//
// Automatically generated by ipdlc.
// Edit at your own risk
//


#include "mozilla/dom/PRemoteWorkerServiceChild.h"
#include "mozilla/ProfilerLabels.h"
#include "mozilla/dom/ClientIPCUtils.h"
#include "mozilla/dom/ReferrerInfoUtils.h"
#include "mozilla/dom/RemoteWorkerServiceChild.h"
#include "mozilla/dom/WorkerIPCUtils.h"
#include "mozilla/ipc/IPCCore.h"
#include "nsID.h"

#include "mozilla/dom/PRemoteWorkerChild.h"
#include "mozilla/dom/PRemoteWorkerNonLifeCycleOpControllerChild.h"

#include "ipc/IPCMessageUtils.h"
#include "ipc/IPCMessageUtilsSpecializations.h"
#include "nsIFile.h"
#include "mozilla/ipc/Endpoint.h"
#include "mozilla/ipc/ProtocolMessageUtils.h"
#include "mozilla/ipc/ProtocolUtils.h"
#include "mozilla/ipc/ShmemMessageUtils.h"
#include "mozilla/ipc/TaintingIPCUtils.h"

namespace mozilla {
namespace dom {


auto PRemoteWorkerServiceChild::RecvPRemoteWorkerConstructor(
        PRemoteWorkerChild* actor,
        const RemoteWorkerData& data,
        Endpoint<::mozilla::dom::PRemoteWorkerNonLifeCycleOpControllerChild>&& childEp) -> mozilla::ipc::IPCResult
{
    return IPC_OK();
}

auto PRemoteWorkerServiceChild::ProcessingError(
        Result aCode,
        const char* aReason) -> void
{
}

auto PRemoteWorkerServiceChild::ShouldContinueFromReplyTimeout() -> bool
{
    return true;
}

MOZ_IMPLICIT PRemoteWorkerServiceChild::PRemoteWorkerServiceChild() :
    mozilla::ipc::IToplevelProtocol("PRemoteWorkerServiceChild", kProtocolId, mozilla::ipc::ChildSide)
{
    MOZ_COUNT_CTOR(PRemoteWorkerServiceChild);
}

PRemoteWorkerServiceChild::~PRemoteWorkerServiceChild()
{
    MOZ_COUNT_DTOR(PRemoteWorkerServiceChild);
}

auto PRemoteWorkerServiceChild::ActorAlloc() -> void
{
    MOZ_RELEASE_ASSERT(XRE_IsParentProcess() || XRE_IsContentProcess(), "Invalid process for `PRemoteWorkerServiceChild'");
    AddRef();
}

auto PRemoteWorkerServiceChild::ActorDealloc() -> void
{
    Release();
}

auto PRemoteWorkerServiceChild::OtherPid() const -> ::base::ProcessId
{
    ::base::ProcessId pid =
        ::mozilla::ipc::IProtocol::ToplevelProtocol()->OtherPidMaybeInvalid();
    MOZ_RELEASE_ASSERT(pid != ::base::kInvalidProcessId);
    return pid;
}

auto PRemoteWorkerServiceChild::OtherChildID() const -> ::GeckoChildID
{
    ::GeckoChildID childID =
        ::mozilla::ipc::IProtocol::ToplevelProtocol()->OtherChildIDMaybeInvalid();
    MOZ_RELEASE_ASSERT(childID != -1);
    return childID;
}

auto PRemoteWorkerServiceChild::OtherEndpointProcInfo() const -> ::mozilla::ipc::EndpointProcInfo
{
    return ::mozilla::ipc::EndpointProcInfo{OtherPid(), OtherChildID()};
}

auto PRemoteWorkerServiceChild::ManagedPRemoteWorkerChild(nsTArray<PRemoteWorkerChild*>& aArr) const -> void
{
    mManagedPRemoteWorkerChild.ToArray(aArr);
}

auto PRemoteWorkerServiceChild::ManagedPRemoteWorkerChild() const -> const ManagedContainer<PRemoteWorkerChild>&
{
    return mManagedPRemoteWorkerChild;
}

auto PRemoteWorkerServiceChild::ManagedProtocolIds() const -> mozilla::Span<mozilla::ipc::ProtocolId const>
{
    static constexpr ::mozilla::ipc::ProtocolId sIds[] = {
        PRemoteWorkerMsgStart
    };
    return sIds;
}

auto PRemoteWorkerServiceChild::GetManagedActors(mozilla::ipc::ProtocolId aProtocol) -> UntypedManagedContainer*
{
    switch (aProtocol) {
    case PRemoteWorkerMsgStart:
        return (&(mManagedPRemoteWorkerChild));
    default:
        return nullptr;
    }
}

auto PRemoteWorkerServiceChild::OpenPRemoteWorkerEndpoint(PRemoteWorkerChild* aActor) -> ManagedEndpoint<PRemoteWorkerParent>
{
    if (!aActor) {
        NS_WARNING("Cannot bind null PRemoteWorkerChild actor");
        return ManagedEndpoint<PRemoteWorkerParent>();
    }

    if (!aActor->SetManagerAndRegister(this)) {
        NS_WARNING("Failed to bind PRemoteWorkerChild actor");
        return ManagedEndpoint<PRemoteWorkerParent>();
    }

    // Mark our actor as awaiting the other side to be bound. This will
    // be cleared when a `MANAGED_ENDPOINT_{DROPPED,BOUND}` message is
    // received.
    aActor->mAwaitingManagedEndpointBind = true;
    return ManagedEndpoint<PRemoteWorkerParent>(mozilla::ipc::PrivateIPDLInterface(), aActor);
}

auto PRemoteWorkerServiceChild::BindPRemoteWorkerEndpoint(
        ManagedEndpoint<PRemoteWorkerChild> aEndpoint,
        PRemoteWorkerChild* aActor) -> bool
{
    return aEndpoint.Bind(mozilla::ipc::PrivateIPDLInterface(), aActor, this);
}

auto PRemoteWorkerServiceChild::DeallocManagee(
        int32_t aProtocolId,
        IProtocol* aListener) -> void
{
    switch (aProtocolId) {
    default:
        FatalError("unreached");
        return;
    }
}

auto PRemoteWorkerServiceChild::OnMessageReceived(const Message& msg__) -> PRemoteWorkerServiceChild::Result
{
    int32_t route__ = msg__.routing_id();
    if (MSG_ROUTING_CONTROL != route__) {
        IProtocol* routed__ = Lookup(route__);
        if (!routed__ || !routed__->GetLifecycleProxy()) {
            if (mozilla::ipc::LoggingEnabledFor("PRemoteWorkerService", mozilla::ipc::ChildSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PRemoteWorkerServiceChild",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Ignored message for dead actor",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eSending);
            }
            return MsgProcessed;

        }

        RefPtr<mozilla::ipc::ActorLifecycleProxy> proxy__ =
            routed__->GetLifecycleProxy();
        return proxy__->Get()->OnMessageReceived(msg__);
    }

    switch (msg__.type()) {
    case PRemoteWorkerService::Msg_PRemoteWorkerConstructor__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PRemoteWorkerService", mozilla::ipc::ChildSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PRemoteWorkerServiceChild",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PRemoteWorkerService::Msg_PRemoteWorkerConstructor", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__handle__ = IPC::ReadParam<ActorHandle>((&(reader__)));
            if (!maybe__handle__) {
                FatalError("Error deserializing 'ActorHandle'");
                return MsgValueError;

            }
            auto& handle__ = *maybe__handle__;
            // Sentinel = 'actor'
            if ((!(((&(reader__)))->ReadSentinel(102892058)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'ActorHandle'");
                return MsgValueError;
            }
            auto maybe__data = IPC::ReadParam<RemoteWorkerData>((&(reader__)));
            if (!maybe__data) {
                FatalError("Error deserializing 'RemoteWorkerData'");
                return MsgValueError;

            }
            auto& data = *maybe__data;
            // Sentinel = 'data'
            if ((!(((&(reader__)))->ReadSentinel(67109275)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'RemoteWorkerData'");
                return MsgValueError;
            }
            auto maybe__childEp = IPC::ReadParam<Endpoint<::mozilla::dom::PRemoteWorkerNonLifeCycleOpControllerChild>>((&(reader__)));
            if (!maybe__childEp) {
                FatalError("Error deserializing 'Endpoint<::mozilla::dom::PRemoteWorkerNonLifeCycleOpControllerChild>'");
                return MsgValueError;

            }
            auto& childEp = *maybe__childEp;
            // Sentinel = 'childEp'
            if ((!(((&(reader__)))->ReadSentinel(185533114)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'Endpoint<::mozilla::dom::PRemoteWorkerNonLifeCycleOpControllerChild>'");
                return MsgValueError;
            }
            reader__.EndRead();
            RefPtr<PRemoteWorkerChild> actor = (static_cast<RemoteWorkerServiceChild*>(this))->AllocPRemoteWorkerChild(data, childEp);
            if (!actor) {
                NS_WARNING("Cannot bind null PRemoteWorkerChild actor");
                return MsgValueError;
            }

            if (!actor->SetManagerAndRegister(this, (handle__).mId)) {
                NS_WARNING("Failed to bind PRemoteWorkerChild actor");
                return MsgValueError;
            }

            mozilla::ipc::IPCResult __ok = (static_cast<RemoteWorkerServiceChild*>(this))->RecvPRemoteWorkerConstructor(actor, std::move(data), std::move(childEp));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    default:
        return MsgNotKnown;
    case SHMEM_CREATED_MESSAGE_TYPE:
        {
            if (!ShmemCreated(msg__)) {
                return MsgPayloadError;
            }
            return MsgProcessed;
        }
    case SHMEM_DESTROYED_MESSAGE_TYPE:
        {
            if (!ShmemDestroyed(msg__)) {
                return MsgPayloadError;
            }
            return MsgProcessed;
        }
    }
}

auto PRemoteWorkerServiceChild::OnMessageReceived(
        const Message& msg__,
        UniquePtr<Message>& reply__) -> PRemoteWorkerServiceChild::Result
{
    MOZ_ASSERT_UNREACHABLE("message protocol not supported");
    return MsgNotKnown;
}



} // namespace dom
} // namespace mozilla
namespace IPC {
auto ParamTraits<::mozilla::dom::PRemoteWorkerServiceChild*>::Write(
        IPC::MessageWriter* aWriter,
        const paramType& aVar) -> void
{
    MOZ_RELEASE_ASSERT(
        aWriter->GetActor(),
        "Cannot serialize managed actors without an actor");

    int32_t id;
    if (!aVar) {
        id = 0;  // kNullActorId
    } else {
        id = aVar->Id();
        if (id == 1) {  // kFreedActorId
            aVar->FatalError("Actor has been |delete|d");
        }
        MOZ_RELEASE_ASSERT(
            aWriter->GetActor()->GetIPCChannel() == aVar->GetIPCChannel(),
            "Actor must be from the same channel as the"
            " actor it's being sent over");
        MOZ_RELEASE_ASSERT(
            aVar->CanSend(),
            "Actor must still be open when sending");
    }

    IPC::WriteParam(aWriter, id);
}

auto ParamTraits<::mozilla::dom::PRemoteWorkerServiceChild*>::Read(IPC::MessageReader* aReader) -> IPC::ReadResult<paramType>
{
    MOZ_RELEASE_ASSERT(
        aReader->GetActor(),
        "Cannot deserialize managed actors without an actor");
    mozilla::Maybe<mozilla::ipc::IProtocol*> actor = aReader->GetActor()
        ->ReadActor(aReader, true, "PRemoteWorkerService", PRemoteWorkerServiceMsgStart);
    if (actor.isSome()) {
        return static_cast<::mozilla::dom::PRemoteWorkerServiceChild*>(actor.ref());
    }
    return {};
}

} // namespace IPC
