//
// Automatically generated by ipdlc.
// Edit at your own risk
//


#include "mozilla/dom/PRemoteWorkerControllerParent.h"
#include "mozilla/ProfilerLabels.h"
#include "mozilla/dom/ClientIPCUtils.h"
#include "mozilla/dom/ReferrerInfoUtils.h"
#include "mozilla/dom/RemoteWorkerControllerParent.h"
#include "mozilla/dom/ServiceWorkerIPCUtils.h"
#include "mozilla/dom/WorkerIPCUtils.h"
#include "mozilla/ipc/IPCCore.h"

#include "mozilla/ipc/PBackgroundParent.h"
#include "mozilla/dom/PFetchEventOpParent.h"

#include "ipc/IPCMessageUtils.h"
#include "ipc/IPCMessageUtilsSpecializations.h"
#include "nsIFile.h"
#include "mozilla/ipc/Endpoint.h"
#include "mozilla/ipc/ProtocolMessageUtils.h"
#include "mozilla/ipc/ProtocolUtils.h"
#include "mozilla/ipc/ShmemMessageUtils.h"
#include "mozilla/ipc/TaintingIPCUtils.h"

namespace mozilla {
namespace dom {


auto PRemoteWorkerControllerParent::RecvPFetchEventOpConstructor(
        PFetchEventOpParent* actor,
        const ParentToParentServiceWorkerFetchEventOpArgs& aArgs) -> mozilla::ipc::IPCResult
{
    return IPC_OK();
}

auto PRemoteWorkerControllerParent::Recv__delete__() -> mozilla::ipc::IPCResult
{
    return IPC_OK();
}

MOZ_IMPLICIT PRemoteWorkerControllerParent::PRemoteWorkerControllerParent() :
    mozilla::ipc::IRefCountedProtocol(kProtocolId, mozilla::ipc::ParentSide)
{
    MOZ_COUNT_CTOR(PRemoteWorkerControllerParent);
}

PRemoteWorkerControllerParent::~PRemoteWorkerControllerParent()
{
    MOZ_COUNT_DTOR(PRemoteWorkerControllerParent);
}

auto PRemoteWorkerControllerParent::ActorAlloc() -> void
{
    AddRef();
}

auto PRemoteWorkerControllerParent::ActorDealloc() -> void
{
    Release();
}

auto PRemoteWorkerControllerParent::OtherPid() const -> ::base::ProcessId
{
    ::base::ProcessId pid =
        ::mozilla::ipc::IProtocol::ToplevelProtocol()->OtherPidMaybeInvalid();
    MOZ_RELEASE_ASSERT(pid != ::base::kInvalidProcessId);
    return pid;
}

auto PRemoteWorkerControllerParent::OtherChildID() const -> ::GeckoChildID
{
    ::GeckoChildID childID =
        ::mozilla::ipc::IProtocol::ToplevelProtocol()->OtherChildIDMaybeInvalid();
    MOZ_RELEASE_ASSERT(childID != -1);
    return childID;
}

auto PRemoteWorkerControllerParent::OtherEndpointProcInfo() const -> ::mozilla::ipc::EndpointProcInfo
{
    return ::mozilla::ipc::EndpointProcInfo{OtherPid(), OtherChildID()};
}

auto PRemoteWorkerControllerParent::Manager() const -> PBackgroundParent*
{
    return static_cast<PBackgroundParent*>(IProtocol::Manager());
}

auto PRemoteWorkerControllerParent::ManagedPFetchEventOpParent(nsTArray<PFetchEventOpParent*>& aArr) const -> void
{
    mManagedPFetchEventOpParent.ToArray(aArr);
}

auto PRemoteWorkerControllerParent::ManagedPFetchEventOpParent() const -> const ManagedContainer<PFetchEventOpParent>&
{
    return mManagedPFetchEventOpParent;
}

auto PRemoteWorkerControllerParent::ManagedProtocolIds() const -> mozilla::Span<mozilla::ipc::ProtocolId const>
{
    static constexpr ::mozilla::ipc::ProtocolId sIds[] = {
        PFetchEventOpMsgStart
    };
    return sIds;
}

auto PRemoteWorkerControllerParent::GetManagedActors(mozilla::ipc::ProtocolId aProtocol) -> UntypedManagedContainer*
{
    switch (aProtocol) {
    case PFetchEventOpMsgStart:
        return (&(mManagedPFetchEventOpParent));
    default:
        return nullptr;
    }
}

auto PRemoteWorkerControllerParent::RejectPendingResponses(ResponseRejectReason aReason) -> void
{
    mAsyncCallbacks.RejectPendingResponses(aReason);
}

auto PRemoteWorkerControllerParent::OpenPFetchEventOpEndpoint(PFetchEventOpParent* aActor) -> ManagedEndpoint<PFetchEventOpChild>
{
    if (!aActor) {
        NS_WARNING("Cannot bind null PFetchEventOpParent actor");
        return ManagedEndpoint<PFetchEventOpChild>();
    }

    if (!aActor->SetManagerAndRegister(this)) {
        NS_WARNING("Failed to bind PFetchEventOpParent actor");
        return ManagedEndpoint<PFetchEventOpChild>();
    }

    // Mark our actor as awaiting the other side to be bound. This will
    // be cleared when a `MANAGED_ENDPOINT_{DROPPED,BOUND}` message is
    // received.
    aActor->mAwaitingManagedEndpointBind = true;
    return ManagedEndpoint<PFetchEventOpChild>(mozilla::ipc::PrivateIPDLInterface(), aActor);
}

auto PRemoteWorkerControllerParent::BindPFetchEventOpEndpoint(
        ManagedEndpoint<PFetchEventOpParent> aEndpoint,
        PFetchEventOpParent* aActor) -> bool
{
    return aEndpoint.Bind(mozilla::ipc::PrivateIPDLInterface(), aActor, this);
}

auto PRemoteWorkerControllerParent::SendCreationFailed() -> bool
{
    UniquePtr<IPC::Message> msg__ = PRemoteWorkerController::Msg_CreationFailed(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};





    if (mozilla::ipc::LoggingEnabledFor("PRemoteWorkerController", mozilla::ipc::ParentSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PRemoteWorkerControllerParent",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PRemoteWorkerController::Msg_CreationFailed", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PRemoteWorkerControllerParent::SendCreationSucceeded() -> bool
{
    UniquePtr<IPC::Message> msg__ = PRemoteWorkerController::Msg_CreationSucceeded(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};





    if (mozilla::ipc::LoggingEnabledFor("PRemoteWorkerController", mozilla::ipc::ParentSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PRemoteWorkerControllerParent",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PRemoteWorkerController::Msg_CreationSucceeded", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PRemoteWorkerControllerParent::SendErrorReceived(const ErrorValue& aError) -> bool
{
    UniquePtr<IPC::Message> msg__ = PRemoteWorkerController::Msg_ErrorReceived(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), aError);
    // Sentinel = 'aError'
    ((&(writer__)))->WriteSentinel(135463532);




    if (mozilla::ipc::LoggingEnabledFor("PRemoteWorkerController", mozilla::ipc::ParentSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PRemoteWorkerControllerParent",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PRemoteWorkerController::Msg_ErrorReceived", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PRemoteWorkerControllerParent::SendTerminated() -> bool
{
    UniquePtr<IPC::Message> msg__ = PRemoteWorkerController::Msg_Terminated(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};





    if (mozilla::ipc::LoggingEnabledFor("PRemoteWorkerController", mozilla::ipc::ParentSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PRemoteWorkerControllerParent",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PRemoteWorkerController::Msg_Terminated", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PRemoteWorkerControllerParent::SendSetServiceWorkerSkipWaitingFlag(
        mozilla::ipc::ResolveCallback<bool>&& aResolve,
        mozilla::ipc::RejectCallback&& aReject) -> void
{
    UniquePtr<IPC::Message> msg__ = PRemoteWorkerController::Msg_SetServiceWorkerSkipWaitingFlag(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};





    if (mozilla::ipc::LoggingEnabledFor("PRemoteWorkerController", mozilla::ipc::ParentSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PRemoteWorkerControllerParent",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PRemoteWorkerController::Msg_SetServiceWorkerSkipWaitingFlag", OTHER);

    int32_t seqno__ = 0;
    if (ChannelSend(std::move(msg__), (&(seqno__)))) {
        mAsyncCallbacks.AddCallback(seqno__, PRemoteWorkerController::Reply_SetServiceWorkerSkipWaitingFlag__ID, [resolve=std::move(aResolve)](IPC::MessageReader* aReader) mutable {
            auto maybe__aOk = IPC::ReadParam<bool>(aReader);
            if (!maybe__aOk) {
                (aReader)->FatalError("Error deserializing 'bool'");
                return MsgValueError;

            }
            auto& aOk = *maybe__aOk;
            // Sentinel = 'aOk'
            if ((!((aReader)->ReadSentinel(36634908)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'bool'");
                return MsgValueError;
            }


            aReader->EndRead();

            resolve(std::move(aOk));
            return MsgProcessed;
        }, std::move(aReject));
    }
    else {
        aReject(::mozilla::ipc::ResponseRejectReason::SendError);
    }
    return;
}

auto PRemoteWorkerControllerParent::SendSetServiceWorkerSkipWaitingFlag() -> RefPtr<SetServiceWorkerSkipWaitingFlagPromise>
{
    RefPtr<MozPromise<bool, ResponseRejectReason, true>::Private> promise__ = new MozPromise<bool, ResponseRejectReason, true>::Private(__func__);
    promise__->UseDirectTaskDispatch(__func__);
    SendSetServiceWorkerSkipWaitingFlag([promise__](bool&& aValue) {
        promise__->Resolve(std::move(aValue), __func__);
    }, [promise__](ResponseRejectReason&& aReason) {
        promise__->Reject(std::move(aReason), __func__);
    });
    return promise__;
}

auto PRemoteWorkerControllerParent::DeallocManagee(
        int32_t aProtocolId,
        IProtocol* aListener) -> void
{
    switch (aProtocolId) {
    case PFetchEventOpMsgStart:
        static_cast<RemoteWorkerControllerParent*>(this)->DeallocPFetchEventOpParent(static_cast<PFetchEventOpParent*>(aListener));
        return;
    default:
        FatalError("unreached");
        return;
    }
}

auto PRemoteWorkerControllerParent::OnMessageReceived(const Message& msg__) -> PRemoteWorkerControllerParent::Result
{
    switch (msg__.type()) {
    case MANAGED_ENDPOINT_BOUND_MESSAGE_TYPE:
        {
            if (!mAwaitingManagedEndpointBind) {
                NS_WARNING("Unexpected managed endpoint lifecycle message after actor bound!");
                return MsgNotAllowed;
            }
            mAwaitingManagedEndpointBind = false;
            return MsgProcessed;
        }
    case MANAGED_ENDPOINT_DROPPED_MESSAGE_TYPE:
        {
            if (!mAwaitingManagedEndpointBind) {
                NS_WARNING("Unexpected managed endpoint lifecycle message after actor bound!");
                return MsgNotAllowed;
            }
            mAwaitingManagedEndpointBind = false;
            this->ActorDisconnected(ManagedEndpointDropped);
            return MsgProcessed;
        }
    case PRemoteWorkerController::Reply_SetServiceWorkerSkipWaitingFlag__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PRemoteWorkerController", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PRemoteWorkerControllerParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }

            AUTO_PROFILER_LABEL("PRemoteWorkerController::Msg_SetServiceWorkerSkipWaitingFlag", OTHER);


            return mAsyncCallbacks.GotReply(this, msg__);
        }
    case PRemoteWorkerController::Msg_PFetchEventOpConstructor__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PRemoteWorkerController", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PRemoteWorkerControllerParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PRemoteWorkerController::Msg_PFetchEventOpConstructor", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__handle__ = IPC::ReadParam<ActorHandle>((&(reader__)));
            if (!maybe__handle__) {
                FatalError("Error deserializing 'ActorHandle'");
                return MsgValueError;

            }
            auto& handle__ = *maybe__handle__;
            // Sentinel = 'actor'
            if ((!(((&(reader__)))->ReadSentinel(102892058)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'ActorHandle'");
                return MsgValueError;
            }
            auto maybe__aArgs = IPC::ReadParam<ParentToParentServiceWorkerFetchEventOpArgs>((&(reader__)));
            if (!maybe__aArgs) {
                FatalError("Error deserializing 'ParentToParentServiceWorkerFetchEventOpArgs'");
                return MsgValueError;

            }
            auto& aArgs = *maybe__aArgs;
            // Sentinel = 'aArgs'
            if ((!(((&(reader__)))->ReadSentinel(92602863)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'ParentToParentServiceWorkerFetchEventOpArgs'");
                return MsgValueError;
            }
            reader__.EndRead();
            PFetchEventOpParent* actor = (static_cast<RemoteWorkerControllerParent*>(this))->AllocPFetchEventOpParent(aArgs);
            if (!actor) {
                NS_WARNING("Cannot bind null PFetchEventOpParent actor");
                return MsgValueError;
            }

            if (!actor->SetManagerAndRegister(this, (handle__).mId)) {
                NS_WARNING("Failed to bind PFetchEventOpParent actor");
                return MsgValueError;
            }

            mozilla::ipc::IPCResult __ok = (static_cast<RemoteWorkerControllerParent*>(this))->RecvPFetchEventOpConstructor(std::move(actor), std::move(aArgs));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PRemoteWorkerController::Msg___delete____ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PRemoteWorkerController", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PRemoteWorkerControllerParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PRemoteWorkerController::Msg___delete__", OTHER);

            mozilla::ipc::IPCResult __ok = (static_cast<RemoteWorkerControllerParent*>(this))->Recv__delete__();
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }


            this->ActorDisconnected(Deletion);

            return MsgProcessed;
        }
    case PRemoteWorkerController::Msg_Shutdown__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PRemoteWorkerController", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PRemoteWorkerControllerParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PRemoteWorkerController::Msg_Shutdown", OTHER);

            int32_t id__ = Id();
            UniquePtr<IPC::Message> reply__(PRemoteWorkerController::Reply_Shutdown(id__));
            reply__->set_seqno(msg__.seqno());

            RefPtr<mozilla::ipc::IPDLResolverInner> resolver__ =
                new mozilla::ipc::IPDLResolverInner(std::move(reply__), this);

            ShutdownResolver resolver = [resolver__ = std::move(resolver__)](const bool& aParam) {
                resolver__->Resolve([&] (IPC::Message* reply__, IProtocol* self__) {
                    IPC::MessageWriter writer__(*reply__, self__);
                    IPC::WriteParam((&(writer__)), aParam);
                    // Sentinel = 'aOk'
                    ((&(writer__)))->WriteSentinel(36634908);

                    if (mozilla::ipc::LoggingEnabledFor("PRemoteWorkerController", mozilla::ipc::ParentSide)) {
                        mozilla::ipc::LogMessageForProtocol(
                            "PRemoteWorkerControllerParent",
                            self__->ToplevelProtocol()->OtherPidMaybeInvalid(),
                            "Sending reply ",
                            reply__->type(),
                            mozilla::ipc::MessageDirection::eSending);
                    }

                });
            };
            mozilla::ipc::IPCResult __ok = (static_cast<RemoteWorkerControllerParent*>(this))->RecvShutdown(std::move(resolver));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PRemoteWorkerController::Msg_ExecServiceWorkerOp__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PRemoteWorkerController", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PRemoteWorkerControllerParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PRemoteWorkerController::Msg_ExecServiceWorkerOp", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__aArgs = IPC::ReadParam<ServiceWorkerOpArgs>((&(reader__)));
            if (!maybe__aArgs) {
                FatalError("Error deserializing 'ServiceWorkerOpArgs'");
                return MsgValueError;

            }
            auto& aArgs = *maybe__aArgs;
            // Sentinel = 'aArgs'
            if ((!(((&(reader__)))->ReadSentinel(92602863)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'ServiceWorkerOpArgs'");
                return MsgValueError;
            }
            reader__.EndRead();
            int32_t id__ = Id();
            UniquePtr<IPC::Message> reply__(PRemoteWorkerController::Reply_ExecServiceWorkerOp(id__));
            reply__->set_seqno(msg__.seqno());

            RefPtr<mozilla::ipc::IPDLResolverInner> resolver__ =
                new mozilla::ipc::IPDLResolverInner(std::move(reply__), this);

            ExecServiceWorkerOpResolver resolver = [resolver__ = std::move(resolver__)](const ServiceWorkerOpResult& aParam) {
                resolver__->Resolve([&] (IPC::Message* reply__, IProtocol* self__) {
                    IPC::MessageWriter writer__(*reply__, self__);
                    IPC::WriteParam((&(writer__)), aParam);
                    // Sentinel = 'aResult'
                    ((&(writer__)))->WriteSentinel(185205473);

                    if (mozilla::ipc::LoggingEnabledFor("PRemoteWorkerController", mozilla::ipc::ParentSide)) {
                        mozilla::ipc::LogMessageForProtocol(
                            "PRemoteWorkerControllerParent",
                            self__->ToplevelProtocol()->OtherPidMaybeInvalid(),
                            "Sending reply ",
                            reply__->type(),
                            mozilla::ipc::MessageDirection::eSending);
                    }

                });
            };
            mozilla::ipc::IPCResult __ok = (static_cast<RemoteWorkerControllerParent*>(this))->RecvExecServiceWorkerOp(std::move(aArgs), std::move(resolver));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    default:
        return MsgNotKnown;
    }
}

auto PRemoteWorkerControllerParent::OnMessageReceived(
        const Message& msg__,
        UniquePtr<Message>& reply__) -> PRemoteWorkerControllerParent::Result
{
    return MsgNotKnown;
}



} // namespace dom
} // namespace mozilla
namespace IPC {
auto ParamTraits<::mozilla::dom::PRemoteWorkerControllerParent*>::Write(
        IPC::MessageWriter* aWriter,
        const paramType& aVar) -> void
{
    MOZ_RELEASE_ASSERT(
        aWriter->GetActor(),
        "Cannot serialize managed actors without an actor");

    int32_t id;
    if (!aVar) {
        id = 0;  // kNullActorId
    } else {
        id = aVar->Id();
        if (id == 1) {  // kFreedActorId
            aVar->FatalError("Actor has been |delete|d");
        }
        MOZ_RELEASE_ASSERT(
            aWriter->GetActor()->GetIPCChannel() == aVar->GetIPCChannel(),
            "Actor must be from the same channel as the"
            " actor it's being sent over");
        MOZ_RELEASE_ASSERT(
            aVar->CanSend(),
            "Actor must still be open when sending");
    }

    IPC::WriteParam(aWriter, id);
}

auto ParamTraits<::mozilla::dom::PRemoteWorkerControllerParent*>::Read(IPC::MessageReader* aReader) -> IPC::ReadResult<paramType>
{
    MOZ_RELEASE_ASSERT(
        aReader->GetActor(),
        "Cannot deserialize managed actors without an actor");
    mozilla::Maybe<mozilla::ipc::IProtocol*> actor = aReader->GetActor()
        ->ReadActor(aReader, true, "PRemoteWorkerController", PRemoteWorkerControllerMsgStart);
    if (actor.isSome()) {
        return static_cast<::mozilla::dom::PRemoteWorkerControllerParent*>(actor.ref());
    }
    return {};
}

} // namespace IPC
