//
// Automatically generated by ipdlc.
// Edit at your own risk
//


#include "mozilla/dom/PRemoteWorkerChild.h"
#include "mozilla/ProfilerLabels.h"
#include "mozilla/dom/ClientIPCUtils.h"
#include "mozilla/dom/ReferrerInfoUtils.h"
#include "mozilla/dom/RemoteWorkerChild.h"
#include "mozilla/dom/ServiceWorkerIPCUtils.h"
#include "mozilla/dom/WorkerIPCUtils.h"
#include "mozilla/ipc/IPCCore.h"

#include "mozilla/dom/PFetchEventOpProxyChild.h"
#include "mozilla/dom/PRemoteWorkerServiceChild.h"

#include "ipc/IPCMessageUtils.h"
#include "ipc/IPCMessageUtilsSpecializations.h"
#include "nsIFile.h"
#include "mozilla/ipc/Endpoint.h"
#include "mozilla/ipc/ProtocolMessageUtils.h"
#include "mozilla/ipc/ProtocolUtils.h"
#include "mozilla/ipc/ShmemMessageUtils.h"
#include "mozilla/ipc/TaintingIPCUtils.h"

namespace mozilla {
namespace dom {


auto PRemoteWorkerChild::RecvPFetchEventOpProxyConstructor(
        PFetchEventOpProxyChild* actor,
        const ParentToChildServiceWorkerFetchEventOpArgs& aArgs) -> mozilla::ipc::IPCResult
{
    return IPC_OK();
}

auto PRemoteWorkerChild::Recv__delete__() -> mozilla::ipc::IPCResult
{
    return IPC_OK();
}

MOZ_IMPLICIT PRemoteWorkerChild::PRemoteWorkerChild() :
    mozilla::ipc::IRefCountedProtocol(kProtocolId, mozilla::ipc::ChildSide)
{
    MOZ_COUNT_CTOR(PRemoteWorkerChild);
}

PRemoteWorkerChild::~PRemoteWorkerChild()
{
    MOZ_COUNT_DTOR(PRemoteWorkerChild);
}

auto PRemoteWorkerChild::ActorAlloc() -> void
{
    AddRef();
}

auto PRemoteWorkerChild::ActorDealloc() -> void
{
    Release();
}

auto PRemoteWorkerChild::OtherPid() const -> ::base::ProcessId
{
    ::base::ProcessId pid =
        ::mozilla::ipc::IProtocol::ToplevelProtocol()->OtherPidMaybeInvalid();
    MOZ_RELEASE_ASSERT(pid != ::base::kInvalidProcessId);
    return pid;
}

auto PRemoteWorkerChild::OtherChildID() const -> ::GeckoChildID
{
    ::GeckoChildID childID =
        ::mozilla::ipc::IProtocol::ToplevelProtocol()->OtherChildIDMaybeInvalid();
    MOZ_RELEASE_ASSERT(childID != -1);
    return childID;
}

auto PRemoteWorkerChild::OtherEndpointProcInfo() const -> ::mozilla::ipc::EndpointProcInfo
{
    return ::mozilla::ipc::EndpointProcInfo{OtherPid(), OtherChildID()};
}

auto PRemoteWorkerChild::Manager() const -> PRemoteWorkerServiceChild*
{
    return static_cast<PRemoteWorkerServiceChild*>(IProtocol::Manager());
}

auto PRemoteWorkerChild::ManagedPFetchEventOpProxyChild(nsTArray<PFetchEventOpProxyChild*>& aArr) const -> void
{
    mManagedPFetchEventOpProxyChild.ToArray(aArr);
}

auto PRemoteWorkerChild::ManagedPFetchEventOpProxyChild() const -> const ManagedContainer<PFetchEventOpProxyChild>&
{
    return mManagedPFetchEventOpProxyChild;
}

auto PRemoteWorkerChild::ManagedProtocolIds() const -> mozilla::Span<mozilla::ipc::ProtocolId const>
{
    static constexpr ::mozilla::ipc::ProtocolId sIds[] = {
        PFetchEventOpProxyMsgStart
    };
    return sIds;
}

auto PRemoteWorkerChild::GetManagedActors(mozilla::ipc::ProtocolId aProtocol) -> UntypedManagedContainer*
{
    switch (aProtocol) {
    case PFetchEventOpProxyMsgStart:
        return (&(mManagedPFetchEventOpProxyChild));
    default:
        return nullptr;
    }
}

auto PRemoteWorkerChild::RejectPendingResponses(ResponseRejectReason aReason) -> void
{
    mAsyncCallbacks.RejectPendingResponses(aReason);
}

auto PRemoteWorkerChild::OpenPFetchEventOpProxyEndpoint(PFetchEventOpProxyChild* aActor) -> ManagedEndpoint<PFetchEventOpProxyParent>
{
    if (!aActor) {
        NS_WARNING("Cannot bind null PFetchEventOpProxyChild actor");
        return ManagedEndpoint<PFetchEventOpProxyParent>();
    }

    if (!aActor->SetManagerAndRegister(this)) {
        NS_WARNING("Failed to bind PFetchEventOpProxyChild actor");
        return ManagedEndpoint<PFetchEventOpProxyParent>();
    }

    // Mark our actor as awaiting the other side to be bound. This will
    // be cleared when a `MANAGED_ENDPOINT_{DROPPED,BOUND}` message is
    // received.
    aActor->mAwaitingManagedEndpointBind = true;
    return ManagedEndpoint<PFetchEventOpProxyParent>(mozilla::ipc::PrivateIPDLInterface(), aActor);
}

auto PRemoteWorkerChild::BindPFetchEventOpProxyEndpoint(
        ManagedEndpoint<PFetchEventOpProxyChild> aEndpoint,
        PFetchEventOpProxyChild* aActor) -> bool
{
    return aEndpoint.Bind(mozilla::ipc::PrivateIPDLInterface(), aActor, this);
}

auto PRemoteWorkerChild::SendCreated(const bool& aStatus) -> bool
{
    UniquePtr<IPC::Message> msg__ = PRemoteWorker::Msg_Created(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), aStatus);
    // Sentinel = 'aStatus'
    ((&(writer__)))->WriteSentinel(186712806);




    if (mozilla::ipc::LoggingEnabledFor("PRemoteWorker", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PRemoteWorkerChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PRemoteWorker::Msg_Created", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PRemoteWorkerChild::SendError(const ErrorValue& aValue) -> bool
{
    UniquePtr<IPC::Message> msg__ = PRemoteWorker::Msg_Error(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), aValue);
    // Sentinel = 'aValue'
    ((&(writer__)))->WriteSentinel(135332447);




    if (mozilla::ipc::LoggingEnabledFor("PRemoteWorker", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PRemoteWorkerChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PRemoteWorker::Msg_Error", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PRemoteWorkerChild::SendNotifyLock(const bool& aCreated) -> bool
{
    UniquePtr<IPC::Message> msg__ = PRemoteWorker::Msg_NotifyLock(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), aCreated);
    // Sentinel = 'aCreated'
    ((&(writer__)))->WriteSentinel(228066074);




    if (mozilla::ipc::LoggingEnabledFor("PRemoteWorker", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PRemoteWorkerChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PRemoteWorker::Msg_NotifyLock", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PRemoteWorkerChild::SendNotifyWebTransport(const bool& aCreated) -> bool
{
    UniquePtr<IPC::Message> msg__ = PRemoteWorker::Msg_NotifyWebTransport(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), aCreated);
    // Sentinel = 'aCreated'
    ((&(writer__)))->WriteSentinel(228066074);




    if (mozilla::ipc::LoggingEnabledFor("PRemoteWorker", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PRemoteWorkerChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PRemoteWorker::Msg_NotifyWebTransport", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PRemoteWorkerChild::SendClose() -> bool
{
    UniquePtr<IPC::Message> msg__ = PRemoteWorker::Msg_Close(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};





    if (mozilla::ipc::LoggingEnabledFor("PRemoteWorker", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PRemoteWorkerChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PRemoteWorker::Msg_Close", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PRemoteWorkerChild::SendSetServiceWorkerSkipWaitingFlag(
        mozilla::ipc::ResolveCallback<bool>&& aResolve,
        mozilla::ipc::RejectCallback&& aReject) -> void
{
    UniquePtr<IPC::Message> msg__ = PRemoteWorker::Msg_SetServiceWorkerSkipWaitingFlag(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};





    if (mozilla::ipc::LoggingEnabledFor("PRemoteWorker", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PRemoteWorkerChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PRemoteWorker::Msg_SetServiceWorkerSkipWaitingFlag", OTHER);

    int32_t seqno__ = 0;
    if (ChannelSend(std::move(msg__), (&(seqno__)))) {
        mAsyncCallbacks.AddCallback(seqno__, PRemoteWorker::Reply_SetServiceWorkerSkipWaitingFlag__ID, [resolve=std::move(aResolve)](IPC::MessageReader* aReader) mutable {
            auto maybe__aOk = IPC::ReadParam<bool>(aReader);
            if (!maybe__aOk) {
                (aReader)->FatalError("Error deserializing 'bool'");
                return MsgValueError;

            }
            auto& aOk = *maybe__aOk;
            // Sentinel = 'aOk'
            if ((!((aReader)->ReadSentinel(36634908)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'bool'");
                return MsgValueError;
            }


            aReader->EndRead();

            resolve(std::move(aOk));
            return MsgProcessed;
        }, std::move(aReject));
    }
    else {
        aReject(::mozilla::ipc::ResponseRejectReason::SendError);
    }
    return;
}

auto PRemoteWorkerChild::SendSetServiceWorkerSkipWaitingFlag() -> RefPtr<SetServiceWorkerSkipWaitingFlagPromise>
{
    RefPtr<MozPromise<bool, ResponseRejectReason, true>::Private> promise__ = new MozPromise<bool, ResponseRejectReason, true>::Private(__func__);
    promise__->UseDirectTaskDispatch(__func__);
    SendSetServiceWorkerSkipWaitingFlag([promise__](bool&& aValue) {
        promise__->Resolve(std::move(aValue), __func__);
    }, [promise__](ResponseRejectReason&& aReason) {
        promise__->Reject(std::move(aReason), __func__);
    });
    return promise__;
}

auto PRemoteWorkerChild::DeallocManagee(
        int32_t aProtocolId,
        IProtocol* aListener) -> void
{
    switch (aProtocolId) {
    default:
        FatalError("unreached");
        return;
    }
}

auto PRemoteWorkerChild::OnMessageReceived(const Message& msg__) -> PRemoteWorkerChild::Result
{
    switch (msg__.type()) {
    case MANAGED_ENDPOINT_BOUND_MESSAGE_TYPE:
        {
            if (!mAwaitingManagedEndpointBind) {
                NS_WARNING("Unexpected managed endpoint lifecycle message after actor bound!");
                return MsgNotAllowed;
            }
            mAwaitingManagedEndpointBind = false;
            return MsgProcessed;
        }
    case MANAGED_ENDPOINT_DROPPED_MESSAGE_TYPE:
        {
            if (!mAwaitingManagedEndpointBind) {
                NS_WARNING("Unexpected managed endpoint lifecycle message after actor bound!");
                return MsgNotAllowed;
            }
            mAwaitingManagedEndpointBind = false;
            this->ActorDisconnected(ManagedEndpointDropped);
            return MsgProcessed;
        }
    case PRemoteWorker::Reply_SetServiceWorkerSkipWaitingFlag__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PRemoteWorker", mozilla::ipc::ChildSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PRemoteWorkerChild",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }

            AUTO_PROFILER_LABEL("PRemoteWorker::Msg_SetServiceWorkerSkipWaitingFlag", OTHER);


            return mAsyncCallbacks.GotReply(this, msg__);
        }
    case PRemoteWorker::Msg_PFetchEventOpProxyConstructor__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PRemoteWorker", mozilla::ipc::ChildSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PRemoteWorkerChild",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PRemoteWorker::Msg_PFetchEventOpProxyConstructor", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__handle__ = IPC::ReadParam<ActorHandle>((&(reader__)));
            if (!maybe__handle__) {
                FatalError("Error deserializing 'ActorHandle'");
                return MsgValueError;

            }
            auto& handle__ = *maybe__handle__;
            // Sentinel = 'actor'
            if ((!(((&(reader__)))->ReadSentinel(102892058)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'ActorHandle'");
                return MsgValueError;
            }
            auto maybe__aArgs = IPC::ReadParam<ParentToChildServiceWorkerFetchEventOpArgs>((&(reader__)));
            if (!maybe__aArgs) {
                FatalError("Error deserializing 'ParentToChildServiceWorkerFetchEventOpArgs'");
                return MsgValueError;

            }
            auto& aArgs = *maybe__aArgs;
            // Sentinel = 'aArgs'
            if ((!(((&(reader__)))->ReadSentinel(92602863)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'ParentToChildServiceWorkerFetchEventOpArgs'");
                return MsgValueError;
            }
            reader__.EndRead();
            RefPtr<PFetchEventOpProxyChild> actor = (static_cast<RemoteWorkerChild*>(this))->AllocPFetchEventOpProxyChild(aArgs);
            if (!actor) {
                NS_WARNING("Cannot bind null PFetchEventOpProxyChild actor");
                return MsgValueError;
            }

            if (!actor->SetManagerAndRegister(this, (handle__).mId)) {
                NS_WARNING("Failed to bind PFetchEventOpProxyChild actor");
                return MsgValueError;
            }

            mozilla::ipc::IPCResult __ok = (static_cast<RemoteWorkerChild*>(this))->RecvPFetchEventOpProxyConstructor(actor, std::move(aArgs));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PRemoteWorker::Msg___delete____ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PRemoteWorker", mozilla::ipc::ChildSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PRemoteWorkerChild",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PRemoteWorker::Msg___delete__", OTHER);

            mozilla::ipc::IPCResult __ok = (static_cast<RemoteWorkerChild*>(this))->Recv__delete__();
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }


            this->ActorDisconnected(Deletion);

            return MsgProcessed;
        }
    case PRemoteWorker::Msg_ExecOp__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PRemoteWorker", mozilla::ipc::ChildSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PRemoteWorkerChild",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PRemoteWorker::Msg_ExecOp", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__aArgs = IPC::ReadParam<SharedWorkerOpArgs>((&(reader__)));
            if (!maybe__aArgs) {
                FatalError("Error deserializing 'SharedWorkerOpArgs'");
                return MsgValueError;

            }
            auto& aArgs = *maybe__aArgs;
            // Sentinel = 'aArgs'
            if ((!(((&(reader__)))->ReadSentinel(92602863)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'SharedWorkerOpArgs'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::IPCResult __ok = (static_cast<RemoteWorkerChild*>(this))->RecvExecOp(std::move(aArgs));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PRemoteWorker::Msg_ExecServiceWorkerOp__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PRemoteWorker", mozilla::ipc::ChildSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PRemoteWorkerChild",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PRemoteWorker::Msg_ExecServiceWorkerOp", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__aArgs = IPC::ReadParam<ServiceWorkerOpArgs>((&(reader__)));
            if (!maybe__aArgs) {
                FatalError("Error deserializing 'ServiceWorkerOpArgs'");
                return MsgValueError;

            }
            auto& aArgs = *maybe__aArgs;
            // Sentinel = 'aArgs'
            if ((!(((&(reader__)))->ReadSentinel(92602863)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'ServiceWorkerOpArgs'");
                return MsgValueError;
            }
            reader__.EndRead();
            int32_t id__ = Id();
            UniquePtr<IPC::Message> reply__(PRemoteWorker::Reply_ExecServiceWorkerOp(id__));
            reply__->set_seqno(msg__.seqno());

            RefPtr<mozilla::ipc::IPDLResolverInner> resolver__ =
                new mozilla::ipc::IPDLResolverInner(std::move(reply__), this);

            ExecServiceWorkerOpResolver resolver = [resolver__ = std::move(resolver__)](const ServiceWorkerOpResult& aParam) {
                resolver__->Resolve([&] (IPC::Message* reply__, IProtocol* self__) {
                    IPC::MessageWriter writer__(*reply__, self__);
                    IPC::WriteParam((&(writer__)), aParam);
                    // Sentinel = 'aResult'
                    ((&(writer__)))->WriteSentinel(185205473);

                    if (mozilla::ipc::LoggingEnabledFor("PRemoteWorker", mozilla::ipc::ChildSide)) {
                        mozilla::ipc::LogMessageForProtocol(
                            "PRemoteWorkerChild",
                            self__->ToplevelProtocol()->OtherPidMaybeInvalid(),
                            "Sending reply ",
                            reply__->type(),
                            mozilla::ipc::MessageDirection::eSending);
                    }

                });
            };
            mozilla::ipc::IPCResult __ok = (static_cast<RemoteWorkerChild*>(this))->RecvExecServiceWorkerOp(std::move(aArgs), std::move(resolver));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    default:
        return MsgNotKnown;
    }
}

auto PRemoteWorkerChild::OnMessageReceived(
        const Message& msg__,
        UniquePtr<Message>& reply__) -> PRemoteWorkerChild::Result
{
    MOZ_ASSERT_UNREACHABLE("message protocol not supported");
    return MsgNotKnown;
}



} // namespace dom
} // namespace mozilla
namespace IPC {
auto ParamTraits<::mozilla::dom::PRemoteWorkerChild*>::Write(
        IPC::MessageWriter* aWriter,
        const paramType& aVar) -> void
{
    MOZ_RELEASE_ASSERT(
        aWriter->GetActor(),
        "Cannot serialize managed actors without an actor");

    int32_t id;
    if (!aVar) {
        id = 0;  // kNullActorId
    } else {
        id = aVar->Id();
        if (id == 1) {  // kFreedActorId
            aVar->FatalError("Actor has been |delete|d");
        }
        MOZ_RELEASE_ASSERT(
            aWriter->GetActor()->GetIPCChannel() == aVar->GetIPCChannel(),
            "Actor must be from the same channel as the"
            " actor it's being sent over");
        MOZ_RELEASE_ASSERT(
            aVar->CanSend(),
            "Actor must still be open when sending");
    }

    IPC::WriteParam(aWriter, id);
}

auto ParamTraits<::mozilla::dom::PRemoteWorkerChild*>::Read(IPC::MessageReader* aReader) -> IPC::ReadResult<paramType>
{
    MOZ_RELEASE_ASSERT(
        aReader->GetActor(),
        "Cannot deserialize managed actors without an actor");
    mozilla::Maybe<mozilla::ipc::IProtocol*> actor = aReader->GetActor()
        ->ReadActor(aReader, true, "PRemoteWorker", PRemoteWorkerMsgStart);
    if (actor.isSome()) {
        return static_cast<::mozilla::dom::PRemoteWorkerChild*>(actor.ref());
    }
    return {};
}

} // namespace IPC
