//
// Automatically generated by ipdlc.
// Edit at your own risk
//


#include "mozilla/PRemoteDecoderManagerChild.h"
#include "gfxipc/ShadowLayerUtils.h"
#include "mozilla/GfxMessageUtils.h"
#include "mozilla/ProfilerLabels.h"
#include "mozilla/ProfilerMarkers.h"
#include "mozilla/RemoteDecoderManagerChild.h"
#include "mozilla/dom/MediaIPCUtils.h"
#include "mozilla/ipc/IPCCore.h"
#include "mozilla/layers/CompositorTypes.h"
#include "mozilla/layers/LayersMessageUtils.h"
#include "mozilla/layers/WebRenderMessageUtils.h"

#include "mozilla/layers/PTextureChild.h"
#include "mozilla/PRemoteDecoderChild.h"

#include "ipc/IPCMessageUtils.h"
#include "ipc/IPCMessageUtilsSpecializations.h"
#include "nsIFile.h"
#include "mozilla/ipc/Endpoint.h"
#include "mozilla/ipc/ProtocolMessageUtils.h"
#include "mozilla/ipc/ProtocolUtils.h"
#include "mozilla/ipc/ShmemMessageUtils.h"
#include "mozilla/ipc/TaintingIPCUtils.h"

namespace mozilla {


auto PRemoteDecoderManagerChild::ProcessingError(
        Result aCode,
        const char* aReason) -> void
{
}

auto PRemoteDecoderManagerChild::ShouldContinueFromReplyTimeout() -> bool
{
    return true;
}

MOZ_IMPLICIT PRemoteDecoderManagerChild::PRemoteDecoderManagerChild() :
    mozilla::ipc::IToplevelProtocol("PRemoteDecoderManagerChild", kProtocolId, mozilla::ipc::ChildSide)
{
    MOZ_COUNT_CTOR(PRemoteDecoderManagerChild);
}

PRemoteDecoderManagerChild::~PRemoteDecoderManagerChild()
{
    MOZ_COUNT_DTOR(PRemoteDecoderManagerChild);
}

auto PRemoteDecoderManagerChild::ActorAlloc() -> void
{
    MOZ_RELEASE_ASSERT(XRE_IsParentProcess() || XRE_IsContentProcess(), "Invalid process for `PRemoteDecoderManagerChild'");
    AddRef();
}

auto PRemoteDecoderManagerChild::ActorDealloc() -> void
{
    Release();
}

auto PRemoteDecoderManagerChild::OtherPid() const -> ::base::ProcessId
{
    ::base::ProcessId pid =
        ::mozilla::ipc::IProtocol::ToplevelProtocol()->OtherPidMaybeInvalid();
    MOZ_RELEASE_ASSERT(pid != ::base::kInvalidProcessId);
    return pid;
}

auto PRemoteDecoderManagerChild::OtherChildID() const -> ::GeckoChildID
{
    ::GeckoChildID childID =
        ::mozilla::ipc::IProtocol::ToplevelProtocol()->OtherChildIDMaybeInvalid();
    MOZ_RELEASE_ASSERT(childID != -1);
    return childID;
}

auto PRemoteDecoderManagerChild::OtherEndpointProcInfo() const -> ::mozilla::ipc::EndpointProcInfo
{
    return ::mozilla::ipc::EndpointProcInfo{OtherPid(), OtherChildID()};
}

auto PRemoteDecoderManagerChild::ManagedPRemoteDecoderChild(nsTArray<PRemoteDecoderChild*>& aArr) const -> void
{
    mManagedPRemoteDecoderChild.ToArray(aArr);
}

auto PRemoteDecoderManagerChild::ManagedPRemoteDecoderChild() const -> const ManagedContainer<PRemoteDecoderChild>&
{
    return mManagedPRemoteDecoderChild;
}

auto PRemoteDecoderManagerChild::ManagedProtocolIds() const -> mozilla::Span<mozilla::ipc::ProtocolId const>
{
    static constexpr ::mozilla::ipc::ProtocolId sIds[] = {
        PRemoteDecoderMsgStart
    };
    return sIds;
}

auto PRemoteDecoderManagerChild::GetManagedActors(mozilla::ipc::ProtocolId aProtocol) -> UntypedManagedContainer*
{
    switch (aProtocol) {
    case PRemoteDecoderMsgStart:
        return (&(mManagedPRemoteDecoderChild));
    default:
        return nullptr;
    }
}

auto PRemoteDecoderManagerChild::OpenPRemoteDecoderEndpoint(PRemoteDecoderChild* aActor) -> ManagedEndpoint<PRemoteDecoderParent>
{
    if (!aActor) {
        NS_WARNING("Cannot bind null PRemoteDecoderChild actor");
        return ManagedEndpoint<PRemoteDecoderParent>();
    }

    if (!aActor->SetManagerAndRegister(this)) {
        NS_WARNING("Failed to bind PRemoteDecoderChild actor");
        return ManagedEndpoint<PRemoteDecoderParent>();
    }

    // Mark our actor as awaiting the other side to be bound. This will
    // be cleared when a `MANAGED_ENDPOINT_{DROPPED,BOUND}` message is
    // received.
    aActor->mAwaitingManagedEndpointBind = true;
    return ManagedEndpoint<PRemoteDecoderParent>(mozilla::ipc::PrivateIPDLInterface(), aActor);
}

auto PRemoteDecoderManagerChild::BindPRemoteDecoderEndpoint(
        ManagedEndpoint<PRemoteDecoderChild> aEndpoint,
        PRemoteDecoderChild* aActor) -> bool
{
    return aEndpoint.Bind(mozilla::ipc::PrivateIPDLInterface(), aActor, this);
}

auto PRemoteDecoderManagerChild::SendPRemoteDecoderConstructor(
        const RemoteDecoderInfoIPDL& info,
        const OptionSet& options,
        const mozilla::Maybe<TextureFactoryIdentifier>& identifier,
        const mozilla::Maybe<uint64_t>& mediaEngineId,
        const mozilla::Maybe<TrackingId>& trackingId) -> PRemoteDecoderChild*
{
    PRemoteDecoderChild* actor = (static_cast<RemoteDecoderManagerChild*>(this))->AllocPRemoteDecoderChild(info, options, identifier, mediaEngineId, trackingId);
    return SendPRemoteDecoderConstructor(std::move(actor), std::move(info), std::move(options), std::move(identifier), std::move(mediaEngineId), std::move(trackingId));
}

auto PRemoteDecoderManagerChild::SendPRemoteDecoderConstructor(
        PRemoteDecoderChild* actor,
        const RemoteDecoderInfoIPDL& info,
        const OptionSet& options,
        const mozilla::Maybe<TextureFactoryIdentifier>& identifier,
        const mozilla::Maybe<uint64_t>& mediaEngineId,
        const mozilla::Maybe<TrackingId>& trackingId) -> PRemoteDecoderChild*
{
    if (!actor) {
        NS_WARNING("Cannot bind null PRemoteDecoderChild actor");
        return nullptr;
    }

    if (!actor->SetManagerAndRegister(this)) {
        NS_WARNING("Failed to bind PRemoteDecoderChild actor");
        return nullptr;
    }


    // Build our constructor message.
    UniquePtr<IPC::Message> msg__ = PRemoteDecoderManager::Msg_PRemoteDecoderConstructor(MSG_ROUTING_CONTROL);
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), actor);
    // Sentinel = 'actor'
    ((&(writer__)))->WriteSentinel(102892058);
    IPC::WriteParam((&(writer__)), info);
    // Sentinel = 'info'
    ((&(writer__)))->WriteSentinel(70058413);
    IPC::WriteParam((&(writer__)), options);
    // Sentinel = 'options'
    ((&(writer__)))->WriteSentinel(204735245);
    IPC::WriteParam((&(writer__)), identifier);
    // Sentinel = 'identifier'
    ((&(writer__)))->WriteSentinel(379978788);
    IPC::WriteParam((&(writer__)), mediaEngineId);
    // Sentinel = 'mediaEngineId'
    ((&(writer__)))->WriteSentinel(597624068);
    IPC::WriteParam((&(writer__)), trackingId);
    // Sentinel = 'trackingId'
    ((&(writer__)))->WriteSentinel(381879297);




    // Notify the other side about the newly created actor. This can
    // fail if our manager has already been destroyed.
    //
    // NOTE: If the send call fails due to toplevel channel teardown,
    // the `IProtocol::ChannelSend` wrapper absorbs the error for us,
    // so we don't tear down actors unexpectedly.

    if (mozilla::ipc::LoggingEnabledFor("PRemoteDecoderManager", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PRemoteDecoderManagerChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PRemoteDecoderManager::Msg_PRemoteDecoderConstructor", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));


    // Warn, destroy the actor, and return null if the message failed to
    // send. Otherwise, return the successfully created actor reference.
    if (!sendok__) {
        NS_WARNING("Error sending PRemoteDecoderChild constructor");
        actor->ActorDisconnected(FailedConstructor);

        return nullptr;
    }
    return actor;
}

auto PRemoteDecoderManagerChild::SendReadback(
        const SurfaceDescriptorGPUVideo& sd,
        SurfaceDescriptor* aResult) -> bool
{
    UniquePtr<IPC::Message> msg__ = PRemoteDecoderManager::Msg_Readback(MSG_ROUTING_CONTROL);
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), sd);
    // Sentinel = 'sd'
    ((&(writer__)))->WriteSentinel(21758168);



    UniquePtr<Message> reply__;

    if (mozilla::ipc::LoggingEnabledFor("PRemoteDecoderManager", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PRemoteDecoderManagerChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PRemoteDecoderManager::Msg_Readback", OTHER);

    bool sendok__ = false;
    {
        AUTO_PROFILER_TRACING_MARKER("Sync IPC", "PRemoteDecoderManager::Msg_Readback", IPC);
        sendok__ = ChannelSend(std::move(msg__), (&(reply__)));
    }
    if ((!(sendok__))) {
        return false;
    }

    if (mozilla::ipc::LoggingEnabledFor("PRemoteDecoderManager", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PRemoteDecoderManagerChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Received reply ",
            reply__->type(),
            mozilla::ipc::MessageDirection::eReceiving);
    }

    IPC::MessageReader reader__{
            (*(reply__)),
            this};

    auto maybe__aResult__reply = IPC::ReadParam<SurfaceDescriptor>((&(reader__)));
    if (!maybe__aResult__reply) {
        FatalError("Error deserializing 'SurfaceDescriptor'");
        return false;

    }
    auto& aResult__reply = *maybe__aResult__reply;
    // Sentinel = 'aResult'
    if ((!(((&(reader__)))->ReadSentinel(185205473)))) {
        mozilla::ipc::SentinelReadError("Error deserializing 'SurfaceDescriptor'");
        return false;
    }
    (*(aResult)) = std::move(aResult__reply);
    reader__.EndRead();

    return true;
}

auto PRemoteDecoderManagerChild::SendDeallocateSurfaceDescriptorGPUVideo(const SurfaceDescriptorGPUVideo& sd) -> bool
{
    UniquePtr<IPC::Message> msg__ = PRemoteDecoderManager::Msg_DeallocateSurfaceDescriptorGPUVideo(MSG_ROUTING_CONTROL);
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), sd);
    // Sentinel = 'sd'
    ((&(writer__)))->WriteSentinel(21758168);




    if (mozilla::ipc::LoggingEnabledFor("PRemoteDecoderManager", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PRemoteDecoderManagerChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PRemoteDecoderManager::Msg_DeallocateSurfaceDescriptorGPUVideo", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PRemoteDecoderManagerChild::DeallocManagee(
        int32_t aProtocolId,
        IProtocol* aListener) -> void
{
    switch (aProtocolId) {
    case PRemoteDecoderMsgStart:
        static_cast<RemoteDecoderManagerChild*>(this)->DeallocPRemoteDecoderChild(static_cast<PRemoteDecoderChild*>(aListener));
        return;
    default:
        FatalError("unreached");
        return;
    }
}

auto PRemoteDecoderManagerChild::OnMessageReceived(const Message& msg__) -> PRemoteDecoderManagerChild::Result
{
    int32_t route__ = msg__.routing_id();
    if (MSG_ROUTING_CONTROL != route__) {
        IProtocol* routed__ = Lookup(route__);
        if (!routed__ || !routed__->GetLifecycleProxy()) {
            if (mozilla::ipc::LoggingEnabledFor("PRemoteDecoderManager", mozilla::ipc::ChildSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PRemoteDecoderManagerChild",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Ignored message for dead actor",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eSending);
            }
            return MsgProcessed;

        }

        RefPtr<mozilla::ipc::ActorLifecycleProxy> proxy__ =
            routed__->GetLifecycleProxy();
        return proxy__->Get()->OnMessageReceived(msg__);
    }

    switch (msg__.type()) {
    case PRemoteDecoderManager::Reply_PRemoteDecoderConstructor__ID:
        {
            return MsgProcessed;
        }
    default:
        return MsgNotKnown;
    case SHMEM_CREATED_MESSAGE_TYPE:
        {
            if (!ShmemCreated(msg__)) {
                return MsgPayloadError;
            }
            return MsgProcessed;
        }
    case SHMEM_DESTROYED_MESSAGE_TYPE:
        {
            if (!ShmemDestroyed(msg__)) {
                return MsgPayloadError;
            }
            return MsgProcessed;
        }
    }
}

auto PRemoteDecoderManagerChild::OnMessageReceived(
        const Message& msg__,
        UniquePtr<Message>& reply__) -> PRemoteDecoderManagerChild::Result
{
    int32_t route__ = msg__.routing_id();
    if (MSG_ROUTING_CONTROL != route__) {
        IProtocol* routed__ = Lookup(route__);
        if (!routed__ || !routed__->GetLifecycleProxy()) {
            return MsgDropped;

        }

        RefPtr<mozilla::ipc::ActorLifecycleProxy> proxy__ =
            routed__->GetLifecycleProxy();
        return proxy__->Get()->OnMessageReceived(msg__, reply__);
    }

    return MsgNotKnown;
}



} // namespace mozilla
namespace IPC {
auto ParamTraits<::mozilla::PRemoteDecoderManagerChild*>::Write(
        IPC::MessageWriter* aWriter,
        const paramType& aVar) -> void
{
    MOZ_RELEASE_ASSERT(
        aWriter->GetActor(),
        "Cannot serialize managed actors without an actor");

    int32_t id;
    if (!aVar) {
        id = 0;  // kNullActorId
    } else {
        id = aVar->Id();
        if (id == 1) {  // kFreedActorId
            aVar->FatalError("Actor has been |delete|d");
        }
        MOZ_RELEASE_ASSERT(
            aWriter->GetActor()->GetIPCChannel() == aVar->GetIPCChannel(),
            "Actor must be from the same channel as the"
            " actor it's being sent over");
        MOZ_RELEASE_ASSERT(
            aVar->CanSend(),
            "Actor must still be open when sending");
    }

    IPC::WriteParam(aWriter, id);
}

auto ParamTraits<::mozilla::PRemoteDecoderManagerChild*>::Read(IPC::MessageReader* aReader) -> IPC::ReadResult<paramType>
{
    MOZ_RELEASE_ASSERT(
        aReader->GetActor(),
        "Cannot deserialize managed actors without an actor");
    mozilla::Maybe<mozilla::ipc::IProtocol*> actor = aReader->GetActor()
        ->ReadActor(aReader, true, "PRemoteDecoderManager", PRemoteDecoderManagerMsgStart);
    if (actor.isSome()) {
        return static_cast<::mozilla::PRemoteDecoderManagerChild*>(actor.ref());
    }
    return {};
}

} // namespace IPC
