//
// Automatically generated by ipdlc.
// Edit at your own risk
//


#include "mozilla/dom/quota/PQuotaParent.h"
#include "mozilla/ProfilerLabels.h"
#include "mozilla/dom/DomSecurityIPCUtils.h"
#include "mozilla/dom/quota/SerializationHelpers.h"
#include "mozilla/ipc/IPCCore.h"

#include "mozilla/ipc/PBackgroundParent.h"
#include "mozilla/dom/quota/PQuotaRequestParent.h"
#include "mozilla/dom/quota/PQuotaUsageRequestParent.h"

#include "ipc/IPCMessageUtils.h"
#include "ipc/IPCMessageUtilsSpecializations.h"
#include "nsIFile.h"
#include "mozilla/ipc/Endpoint.h"
#include "mozilla/ipc/ProtocolMessageUtils.h"
#include "mozilla/ipc/ProtocolUtils.h"
#include "mozilla/ipc/ShmemMessageUtils.h"
#include "mozilla/ipc/TaintingIPCUtils.h"

namespace mozilla {
namespace dom {
namespace quota {


auto PQuotaParent::Recv__delete__() -> mozilla::ipc::IPCResult
{
    return IPC_OK();
}

auto PQuotaParent::RecvPQuotaRequestConstructor(
        PQuotaRequestParent* actor,
        const RequestParams& params) -> mozilla::ipc::IPCResult
{
    return IPC_OK();
}

MOZ_IMPLICIT PQuotaParent::PQuotaParent() :
    mozilla::ipc::IRefCountedProtocol(kProtocolId, mozilla::ipc::ParentSide)
{
    MOZ_COUNT_CTOR(PQuotaParent);
}

PQuotaParent::~PQuotaParent()
{
    MOZ_COUNT_DTOR(PQuotaParent);
}

auto PQuotaParent::ActorAlloc() -> void
{
    AddRef();
}

auto PQuotaParent::ActorDealloc() -> void
{
    Release();
}

auto PQuotaParent::OtherPid() const -> ::base::ProcessId
{
    ::base::ProcessId pid =
        ::mozilla::ipc::IProtocol::ToplevelProtocol()->OtherPidMaybeInvalid();
    MOZ_RELEASE_ASSERT(pid != ::base::kInvalidProcessId);
    return pid;
}

auto PQuotaParent::OtherChildID() const -> ::GeckoChildID
{
    ::GeckoChildID childID =
        ::mozilla::ipc::IProtocol::ToplevelProtocol()->OtherChildIDMaybeInvalid();
    MOZ_RELEASE_ASSERT(childID != -1);
    return childID;
}

auto PQuotaParent::OtherEndpointProcInfo() const -> ::mozilla::ipc::EndpointProcInfo
{
    return ::mozilla::ipc::EndpointProcInfo{OtherPid(), OtherChildID()};
}

auto PQuotaParent::Manager() const -> PBackgroundParent*
{
    return static_cast<PBackgroundParent*>(IProtocol::Manager());
}

auto PQuotaParent::ManagedPQuotaRequestParent(nsTArray<PQuotaRequestParent*>& aArr) const -> void
{
    mManagedPQuotaRequestParent.ToArray(aArr);
}

auto PQuotaParent::ManagedPQuotaRequestParent() const -> const ManagedContainer<PQuotaRequestParent>&
{
    return mManagedPQuotaRequestParent;
}

auto PQuotaParent::ManagedPQuotaUsageRequestParent(nsTArray<PQuotaUsageRequestParent*>& aArr) const -> void
{
    mManagedPQuotaUsageRequestParent.ToArray(aArr);
}

auto PQuotaParent::ManagedPQuotaUsageRequestParent() const -> const ManagedContainer<PQuotaUsageRequestParent>&
{
    return mManagedPQuotaUsageRequestParent;
}

auto PQuotaParent::ManagedProtocolIds() const -> mozilla::Span<mozilla::ipc::ProtocolId const>
{
    static constexpr ::mozilla::ipc::ProtocolId sIds[] = {
        PQuotaRequestMsgStart,
        PQuotaUsageRequestMsgStart
    };
    return sIds;
}

auto PQuotaParent::GetManagedActors(mozilla::ipc::ProtocolId aProtocol) -> UntypedManagedContainer*
{
    switch (aProtocol) {
    case PQuotaRequestMsgStart:
        return (&(mManagedPQuotaRequestParent));
    case PQuotaUsageRequestMsgStart:
        return (&(mManagedPQuotaUsageRequestParent));
    default:
        return nullptr;
    }
}

auto PQuotaParent::RejectPendingResponses(ResponseRejectReason aReason) -> void
{
    mAsyncCallbacks.RejectPendingResponses(aReason);
}

auto PQuotaParent::OpenPQuotaRequestEndpoint(PQuotaRequestParent* aActor) -> ManagedEndpoint<PQuotaRequestChild>
{
    if (!aActor) {
        NS_WARNING("Cannot bind null PQuotaRequestParent actor");
        return ManagedEndpoint<PQuotaRequestChild>();
    }

    if (!aActor->SetManagerAndRegister(this)) {
        NS_WARNING("Failed to bind PQuotaRequestParent actor");
        return ManagedEndpoint<PQuotaRequestChild>();
    }

    // Mark our actor as awaiting the other side to be bound. This will
    // be cleared when a `MANAGED_ENDPOINT_{DROPPED,BOUND}` message is
    // received.
    aActor->mAwaitingManagedEndpointBind = true;
    return ManagedEndpoint<PQuotaRequestChild>(mozilla::ipc::PrivateIPDLInterface(), aActor);
}

auto PQuotaParent::BindPQuotaRequestEndpoint(
        ManagedEndpoint<PQuotaRequestParent> aEndpoint,
        PQuotaRequestParent* aActor) -> bool
{
    return aEndpoint.Bind(mozilla::ipc::PrivateIPDLInterface(), aActor, this);
}

auto PQuotaParent::OpenPQuotaUsageRequestEndpoint(PQuotaUsageRequestParent* aActor) -> ManagedEndpoint<PQuotaUsageRequestChild>
{
    if (!aActor) {
        NS_WARNING("Cannot bind null PQuotaUsageRequestParent actor");
        return ManagedEndpoint<PQuotaUsageRequestChild>();
    }

    if (!aActor->SetManagerAndRegister(this)) {
        NS_WARNING("Failed to bind PQuotaUsageRequestParent actor");
        return ManagedEndpoint<PQuotaUsageRequestChild>();
    }

    // Mark our actor as awaiting the other side to be bound. This will
    // be cleared when a `MANAGED_ENDPOINT_{DROPPED,BOUND}` message is
    // received.
    aActor->mAwaitingManagedEndpointBind = true;
    return ManagedEndpoint<PQuotaUsageRequestChild>(mozilla::ipc::PrivateIPDLInterface(), aActor);
}

auto PQuotaParent::BindPQuotaUsageRequestEndpoint(
        ManagedEndpoint<PQuotaUsageRequestParent> aEndpoint,
        PQuotaUsageRequestParent* aActor) -> bool
{
    return aEndpoint.Bind(mozilla::ipc::PrivateIPDLInterface(), aActor, this);
}

auto PQuotaParent::DeallocManagee(
        int32_t aProtocolId,
        IProtocol* aListener) -> void
{
    switch (aProtocolId) {
    case PQuotaRequestMsgStart:
        this->DeallocPQuotaRequestParent(static_cast<PQuotaRequestParent*>(aListener));
        return;
    default:
        FatalError("unreached");
        return;
    }
}

auto PQuotaParent::OnMessageReceived(const Message& msg__) -> PQuotaParent::Result
{
    switch (msg__.type()) {
    case MANAGED_ENDPOINT_BOUND_MESSAGE_TYPE:
        {
            if (!mAwaitingManagedEndpointBind) {
                NS_WARNING("Unexpected managed endpoint lifecycle message after actor bound!");
                return MsgNotAllowed;
            }
            mAwaitingManagedEndpointBind = false;
            return MsgProcessed;
        }
    case MANAGED_ENDPOINT_DROPPED_MESSAGE_TYPE:
        {
            if (!mAwaitingManagedEndpointBind) {
                NS_WARNING("Unexpected managed endpoint lifecycle message after actor bound!");
                return MsgNotAllowed;
            }
            mAwaitingManagedEndpointBind = false;
            this->ActorDisconnected(ManagedEndpointDropped);
            return MsgProcessed;
        }
    case PQuota::Msg___delete____ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PQuota", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PQuotaParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PQuota::Msg___delete__", OTHER);

            mozilla::ipc::IPCResult __ok = (this)->Recv__delete__();
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }


            this->ActorDisconnected(Deletion);

            return MsgProcessed;
        }
    case PQuota::Msg_PQuotaRequestConstructor__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PQuota", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PQuotaParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PQuota::Msg_PQuotaRequestConstructor", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__handle__ = IPC::ReadParam<ActorHandle>((&(reader__)));
            if (!maybe__handle__) {
                FatalError("Error deserializing 'ActorHandle'");
                return MsgValueError;

            }
            auto& handle__ = *maybe__handle__;
            // Sentinel = 'actor'
            if ((!(((&(reader__)))->ReadSentinel(102892058)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'ActorHandle'");
                return MsgValueError;
            }
            auto maybe__params = IPC::ReadParam<RequestParams>((&(reader__)));
            if (!maybe__params) {
                FatalError("Error deserializing 'RequestParams'");
                return MsgValueError;

            }
            auto& params = *maybe__params;
            // Sentinel = 'params'
            if ((!(((&(reader__)))->ReadSentinel(146997893)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'RequestParams'");
                return MsgValueError;
            }
            reader__.EndRead();
            PQuotaRequestParent* actor = (this)->AllocPQuotaRequestParent(params);
            if (!actor) {
                NS_WARNING("Cannot bind null PQuotaRequestParent actor");
                return MsgValueError;
            }

            if (!actor->SetManagerAndRegister(this, (handle__).mId)) {
                NS_WARNING("Failed to bind PQuotaRequestParent actor");
                return MsgValueError;
            }

            mozilla::ipc::IPCResult __ok = (this)->RecvPQuotaRequestConstructor(std::move(actor), std::move(params));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PQuota::Msg_StorageInitialized__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PQuota", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PQuotaParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PQuota::Msg_StorageInitialized", OTHER);

            int32_t id__ = Id();
            UniquePtr<IPC::Message> reply__(PQuota::Reply_StorageInitialized(id__));
            reply__->set_seqno(msg__.seqno());

            RefPtr<mozilla::ipc::IPDLResolverInner> resolver__ =
                new mozilla::ipc::IPDLResolverInner(std::move(reply__), this);

            StorageInitializedResolver resolver = [resolver__ = std::move(resolver__)](const BoolResponse& aParam) {
                resolver__->Resolve([&] (IPC::Message* reply__, IProtocol* self__) {
                    IPC::MessageWriter writer__(*reply__, self__);
                    IPC::WriteParam((&(writer__)), aParam);
                    // Sentinel = 'response'
                    ((&(writer__)))->WriteSentinel(260965232);

                    if (mozilla::ipc::LoggingEnabledFor("PQuota", mozilla::ipc::ParentSide)) {
                        mozilla::ipc::LogMessageForProtocol(
                            "PQuotaParent",
                            self__->ToplevelProtocol()->OtherPidMaybeInvalid(),
                            "Sending reply ",
                            reply__->type(),
                            mozilla::ipc::MessageDirection::eSending);
                    }

                });
            };
            mozilla::ipc::IPCResult __ok = (this)->RecvStorageInitialized(std::move(resolver));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PQuota::Msg_PersistentStorageInitialized__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PQuota", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PQuotaParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PQuota::Msg_PersistentStorageInitialized", OTHER);

            int32_t id__ = Id();
            UniquePtr<IPC::Message> reply__(PQuota::Reply_PersistentStorageInitialized(id__));
            reply__->set_seqno(msg__.seqno());

            RefPtr<mozilla::ipc::IPDLResolverInner> resolver__ =
                new mozilla::ipc::IPDLResolverInner(std::move(reply__), this);

            PersistentStorageInitializedResolver resolver = [resolver__ = std::move(resolver__)](const BoolResponse& aParam) {
                resolver__->Resolve([&] (IPC::Message* reply__, IProtocol* self__) {
                    IPC::MessageWriter writer__(*reply__, self__);
                    IPC::WriteParam((&(writer__)), aParam);
                    // Sentinel = 'response'
                    ((&(writer__)))->WriteSentinel(260965232);

                    if (mozilla::ipc::LoggingEnabledFor("PQuota", mozilla::ipc::ParentSide)) {
                        mozilla::ipc::LogMessageForProtocol(
                            "PQuotaParent",
                            self__->ToplevelProtocol()->OtherPidMaybeInvalid(),
                            "Sending reply ",
                            reply__->type(),
                            mozilla::ipc::MessageDirection::eSending);
                    }

                });
            };
            mozilla::ipc::IPCResult __ok = (this)->RecvPersistentStorageInitialized(std::move(resolver));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PQuota::Msg_TemporaryStorageInitialized__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PQuota", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PQuotaParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PQuota::Msg_TemporaryStorageInitialized", OTHER);

            int32_t id__ = Id();
            UniquePtr<IPC::Message> reply__(PQuota::Reply_TemporaryStorageInitialized(id__));
            reply__->set_seqno(msg__.seqno());

            RefPtr<mozilla::ipc::IPDLResolverInner> resolver__ =
                new mozilla::ipc::IPDLResolverInner(std::move(reply__), this);

            TemporaryStorageInitializedResolver resolver = [resolver__ = std::move(resolver__)](const BoolResponse& aParam) {
                resolver__->Resolve([&] (IPC::Message* reply__, IProtocol* self__) {
                    IPC::MessageWriter writer__(*reply__, self__);
                    IPC::WriteParam((&(writer__)), aParam);
                    // Sentinel = 'response'
                    ((&(writer__)))->WriteSentinel(260965232);

                    if (mozilla::ipc::LoggingEnabledFor("PQuota", mozilla::ipc::ParentSide)) {
                        mozilla::ipc::LogMessageForProtocol(
                            "PQuotaParent",
                            self__->ToplevelProtocol()->OtherPidMaybeInvalid(),
                            "Sending reply ",
                            reply__->type(),
                            mozilla::ipc::MessageDirection::eSending);
                    }

                });
            };
            mozilla::ipc::IPCResult __ok = (this)->RecvTemporaryStorageInitialized(std::move(resolver));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PQuota::Msg_TemporaryGroupInitialized__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PQuota", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PQuotaParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PQuota::Msg_TemporaryGroupInitialized", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__principalInfo = IPC::ReadParam<PrincipalInfo>((&(reader__)));
            if (!maybe__principalInfo) {
                FatalError("Error deserializing 'PrincipalInfo'");
                return MsgValueError;

            }
            auto& principalInfo = *maybe__principalInfo;
            // Sentinel = 'principalInfo'
            if ((!(((&(reader__)))->ReadSentinel(633472335)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'PrincipalInfo'");
                return MsgValueError;
            }
            reader__.EndRead();
            int32_t id__ = Id();
            UniquePtr<IPC::Message> reply__(PQuota::Reply_TemporaryGroupInitialized(id__));
            reply__->set_seqno(msg__.seqno());

            RefPtr<mozilla::ipc::IPDLResolverInner> resolver__ =
                new mozilla::ipc::IPDLResolverInner(std::move(reply__), this);

            TemporaryGroupInitializedResolver resolver = [resolver__ = std::move(resolver__)](const BoolResponse& aParam) {
                resolver__->Resolve([&] (IPC::Message* reply__, IProtocol* self__) {
                    IPC::MessageWriter writer__(*reply__, self__);
                    IPC::WriteParam((&(writer__)), aParam);
                    // Sentinel = 'response'
                    ((&(writer__)))->WriteSentinel(260965232);

                    if (mozilla::ipc::LoggingEnabledFor("PQuota", mozilla::ipc::ParentSide)) {
                        mozilla::ipc::LogMessageForProtocol(
                            "PQuotaParent",
                            self__->ToplevelProtocol()->OtherPidMaybeInvalid(),
                            "Sending reply ",
                            reply__->type(),
                            mozilla::ipc::MessageDirection::eSending);
                    }

                });
            };
            mozilla::ipc::IPCResult __ok = (this)->RecvTemporaryGroupInitialized(std::move(principalInfo), std::move(resolver));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PQuota::Msg_PersistentOriginInitialized__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PQuota", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PQuotaParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PQuota::Msg_PersistentOriginInitialized", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__principalInfo = IPC::ReadParam<PrincipalInfo>((&(reader__)));
            if (!maybe__principalInfo) {
                FatalError("Error deserializing 'PrincipalInfo'");
                return MsgValueError;

            }
            auto& principalInfo = *maybe__principalInfo;
            // Sentinel = 'principalInfo'
            if ((!(((&(reader__)))->ReadSentinel(633472335)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'PrincipalInfo'");
                return MsgValueError;
            }
            reader__.EndRead();
            int32_t id__ = Id();
            UniquePtr<IPC::Message> reply__(PQuota::Reply_PersistentOriginInitialized(id__));
            reply__->set_seqno(msg__.seqno());

            RefPtr<mozilla::ipc::IPDLResolverInner> resolver__ =
                new mozilla::ipc::IPDLResolverInner(std::move(reply__), this);

            PersistentOriginInitializedResolver resolver = [resolver__ = std::move(resolver__)](const BoolResponse& aParam) {
                resolver__->Resolve([&] (IPC::Message* reply__, IProtocol* self__) {
                    IPC::MessageWriter writer__(*reply__, self__);
                    IPC::WriteParam((&(writer__)), aParam);
                    // Sentinel = 'response'
                    ((&(writer__)))->WriteSentinel(260965232);

                    if (mozilla::ipc::LoggingEnabledFor("PQuota", mozilla::ipc::ParentSide)) {
                        mozilla::ipc::LogMessageForProtocol(
                            "PQuotaParent",
                            self__->ToplevelProtocol()->OtherPidMaybeInvalid(),
                            "Sending reply ",
                            reply__->type(),
                            mozilla::ipc::MessageDirection::eSending);
                    }

                });
            };
            mozilla::ipc::IPCResult __ok = (this)->RecvPersistentOriginInitialized(std::move(principalInfo), std::move(resolver));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PQuota::Msg_TemporaryOriginInitialized__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PQuota", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PQuotaParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PQuota::Msg_TemporaryOriginInitialized", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__persistenceType = IPC::ReadParam<PersistenceType>((&(reader__)));
            if (!maybe__persistenceType) {
                FatalError("Error deserializing 'PersistenceType'");
                return MsgValueError;

            }
            auto& persistenceType = *maybe__persistenceType;
            // Sentinel = 'persistenceType'
            if ((!(((&(reader__)))->ReadSentinel(853345864)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'PersistenceType'");
                return MsgValueError;
            }
            auto maybe__principalInfo = IPC::ReadParam<PrincipalInfo>((&(reader__)));
            if (!maybe__principalInfo) {
                FatalError("Error deserializing 'PrincipalInfo'");
                return MsgValueError;

            }
            auto& principalInfo = *maybe__principalInfo;
            // Sentinel = 'principalInfo'
            if ((!(((&(reader__)))->ReadSentinel(633472335)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'PrincipalInfo'");
                return MsgValueError;
            }
            reader__.EndRead();
            int32_t id__ = Id();
            UniquePtr<IPC::Message> reply__(PQuota::Reply_TemporaryOriginInitialized(id__));
            reply__->set_seqno(msg__.seqno());

            RefPtr<mozilla::ipc::IPDLResolverInner> resolver__ =
                new mozilla::ipc::IPDLResolverInner(std::move(reply__), this);

            TemporaryOriginInitializedResolver resolver = [resolver__ = std::move(resolver__)](const BoolResponse& aParam) {
                resolver__->Resolve([&] (IPC::Message* reply__, IProtocol* self__) {
                    IPC::MessageWriter writer__(*reply__, self__);
                    IPC::WriteParam((&(writer__)), aParam);
                    // Sentinel = 'response'
                    ((&(writer__)))->WriteSentinel(260965232);

                    if (mozilla::ipc::LoggingEnabledFor("PQuota", mozilla::ipc::ParentSide)) {
                        mozilla::ipc::LogMessageForProtocol(
                            "PQuotaParent",
                            self__->ToplevelProtocol()->OtherPidMaybeInvalid(),
                            "Sending reply ",
                            reply__->type(),
                            mozilla::ipc::MessageDirection::eSending);
                    }

                });
            };
            mozilla::ipc::IPCResult __ok = (this)->RecvTemporaryOriginInitialized(std::move(persistenceType), std::move(principalInfo), std::move(resolver));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PQuota::Msg_InitializeStorage__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PQuota", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PQuotaParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PQuota::Msg_InitializeStorage", OTHER);

            int32_t id__ = Id();
            UniquePtr<IPC::Message> reply__(PQuota::Reply_InitializeStorage(id__));
            reply__->set_seqno(msg__.seqno());

            RefPtr<mozilla::ipc::IPDLResolverInner> resolver__ =
                new mozilla::ipc::IPDLResolverInner(std::move(reply__), this);

            InitializeStorageResolver resolver = [resolver__ = std::move(resolver__)](const BoolResponse& aParam) {
                resolver__->Resolve([&] (IPC::Message* reply__, IProtocol* self__) {
                    IPC::MessageWriter writer__(*reply__, self__);
                    IPC::WriteParam((&(writer__)), aParam);
                    // Sentinel = 'response'
                    ((&(writer__)))->WriteSentinel(260965232);

                    if (mozilla::ipc::LoggingEnabledFor("PQuota", mozilla::ipc::ParentSide)) {
                        mozilla::ipc::LogMessageForProtocol(
                            "PQuotaParent",
                            self__->ToplevelProtocol()->OtherPidMaybeInvalid(),
                            "Sending reply ",
                            reply__->type(),
                            mozilla::ipc::MessageDirection::eSending);
                    }

                });
            };
            mozilla::ipc::IPCResult __ok = (this)->RecvInitializeStorage(std::move(resolver));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PQuota::Msg_InitializePersistentStorage__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PQuota", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PQuotaParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PQuota::Msg_InitializePersistentStorage", OTHER);

            int32_t id__ = Id();
            UniquePtr<IPC::Message> reply__(PQuota::Reply_InitializePersistentStorage(id__));
            reply__->set_seqno(msg__.seqno());

            RefPtr<mozilla::ipc::IPDLResolverInner> resolver__ =
                new mozilla::ipc::IPDLResolverInner(std::move(reply__), this);

            InitializePersistentStorageResolver resolver = [resolver__ = std::move(resolver__)](const BoolResponse& aParam) {
                resolver__->Resolve([&] (IPC::Message* reply__, IProtocol* self__) {
                    IPC::MessageWriter writer__(*reply__, self__);
                    IPC::WriteParam((&(writer__)), aParam);
                    // Sentinel = 'response'
                    ((&(writer__)))->WriteSentinel(260965232);

                    if (mozilla::ipc::LoggingEnabledFor("PQuota", mozilla::ipc::ParentSide)) {
                        mozilla::ipc::LogMessageForProtocol(
                            "PQuotaParent",
                            self__->ToplevelProtocol()->OtherPidMaybeInvalid(),
                            "Sending reply ",
                            reply__->type(),
                            mozilla::ipc::MessageDirection::eSending);
                    }

                });
            };
            mozilla::ipc::IPCResult __ok = (this)->RecvInitializePersistentStorage(std::move(resolver));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PQuota::Msg_InitializeAllTemporaryOrigins__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PQuota", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PQuotaParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PQuota::Msg_InitializeAllTemporaryOrigins", OTHER);

            int32_t id__ = Id();
            UniquePtr<IPC::Message> reply__(PQuota::Reply_InitializeAllTemporaryOrigins(id__));
            reply__->set_seqno(msg__.seqno());

            RefPtr<mozilla::ipc::IPDLResolverInner> resolver__ =
                new mozilla::ipc::IPDLResolverInner(std::move(reply__), this);

            InitializeAllTemporaryOriginsResolver resolver = [resolver__ = std::move(resolver__)](const BoolResponse& aParam) {
                resolver__->Resolve([&] (IPC::Message* reply__, IProtocol* self__) {
                    IPC::MessageWriter writer__(*reply__, self__);
                    IPC::WriteParam((&(writer__)), aParam);
                    // Sentinel = 'response'
                    ((&(writer__)))->WriteSentinel(260965232);

                    if (mozilla::ipc::LoggingEnabledFor("PQuota", mozilla::ipc::ParentSide)) {
                        mozilla::ipc::LogMessageForProtocol(
                            "PQuotaParent",
                            self__->ToplevelProtocol()->OtherPidMaybeInvalid(),
                            "Sending reply ",
                            reply__->type(),
                            mozilla::ipc::MessageDirection::eSending);
                    }

                });
            };
            mozilla::ipc::IPCResult __ok = (this)->RecvInitializeAllTemporaryOrigins(std::move(resolver));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PQuota::Msg_InitializeTemporaryGroup__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PQuota", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PQuotaParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PQuota::Msg_InitializeTemporaryGroup", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__principalInfo = IPC::ReadParam<PrincipalInfo>((&(reader__)));
            if (!maybe__principalInfo) {
                FatalError("Error deserializing 'PrincipalInfo'");
                return MsgValueError;

            }
            auto& principalInfo = *maybe__principalInfo;
            // Sentinel = 'principalInfo'
            if ((!(((&(reader__)))->ReadSentinel(633472335)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'PrincipalInfo'");
                return MsgValueError;
            }
            reader__.EndRead();
            int32_t id__ = Id();
            UniquePtr<IPC::Message> reply__(PQuota::Reply_InitializeTemporaryGroup(id__));
            reply__->set_seqno(msg__.seqno());

            RefPtr<mozilla::ipc::IPDLResolverInner> resolver__ =
                new mozilla::ipc::IPDLResolverInner(std::move(reply__), this);

            InitializeTemporaryGroupResolver resolver = [resolver__ = std::move(resolver__)](const BoolResponse& aParam) {
                resolver__->Resolve([&] (IPC::Message* reply__, IProtocol* self__) {
                    IPC::MessageWriter writer__(*reply__, self__);
                    IPC::WriteParam((&(writer__)), aParam);
                    // Sentinel = 'response'
                    ((&(writer__)))->WriteSentinel(260965232);

                    if (mozilla::ipc::LoggingEnabledFor("PQuota", mozilla::ipc::ParentSide)) {
                        mozilla::ipc::LogMessageForProtocol(
                            "PQuotaParent",
                            self__->ToplevelProtocol()->OtherPidMaybeInvalid(),
                            "Sending reply ",
                            reply__->type(),
                            mozilla::ipc::MessageDirection::eSending);
                    }

                });
            };
            mozilla::ipc::IPCResult __ok = (this)->RecvInitializeTemporaryGroup(std::move(principalInfo), std::move(resolver));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PQuota::Msg_InitializePersistentOrigin__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PQuota", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PQuotaParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PQuota::Msg_InitializePersistentOrigin", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__principalInfo = IPC::ReadParam<PrincipalInfo>((&(reader__)));
            if (!maybe__principalInfo) {
                FatalError("Error deserializing 'PrincipalInfo'");
                return MsgValueError;

            }
            auto& principalInfo = *maybe__principalInfo;
            // Sentinel = 'principalInfo'
            if ((!(((&(reader__)))->ReadSentinel(633472335)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'PrincipalInfo'");
                return MsgValueError;
            }
            reader__.EndRead();
            int32_t id__ = Id();
            UniquePtr<IPC::Message> reply__(PQuota::Reply_InitializePersistentOrigin(id__));
            reply__->set_seqno(msg__.seqno());

            RefPtr<mozilla::ipc::IPDLResolverInner> resolver__ =
                new mozilla::ipc::IPDLResolverInner(std::move(reply__), this);

            InitializePersistentOriginResolver resolver = [resolver__ = std::move(resolver__)](const BoolResponse& aParam) {
                resolver__->Resolve([&] (IPC::Message* reply__, IProtocol* self__) {
                    IPC::MessageWriter writer__(*reply__, self__);
                    IPC::WriteParam((&(writer__)), aParam);
                    // Sentinel = 'response'
                    ((&(writer__)))->WriteSentinel(260965232);

                    if (mozilla::ipc::LoggingEnabledFor("PQuota", mozilla::ipc::ParentSide)) {
                        mozilla::ipc::LogMessageForProtocol(
                            "PQuotaParent",
                            self__->ToplevelProtocol()->OtherPidMaybeInvalid(),
                            "Sending reply ",
                            reply__->type(),
                            mozilla::ipc::MessageDirection::eSending);
                    }

                });
            };
            mozilla::ipc::IPCResult __ok = (this)->RecvInitializePersistentOrigin(std::move(principalInfo), std::move(resolver));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PQuota::Msg_InitializeTemporaryOrigin__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PQuota", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PQuotaParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PQuota::Msg_InitializeTemporaryOrigin", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__persistenceType = IPC::ReadParam<PersistenceType>((&(reader__)));
            if (!maybe__persistenceType) {
                FatalError("Error deserializing 'PersistenceType'");
                return MsgValueError;

            }
            auto& persistenceType = *maybe__persistenceType;
            // Sentinel = 'persistenceType'
            if ((!(((&(reader__)))->ReadSentinel(853345864)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'PersistenceType'");
                return MsgValueError;
            }
            auto maybe__principalInfo = IPC::ReadParam<PrincipalInfo>((&(reader__)));
            if (!maybe__principalInfo) {
                FatalError("Error deserializing 'PrincipalInfo'");
                return MsgValueError;

            }
            auto& principalInfo = *maybe__principalInfo;
            // Sentinel = 'principalInfo'
            if ((!(((&(reader__)))->ReadSentinel(633472335)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'PrincipalInfo'");
                return MsgValueError;
            }
            auto maybe__createIfNonExistent = IPC::ReadParam<bool>((&(reader__)));
            if (!maybe__createIfNonExistent) {
                FatalError("Error deserializing 'bool'");
                return MsgValueError;

            }
            auto& createIfNonExistent = *maybe__createIfNonExistent;
            // Sentinel = 'createIfNonExistent'
            if ((!(((&(reader__)))->ReadSentinel(1258686371)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'bool'");
                return MsgValueError;
            }
            reader__.EndRead();
            int32_t id__ = Id();
            UniquePtr<IPC::Message> reply__(PQuota::Reply_InitializeTemporaryOrigin(id__));
            reply__->set_seqno(msg__.seqno());

            RefPtr<mozilla::ipc::IPDLResolverInner> resolver__ =
                new mozilla::ipc::IPDLResolverInner(std::move(reply__), this);

            InitializeTemporaryOriginResolver resolver = [resolver__ = std::move(resolver__)](const BoolResponse& aParam) {
                resolver__->Resolve([&] (IPC::Message* reply__, IProtocol* self__) {
                    IPC::MessageWriter writer__(*reply__, self__);
                    IPC::WriteParam((&(writer__)), aParam);
                    // Sentinel = 'response'
                    ((&(writer__)))->WriteSentinel(260965232);

                    if (mozilla::ipc::LoggingEnabledFor("PQuota", mozilla::ipc::ParentSide)) {
                        mozilla::ipc::LogMessageForProtocol(
                            "PQuotaParent",
                            self__->ToplevelProtocol()->OtherPidMaybeInvalid(),
                            "Sending reply ",
                            reply__->type(),
                            mozilla::ipc::MessageDirection::eSending);
                    }

                });
            };
            mozilla::ipc::IPCResult __ok = (this)->RecvInitializeTemporaryOrigin(std::move(persistenceType), std::move(principalInfo), std::move(createIfNonExistent), std::move(resolver));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PQuota::Msg_InitializePersistentClient__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PQuota", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PQuotaParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PQuota::Msg_InitializePersistentClient", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__principalInfo = IPC::ReadParam<PrincipalInfo>((&(reader__)));
            if (!maybe__principalInfo) {
                FatalError("Error deserializing 'PrincipalInfo'");
                return MsgValueError;

            }
            auto& principalInfo = *maybe__principalInfo;
            // Sentinel = 'principalInfo'
            if ((!(((&(reader__)))->ReadSentinel(633472335)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'PrincipalInfo'");
                return MsgValueError;
            }
            auto maybe__clientType = IPC::ReadParam<Type>((&(reader__)));
            if (!maybe__clientType) {
                FatalError("Error deserializing 'Type'");
                return MsgValueError;

            }
            auto& clientType = *maybe__clientType;
            // Sentinel = 'clientType'
            if ((!(((&(reader__)))->ReadSentinel(378995746)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'Type'");
                return MsgValueError;
            }
            reader__.EndRead();
            int32_t id__ = Id();
            UniquePtr<IPC::Message> reply__(PQuota::Reply_InitializePersistentClient(id__));
            reply__->set_seqno(msg__.seqno());

            RefPtr<mozilla::ipc::IPDLResolverInner> resolver__ =
                new mozilla::ipc::IPDLResolverInner(std::move(reply__), this);

            InitializePersistentClientResolver resolver = [resolver__ = std::move(resolver__)](const BoolResponse& aParam) {
                resolver__->Resolve([&] (IPC::Message* reply__, IProtocol* self__) {
                    IPC::MessageWriter writer__(*reply__, self__);
                    IPC::WriteParam((&(writer__)), aParam);
                    // Sentinel = 'response'
                    ((&(writer__)))->WriteSentinel(260965232);

                    if (mozilla::ipc::LoggingEnabledFor("PQuota", mozilla::ipc::ParentSide)) {
                        mozilla::ipc::LogMessageForProtocol(
                            "PQuotaParent",
                            self__->ToplevelProtocol()->OtherPidMaybeInvalid(),
                            "Sending reply ",
                            reply__->type(),
                            mozilla::ipc::MessageDirection::eSending);
                    }

                });
            };
            mozilla::ipc::IPCResult __ok = (this)->RecvInitializePersistentClient(std::move(principalInfo), std::move(clientType), std::move(resolver));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PQuota::Msg_InitializeTemporaryClient__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PQuota", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PQuotaParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PQuota::Msg_InitializeTemporaryClient", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__persistenceType = IPC::ReadParam<PersistenceType>((&(reader__)));
            if (!maybe__persistenceType) {
                FatalError("Error deserializing 'PersistenceType'");
                return MsgValueError;

            }
            auto& persistenceType = *maybe__persistenceType;
            // Sentinel = 'persistenceType'
            if ((!(((&(reader__)))->ReadSentinel(853345864)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'PersistenceType'");
                return MsgValueError;
            }
            auto maybe__principalInfo = IPC::ReadParam<PrincipalInfo>((&(reader__)));
            if (!maybe__principalInfo) {
                FatalError("Error deserializing 'PrincipalInfo'");
                return MsgValueError;

            }
            auto& principalInfo = *maybe__principalInfo;
            // Sentinel = 'principalInfo'
            if ((!(((&(reader__)))->ReadSentinel(633472335)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'PrincipalInfo'");
                return MsgValueError;
            }
            auto maybe__clientType = IPC::ReadParam<Type>((&(reader__)));
            if (!maybe__clientType) {
                FatalError("Error deserializing 'Type'");
                return MsgValueError;

            }
            auto& clientType = *maybe__clientType;
            // Sentinel = 'clientType'
            if ((!(((&(reader__)))->ReadSentinel(378995746)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'Type'");
                return MsgValueError;
            }
            reader__.EndRead();
            int32_t id__ = Id();
            UniquePtr<IPC::Message> reply__(PQuota::Reply_InitializeTemporaryClient(id__));
            reply__->set_seqno(msg__.seqno());

            RefPtr<mozilla::ipc::IPDLResolverInner> resolver__ =
                new mozilla::ipc::IPDLResolverInner(std::move(reply__), this);

            InitializeTemporaryClientResolver resolver = [resolver__ = std::move(resolver__)](const BoolResponse& aParam) {
                resolver__->Resolve([&] (IPC::Message* reply__, IProtocol* self__) {
                    IPC::MessageWriter writer__(*reply__, self__);
                    IPC::WriteParam((&(writer__)), aParam);
                    // Sentinel = 'response'
                    ((&(writer__)))->WriteSentinel(260965232);

                    if (mozilla::ipc::LoggingEnabledFor("PQuota", mozilla::ipc::ParentSide)) {
                        mozilla::ipc::LogMessageForProtocol(
                            "PQuotaParent",
                            self__->ToplevelProtocol()->OtherPidMaybeInvalid(),
                            "Sending reply ",
                            reply__->type(),
                            mozilla::ipc::MessageDirection::eSending);
                    }

                });
            };
            mozilla::ipc::IPCResult __ok = (this)->RecvInitializeTemporaryClient(std::move(persistenceType), std::move(principalInfo), std::move(clientType), std::move(resolver));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PQuota::Msg_InitializeTemporaryStorage__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PQuota", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PQuotaParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PQuota::Msg_InitializeTemporaryStorage", OTHER);

            int32_t id__ = Id();
            UniquePtr<IPC::Message> reply__(PQuota::Reply_InitializeTemporaryStorage(id__));
            reply__->set_seqno(msg__.seqno());

            RefPtr<mozilla::ipc::IPDLResolverInner> resolver__ =
                new mozilla::ipc::IPDLResolverInner(std::move(reply__), this);

            InitializeTemporaryStorageResolver resolver = [resolver__ = std::move(resolver__)](const BoolResponse& aParam) {
                resolver__->Resolve([&] (IPC::Message* reply__, IProtocol* self__) {
                    IPC::MessageWriter writer__(*reply__, self__);
                    IPC::WriteParam((&(writer__)), aParam);
                    // Sentinel = 'response'
                    ((&(writer__)))->WriteSentinel(260965232);

                    if (mozilla::ipc::LoggingEnabledFor("PQuota", mozilla::ipc::ParentSide)) {
                        mozilla::ipc::LogMessageForProtocol(
                            "PQuotaParent",
                            self__->ToplevelProtocol()->OtherPidMaybeInvalid(),
                            "Sending reply ",
                            reply__->type(),
                            mozilla::ipc::MessageDirection::eSending);
                    }

                });
            };
            mozilla::ipc::IPCResult __ok = (this)->RecvInitializeTemporaryStorage(std::move(resolver));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PQuota::Msg_GetUsage__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PQuota", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PQuotaParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PQuota::Msg_GetUsage", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__getAll = IPC::ReadParam<bool>((&(reader__)));
            if (!maybe__getAll) {
                FatalError("Error deserializing 'bool'");
                return MsgValueError;

            }
            auto& getAll = *maybe__getAll;
            // Sentinel = 'getAll'
            if ((!(((&(reader__)))->ReadSentinel(138412634)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'bool'");
                return MsgValueError;
            }
            auto maybe__parentEndpoint = IPC::ReadParam<ManagedEndpoint<::mozilla::dom::quota::PQuotaUsageRequestParent>>((&(reader__)));
            if (!maybe__parentEndpoint) {
                FatalError("Error deserializing 'ManagedEndpoint<::mozilla::dom::quota::PQuotaUsageRequestParent>'");
                return MsgValueError;

            }
            auto& parentEndpoint = *maybe__parentEndpoint;
            // Sentinel = 'parentEndpoint'
            if ((!(((&(reader__)))->ReadSentinel(723715532)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'ManagedEndpoint<::mozilla::dom::quota::PQuotaUsageRequestParent>'");
                return MsgValueError;
            }
            reader__.EndRead();
            int32_t id__ = Id();
            UniquePtr<IPC::Message> reply__(PQuota::Reply_GetUsage(id__));
            reply__->set_seqno(msg__.seqno());

            RefPtr<mozilla::ipc::IPDLResolverInner> resolver__ =
                new mozilla::ipc::IPDLResolverInner(std::move(reply__), this);

            GetUsageResolver resolver = [resolver__ = std::move(resolver__)](OriginUsageMetadataArrayResponse&& aParam) {
                resolver__->Resolve([&] (IPC::Message* reply__, IProtocol* self__) {
                    IPC::MessageWriter writer__(*reply__, self__);
                    IPC::WriteParam((&(writer__)), std::move(aParam));
                    // Sentinel = 'response'
                    ((&(writer__)))->WriteSentinel(260965232);

                    if (mozilla::ipc::LoggingEnabledFor("PQuota", mozilla::ipc::ParentSide)) {
                        mozilla::ipc::LogMessageForProtocol(
                            "PQuotaParent",
                            self__->ToplevelProtocol()->OtherPidMaybeInvalid(),
                            "Sending reply ",
                            reply__->type(),
                            mozilla::ipc::MessageDirection::eSending);
                    }

                });
            };
            mozilla::ipc::IPCResult __ok = (this)->RecvGetUsage(std::move(getAll), std::move(parentEndpoint), std::move(resolver));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PQuota::Msg_GetOriginUsage__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PQuota", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PQuotaParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PQuota::Msg_GetOriginUsage", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__principalInfo = IPC::ReadParam<PrincipalInfo>((&(reader__)));
            if (!maybe__principalInfo) {
                FatalError("Error deserializing 'PrincipalInfo'");
                return MsgValueError;

            }
            auto& principalInfo = *maybe__principalInfo;
            // Sentinel = 'principalInfo'
            if ((!(((&(reader__)))->ReadSentinel(633472335)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'PrincipalInfo'");
                return MsgValueError;
            }
            auto maybe__parentEndpoint = IPC::ReadParam<ManagedEndpoint<::mozilla::dom::quota::PQuotaUsageRequestParent>>((&(reader__)));
            if (!maybe__parentEndpoint) {
                FatalError("Error deserializing 'ManagedEndpoint<::mozilla::dom::quota::PQuotaUsageRequestParent>'");
                return MsgValueError;

            }
            auto& parentEndpoint = *maybe__parentEndpoint;
            // Sentinel = 'parentEndpoint'
            if ((!(((&(reader__)))->ReadSentinel(723715532)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'ManagedEndpoint<::mozilla::dom::quota::PQuotaUsageRequestParent>'");
                return MsgValueError;
            }
            reader__.EndRead();
            int32_t id__ = Id();
            UniquePtr<IPC::Message> reply__(PQuota::Reply_GetOriginUsage(id__));
            reply__->set_seqno(msg__.seqno());

            RefPtr<mozilla::ipc::IPDLResolverInner> resolver__ =
                new mozilla::ipc::IPDLResolverInner(std::move(reply__), this);

            GetOriginUsageResolver resolver = [resolver__ = std::move(resolver__)](const UsageInfoResponse& aParam) {
                resolver__->Resolve([&] (IPC::Message* reply__, IProtocol* self__) {
                    IPC::MessageWriter writer__(*reply__, self__);
                    IPC::WriteParam((&(writer__)), aParam);
                    // Sentinel = 'response'
                    ((&(writer__)))->WriteSentinel(260965232);

                    if (mozilla::ipc::LoggingEnabledFor("PQuota", mozilla::ipc::ParentSide)) {
                        mozilla::ipc::LogMessageForProtocol(
                            "PQuotaParent",
                            self__->ToplevelProtocol()->OtherPidMaybeInvalid(),
                            "Sending reply ",
                            reply__->type(),
                            mozilla::ipc::MessageDirection::eSending);
                    }

                });
            };
            mozilla::ipc::IPCResult __ok = (this)->RecvGetOriginUsage(std::move(principalInfo), std::move(parentEndpoint), std::move(resolver));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PQuota::Msg_GetCachedOriginUsage__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PQuota", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PQuotaParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PQuota::Msg_GetCachedOriginUsage", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__principalInfo = IPC::ReadParam<PrincipalInfo>((&(reader__)));
            if (!maybe__principalInfo) {
                FatalError("Error deserializing 'PrincipalInfo'");
                return MsgValueError;

            }
            auto& principalInfo = *maybe__principalInfo;
            // Sentinel = 'principalInfo'
            if ((!(((&(reader__)))->ReadSentinel(633472335)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'PrincipalInfo'");
                return MsgValueError;
            }
            reader__.EndRead();
            int32_t id__ = Id();
            UniquePtr<IPC::Message> reply__(PQuota::Reply_GetCachedOriginUsage(id__));
            reply__->set_seqno(msg__.seqno());

            RefPtr<mozilla::ipc::IPDLResolverInner> resolver__ =
                new mozilla::ipc::IPDLResolverInner(std::move(reply__), this);

            GetCachedOriginUsageResolver resolver = [resolver__ = std::move(resolver__)](const UInt64Response& aParam) {
                resolver__->Resolve([&] (IPC::Message* reply__, IProtocol* self__) {
                    IPC::MessageWriter writer__(*reply__, self__);
                    IPC::WriteParam((&(writer__)), aParam);
                    // Sentinel = 'response'
                    ((&(writer__)))->WriteSentinel(260965232);

                    if (mozilla::ipc::LoggingEnabledFor("PQuota", mozilla::ipc::ParentSide)) {
                        mozilla::ipc::LogMessageForProtocol(
                            "PQuotaParent",
                            self__->ToplevelProtocol()->OtherPidMaybeInvalid(),
                            "Sending reply ",
                            reply__->type(),
                            mozilla::ipc::MessageDirection::eSending);
                    }

                });
            };
            mozilla::ipc::IPCResult __ok = (this)->RecvGetCachedOriginUsage(std::move(principalInfo), std::move(resolver));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PQuota::Msg_ListOrigins__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PQuota", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PQuotaParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PQuota::Msg_ListOrigins", OTHER);

            int32_t id__ = Id();
            UniquePtr<IPC::Message> reply__(PQuota::Reply_ListOrigins(id__));
            reply__->set_seqno(msg__.seqno());

            RefPtr<mozilla::ipc::IPDLResolverInner> resolver__ =
                new mozilla::ipc::IPDLResolverInner(std::move(reply__), this);

            ListOriginsResolver resolver = [resolver__ = std::move(resolver__)](const CStringArrayResponse& aParam) {
                resolver__->Resolve([&] (IPC::Message* reply__, IProtocol* self__) {
                    IPC::MessageWriter writer__(*reply__, self__);
                    IPC::WriteParam((&(writer__)), aParam);
                    // Sentinel = 'response'
                    ((&(writer__)))->WriteSentinel(260965232);

                    if (mozilla::ipc::LoggingEnabledFor("PQuota", mozilla::ipc::ParentSide)) {
                        mozilla::ipc::LogMessageForProtocol(
                            "PQuotaParent",
                            self__->ToplevelProtocol()->OtherPidMaybeInvalid(),
                            "Sending reply ",
                            reply__->type(),
                            mozilla::ipc::MessageDirection::eSending);
                    }

                });
            };
            mozilla::ipc::IPCResult __ok = (this)->RecvListOrigins(std::move(resolver));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PQuota::Msg_ListCachedOrigins__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PQuota", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PQuotaParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PQuota::Msg_ListCachedOrigins", OTHER);

            int32_t id__ = Id();
            UniquePtr<IPC::Message> reply__(PQuota::Reply_ListCachedOrigins(id__));
            reply__->set_seqno(msg__.seqno());

            RefPtr<mozilla::ipc::IPDLResolverInner> resolver__ =
                new mozilla::ipc::IPDLResolverInner(std::move(reply__), this);

            ListCachedOriginsResolver resolver = [resolver__ = std::move(resolver__)](const CStringArrayResponse& aParam) {
                resolver__->Resolve([&] (IPC::Message* reply__, IProtocol* self__) {
                    IPC::MessageWriter writer__(*reply__, self__);
                    IPC::WriteParam((&(writer__)), aParam);
                    // Sentinel = 'response'
                    ((&(writer__)))->WriteSentinel(260965232);

                    if (mozilla::ipc::LoggingEnabledFor("PQuota", mozilla::ipc::ParentSide)) {
                        mozilla::ipc::LogMessageForProtocol(
                            "PQuotaParent",
                            self__->ToplevelProtocol()->OtherPidMaybeInvalid(),
                            "Sending reply ",
                            reply__->type(),
                            mozilla::ipc::MessageDirection::eSending);
                    }

                });
            };
            mozilla::ipc::IPCResult __ok = (this)->RecvListCachedOrigins(std::move(resolver));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PQuota::Msg_ClearStoragesForOrigin__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PQuota", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PQuotaParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PQuota::Msg_ClearStoragesForOrigin", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__persistenceType = IPC::ReadParam<mozilla::Maybe<PersistenceType>>((&(reader__)));
            if (!maybe__persistenceType) {
                FatalError("Error deserializing 'PersistenceType?'");
                return MsgValueError;

            }
            auto& persistenceType = *maybe__persistenceType;
            // Sentinel = 'persistenceType'
            if ((!(((&(reader__)))->ReadSentinel(853345864)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'PersistenceType?'");
                return MsgValueError;
            }
            auto maybe__principalInfo = IPC::ReadParam<PrincipalInfo>((&(reader__)));
            if (!maybe__principalInfo) {
                FatalError("Error deserializing 'PrincipalInfo'");
                return MsgValueError;

            }
            auto& principalInfo = *maybe__principalInfo;
            // Sentinel = 'principalInfo'
            if ((!(((&(reader__)))->ReadSentinel(633472335)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'PrincipalInfo'");
                return MsgValueError;
            }
            reader__.EndRead();
            int32_t id__ = Id();
            UniquePtr<IPC::Message> reply__(PQuota::Reply_ClearStoragesForOrigin(id__));
            reply__->set_seqno(msg__.seqno());

            RefPtr<mozilla::ipc::IPDLResolverInner> resolver__ =
                new mozilla::ipc::IPDLResolverInner(std::move(reply__), this);

            ClearStoragesForOriginResolver resolver = [resolver__ = std::move(resolver__)](const BoolResponse& aParam) {
                resolver__->Resolve([&] (IPC::Message* reply__, IProtocol* self__) {
                    IPC::MessageWriter writer__(*reply__, self__);
                    IPC::WriteParam((&(writer__)), aParam);
                    // Sentinel = 'response'
                    ((&(writer__)))->WriteSentinel(260965232);

                    if (mozilla::ipc::LoggingEnabledFor("PQuota", mozilla::ipc::ParentSide)) {
                        mozilla::ipc::LogMessageForProtocol(
                            "PQuotaParent",
                            self__->ToplevelProtocol()->OtherPidMaybeInvalid(),
                            "Sending reply ",
                            reply__->type(),
                            mozilla::ipc::MessageDirection::eSending);
                    }

                });
            };
            mozilla::ipc::IPCResult __ok = (this)->RecvClearStoragesForOrigin(std::move(persistenceType), std::move(principalInfo), std::move(resolver));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PQuota::Msg_ClearStoragesForClient__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PQuota", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PQuotaParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PQuota::Msg_ClearStoragesForClient", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__persistenceType = IPC::ReadParam<mozilla::Maybe<PersistenceType>>((&(reader__)));
            if (!maybe__persistenceType) {
                FatalError("Error deserializing 'PersistenceType?'");
                return MsgValueError;

            }
            auto& persistenceType = *maybe__persistenceType;
            // Sentinel = 'persistenceType'
            if ((!(((&(reader__)))->ReadSentinel(853345864)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'PersistenceType?'");
                return MsgValueError;
            }
            auto maybe__principalInfo = IPC::ReadParam<PrincipalInfo>((&(reader__)));
            if (!maybe__principalInfo) {
                FatalError("Error deserializing 'PrincipalInfo'");
                return MsgValueError;

            }
            auto& principalInfo = *maybe__principalInfo;
            // Sentinel = 'principalInfo'
            if ((!(((&(reader__)))->ReadSentinel(633472335)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'PrincipalInfo'");
                return MsgValueError;
            }
            auto maybe__clientType = IPC::ReadParam<Type>((&(reader__)));
            if (!maybe__clientType) {
                FatalError("Error deserializing 'Type'");
                return MsgValueError;

            }
            auto& clientType = *maybe__clientType;
            // Sentinel = 'clientType'
            if ((!(((&(reader__)))->ReadSentinel(378995746)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'Type'");
                return MsgValueError;
            }
            reader__.EndRead();
            int32_t id__ = Id();
            UniquePtr<IPC::Message> reply__(PQuota::Reply_ClearStoragesForClient(id__));
            reply__->set_seqno(msg__.seqno());

            RefPtr<mozilla::ipc::IPDLResolverInner> resolver__ =
                new mozilla::ipc::IPDLResolverInner(std::move(reply__), this);

            ClearStoragesForClientResolver resolver = [resolver__ = std::move(resolver__)](const BoolResponse& aParam) {
                resolver__->Resolve([&] (IPC::Message* reply__, IProtocol* self__) {
                    IPC::MessageWriter writer__(*reply__, self__);
                    IPC::WriteParam((&(writer__)), aParam);
                    // Sentinel = 'response'
                    ((&(writer__)))->WriteSentinel(260965232);

                    if (mozilla::ipc::LoggingEnabledFor("PQuota", mozilla::ipc::ParentSide)) {
                        mozilla::ipc::LogMessageForProtocol(
                            "PQuotaParent",
                            self__->ToplevelProtocol()->OtherPidMaybeInvalid(),
                            "Sending reply ",
                            reply__->type(),
                            mozilla::ipc::MessageDirection::eSending);
                    }

                });
            };
            mozilla::ipc::IPCResult __ok = (this)->RecvClearStoragesForClient(std::move(persistenceType), std::move(principalInfo), std::move(clientType), std::move(resolver));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PQuota::Msg_ClearStoragesForOriginPrefix__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PQuota", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PQuotaParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PQuota::Msg_ClearStoragesForOriginPrefix", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__persistenceType = IPC::ReadParam<mozilla::Maybe<PersistenceType>>((&(reader__)));
            if (!maybe__persistenceType) {
                FatalError("Error deserializing 'PersistenceType?'");
                return MsgValueError;

            }
            auto& persistenceType = *maybe__persistenceType;
            // Sentinel = 'persistenceType'
            if ((!(((&(reader__)))->ReadSentinel(853345864)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'PersistenceType?'");
                return MsgValueError;
            }
            auto maybe__principalInfo = IPC::ReadParam<PrincipalInfo>((&(reader__)));
            if (!maybe__principalInfo) {
                FatalError("Error deserializing 'PrincipalInfo'");
                return MsgValueError;

            }
            auto& principalInfo = *maybe__principalInfo;
            // Sentinel = 'principalInfo'
            if ((!(((&(reader__)))->ReadSentinel(633472335)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'PrincipalInfo'");
                return MsgValueError;
            }
            reader__.EndRead();
            int32_t id__ = Id();
            UniquePtr<IPC::Message> reply__(PQuota::Reply_ClearStoragesForOriginPrefix(id__));
            reply__->set_seqno(msg__.seqno());

            RefPtr<mozilla::ipc::IPDLResolverInner> resolver__ =
                new mozilla::ipc::IPDLResolverInner(std::move(reply__), this);

            ClearStoragesForOriginPrefixResolver resolver = [resolver__ = std::move(resolver__)](const BoolResponse& aParam) {
                resolver__->Resolve([&] (IPC::Message* reply__, IProtocol* self__) {
                    IPC::MessageWriter writer__(*reply__, self__);
                    IPC::WriteParam((&(writer__)), aParam);
                    // Sentinel = 'response'
                    ((&(writer__)))->WriteSentinel(260965232);

                    if (mozilla::ipc::LoggingEnabledFor("PQuota", mozilla::ipc::ParentSide)) {
                        mozilla::ipc::LogMessageForProtocol(
                            "PQuotaParent",
                            self__->ToplevelProtocol()->OtherPidMaybeInvalid(),
                            "Sending reply ",
                            reply__->type(),
                            mozilla::ipc::MessageDirection::eSending);
                    }

                });
            };
            mozilla::ipc::IPCResult __ok = (this)->RecvClearStoragesForOriginPrefix(std::move(persistenceType), std::move(principalInfo), std::move(resolver));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PQuota::Msg_ClearStoragesForOriginAttributesPattern__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PQuota", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PQuotaParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PQuota::Msg_ClearStoragesForOriginAttributesPattern", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__pattern = IPC::ReadParam<OriginAttributesPattern>((&(reader__)));
            if (!maybe__pattern) {
                FatalError("Error deserializing 'OriginAttributesPattern'");
                return MsgValueError;

            }
            auto& pattern = *maybe__pattern;
            // Sentinel = 'pattern'
            if ((!(((&(reader__)))->ReadSentinel(200409855)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'OriginAttributesPattern'");
                return MsgValueError;
            }
            reader__.EndRead();
            int32_t id__ = Id();
            UniquePtr<IPC::Message> reply__(PQuota::Reply_ClearStoragesForOriginAttributesPattern(id__));
            reply__->set_seqno(msg__.seqno());

            RefPtr<mozilla::ipc::IPDLResolverInner> resolver__ =
                new mozilla::ipc::IPDLResolverInner(std::move(reply__), this);

            ClearStoragesForOriginAttributesPatternResolver resolver = [resolver__ = std::move(resolver__)](const BoolResponse& aParam) {
                resolver__->Resolve([&] (IPC::Message* reply__, IProtocol* self__) {
                    IPC::MessageWriter writer__(*reply__, self__);
                    IPC::WriteParam((&(writer__)), aParam);
                    // Sentinel = 'response'
                    ((&(writer__)))->WriteSentinel(260965232);

                    if (mozilla::ipc::LoggingEnabledFor("PQuota", mozilla::ipc::ParentSide)) {
                        mozilla::ipc::LogMessageForProtocol(
                            "PQuotaParent",
                            self__->ToplevelProtocol()->OtherPidMaybeInvalid(),
                            "Sending reply ",
                            reply__->type(),
                            mozilla::ipc::MessageDirection::eSending);
                    }

                });
            };
            mozilla::ipc::IPCResult __ok = (this)->RecvClearStoragesForOriginAttributesPattern(std::move(pattern), std::move(resolver));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PQuota::Msg_ClearStoragesForPrivateBrowsing__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PQuota", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PQuotaParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PQuota::Msg_ClearStoragesForPrivateBrowsing", OTHER);

            int32_t id__ = Id();
            UniquePtr<IPC::Message> reply__(PQuota::Reply_ClearStoragesForPrivateBrowsing(id__));
            reply__->set_seqno(msg__.seqno());

            RefPtr<mozilla::ipc::IPDLResolverInner> resolver__ =
                new mozilla::ipc::IPDLResolverInner(std::move(reply__), this);

            ClearStoragesForPrivateBrowsingResolver resolver = [resolver__ = std::move(resolver__)](const BoolResponse& aParam) {
                resolver__->Resolve([&] (IPC::Message* reply__, IProtocol* self__) {
                    IPC::MessageWriter writer__(*reply__, self__);
                    IPC::WriteParam((&(writer__)), aParam);
                    // Sentinel = 'response'
                    ((&(writer__)))->WriteSentinel(260965232);

                    if (mozilla::ipc::LoggingEnabledFor("PQuota", mozilla::ipc::ParentSide)) {
                        mozilla::ipc::LogMessageForProtocol(
                            "PQuotaParent",
                            self__->ToplevelProtocol()->OtherPidMaybeInvalid(),
                            "Sending reply ",
                            reply__->type(),
                            mozilla::ipc::MessageDirection::eSending);
                    }

                });
            };
            mozilla::ipc::IPCResult __ok = (this)->RecvClearStoragesForPrivateBrowsing(std::move(resolver));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PQuota::Msg_ClearStorage__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PQuota", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PQuotaParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PQuota::Msg_ClearStorage", OTHER);

            int32_t id__ = Id();
            UniquePtr<IPC::Message> reply__(PQuota::Reply_ClearStorage(id__));
            reply__->set_seqno(msg__.seqno());

            RefPtr<mozilla::ipc::IPDLResolverInner> resolver__ =
                new mozilla::ipc::IPDLResolverInner(std::move(reply__), this);

            ClearStorageResolver resolver = [resolver__ = std::move(resolver__)](const BoolResponse& aParam) {
                resolver__->Resolve([&] (IPC::Message* reply__, IProtocol* self__) {
                    IPC::MessageWriter writer__(*reply__, self__);
                    IPC::WriteParam((&(writer__)), aParam);
                    // Sentinel = 'response'
                    ((&(writer__)))->WriteSentinel(260965232);

                    if (mozilla::ipc::LoggingEnabledFor("PQuota", mozilla::ipc::ParentSide)) {
                        mozilla::ipc::LogMessageForProtocol(
                            "PQuotaParent",
                            self__->ToplevelProtocol()->OtherPidMaybeInvalid(),
                            "Sending reply ",
                            reply__->type(),
                            mozilla::ipc::MessageDirection::eSending);
                    }

                });
            };
            mozilla::ipc::IPCResult __ok = (this)->RecvClearStorage(std::move(resolver));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PQuota::Msg_ShutdownStoragesForOrigin__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PQuota", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PQuotaParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PQuota::Msg_ShutdownStoragesForOrigin", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__persistenceType = IPC::ReadParam<mozilla::Maybe<PersistenceType>>((&(reader__)));
            if (!maybe__persistenceType) {
                FatalError("Error deserializing 'PersistenceType?'");
                return MsgValueError;

            }
            auto& persistenceType = *maybe__persistenceType;
            // Sentinel = 'persistenceType'
            if ((!(((&(reader__)))->ReadSentinel(853345864)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'PersistenceType?'");
                return MsgValueError;
            }
            auto maybe__principalInfo = IPC::ReadParam<PrincipalInfo>((&(reader__)));
            if (!maybe__principalInfo) {
                FatalError("Error deserializing 'PrincipalInfo'");
                return MsgValueError;

            }
            auto& principalInfo = *maybe__principalInfo;
            // Sentinel = 'principalInfo'
            if ((!(((&(reader__)))->ReadSentinel(633472335)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'PrincipalInfo'");
                return MsgValueError;
            }
            reader__.EndRead();
            int32_t id__ = Id();
            UniquePtr<IPC::Message> reply__(PQuota::Reply_ShutdownStoragesForOrigin(id__));
            reply__->set_seqno(msg__.seqno());

            RefPtr<mozilla::ipc::IPDLResolverInner> resolver__ =
                new mozilla::ipc::IPDLResolverInner(std::move(reply__), this);

            ShutdownStoragesForOriginResolver resolver = [resolver__ = std::move(resolver__)](const BoolResponse& aParam) {
                resolver__->Resolve([&] (IPC::Message* reply__, IProtocol* self__) {
                    IPC::MessageWriter writer__(*reply__, self__);
                    IPC::WriteParam((&(writer__)), aParam);
                    // Sentinel = 'response'
                    ((&(writer__)))->WriteSentinel(260965232);

                    if (mozilla::ipc::LoggingEnabledFor("PQuota", mozilla::ipc::ParentSide)) {
                        mozilla::ipc::LogMessageForProtocol(
                            "PQuotaParent",
                            self__->ToplevelProtocol()->OtherPidMaybeInvalid(),
                            "Sending reply ",
                            reply__->type(),
                            mozilla::ipc::MessageDirection::eSending);
                    }

                });
            };
            mozilla::ipc::IPCResult __ok = (this)->RecvShutdownStoragesForOrigin(std::move(persistenceType), std::move(principalInfo), std::move(resolver));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PQuota::Msg_ShutdownStoragesForClient__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PQuota", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PQuotaParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PQuota::Msg_ShutdownStoragesForClient", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__persistenceType = IPC::ReadParam<mozilla::Maybe<PersistenceType>>((&(reader__)));
            if (!maybe__persistenceType) {
                FatalError("Error deserializing 'PersistenceType?'");
                return MsgValueError;

            }
            auto& persistenceType = *maybe__persistenceType;
            // Sentinel = 'persistenceType'
            if ((!(((&(reader__)))->ReadSentinel(853345864)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'PersistenceType?'");
                return MsgValueError;
            }
            auto maybe__principalInfo = IPC::ReadParam<PrincipalInfo>((&(reader__)));
            if (!maybe__principalInfo) {
                FatalError("Error deserializing 'PrincipalInfo'");
                return MsgValueError;

            }
            auto& principalInfo = *maybe__principalInfo;
            // Sentinel = 'principalInfo'
            if ((!(((&(reader__)))->ReadSentinel(633472335)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'PrincipalInfo'");
                return MsgValueError;
            }
            auto maybe__clientType = IPC::ReadParam<Type>((&(reader__)));
            if (!maybe__clientType) {
                FatalError("Error deserializing 'Type'");
                return MsgValueError;

            }
            auto& clientType = *maybe__clientType;
            // Sentinel = 'clientType'
            if ((!(((&(reader__)))->ReadSentinel(378995746)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'Type'");
                return MsgValueError;
            }
            reader__.EndRead();
            int32_t id__ = Id();
            UniquePtr<IPC::Message> reply__(PQuota::Reply_ShutdownStoragesForClient(id__));
            reply__->set_seqno(msg__.seqno());

            RefPtr<mozilla::ipc::IPDLResolverInner> resolver__ =
                new mozilla::ipc::IPDLResolverInner(std::move(reply__), this);

            ShutdownStoragesForClientResolver resolver = [resolver__ = std::move(resolver__)](const BoolResponse& aParam) {
                resolver__->Resolve([&] (IPC::Message* reply__, IProtocol* self__) {
                    IPC::MessageWriter writer__(*reply__, self__);
                    IPC::WriteParam((&(writer__)), aParam);
                    // Sentinel = 'response'
                    ((&(writer__)))->WriteSentinel(260965232);

                    if (mozilla::ipc::LoggingEnabledFor("PQuota", mozilla::ipc::ParentSide)) {
                        mozilla::ipc::LogMessageForProtocol(
                            "PQuotaParent",
                            self__->ToplevelProtocol()->OtherPidMaybeInvalid(),
                            "Sending reply ",
                            reply__->type(),
                            mozilla::ipc::MessageDirection::eSending);
                    }

                });
            };
            mozilla::ipc::IPCResult __ok = (this)->RecvShutdownStoragesForClient(std::move(persistenceType), std::move(principalInfo), std::move(clientType), std::move(resolver));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PQuota::Msg_ShutdownStorage__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PQuota", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PQuotaParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PQuota::Msg_ShutdownStorage", OTHER);

            int32_t id__ = Id();
            UniquePtr<IPC::Message> reply__(PQuota::Reply_ShutdownStorage(id__));
            reply__->set_seqno(msg__.seqno());

            RefPtr<mozilla::ipc::IPDLResolverInner> resolver__ =
                new mozilla::ipc::IPDLResolverInner(std::move(reply__), this);

            ShutdownStorageResolver resolver = [resolver__ = std::move(resolver__)](const BoolResponse& aParam) {
                resolver__->Resolve([&] (IPC::Message* reply__, IProtocol* self__) {
                    IPC::MessageWriter writer__(*reply__, self__);
                    IPC::WriteParam((&(writer__)), aParam);
                    // Sentinel = 'response'
                    ((&(writer__)))->WriteSentinel(260965232);

                    if (mozilla::ipc::LoggingEnabledFor("PQuota", mozilla::ipc::ParentSide)) {
                        mozilla::ipc::LogMessageForProtocol(
                            "PQuotaParent",
                            self__->ToplevelProtocol()->OtherPidMaybeInvalid(),
                            "Sending reply ",
                            reply__->type(),
                            mozilla::ipc::MessageDirection::eSending);
                    }

                });
            };
            mozilla::ipc::IPCResult __ok = (this)->RecvShutdownStorage(std::move(resolver));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PQuota::Msg_StartIdleMaintenance__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PQuota", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PQuotaParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PQuota::Msg_StartIdleMaintenance", OTHER);

            mozilla::ipc::IPCResult __ok = (this)->RecvStartIdleMaintenance();
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PQuota::Msg_StopIdleMaintenance__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PQuota", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PQuotaParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PQuota::Msg_StopIdleMaintenance", OTHER);

            mozilla::ipc::IPCResult __ok = (this)->RecvStopIdleMaintenance();
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PQuota::Msg_AbortOperationsForProcess__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PQuota", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PQuotaParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PQuota::Msg_AbortOperationsForProcess", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__contentParentId = IPC::ReadParam<ContentParentId>((&(reader__)));
            if (!maybe__contentParentId) {
                FatalError("Error deserializing 'ContentParentId'");
                return MsgValueError;

            }
            auto& contentParentId = *maybe__contentParentId;
            // Sentinel = 'contentParentId'
            if ((!(((&(reader__)))->ReadSentinel(830539283)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'ContentParentId'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::IPCResult __ok = (this)->RecvAbortOperationsForProcess(std::move(contentParentId));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PQuota::Msg_SetThumbnailPrivateIdentityId__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PQuota", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PQuotaParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PQuota::Msg_SetThumbnailPrivateIdentityId", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__aThumbnailPrivateIdentityId = IPC::ReadParam<uint32_t>((&(reader__)));
            if (!maybe__aThumbnailPrivateIdentityId) {
                FatalError("Error deserializing 'uint32_t'");
                return MsgValueError;

            }
            auto& aThumbnailPrivateIdentityId = *maybe__aThumbnailPrivateIdentityId;
            // Sentinel = 'aThumbnailPrivateIdentityId'
            if ((!(((&(reader__)))->ReadSentinel(2540636888)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'uint32_t'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::IPCResult __ok = (this)->RecvSetThumbnailPrivateIdentityId(std::move(aThumbnailPrivateIdentityId));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    default:
        return MsgNotKnown;
    }
}

auto PQuotaParent::OnMessageReceived(
        const Message& msg__,
        UniquePtr<Message>& reply__) -> PQuotaParent::Result
{
    return MsgNotKnown;
}



} // namespace quota
} // namespace dom
} // namespace mozilla
namespace IPC {
auto ParamTraits<::mozilla::dom::quota::PQuotaParent*>::Write(
        IPC::MessageWriter* aWriter,
        const paramType& aVar) -> void
{
    MOZ_RELEASE_ASSERT(
        aWriter->GetActor(),
        "Cannot serialize managed actors without an actor");

    int32_t id;
    if (!aVar) {
        id = 0;  // kNullActorId
    } else {
        id = aVar->Id();
        if (id == 1) {  // kFreedActorId
            aVar->FatalError("Actor has been |delete|d");
        }
        MOZ_RELEASE_ASSERT(
            aWriter->GetActor()->GetIPCChannel() == aVar->GetIPCChannel(),
            "Actor must be from the same channel as the"
            " actor it's being sent over");
        MOZ_RELEASE_ASSERT(
            aVar->CanSend(),
            "Actor must still be open when sending");
    }

    IPC::WriteParam(aWriter, id);
}

auto ParamTraits<::mozilla::dom::quota::PQuotaParent*>::Read(IPC::MessageReader* aReader) -> IPC::ReadResult<paramType>
{
    MOZ_RELEASE_ASSERT(
        aReader->GetActor(),
        "Cannot deserialize managed actors without an actor");
    mozilla::Maybe<mozilla::ipc::IProtocol*> actor = aReader->GetActor()
        ->ReadActor(aReader, true, "PQuota", PQuotaMsgStart);
    if (actor.isSome()) {
        return static_cast<::mozilla::dom::quota::PQuotaParent*>(actor.ref());
    }
    return {};
}

} // namespace IPC
