//
// Automatically generated by ipdlc.
// Edit at your own risk
//


#include "mozilla/dom/quota/PQuotaChild.h"
#include "mozilla/ProfilerLabels.h"
#include "mozilla/dom/DomSecurityIPCUtils.h"
#include "mozilla/dom/quota/SerializationHelpers.h"
#include "mozilla/ipc/IPCCore.h"

#include "mozilla/ipc/PBackgroundChild.h"
#include "mozilla/dom/quota/PQuotaRequestChild.h"
#include "mozilla/dom/quota/PQuotaUsageRequestChild.h"

#include "ipc/IPCMessageUtils.h"
#include "ipc/IPCMessageUtilsSpecializations.h"
#include "nsIFile.h"
#include "mozilla/ipc/Endpoint.h"
#include "mozilla/ipc/ProtocolMessageUtils.h"
#include "mozilla/ipc/ProtocolUtils.h"
#include "mozilla/ipc/ShmemMessageUtils.h"
#include "mozilla/ipc/TaintingIPCUtils.h"

namespace mozilla {
namespace dom {
namespace quota {


MOZ_IMPLICIT PQuotaChild::PQuotaChild() :
    mozilla::ipc::IRefCountedProtocol(kProtocolId, mozilla::ipc::ChildSide)
{
    MOZ_COUNT_CTOR(PQuotaChild);
}

PQuotaChild::~PQuotaChild()
{
    MOZ_COUNT_DTOR(PQuotaChild);
}

auto PQuotaChild::ActorAlloc() -> void
{
    AddRef();
}

auto PQuotaChild::ActorDealloc() -> void
{
    Release();
}

auto PQuotaChild::OtherPid() const -> ::base::ProcessId
{
    ::base::ProcessId pid =
        ::mozilla::ipc::IProtocol::ToplevelProtocol()->OtherPidMaybeInvalid();
    MOZ_RELEASE_ASSERT(pid != ::base::kInvalidProcessId);
    return pid;
}

auto PQuotaChild::OtherChildID() const -> ::GeckoChildID
{
    ::GeckoChildID childID =
        ::mozilla::ipc::IProtocol::ToplevelProtocol()->OtherChildIDMaybeInvalid();
    MOZ_RELEASE_ASSERT(childID != -1);
    return childID;
}

auto PQuotaChild::OtherEndpointProcInfo() const -> ::mozilla::ipc::EndpointProcInfo
{
    return ::mozilla::ipc::EndpointProcInfo{OtherPid(), OtherChildID()};
}

auto PQuotaChild::Manager() const -> PBackgroundChild*
{
    return static_cast<PBackgroundChild*>(IProtocol::Manager());
}

auto PQuotaChild::ManagedPQuotaRequestChild(nsTArray<PQuotaRequestChild*>& aArr) const -> void
{
    mManagedPQuotaRequestChild.ToArray(aArr);
}

auto PQuotaChild::ManagedPQuotaRequestChild() const -> const ManagedContainer<PQuotaRequestChild>&
{
    return mManagedPQuotaRequestChild;
}

auto PQuotaChild::ManagedPQuotaUsageRequestChild(nsTArray<PQuotaUsageRequestChild*>& aArr) const -> void
{
    mManagedPQuotaUsageRequestChild.ToArray(aArr);
}

auto PQuotaChild::ManagedPQuotaUsageRequestChild() const -> const ManagedContainer<PQuotaUsageRequestChild>&
{
    return mManagedPQuotaUsageRequestChild;
}

auto PQuotaChild::ManagedProtocolIds() const -> mozilla::Span<mozilla::ipc::ProtocolId const>
{
    static constexpr ::mozilla::ipc::ProtocolId sIds[] = {
        PQuotaRequestMsgStart,
        PQuotaUsageRequestMsgStart
    };
    return sIds;
}

auto PQuotaChild::GetManagedActors(mozilla::ipc::ProtocolId aProtocol) -> UntypedManagedContainer*
{
    switch (aProtocol) {
    case PQuotaRequestMsgStart:
        return (&(mManagedPQuotaRequestChild));
    case PQuotaUsageRequestMsgStart:
        return (&(mManagedPQuotaUsageRequestChild));
    default:
        return nullptr;
    }
}

auto PQuotaChild::RejectPendingResponses(ResponseRejectReason aReason) -> void
{
    mAsyncCallbacks.RejectPendingResponses(aReason);
}

auto PQuotaChild::OpenPQuotaRequestEndpoint(PQuotaRequestChild* aActor) -> ManagedEndpoint<PQuotaRequestParent>
{
    if (!aActor) {
        NS_WARNING("Cannot bind null PQuotaRequestChild actor");
        return ManagedEndpoint<PQuotaRequestParent>();
    }

    if (!aActor->SetManagerAndRegister(this)) {
        NS_WARNING("Failed to bind PQuotaRequestChild actor");
        return ManagedEndpoint<PQuotaRequestParent>();
    }

    // Mark our actor as awaiting the other side to be bound. This will
    // be cleared when a `MANAGED_ENDPOINT_{DROPPED,BOUND}` message is
    // received.
    aActor->mAwaitingManagedEndpointBind = true;
    return ManagedEndpoint<PQuotaRequestParent>(mozilla::ipc::PrivateIPDLInterface(), aActor);
}

auto PQuotaChild::BindPQuotaRequestEndpoint(
        ManagedEndpoint<PQuotaRequestChild> aEndpoint,
        PQuotaRequestChild* aActor) -> bool
{
    return aEndpoint.Bind(mozilla::ipc::PrivateIPDLInterface(), aActor, this);
}

auto PQuotaChild::OpenPQuotaUsageRequestEndpoint(PQuotaUsageRequestChild* aActor) -> ManagedEndpoint<PQuotaUsageRequestParent>
{
    if (!aActor) {
        NS_WARNING("Cannot bind null PQuotaUsageRequestChild actor");
        return ManagedEndpoint<PQuotaUsageRequestParent>();
    }

    if (!aActor->SetManagerAndRegister(this)) {
        NS_WARNING("Failed to bind PQuotaUsageRequestChild actor");
        return ManagedEndpoint<PQuotaUsageRequestParent>();
    }

    // Mark our actor as awaiting the other side to be bound. This will
    // be cleared when a `MANAGED_ENDPOINT_{DROPPED,BOUND}` message is
    // received.
    aActor->mAwaitingManagedEndpointBind = true;
    return ManagedEndpoint<PQuotaUsageRequestParent>(mozilla::ipc::PrivateIPDLInterface(), aActor);
}

auto PQuotaChild::BindPQuotaUsageRequestEndpoint(
        ManagedEndpoint<PQuotaUsageRequestChild> aEndpoint,
        PQuotaUsageRequestChild* aActor) -> bool
{
    return aEndpoint.Bind(mozilla::ipc::PrivateIPDLInterface(), aActor, this);
}

auto PQuotaChild::Send__delete__(PQuotaChild* actor) -> bool
{
    if (!actor || !actor->CanSend()) {
        NS_WARNING("Attempt to __delete__ missing or closed actor");
        return false;
    }
    UniquePtr<IPC::Message> msg__ = PQuota::Msg___delete__((actor)->Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            actor};




    if (mozilla::ipc::LoggingEnabledFor("PQuota", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PQuotaChild",
            actor->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PQuota::Msg___delete__", OTHER);

    bool sendok__ = (actor)->ChannelSend(std::move(msg__));

    actor->ActorDisconnected(Deletion);
    return sendok__;
}

auto PQuotaChild::SendPQuotaRequestConstructor(const RequestParams& params) -> PQuotaRequestChild*
{
    PQuotaRequestChild* actor = (this)->AllocPQuotaRequestChild(params);
    return SendPQuotaRequestConstructor(std::move(actor), std::move(params));
}

auto PQuotaChild::SendPQuotaRequestConstructor(
        PQuotaRequestChild* actor,
        const RequestParams& params) -> PQuotaRequestChild*
{
    if (!actor) {
        NS_WARNING("Cannot bind null PQuotaRequestChild actor");
        return nullptr;
    }

    if (!actor->SetManagerAndRegister(this)) {
        NS_WARNING("Failed to bind PQuotaRequestChild actor");
        return nullptr;
    }


    // Build our constructor message.
    UniquePtr<IPC::Message> msg__ = PQuota::Msg_PQuotaRequestConstructor(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), actor);
    // Sentinel = 'actor'
    ((&(writer__)))->WriteSentinel(102892058);
    IPC::WriteParam((&(writer__)), params);
    // Sentinel = 'params'
    ((&(writer__)))->WriteSentinel(146997893);




    // Notify the other side about the newly created actor. This can
    // fail if our manager has already been destroyed.
    //
    // NOTE: If the send call fails due to toplevel channel teardown,
    // the `IProtocol::ChannelSend` wrapper absorbs the error for us,
    // so we don't tear down actors unexpectedly.

    if (mozilla::ipc::LoggingEnabledFor("PQuota", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PQuotaChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PQuota::Msg_PQuotaRequestConstructor", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));


    // Warn, destroy the actor, and return null if the message failed to
    // send. Otherwise, return the successfully created actor reference.
    if (!sendok__) {
        NS_WARNING("Error sending PQuotaRequestChild constructor");
        actor->ActorDisconnected(FailedConstructor);

        return nullptr;
    }
    return actor;
}

auto PQuotaChild::SendStorageInitialized(
        mozilla::ipc::ResolveCallback<BoolResponse>&& aResolve,
        mozilla::ipc::RejectCallback&& aReject) -> void
{
    UniquePtr<IPC::Message> msg__ = PQuota::Msg_StorageInitialized(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};





    if (mozilla::ipc::LoggingEnabledFor("PQuota", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PQuotaChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PQuota::Msg_StorageInitialized", OTHER);

    int32_t seqno__ = 0;
    if (ChannelSend(std::move(msg__), (&(seqno__)))) {
        mAsyncCallbacks.AddCallback(seqno__, PQuota::Reply_StorageInitialized__ID, [resolve=std::move(aResolve)](IPC::MessageReader* aReader) mutable {
            auto maybe__response = IPC::ReadParam<BoolResponse>(aReader);
            if (!maybe__response) {
                (aReader)->FatalError("Error deserializing 'BoolResponse'");
                return MsgValueError;

            }
            auto& response = *maybe__response;
            // Sentinel = 'response'
            if ((!((aReader)->ReadSentinel(260965232)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'BoolResponse'");
                return MsgValueError;
            }


            aReader->EndRead();

            resolve(std::move(response));
            return MsgProcessed;
        }, std::move(aReject));
    }
    else {
        aReject(::mozilla::ipc::ResponseRejectReason::SendError);
    }
    return;
}

auto PQuotaChild::SendStorageInitialized() -> RefPtr<StorageInitializedPromise>
{
    RefPtr<MozPromise<BoolResponse, ResponseRejectReason, true>::Private> promise__ = new MozPromise<BoolResponse, ResponseRejectReason, true>::Private(__func__);
    promise__->UseDirectTaskDispatch(__func__);
    SendStorageInitialized([promise__](BoolResponse&& aValue) {
        promise__->Resolve(std::move(aValue), __func__);
    }, [promise__](ResponseRejectReason&& aReason) {
        promise__->Reject(std::move(aReason), __func__);
    });
    return promise__;
}

auto PQuotaChild::SendPersistentStorageInitialized(
        mozilla::ipc::ResolveCallback<BoolResponse>&& aResolve,
        mozilla::ipc::RejectCallback&& aReject) -> void
{
    UniquePtr<IPC::Message> msg__ = PQuota::Msg_PersistentStorageInitialized(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};





    if (mozilla::ipc::LoggingEnabledFor("PQuota", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PQuotaChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PQuota::Msg_PersistentStorageInitialized", OTHER);

    int32_t seqno__ = 0;
    if (ChannelSend(std::move(msg__), (&(seqno__)))) {
        mAsyncCallbacks.AddCallback(seqno__, PQuota::Reply_PersistentStorageInitialized__ID, [resolve=std::move(aResolve)](IPC::MessageReader* aReader) mutable {
            auto maybe__response = IPC::ReadParam<BoolResponse>(aReader);
            if (!maybe__response) {
                (aReader)->FatalError("Error deserializing 'BoolResponse'");
                return MsgValueError;

            }
            auto& response = *maybe__response;
            // Sentinel = 'response'
            if ((!((aReader)->ReadSentinel(260965232)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'BoolResponse'");
                return MsgValueError;
            }


            aReader->EndRead();

            resolve(std::move(response));
            return MsgProcessed;
        }, std::move(aReject));
    }
    else {
        aReject(::mozilla::ipc::ResponseRejectReason::SendError);
    }
    return;
}

auto PQuotaChild::SendPersistentStorageInitialized() -> RefPtr<PersistentStorageInitializedPromise>
{
    RefPtr<MozPromise<BoolResponse, ResponseRejectReason, true>::Private> promise__ = new MozPromise<BoolResponse, ResponseRejectReason, true>::Private(__func__);
    promise__->UseDirectTaskDispatch(__func__);
    SendPersistentStorageInitialized([promise__](BoolResponse&& aValue) {
        promise__->Resolve(std::move(aValue), __func__);
    }, [promise__](ResponseRejectReason&& aReason) {
        promise__->Reject(std::move(aReason), __func__);
    });
    return promise__;
}

auto PQuotaChild::SendTemporaryStorageInitialized(
        mozilla::ipc::ResolveCallback<BoolResponse>&& aResolve,
        mozilla::ipc::RejectCallback&& aReject) -> void
{
    UniquePtr<IPC::Message> msg__ = PQuota::Msg_TemporaryStorageInitialized(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};





    if (mozilla::ipc::LoggingEnabledFor("PQuota", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PQuotaChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PQuota::Msg_TemporaryStorageInitialized", OTHER);

    int32_t seqno__ = 0;
    if (ChannelSend(std::move(msg__), (&(seqno__)))) {
        mAsyncCallbacks.AddCallback(seqno__, PQuota::Reply_TemporaryStorageInitialized__ID, [resolve=std::move(aResolve)](IPC::MessageReader* aReader) mutable {
            auto maybe__response = IPC::ReadParam<BoolResponse>(aReader);
            if (!maybe__response) {
                (aReader)->FatalError("Error deserializing 'BoolResponse'");
                return MsgValueError;

            }
            auto& response = *maybe__response;
            // Sentinel = 'response'
            if ((!((aReader)->ReadSentinel(260965232)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'BoolResponse'");
                return MsgValueError;
            }


            aReader->EndRead();

            resolve(std::move(response));
            return MsgProcessed;
        }, std::move(aReject));
    }
    else {
        aReject(::mozilla::ipc::ResponseRejectReason::SendError);
    }
    return;
}

auto PQuotaChild::SendTemporaryStorageInitialized() -> RefPtr<TemporaryStorageInitializedPromise>
{
    RefPtr<MozPromise<BoolResponse, ResponseRejectReason, true>::Private> promise__ = new MozPromise<BoolResponse, ResponseRejectReason, true>::Private(__func__);
    promise__->UseDirectTaskDispatch(__func__);
    SendTemporaryStorageInitialized([promise__](BoolResponse&& aValue) {
        promise__->Resolve(std::move(aValue), __func__);
    }, [promise__](ResponseRejectReason&& aReason) {
        promise__->Reject(std::move(aReason), __func__);
    });
    return promise__;
}

auto PQuotaChild::SendTemporaryGroupInitialized(
        const PrincipalInfo& principalInfo,
        mozilla::ipc::ResolveCallback<BoolResponse>&& aResolve,
        mozilla::ipc::RejectCallback&& aReject) -> void
{
    UniquePtr<IPC::Message> msg__ = PQuota::Msg_TemporaryGroupInitialized(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), principalInfo);
    // Sentinel = 'principalInfo'
    ((&(writer__)))->WriteSentinel(633472335);




    if (mozilla::ipc::LoggingEnabledFor("PQuota", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PQuotaChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PQuota::Msg_TemporaryGroupInitialized", OTHER);

    int32_t seqno__ = 0;
    if (ChannelSend(std::move(msg__), (&(seqno__)))) {
        mAsyncCallbacks.AddCallback(seqno__, PQuota::Reply_TemporaryGroupInitialized__ID, [resolve=std::move(aResolve)](IPC::MessageReader* aReader) mutable {
            auto maybe__response = IPC::ReadParam<BoolResponse>(aReader);
            if (!maybe__response) {
                (aReader)->FatalError("Error deserializing 'BoolResponse'");
                return MsgValueError;

            }
            auto& response = *maybe__response;
            // Sentinel = 'response'
            if ((!((aReader)->ReadSentinel(260965232)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'BoolResponse'");
                return MsgValueError;
            }


            aReader->EndRead();

            resolve(std::move(response));
            return MsgProcessed;
        }, std::move(aReject));
    }
    else {
        aReject(::mozilla::ipc::ResponseRejectReason::SendError);
    }
    return;
}

auto PQuotaChild::SendTemporaryGroupInitialized(const PrincipalInfo& principalInfo) -> RefPtr<TemporaryGroupInitializedPromise>
{
    RefPtr<MozPromise<BoolResponse, ResponseRejectReason, true>::Private> promise__ = new MozPromise<BoolResponse, ResponseRejectReason, true>::Private(__func__);
    promise__->UseDirectTaskDispatch(__func__);
    SendTemporaryGroupInitialized(std::move(principalInfo), [promise__](BoolResponse&& aValue) {
        promise__->Resolve(std::move(aValue), __func__);
    }, [promise__](ResponseRejectReason&& aReason) {
        promise__->Reject(std::move(aReason), __func__);
    });
    return promise__;
}

auto PQuotaChild::SendPersistentOriginInitialized(
        const PrincipalInfo& principalInfo,
        mozilla::ipc::ResolveCallback<BoolResponse>&& aResolve,
        mozilla::ipc::RejectCallback&& aReject) -> void
{
    UniquePtr<IPC::Message> msg__ = PQuota::Msg_PersistentOriginInitialized(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), principalInfo);
    // Sentinel = 'principalInfo'
    ((&(writer__)))->WriteSentinel(633472335);




    if (mozilla::ipc::LoggingEnabledFor("PQuota", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PQuotaChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PQuota::Msg_PersistentOriginInitialized", OTHER);

    int32_t seqno__ = 0;
    if (ChannelSend(std::move(msg__), (&(seqno__)))) {
        mAsyncCallbacks.AddCallback(seqno__, PQuota::Reply_PersistentOriginInitialized__ID, [resolve=std::move(aResolve)](IPC::MessageReader* aReader) mutable {
            auto maybe__response = IPC::ReadParam<BoolResponse>(aReader);
            if (!maybe__response) {
                (aReader)->FatalError("Error deserializing 'BoolResponse'");
                return MsgValueError;

            }
            auto& response = *maybe__response;
            // Sentinel = 'response'
            if ((!((aReader)->ReadSentinel(260965232)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'BoolResponse'");
                return MsgValueError;
            }


            aReader->EndRead();

            resolve(std::move(response));
            return MsgProcessed;
        }, std::move(aReject));
    }
    else {
        aReject(::mozilla::ipc::ResponseRejectReason::SendError);
    }
    return;
}

auto PQuotaChild::SendPersistentOriginInitialized(const PrincipalInfo& principalInfo) -> RefPtr<PersistentOriginInitializedPromise>
{
    RefPtr<MozPromise<BoolResponse, ResponseRejectReason, true>::Private> promise__ = new MozPromise<BoolResponse, ResponseRejectReason, true>::Private(__func__);
    promise__->UseDirectTaskDispatch(__func__);
    SendPersistentOriginInitialized(std::move(principalInfo), [promise__](BoolResponse&& aValue) {
        promise__->Resolve(std::move(aValue), __func__);
    }, [promise__](ResponseRejectReason&& aReason) {
        promise__->Reject(std::move(aReason), __func__);
    });
    return promise__;
}

auto PQuotaChild::SendTemporaryOriginInitialized(
        const PersistenceType& persistenceType,
        const PrincipalInfo& principalInfo,
        mozilla::ipc::ResolveCallback<BoolResponse>&& aResolve,
        mozilla::ipc::RejectCallback&& aReject) -> void
{
    UniquePtr<IPC::Message> msg__ = PQuota::Msg_TemporaryOriginInitialized(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), persistenceType);
    // Sentinel = 'persistenceType'
    ((&(writer__)))->WriteSentinel(853345864);
    IPC::WriteParam((&(writer__)), principalInfo);
    // Sentinel = 'principalInfo'
    ((&(writer__)))->WriteSentinel(633472335);




    if (mozilla::ipc::LoggingEnabledFor("PQuota", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PQuotaChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PQuota::Msg_TemporaryOriginInitialized", OTHER);

    int32_t seqno__ = 0;
    if (ChannelSend(std::move(msg__), (&(seqno__)))) {
        mAsyncCallbacks.AddCallback(seqno__, PQuota::Reply_TemporaryOriginInitialized__ID, [resolve=std::move(aResolve)](IPC::MessageReader* aReader) mutable {
            auto maybe__response = IPC::ReadParam<BoolResponse>(aReader);
            if (!maybe__response) {
                (aReader)->FatalError("Error deserializing 'BoolResponse'");
                return MsgValueError;

            }
            auto& response = *maybe__response;
            // Sentinel = 'response'
            if ((!((aReader)->ReadSentinel(260965232)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'BoolResponse'");
                return MsgValueError;
            }


            aReader->EndRead();

            resolve(std::move(response));
            return MsgProcessed;
        }, std::move(aReject));
    }
    else {
        aReject(::mozilla::ipc::ResponseRejectReason::SendError);
    }
    return;
}

auto PQuotaChild::SendTemporaryOriginInitialized(
        const PersistenceType& persistenceType,
        const PrincipalInfo& principalInfo) -> RefPtr<TemporaryOriginInitializedPromise>
{
    RefPtr<MozPromise<BoolResponse, ResponseRejectReason, true>::Private> promise__ = new MozPromise<BoolResponse, ResponseRejectReason, true>::Private(__func__);
    promise__->UseDirectTaskDispatch(__func__);
    SendTemporaryOriginInitialized(std::move(persistenceType), std::move(principalInfo), [promise__](BoolResponse&& aValue) {
        promise__->Resolve(std::move(aValue), __func__);
    }, [promise__](ResponseRejectReason&& aReason) {
        promise__->Reject(std::move(aReason), __func__);
    });
    return promise__;
}

auto PQuotaChild::SendInitializeStorage(
        mozilla::ipc::ResolveCallback<BoolResponse>&& aResolve,
        mozilla::ipc::RejectCallback&& aReject) -> void
{
    UniquePtr<IPC::Message> msg__ = PQuota::Msg_InitializeStorage(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};





    if (mozilla::ipc::LoggingEnabledFor("PQuota", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PQuotaChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PQuota::Msg_InitializeStorage", OTHER);

    int32_t seqno__ = 0;
    if (ChannelSend(std::move(msg__), (&(seqno__)))) {
        mAsyncCallbacks.AddCallback(seqno__, PQuota::Reply_InitializeStorage__ID, [resolve=std::move(aResolve)](IPC::MessageReader* aReader) mutable {
            auto maybe__response = IPC::ReadParam<BoolResponse>(aReader);
            if (!maybe__response) {
                (aReader)->FatalError("Error deserializing 'BoolResponse'");
                return MsgValueError;

            }
            auto& response = *maybe__response;
            // Sentinel = 'response'
            if ((!((aReader)->ReadSentinel(260965232)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'BoolResponse'");
                return MsgValueError;
            }


            aReader->EndRead();

            resolve(std::move(response));
            return MsgProcessed;
        }, std::move(aReject));
    }
    else {
        aReject(::mozilla::ipc::ResponseRejectReason::SendError);
    }
    return;
}

auto PQuotaChild::SendInitializeStorage() -> RefPtr<InitializeStoragePromise>
{
    RefPtr<MozPromise<BoolResponse, ResponseRejectReason, true>::Private> promise__ = new MozPromise<BoolResponse, ResponseRejectReason, true>::Private(__func__);
    promise__->UseDirectTaskDispatch(__func__);
    SendInitializeStorage([promise__](BoolResponse&& aValue) {
        promise__->Resolve(std::move(aValue), __func__);
    }, [promise__](ResponseRejectReason&& aReason) {
        promise__->Reject(std::move(aReason), __func__);
    });
    return promise__;
}

auto PQuotaChild::SendInitializePersistentStorage(
        mozilla::ipc::ResolveCallback<BoolResponse>&& aResolve,
        mozilla::ipc::RejectCallback&& aReject) -> void
{
    UniquePtr<IPC::Message> msg__ = PQuota::Msg_InitializePersistentStorage(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};





    if (mozilla::ipc::LoggingEnabledFor("PQuota", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PQuotaChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PQuota::Msg_InitializePersistentStorage", OTHER);

    int32_t seqno__ = 0;
    if (ChannelSend(std::move(msg__), (&(seqno__)))) {
        mAsyncCallbacks.AddCallback(seqno__, PQuota::Reply_InitializePersistentStorage__ID, [resolve=std::move(aResolve)](IPC::MessageReader* aReader) mutable {
            auto maybe__response = IPC::ReadParam<BoolResponse>(aReader);
            if (!maybe__response) {
                (aReader)->FatalError("Error deserializing 'BoolResponse'");
                return MsgValueError;

            }
            auto& response = *maybe__response;
            // Sentinel = 'response'
            if ((!((aReader)->ReadSentinel(260965232)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'BoolResponse'");
                return MsgValueError;
            }


            aReader->EndRead();

            resolve(std::move(response));
            return MsgProcessed;
        }, std::move(aReject));
    }
    else {
        aReject(::mozilla::ipc::ResponseRejectReason::SendError);
    }
    return;
}

auto PQuotaChild::SendInitializePersistentStorage() -> RefPtr<InitializePersistentStoragePromise>
{
    RefPtr<MozPromise<BoolResponse, ResponseRejectReason, true>::Private> promise__ = new MozPromise<BoolResponse, ResponseRejectReason, true>::Private(__func__);
    promise__->UseDirectTaskDispatch(__func__);
    SendInitializePersistentStorage([promise__](BoolResponse&& aValue) {
        promise__->Resolve(std::move(aValue), __func__);
    }, [promise__](ResponseRejectReason&& aReason) {
        promise__->Reject(std::move(aReason), __func__);
    });
    return promise__;
}

auto PQuotaChild::SendInitializeAllTemporaryOrigins(
        mozilla::ipc::ResolveCallback<BoolResponse>&& aResolve,
        mozilla::ipc::RejectCallback&& aReject) -> void
{
    UniquePtr<IPC::Message> msg__ = PQuota::Msg_InitializeAllTemporaryOrigins(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};





    if (mozilla::ipc::LoggingEnabledFor("PQuota", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PQuotaChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PQuota::Msg_InitializeAllTemporaryOrigins", OTHER);

    int32_t seqno__ = 0;
    if (ChannelSend(std::move(msg__), (&(seqno__)))) {
        mAsyncCallbacks.AddCallback(seqno__, PQuota::Reply_InitializeAllTemporaryOrigins__ID, [resolve=std::move(aResolve)](IPC::MessageReader* aReader) mutable {
            auto maybe__response = IPC::ReadParam<BoolResponse>(aReader);
            if (!maybe__response) {
                (aReader)->FatalError("Error deserializing 'BoolResponse'");
                return MsgValueError;

            }
            auto& response = *maybe__response;
            // Sentinel = 'response'
            if ((!((aReader)->ReadSentinel(260965232)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'BoolResponse'");
                return MsgValueError;
            }


            aReader->EndRead();

            resolve(std::move(response));
            return MsgProcessed;
        }, std::move(aReject));
    }
    else {
        aReject(::mozilla::ipc::ResponseRejectReason::SendError);
    }
    return;
}

auto PQuotaChild::SendInitializeAllTemporaryOrigins() -> RefPtr<InitializeAllTemporaryOriginsPromise>
{
    RefPtr<MozPromise<BoolResponse, ResponseRejectReason, true>::Private> promise__ = new MozPromise<BoolResponse, ResponseRejectReason, true>::Private(__func__);
    promise__->UseDirectTaskDispatch(__func__);
    SendInitializeAllTemporaryOrigins([promise__](BoolResponse&& aValue) {
        promise__->Resolve(std::move(aValue), __func__);
    }, [promise__](ResponseRejectReason&& aReason) {
        promise__->Reject(std::move(aReason), __func__);
    });
    return promise__;
}

auto PQuotaChild::SendInitializeTemporaryGroup(
        const PrincipalInfo& principalInfo,
        mozilla::ipc::ResolveCallback<BoolResponse>&& aResolve,
        mozilla::ipc::RejectCallback&& aReject) -> void
{
    UniquePtr<IPC::Message> msg__ = PQuota::Msg_InitializeTemporaryGroup(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), principalInfo);
    // Sentinel = 'principalInfo'
    ((&(writer__)))->WriteSentinel(633472335);




    if (mozilla::ipc::LoggingEnabledFor("PQuota", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PQuotaChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PQuota::Msg_InitializeTemporaryGroup", OTHER);

    int32_t seqno__ = 0;
    if (ChannelSend(std::move(msg__), (&(seqno__)))) {
        mAsyncCallbacks.AddCallback(seqno__, PQuota::Reply_InitializeTemporaryGroup__ID, [resolve=std::move(aResolve)](IPC::MessageReader* aReader) mutable {
            auto maybe__response = IPC::ReadParam<BoolResponse>(aReader);
            if (!maybe__response) {
                (aReader)->FatalError("Error deserializing 'BoolResponse'");
                return MsgValueError;

            }
            auto& response = *maybe__response;
            // Sentinel = 'response'
            if ((!((aReader)->ReadSentinel(260965232)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'BoolResponse'");
                return MsgValueError;
            }


            aReader->EndRead();

            resolve(std::move(response));
            return MsgProcessed;
        }, std::move(aReject));
    }
    else {
        aReject(::mozilla::ipc::ResponseRejectReason::SendError);
    }
    return;
}

auto PQuotaChild::SendInitializeTemporaryGroup(const PrincipalInfo& principalInfo) -> RefPtr<InitializeTemporaryGroupPromise>
{
    RefPtr<MozPromise<BoolResponse, ResponseRejectReason, true>::Private> promise__ = new MozPromise<BoolResponse, ResponseRejectReason, true>::Private(__func__);
    promise__->UseDirectTaskDispatch(__func__);
    SendInitializeTemporaryGroup(std::move(principalInfo), [promise__](BoolResponse&& aValue) {
        promise__->Resolve(std::move(aValue), __func__);
    }, [promise__](ResponseRejectReason&& aReason) {
        promise__->Reject(std::move(aReason), __func__);
    });
    return promise__;
}

auto PQuotaChild::SendInitializePersistentOrigin(
        const PrincipalInfo& principalInfo,
        mozilla::ipc::ResolveCallback<BoolResponse>&& aResolve,
        mozilla::ipc::RejectCallback&& aReject) -> void
{
    UniquePtr<IPC::Message> msg__ = PQuota::Msg_InitializePersistentOrigin(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), principalInfo);
    // Sentinel = 'principalInfo'
    ((&(writer__)))->WriteSentinel(633472335);




    if (mozilla::ipc::LoggingEnabledFor("PQuota", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PQuotaChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PQuota::Msg_InitializePersistentOrigin", OTHER);

    int32_t seqno__ = 0;
    if (ChannelSend(std::move(msg__), (&(seqno__)))) {
        mAsyncCallbacks.AddCallback(seqno__, PQuota::Reply_InitializePersistentOrigin__ID, [resolve=std::move(aResolve)](IPC::MessageReader* aReader) mutable {
            auto maybe__response = IPC::ReadParam<BoolResponse>(aReader);
            if (!maybe__response) {
                (aReader)->FatalError("Error deserializing 'BoolResponse'");
                return MsgValueError;

            }
            auto& response = *maybe__response;
            // Sentinel = 'response'
            if ((!((aReader)->ReadSentinel(260965232)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'BoolResponse'");
                return MsgValueError;
            }


            aReader->EndRead();

            resolve(std::move(response));
            return MsgProcessed;
        }, std::move(aReject));
    }
    else {
        aReject(::mozilla::ipc::ResponseRejectReason::SendError);
    }
    return;
}

auto PQuotaChild::SendInitializePersistentOrigin(const PrincipalInfo& principalInfo) -> RefPtr<InitializePersistentOriginPromise>
{
    RefPtr<MozPromise<BoolResponse, ResponseRejectReason, true>::Private> promise__ = new MozPromise<BoolResponse, ResponseRejectReason, true>::Private(__func__);
    promise__->UseDirectTaskDispatch(__func__);
    SendInitializePersistentOrigin(std::move(principalInfo), [promise__](BoolResponse&& aValue) {
        promise__->Resolve(std::move(aValue), __func__);
    }, [promise__](ResponseRejectReason&& aReason) {
        promise__->Reject(std::move(aReason), __func__);
    });
    return promise__;
}

auto PQuotaChild::SendInitializeTemporaryOrigin(
        const PersistenceType& persistenceType,
        const PrincipalInfo& principalInfo,
        const bool& createIfNonExistent,
        mozilla::ipc::ResolveCallback<BoolResponse>&& aResolve,
        mozilla::ipc::RejectCallback&& aReject) -> void
{
    UniquePtr<IPC::Message> msg__ = PQuota::Msg_InitializeTemporaryOrigin(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), persistenceType);
    // Sentinel = 'persistenceType'
    ((&(writer__)))->WriteSentinel(853345864);
    IPC::WriteParam((&(writer__)), principalInfo);
    // Sentinel = 'principalInfo'
    ((&(writer__)))->WriteSentinel(633472335);
    IPC::WriteParam((&(writer__)), createIfNonExistent);
    // Sentinel = 'createIfNonExistent'
    ((&(writer__)))->WriteSentinel(1258686371);




    if (mozilla::ipc::LoggingEnabledFor("PQuota", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PQuotaChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PQuota::Msg_InitializeTemporaryOrigin", OTHER);

    int32_t seqno__ = 0;
    if (ChannelSend(std::move(msg__), (&(seqno__)))) {
        mAsyncCallbacks.AddCallback(seqno__, PQuota::Reply_InitializeTemporaryOrigin__ID, [resolve=std::move(aResolve)](IPC::MessageReader* aReader) mutable {
            auto maybe__response = IPC::ReadParam<BoolResponse>(aReader);
            if (!maybe__response) {
                (aReader)->FatalError("Error deserializing 'BoolResponse'");
                return MsgValueError;

            }
            auto& response = *maybe__response;
            // Sentinel = 'response'
            if ((!((aReader)->ReadSentinel(260965232)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'BoolResponse'");
                return MsgValueError;
            }


            aReader->EndRead();

            resolve(std::move(response));
            return MsgProcessed;
        }, std::move(aReject));
    }
    else {
        aReject(::mozilla::ipc::ResponseRejectReason::SendError);
    }
    return;
}

auto PQuotaChild::SendInitializeTemporaryOrigin(
        const PersistenceType& persistenceType,
        const PrincipalInfo& principalInfo,
        const bool& createIfNonExistent) -> RefPtr<InitializeTemporaryOriginPromise>
{
    RefPtr<MozPromise<BoolResponse, ResponseRejectReason, true>::Private> promise__ = new MozPromise<BoolResponse, ResponseRejectReason, true>::Private(__func__);
    promise__->UseDirectTaskDispatch(__func__);
    SendInitializeTemporaryOrigin(std::move(persistenceType), std::move(principalInfo), std::move(createIfNonExistent), [promise__](BoolResponse&& aValue) {
        promise__->Resolve(std::move(aValue), __func__);
    }, [promise__](ResponseRejectReason&& aReason) {
        promise__->Reject(std::move(aReason), __func__);
    });
    return promise__;
}

auto PQuotaChild::SendInitializePersistentClient(
        const PrincipalInfo& principalInfo,
        const Type& clientType,
        mozilla::ipc::ResolveCallback<BoolResponse>&& aResolve,
        mozilla::ipc::RejectCallback&& aReject) -> void
{
    UniquePtr<IPC::Message> msg__ = PQuota::Msg_InitializePersistentClient(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), principalInfo);
    // Sentinel = 'principalInfo'
    ((&(writer__)))->WriteSentinel(633472335);
    IPC::WriteParam((&(writer__)), clientType);
    // Sentinel = 'clientType'
    ((&(writer__)))->WriteSentinel(378995746);




    if (mozilla::ipc::LoggingEnabledFor("PQuota", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PQuotaChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PQuota::Msg_InitializePersistentClient", OTHER);

    int32_t seqno__ = 0;
    if (ChannelSend(std::move(msg__), (&(seqno__)))) {
        mAsyncCallbacks.AddCallback(seqno__, PQuota::Reply_InitializePersistentClient__ID, [resolve=std::move(aResolve)](IPC::MessageReader* aReader) mutable {
            auto maybe__response = IPC::ReadParam<BoolResponse>(aReader);
            if (!maybe__response) {
                (aReader)->FatalError("Error deserializing 'BoolResponse'");
                return MsgValueError;

            }
            auto& response = *maybe__response;
            // Sentinel = 'response'
            if ((!((aReader)->ReadSentinel(260965232)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'BoolResponse'");
                return MsgValueError;
            }


            aReader->EndRead();

            resolve(std::move(response));
            return MsgProcessed;
        }, std::move(aReject));
    }
    else {
        aReject(::mozilla::ipc::ResponseRejectReason::SendError);
    }
    return;
}

auto PQuotaChild::SendInitializePersistentClient(
        const PrincipalInfo& principalInfo,
        const Type& clientType) -> RefPtr<InitializePersistentClientPromise>
{
    RefPtr<MozPromise<BoolResponse, ResponseRejectReason, true>::Private> promise__ = new MozPromise<BoolResponse, ResponseRejectReason, true>::Private(__func__);
    promise__->UseDirectTaskDispatch(__func__);
    SendInitializePersistentClient(std::move(principalInfo), std::move(clientType), [promise__](BoolResponse&& aValue) {
        promise__->Resolve(std::move(aValue), __func__);
    }, [promise__](ResponseRejectReason&& aReason) {
        promise__->Reject(std::move(aReason), __func__);
    });
    return promise__;
}

auto PQuotaChild::SendInitializeTemporaryClient(
        const PersistenceType& persistenceType,
        const PrincipalInfo& principalInfo,
        const Type& clientType,
        mozilla::ipc::ResolveCallback<BoolResponse>&& aResolve,
        mozilla::ipc::RejectCallback&& aReject) -> void
{
    UniquePtr<IPC::Message> msg__ = PQuota::Msg_InitializeTemporaryClient(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), persistenceType);
    // Sentinel = 'persistenceType'
    ((&(writer__)))->WriteSentinel(853345864);
    IPC::WriteParam((&(writer__)), principalInfo);
    // Sentinel = 'principalInfo'
    ((&(writer__)))->WriteSentinel(633472335);
    IPC::WriteParam((&(writer__)), clientType);
    // Sentinel = 'clientType'
    ((&(writer__)))->WriteSentinel(378995746);




    if (mozilla::ipc::LoggingEnabledFor("PQuota", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PQuotaChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PQuota::Msg_InitializeTemporaryClient", OTHER);

    int32_t seqno__ = 0;
    if (ChannelSend(std::move(msg__), (&(seqno__)))) {
        mAsyncCallbacks.AddCallback(seqno__, PQuota::Reply_InitializeTemporaryClient__ID, [resolve=std::move(aResolve)](IPC::MessageReader* aReader) mutable {
            auto maybe__response = IPC::ReadParam<BoolResponse>(aReader);
            if (!maybe__response) {
                (aReader)->FatalError("Error deserializing 'BoolResponse'");
                return MsgValueError;

            }
            auto& response = *maybe__response;
            // Sentinel = 'response'
            if ((!((aReader)->ReadSentinel(260965232)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'BoolResponse'");
                return MsgValueError;
            }


            aReader->EndRead();

            resolve(std::move(response));
            return MsgProcessed;
        }, std::move(aReject));
    }
    else {
        aReject(::mozilla::ipc::ResponseRejectReason::SendError);
    }
    return;
}

auto PQuotaChild::SendInitializeTemporaryClient(
        const PersistenceType& persistenceType,
        const PrincipalInfo& principalInfo,
        const Type& clientType) -> RefPtr<InitializeTemporaryClientPromise>
{
    RefPtr<MozPromise<BoolResponse, ResponseRejectReason, true>::Private> promise__ = new MozPromise<BoolResponse, ResponseRejectReason, true>::Private(__func__);
    promise__->UseDirectTaskDispatch(__func__);
    SendInitializeTemporaryClient(std::move(persistenceType), std::move(principalInfo), std::move(clientType), [promise__](BoolResponse&& aValue) {
        promise__->Resolve(std::move(aValue), __func__);
    }, [promise__](ResponseRejectReason&& aReason) {
        promise__->Reject(std::move(aReason), __func__);
    });
    return promise__;
}

auto PQuotaChild::SendInitializeTemporaryStorage(
        mozilla::ipc::ResolveCallback<BoolResponse>&& aResolve,
        mozilla::ipc::RejectCallback&& aReject) -> void
{
    UniquePtr<IPC::Message> msg__ = PQuota::Msg_InitializeTemporaryStorage(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};





    if (mozilla::ipc::LoggingEnabledFor("PQuota", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PQuotaChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PQuota::Msg_InitializeTemporaryStorage", OTHER);

    int32_t seqno__ = 0;
    if (ChannelSend(std::move(msg__), (&(seqno__)))) {
        mAsyncCallbacks.AddCallback(seqno__, PQuota::Reply_InitializeTemporaryStorage__ID, [resolve=std::move(aResolve)](IPC::MessageReader* aReader) mutable {
            auto maybe__response = IPC::ReadParam<BoolResponse>(aReader);
            if (!maybe__response) {
                (aReader)->FatalError("Error deserializing 'BoolResponse'");
                return MsgValueError;

            }
            auto& response = *maybe__response;
            // Sentinel = 'response'
            if ((!((aReader)->ReadSentinel(260965232)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'BoolResponse'");
                return MsgValueError;
            }


            aReader->EndRead();

            resolve(std::move(response));
            return MsgProcessed;
        }, std::move(aReject));
    }
    else {
        aReject(::mozilla::ipc::ResponseRejectReason::SendError);
    }
    return;
}

auto PQuotaChild::SendInitializeTemporaryStorage() -> RefPtr<InitializeTemporaryStoragePromise>
{
    RefPtr<MozPromise<BoolResponse, ResponseRejectReason, true>::Private> promise__ = new MozPromise<BoolResponse, ResponseRejectReason, true>::Private(__func__);
    promise__->UseDirectTaskDispatch(__func__);
    SendInitializeTemporaryStorage([promise__](BoolResponse&& aValue) {
        promise__->Resolve(std::move(aValue), __func__);
    }, [promise__](ResponseRejectReason&& aReason) {
        promise__->Reject(std::move(aReason), __func__);
    });
    return promise__;
}

auto PQuotaChild::SendGetUsage(
        const bool& getAll,
        ManagedEndpoint<::mozilla::dom::quota::PQuotaUsageRequestParent>&& parentEndpoint,
        mozilla::ipc::ResolveCallback<OriginUsageMetadataArrayResponse>&& aResolve,
        mozilla::ipc::RejectCallback&& aReject) -> void
{
    UniquePtr<IPC::Message> msg__ = PQuota::Msg_GetUsage(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), getAll);
    // Sentinel = 'getAll'
    ((&(writer__)))->WriteSentinel(138412634);
    IPC::WriteParam((&(writer__)), std::move(parentEndpoint));
    // Sentinel = 'parentEndpoint'
    ((&(writer__)))->WriteSentinel(723715532);




    if (mozilla::ipc::LoggingEnabledFor("PQuota", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PQuotaChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PQuota::Msg_GetUsage", OTHER);

    int32_t seqno__ = 0;
    if (ChannelSend(std::move(msg__), (&(seqno__)))) {
        mAsyncCallbacks.AddCallback(seqno__, PQuota::Reply_GetUsage__ID, [resolve=std::move(aResolve)](IPC::MessageReader* aReader) mutable {
            auto maybe__response = IPC::ReadParam<OriginUsageMetadataArrayResponse>(aReader);
            if (!maybe__response) {
                (aReader)->FatalError("Error deserializing 'OriginUsageMetadataArrayResponse'");
                return MsgValueError;

            }
            auto& response = *maybe__response;
            // Sentinel = 'response'
            if ((!((aReader)->ReadSentinel(260965232)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'OriginUsageMetadataArrayResponse'");
                return MsgValueError;
            }


            aReader->EndRead();

            resolve(std::move(response));
            return MsgProcessed;
        }, std::move(aReject));
    }
    else {
        aReject(::mozilla::ipc::ResponseRejectReason::SendError);
    }
    return;
}

auto PQuotaChild::SendGetUsage(
        const bool& getAll,
        ManagedEndpoint<::mozilla::dom::quota::PQuotaUsageRequestParent>&& parentEndpoint) -> RefPtr<GetUsagePromise>
{
    RefPtr<MozPromise<OriginUsageMetadataArrayResponse, ResponseRejectReason, true>::Private> promise__ = new MozPromise<OriginUsageMetadataArrayResponse, ResponseRejectReason, true>::Private(__func__);
    promise__->UseDirectTaskDispatch(__func__);
    SendGetUsage(std::move(getAll), std::move(parentEndpoint), [promise__](OriginUsageMetadataArrayResponse&& aValue) {
        promise__->Resolve(std::move(aValue), __func__);
    }, [promise__](ResponseRejectReason&& aReason) {
        promise__->Reject(std::move(aReason), __func__);
    });
    return promise__;
}

auto PQuotaChild::SendGetOriginUsage(
        const PrincipalInfo& principalInfo,
        ManagedEndpoint<::mozilla::dom::quota::PQuotaUsageRequestParent>&& parentEndpoint,
        mozilla::ipc::ResolveCallback<UsageInfoResponse>&& aResolve,
        mozilla::ipc::RejectCallback&& aReject) -> void
{
    UniquePtr<IPC::Message> msg__ = PQuota::Msg_GetOriginUsage(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), principalInfo);
    // Sentinel = 'principalInfo'
    ((&(writer__)))->WriteSentinel(633472335);
    IPC::WriteParam((&(writer__)), std::move(parentEndpoint));
    // Sentinel = 'parentEndpoint'
    ((&(writer__)))->WriteSentinel(723715532);




    if (mozilla::ipc::LoggingEnabledFor("PQuota", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PQuotaChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PQuota::Msg_GetOriginUsage", OTHER);

    int32_t seqno__ = 0;
    if (ChannelSend(std::move(msg__), (&(seqno__)))) {
        mAsyncCallbacks.AddCallback(seqno__, PQuota::Reply_GetOriginUsage__ID, [resolve=std::move(aResolve)](IPC::MessageReader* aReader) mutable {
            auto maybe__response = IPC::ReadParam<UsageInfoResponse>(aReader);
            if (!maybe__response) {
                (aReader)->FatalError("Error deserializing 'UsageInfoResponse'");
                return MsgValueError;

            }
            auto& response = *maybe__response;
            // Sentinel = 'response'
            if ((!((aReader)->ReadSentinel(260965232)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'UsageInfoResponse'");
                return MsgValueError;
            }


            aReader->EndRead();

            resolve(std::move(response));
            return MsgProcessed;
        }, std::move(aReject));
    }
    else {
        aReject(::mozilla::ipc::ResponseRejectReason::SendError);
    }
    return;
}

auto PQuotaChild::SendGetOriginUsage(
        const PrincipalInfo& principalInfo,
        ManagedEndpoint<::mozilla::dom::quota::PQuotaUsageRequestParent>&& parentEndpoint) -> RefPtr<GetOriginUsagePromise>
{
    RefPtr<MozPromise<UsageInfoResponse, ResponseRejectReason, true>::Private> promise__ = new MozPromise<UsageInfoResponse, ResponseRejectReason, true>::Private(__func__);
    promise__->UseDirectTaskDispatch(__func__);
    SendGetOriginUsage(std::move(principalInfo), std::move(parentEndpoint), [promise__](UsageInfoResponse&& aValue) {
        promise__->Resolve(std::move(aValue), __func__);
    }, [promise__](ResponseRejectReason&& aReason) {
        promise__->Reject(std::move(aReason), __func__);
    });
    return promise__;
}

auto PQuotaChild::SendGetCachedOriginUsage(
        const PrincipalInfo& principalInfo,
        mozilla::ipc::ResolveCallback<UInt64Response>&& aResolve,
        mozilla::ipc::RejectCallback&& aReject) -> void
{
    UniquePtr<IPC::Message> msg__ = PQuota::Msg_GetCachedOriginUsage(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), principalInfo);
    // Sentinel = 'principalInfo'
    ((&(writer__)))->WriteSentinel(633472335);




    if (mozilla::ipc::LoggingEnabledFor("PQuota", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PQuotaChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PQuota::Msg_GetCachedOriginUsage", OTHER);

    int32_t seqno__ = 0;
    if (ChannelSend(std::move(msg__), (&(seqno__)))) {
        mAsyncCallbacks.AddCallback(seqno__, PQuota::Reply_GetCachedOriginUsage__ID, [resolve=std::move(aResolve)](IPC::MessageReader* aReader) mutable {
            auto maybe__response = IPC::ReadParam<UInt64Response>(aReader);
            if (!maybe__response) {
                (aReader)->FatalError("Error deserializing 'UInt64Response'");
                return MsgValueError;

            }
            auto& response = *maybe__response;
            // Sentinel = 'response'
            if ((!((aReader)->ReadSentinel(260965232)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'UInt64Response'");
                return MsgValueError;
            }


            aReader->EndRead();

            resolve(std::move(response));
            return MsgProcessed;
        }, std::move(aReject));
    }
    else {
        aReject(::mozilla::ipc::ResponseRejectReason::SendError);
    }
    return;
}

auto PQuotaChild::SendGetCachedOriginUsage(const PrincipalInfo& principalInfo) -> RefPtr<GetCachedOriginUsagePromise>
{
    RefPtr<MozPromise<UInt64Response, ResponseRejectReason, true>::Private> promise__ = new MozPromise<UInt64Response, ResponseRejectReason, true>::Private(__func__);
    promise__->UseDirectTaskDispatch(__func__);
    SendGetCachedOriginUsage(std::move(principalInfo), [promise__](UInt64Response&& aValue) {
        promise__->Resolve(std::move(aValue), __func__);
    }, [promise__](ResponseRejectReason&& aReason) {
        promise__->Reject(std::move(aReason), __func__);
    });
    return promise__;
}

auto PQuotaChild::SendListOrigins(
        mozilla::ipc::ResolveCallback<CStringArrayResponse>&& aResolve,
        mozilla::ipc::RejectCallback&& aReject) -> void
{
    UniquePtr<IPC::Message> msg__ = PQuota::Msg_ListOrigins(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};





    if (mozilla::ipc::LoggingEnabledFor("PQuota", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PQuotaChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PQuota::Msg_ListOrigins", OTHER);

    int32_t seqno__ = 0;
    if (ChannelSend(std::move(msg__), (&(seqno__)))) {
        mAsyncCallbacks.AddCallback(seqno__, PQuota::Reply_ListOrigins__ID, [resolve=std::move(aResolve)](IPC::MessageReader* aReader) mutable {
            auto maybe__response = IPC::ReadParam<CStringArrayResponse>(aReader);
            if (!maybe__response) {
                (aReader)->FatalError("Error deserializing 'CStringArrayResponse'");
                return MsgValueError;

            }
            auto& response = *maybe__response;
            // Sentinel = 'response'
            if ((!((aReader)->ReadSentinel(260965232)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'CStringArrayResponse'");
                return MsgValueError;
            }


            aReader->EndRead();

            resolve(std::move(response));
            return MsgProcessed;
        }, std::move(aReject));
    }
    else {
        aReject(::mozilla::ipc::ResponseRejectReason::SendError);
    }
    return;
}

auto PQuotaChild::SendListOrigins() -> RefPtr<ListOriginsPromise>
{
    RefPtr<MozPromise<CStringArrayResponse, ResponseRejectReason, true>::Private> promise__ = new MozPromise<CStringArrayResponse, ResponseRejectReason, true>::Private(__func__);
    promise__->UseDirectTaskDispatch(__func__);
    SendListOrigins([promise__](CStringArrayResponse&& aValue) {
        promise__->Resolve(std::move(aValue), __func__);
    }, [promise__](ResponseRejectReason&& aReason) {
        promise__->Reject(std::move(aReason), __func__);
    });
    return promise__;
}

auto PQuotaChild::SendListCachedOrigins(
        mozilla::ipc::ResolveCallback<CStringArrayResponse>&& aResolve,
        mozilla::ipc::RejectCallback&& aReject) -> void
{
    UniquePtr<IPC::Message> msg__ = PQuota::Msg_ListCachedOrigins(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};





    if (mozilla::ipc::LoggingEnabledFor("PQuota", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PQuotaChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PQuota::Msg_ListCachedOrigins", OTHER);

    int32_t seqno__ = 0;
    if (ChannelSend(std::move(msg__), (&(seqno__)))) {
        mAsyncCallbacks.AddCallback(seqno__, PQuota::Reply_ListCachedOrigins__ID, [resolve=std::move(aResolve)](IPC::MessageReader* aReader) mutable {
            auto maybe__response = IPC::ReadParam<CStringArrayResponse>(aReader);
            if (!maybe__response) {
                (aReader)->FatalError("Error deserializing 'CStringArrayResponse'");
                return MsgValueError;

            }
            auto& response = *maybe__response;
            // Sentinel = 'response'
            if ((!((aReader)->ReadSentinel(260965232)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'CStringArrayResponse'");
                return MsgValueError;
            }


            aReader->EndRead();

            resolve(std::move(response));
            return MsgProcessed;
        }, std::move(aReject));
    }
    else {
        aReject(::mozilla::ipc::ResponseRejectReason::SendError);
    }
    return;
}

auto PQuotaChild::SendListCachedOrigins() -> RefPtr<ListCachedOriginsPromise>
{
    RefPtr<MozPromise<CStringArrayResponse, ResponseRejectReason, true>::Private> promise__ = new MozPromise<CStringArrayResponse, ResponseRejectReason, true>::Private(__func__);
    promise__->UseDirectTaskDispatch(__func__);
    SendListCachedOrigins([promise__](CStringArrayResponse&& aValue) {
        promise__->Resolve(std::move(aValue), __func__);
    }, [promise__](ResponseRejectReason&& aReason) {
        promise__->Reject(std::move(aReason), __func__);
    });
    return promise__;
}

auto PQuotaChild::SendClearStoragesForOrigin(
        const mozilla::Maybe<PersistenceType>& persistenceType,
        const PrincipalInfo& principalInfo,
        mozilla::ipc::ResolveCallback<BoolResponse>&& aResolve,
        mozilla::ipc::RejectCallback&& aReject) -> void
{
    UniquePtr<IPC::Message> msg__ = PQuota::Msg_ClearStoragesForOrigin(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), persistenceType);
    // Sentinel = 'persistenceType'
    ((&(writer__)))->WriteSentinel(853345864);
    IPC::WriteParam((&(writer__)), principalInfo);
    // Sentinel = 'principalInfo'
    ((&(writer__)))->WriteSentinel(633472335);




    if (mozilla::ipc::LoggingEnabledFor("PQuota", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PQuotaChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PQuota::Msg_ClearStoragesForOrigin", OTHER);

    int32_t seqno__ = 0;
    if (ChannelSend(std::move(msg__), (&(seqno__)))) {
        mAsyncCallbacks.AddCallback(seqno__, PQuota::Reply_ClearStoragesForOrigin__ID, [resolve=std::move(aResolve)](IPC::MessageReader* aReader) mutable {
            auto maybe__response = IPC::ReadParam<BoolResponse>(aReader);
            if (!maybe__response) {
                (aReader)->FatalError("Error deserializing 'BoolResponse'");
                return MsgValueError;

            }
            auto& response = *maybe__response;
            // Sentinel = 'response'
            if ((!((aReader)->ReadSentinel(260965232)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'BoolResponse'");
                return MsgValueError;
            }


            aReader->EndRead();

            resolve(std::move(response));
            return MsgProcessed;
        }, std::move(aReject));
    }
    else {
        aReject(::mozilla::ipc::ResponseRejectReason::SendError);
    }
    return;
}

auto PQuotaChild::SendClearStoragesForOrigin(
        const mozilla::Maybe<PersistenceType>& persistenceType,
        const PrincipalInfo& principalInfo) -> RefPtr<ClearStoragesForOriginPromise>
{
    RefPtr<MozPromise<BoolResponse, ResponseRejectReason, true>::Private> promise__ = new MozPromise<BoolResponse, ResponseRejectReason, true>::Private(__func__);
    promise__->UseDirectTaskDispatch(__func__);
    SendClearStoragesForOrigin(std::move(persistenceType), std::move(principalInfo), [promise__](BoolResponse&& aValue) {
        promise__->Resolve(std::move(aValue), __func__);
    }, [promise__](ResponseRejectReason&& aReason) {
        promise__->Reject(std::move(aReason), __func__);
    });
    return promise__;
}

auto PQuotaChild::SendClearStoragesForClient(
        const mozilla::Maybe<PersistenceType>& persistenceType,
        const PrincipalInfo& principalInfo,
        const Type& clientType,
        mozilla::ipc::ResolveCallback<BoolResponse>&& aResolve,
        mozilla::ipc::RejectCallback&& aReject) -> void
{
    UniquePtr<IPC::Message> msg__ = PQuota::Msg_ClearStoragesForClient(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), persistenceType);
    // Sentinel = 'persistenceType'
    ((&(writer__)))->WriteSentinel(853345864);
    IPC::WriteParam((&(writer__)), principalInfo);
    // Sentinel = 'principalInfo'
    ((&(writer__)))->WriteSentinel(633472335);
    IPC::WriteParam((&(writer__)), clientType);
    // Sentinel = 'clientType'
    ((&(writer__)))->WriteSentinel(378995746);




    if (mozilla::ipc::LoggingEnabledFor("PQuota", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PQuotaChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PQuota::Msg_ClearStoragesForClient", OTHER);

    int32_t seqno__ = 0;
    if (ChannelSend(std::move(msg__), (&(seqno__)))) {
        mAsyncCallbacks.AddCallback(seqno__, PQuota::Reply_ClearStoragesForClient__ID, [resolve=std::move(aResolve)](IPC::MessageReader* aReader) mutable {
            auto maybe__response = IPC::ReadParam<BoolResponse>(aReader);
            if (!maybe__response) {
                (aReader)->FatalError("Error deserializing 'BoolResponse'");
                return MsgValueError;

            }
            auto& response = *maybe__response;
            // Sentinel = 'response'
            if ((!((aReader)->ReadSentinel(260965232)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'BoolResponse'");
                return MsgValueError;
            }


            aReader->EndRead();

            resolve(std::move(response));
            return MsgProcessed;
        }, std::move(aReject));
    }
    else {
        aReject(::mozilla::ipc::ResponseRejectReason::SendError);
    }
    return;
}

auto PQuotaChild::SendClearStoragesForClient(
        const mozilla::Maybe<PersistenceType>& persistenceType,
        const PrincipalInfo& principalInfo,
        const Type& clientType) -> RefPtr<ClearStoragesForClientPromise>
{
    RefPtr<MozPromise<BoolResponse, ResponseRejectReason, true>::Private> promise__ = new MozPromise<BoolResponse, ResponseRejectReason, true>::Private(__func__);
    promise__->UseDirectTaskDispatch(__func__);
    SendClearStoragesForClient(std::move(persistenceType), std::move(principalInfo), std::move(clientType), [promise__](BoolResponse&& aValue) {
        promise__->Resolve(std::move(aValue), __func__);
    }, [promise__](ResponseRejectReason&& aReason) {
        promise__->Reject(std::move(aReason), __func__);
    });
    return promise__;
}

auto PQuotaChild::SendClearStoragesForOriginPrefix(
        const mozilla::Maybe<PersistenceType>& persistenceType,
        const PrincipalInfo& principalInfo,
        mozilla::ipc::ResolveCallback<BoolResponse>&& aResolve,
        mozilla::ipc::RejectCallback&& aReject) -> void
{
    UniquePtr<IPC::Message> msg__ = PQuota::Msg_ClearStoragesForOriginPrefix(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), persistenceType);
    // Sentinel = 'persistenceType'
    ((&(writer__)))->WriteSentinel(853345864);
    IPC::WriteParam((&(writer__)), principalInfo);
    // Sentinel = 'principalInfo'
    ((&(writer__)))->WriteSentinel(633472335);




    if (mozilla::ipc::LoggingEnabledFor("PQuota", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PQuotaChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PQuota::Msg_ClearStoragesForOriginPrefix", OTHER);

    int32_t seqno__ = 0;
    if (ChannelSend(std::move(msg__), (&(seqno__)))) {
        mAsyncCallbacks.AddCallback(seqno__, PQuota::Reply_ClearStoragesForOriginPrefix__ID, [resolve=std::move(aResolve)](IPC::MessageReader* aReader) mutable {
            auto maybe__response = IPC::ReadParam<BoolResponse>(aReader);
            if (!maybe__response) {
                (aReader)->FatalError("Error deserializing 'BoolResponse'");
                return MsgValueError;

            }
            auto& response = *maybe__response;
            // Sentinel = 'response'
            if ((!((aReader)->ReadSentinel(260965232)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'BoolResponse'");
                return MsgValueError;
            }


            aReader->EndRead();

            resolve(std::move(response));
            return MsgProcessed;
        }, std::move(aReject));
    }
    else {
        aReject(::mozilla::ipc::ResponseRejectReason::SendError);
    }
    return;
}

auto PQuotaChild::SendClearStoragesForOriginPrefix(
        const mozilla::Maybe<PersistenceType>& persistenceType,
        const PrincipalInfo& principalInfo) -> RefPtr<ClearStoragesForOriginPrefixPromise>
{
    RefPtr<MozPromise<BoolResponse, ResponseRejectReason, true>::Private> promise__ = new MozPromise<BoolResponse, ResponseRejectReason, true>::Private(__func__);
    promise__->UseDirectTaskDispatch(__func__);
    SendClearStoragesForOriginPrefix(std::move(persistenceType), std::move(principalInfo), [promise__](BoolResponse&& aValue) {
        promise__->Resolve(std::move(aValue), __func__);
    }, [promise__](ResponseRejectReason&& aReason) {
        promise__->Reject(std::move(aReason), __func__);
    });
    return promise__;
}

auto PQuotaChild::SendClearStoragesForOriginAttributesPattern(
        const OriginAttributesPattern& pattern,
        mozilla::ipc::ResolveCallback<BoolResponse>&& aResolve,
        mozilla::ipc::RejectCallback&& aReject) -> void
{
    UniquePtr<IPC::Message> msg__ = PQuota::Msg_ClearStoragesForOriginAttributesPattern(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), pattern);
    // Sentinel = 'pattern'
    ((&(writer__)))->WriteSentinel(200409855);




    if (mozilla::ipc::LoggingEnabledFor("PQuota", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PQuotaChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PQuota::Msg_ClearStoragesForOriginAttributesPattern", OTHER);

    int32_t seqno__ = 0;
    if (ChannelSend(std::move(msg__), (&(seqno__)))) {
        mAsyncCallbacks.AddCallback(seqno__, PQuota::Reply_ClearStoragesForOriginAttributesPattern__ID, [resolve=std::move(aResolve)](IPC::MessageReader* aReader) mutable {
            auto maybe__response = IPC::ReadParam<BoolResponse>(aReader);
            if (!maybe__response) {
                (aReader)->FatalError("Error deserializing 'BoolResponse'");
                return MsgValueError;

            }
            auto& response = *maybe__response;
            // Sentinel = 'response'
            if ((!((aReader)->ReadSentinel(260965232)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'BoolResponse'");
                return MsgValueError;
            }


            aReader->EndRead();

            resolve(std::move(response));
            return MsgProcessed;
        }, std::move(aReject));
    }
    else {
        aReject(::mozilla::ipc::ResponseRejectReason::SendError);
    }
    return;
}

auto PQuotaChild::SendClearStoragesForOriginAttributesPattern(const OriginAttributesPattern& pattern) -> RefPtr<ClearStoragesForOriginAttributesPatternPromise>
{
    RefPtr<MozPromise<BoolResponse, ResponseRejectReason, true>::Private> promise__ = new MozPromise<BoolResponse, ResponseRejectReason, true>::Private(__func__);
    promise__->UseDirectTaskDispatch(__func__);
    SendClearStoragesForOriginAttributesPattern(std::move(pattern), [promise__](BoolResponse&& aValue) {
        promise__->Resolve(std::move(aValue), __func__);
    }, [promise__](ResponseRejectReason&& aReason) {
        promise__->Reject(std::move(aReason), __func__);
    });
    return promise__;
}

auto PQuotaChild::SendClearStoragesForPrivateBrowsing(
        mozilla::ipc::ResolveCallback<BoolResponse>&& aResolve,
        mozilla::ipc::RejectCallback&& aReject) -> void
{
    UniquePtr<IPC::Message> msg__ = PQuota::Msg_ClearStoragesForPrivateBrowsing(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};





    if (mozilla::ipc::LoggingEnabledFor("PQuota", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PQuotaChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PQuota::Msg_ClearStoragesForPrivateBrowsing", OTHER);

    int32_t seqno__ = 0;
    if (ChannelSend(std::move(msg__), (&(seqno__)))) {
        mAsyncCallbacks.AddCallback(seqno__, PQuota::Reply_ClearStoragesForPrivateBrowsing__ID, [resolve=std::move(aResolve)](IPC::MessageReader* aReader) mutable {
            auto maybe__response = IPC::ReadParam<BoolResponse>(aReader);
            if (!maybe__response) {
                (aReader)->FatalError("Error deserializing 'BoolResponse'");
                return MsgValueError;

            }
            auto& response = *maybe__response;
            // Sentinel = 'response'
            if ((!((aReader)->ReadSentinel(260965232)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'BoolResponse'");
                return MsgValueError;
            }


            aReader->EndRead();

            resolve(std::move(response));
            return MsgProcessed;
        }, std::move(aReject));
    }
    else {
        aReject(::mozilla::ipc::ResponseRejectReason::SendError);
    }
    return;
}

auto PQuotaChild::SendClearStoragesForPrivateBrowsing() -> RefPtr<ClearStoragesForPrivateBrowsingPromise>
{
    RefPtr<MozPromise<BoolResponse, ResponseRejectReason, true>::Private> promise__ = new MozPromise<BoolResponse, ResponseRejectReason, true>::Private(__func__);
    promise__->UseDirectTaskDispatch(__func__);
    SendClearStoragesForPrivateBrowsing([promise__](BoolResponse&& aValue) {
        promise__->Resolve(std::move(aValue), __func__);
    }, [promise__](ResponseRejectReason&& aReason) {
        promise__->Reject(std::move(aReason), __func__);
    });
    return promise__;
}

auto PQuotaChild::SendClearStorage(
        mozilla::ipc::ResolveCallback<BoolResponse>&& aResolve,
        mozilla::ipc::RejectCallback&& aReject) -> void
{
    UniquePtr<IPC::Message> msg__ = PQuota::Msg_ClearStorage(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};





    if (mozilla::ipc::LoggingEnabledFor("PQuota", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PQuotaChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PQuota::Msg_ClearStorage", OTHER);

    int32_t seqno__ = 0;
    if (ChannelSend(std::move(msg__), (&(seqno__)))) {
        mAsyncCallbacks.AddCallback(seqno__, PQuota::Reply_ClearStorage__ID, [resolve=std::move(aResolve)](IPC::MessageReader* aReader) mutable {
            auto maybe__response = IPC::ReadParam<BoolResponse>(aReader);
            if (!maybe__response) {
                (aReader)->FatalError("Error deserializing 'BoolResponse'");
                return MsgValueError;

            }
            auto& response = *maybe__response;
            // Sentinel = 'response'
            if ((!((aReader)->ReadSentinel(260965232)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'BoolResponse'");
                return MsgValueError;
            }


            aReader->EndRead();

            resolve(std::move(response));
            return MsgProcessed;
        }, std::move(aReject));
    }
    else {
        aReject(::mozilla::ipc::ResponseRejectReason::SendError);
    }
    return;
}

auto PQuotaChild::SendClearStorage() -> RefPtr<ClearStoragePromise>
{
    RefPtr<MozPromise<BoolResponse, ResponseRejectReason, true>::Private> promise__ = new MozPromise<BoolResponse, ResponseRejectReason, true>::Private(__func__);
    promise__->UseDirectTaskDispatch(__func__);
    SendClearStorage([promise__](BoolResponse&& aValue) {
        promise__->Resolve(std::move(aValue), __func__);
    }, [promise__](ResponseRejectReason&& aReason) {
        promise__->Reject(std::move(aReason), __func__);
    });
    return promise__;
}

auto PQuotaChild::SendShutdownStoragesForOrigin(
        const mozilla::Maybe<PersistenceType>& persistenceType,
        const PrincipalInfo& principalInfo,
        mozilla::ipc::ResolveCallback<BoolResponse>&& aResolve,
        mozilla::ipc::RejectCallback&& aReject) -> void
{
    UniquePtr<IPC::Message> msg__ = PQuota::Msg_ShutdownStoragesForOrigin(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), persistenceType);
    // Sentinel = 'persistenceType'
    ((&(writer__)))->WriteSentinel(853345864);
    IPC::WriteParam((&(writer__)), principalInfo);
    // Sentinel = 'principalInfo'
    ((&(writer__)))->WriteSentinel(633472335);




    if (mozilla::ipc::LoggingEnabledFor("PQuota", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PQuotaChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PQuota::Msg_ShutdownStoragesForOrigin", OTHER);

    int32_t seqno__ = 0;
    if (ChannelSend(std::move(msg__), (&(seqno__)))) {
        mAsyncCallbacks.AddCallback(seqno__, PQuota::Reply_ShutdownStoragesForOrigin__ID, [resolve=std::move(aResolve)](IPC::MessageReader* aReader) mutable {
            auto maybe__response = IPC::ReadParam<BoolResponse>(aReader);
            if (!maybe__response) {
                (aReader)->FatalError("Error deserializing 'BoolResponse'");
                return MsgValueError;

            }
            auto& response = *maybe__response;
            // Sentinel = 'response'
            if ((!((aReader)->ReadSentinel(260965232)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'BoolResponse'");
                return MsgValueError;
            }


            aReader->EndRead();

            resolve(std::move(response));
            return MsgProcessed;
        }, std::move(aReject));
    }
    else {
        aReject(::mozilla::ipc::ResponseRejectReason::SendError);
    }
    return;
}

auto PQuotaChild::SendShutdownStoragesForOrigin(
        const mozilla::Maybe<PersistenceType>& persistenceType,
        const PrincipalInfo& principalInfo) -> RefPtr<ShutdownStoragesForOriginPromise>
{
    RefPtr<MozPromise<BoolResponse, ResponseRejectReason, true>::Private> promise__ = new MozPromise<BoolResponse, ResponseRejectReason, true>::Private(__func__);
    promise__->UseDirectTaskDispatch(__func__);
    SendShutdownStoragesForOrigin(std::move(persistenceType), std::move(principalInfo), [promise__](BoolResponse&& aValue) {
        promise__->Resolve(std::move(aValue), __func__);
    }, [promise__](ResponseRejectReason&& aReason) {
        promise__->Reject(std::move(aReason), __func__);
    });
    return promise__;
}

auto PQuotaChild::SendShutdownStoragesForClient(
        const mozilla::Maybe<PersistenceType>& persistenceType,
        const PrincipalInfo& principalInfo,
        const Type& clientType,
        mozilla::ipc::ResolveCallback<BoolResponse>&& aResolve,
        mozilla::ipc::RejectCallback&& aReject) -> void
{
    UniquePtr<IPC::Message> msg__ = PQuota::Msg_ShutdownStoragesForClient(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), persistenceType);
    // Sentinel = 'persistenceType'
    ((&(writer__)))->WriteSentinel(853345864);
    IPC::WriteParam((&(writer__)), principalInfo);
    // Sentinel = 'principalInfo'
    ((&(writer__)))->WriteSentinel(633472335);
    IPC::WriteParam((&(writer__)), clientType);
    // Sentinel = 'clientType'
    ((&(writer__)))->WriteSentinel(378995746);




    if (mozilla::ipc::LoggingEnabledFor("PQuota", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PQuotaChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PQuota::Msg_ShutdownStoragesForClient", OTHER);

    int32_t seqno__ = 0;
    if (ChannelSend(std::move(msg__), (&(seqno__)))) {
        mAsyncCallbacks.AddCallback(seqno__, PQuota::Reply_ShutdownStoragesForClient__ID, [resolve=std::move(aResolve)](IPC::MessageReader* aReader) mutable {
            auto maybe__response = IPC::ReadParam<BoolResponse>(aReader);
            if (!maybe__response) {
                (aReader)->FatalError("Error deserializing 'BoolResponse'");
                return MsgValueError;

            }
            auto& response = *maybe__response;
            // Sentinel = 'response'
            if ((!((aReader)->ReadSentinel(260965232)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'BoolResponse'");
                return MsgValueError;
            }


            aReader->EndRead();

            resolve(std::move(response));
            return MsgProcessed;
        }, std::move(aReject));
    }
    else {
        aReject(::mozilla::ipc::ResponseRejectReason::SendError);
    }
    return;
}

auto PQuotaChild::SendShutdownStoragesForClient(
        const mozilla::Maybe<PersistenceType>& persistenceType,
        const PrincipalInfo& principalInfo,
        const Type& clientType) -> RefPtr<ShutdownStoragesForClientPromise>
{
    RefPtr<MozPromise<BoolResponse, ResponseRejectReason, true>::Private> promise__ = new MozPromise<BoolResponse, ResponseRejectReason, true>::Private(__func__);
    promise__->UseDirectTaskDispatch(__func__);
    SendShutdownStoragesForClient(std::move(persistenceType), std::move(principalInfo), std::move(clientType), [promise__](BoolResponse&& aValue) {
        promise__->Resolve(std::move(aValue), __func__);
    }, [promise__](ResponseRejectReason&& aReason) {
        promise__->Reject(std::move(aReason), __func__);
    });
    return promise__;
}

auto PQuotaChild::SendShutdownStorage(
        mozilla::ipc::ResolveCallback<BoolResponse>&& aResolve,
        mozilla::ipc::RejectCallback&& aReject) -> void
{
    UniquePtr<IPC::Message> msg__ = PQuota::Msg_ShutdownStorage(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};





    if (mozilla::ipc::LoggingEnabledFor("PQuota", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PQuotaChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PQuota::Msg_ShutdownStorage", OTHER);

    int32_t seqno__ = 0;
    if (ChannelSend(std::move(msg__), (&(seqno__)))) {
        mAsyncCallbacks.AddCallback(seqno__, PQuota::Reply_ShutdownStorage__ID, [resolve=std::move(aResolve)](IPC::MessageReader* aReader) mutable {
            auto maybe__response = IPC::ReadParam<BoolResponse>(aReader);
            if (!maybe__response) {
                (aReader)->FatalError("Error deserializing 'BoolResponse'");
                return MsgValueError;

            }
            auto& response = *maybe__response;
            // Sentinel = 'response'
            if ((!((aReader)->ReadSentinel(260965232)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'BoolResponse'");
                return MsgValueError;
            }


            aReader->EndRead();

            resolve(std::move(response));
            return MsgProcessed;
        }, std::move(aReject));
    }
    else {
        aReject(::mozilla::ipc::ResponseRejectReason::SendError);
    }
    return;
}

auto PQuotaChild::SendShutdownStorage() -> RefPtr<ShutdownStoragePromise>
{
    RefPtr<MozPromise<BoolResponse, ResponseRejectReason, true>::Private> promise__ = new MozPromise<BoolResponse, ResponseRejectReason, true>::Private(__func__);
    promise__->UseDirectTaskDispatch(__func__);
    SendShutdownStorage([promise__](BoolResponse&& aValue) {
        promise__->Resolve(std::move(aValue), __func__);
    }, [promise__](ResponseRejectReason&& aReason) {
        promise__->Reject(std::move(aReason), __func__);
    });
    return promise__;
}

auto PQuotaChild::SendStartIdleMaintenance() -> bool
{
    UniquePtr<IPC::Message> msg__ = PQuota::Msg_StartIdleMaintenance(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};





    if (mozilla::ipc::LoggingEnabledFor("PQuota", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PQuotaChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PQuota::Msg_StartIdleMaintenance", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PQuotaChild::SendStopIdleMaintenance() -> bool
{
    UniquePtr<IPC::Message> msg__ = PQuota::Msg_StopIdleMaintenance(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};





    if (mozilla::ipc::LoggingEnabledFor("PQuota", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PQuotaChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PQuota::Msg_StopIdleMaintenance", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PQuotaChild::SendAbortOperationsForProcess(const ContentParentId& contentParentId) -> bool
{
    UniquePtr<IPC::Message> msg__ = PQuota::Msg_AbortOperationsForProcess(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), contentParentId);
    // Sentinel = 'contentParentId'
    ((&(writer__)))->WriteSentinel(830539283);




    if (mozilla::ipc::LoggingEnabledFor("PQuota", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PQuotaChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PQuota::Msg_AbortOperationsForProcess", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PQuotaChild::SendSetThumbnailPrivateIdentityId(const uint32_t& aThumbnailPrivateIdentityId) -> bool
{
    UniquePtr<IPC::Message> msg__ = PQuota::Msg_SetThumbnailPrivateIdentityId(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), aThumbnailPrivateIdentityId);
    // Sentinel = 'aThumbnailPrivateIdentityId'
    ((&(writer__)))->WriteSentinel(2540636888);




    if (mozilla::ipc::LoggingEnabledFor("PQuota", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PQuotaChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PQuota::Msg_SetThumbnailPrivateIdentityId", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PQuotaChild::DeallocManagee(
        int32_t aProtocolId,
        IProtocol* aListener) -> void
{
    switch (aProtocolId) {
    case PQuotaRequestMsgStart:
        this->DeallocPQuotaRequestChild(static_cast<PQuotaRequestChild*>(aListener));
        return;
    default:
        FatalError("unreached");
        return;
    }
}

auto PQuotaChild::OnMessageReceived(const Message& msg__) -> PQuotaChild::Result
{
    switch (msg__.type()) {
    case MANAGED_ENDPOINT_BOUND_MESSAGE_TYPE:
        {
            if (!mAwaitingManagedEndpointBind) {
                NS_WARNING("Unexpected managed endpoint lifecycle message after actor bound!");
                return MsgNotAllowed;
            }
            mAwaitingManagedEndpointBind = false;
            return MsgProcessed;
        }
    case MANAGED_ENDPOINT_DROPPED_MESSAGE_TYPE:
        {
            if (!mAwaitingManagedEndpointBind) {
                NS_WARNING("Unexpected managed endpoint lifecycle message after actor bound!");
                return MsgNotAllowed;
            }
            mAwaitingManagedEndpointBind = false;
            this->ActorDisconnected(ManagedEndpointDropped);
            return MsgProcessed;
        }
    case PQuota::Reply___delete____ID:
        {
            return MsgProcessed;
        }
    case PQuota::Reply_PQuotaRequestConstructor__ID:
        {
            return MsgProcessed;
        }
    case PQuota::Reply_StorageInitialized__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PQuota", mozilla::ipc::ChildSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PQuotaChild",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }

            AUTO_PROFILER_LABEL("PQuota::Msg_StorageInitialized", OTHER);


            return mAsyncCallbacks.GotReply(this, msg__);
        }
    case PQuota::Reply_PersistentStorageInitialized__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PQuota", mozilla::ipc::ChildSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PQuotaChild",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }

            AUTO_PROFILER_LABEL("PQuota::Msg_PersistentStorageInitialized", OTHER);


            return mAsyncCallbacks.GotReply(this, msg__);
        }
    case PQuota::Reply_TemporaryStorageInitialized__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PQuota", mozilla::ipc::ChildSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PQuotaChild",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }

            AUTO_PROFILER_LABEL("PQuota::Msg_TemporaryStorageInitialized", OTHER);


            return mAsyncCallbacks.GotReply(this, msg__);
        }
    case PQuota::Reply_TemporaryGroupInitialized__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PQuota", mozilla::ipc::ChildSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PQuotaChild",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }

            AUTO_PROFILER_LABEL("PQuota::Msg_TemporaryGroupInitialized", OTHER);


            return mAsyncCallbacks.GotReply(this, msg__);
        }
    case PQuota::Reply_PersistentOriginInitialized__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PQuota", mozilla::ipc::ChildSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PQuotaChild",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }

            AUTO_PROFILER_LABEL("PQuota::Msg_PersistentOriginInitialized", OTHER);


            return mAsyncCallbacks.GotReply(this, msg__);
        }
    case PQuota::Reply_TemporaryOriginInitialized__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PQuota", mozilla::ipc::ChildSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PQuotaChild",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }

            AUTO_PROFILER_LABEL("PQuota::Msg_TemporaryOriginInitialized", OTHER);


            return mAsyncCallbacks.GotReply(this, msg__);
        }
    case PQuota::Reply_InitializeStorage__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PQuota", mozilla::ipc::ChildSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PQuotaChild",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }

            AUTO_PROFILER_LABEL("PQuota::Msg_InitializeStorage", OTHER);


            return mAsyncCallbacks.GotReply(this, msg__);
        }
    case PQuota::Reply_InitializePersistentStorage__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PQuota", mozilla::ipc::ChildSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PQuotaChild",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }

            AUTO_PROFILER_LABEL("PQuota::Msg_InitializePersistentStorage", OTHER);


            return mAsyncCallbacks.GotReply(this, msg__);
        }
    case PQuota::Reply_InitializeAllTemporaryOrigins__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PQuota", mozilla::ipc::ChildSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PQuotaChild",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }

            AUTO_PROFILER_LABEL("PQuota::Msg_InitializeAllTemporaryOrigins", OTHER);


            return mAsyncCallbacks.GotReply(this, msg__);
        }
    case PQuota::Reply_InitializeTemporaryGroup__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PQuota", mozilla::ipc::ChildSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PQuotaChild",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }

            AUTO_PROFILER_LABEL("PQuota::Msg_InitializeTemporaryGroup", OTHER);


            return mAsyncCallbacks.GotReply(this, msg__);
        }
    case PQuota::Reply_InitializePersistentOrigin__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PQuota", mozilla::ipc::ChildSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PQuotaChild",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }

            AUTO_PROFILER_LABEL("PQuota::Msg_InitializePersistentOrigin", OTHER);


            return mAsyncCallbacks.GotReply(this, msg__);
        }
    case PQuota::Reply_InitializeTemporaryOrigin__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PQuota", mozilla::ipc::ChildSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PQuotaChild",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }

            AUTO_PROFILER_LABEL("PQuota::Msg_InitializeTemporaryOrigin", OTHER);


            return mAsyncCallbacks.GotReply(this, msg__);
        }
    case PQuota::Reply_InitializePersistentClient__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PQuota", mozilla::ipc::ChildSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PQuotaChild",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }

            AUTO_PROFILER_LABEL("PQuota::Msg_InitializePersistentClient", OTHER);


            return mAsyncCallbacks.GotReply(this, msg__);
        }
    case PQuota::Reply_InitializeTemporaryClient__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PQuota", mozilla::ipc::ChildSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PQuotaChild",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }

            AUTO_PROFILER_LABEL("PQuota::Msg_InitializeTemporaryClient", OTHER);


            return mAsyncCallbacks.GotReply(this, msg__);
        }
    case PQuota::Reply_InitializeTemporaryStorage__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PQuota", mozilla::ipc::ChildSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PQuotaChild",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }

            AUTO_PROFILER_LABEL("PQuota::Msg_InitializeTemporaryStorage", OTHER);


            return mAsyncCallbacks.GotReply(this, msg__);
        }
    case PQuota::Reply_GetUsage__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PQuota", mozilla::ipc::ChildSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PQuotaChild",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }

            AUTO_PROFILER_LABEL("PQuota::Msg_GetUsage", OTHER);


            return mAsyncCallbacks.GotReply(this, msg__);
        }
    case PQuota::Reply_GetOriginUsage__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PQuota", mozilla::ipc::ChildSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PQuotaChild",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }

            AUTO_PROFILER_LABEL("PQuota::Msg_GetOriginUsage", OTHER);


            return mAsyncCallbacks.GotReply(this, msg__);
        }
    case PQuota::Reply_GetCachedOriginUsage__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PQuota", mozilla::ipc::ChildSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PQuotaChild",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }

            AUTO_PROFILER_LABEL("PQuota::Msg_GetCachedOriginUsage", OTHER);


            return mAsyncCallbacks.GotReply(this, msg__);
        }
    case PQuota::Reply_ListOrigins__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PQuota", mozilla::ipc::ChildSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PQuotaChild",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }

            AUTO_PROFILER_LABEL("PQuota::Msg_ListOrigins", OTHER);


            return mAsyncCallbacks.GotReply(this, msg__);
        }
    case PQuota::Reply_ListCachedOrigins__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PQuota", mozilla::ipc::ChildSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PQuotaChild",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }

            AUTO_PROFILER_LABEL("PQuota::Msg_ListCachedOrigins", OTHER);


            return mAsyncCallbacks.GotReply(this, msg__);
        }
    case PQuota::Reply_ClearStoragesForOrigin__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PQuota", mozilla::ipc::ChildSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PQuotaChild",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }

            AUTO_PROFILER_LABEL("PQuota::Msg_ClearStoragesForOrigin", OTHER);


            return mAsyncCallbacks.GotReply(this, msg__);
        }
    case PQuota::Reply_ClearStoragesForClient__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PQuota", mozilla::ipc::ChildSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PQuotaChild",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }

            AUTO_PROFILER_LABEL("PQuota::Msg_ClearStoragesForClient", OTHER);


            return mAsyncCallbacks.GotReply(this, msg__);
        }
    case PQuota::Reply_ClearStoragesForOriginPrefix__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PQuota", mozilla::ipc::ChildSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PQuotaChild",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }

            AUTO_PROFILER_LABEL("PQuota::Msg_ClearStoragesForOriginPrefix", OTHER);


            return mAsyncCallbacks.GotReply(this, msg__);
        }
    case PQuota::Reply_ClearStoragesForOriginAttributesPattern__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PQuota", mozilla::ipc::ChildSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PQuotaChild",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }

            AUTO_PROFILER_LABEL("PQuota::Msg_ClearStoragesForOriginAttributesPattern", OTHER);


            return mAsyncCallbacks.GotReply(this, msg__);
        }
    case PQuota::Reply_ClearStoragesForPrivateBrowsing__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PQuota", mozilla::ipc::ChildSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PQuotaChild",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }

            AUTO_PROFILER_LABEL("PQuota::Msg_ClearStoragesForPrivateBrowsing", OTHER);


            return mAsyncCallbacks.GotReply(this, msg__);
        }
    case PQuota::Reply_ClearStorage__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PQuota", mozilla::ipc::ChildSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PQuotaChild",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }

            AUTO_PROFILER_LABEL("PQuota::Msg_ClearStorage", OTHER);


            return mAsyncCallbacks.GotReply(this, msg__);
        }
    case PQuota::Reply_ShutdownStoragesForOrigin__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PQuota", mozilla::ipc::ChildSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PQuotaChild",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }

            AUTO_PROFILER_LABEL("PQuota::Msg_ShutdownStoragesForOrigin", OTHER);


            return mAsyncCallbacks.GotReply(this, msg__);
        }
    case PQuota::Reply_ShutdownStoragesForClient__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PQuota", mozilla::ipc::ChildSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PQuotaChild",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }

            AUTO_PROFILER_LABEL("PQuota::Msg_ShutdownStoragesForClient", OTHER);


            return mAsyncCallbacks.GotReply(this, msg__);
        }
    case PQuota::Reply_ShutdownStorage__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PQuota", mozilla::ipc::ChildSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PQuotaChild",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }

            AUTO_PROFILER_LABEL("PQuota::Msg_ShutdownStorage", OTHER);


            return mAsyncCallbacks.GotReply(this, msg__);
        }
    default:
        return MsgNotKnown;
    }
}

auto PQuotaChild::OnMessageReceived(
        const Message& msg__,
        UniquePtr<Message>& reply__) -> PQuotaChild::Result
{
    return MsgNotKnown;
}



} // namespace quota
} // namespace dom
} // namespace mozilla
namespace IPC {
auto ParamTraits<::mozilla::dom::quota::PQuotaChild*>::Write(
        IPC::MessageWriter* aWriter,
        const paramType& aVar) -> void
{
    MOZ_RELEASE_ASSERT(
        aWriter->GetActor(),
        "Cannot serialize managed actors without an actor");

    int32_t id;
    if (!aVar) {
        id = 0;  // kNullActorId
    } else {
        id = aVar->Id();
        if (id == 1) {  // kFreedActorId
            aVar->FatalError("Actor has been |delete|d");
        }
        MOZ_RELEASE_ASSERT(
            aWriter->GetActor()->GetIPCChannel() == aVar->GetIPCChannel(),
            "Actor must be from the same channel as the"
            " actor it's being sent over");
        MOZ_RELEASE_ASSERT(
            aVar->CanSend(),
            "Actor must still be open when sending");
    }

    IPC::WriteParam(aWriter, id);
}

auto ParamTraits<::mozilla::dom::quota::PQuotaChild*>::Read(IPC::MessageReader* aReader) -> IPC::ReadResult<paramType>
{
    MOZ_RELEASE_ASSERT(
        aReader->GetActor(),
        "Cannot deserialize managed actors without an actor");
    mozilla::Maybe<mozilla::ipc::IProtocol*> actor = aReader->GetActor()
        ->ReadActor(aReader, true, "PQuota", PQuotaMsgStart);
    if (actor.isSome()) {
        return static_cast<::mozilla::dom::quota::PQuotaChild*>(actor.ref());
    }
    return {};
}

} // namespace IPC
