//
// Automatically generated by ipdlc.
// Edit at your own risk
//


#include "mozilla/dom/PMessagePortParent.h"
#include "mozilla/GfxMessageUtils.h"
#include "mozilla/ProfilerLabels.h"
#include "mozilla/RemoteLazyInputStream.h"
#include "mozilla/dom/CSPMessageUtils.h"
#include "mozilla/dom/DocShellMessageUtils.h"
#include "mozilla/dom/DomSecurityIPCUtils.h"
#include "mozilla/dom/MessagePortParent.h"
#include "mozilla/dom/NavigationAPIIPCUtils.h"
#include "mozilla/dom/PermissionMessageUtils.h"
#include "mozilla/dom/PropertyBagUtils.h"
#include "mozilla/dom/ReferrerInfoUtils.h"
#include "mozilla/dom/SessionHistoryEntry.h"
#include "mozilla/dom/TabMessageUtils.h"
#include "mozilla/dom/notification/IPCUtils.h"
#include "mozilla/ipc/BigBuffer.h"
#include "mozilla/ipc/IPCCore.h"
#include "mozilla/ipc/IPCStreamUtils.h"
#include "mozilla/ipc/SerializedStructuredCloneBuffer.h"
#include "mozilla/ipc/URIUtils.h"
#include "mozilla/layers/LayersMessageUtils.h"
#include "mozilla/net/NeckoMessageUtils.h"
#include "nsIContentSecurityPolicy.h"
#include "nsID.h"
#include "nsIPrincipal.h"
#include "nsIReferrerInfo.h"
#include "nsIURI.h"
#include "nsIVariant.h"

#include "mozilla/ipc/PBackgroundParent.h"

#include "ipc/IPCMessageUtils.h"
#include "ipc/IPCMessageUtilsSpecializations.h"
#include "nsIFile.h"
#include "mozilla/ipc/Endpoint.h"
#include "mozilla/ipc/ProtocolMessageUtils.h"
#include "mozilla/ipc/ProtocolUtils.h"
#include "mozilla/ipc/ShmemMessageUtils.h"
#include "mozilla/ipc/TaintingIPCUtils.h"

namespace mozilla {
namespace dom {


MOZ_IMPLICIT PMessagePortParent::PMessagePortParent() :
    mozilla::ipc::IProtocol(kProtocolId, mozilla::ipc::ParentSide)
{
    MOZ_COUNT_CTOR(PMessagePortParent);
}

PMessagePortParent::~PMessagePortParent()
{
    MOZ_COUNT_DTOR(PMessagePortParent);
}

auto PMessagePortParent::ActorAlloc() -> void
{
}

auto PMessagePortParent::ActorDealloc() -> void
{
    if (Manager()) {
        Manager()->DeallocManagee(kProtocolId, this);
    }
}

auto PMessagePortParent::OtherPid() const -> ::base::ProcessId
{
    ::base::ProcessId pid =
        ::mozilla::ipc::IProtocol::ToplevelProtocol()->OtherPidMaybeInvalid();
    MOZ_RELEASE_ASSERT(pid != ::base::kInvalidProcessId);
    return pid;
}

auto PMessagePortParent::OtherChildID() const -> ::GeckoChildID
{
    ::GeckoChildID childID =
        ::mozilla::ipc::IProtocol::ToplevelProtocol()->OtherChildIDMaybeInvalid();
    MOZ_RELEASE_ASSERT(childID != -1);
    return childID;
}

auto PMessagePortParent::OtherEndpointProcInfo() const -> ::mozilla::ipc::EndpointProcInfo
{
    return ::mozilla::ipc::EndpointProcInfo{OtherPid(), OtherChildID()};
}

auto PMessagePortParent::Manager() const -> PBackgroundParent*
{
    return static_cast<PBackgroundParent*>(IProtocol::Manager());
}

auto PMessagePortParent::ManagedProtocolIds() const -> mozilla::Span<mozilla::ipc::ProtocolId const>
{
    return {};
}

auto PMessagePortParent::GetManagedActors(mozilla::ipc::ProtocolId aProtocol) -> UntypedManagedContainer*
{
    switch (aProtocol) {
    default:
        return nullptr;
    }
}

auto PMessagePortParent::SendEntangled(mozilla::Span<MessageData const> messages) -> bool
{
    UniquePtr<IPC::Message> msg__ = PMessagePort::Msg_Entangled(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), messages);
    // Sentinel = 'messages'
    ((&(writer__)))->WriteSentinel(253363033);




    if (mozilla::ipc::LoggingEnabledFor("PMessagePort", mozilla::ipc::ParentSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PMessagePortParent",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PMessagePort::Msg_Entangled", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PMessagePortParent::SendReceiveData(mozilla::Span<MessageData const> messages) -> bool
{
    UniquePtr<IPC::Message> msg__ = PMessagePort::Msg_ReceiveData(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), messages);
    // Sentinel = 'messages'
    ((&(writer__)))->WriteSentinel(253363033);




    if (mozilla::ipc::LoggingEnabledFor("PMessagePort", mozilla::ipc::ParentSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PMessagePortParent",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PMessagePort::Msg_ReceiveData", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PMessagePortParent::SendStopSendingDataConfirmed() -> bool
{
    UniquePtr<IPC::Message> msg__ = PMessagePort::Msg_StopSendingDataConfirmed(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};





    if (mozilla::ipc::LoggingEnabledFor("PMessagePort", mozilla::ipc::ParentSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PMessagePortParent",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PMessagePort::Msg_StopSendingDataConfirmed", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PMessagePortParent::Send__delete__(PMessagePortParent* actor) -> bool
{
    if (!actor || !actor->CanSend()) {
        NS_WARNING("Attempt to __delete__ missing or closed actor");
        return false;
    }
    UniquePtr<IPC::Message> msg__ = PMessagePort::Msg___delete__((actor)->Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            actor};




    if (mozilla::ipc::LoggingEnabledFor("PMessagePort", mozilla::ipc::ParentSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PMessagePortParent",
            actor->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PMessagePort::Msg___delete__", OTHER);

    bool sendok__ = (actor)->ChannelSend(std::move(msg__));

    actor->ActorDisconnected(Deletion);
    return sendok__;
}

auto PMessagePortParent::DeallocManagee(
        int32_t aProtocolId,
        IProtocol* aListener) -> void
{
    FatalError("unreached");
    return;
}

auto PMessagePortParent::OnMessageReceived(const Message& msg__) -> PMessagePortParent::Result
{
    switch (msg__.type()) {
    case MANAGED_ENDPOINT_BOUND_MESSAGE_TYPE:
        {
            if (!mAwaitingManagedEndpointBind) {
                NS_WARNING("Unexpected managed endpoint lifecycle message after actor bound!");
                return MsgNotAllowed;
            }
            mAwaitingManagedEndpointBind = false;
            return MsgProcessed;
        }
    case MANAGED_ENDPOINT_DROPPED_MESSAGE_TYPE:
        {
            if (!mAwaitingManagedEndpointBind) {
                NS_WARNING("Unexpected managed endpoint lifecycle message after actor bound!");
                return MsgNotAllowed;
            }
            mAwaitingManagedEndpointBind = false;
            this->ActorDisconnected(ManagedEndpointDropped);
            return MsgProcessed;
        }
    case PMessagePort::Msg_PostMessages__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PMessagePort", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PMessagePortParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PMessagePort::Msg_PostMessages", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__messages = IPC::ReadParam<nsTArray<MessageData>>((&(reader__)));
            if (!maybe__messages) {
                FatalError("Error deserializing 'MessageData[]'");
                return MsgValueError;

            }
            auto& messages = *maybe__messages;
            // Sentinel = 'messages'
            if ((!(((&(reader__)))->ReadSentinel(253363033)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'MessageData[]'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::IPCResult __ok = (static_cast<MessagePortParent*>(this))->RecvPostMessages(std::move(messages));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PMessagePort::Msg_Disentangle__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PMessagePort", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PMessagePortParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PMessagePort::Msg_Disentangle", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__messages = IPC::ReadParam<nsTArray<MessageData>>((&(reader__)));
            if (!maybe__messages) {
                FatalError("Error deserializing 'MessageData[]'");
                return MsgValueError;

            }
            auto& messages = *maybe__messages;
            // Sentinel = 'messages'
            if ((!(((&(reader__)))->ReadSentinel(253363033)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'MessageData[]'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::IPCResult __ok = (static_cast<MessagePortParent*>(this))->RecvDisentangle(std::move(messages));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PMessagePort::Msg_StopSendingData__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PMessagePort", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PMessagePortParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PMessagePort::Msg_StopSendingData", OTHER);

            mozilla::ipc::IPCResult __ok = (static_cast<MessagePortParent*>(this))->RecvStopSendingData();
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PMessagePort::Msg_Close__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PMessagePort", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PMessagePortParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PMessagePort::Msg_Close", OTHER);

            mozilla::ipc::IPCResult __ok = (static_cast<MessagePortParent*>(this))->RecvClose();
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PMessagePort::Reply___delete____ID:
        {
            return MsgProcessed;
        }
    default:
        return MsgNotKnown;
    }
}

auto PMessagePortParent::OnMessageReceived(
        const Message& msg__,
        UniquePtr<Message>& reply__) -> PMessagePortParent::Result
{
    return MsgNotKnown;
}



} // namespace dom
} // namespace mozilla
namespace IPC {
auto ParamTraits<::mozilla::dom::PMessagePortParent*>::Write(
        IPC::MessageWriter* aWriter,
        const paramType& aVar) -> void
{
    MOZ_RELEASE_ASSERT(
        aWriter->GetActor(),
        "Cannot serialize managed actors without an actor");

    int32_t id;
    if (!aVar) {
        id = 0;  // kNullActorId
    } else {
        id = aVar->Id();
        if (id == 1) {  // kFreedActorId
            aVar->FatalError("Actor has been |delete|d");
        }
        MOZ_RELEASE_ASSERT(
            aWriter->GetActor()->GetIPCChannel() == aVar->GetIPCChannel(),
            "Actor must be from the same channel as the"
            " actor it's being sent over");
        MOZ_RELEASE_ASSERT(
            aVar->CanSend(),
            "Actor must still be open when sending");
    }

    IPC::WriteParam(aWriter, id);
}

auto ParamTraits<::mozilla::dom::PMessagePortParent*>::Read(IPC::MessageReader* aReader) -> IPC::ReadResult<paramType>
{
    MOZ_RELEASE_ASSERT(
        aReader->GetActor(),
        "Cannot deserialize managed actors without an actor");
    mozilla::Maybe<mozilla::ipc::IProtocol*> actor = aReader->GetActor()
        ->ReadActor(aReader, true, "PMessagePort", PMessagePortMsgStart);
    if (actor.isSome()) {
        return static_cast<::mozilla::dom::PMessagePortParent*>(actor.ref());
    }
    return {};
}

} // namespace IPC
