//
// Automatically generated by ipdlc.
// Edit at your own risk
//


#include "mozilla/dom/PMediaTransportParent.h"
#include "mozilla/ProfilerLabels.h"
#include "mozilla/dom/MediaTransportParent.h"
#include "mozilla/dom/RTCStatsReportBinding.h"
#include "mozilla/media/webrtc/WebrtcIPCTraits.h"
#include "mozilla/net/NrIceStunAddrMessageUtils.h"

#include "mozilla/ipc/PBackgroundParent.h"

#include "ipc/IPCMessageUtils.h"
#include "ipc/IPCMessageUtilsSpecializations.h"
#include "nsIFile.h"
#include "mozilla/ipc/Endpoint.h"
#include "mozilla/ipc/ProtocolMessageUtils.h"
#include "mozilla/ipc/ProtocolUtils.h"
#include "mozilla/ipc/ShmemMessageUtils.h"
#include "mozilla/ipc/TaintingIPCUtils.h"

namespace mozilla {
namespace dom {


auto PMediaTransportParent::ProcessingError(
        Result aCode,
        const char* aReason) -> void
{
}

auto PMediaTransportParent::ShouldContinueFromReplyTimeout() -> bool
{
    return true;
}

MOZ_IMPLICIT PMediaTransportParent::PMediaTransportParent() :
    mozilla::ipc::IToplevelProtocol("PMediaTransportParent", kProtocolId, mozilla::ipc::ParentSide)
{
    MOZ_COUNT_CTOR(PMediaTransportParent);
}

PMediaTransportParent::~PMediaTransportParent()
{
    MOZ_COUNT_DTOR(PMediaTransportParent);
}

auto PMediaTransportParent::ActorAlloc() -> void
{
    MOZ_RELEASE_ASSERT(XRE_IsSocketProcess(), "Invalid process for `PMediaTransportParent'");
    AddRef();
}

auto PMediaTransportParent::ActorDealloc() -> void
{
    Release();
}

auto PMediaTransportParent::ManagedProtocolIds() const -> mozilla::Span<mozilla::ipc::ProtocolId const>
{
    return {};
}

auto PMediaTransportParent::GetManagedActors(mozilla::ipc::ProtocolId aProtocol) -> UntypedManagedContainer*
{
    switch (aProtocol) {
    default:
        return nullptr;
    }
}

auto PMediaTransportParent::RejectPendingResponses(ResponseRejectReason aReason) -> void
{
    mAsyncCallbacks.RejectPendingResponses(aReason);
}

auto PMediaTransportParent::SendOnCandidate(
        const string& transportId,
        const CandidateInfo& candidateInfo) -> bool
{
    UniquePtr<IPC::Message> msg__ = PMediaTransport::Msg_OnCandidate(MSG_ROUTING_CONTROL);
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), transportId);
    // Sentinel = 'transportId'
    ((&(writer__)))->WriteSentinel(475923611);
    IPC::WriteParam((&(writer__)), candidateInfo);
    // Sentinel = 'candidateInfo'
    ((&(writer__)))->WriteSentinel(605291818);




    if (mozilla::ipc::LoggingEnabledFor("PMediaTransport", mozilla::ipc::ParentSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PMediaTransportParent",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PMediaTransport::Msg_OnCandidate", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PMediaTransportParent::SendOnAlpnNegotiated(const string& alpn) -> bool
{
    UniquePtr<IPC::Message> msg__ = PMediaTransport::Msg_OnAlpnNegotiated(MSG_ROUTING_CONTROL);
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), alpn);
    // Sentinel = 'alpn'
    ((&(writer__)))->WriteSentinel(68813228);




    if (mozilla::ipc::LoggingEnabledFor("PMediaTransport", mozilla::ipc::ParentSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PMediaTransportParent",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PMediaTransport::Msg_OnAlpnNegotiated", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PMediaTransportParent::SendOnGatheringStateChange(
        const string& transportId,
        const int& state) -> bool
{
    UniquePtr<IPC::Message> msg__ = PMediaTransport::Msg_OnGatheringStateChange(MSG_ROUTING_CONTROL);
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), transportId);
    // Sentinel = 'transportId'
    ((&(writer__)))->WriteSentinel(475923611);
    IPC::WriteParam((&(writer__)), state);
    // Sentinel = 'state'
    ((&(writer__)))->WriteSentinel(109314594);




    if (mozilla::ipc::LoggingEnabledFor("PMediaTransport", mozilla::ipc::ParentSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PMediaTransportParent",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PMediaTransport::Msg_OnGatheringStateChange", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PMediaTransportParent::SendOnConnectionStateChange(
        const string& transportId,
        const int& state) -> bool
{
    UniquePtr<IPC::Message> msg__ = PMediaTransport::Msg_OnConnectionStateChange(MSG_ROUTING_CONTROL);
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), transportId);
    // Sentinel = 'transportId'
    ((&(writer__)))->WriteSentinel(475923611);
    IPC::WriteParam((&(writer__)), state);
    // Sentinel = 'state'
    ((&(writer__)))->WriteSentinel(109314594);




    if (mozilla::ipc::LoggingEnabledFor("PMediaTransport", mozilla::ipc::ParentSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PMediaTransportParent",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PMediaTransport::Msg_OnConnectionStateChange", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PMediaTransportParent::SendOnPacketReceived(
        const string& transportId,
        const MediaPacket& packet) -> bool
{
    UniquePtr<IPC::Message> msg__ = PMediaTransport::Msg_OnPacketReceived(MSG_ROUTING_CONTROL);
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), transportId);
    // Sentinel = 'transportId'
    ((&(writer__)))->WriteSentinel(475923611);
    IPC::WriteParam((&(writer__)), packet);
    // Sentinel = 'packet'
    ((&(writer__)))->WriteSentinel(144048761);




    if (mozilla::ipc::LoggingEnabledFor("PMediaTransport", mozilla::ipc::ParentSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PMediaTransportParent",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PMediaTransport::Msg_OnPacketReceived", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PMediaTransportParent::SendOnEncryptedSending(
        const string& transportId,
        const MediaPacket& packet) -> bool
{
    UniquePtr<IPC::Message> msg__ = PMediaTransport::Msg_OnEncryptedSending(MSG_ROUTING_CONTROL);
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), transportId);
    // Sentinel = 'transportId'
    ((&(writer__)))->WriteSentinel(475923611);
    IPC::WriteParam((&(writer__)), packet);
    // Sentinel = 'packet'
    ((&(writer__)))->WriteSentinel(144048761);




    if (mozilla::ipc::LoggingEnabledFor("PMediaTransport", mozilla::ipc::ParentSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PMediaTransportParent",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PMediaTransport::Msg_OnEncryptedSending", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PMediaTransportParent::SendOnStateChange(
        const string& transportId,
        const int& state) -> bool
{
    UniquePtr<IPC::Message> msg__ = PMediaTransport::Msg_OnStateChange(MSG_ROUTING_CONTROL);
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), transportId);
    // Sentinel = 'transportId'
    ((&(writer__)))->WriteSentinel(475923611);
    IPC::WriteParam((&(writer__)), state);
    // Sentinel = 'state'
    ((&(writer__)))->WriteSentinel(109314594);




    if (mozilla::ipc::LoggingEnabledFor("PMediaTransport", mozilla::ipc::ParentSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PMediaTransportParent",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PMediaTransport::Msg_OnStateChange", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PMediaTransportParent::SendOnRtcpStateChange(
        const string& transportId,
        const int& state) -> bool
{
    UniquePtr<IPC::Message> msg__ = PMediaTransport::Msg_OnRtcpStateChange(MSG_ROUTING_CONTROL);
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), transportId);
    // Sentinel = 'transportId'
    ((&(writer__)))->WriteSentinel(475923611);
    IPC::WriteParam((&(writer__)), state);
    // Sentinel = 'state'
    ((&(writer__)))->WriteSentinel(109314594);




    if (mozilla::ipc::LoggingEnabledFor("PMediaTransport", mozilla::ipc::ParentSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PMediaTransportParent",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PMediaTransport::Msg_OnRtcpStateChange", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PMediaTransportParent::DeallocManagee(
        int32_t aProtocolId,
        IProtocol* aListener) -> void
{
    FatalError("unreached");
    return;
}

auto PMediaTransportParent::OnMessageReceived(const Message& msg__) -> PMediaTransportParent::Result
{
    switch (msg__.type()) {
    case PMediaTransport::Msg_GetIceLog__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PMediaTransport", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PMediaTransportParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PMediaTransport::Msg_GetIceLog", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__pattern = IPC::ReadParam<nsCString>((&(reader__)));
            if (!maybe__pattern) {
                FatalError("Error deserializing 'nsCString'");
                return MsgValueError;

            }
            auto& pattern = *maybe__pattern;
            // Sentinel = 'pattern'
            if ((!(((&(reader__)))->ReadSentinel(200409855)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'nsCString'");
                return MsgValueError;
            }
            reader__.EndRead();
            int32_t id__ = MSG_ROUTING_CONTROL;
            UniquePtr<IPC::Message> reply__(PMediaTransport::Reply_GetIceLog(id__));
            reply__->set_seqno(msg__.seqno());

            RefPtr<mozilla::ipc::IPDLResolverInner> resolver__ =
                new mozilla::ipc::IPDLResolverInner(std::move(reply__), this);

            GetIceLogResolver resolver = [resolver__ = std::move(resolver__)](const WebrtcGlobalLog& aParam) {
                resolver__->Resolve([&] (IPC::Message* reply__, IProtocol* self__) {
                    IPC::MessageWriter writer__(*reply__, self__);
                    IPC::WriteParam((&(writer__)), aParam);
                    // Sentinel = 'loglines'
                    ((&(writer__)))->WriteSentinel(253887326);

                    if (mozilla::ipc::LoggingEnabledFor("PMediaTransport", mozilla::ipc::ParentSide)) {
                        mozilla::ipc::LogMessageForProtocol(
                            "PMediaTransportParent",
                            self__->ToplevelProtocol()->OtherPidMaybeInvalid(),
                            "Sending reply ",
                            reply__->type(),
                            mozilla::ipc::MessageDirection::eSending);
                    }

                });
            };
            mozilla::ipc::IPCResult __ok = (static_cast<MediaTransportParent*>(this))->RecvGetIceLog(std::move(pattern), std::move(resolver));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PMediaTransport::Msg_ClearIceLog__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PMediaTransport", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PMediaTransportParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PMediaTransport::Msg_ClearIceLog", OTHER);

            mozilla::ipc::IPCResult __ok = (static_cast<MediaTransportParent*>(this))->RecvClearIceLog();
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PMediaTransport::Msg_EnterPrivateMode__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PMediaTransport", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PMediaTransportParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PMediaTransport::Msg_EnterPrivateMode", OTHER);

            mozilla::ipc::IPCResult __ok = (static_cast<MediaTransportParent*>(this))->RecvEnterPrivateMode();
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PMediaTransport::Msg_ExitPrivateMode__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PMediaTransport", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PMediaTransportParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PMediaTransport::Msg_ExitPrivateMode", OTHER);

            mozilla::ipc::IPCResult __ok = (static_cast<MediaTransportParent*>(this))->RecvExitPrivateMode();
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PMediaTransport::Msg_CreateIceCtx__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PMediaTransport", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PMediaTransportParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PMediaTransport::Msg_CreateIceCtx", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__name = IPC::ReadParam<string>((&(reader__)));
            if (!maybe__name) {
                FatalError("Error deserializing 'string'");
                return MsgValueError;

            }
            auto& name = *maybe__name;
            // Sentinel = 'name'
            if ((!(((&(reader__)))->ReadSentinel(69075362)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'string'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::IPCResult __ok = (static_cast<MediaTransportParent*>(this))->RecvCreateIceCtx(std::move(name));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PMediaTransport::Msg_SetIceConfig__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PMediaTransport", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PMediaTransportParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PMediaTransport::Msg_SetIceConfig", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__iceServers = IPC::ReadParam<nsTArray<RTCIceServer>>((&(reader__)));
            if (!maybe__iceServers) {
                FatalError("Error deserializing 'RTCIceServer[]'");
                return MsgValueError;

            }
            auto& iceServers = *maybe__iceServers;
            // Sentinel = 'iceServers'
            if ((!(((&(reader__)))->ReadSentinel(369230876)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'RTCIceServer[]'");
                return MsgValueError;
            }
            auto maybe__icePolicy = IPC::ReadParam<RTCIceTransportPolicy>((&(reader__)));
            if (!maybe__icePolicy) {
                FatalError("Error deserializing 'RTCIceTransportPolicy'");
                return MsgValueError;

            }
            auto& icePolicy = *maybe__icePolicy;
            // Sentinel = 'icePolicy'
            if ((!(((&(reader__)))->ReadSentinel(298451874)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'RTCIceTransportPolicy'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::IPCResult __ok = (static_cast<MediaTransportParent*>(this))->RecvSetIceConfig(std::move(iceServers), std::move(icePolicy));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PMediaTransport::Msg_SetProxyConfig__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PMediaTransport", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PMediaTransportParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PMediaTransport::Msg_SetProxyConfig", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__proxyConfig = IPC::ReadParam<WebrtcProxyConfig>((&(reader__)));
            if (!maybe__proxyConfig) {
                FatalError("Error deserializing 'WebrtcProxyConfig'");
                return MsgValueError;

            }
            auto& proxyConfig = *maybe__proxyConfig;
            // Sentinel = 'proxyConfig'
            if ((!(((&(reader__)))->ReadSentinel(472188057)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'WebrtcProxyConfig'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::IPCResult __ok = (static_cast<MediaTransportParent*>(this))->RecvSetProxyConfig(std::move(proxyConfig));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PMediaTransport::Msg_EnsureProvisionalTransport__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PMediaTransport", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PMediaTransportParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PMediaTransport::Msg_EnsureProvisionalTransport", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__transportId = IPC::ReadParam<string>((&(reader__)));
            if (!maybe__transportId) {
                FatalError("Error deserializing 'string'");
                return MsgValueError;

            }
            auto& transportId = *maybe__transportId;
            // Sentinel = 'transportId'
            if ((!(((&(reader__)))->ReadSentinel(475923611)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'string'");
                return MsgValueError;
            }
            auto maybe__localUfrag = IPC::ReadParam<string>((&(reader__)));
            if (!maybe__localUfrag) {
                FatalError("Error deserializing 'string'");
                return MsgValueError;

            }
            auto& localUfrag = *maybe__localUfrag;
            // Sentinel = 'localUfrag'
            if ((!(((&(reader__)))->ReadSentinel(372245505)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'string'");
                return MsgValueError;
            }
            auto maybe__localPwd = IPC::ReadParam<string>((&(reader__)));
            if (!maybe__localPwd) {
                FatalError("Error deserializing 'string'");
                return MsgValueError;

            }
            auto& localPwd = *maybe__localPwd;
            // Sentinel = 'localPwd'
            if ((!(((&(reader__)))->ReadSentinel(244974391)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'string'");
                return MsgValueError;
            }
            auto maybe__componentCount = IPC::ReadParam<int>((&(reader__)));
            if (!maybe__componentCount) {
                FatalError("Error deserializing 'int'");
                return MsgValueError;

            }
            auto& componentCount = *maybe__componentCount;
            // Sentinel = 'componentCount'
            if ((!(((&(reader__)))->ReadSentinel(735512029)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'int'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::IPCResult __ok = (static_cast<MediaTransportParent*>(this))->RecvEnsureProvisionalTransport(std::move(transportId), std::move(localUfrag), std::move(localPwd), std::move(componentCount));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PMediaTransport::Msg_SetTargetForDefaultLocalAddressLookup__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PMediaTransport", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PMediaTransportParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PMediaTransport::Msg_SetTargetForDefaultLocalAddressLookup", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__targetIp = IPC::ReadParam<string>((&(reader__)));
            if (!maybe__targetIp) {
                FatalError("Error deserializing 'string'");
                return MsgValueError;

            }
            auto& targetIp = *maybe__targetIp;
            // Sentinel = 'targetIp'
            if ((!(((&(reader__)))->ReadSentinel(250610497)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'string'");
                return MsgValueError;
            }
            auto maybe__targetPort = IPC::ReadParam<uint16_t>((&(reader__)));
            if (!maybe__targetPort) {
                FatalError("Error deserializing 'uint16_t'");
                return MsgValueError;

            }
            auto& targetPort = *maybe__targetPort;
            // Sentinel = 'targetPort'
            if ((!(((&(reader__)))->ReadSentinel(383976493)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'uint16_t'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::IPCResult __ok = (static_cast<MediaTransportParent*>(this))->RecvSetTargetForDefaultLocalAddressLookup(std::move(targetIp), std::move(targetPort));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PMediaTransport::Msg_StartIceGathering__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PMediaTransport", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PMediaTransportParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PMediaTransport::Msg_StartIceGathering", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__defaultRouteOnly = IPC::ReadParam<bool>((&(reader__)));
            if (!maybe__defaultRouteOnly) {
                FatalError("Error deserializing 'bool'");
                return MsgValueError;

            }
            auto& defaultRouteOnly = *maybe__defaultRouteOnly;
            // Sentinel = 'defaultRouteOnly'
            if ((!(((&(reader__)))->ReadSentinel(930678423)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'bool'");
                return MsgValueError;
            }
            auto maybe__obfuscateHostAddresses = IPC::ReadParam<bool>((&(reader__)));
            if (!maybe__obfuscateHostAddresses) {
                FatalError("Error deserializing 'bool'");
                return MsgValueError;

            }
            auto& obfuscateHostAddresses = *maybe__obfuscateHostAddresses;
            // Sentinel = 'obfuscateHostAddresses'
            if ((!(((&(reader__)))->ReadSentinel(1725761785)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'bool'");
                return MsgValueError;
            }
            auto maybe__stunAddrs = IPC::ReadParam<NrIceStunAddrArray>((&(reader__)));
            if (!maybe__stunAddrs) {
                FatalError("Error deserializing 'NrIceStunAddrArray'");
                return MsgValueError;

            }
            auto& stunAddrs = *maybe__stunAddrs;
            // Sentinel = 'stunAddrs'
            if ((!(((&(reader__)))->ReadSentinel(315818937)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'NrIceStunAddrArray'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::IPCResult __ok = (static_cast<MediaTransportParent*>(this))->RecvStartIceGathering(std::move(defaultRouteOnly), std::move(obfuscateHostAddresses), std::move(stunAddrs));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PMediaTransport::Msg_ActivateTransport__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PMediaTransport", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PMediaTransportParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PMediaTransport::Msg_ActivateTransport", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__transportId = IPC::ReadParam<string>((&(reader__)));
            if (!maybe__transportId) {
                FatalError("Error deserializing 'string'");
                return MsgValueError;

            }
            auto& transportId = *maybe__transportId;
            // Sentinel = 'transportId'
            if ((!(((&(reader__)))->ReadSentinel(475923611)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'string'");
                return MsgValueError;
            }
            auto maybe__localUfrag = IPC::ReadParam<string>((&(reader__)));
            if (!maybe__localUfrag) {
                FatalError("Error deserializing 'string'");
                return MsgValueError;

            }
            auto& localUfrag = *maybe__localUfrag;
            // Sentinel = 'localUfrag'
            if ((!(((&(reader__)))->ReadSentinel(372245505)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'string'");
                return MsgValueError;
            }
            auto maybe__localPwd = IPC::ReadParam<string>((&(reader__)));
            if (!maybe__localPwd) {
                FatalError("Error deserializing 'string'");
                return MsgValueError;

            }
            auto& localPwd = *maybe__localPwd;
            // Sentinel = 'localPwd'
            if ((!(((&(reader__)))->ReadSentinel(244974391)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'string'");
                return MsgValueError;
            }
            auto maybe__componentCount = IPC::ReadParam<int>((&(reader__)));
            if (!maybe__componentCount) {
                FatalError("Error deserializing 'int'");
                return MsgValueError;

            }
            auto& componentCount = *maybe__componentCount;
            // Sentinel = 'componentCount'
            if ((!(((&(reader__)))->ReadSentinel(735512029)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'int'");
                return MsgValueError;
            }
            auto maybe__remoteUfrag = IPC::ReadParam<string>((&(reader__)));
            if (!maybe__remoteUfrag) {
                FatalError("Error deserializing 'string'");
                return MsgValueError;

            }
            auto& remoteUfrag = *maybe__remoteUfrag;
            // Sentinel = 'remoteUfrag'
            if ((!(((&(reader__)))->ReadSentinel(460981378)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'string'");
                return MsgValueError;
            }
            auto maybe__remotePwd = IPC::ReadParam<string>((&(reader__)));
            if (!maybe__remotePwd) {
                FatalError("Error deserializing 'string'");
                return MsgValueError;

            }
            auto& remotePwd = *maybe__remotePwd;
            // Sentinel = 'remotePwd'
            if ((!(((&(reader__)))->ReadSentinel(316801976)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'string'");
                return MsgValueError;
            }
            auto maybe__keyDer = IPC::ReadParam<nsTArray<uint8_t>>((&(reader__)));
            if (!maybe__keyDer) {
                FatalError("Error deserializing 'uint8_t[]'");
                return MsgValueError;

            }
            auto& keyDer = *maybe__keyDer;
            // Sentinel = 'keyDer'
            if ((!(((&(reader__)))->ReadSentinel(141361765)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'uint8_t[]'");
                return MsgValueError;
            }
            auto maybe__certDer = IPC::ReadParam<nsTArray<uint8_t>>((&(reader__)));
            if (!maybe__certDer) {
                FatalError("Error deserializing 'uint8_t[]'");
                return MsgValueError;

            }
            auto& certDer = *maybe__certDer;
            // Sentinel = 'certDer'
            if ((!(((&(reader__)))->ReadSentinel(187433674)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'uint8_t[]'");
                return MsgValueError;
            }
            auto maybe__authType = IPC::ReadParam<int>((&(reader__)));
            if (!maybe__authType) {
                FatalError("Error deserializing 'int'");
                return MsgValueError;

            }
            auto& authType = *maybe__authType;
            // Sentinel = 'authType'
            if ((!(((&(reader__)))->ReadSentinel(251855701)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'int'");
                return MsgValueError;
            }
            auto maybe__dtlsClient = IPC::ReadParam<bool>((&(reader__)));
            if (!maybe__dtlsClient) {
                FatalError("Error deserializing 'bool'");
                return MsgValueError;

            }
            auto& dtlsClient = *maybe__dtlsClient;
            // Sentinel = 'dtlsClient'
            if ((!(((&(reader__)))->ReadSentinel(375129111)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'bool'");
                return MsgValueError;
            }
            auto maybe__digests = IPC::ReadParam<DtlsDigestList>((&(reader__)));
            if (!maybe__digests) {
                FatalError("Error deserializing 'DtlsDigestList'");
                return MsgValueError;

            }
            auto& digests = *maybe__digests;
            // Sentinel = 'digests'
            if ((!(((&(reader__)))->ReadSentinel(193200884)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'DtlsDigestList'");
                return MsgValueError;
            }
            auto maybe__privacyRequested = IPC::ReadParam<bool>((&(reader__)));
            if (!maybe__privacyRequested) {
                FatalError("Error deserializing 'bool'");
                return MsgValueError;

            }
            auto& privacyRequested = *maybe__privacyRequested;
            // Sentinel = 'privacyRequested'
            if ((!(((&(reader__)))->ReadSentinel(959383217)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'bool'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::IPCResult __ok = (static_cast<MediaTransportParent*>(this))->RecvActivateTransport(std::move(transportId), std::move(localUfrag), std::move(localPwd), std::move(componentCount), std::move(remoteUfrag), std::move(remotePwd), std::move(keyDer), std::move(certDer), std::move(authType), std::move(dtlsClient), std::move(digests), std::move(privacyRequested));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PMediaTransport::Msg_RemoveTransportsExcept__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PMediaTransport", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PMediaTransportParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PMediaTransport::Msg_RemoveTransportsExcept", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__transportIds = IPC::ReadParam<StringVector>((&(reader__)));
            if (!maybe__transportIds) {
                FatalError("Error deserializing 'StringVector'");
                return MsgValueError;

            }
            auto& transportIds = *maybe__transportIds;
            // Sentinel = 'transportIds'
            if ((!(((&(reader__)))->ReadSentinel(560727310)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'StringVector'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::IPCResult __ok = (static_cast<MediaTransportParent*>(this))->RecvRemoveTransportsExcept(std::move(transportIds));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PMediaTransport::Msg_StartIceChecks__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PMediaTransport", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PMediaTransportParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PMediaTransport::Msg_StartIceChecks", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__isControlling = IPC::ReadParam<bool>((&(reader__)));
            if (!maybe__isControlling) {
                FatalError("Error deserializing 'bool'");
                return MsgValueError;

            }
            auto& isControlling = *maybe__isControlling;
            // Sentinel = 'isControlling'
            if ((!(((&(reader__)))->ReadSentinel(628950376)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'bool'");
                return MsgValueError;
            }
            auto maybe__iceOptions = IPC::ReadParam<StringVector>((&(reader__)));
            if (!maybe__iceOptions) {
                FatalError("Error deserializing 'StringVector'");
                return MsgValueError;

            }
            auto& iceOptions = *maybe__iceOptions;
            // Sentinel = 'iceOptions'
            if ((!(((&(reader__)))->ReadSentinel(370410526)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'StringVector'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::IPCResult __ok = (static_cast<MediaTransportParent*>(this))->RecvStartIceChecks(std::move(isControlling), std::move(iceOptions));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PMediaTransport::Msg_SendPacket__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PMediaTransport", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PMediaTransportParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PMediaTransport::Msg_SendPacket", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__transportId = IPC::ReadParam<string>((&(reader__)));
            if (!maybe__transportId) {
                FatalError("Error deserializing 'string'");
                return MsgValueError;

            }
            auto& transportId = *maybe__transportId;
            // Sentinel = 'transportId'
            if ((!(((&(reader__)))->ReadSentinel(475923611)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'string'");
                return MsgValueError;
            }
            auto maybe__packet = IPC::ReadParam<MediaPacket>((&(reader__)));
            if (!maybe__packet) {
                FatalError("Error deserializing 'MediaPacket'");
                return MsgValueError;

            }
            auto& packet = *maybe__packet;
            // Sentinel = 'packet'
            if ((!(((&(reader__)))->ReadSentinel(144048761)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'MediaPacket'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::IPCResult __ok = (static_cast<MediaTransportParent*>(this))->RecvSendPacket(std::move(transportId), std::move(packet));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PMediaTransport::Msg_AddIceCandidate__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PMediaTransport", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PMediaTransportParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PMediaTransport::Msg_AddIceCandidate", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__transportId = IPC::ReadParam<string>((&(reader__)));
            if (!maybe__transportId) {
                FatalError("Error deserializing 'string'");
                return MsgValueError;

            }
            auto& transportId = *maybe__transportId;
            // Sentinel = 'transportId'
            if ((!(((&(reader__)))->ReadSentinel(475923611)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'string'");
                return MsgValueError;
            }
            auto maybe__candidate = IPC::ReadParam<string>((&(reader__)));
            if (!maybe__candidate) {
                FatalError("Error deserializing 'string'");
                return MsgValueError;

            }
            auto& candidate = *maybe__candidate;
            // Sentinel = 'candidate'
            if ((!(((&(reader__)))->ReadSentinel(301138846)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'string'");
                return MsgValueError;
            }
            auto maybe__ufrag = IPC::ReadParam<string>((&(reader__)));
            if (!maybe__ufrag) {
                FatalError("Error deserializing 'string'");
                return MsgValueError;

            }
            auto& ufrag = *maybe__ufrag;
            // Sentinel = 'ufrag'
            if ((!(((&(reader__)))->ReadSentinel(107282966)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'string'");
                return MsgValueError;
            }
            auto maybe__obfuscatedAddr = IPC::ReadParam<string>((&(reader__)));
            if (!maybe__obfuscatedAddr) {
                FatalError("Error deserializing 'string'");
                return MsgValueError;

            }
            auto& obfuscatedAddr = *maybe__obfuscatedAddr;
            // Sentinel = 'obfuscatedAddr'
            if ((!(((&(reader__)))->ReadSentinel(718407068)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'string'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::IPCResult __ok = (static_cast<MediaTransportParent*>(this))->RecvAddIceCandidate(std::move(transportId), std::move(candidate), std::move(ufrag), std::move(obfuscatedAddr));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PMediaTransport::Msg_UpdateNetworkState__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PMediaTransport", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PMediaTransportParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PMediaTransport::Msg_UpdateNetworkState", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__online = IPC::ReadParam<bool>((&(reader__)));
            if (!maybe__online) {
                FatalError("Error deserializing 'bool'");
                return MsgValueError;

            }
            auto& online = *maybe__online;
            // Sentinel = 'online'
            if ((!(((&(reader__)))->ReadSentinel(150078086)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'bool'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::IPCResult __ok = (static_cast<MediaTransportParent*>(this))->RecvUpdateNetworkState(std::move(online));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PMediaTransport::Msg_GetIceStats__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PMediaTransport", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PMediaTransportParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PMediaTransport::Msg_GetIceStats", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__transportId = IPC::ReadParam<string>((&(reader__)));
            if (!maybe__transportId) {
                FatalError("Error deserializing 'string'");
                return MsgValueError;

            }
            auto& transportId = *maybe__transportId;
            // Sentinel = 'transportId'
            if ((!(((&(reader__)))->ReadSentinel(475923611)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'string'");
                return MsgValueError;
            }
            auto maybe__now = IPC::ReadParam<double>((&(reader__)));
            if (!maybe__now) {
                FatalError("Error deserializing 'double'");
                return MsgValueError;

            }
            auto& now = *maybe__now;
            // Sentinel = 'now'
            if ((!(((&(reader__)))->ReadSentinel(44171605)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'double'");
                return MsgValueError;
            }
            reader__.EndRead();
            int32_t id__ = MSG_ROUTING_CONTROL;
            UniquePtr<IPC::Message> reply__(PMediaTransport::Reply_GetIceStats(id__));
            reply__->set_seqno(msg__.seqno());

            RefPtr<mozilla::ipc::IPDLResolverInner> resolver__ =
                new mozilla::ipc::IPDLResolverInner(std::move(reply__), this);

            GetIceStatsResolver resolver = [resolver__ = std::move(resolver__)](const UniquePtr<RTCStatsCollection>& aParam) {
                resolver__->Resolve([&] (IPC::Message* reply__, IProtocol* self__) {
                    IPC::MessageWriter writer__(*reply__, self__);
                    IPC::WriteParam((&(writer__)), aParam);
                    // Sentinel = 'stats'
                    ((&(writer__)))->WriteSentinel(110232112);

                    if (mozilla::ipc::LoggingEnabledFor("PMediaTransport", mozilla::ipc::ParentSide)) {
                        mozilla::ipc::LogMessageForProtocol(
                            "PMediaTransportParent",
                            self__->ToplevelProtocol()->OtherPidMaybeInvalid(),
                            "Sending reply ",
                            reply__->type(),
                            mozilla::ipc::MessageDirection::eSending);
                    }

                });
            };
            mozilla::ipc::IPCResult __ok = (static_cast<MediaTransportParent*>(this))->RecvGetIceStats(std::move(transportId), std::move(now), std::move(resolver));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    default:
        return MsgNotKnown;
    case SHMEM_CREATED_MESSAGE_TYPE:
        {
            if (!ShmemCreated(msg__)) {
                return MsgPayloadError;
            }
            return MsgProcessed;
        }
    case SHMEM_DESTROYED_MESSAGE_TYPE:
        {
            if (!ShmemDestroyed(msg__)) {
                return MsgPayloadError;
            }
            return MsgProcessed;
        }
    }
}

auto PMediaTransportParent::OnMessageReceived(
        const Message& msg__,
        UniquePtr<Message>& reply__) -> PMediaTransportParent::Result
{
    MOZ_ASSERT_UNREACHABLE("message protocol not supported");
    return MsgNotKnown;
}



} // namespace dom
} // namespace mozilla
namespace IPC {
auto ParamTraits<::mozilla::dom::PMediaTransportParent*>::Write(
        IPC::MessageWriter* aWriter,
        const paramType& aVar) -> void
{
    MOZ_RELEASE_ASSERT(
        aWriter->GetActor(),
        "Cannot serialize managed actors without an actor");

    int32_t id;
    if (!aVar) {
        id = 0;  // kNullActorId
    } else {
        id = aVar->Id();
        if (id == 1) {  // kFreedActorId
            aVar->FatalError("Actor has been |delete|d");
        }
        MOZ_RELEASE_ASSERT(
            aWriter->GetActor()->GetIPCChannel() == aVar->GetIPCChannel(),
            "Actor must be from the same channel as the"
            " actor it's being sent over");
        MOZ_RELEASE_ASSERT(
            aVar->CanSend(),
            "Actor must still be open when sending");
    }

    IPC::WriteParam(aWriter, id);
}

auto ParamTraits<::mozilla::dom::PMediaTransportParent*>::Read(IPC::MessageReader* aReader) -> IPC::ReadResult<paramType>
{
    MOZ_RELEASE_ASSERT(
        aReader->GetActor(),
        "Cannot deserialize managed actors without an actor");
    mozilla::Maybe<mozilla::ipc::IProtocol*> actor = aReader->GetActor()
        ->ReadActor(aReader, true, "PMediaTransport", PMediaTransportMsgStart);
    if (actor.isSome()) {
        return static_cast<::mozilla::dom::PMediaTransportParent*>(actor.ref());
    }
    return {};
}

} // namespace IPC
