//
// Automatically generated by ipdlc.
// Edit at your own risk
//


#include "mozilla/dom/PMediaTransportChild.h"
#include "mozilla/ProfilerLabels.h"
#include "mozilla/dom/MediaTransportChild.h"
#include "mozilla/dom/RTCStatsReportBinding.h"
#include "mozilla/media/webrtc/WebrtcIPCTraits.h"
#include "mozilla/net/NrIceStunAddrMessageUtils.h"

#include "mozilla/ipc/PBackgroundChild.h"

#include "ipc/IPCMessageUtils.h"
#include "ipc/IPCMessageUtilsSpecializations.h"
#include "nsIFile.h"
#include "mozilla/ipc/Endpoint.h"
#include "mozilla/ipc/ProtocolMessageUtils.h"
#include "mozilla/ipc/ProtocolUtils.h"
#include "mozilla/ipc/ShmemMessageUtils.h"
#include "mozilla/ipc/TaintingIPCUtils.h"

namespace mozilla {
namespace dom {


auto PMediaTransportChild::ProcessingError(
        Result aCode,
        const char* aReason) -> void
{
}

auto PMediaTransportChild::ShouldContinueFromReplyTimeout() -> bool
{
    return true;
}

MOZ_IMPLICIT PMediaTransportChild::PMediaTransportChild() :
    mozilla::ipc::IToplevelProtocol("PMediaTransportChild", kProtocolId, mozilla::ipc::ChildSide)
{
    MOZ_COUNT_CTOR(PMediaTransportChild);
}

PMediaTransportChild::~PMediaTransportChild()
{
    MOZ_COUNT_DTOR(PMediaTransportChild);
}

auto PMediaTransportChild::ActorAlloc() -> void
{
    MOZ_RELEASE_ASSERT(XRE_IsContentProcess(), "Invalid process for `PMediaTransportChild'");
    AddRef();
}

auto PMediaTransportChild::ActorDealloc() -> void
{
    Release();
}

auto PMediaTransportChild::ManagedProtocolIds() const -> mozilla::Span<mozilla::ipc::ProtocolId const>
{
    return {};
}

auto PMediaTransportChild::GetManagedActors(mozilla::ipc::ProtocolId aProtocol) -> UntypedManagedContainer*
{
    switch (aProtocol) {
    default:
        return nullptr;
    }
}

auto PMediaTransportChild::RejectPendingResponses(ResponseRejectReason aReason) -> void
{
    mAsyncCallbacks.RejectPendingResponses(aReason);
}

auto PMediaTransportChild::SendGetIceLog(
        const nsACString& pattern,
        mozilla::ipc::ResolveCallback<WebrtcGlobalLog>&& aResolve,
        mozilla::ipc::RejectCallback&& aReject) -> void
{
    UniquePtr<IPC::Message> msg__ = PMediaTransport::Msg_GetIceLog(MSG_ROUTING_CONTROL);
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), pattern);
    // Sentinel = 'pattern'
    ((&(writer__)))->WriteSentinel(200409855);




    if (mozilla::ipc::LoggingEnabledFor("PMediaTransport", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PMediaTransportChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PMediaTransport::Msg_GetIceLog", OTHER);

    int32_t seqno__ = 0;
    if (ChannelSend(std::move(msg__), (&(seqno__)))) {
        mAsyncCallbacks.AddCallback(seqno__, PMediaTransport::Reply_GetIceLog__ID, [resolve=std::move(aResolve)](IPC::MessageReader* aReader) mutable {
            auto maybe__loglines = IPC::ReadParam<WebrtcGlobalLog>(aReader);
            if (!maybe__loglines) {
                (aReader)->FatalError("Error deserializing 'WebrtcGlobalLog'");
                return MsgValueError;

            }
            auto& loglines = *maybe__loglines;
            // Sentinel = 'loglines'
            if ((!((aReader)->ReadSentinel(253887326)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'WebrtcGlobalLog'");
                return MsgValueError;
            }


            aReader->EndRead();

            resolve(std::move(loglines));
            return MsgProcessed;
        }, std::move(aReject));
    }
    else {
        aReject(::mozilla::ipc::ResponseRejectReason::SendError);
    }
    return;
}

auto PMediaTransportChild::SendGetIceLog(const nsACString& pattern) -> RefPtr<GetIceLogPromise>
{
    RefPtr<MozPromise<WebrtcGlobalLog, ResponseRejectReason, true>::Private> promise__ = new MozPromise<WebrtcGlobalLog, ResponseRejectReason, true>::Private(__func__);
    promise__->UseDirectTaskDispatch(__func__);
    SendGetIceLog(std::move(pattern), [promise__](WebrtcGlobalLog&& aValue) {
        promise__->Resolve(std::move(aValue), __func__);
    }, [promise__](ResponseRejectReason&& aReason) {
        promise__->Reject(std::move(aReason), __func__);
    });
    return promise__;
}

auto PMediaTransportChild::SendClearIceLog() -> bool
{
    UniquePtr<IPC::Message> msg__ = PMediaTransport::Msg_ClearIceLog(MSG_ROUTING_CONTROL);
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};





    if (mozilla::ipc::LoggingEnabledFor("PMediaTransport", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PMediaTransportChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PMediaTransport::Msg_ClearIceLog", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PMediaTransportChild::SendEnterPrivateMode() -> bool
{
    UniquePtr<IPC::Message> msg__ = PMediaTransport::Msg_EnterPrivateMode(MSG_ROUTING_CONTROL);
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};





    if (mozilla::ipc::LoggingEnabledFor("PMediaTransport", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PMediaTransportChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PMediaTransport::Msg_EnterPrivateMode", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PMediaTransportChild::SendExitPrivateMode() -> bool
{
    UniquePtr<IPC::Message> msg__ = PMediaTransport::Msg_ExitPrivateMode(MSG_ROUTING_CONTROL);
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};





    if (mozilla::ipc::LoggingEnabledFor("PMediaTransport", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PMediaTransportChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PMediaTransport::Msg_ExitPrivateMode", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PMediaTransportChild::SendCreateIceCtx(const string& name) -> bool
{
    UniquePtr<IPC::Message> msg__ = PMediaTransport::Msg_CreateIceCtx(MSG_ROUTING_CONTROL);
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), name);
    // Sentinel = 'name'
    ((&(writer__)))->WriteSentinel(69075362);




    if (mozilla::ipc::LoggingEnabledFor("PMediaTransport", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PMediaTransportChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PMediaTransport::Msg_CreateIceCtx", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PMediaTransportChild::SendSetIceConfig(
        mozilla::Span<RTCIceServer const> iceServers,
        const RTCIceTransportPolicy& icePolicy) -> bool
{
    UniquePtr<IPC::Message> msg__ = PMediaTransport::Msg_SetIceConfig(MSG_ROUTING_CONTROL);
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), iceServers);
    // Sentinel = 'iceServers'
    ((&(writer__)))->WriteSentinel(369230876);
    IPC::WriteParam((&(writer__)), icePolicy);
    // Sentinel = 'icePolicy'
    ((&(writer__)))->WriteSentinel(298451874);




    if (mozilla::ipc::LoggingEnabledFor("PMediaTransport", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PMediaTransportChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PMediaTransport::Msg_SetIceConfig", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PMediaTransportChild::SendSetProxyConfig(const WebrtcProxyConfig& proxyConfig) -> bool
{
    UniquePtr<IPC::Message> msg__ = PMediaTransport::Msg_SetProxyConfig(MSG_ROUTING_CONTROL);
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), proxyConfig);
    // Sentinel = 'proxyConfig'
    ((&(writer__)))->WriteSentinel(472188057);




    if (mozilla::ipc::LoggingEnabledFor("PMediaTransport", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PMediaTransportChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PMediaTransport::Msg_SetProxyConfig", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PMediaTransportChild::SendEnsureProvisionalTransport(
        const string& transportId,
        const string& localUfrag,
        const string& localPwd,
        const int& componentCount) -> bool
{
    UniquePtr<IPC::Message> msg__ = PMediaTransport::Msg_EnsureProvisionalTransport(MSG_ROUTING_CONTROL);
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), transportId);
    // Sentinel = 'transportId'
    ((&(writer__)))->WriteSentinel(475923611);
    IPC::WriteParam((&(writer__)), localUfrag);
    // Sentinel = 'localUfrag'
    ((&(writer__)))->WriteSentinel(372245505);
    IPC::WriteParam((&(writer__)), localPwd);
    // Sentinel = 'localPwd'
    ((&(writer__)))->WriteSentinel(244974391);
    IPC::WriteParam((&(writer__)), componentCount);
    // Sentinel = 'componentCount'
    ((&(writer__)))->WriteSentinel(735512029);




    if (mozilla::ipc::LoggingEnabledFor("PMediaTransport", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PMediaTransportChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PMediaTransport::Msg_EnsureProvisionalTransport", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PMediaTransportChild::SendSetTargetForDefaultLocalAddressLookup(
        const string& targetIp,
        const uint16_t& targetPort) -> bool
{
    UniquePtr<IPC::Message> msg__ = PMediaTransport::Msg_SetTargetForDefaultLocalAddressLookup(MSG_ROUTING_CONTROL);
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), targetIp);
    // Sentinel = 'targetIp'
    ((&(writer__)))->WriteSentinel(250610497);
    IPC::WriteParam((&(writer__)), targetPort);
    // Sentinel = 'targetPort'
    ((&(writer__)))->WriteSentinel(383976493);




    if (mozilla::ipc::LoggingEnabledFor("PMediaTransport", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PMediaTransportChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PMediaTransport::Msg_SetTargetForDefaultLocalAddressLookup", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PMediaTransportChild::SendStartIceGathering(
        const bool& defaultRouteOnly,
        const bool& obfuscateHostAddresses,
        const NrIceStunAddrArray& stunAddrs) -> bool
{
    UniquePtr<IPC::Message> msg__ = PMediaTransport::Msg_StartIceGathering(MSG_ROUTING_CONTROL);
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), defaultRouteOnly);
    // Sentinel = 'defaultRouteOnly'
    ((&(writer__)))->WriteSentinel(930678423);
    IPC::WriteParam((&(writer__)), obfuscateHostAddresses);
    // Sentinel = 'obfuscateHostAddresses'
    ((&(writer__)))->WriteSentinel(1725761785);
    IPC::WriteParam((&(writer__)), stunAddrs);
    // Sentinel = 'stunAddrs'
    ((&(writer__)))->WriteSentinel(315818937);




    if (mozilla::ipc::LoggingEnabledFor("PMediaTransport", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PMediaTransportChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PMediaTransport::Msg_StartIceGathering", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PMediaTransportChild::SendActivateTransport(
        const string& transportId,
        const string& localUfrag,
        const string& localPwd,
        const int& componentCount,
        const string& remoteUfrag,
        const string& remotePwd,
        mozilla::Span<uint8_t const> keyDer,
        mozilla::Span<uint8_t const> certDer,
        const int& authType,
        const bool& dtlsClient,
        const DtlsDigestList& digests,
        const bool& privacyRequested) -> bool
{
    UniquePtr<IPC::Message> msg__ = PMediaTransport::Msg_ActivateTransport(MSG_ROUTING_CONTROL);
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), transportId);
    // Sentinel = 'transportId'
    ((&(writer__)))->WriteSentinel(475923611);
    IPC::WriteParam((&(writer__)), localUfrag);
    // Sentinel = 'localUfrag'
    ((&(writer__)))->WriteSentinel(372245505);
    IPC::WriteParam((&(writer__)), localPwd);
    // Sentinel = 'localPwd'
    ((&(writer__)))->WriteSentinel(244974391);
    IPC::WriteParam((&(writer__)), componentCount);
    // Sentinel = 'componentCount'
    ((&(writer__)))->WriteSentinel(735512029);
    IPC::WriteParam((&(writer__)), remoteUfrag);
    // Sentinel = 'remoteUfrag'
    ((&(writer__)))->WriteSentinel(460981378);
    IPC::WriteParam((&(writer__)), remotePwd);
    // Sentinel = 'remotePwd'
    ((&(writer__)))->WriteSentinel(316801976);
    IPC::WriteParam((&(writer__)), keyDer);
    // Sentinel = 'keyDer'
    ((&(writer__)))->WriteSentinel(141361765);
    IPC::WriteParam((&(writer__)), certDer);
    // Sentinel = 'certDer'
    ((&(writer__)))->WriteSentinel(187433674);
    IPC::WriteParam((&(writer__)), authType);
    // Sentinel = 'authType'
    ((&(writer__)))->WriteSentinel(251855701);
    IPC::WriteParam((&(writer__)), dtlsClient);
    // Sentinel = 'dtlsClient'
    ((&(writer__)))->WriteSentinel(375129111);
    IPC::WriteParam((&(writer__)), digests);
    // Sentinel = 'digests'
    ((&(writer__)))->WriteSentinel(193200884);
    IPC::WriteParam((&(writer__)), privacyRequested);
    // Sentinel = 'privacyRequested'
    ((&(writer__)))->WriteSentinel(959383217);




    if (mozilla::ipc::LoggingEnabledFor("PMediaTransport", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PMediaTransportChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PMediaTransport::Msg_ActivateTransport", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PMediaTransportChild::SendRemoveTransportsExcept(const StringVector& transportIds) -> bool
{
    UniquePtr<IPC::Message> msg__ = PMediaTransport::Msg_RemoveTransportsExcept(MSG_ROUTING_CONTROL);
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), transportIds);
    // Sentinel = 'transportIds'
    ((&(writer__)))->WriteSentinel(560727310);




    if (mozilla::ipc::LoggingEnabledFor("PMediaTransport", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PMediaTransportChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PMediaTransport::Msg_RemoveTransportsExcept", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PMediaTransportChild::SendStartIceChecks(
        const bool& isControlling,
        const StringVector& iceOptions) -> bool
{
    UniquePtr<IPC::Message> msg__ = PMediaTransport::Msg_StartIceChecks(MSG_ROUTING_CONTROL);
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), isControlling);
    // Sentinel = 'isControlling'
    ((&(writer__)))->WriteSentinel(628950376);
    IPC::WriteParam((&(writer__)), iceOptions);
    // Sentinel = 'iceOptions'
    ((&(writer__)))->WriteSentinel(370410526);




    if (mozilla::ipc::LoggingEnabledFor("PMediaTransport", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PMediaTransportChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PMediaTransport::Msg_StartIceChecks", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PMediaTransportChild::SendSendPacket(
        const string& transportId,
        const MediaPacket& packet) -> bool
{
    UniquePtr<IPC::Message> msg__ = PMediaTransport::Msg_SendPacket(MSG_ROUTING_CONTROL);
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), transportId);
    // Sentinel = 'transportId'
    ((&(writer__)))->WriteSentinel(475923611);
    IPC::WriteParam((&(writer__)), packet);
    // Sentinel = 'packet'
    ((&(writer__)))->WriteSentinel(144048761);




    if (mozilla::ipc::LoggingEnabledFor("PMediaTransport", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PMediaTransportChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PMediaTransport::Msg_SendPacket", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PMediaTransportChild::SendAddIceCandidate(
        const string& transportId,
        const string& candidate,
        const string& ufrag,
        const string& obfuscatedAddr) -> bool
{
    UniquePtr<IPC::Message> msg__ = PMediaTransport::Msg_AddIceCandidate(MSG_ROUTING_CONTROL);
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), transportId);
    // Sentinel = 'transportId'
    ((&(writer__)))->WriteSentinel(475923611);
    IPC::WriteParam((&(writer__)), candidate);
    // Sentinel = 'candidate'
    ((&(writer__)))->WriteSentinel(301138846);
    IPC::WriteParam((&(writer__)), ufrag);
    // Sentinel = 'ufrag'
    ((&(writer__)))->WriteSentinel(107282966);
    IPC::WriteParam((&(writer__)), obfuscatedAddr);
    // Sentinel = 'obfuscatedAddr'
    ((&(writer__)))->WriteSentinel(718407068);




    if (mozilla::ipc::LoggingEnabledFor("PMediaTransport", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PMediaTransportChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PMediaTransport::Msg_AddIceCandidate", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PMediaTransportChild::SendUpdateNetworkState(const bool& online) -> bool
{
    UniquePtr<IPC::Message> msg__ = PMediaTransport::Msg_UpdateNetworkState(MSG_ROUTING_CONTROL);
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), online);
    // Sentinel = 'online'
    ((&(writer__)))->WriteSentinel(150078086);




    if (mozilla::ipc::LoggingEnabledFor("PMediaTransport", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PMediaTransportChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PMediaTransport::Msg_UpdateNetworkState", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PMediaTransportChild::SendGetIceStats(
        const string& transportId,
        const double& now,
        mozilla::ipc::ResolveCallback<UniquePtr<RTCStatsCollection>>&& aResolve,
        mozilla::ipc::RejectCallback&& aReject) -> void
{
    UniquePtr<IPC::Message> msg__ = PMediaTransport::Msg_GetIceStats(MSG_ROUTING_CONTROL);
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), transportId);
    // Sentinel = 'transportId'
    ((&(writer__)))->WriteSentinel(475923611);
    IPC::WriteParam((&(writer__)), now);
    // Sentinel = 'now'
    ((&(writer__)))->WriteSentinel(44171605);




    if (mozilla::ipc::LoggingEnabledFor("PMediaTransport", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PMediaTransportChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PMediaTransport::Msg_GetIceStats", OTHER);

    int32_t seqno__ = 0;
    if (ChannelSend(std::move(msg__), (&(seqno__)))) {
        mAsyncCallbacks.AddCallback(seqno__, PMediaTransport::Reply_GetIceStats__ID, [resolve=std::move(aResolve)](IPC::MessageReader* aReader) mutable {
            auto maybe__stats = IPC::ReadParam<UniquePtr<RTCStatsCollection>>(aReader);
            if (!maybe__stats) {
                (aReader)->FatalError("Error deserializing 'UniquePtr<RTCStatsCollection>'");
                return MsgValueError;

            }
            auto& stats = *maybe__stats;
            // Sentinel = 'stats'
            if ((!((aReader)->ReadSentinel(110232112)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'UniquePtr<RTCStatsCollection>'");
                return MsgValueError;
            }


            aReader->EndRead();

            resolve(std::move(stats));
            return MsgProcessed;
        }, std::move(aReject));
    }
    else {
        aReject(::mozilla::ipc::ResponseRejectReason::SendError);
    }
    return;
}

auto PMediaTransportChild::SendGetIceStats(
        const string& transportId,
        const double& now) -> RefPtr<GetIceStatsPromise>
{
    RefPtr<MozPromise<UniquePtr<RTCStatsCollection>, ResponseRejectReason, true>::Private> promise__ = new MozPromise<UniquePtr<RTCStatsCollection>, ResponseRejectReason, true>::Private(__func__);
    promise__->UseDirectTaskDispatch(__func__);
    SendGetIceStats(std::move(transportId), std::move(now), [promise__](UniquePtr<RTCStatsCollection>&& aValue) {
        promise__->Resolve(std::move(aValue), __func__);
    }, [promise__](ResponseRejectReason&& aReason) {
        promise__->Reject(std::move(aReason), __func__);
    });
    return promise__;
}

auto PMediaTransportChild::DeallocManagee(
        int32_t aProtocolId,
        IProtocol* aListener) -> void
{
    FatalError("unreached");
    return;
}

auto PMediaTransportChild::OnMessageReceived(const Message& msg__) -> PMediaTransportChild::Result
{
    switch (msg__.type()) {
    case PMediaTransport::Reply_GetIceLog__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PMediaTransport", mozilla::ipc::ChildSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PMediaTransportChild",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }

            AUTO_PROFILER_LABEL("PMediaTransport::Msg_GetIceLog", OTHER);


            return mAsyncCallbacks.GotReply(this, msg__);
        }
    case PMediaTransport::Reply_GetIceStats__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PMediaTransport", mozilla::ipc::ChildSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PMediaTransportChild",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }

            AUTO_PROFILER_LABEL("PMediaTransport::Msg_GetIceStats", OTHER);


            return mAsyncCallbacks.GotReply(this, msg__);
        }
    case PMediaTransport::Msg_OnCandidate__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PMediaTransport", mozilla::ipc::ChildSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PMediaTransportChild",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PMediaTransport::Msg_OnCandidate", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__transportId = IPC::ReadParam<string>((&(reader__)));
            if (!maybe__transportId) {
                FatalError("Error deserializing 'string'");
                return MsgValueError;

            }
            auto& transportId = *maybe__transportId;
            // Sentinel = 'transportId'
            if ((!(((&(reader__)))->ReadSentinel(475923611)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'string'");
                return MsgValueError;
            }
            auto maybe__candidateInfo = IPC::ReadParam<CandidateInfo>((&(reader__)));
            if (!maybe__candidateInfo) {
                FatalError("Error deserializing 'CandidateInfo'");
                return MsgValueError;

            }
            auto& candidateInfo = *maybe__candidateInfo;
            // Sentinel = 'candidateInfo'
            if ((!(((&(reader__)))->ReadSentinel(605291818)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'CandidateInfo'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::IPCResult __ok = (static_cast<MediaTransportChild*>(this))->RecvOnCandidate(std::move(transportId), std::move(candidateInfo));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PMediaTransport::Msg_OnAlpnNegotiated__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PMediaTransport", mozilla::ipc::ChildSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PMediaTransportChild",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PMediaTransport::Msg_OnAlpnNegotiated", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__alpn = IPC::ReadParam<string>((&(reader__)));
            if (!maybe__alpn) {
                FatalError("Error deserializing 'string'");
                return MsgValueError;

            }
            auto& alpn = *maybe__alpn;
            // Sentinel = 'alpn'
            if ((!(((&(reader__)))->ReadSentinel(68813228)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'string'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::IPCResult __ok = (static_cast<MediaTransportChild*>(this))->RecvOnAlpnNegotiated(std::move(alpn));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PMediaTransport::Msg_OnGatheringStateChange__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PMediaTransport", mozilla::ipc::ChildSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PMediaTransportChild",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PMediaTransport::Msg_OnGatheringStateChange", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__transportId = IPC::ReadParam<string>((&(reader__)));
            if (!maybe__transportId) {
                FatalError("Error deserializing 'string'");
                return MsgValueError;

            }
            auto& transportId = *maybe__transportId;
            // Sentinel = 'transportId'
            if ((!(((&(reader__)))->ReadSentinel(475923611)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'string'");
                return MsgValueError;
            }
            auto maybe__state = IPC::ReadParam<int>((&(reader__)));
            if (!maybe__state) {
                FatalError("Error deserializing 'int'");
                return MsgValueError;

            }
            auto& state = *maybe__state;
            // Sentinel = 'state'
            if ((!(((&(reader__)))->ReadSentinel(109314594)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'int'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::IPCResult __ok = (static_cast<MediaTransportChild*>(this))->RecvOnGatheringStateChange(std::move(transportId), std::move(state));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PMediaTransport::Msg_OnConnectionStateChange__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PMediaTransport", mozilla::ipc::ChildSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PMediaTransportChild",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PMediaTransport::Msg_OnConnectionStateChange", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__transportId = IPC::ReadParam<string>((&(reader__)));
            if (!maybe__transportId) {
                FatalError("Error deserializing 'string'");
                return MsgValueError;

            }
            auto& transportId = *maybe__transportId;
            // Sentinel = 'transportId'
            if ((!(((&(reader__)))->ReadSentinel(475923611)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'string'");
                return MsgValueError;
            }
            auto maybe__state = IPC::ReadParam<int>((&(reader__)));
            if (!maybe__state) {
                FatalError("Error deserializing 'int'");
                return MsgValueError;

            }
            auto& state = *maybe__state;
            // Sentinel = 'state'
            if ((!(((&(reader__)))->ReadSentinel(109314594)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'int'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::IPCResult __ok = (static_cast<MediaTransportChild*>(this))->RecvOnConnectionStateChange(std::move(transportId), std::move(state));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PMediaTransport::Msg_OnPacketReceived__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PMediaTransport", mozilla::ipc::ChildSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PMediaTransportChild",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PMediaTransport::Msg_OnPacketReceived", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__transportId = IPC::ReadParam<string>((&(reader__)));
            if (!maybe__transportId) {
                FatalError("Error deserializing 'string'");
                return MsgValueError;

            }
            auto& transportId = *maybe__transportId;
            // Sentinel = 'transportId'
            if ((!(((&(reader__)))->ReadSentinel(475923611)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'string'");
                return MsgValueError;
            }
            auto maybe__packet = IPC::ReadParam<MediaPacket>((&(reader__)));
            if (!maybe__packet) {
                FatalError("Error deserializing 'MediaPacket'");
                return MsgValueError;

            }
            auto& packet = *maybe__packet;
            // Sentinel = 'packet'
            if ((!(((&(reader__)))->ReadSentinel(144048761)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'MediaPacket'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::IPCResult __ok = (static_cast<MediaTransportChild*>(this))->RecvOnPacketReceived(std::move(transportId), std::move(packet));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PMediaTransport::Msg_OnEncryptedSending__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PMediaTransport", mozilla::ipc::ChildSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PMediaTransportChild",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PMediaTransport::Msg_OnEncryptedSending", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__transportId = IPC::ReadParam<string>((&(reader__)));
            if (!maybe__transportId) {
                FatalError("Error deserializing 'string'");
                return MsgValueError;

            }
            auto& transportId = *maybe__transportId;
            // Sentinel = 'transportId'
            if ((!(((&(reader__)))->ReadSentinel(475923611)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'string'");
                return MsgValueError;
            }
            auto maybe__packet = IPC::ReadParam<MediaPacket>((&(reader__)));
            if (!maybe__packet) {
                FatalError("Error deserializing 'MediaPacket'");
                return MsgValueError;

            }
            auto& packet = *maybe__packet;
            // Sentinel = 'packet'
            if ((!(((&(reader__)))->ReadSentinel(144048761)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'MediaPacket'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::IPCResult __ok = (static_cast<MediaTransportChild*>(this))->RecvOnEncryptedSending(std::move(transportId), std::move(packet));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PMediaTransport::Msg_OnStateChange__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PMediaTransport", mozilla::ipc::ChildSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PMediaTransportChild",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PMediaTransport::Msg_OnStateChange", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__transportId = IPC::ReadParam<string>((&(reader__)));
            if (!maybe__transportId) {
                FatalError("Error deserializing 'string'");
                return MsgValueError;

            }
            auto& transportId = *maybe__transportId;
            // Sentinel = 'transportId'
            if ((!(((&(reader__)))->ReadSentinel(475923611)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'string'");
                return MsgValueError;
            }
            auto maybe__state = IPC::ReadParam<int>((&(reader__)));
            if (!maybe__state) {
                FatalError("Error deserializing 'int'");
                return MsgValueError;

            }
            auto& state = *maybe__state;
            // Sentinel = 'state'
            if ((!(((&(reader__)))->ReadSentinel(109314594)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'int'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::IPCResult __ok = (static_cast<MediaTransportChild*>(this))->RecvOnStateChange(std::move(transportId), std::move(state));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PMediaTransport::Msg_OnRtcpStateChange__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PMediaTransport", mozilla::ipc::ChildSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PMediaTransportChild",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PMediaTransport::Msg_OnRtcpStateChange", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__transportId = IPC::ReadParam<string>((&(reader__)));
            if (!maybe__transportId) {
                FatalError("Error deserializing 'string'");
                return MsgValueError;

            }
            auto& transportId = *maybe__transportId;
            // Sentinel = 'transportId'
            if ((!(((&(reader__)))->ReadSentinel(475923611)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'string'");
                return MsgValueError;
            }
            auto maybe__state = IPC::ReadParam<int>((&(reader__)));
            if (!maybe__state) {
                FatalError("Error deserializing 'int'");
                return MsgValueError;

            }
            auto& state = *maybe__state;
            // Sentinel = 'state'
            if ((!(((&(reader__)))->ReadSentinel(109314594)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'int'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::IPCResult __ok = (static_cast<MediaTransportChild*>(this))->RecvOnRtcpStateChange(std::move(transportId), std::move(state));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    default:
        return MsgNotKnown;
    case SHMEM_CREATED_MESSAGE_TYPE:
        {
            if (!ShmemCreated(msg__)) {
                return MsgPayloadError;
            }
            return MsgProcessed;
        }
    case SHMEM_DESTROYED_MESSAGE_TYPE:
        {
            if (!ShmemDestroyed(msg__)) {
                return MsgPayloadError;
            }
            return MsgProcessed;
        }
    }
}

auto PMediaTransportChild::OnMessageReceived(
        const Message& msg__,
        UniquePtr<Message>& reply__) -> PMediaTransportChild::Result
{
    MOZ_ASSERT_UNREACHABLE("message protocol not supported");
    return MsgNotKnown;
}



} // namespace dom
} // namespace mozilla
namespace IPC {
auto ParamTraits<::mozilla::dom::PMediaTransportChild*>::Write(
        IPC::MessageWriter* aWriter,
        const paramType& aVar) -> void
{
    MOZ_RELEASE_ASSERT(
        aWriter->GetActor(),
        "Cannot serialize managed actors without an actor");

    int32_t id;
    if (!aVar) {
        id = 0;  // kNullActorId
    } else {
        id = aVar->Id();
        if (id == 1) {  // kFreedActorId
            aVar->FatalError("Actor has been |delete|d");
        }
        MOZ_RELEASE_ASSERT(
            aWriter->GetActor()->GetIPCChannel() == aVar->GetIPCChannel(),
            "Actor must be from the same channel as the"
            " actor it's being sent over");
        MOZ_RELEASE_ASSERT(
            aVar->CanSend(),
            "Actor must still be open when sending");
    }

    IPC::WriteParam(aWriter, id);
}

auto ParamTraits<::mozilla::dom::PMediaTransportChild*>::Read(IPC::MessageReader* aReader) -> IPC::ReadResult<paramType>
{
    MOZ_RELEASE_ASSERT(
        aReader->GetActor(),
        "Cannot deserialize managed actors without an actor");
    mozilla::Maybe<mozilla::ipc::IProtocol*> actor = aReader->GetActor()
        ->ReadActor(aReader, true, "PMediaTransport", PMediaTransportMsgStart);
    if (actor.isSome()) {
        return static_cast<::mozilla::dom::PMediaTransportChild*>(actor.ref());
    }
    return {};
}

} // namespace IPC
