//
// Automatically generated by ipdlc.
// Edit at your own risk
//


#include "mozilla/media/PMediaSystemResourceManagerParent.h"
#include "mozilla/ProfilerLabels.h"
#include "mozilla/media/MediaSystemResourceManagerParent.h"
#include "mozilla/media/MediaSystemResourceMessageUtils.h"

#include "mozilla/layers/PImageBridgeParent.h"

#include "ipc/IPCMessageUtils.h"
#include "ipc/IPCMessageUtilsSpecializations.h"
#include "nsIFile.h"
#include "mozilla/ipc/Endpoint.h"
#include "mozilla/ipc/ProtocolMessageUtils.h"
#include "mozilla/ipc/ProtocolUtils.h"
#include "mozilla/ipc/ShmemMessageUtils.h"
#include "mozilla/ipc/TaintingIPCUtils.h"

namespace mozilla {
namespace media {


MOZ_IMPLICIT PMediaSystemResourceManagerParent::PMediaSystemResourceManagerParent() :
    mozilla::ipc::IProtocol(kProtocolId, mozilla::ipc::ParentSide)
{
    MOZ_COUNT_CTOR(PMediaSystemResourceManagerParent);
}

PMediaSystemResourceManagerParent::~PMediaSystemResourceManagerParent()
{
    MOZ_COUNT_DTOR(PMediaSystemResourceManagerParent);
}

auto PMediaSystemResourceManagerParent::ActorAlloc() -> void
{
}

auto PMediaSystemResourceManagerParent::ActorDealloc() -> void
{
    if (Manager()) {
        Manager()->DeallocManagee(kProtocolId, this);
    }
}

auto PMediaSystemResourceManagerParent::OtherPid() const -> ::base::ProcessId
{
    ::base::ProcessId pid =
        ::mozilla::ipc::IProtocol::ToplevelProtocol()->OtherPidMaybeInvalid();
    MOZ_RELEASE_ASSERT(pid != ::base::kInvalidProcessId);
    return pid;
}

auto PMediaSystemResourceManagerParent::OtherChildID() const -> ::GeckoChildID
{
    ::GeckoChildID childID =
        ::mozilla::ipc::IProtocol::ToplevelProtocol()->OtherChildIDMaybeInvalid();
    MOZ_RELEASE_ASSERT(childID != -1);
    return childID;
}

auto PMediaSystemResourceManagerParent::OtherEndpointProcInfo() const -> ::mozilla::ipc::EndpointProcInfo
{
    return ::mozilla::ipc::EndpointProcInfo{OtherPid(), OtherChildID()};
}

auto PMediaSystemResourceManagerParent::Manager() const -> PImageBridgeParent*
{
    return static_cast<PImageBridgeParent*>(IProtocol::Manager());
}

auto PMediaSystemResourceManagerParent::ManagedProtocolIds() const -> mozilla::Span<mozilla::ipc::ProtocolId const>
{
    return {};
}

auto PMediaSystemResourceManagerParent::GetManagedActors(mozilla::ipc::ProtocolId aProtocol) -> UntypedManagedContainer*
{
    switch (aProtocol) {
    default:
        return nullptr;
    }
}

auto PMediaSystemResourceManagerParent::SendResponse(
        const uint32_t& aId,
        const bool& aSuccess) -> bool
{
    UniquePtr<IPC::Message> msg__ = PMediaSystemResourceManager::Msg_Response(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), aId);
    // Sentinel = 'aId'
    ((&(writer__)))->WriteSentinel(35389711);
    IPC::WriteParam((&(writer__)), aSuccess);
    // Sentinel = 'aSuccess'
    ((&(writer__)))->WriteSentinel(236323643);




    if (mozilla::ipc::LoggingEnabledFor("PMediaSystemResourceManager", mozilla::ipc::ParentSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PMediaSystemResourceManagerParent",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PMediaSystemResourceManager::Msg_Response", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PMediaSystemResourceManagerParent::Send__delete__(PMediaSystemResourceManagerParent* actor) -> bool
{
    if (!actor || !actor->CanSend()) {
        NS_WARNING("Attempt to __delete__ missing or closed actor");
        return false;
    }
    UniquePtr<IPC::Message> msg__ = PMediaSystemResourceManager::Msg___delete__((actor)->Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            actor};




    if (mozilla::ipc::LoggingEnabledFor("PMediaSystemResourceManager", mozilla::ipc::ParentSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PMediaSystemResourceManagerParent",
            actor->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PMediaSystemResourceManager::Msg___delete__", OTHER);

    bool sendok__ = (actor)->ChannelSend(std::move(msg__));

    actor->ActorDisconnected(Deletion);
    return sendok__;
}

auto PMediaSystemResourceManagerParent::DeallocManagee(
        int32_t aProtocolId,
        IProtocol* aListener) -> void
{
    FatalError("unreached");
    return;
}

auto PMediaSystemResourceManagerParent::OnMessageReceived(const Message& msg__) -> PMediaSystemResourceManagerParent::Result
{
    switch (msg__.type()) {
    case MANAGED_ENDPOINT_BOUND_MESSAGE_TYPE:
        {
            if (!mAwaitingManagedEndpointBind) {
                NS_WARNING("Unexpected managed endpoint lifecycle message after actor bound!");
                return MsgNotAllowed;
            }
            mAwaitingManagedEndpointBind = false;
            return MsgProcessed;
        }
    case MANAGED_ENDPOINT_DROPPED_MESSAGE_TYPE:
        {
            if (!mAwaitingManagedEndpointBind) {
                NS_WARNING("Unexpected managed endpoint lifecycle message after actor bound!");
                return MsgNotAllowed;
            }
            mAwaitingManagedEndpointBind = false;
            this->ActorDisconnected(ManagedEndpointDropped);
            return MsgProcessed;
        }
    case PMediaSystemResourceManager::Reply___delete____ID:
        {
            return MsgProcessed;
        }
    case PMediaSystemResourceManager::Msg_Acquire__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PMediaSystemResourceManager", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PMediaSystemResourceManagerParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PMediaSystemResourceManager::Msg_Acquire", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__aId = IPC::ReadParam<uint32_t>((&(reader__)));
            if (!maybe__aId) {
                FatalError("Error deserializing 'uint32_t'");
                return MsgValueError;

            }
            auto& aId = *maybe__aId;
            // Sentinel = 'aId'
            if ((!(((&(reader__)))->ReadSentinel(35389711)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'uint32_t'");
                return MsgValueError;
            }
            auto maybe__aResourceType = IPC::ReadParam<MediaSystemResourceType>((&(reader__)));
            if (!maybe__aResourceType) {
                FatalError("Error deserializing 'MediaSystemResourceType'");
                return MsgValueError;

            }
            auto& aResourceType = *maybe__aResourceType;
            // Sentinel = 'aResourceType'
            if ((!(((&(reader__)))->ReadSentinel(614401356)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'MediaSystemResourceType'");
                return MsgValueError;
            }
            auto maybe__aWillWait = IPC::ReadParam<bool>((&(reader__)));
            if (!maybe__aWillWait) {
                FatalError("Error deserializing 'bool'");
                return MsgValueError;

            }
            auto& aWillWait = *maybe__aWillWait;
            // Sentinel = 'aWillWait'
            if ((!(((&(reader__)))->ReadSentinel(292684687)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'bool'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::IPCResult __ok = (static_cast<MediaSystemResourceManagerParent*>(this))->RecvAcquire(std::move(aId), std::move(aResourceType), std::move(aWillWait));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PMediaSystemResourceManager::Msg_Release__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PMediaSystemResourceManager", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PMediaSystemResourceManagerParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PMediaSystemResourceManager::Msg_Release", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__aId = IPC::ReadParam<uint32_t>((&(reader__)));
            if (!maybe__aId) {
                FatalError("Error deserializing 'uint32_t'");
                return MsgValueError;

            }
            auto& aId = *maybe__aId;
            // Sentinel = 'aId'
            if ((!(((&(reader__)))->ReadSentinel(35389711)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'uint32_t'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::IPCResult __ok = (static_cast<MediaSystemResourceManagerParent*>(this))->RecvRelease(std::move(aId));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PMediaSystemResourceManager::Msg_RemoveResourceManager__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PMediaSystemResourceManager", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PMediaSystemResourceManagerParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PMediaSystemResourceManager::Msg_RemoveResourceManager", OTHER);

            mozilla::ipc::IPCResult __ok = (static_cast<MediaSystemResourceManagerParent*>(this))->RecvRemoveResourceManager();
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    default:
        return MsgNotKnown;
    }
}

auto PMediaSystemResourceManagerParent::OnMessageReceived(
        const Message& msg__,
        UniquePtr<Message>& reply__) -> PMediaSystemResourceManagerParent::Result
{
    return MsgNotKnown;
}



} // namespace media
} // namespace mozilla
namespace IPC {
auto ParamTraits<::mozilla::media::PMediaSystemResourceManagerParent*>::Write(
        IPC::MessageWriter* aWriter,
        const paramType& aVar) -> void
{
    MOZ_RELEASE_ASSERT(
        aWriter->GetActor(),
        "Cannot serialize managed actors without an actor");

    int32_t id;
    if (!aVar) {
        id = 0;  // kNullActorId
    } else {
        id = aVar->Id();
        if (id == 1) {  // kFreedActorId
            aVar->FatalError("Actor has been |delete|d");
        }
        MOZ_RELEASE_ASSERT(
            aWriter->GetActor()->GetIPCChannel() == aVar->GetIPCChannel(),
            "Actor must be from the same channel as the"
            " actor it's being sent over");
        MOZ_RELEASE_ASSERT(
            aVar->CanSend(),
            "Actor must still be open when sending");
    }

    IPC::WriteParam(aWriter, id);
}

auto ParamTraits<::mozilla::media::PMediaSystemResourceManagerParent*>::Read(IPC::MessageReader* aReader) -> IPC::ReadResult<paramType>
{
    MOZ_RELEASE_ASSERT(
        aReader->GetActor(),
        "Cannot deserialize managed actors without an actor");
    mozilla::Maybe<mozilla::ipc::IProtocol*> actor = aReader->GetActor()
        ->ReadActor(aReader, true, "PMediaSystemResourceManager", PMediaSystemResourceManagerMsgStart);
    if (actor.isSome()) {
        return static_cast<::mozilla::media::PMediaSystemResourceManagerParent*>(actor.ref());
    }
    return {};
}

} // namespace IPC
