//
// Automatically generated by ipdlc.
// Edit at your own risk
//


#include "mozilla/media/PMediaChild.h"
#include "mozilla/ProfilerLabels.h"
#include "mozilla/dom/DomSecurityIPCUtils.h"
#include "mozilla/ipc/IPCCore.h"
#include "mozilla/media/MediaChild.h"

#include "mozilla/dom/PContentChild.h"

#include "ipc/IPCMessageUtils.h"
#include "ipc/IPCMessageUtilsSpecializations.h"
#include "nsIFile.h"
#include "mozilla/ipc/Endpoint.h"
#include "mozilla/ipc/ProtocolMessageUtils.h"
#include "mozilla/ipc/ProtocolUtils.h"
#include "mozilla/ipc/ShmemMessageUtils.h"
#include "mozilla/ipc/TaintingIPCUtils.h"

namespace mozilla {
namespace media {


auto PMediaChild::Recv__delete__() -> mozilla::ipc::IPCResult
{
    return IPC_OK();
}

MOZ_IMPLICIT PMediaChild::PMediaChild() :
    mozilla::ipc::IProtocol(kProtocolId, mozilla::ipc::ChildSide)
{
    MOZ_COUNT_CTOR(PMediaChild);
}

PMediaChild::~PMediaChild()
{
    MOZ_COUNT_DTOR(PMediaChild);
}

auto PMediaChild::ActorAlloc() -> void
{
}

auto PMediaChild::ActorDealloc() -> void
{
    if (Manager()) {
        Manager()->DeallocManagee(kProtocolId, this);
    }
}

auto PMediaChild::OtherPid() const -> ::base::ProcessId
{
    ::base::ProcessId pid =
        ::mozilla::ipc::IProtocol::ToplevelProtocol()->OtherPidMaybeInvalid();
    MOZ_RELEASE_ASSERT(pid != ::base::kInvalidProcessId);
    return pid;
}

auto PMediaChild::OtherChildID() const -> ::GeckoChildID
{
    ::GeckoChildID childID =
        ::mozilla::ipc::IProtocol::ToplevelProtocol()->OtherChildIDMaybeInvalid();
    MOZ_RELEASE_ASSERT(childID != -1);
    return childID;
}

auto PMediaChild::OtherEndpointProcInfo() const -> ::mozilla::ipc::EndpointProcInfo
{
    return ::mozilla::ipc::EndpointProcInfo{OtherPid(), OtherChildID()};
}

auto PMediaChild::Manager() const -> PContentChild*
{
    return static_cast<PContentChild*>(IProtocol::Manager());
}

auto PMediaChild::ManagedProtocolIds() const -> mozilla::Span<mozilla::ipc::ProtocolId const>
{
    return {};
}

auto PMediaChild::GetManagedActors(mozilla::ipc::ProtocolId aProtocol) -> UntypedManagedContainer*
{
    switch (aProtocol) {
    default:
        return nullptr;
    }
}

auto PMediaChild::RejectPendingResponses(ResponseRejectReason aReason) -> void
{
    mAsyncCallbacks.RejectPendingResponses(aReason);
}

auto PMediaChild::SendGetPrincipalKey(
        const PrincipalInfo& aPrincipal,
        const bool& aPersist,
        mozilla::ipc::ResolveCallback<nsCString>&& aResolve,
        mozilla::ipc::RejectCallback&& aReject) -> void
{
    UniquePtr<IPC::Message> msg__ = PMedia::Msg_GetPrincipalKey(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), aPrincipal);
    // Sentinel = 'aPrincipal'
    ((&(writer__)))->WriteSentinel(364381188);
    IPC::WriteParam((&(writer__)), aPersist);
    // Sentinel = 'aPersist'
    ((&(writer__)))->WriteSentinel(238617420);




    if (mozilla::ipc::LoggingEnabledFor("PMedia", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PMediaChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PMedia::Msg_GetPrincipalKey", OTHER);

    int32_t seqno__ = 0;
    if (ChannelSend(std::move(msg__), (&(seqno__)))) {
        mAsyncCallbacks.AddCallback(seqno__, PMedia::Reply_GetPrincipalKey__ID, [resolve=std::move(aResolve)](IPC::MessageReader* aReader) mutable {
            auto maybe__aKey = IPC::ReadParam<nsCString>(aReader);
            if (!maybe__aKey) {
                (aReader)->FatalError("Error deserializing 'nsCString'");
                return MsgValueError;

            }
            auto& aKey = *maybe__aKey;
            // Sentinel = 'aKey'
            if ((!((aReader)->ReadSentinel(61604235)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'nsCString'");
                return MsgValueError;
            }


            aReader->EndRead();

            resolve(std::move(aKey));
            return MsgProcessed;
        }, std::move(aReject));
    }
    else {
        aReject(::mozilla::ipc::ResponseRejectReason::SendError);
    }
    return;
}

auto PMediaChild::SendGetPrincipalKey(
        const PrincipalInfo& aPrincipal,
        const bool& aPersist) -> RefPtr<GetPrincipalKeyPromise>
{
    RefPtr<MozPromise<nsCString, ResponseRejectReason, true>::Private> promise__ = new MozPromise<nsCString, ResponseRejectReason, true>::Private(__func__);
    promise__->UseDirectTaskDispatch(__func__);
    SendGetPrincipalKey(std::move(aPrincipal), std::move(aPersist), [promise__](nsCString&& aValue) {
        promise__->Resolve(std::move(aValue), __func__);
    }, [promise__](ResponseRejectReason&& aReason) {
        promise__->Reject(std::move(aReason), __func__);
    });
    return promise__;
}

auto PMediaChild::SendSanitizeOriginKeys(
        const uint64_t& aSinceWhen,
        const bool& aOnlyPrivateBrowsing) -> bool
{
    UniquePtr<IPC::Message> msg__ = PMedia::Msg_SanitizeOriginKeys(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), aSinceWhen);
    // Sentinel = 'aSinceWhen'
    ((&(writer__)))->WriteSentinel(354419686);
    IPC::WriteParam((&(writer__)), aOnlyPrivateBrowsing);
    // Sentinel = 'aOnlyPrivateBrowsing'
    ((&(writer__)))->WriteSentinel(1416300586);




    if (mozilla::ipc::LoggingEnabledFor("PMedia", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PMediaChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PMedia::Msg_SanitizeOriginKeys", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PMediaChild::DeallocManagee(
        int32_t aProtocolId,
        IProtocol* aListener) -> void
{
    FatalError("unreached");
    return;
}

auto PMediaChild::OnMessageReceived(const Message& msg__) -> PMediaChild::Result
{
    switch (msg__.type()) {
    case MANAGED_ENDPOINT_BOUND_MESSAGE_TYPE:
        {
            if (!mAwaitingManagedEndpointBind) {
                NS_WARNING("Unexpected managed endpoint lifecycle message after actor bound!");
                return MsgNotAllowed;
            }
            mAwaitingManagedEndpointBind = false;
            return MsgProcessed;
        }
    case MANAGED_ENDPOINT_DROPPED_MESSAGE_TYPE:
        {
            if (!mAwaitingManagedEndpointBind) {
                NS_WARNING("Unexpected managed endpoint lifecycle message after actor bound!");
                return MsgNotAllowed;
            }
            mAwaitingManagedEndpointBind = false;
            this->ActorDisconnected(ManagedEndpointDropped);
            return MsgProcessed;
        }
    case PMedia::Reply_GetPrincipalKey__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PMedia", mozilla::ipc::ChildSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PMediaChild",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }

            AUTO_PROFILER_LABEL("PMedia::Msg_GetPrincipalKey", OTHER);


            return mAsyncCallbacks.GotReply(this, msg__);
        }
    case PMedia::Msg___delete____ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PMedia", mozilla::ipc::ChildSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PMediaChild",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PMedia::Msg___delete__", OTHER);

            mozilla::ipc::IPCResult __ok = (static_cast<Child*>(this))->Recv__delete__();
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }


            this->ActorDisconnected(Deletion);

            return MsgProcessed;
        }
    default:
        return MsgNotKnown;
    }
}

auto PMediaChild::OnMessageReceived(
        const Message& msg__,
        UniquePtr<Message>& reply__) -> PMediaChild::Result
{
    return MsgNotKnown;
}



} // namespace media
} // namespace mozilla
namespace IPC {
auto ParamTraits<::mozilla::media::PMediaChild*>::Write(
        IPC::MessageWriter* aWriter,
        const paramType& aVar) -> void
{
    MOZ_RELEASE_ASSERT(
        aWriter->GetActor(),
        "Cannot serialize managed actors without an actor");

    int32_t id;
    if (!aVar) {
        id = 0;  // kNullActorId
    } else {
        id = aVar->Id();
        if (id == 1) {  // kFreedActorId
            aVar->FatalError("Actor has been |delete|d");
        }
        MOZ_RELEASE_ASSERT(
            aWriter->GetActor()->GetIPCChannel() == aVar->GetIPCChannel(),
            "Actor must be from the same channel as the"
            " actor it's being sent over");
        MOZ_RELEASE_ASSERT(
            aVar->CanSend(),
            "Actor must still be open when sending");
    }

    IPC::WriteParam(aWriter, id);
}

auto ParamTraits<::mozilla::media::PMediaChild*>::Read(IPC::MessageReader* aReader) -> IPC::ReadResult<paramType>
{
    MOZ_RELEASE_ASSERT(
        aReader->GetActor(),
        "Cannot deserialize managed actors without an actor");
    mozilla::Maybe<mozilla::ipc::IProtocol*> actor = aReader->GetActor()
        ->ReadActor(aReader, true, "PMedia", PMediaMsgStart);
    if (actor.isSome()) {
        return static_cast<::mozilla::media::PMediaChild*>(actor.ref());
    }
    return {};
}

} // namespace IPC
