//
// Automatically generated by ipdlc.
// Edit at your own risk
//


#include "mozilla/dom/locks/PLockRequestParent.h"
#include "mozilla/ProfilerLabels.h"
#include "mozilla/dom/locks/IPCUtils.h"
#include "mozilla/dom/locks/LockRequestParent.h"

#include "mozilla/dom/locks/PLockManagerParent.h"

#include "ipc/IPCMessageUtils.h"
#include "ipc/IPCMessageUtilsSpecializations.h"
#include "nsIFile.h"
#include "mozilla/ipc/Endpoint.h"
#include "mozilla/ipc/ProtocolMessageUtils.h"
#include "mozilla/ipc/ProtocolUtils.h"
#include "mozilla/ipc/ShmemMessageUtils.h"
#include "mozilla/ipc/TaintingIPCUtils.h"

namespace mozilla {
namespace dom {
namespace locks {


MOZ_IMPLICIT PLockRequestParent::PLockRequestParent() :
    mozilla::ipc::IRefCountedProtocol(kProtocolId, mozilla::ipc::ParentSide)
{
    MOZ_COUNT_CTOR(PLockRequestParent);
}

PLockRequestParent::~PLockRequestParent()
{
    MOZ_COUNT_DTOR(PLockRequestParent);
}

auto PLockRequestParent::ActorAlloc() -> void
{
    AddRef();
}

auto PLockRequestParent::ActorDealloc() -> void
{
    Release();
}

auto PLockRequestParent::OtherPid() const -> ::base::ProcessId
{
    ::base::ProcessId pid =
        ::mozilla::ipc::IProtocol::ToplevelProtocol()->OtherPidMaybeInvalid();
    MOZ_RELEASE_ASSERT(pid != ::base::kInvalidProcessId);
    return pid;
}

auto PLockRequestParent::OtherChildID() const -> ::GeckoChildID
{
    ::GeckoChildID childID =
        ::mozilla::ipc::IProtocol::ToplevelProtocol()->OtherChildIDMaybeInvalid();
    MOZ_RELEASE_ASSERT(childID != -1);
    return childID;
}

auto PLockRequestParent::OtherEndpointProcInfo() const -> ::mozilla::ipc::EndpointProcInfo
{
    return ::mozilla::ipc::EndpointProcInfo{OtherPid(), OtherChildID()};
}

auto PLockRequestParent::Manager() const -> PLockManagerParent*
{
    return static_cast<PLockManagerParent*>(IProtocol::Manager());
}

auto PLockRequestParent::ManagedProtocolIds() const -> mozilla::Span<mozilla::ipc::ProtocolId const>
{
    return {};
}

auto PLockRequestParent::GetManagedActors(mozilla::ipc::ProtocolId aProtocol) -> UntypedManagedContainer*
{
    switch (aProtocol) {
    default:
        return nullptr;
    }
}

auto PLockRequestParent::SendResolve(
        const LockMode& aMode,
        const bool& aIsAvailable) -> bool
{
    UniquePtr<IPC::Message> msg__ = PLockRequest::Msg_Resolve(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), aMode);
    // Sentinel = 'aMode'
    ((&(writer__)))->WriteSentinel(93848039);
    IPC::WriteParam((&(writer__)), aIsAvailable);
    // Sentinel = 'aIsAvailable'
    ((&(writer__)))->WriteSentinel(491914399);




    if (mozilla::ipc::LoggingEnabledFor("PLockRequest", mozilla::ipc::ParentSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PLockRequestParent",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PLockRequest::Msg_Resolve", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PLockRequestParent::Send__delete__(
        PLockRequestParent* actor,
        const bool& aAborted) -> bool
{
    if (!actor || !actor->CanSend()) {
        NS_WARNING("Attempt to __delete__ missing or closed actor");
        return false;
    }
    UniquePtr<IPC::Message> msg__ = PLockRequest::Msg___delete__((actor)->Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            actor};

    IPC::WriteParam((&(writer__)), aAborted);
    // Sentinel = 'aAborted'
    ((&(writer__)))->WriteSentinel(228590371);



    if (mozilla::ipc::LoggingEnabledFor("PLockRequest", mozilla::ipc::ParentSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PLockRequestParent",
            actor->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PLockRequest::Msg___delete__", OTHER);

    bool sendok__ = (actor)->ChannelSend(std::move(msg__));

    actor->ActorDisconnected(Deletion);
    return sendok__;
}

auto PLockRequestParent::DeallocManagee(
        int32_t aProtocolId,
        IProtocol* aListener) -> void
{
    FatalError("unreached");
    return;
}

auto PLockRequestParent::OnMessageReceived(const Message& msg__) -> PLockRequestParent::Result
{
    switch (msg__.type()) {
    case MANAGED_ENDPOINT_BOUND_MESSAGE_TYPE:
        {
            if (!mAwaitingManagedEndpointBind) {
                NS_WARNING("Unexpected managed endpoint lifecycle message after actor bound!");
                return MsgNotAllowed;
            }
            mAwaitingManagedEndpointBind = false;
            return MsgProcessed;
        }
    case MANAGED_ENDPOINT_DROPPED_MESSAGE_TYPE:
        {
            if (!mAwaitingManagedEndpointBind) {
                NS_WARNING("Unexpected managed endpoint lifecycle message after actor bound!");
                return MsgNotAllowed;
            }
            mAwaitingManagedEndpointBind = false;
            this->ActorDisconnected(ManagedEndpointDropped);
            return MsgProcessed;
        }
    case PLockRequest::Reply___delete____ID:
        {
            return MsgProcessed;
        }
    case PLockRequest::Msg___delete____ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PLockRequest", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PLockRequestParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PLockRequest::Msg___delete__", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__aAborted = IPC::ReadParam<bool>((&(reader__)));
            if (!maybe__aAborted) {
                FatalError("Error deserializing 'bool'");
                return MsgValueError;

            }
            auto& aAborted = *maybe__aAborted;
            // Sentinel = 'aAborted'
            if ((!(((&(reader__)))->ReadSentinel(228590371)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'bool'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::IPCResult __ok = (static_cast<LockRequestParent*>(this))->Recv__delete__(std::move(aAborted));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }


            this->ActorDisconnected(Deletion);

            return MsgProcessed;
        }
    default:
        return MsgNotKnown;
    }
}

auto PLockRequestParent::OnMessageReceived(
        const Message& msg__,
        UniquePtr<Message>& reply__) -> PLockRequestParent::Result
{
    return MsgNotKnown;
}



} // namespace locks
} // namespace dom
} // namespace mozilla
namespace IPC {
auto ParamTraits<::mozilla::dom::locks::PLockRequestParent*>::Write(
        IPC::MessageWriter* aWriter,
        const paramType& aVar) -> void
{
    MOZ_RELEASE_ASSERT(
        aWriter->GetActor(),
        "Cannot serialize managed actors without an actor");

    int32_t id;
    if (!aVar) {
        id = 0;  // kNullActorId
    } else {
        id = aVar->Id();
        if (id == 1) {  // kFreedActorId
            aVar->FatalError("Actor has been |delete|d");
        }
        MOZ_RELEASE_ASSERT(
            aWriter->GetActor()->GetIPCChannel() == aVar->GetIPCChannel(),
            "Actor must be from the same channel as the"
            " actor it's being sent over");
        MOZ_RELEASE_ASSERT(
            aVar->CanSend(),
            "Actor must still be open when sending");
    }

    IPC::WriteParam(aWriter, id);
}

auto ParamTraits<::mozilla::dom::locks::PLockRequestParent*>::Read(IPC::MessageReader* aReader) -> IPC::ReadResult<paramType>
{
    MOZ_RELEASE_ASSERT(
        aReader->GetActor(),
        "Cannot deserialize managed actors without an actor");
    mozilla::Maybe<mozilla::ipc::IProtocol*> actor = aReader->GetActor()
        ->ReadActor(aReader, true, "PLockRequest", PLockRequestMsgStart);
    if (actor.isSome()) {
        return static_cast<::mozilla::dom::locks::PLockRequestParent*>(actor.ref());
    }
    return {};
}

} // namespace IPC
