//
// Automatically generated by ipdlc.
// Edit at your own risk
//


#include "mozilla/dom/locks/PLockManagerParent.h"
#include "mozilla/ProfilerLabels.h"
#include "mozilla/dom/locks/IPCUtils.h"
#include "mozilla/dom/locks/LockManagerParent.h"

#include "mozilla/ipc/PBackgroundParent.h"
#include "mozilla/dom/locks/PLockRequestParent.h"

#include "ipc/IPCMessageUtils.h"
#include "ipc/IPCMessageUtilsSpecializations.h"
#include "nsIFile.h"
#include "mozilla/ipc/Endpoint.h"
#include "mozilla/ipc/ProtocolMessageUtils.h"
#include "mozilla/ipc/ProtocolUtils.h"
#include "mozilla/ipc/ShmemMessageUtils.h"
#include "mozilla/ipc/TaintingIPCUtils.h"

namespace mozilla {
namespace dom {
namespace locks {


auto PLockManagerParent::RecvPLockRequestConstructor(
        PLockRequestParent* actor,
        const IPCLockRequest& aRequest) -> mozilla::ipc::IPCResult
{
    return IPC_OK();
}

auto PLockManagerParent::Recv__delete__() -> mozilla::ipc::IPCResult
{
    return IPC_OK();
}

MOZ_IMPLICIT PLockManagerParent::PLockManagerParent() :
    mozilla::ipc::IRefCountedProtocol(kProtocolId, mozilla::ipc::ParentSide)
{
    MOZ_COUNT_CTOR(PLockManagerParent);
}

PLockManagerParent::~PLockManagerParent()
{
    MOZ_COUNT_DTOR(PLockManagerParent);
}

auto PLockManagerParent::ActorAlloc() -> void
{
    AddRef();
}

auto PLockManagerParent::ActorDealloc() -> void
{
    Release();
}

auto PLockManagerParent::OtherPid() const -> ::base::ProcessId
{
    ::base::ProcessId pid =
        ::mozilla::ipc::IProtocol::ToplevelProtocol()->OtherPidMaybeInvalid();
    MOZ_RELEASE_ASSERT(pid != ::base::kInvalidProcessId);
    return pid;
}

auto PLockManagerParent::OtherChildID() const -> ::GeckoChildID
{
    ::GeckoChildID childID =
        ::mozilla::ipc::IProtocol::ToplevelProtocol()->OtherChildIDMaybeInvalid();
    MOZ_RELEASE_ASSERT(childID != -1);
    return childID;
}

auto PLockManagerParent::OtherEndpointProcInfo() const -> ::mozilla::ipc::EndpointProcInfo
{
    return ::mozilla::ipc::EndpointProcInfo{OtherPid(), OtherChildID()};
}

auto PLockManagerParent::Manager() const -> PBackgroundParent*
{
    return static_cast<PBackgroundParent*>(IProtocol::Manager());
}

auto PLockManagerParent::ManagedPLockRequestParent(nsTArray<PLockRequestParent*>& aArr) const -> void
{
    mManagedPLockRequestParent.ToArray(aArr);
}

auto PLockManagerParent::ManagedPLockRequestParent() const -> const ManagedContainer<PLockRequestParent>&
{
    return mManagedPLockRequestParent;
}

auto PLockManagerParent::ManagedProtocolIds() const -> mozilla::Span<mozilla::ipc::ProtocolId const>
{
    static constexpr ::mozilla::ipc::ProtocolId sIds[] = {
        PLockRequestMsgStart
    };
    return sIds;
}

auto PLockManagerParent::GetManagedActors(mozilla::ipc::ProtocolId aProtocol) -> UntypedManagedContainer*
{
    switch (aProtocol) {
    case PLockRequestMsgStart:
        return (&(mManagedPLockRequestParent));
    default:
        return nullptr;
    }
}

auto PLockManagerParent::RejectPendingResponses(ResponseRejectReason aReason) -> void
{
    mAsyncCallbacks.RejectPendingResponses(aReason);
}

auto PLockManagerParent::OpenPLockRequestEndpoint(PLockRequestParent* aActor) -> ManagedEndpoint<PLockRequestChild>
{
    if (!aActor) {
        NS_WARNING("Cannot bind null PLockRequestParent actor");
        return ManagedEndpoint<PLockRequestChild>();
    }

    if (!aActor->SetManagerAndRegister(this)) {
        NS_WARNING("Failed to bind PLockRequestParent actor");
        return ManagedEndpoint<PLockRequestChild>();
    }

    // Mark our actor as awaiting the other side to be bound. This will
    // be cleared when a `MANAGED_ENDPOINT_{DROPPED,BOUND}` message is
    // received.
    aActor->mAwaitingManagedEndpointBind = true;
    return ManagedEndpoint<PLockRequestChild>(mozilla::ipc::PrivateIPDLInterface(), aActor);
}

auto PLockManagerParent::BindPLockRequestEndpoint(
        ManagedEndpoint<PLockRequestParent> aEndpoint,
        PLockRequestParent* aActor) -> bool
{
    return aEndpoint.Bind(mozilla::ipc::PrivateIPDLInterface(), aActor, this);
}

auto PLockManagerParent::DeallocManagee(
        int32_t aProtocolId,
        IProtocol* aListener) -> void
{
    switch (aProtocolId) {
    default:
        FatalError("unreached");
        return;
    }
}

auto PLockManagerParent::OnMessageReceived(const Message& msg__) -> PLockManagerParent::Result
{
    switch (msg__.type()) {
    case MANAGED_ENDPOINT_BOUND_MESSAGE_TYPE:
        {
            if (!mAwaitingManagedEndpointBind) {
                NS_WARNING("Unexpected managed endpoint lifecycle message after actor bound!");
                return MsgNotAllowed;
            }
            mAwaitingManagedEndpointBind = false;
            return MsgProcessed;
        }
    case MANAGED_ENDPOINT_DROPPED_MESSAGE_TYPE:
        {
            if (!mAwaitingManagedEndpointBind) {
                NS_WARNING("Unexpected managed endpoint lifecycle message after actor bound!");
                return MsgNotAllowed;
            }
            mAwaitingManagedEndpointBind = false;
            this->ActorDisconnected(ManagedEndpointDropped);
            return MsgProcessed;
        }
    case PLockManager::Msg_Query__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PLockManager", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PLockManagerParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PLockManager::Msg_Query", OTHER);

            int32_t id__ = Id();
            UniquePtr<IPC::Message> reply__(PLockManager::Reply_Query(id__));
            reply__->set_seqno(msg__.seqno());

            RefPtr<mozilla::ipc::IPDLResolverInner> resolver__ =
                new mozilla::ipc::IPDLResolverInner(std::move(reply__), this);

            QueryResolver resolver = [resolver__ = std::move(resolver__)](const LockManagerSnapshot& aParam) {
                resolver__->Resolve([&] (IPC::Message* reply__, IProtocol* self__) {
                    IPC::MessageWriter writer__(*reply__, self__);
                    IPC::WriteParam((&(writer__)), aParam);
                    // Sentinel = 'snapshot'
                    ((&(writer__)))->WriteSentinel(258868081);

                    if (mozilla::ipc::LoggingEnabledFor("PLockManager", mozilla::ipc::ParentSide)) {
                        mozilla::ipc::LogMessageForProtocol(
                            "PLockManagerParent",
                            self__->ToplevelProtocol()->OtherPidMaybeInvalid(),
                            "Sending reply ",
                            reply__->type(),
                            mozilla::ipc::MessageDirection::eSending);
                    }

                });
            };
            mozilla::ipc::IPCResult __ok = (static_cast<LockManagerParent*>(this))->RecvQuery(std::move(resolver));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PLockManager::Msg_PLockRequestConstructor__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PLockManager", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PLockManagerParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PLockManager::Msg_PLockRequestConstructor", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__handle__ = IPC::ReadParam<ActorHandle>((&(reader__)));
            if (!maybe__handle__) {
                FatalError("Error deserializing 'ActorHandle'");
                return MsgValueError;

            }
            auto& handle__ = *maybe__handle__;
            // Sentinel = 'actor'
            if ((!(((&(reader__)))->ReadSentinel(102892058)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'ActorHandle'");
                return MsgValueError;
            }
            auto maybe__aRequest = IPC::ReadParam<IPCLockRequest>((&(reader__)));
            if (!maybe__aRequest) {
                FatalError("Error deserializing 'IPCLockRequest'");
                return MsgValueError;

            }
            auto& aRequest = *maybe__aRequest;
            // Sentinel = 'aRequest'
            if ((!(((&(reader__)))->ReadSentinel(238945099)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'IPCLockRequest'");
                return MsgValueError;
            }
            reader__.EndRead();
            RefPtr<PLockRequestParent> actor = (static_cast<LockManagerParent*>(this))->AllocPLockRequestParent(aRequest);
            if (!actor) {
                NS_WARNING("Cannot bind null PLockRequestParent actor");
                return MsgValueError;
            }

            if (!actor->SetManagerAndRegister(this, (handle__).mId)) {
                NS_WARNING("Failed to bind PLockRequestParent actor");
                return MsgValueError;
            }

            mozilla::ipc::IPCResult __ok = (static_cast<LockManagerParent*>(this))->RecvPLockRequestConstructor(actor, std::move(aRequest));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PLockManager::Msg___delete____ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PLockManager", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PLockManagerParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PLockManager::Msg___delete__", OTHER);

            mozilla::ipc::IPCResult __ok = (static_cast<LockManagerParent*>(this))->Recv__delete__();
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }


            this->ActorDisconnected(Deletion);

            return MsgProcessed;
        }
    default:
        return MsgNotKnown;
    }
}

auto PLockManagerParent::OnMessageReceived(
        const Message& msg__,
        UniquePtr<Message>& reply__) -> PLockManagerParent::Result
{
    return MsgNotKnown;
}



} // namespace locks
} // namespace dom
} // namespace mozilla
namespace IPC {
auto ParamTraits<::mozilla::dom::locks::PLockManagerParent*>::Write(
        IPC::MessageWriter* aWriter,
        const paramType& aVar) -> void
{
    MOZ_RELEASE_ASSERT(
        aWriter->GetActor(),
        "Cannot serialize managed actors without an actor");

    int32_t id;
    if (!aVar) {
        id = 0;  // kNullActorId
    } else {
        id = aVar->Id();
        if (id == 1) {  // kFreedActorId
            aVar->FatalError("Actor has been |delete|d");
        }
        MOZ_RELEASE_ASSERT(
            aWriter->GetActor()->GetIPCChannel() == aVar->GetIPCChannel(),
            "Actor must be from the same channel as the"
            " actor it's being sent over");
        MOZ_RELEASE_ASSERT(
            aVar->CanSend(),
            "Actor must still be open when sending");
    }

    IPC::WriteParam(aWriter, id);
}

auto ParamTraits<::mozilla::dom::locks::PLockManagerParent*>::Read(IPC::MessageReader* aReader) -> IPC::ReadResult<paramType>
{
    MOZ_RELEASE_ASSERT(
        aReader->GetActor(),
        "Cannot deserialize managed actors without an actor");
    mozilla::Maybe<mozilla::ipc::IProtocol*> actor = aReader->GetActor()
        ->ReadActor(aReader, true, "PLockManager", PLockManagerMsgStart);
    if (actor.isSome()) {
        return static_cast<::mozilla::dom::locks::PLockManagerParent*>(actor.ref());
    }
    return {};
}

} // namespace IPC
