//
// Automatically generated by ipdlc.
// Edit at your own risk
//


#include "mozilla/ipc/PIdleSchedulerChild.h"
#include "mozilla/ProfilerLabels.h"
#include "mozilla/ipc/IdleSchedulerChild.h"

#include "mozilla/ipc/PBackgroundChild.h"

#include "ipc/IPCMessageUtils.h"
#include "ipc/IPCMessageUtilsSpecializations.h"
#include "nsIFile.h"
#include "mozilla/ipc/Endpoint.h"
#include "mozilla/ipc/ProtocolMessageUtils.h"
#include "mozilla/ipc/ProtocolUtils.h"
#include "mozilla/ipc/ShmemMessageUtils.h"
#include "mozilla/ipc/TaintingIPCUtils.h"

namespace mozilla {
namespace ipc {


MOZ_IMPLICIT PIdleSchedulerChild::PIdleSchedulerChild() :
    mozilla::ipc::IRefCountedProtocol(kProtocolId, mozilla::ipc::ChildSide)
{
    MOZ_COUNT_CTOR(PIdleSchedulerChild);
}

PIdleSchedulerChild::~PIdleSchedulerChild()
{
    MOZ_COUNT_DTOR(PIdleSchedulerChild);
}

auto PIdleSchedulerChild::ActorAlloc() -> void
{
    AddRef();
}

auto PIdleSchedulerChild::ActorDealloc() -> void
{
    Release();
}

auto PIdleSchedulerChild::OtherPid() const -> ::base::ProcessId
{
    ::base::ProcessId pid =
        ::mozilla::ipc::IProtocol::ToplevelProtocol()->OtherPidMaybeInvalid();
    MOZ_RELEASE_ASSERT(pid != ::base::kInvalidProcessId);
    return pid;
}

auto PIdleSchedulerChild::OtherChildID() const -> ::GeckoChildID
{
    ::GeckoChildID childID =
        ::mozilla::ipc::IProtocol::ToplevelProtocol()->OtherChildIDMaybeInvalid();
    MOZ_RELEASE_ASSERT(childID != -1);
    return childID;
}

auto PIdleSchedulerChild::OtherEndpointProcInfo() const -> ::mozilla::ipc::EndpointProcInfo
{
    return ::mozilla::ipc::EndpointProcInfo{OtherPid(), OtherChildID()};
}

auto PIdleSchedulerChild::Manager() const -> PBackgroundChild*
{
    return static_cast<PBackgroundChild*>(IProtocol::Manager());
}

auto PIdleSchedulerChild::ManagedProtocolIds() const -> mozilla::Span<mozilla::ipc::ProtocolId const>
{
    return {};
}

auto PIdleSchedulerChild::GetManagedActors(mozilla::ipc::ProtocolId aProtocol) -> UntypedManagedContainer*
{
    switch (aProtocol) {
    default:
        return nullptr;
    }
}

auto PIdleSchedulerChild::RejectPendingResponses(ResponseRejectReason aReason) -> void
{
    mAsyncCallbacks.RejectPendingResponses(aReason);
}

auto PIdleSchedulerChild::SendInitForIdleUse(
        mozilla::ipc::ResolveCallback<std::tuple<mozilla::Maybe<MutableSharedMemoryHandle>, uint32_t>>&& aResolve,
        mozilla::ipc::RejectCallback&& aReject) -> void
{
    UniquePtr<IPC::Message> msg__ = PIdleScheduler::Msg_InitForIdleUse(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};





    if (mozilla::ipc::LoggingEnabledFor("PIdleScheduler", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PIdleSchedulerChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PIdleScheduler::Msg_InitForIdleUse", OTHER);

    int32_t seqno__ = 0;
    if (ChannelSend(std::move(msg__), (&(seqno__)))) {
        mAsyncCallbacks.AddCallback(seqno__, PIdleScheduler::Reply_InitForIdleUse__ID, [resolve=std::move(aResolve)](IPC::MessageReader* aReader) mutable {
            auto maybe__state = IPC::ReadParam<mozilla::Maybe<MutableSharedMemoryHandle>>(aReader);
            if (!maybe__state) {
                (aReader)->FatalError("Error deserializing 'MutableSharedMemoryHandle?'");
                return MsgValueError;

            }
            auto& state = *maybe__state;
            // Sentinel = 'state'
            if ((!((aReader)->ReadSentinel(109314594)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'MutableSharedMemoryHandle?'");
                return MsgValueError;
            }
            auto maybe__childId = IPC::ReadParam<uint32_t>(aReader);
            if (!maybe__childId) {
                (aReader)->FatalError("Error deserializing 'uint32_t'");
                return MsgValueError;

            }
            auto& childId = *maybe__childId;
            // Sentinel = 'childId'
            if ((!((aReader)->ReadSentinel(185270962)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'uint32_t'");
                return MsgValueError;
            }


            aReader->EndRead();

            resolve(std::make_tuple(std::move(state), std::move(childId)));
            return MsgProcessed;
        }, std::move(aReject));
    }
    else {
        aReject(::mozilla::ipc::ResponseRejectReason::SendError);
    }
    return;
}

auto PIdleSchedulerChild::SendInitForIdleUse() -> RefPtr<InitForIdleUsePromise>
{
    RefPtr<MozPromise<std::tuple<mozilla::Maybe<MutableSharedMemoryHandle>, uint32_t>, ResponseRejectReason, true>::Private> promise__ = new MozPromise<std::tuple<mozilla::Maybe<MutableSharedMemoryHandle>, uint32_t>, ResponseRejectReason, true>::Private(__func__);
    promise__->UseDirectTaskDispatch(__func__);
    SendInitForIdleUse([promise__](std::tuple<mozilla::Maybe<MutableSharedMemoryHandle>, uint32_t>&& aValue) {
        promise__->Resolve(std::move(aValue), __func__);
    }, [promise__](ResponseRejectReason&& aReason) {
        promise__->Reject(std::move(aReason), __func__);
    });
    return promise__;
}

auto PIdleSchedulerChild::SendRequestIdleTime(
        const uint64_t& id,
        const TimeDuration& budget) -> bool
{
    UniquePtr<IPC::Message> msg__ = PIdleScheduler::Msg_RequestIdleTime(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), id);
    // Sentinel = 'id'
    ((&(writer__)))->WriteSentinel(20447438);
    IPC::WriteParam((&(writer__)), budget);
    // Sentinel = 'budget'
    ((&(writer__)))->WriteSentinel(144573052);




    if (mozilla::ipc::LoggingEnabledFor("PIdleScheduler", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PIdleSchedulerChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PIdleScheduler::Msg_RequestIdleTime", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PIdleSchedulerChild::SendIdleTimeUsed(const uint64_t& id) -> bool
{
    UniquePtr<IPC::Message> msg__ = PIdleScheduler::Msg_IdleTimeUsed(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), id);
    // Sentinel = 'id'
    ((&(writer__)))->WriteSentinel(20447438);




    if (mozilla::ipc::LoggingEnabledFor("PIdleScheduler", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PIdleSchedulerChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PIdleScheduler::Msg_IdleTimeUsed", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PIdleSchedulerChild::SendSchedule() -> bool
{
    UniquePtr<IPC::Message> msg__ = PIdleScheduler::Msg_Schedule(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};





    if (mozilla::ipc::LoggingEnabledFor("PIdleScheduler", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PIdleSchedulerChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PIdleScheduler::Msg_Schedule", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PIdleSchedulerChild::SendRunningPrioritizedOperation() -> bool
{
    UniquePtr<IPC::Message> msg__ = PIdleScheduler::Msg_RunningPrioritizedOperation(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};





    if (mozilla::ipc::LoggingEnabledFor("PIdleScheduler", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PIdleSchedulerChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PIdleScheduler::Msg_RunningPrioritizedOperation", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PIdleSchedulerChild::SendPrioritizedOperationDone() -> bool
{
    UniquePtr<IPC::Message> msg__ = PIdleScheduler::Msg_PrioritizedOperationDone(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};





    if (mozilla::ipc::LoggingEnabledFor("PIdleScheduler", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PIdleSchedulerChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PIdleScheduler::Msg_PrioritizedOperationDone", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PIdleSchedulerChild::SendRequestGC(
        mozilla::ipc::ResolveCallback<bool>&& aResolve,
        mozilla::ipc::RejectCallback&& aReject) -> void
{
    UniquePtr<IPC::Message> msg__ = PIdleScheduler::Msg_RequestGC(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};





    if (mozilla::ipc::LoggingEnabledFor("PIdleScheduler", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PIdleSchedulerChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PIdleScheduler::Msg_RequestGC", OTHER);

    int32_t seqno__ = 0;
    if (ChannelSend(std::move(msg__), (&(seqno__)))) {
        mAsyncCallbacks.AddCallback(seqno__, PIdleScheduler::Reply_RequestGC__ID, [resolve=std::move(aResolve)](IPC::MessageReader* aReader) mutable {
            auto maybe__may_gc = IPC::ReadParam<bool>(aReader);
            if (!maybe__may_gc) {
                (aReader)->FatalError("Error deserializing 'bool'");
                return MsgValueError;

            }
            auto& may_gc = *maybe__may_gc;
            // Sentinel = 'may_gc'
            if ((!((aReader)->ReadSentinel(145425009)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'bool'");
                return MsgValueError;
            }


            aReader->EndRead();

            resolve(std::move(may_gc));
            return MsgProcessed;
        }, std::move(aReject));
    }
    else {
        aReject(::mozilla::ipc::ResponseRejectReason::SendError);
    }
    return;
}

auto PIdleSchedulerChild::SendRequestGC() -> RefPtr<RequestGCPromise>
{
    RefPtr<MozPromise<bool, ResponseRejectReason, true>::Private> promise__ = new MozPromise<bool, ResponseRejectReason, true>::Private(__func__);
    promise__->UseDirectTaskDispatch(__func__);
    SendRequestGC([promise__](bool&& aValue) {
        promise__->Resolve(std::move(aValue), __func__);
    }, [promise__](ResponseRejectReason&& aReason) {
        promise__->Reject(std::move(aReason), __func__);
    });
    return promise__;
}

auto PIdleSchedulerChild::SendStartedGC() -> bool
{
    UniquePtr<IPC::Message> msg__ = PIdleScheduler::Msg_StartedGC(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};





    if (mozilla::ipc::LoggingEnabledFor("PIdleScheduler", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PIdleSchedulerChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PIdleScheduler::Msg_StartedGC", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PIdleSchedulerChild::SendDoneGC() -> bool
{
    UniquePtr<IPC::Message> msg__ = PIdleScheduler::Msg_DoneGC(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};





    if (mozilla::ipc::LoggingEnabledFor("PIdleScheduler", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PIdleSchedulerChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PIdleScheduler::Msg_DoneGC", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PIdleSchedulerChild::Send__delete__(PIdleSchedulerChild* actor) -> bool
{
    if (!actor || !actor->CanSend()) {
        NS_WARNING("Attempt to __delete__ missing or closed actor");
        return false;
    }
    UniquePtr<IPC::Message> msg__ = PIdleScheduler::Msg___delete__((actor)->Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            actor};




    if (mozilla::ipc::LoggingEnabledFor("PIdleScheduler", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PIdleSchedulerChild",
            actor->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PIdleScheduler::Msg___delete__", OTHER);

    bool sendok__ = (actor)->ChannelSend(std::move(msg__));

    actor->ActorDisconnected(Deletion);
    return sendok__;
}

auto PIdleSchedulerChild::DeallocManagee(
        int32_t aProtocolId,
        IProtocol* aListener) -> void
{
    FatalError("unreached");
    return;
}

auto PIdleSchedulerChild::OnMessageReceived(const Message& msg__) -> PIdleSchedulerChild::Result
{
    switch (msg__.type()) {
    case MANAGED_ENDPOINT_BOUND_MESSAGE_TYPE:
        {
            if (!mAwaitingManagedEndpointBind) {
                NS_WARNING("Unexpected managed endpoint lifecycle message after actor bound!");
                return MsgNotAllowed;
            }
            mAwaitingManagedEndpointBind = false;
            return MsgProcessed;
        }
    case MANAGED_ENDPOINT_DROPPED_MESSAGE_TYPE:
        {
            if (!mAwaitingManagedEndpointBind) {
                NS_WARNING("Unexpected managed endpoint lifecycle message after actor bound!");
                return MsgNotAllowed;
            }
            mAwaitingManagedEndpointBind = false;
            this->ActorDisconnected(ManagedEndpointDropped);
            return MsgProcessed;
        }
    case PIdleScheduler::Msg_IdleTime__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PIdleScheduler", mozilla::ipc::ChildSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PIdleSchedulerChild",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PIdleScheduler::Msg_IdleTime", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__id = IPC::ReadParam<uint64_t>((&(reader__)));
            if (!maybe__id) {
                FatalError("Error deserializing 'uint64_t'");
                return MsgValueError;

            }
            auto& id = *maybe__id;
            // Sentinel = 'id'
            if ((!(((&(reader__)))->ReadSentinel(20447438)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'uint64_t'");
                return MsgValueError;
            }
            auto maybe__budget = IPC::ReadParam<TimeDuration>((&(reader__)));
            if (!maybe__budget) {
                FatalError("Error deserializing 'TimeDuration'");
                return MsgValueError;

            }
            auto& budget = *maybe__budget;
            // Sentinel = 'budget'
            if ((!(((&(reader__)))->ReadSentinel(144573052)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'TimeDuration'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::IPCResult __ok = (static_cast<IdleSchedulerChild*>(this))->RecvIdleTime(std::move(id), std::move(budget));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PIdleScheduler::Reply_InitForIdleUse__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PIdleScheduler", mozilla::ipc::ChildSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PIdleSchedulerChild",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }

            AUTO_PROFILER_LABEL("PIdleScheduler::Msg_InitForIdleUse", OTHER);


            return mAsyncCallbacks.GotReply(this, msg__);
        }
    case PIdleScheduler::Reply_RequestGC__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PIdleScheduler", mozilla::ipc::ChildSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PIdleSchedulerChild",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }

            AUTO_PROFILER_LABEL("PIdleScheduler::Msg_RequestGC", OTHER);


            return mAsyncCallbacks.GotReply(this, msg__);
        }
    case PIdleScheduler::Reply___delete____ID:
        {
            return MsgProcessed;
        }
    default:
        return MsgNotKnown;
    }
}

auto PIdleSchedulerChild::OnMessageReceived(
        const Message& msg__,
        UniquePtr<Message>& reply__) -> PIdleSchedulerChild::Result
{
    return MsgNotKnown;
}



} // namespace ipc
} // namespace mozilla
namespace IPC {
auto ParamTraits<::mozilla::ipc::PIdleSchedulerChild*>::Write(
        IPC::MessageWriter* aWriter,
        const paramType& aVar) -> void
{
    MOZ_RELEASE_ASSERT(
        aWriter->GetActor(),
        "Cannot serialize managed actors without an actor");

    int32_t id;
    if (!aVar) {
        id = 0;  // kNullActorId
    } else {
        id = aVar->Id();
        if (id == 1) {  // kFreedActorId
            aVar->FatalError("Actor has been |delete|d");
        }
        MOZ_RELEASE_ASSERT(
            aWriter->GetActor()->GetIPCChannel() == aVar->GetIPCChannel(),
            "Actor must be from the same channel as the"
            " actor it's being sent over");
        MOZ_RELEASE_ASSERT(
            aVar->CanSend(),
            "Actor must still be open when sending");
    }

    IPC::WriteParam(aWriter, id);
}

auto ParamTraits<::mozilla::ipc::PIdleSchedulerChild*>::Read(IPC::MessageReader* aReader) -> IPC::ReadResult<paramType>
{
    MOZ_RELEASE_ASSERT(
        aReader->GetActor(),
        "Cannot deserialize managed actors without an actor");
    mozilla::Maybe<mozilla::ipc::IProtocol*> actor = aReader->GetActor()
        ->ReadActor(aReader, true, "PIdleScheduler", PIdleSchedulerMsgStart);
    if (actor.isSome()) {
        return static_cast<::mozilla::ipc::PIdleSchedulerChild*>(actor.ref());
    }
    return {};
}

} // namespace IPC
