//
// Automatically generated by ipdlc.
// Edit at your own risk
//


#include "mozilla/net/PHttpTransactionParent.h"
#include "mozilla/AntiTrackingIPCUtils.h"
#include "mozilla/ProfilerLabels.h"
#include "mozilla/TimeStamp.h"
#include "mozilla/dom/DomSecurityIPCUtils.h"
#include "mozilla/dom/FeaturePolicyUtils.h"
#include "mozilla/dom/FetchIPCTypes.h"
#include "mozilla/dom/NavigationAPIIPCUtils.h"
#include "mozilla/dom/PropertyBagUtils.h"
#include "mozilla/dom/ReferrerInfoUtils.h"
#include "mozilla/dom/SessionHistoryEntry.h"
#include "mozilla/ipc/TransportSecurityInfoUtils.h"
#include "mozilla/ipc/URIUtils.h"
#include "mozilla/net/CacheInfoIPCTypes.h"
#include "mozilla/net/ClassOfService.h"
#include "mozilla/net/HttpTransactionParent.h"
#include "mozilla/net/NeckoMessageUtils.h"
#include "nsDOMNavigationTiming.h"
#include "nsDocShellLoadState.h"
#include "nsHttp.h"
#include "nsHttpHeaderArray.h"
#include "nsHttpRequestHead.h"
#include "nsHttpResponseHead.h"
#include "nsIPropertyBag2.h"
#include "nsITransportSecurityInfo.h"

#include "mozilla/net/PSocketProcessParent.h"
#include "mozilla/net/PInputChannelThrottleQueueParent.h"

#include "ipc/IPCMessageUtils.h"
#include "ipc/IPCMessageUtilsSpecializations.h"
#include "nsIFile.h"
#include "mozilla/ipc/Endpoint.h"
#include "mozilla/ipc/ProtocolMessageUtils.h"
#include "mozilla/ipc/ProtocolUtils.h"
#include "mozilla/ipc/ShmemMessageUtils.h"
#include "mozilla/ipc/TaintingIPCUtils.h"

namespace mozilla {
namespace net {


MOZ_IMPLICIT PHttpTransactionParent::PHttpTransactionParent() :
    mozilla::ipc::IRefCountedProtocol(kProtocolId, mozilla::ipc::ParentSide)
{
    MOZ_COUNT_CTOR(PHttpTransactionParent);
}

PHttpTransactionParent::~PHttpTransactionParent()
{
    MOZ_COUNT_DTOR(PHttpTransactionParent);
}

auto PHttpTransactionParent::ActorAlloc() -> void
{
    AddRef();
}

auto PHttpTransactionParent::ActorDealloc() -> void
{
    Release();
}

auto PHttpTransactionParent::OtherPid() const -> ::base::ProcessId
{
    ::base::ProcessId pid =
        ::mozilla::ipc::IProtocol::ToplevelProtocol()->OtherPidMaybeInvalid();
    MOZ_RELEASE_ASSERT(pid != ::base::kInvalidProcessId);
    return pid;
}

auto PHttpTransactionParent::OtherChildID() const -> ::GeckoChildID
{
    ::GeckoChildID childID =
        ::mozilla::ipc::IProtocol::ToplevelProtocol()->OtherChildIDMaybeInvalid();
    MOZ_RELEASE_ASSERT(childID != -1);
    return childID;
}

auto PHttpTransactionParent::OtherEndpointProcInfo() const -> ::mozilla::ipc::EndpointProcInfo
{
    return ::mozilla::ipc::EndpointProcInfo{OtherPid(), OtherChildID()};
}

auto PHttpTransactionParent::Manager() const -> PSocketProcessParent*
{
    return static_cast<PSocketProcessParent*>(IProtocol::Manager());
}

auto PHttpTransactionParent::ManagedProtocolIds() const -> mozilla::Span<mozilla::ipc::ProtocolId const>
{
    return {};
}

auto PHttpTransactionParent::GetManagedActors(mozilla::ipc::ProtocolId aProtocol) -> UntypedManagedContainer*
{
    switch (aProtocol) {
    default:
        return nullptr;
    }
}

auto PHttpTransactionParent::Send__delete__(PHttpTransactionParent* actor) -> bool
{
    if (!actor || !actor->CanSend()) {
        NS_WARNING("Attempt to __delete__ missing or closed actor");
        return false;
    }
    UniquePtr<IPC::Message> msg__ = PHttpTransaction::Msg___delete__((actor)->Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            actor};




    if (mozilla::ipc::LoggingEnabledFor("PHttpTransaction", mozilla::ipc::ParentSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PHttpTransactionParent",
            actor->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PHttpTransaction::Msg___delete__", OTHER);

    bool sendok__ = (actor)->ChannelSend(std::move(msg__));

    actor->ActorDisconnected(Deletion);
    return sendok__;
}

auto PHttpTransactionParent::SendInit(
        const uint32_t& caps,
        const HttpConnectionInfoCloneArgs& aArgs,
        const nsHttpRequestHead& reqHeaders,
        const mozilla::Maybe<IPCStream>& requestBody,
        const uint64_t& reqContentLength,
        const bool& reqBodyIncludesHeaders,
        const uint64_t& topLevelOuterContentWindowId,
        const uint8_t& httpTrafficCategory,
        const uint64_t& requestContextID,
        const ClassOfService& classOfService,
        const uint32_t& initialRwin,
        const bool& responseTimeoutEnabled,
        const uint64_t& channelId,
        const bool& hasTransactionObserver,
        const mozilla::Maybe<H2PushedStreamArg>& pushedStreamArg,
        const mozilla::Maybe<mozilla::NotNull<PInputChannelThrottleQueueParent*>>& throttleQueue,
        const bool& aIsDocumentLoad,
        const TimeStamp& aRedirectStart,
        const TimeStamp& aRedirectEnd) -> bool
{
    UniquePtr<IPC::Message> msg__ = PHttpTransaction::Msg_Init(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), caps);
    // Sentinel = 'caps'
    ((&(writer__)))->WriteSentinel(67502504);
    IPC::WriteParam((&(writer__)), aArgs);
    // Sentinel = 'aArgs'
    ((&(writer__)))->WriteSentinel(92602863);
    IPC::WriteParam((&(writer__)), reqHeaders);
    // Sentinel = 'reqHeaders'
    ((&(writer__)))->WriteSentinel(367264773);
    IPC::WriteParam((&(writer__)), requestBody);
    // Sentinel = 'requestBody'
    ((&(writer__)))->WriteSentinel(466814104);
    IPC::WriteParam((&(writer__)), reqContentLength);
    // Sentinel = 'reqContentLength'
    ((&(writer__)))->WriteSentinel(927794822);
    IPC::WriteParam((&(writer__)), reqBodyIncludesHeaders);
    // Sentinel = 'reqBodyIncludesHeaders'
    ((&(writer__)))->WriteSentinel(1689127114);
    IPC::WriteParam((&(writer__)), topLevelOuterContentWindowId);
    // Sentinel = 'topLevelOuterContentWindowId'
    ((&(writer__)))->WriteSentinel(2779974491);
    IPC::WriteParam((&(writer__)), httpTrafficCategory);
    // Sentinel = 'httpTrafficCategory'
    ((&(writer__)))->WriteSentinel(1295058878);
    IPC::WriteParam((&(writer__)), requestContextID);
    // Sentinel = 'requestContextID'
    ((&(writer__)))->WriteSentinel(956761724);
    IPC::WriteParam((&(writer__)), classOfService);
    // Sentinel = 'classOfService'
    ((&(writer__)))->WriteSentinel(704710045);
    IPC::WriteParam((&(writer__)), initialRwin);
    // Sentinel = 'initialRwin'
    ((&(writer__)))->WriteSentinel(458818699);
    IPC::WriteParam((&(writer__)), responseTimeoutEnabled);
    // Sentinel = 'responseTimeoutEnabled'
    ((&(writer__)))->WriteSentinel(1769408770);
    IPC::WriteParam((&(writer__)), channelId);
    // Sentinel = 'channelId'
    ((&(writer__)))->WriteSentinel(301138823);
    IPC::WriteParam((&(writer__)), hasTransactionObserver);
    // Sentinel = 'hasTransactionObserver'
    ((&(writer__)))->WriteSentinel(1727531275);
    IPC::WriteParam((&(writer__)), pushedStreamArg);
    // Sentinel = 'pushedStreamArg'
    ((&(writer__)))->WriteSentinel(833160720);
    IPC::WriteParam((&(writer__)), throttleQueue);
    // Sentinel = 'throttleQueue'
    ((&(writer__)))->WriteSentinel(653919612);
    IPC::WriteParam((&(writer__)), aIsDocumentLoad);
    // Sentinel = 'aIsDocumentLoad'
    ((&(writer__)))->WriteSentinel(774440413);
    IPC::WriteParam((&(writer__)), aRedirectStart);
    // Sentinel = 'aRedirectStart'
    ((&(writer__)))->WriteSentinel(690554274);
    IPC::WriteParam((&(writer__)), aRedirectEnd);
    // Sentinel = 'aRedirectEnd'
    ((&(writer__)))->WriteSentinel(505808043);




    if (mozilla::ipc::LoggingEnabledFor("PHttpTransaction", mozilla::ipc::ParentSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PHttpTransactionParent",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PHttpTransaction::Msg_Init", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PHttpTransactionParent::SendCancelPump(const nsresult& status) -> bool
{
    UniquePtr<IPC::Message> msg__ = PHttpTransaction::Msg_CancelPump(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), status);
    // Sentinel = 'status'
    ((&(writer__)))->WriteSentinel(154731173);




    if (mozilla::ipc::LoggingEnabledFor("PHttpTransaction", mozilla::ipc::ParentSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PHttpTransactionParent",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PHttpTransaction::Msg_CancelPump", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PHttpTransactionParent::SendSuspendPump() -> bool
{
    UniquePtr<IPC::Message> msg__ = PHttpTransaction::Msg_SuspendPump(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};





    if (mozilla::ipc::LoggingEnabledFor("PHttpTransaction", mozilla::ipc::ParentSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PHttpTransactionParent",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PHttpTransaction::Msg_SuspendPump", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PHttpTransactionParent::SendResumePump() -> bool
{
    UniquePtr<IPC::Message> msg__ = PHttpTransaction::Msg_ResumePump(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};





    if (mozilla::ipc::LoggingEnabledFor("PHttpTransaction", mozilla::ipc::ParentSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PHttpTransactionParent",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PHttpTransaction::Msg_ResumePump", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PHttpTransactionParent::SendSetDNSWasRefreshed() -> bool
{
    UniquePtr<IPC::Message> msg__ = PHttpTransaction::Msg_SetDNSWasRefreshed(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};





    if (mozilla::ipc::LoggingEnabledFor("PHttpTransaction", mozilla::ipc::ParentSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PHttpTransactionParent",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PHttpTransaction::Msg_SetDNSWasRefreshed", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PHttpTransactionParent::SendDontReuseConnection() -> bool
{
    UniquePtr<IPC::Message> msg__ = PHttpTransaction::Msg_DontReuseConnection(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};





    if (mozilla::ipc::LoggingEnabledFor("PHttpTransaction", mozilla::ipc::ParentSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PHttpTransactionParent",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PHttpTransaction::Msg_DontReuseConnection", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PHttpTransactionParent::SendSetH2WSConnRefTaken() -> bool
{
    UniquePtr<IPC::Message> msg__ = PHttpTransaction::Msg_SetH2WSConnRefTaken(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};





    if (mozilla::ipc::LoggingEnabledFor("PHttpTransaction", mozilla::ipc::ParentSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PHttpTransactionParent",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PHttpTransaction::Msg_SetH2WSConnRefTaken", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PHttpTransactionParent::DeallocManagee(
        int32_t aProtocolId,
        IProtocol* aListener) -> void
{
    FatalError("unreached");
    return;
}

auto PHttpTransactionParent::OnMessageReceived(const Message& msg__) -> PHttpTransactionParent::Result
{
    switch (msg__.type()) {
    case MANAGED_ENDPOINT_BOUND_MESSAGE_TYPE:
        {
            if (!mAwaitingManagedEndpointBind) {
                NS_WARNING("Unexpected managed endpoint lifecycle message after actor bound!");
                return MsgNotAllowed;
            }
            mAwaitingManagedEndpointBind = false;
            return MsgProcessed;
        }
    case MANAGED_ENDPOINT_DROPPED_MESSAGE_TYPE:
        {
            if (!mAwaitingManagedEndpointBind) {
                NS_WARNING("Unexpected managed endpoint lifecycle message after actor bound!");
                return MsgNotAllowed;
            }
            mAwaitingManagedEndpointBind = false;
            this->ActorDisconnected(ManagedEndpointDropped);
            return MsgProcessed;
        }
    case PHttpTransaction::Msg_OnStartRequest__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PHttpTransaction", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PHttpTransactionParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PHttpTransaction::Msg_OnStartRequest", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__status = IPC::ReadParam<nsresult>((&(reader__)));
            if (!maybe__status) {
                FatalError("Error deserializing 'nsresult'");
                return MsgValueError;

            }
            auto& status = *maybe__status;
            // Sentinel = 'status'
            if ((!(((&(reader__)))->ReadSentinel(154731173)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'nsresult'");
                return MsgValueError;
            }
            auto maybe__responseHead = IPC::ReadParam<mozilla::Maybe<nsHttpResponseHead>>((&(reader__)));
            if (!maybe__responseHead) {
                FatalError("Error deserializing 'nsHttpResponseHead?'");
                return MsgValueError;

            }
            auto& responseHead = *maybe__responseHead;
            // Sentinel = 'responseHead'
            if ((!(((&(reader__)))->ReadSentinel(549651682)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'nsHttpResponseHead?'");
                return MsgValueError;
            }
            auto maybe__securityInfo = IPC::ReadParam<RefPtr<nsITransportSecurityInfo>>((&(reader__)));
            if (!maybe__securityInfo) {
                FatalError("Error deserializing 'nsITransportSecurityInfo'");
                return MsgValueError;

            }
            auto& securityInfo = *maybe__securityInfo;
            // Sentinel = 'securityInfo'
            if ((!(((&(reader__)))->ReadSentinel(552535301)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'nsITransportSecurityInfo'");
                return MsgValueError;
            }
            auto maybe__proxyConnectFailed = IPC::ReadParam<bool>((&(reader__)));
            if (!maybe__proxyConnectFailed) {
                FatalError("Error deserializing 'bool'");
                return MsgValueError;

            }
            auto& proxyConnectFailed = *maybe__proxyConnectFailed;
            // Sentinel = 'proxyConnectFailed'
            if ((!(((&(reader__)))->ReadSentinel(1194002258)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'bool'");
                return MsgValueError;
            }
            auto maybe__timings = IPC::ReadParam<TimingStructArgs>((&(reader__)));
            if (!maybe__timings) {
                FatalError("Error deserializing 'TimingStructArgs'");
                return MsgValueError;

            }
            auto& timings = *maybe__timings;
            // Sentinel = 'timings'
            if ((!(((&(reader__)))->ReadSentinel(200868604)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'TimingStructArgs'");
                return MsgValueError;
            }
            auto maybe__proxyConnectResponseCode = IPC::ReadParam<int32_t>((&(reader__)));
            if (!maybe__proxyConnectResponseCode) {
                FatalError("Error deserializing 'int32_t'");
                return MsgValueError;

            }
            auto& proxyConnectResponseCode = *maybe__proxyConnectResponseCode;
            // Sentinel = 'proxyConnectResponseCode'
            if ((!(((&(reader__)))->ReadSentinel(2099382743)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'int32_t'");
                return MsgValueError;
            }
            auto maybe__dataForSniffer = IPC::ReadParam<nsTArray<uint8_t>>((&(reader__)));
            if (!maybe__dataForSniffer) {
                FatalError("Error deserializing 'uint8_t[]'");
                return MsgValueError;

            }
            auto& dataForSniffer = *maybe__dataForSniffer;
            // Sentinel = 'dataForSniffer'
            if ((!(((&(reader__)))->ReadSentinel(690816399)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'uint8_t[]'");
                return MsgValueError;
            }
            auto maybe__altSvcUsed = IPC::ReadParam<mozilla::Maybe<nsCString>>((&(reader__)));
            if (!maybe__altSvcUsed) {
                FatalError("Error deserializing 'nsCString?'");
                return MsgValueError;

            }
            auto& altSvcUsed = *maybe__altSvcUsed;
            // Sentinel = 'altSvcUsed'
            if ((!(((&(reader__)))->ReadSentinel(370344959)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'nsCString?'");
                return MsgValueError;
            }
            auto maybe__dataToChildProcess = IPC::ReadParam<bool>((&(reader__)));
            if (!maybe__dataToChildProcess) {
                FatalError("Error deserializing 'bool'");
                return MsgValueError;

            }
            auto& dataToChildProcess = *maybe__dataToChildProcess;
            // Sentinel = 'dataToChildProcess'
            if ((!(((&(reader__)))->ReadSentinel(1114769185)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'bool'");
                return MsgValueError;
            }
            auto maybe__restarted = IPC::ReadParam<bool>((&(reader__)));
            if (!maybe__restarted) {
                FatalError("Error deserializing 'bool'");
                return MsgValueError;

            }
            auto& restarted = *maybe__restarted;
            // Sentinel = 'restarted'
            if ((!(((&(reader__)))->ReadSentinel(323421135)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'bool'");
                return MsgValueError;
            }
            auto maybe__HTTPSSVCReceivedStage = IPC::ReadParam<uint32_t>((&(reader__)));
            if (!maybe__HTTPSSVCReceivedStage) {
                FatalError("Error deserializing 'uint32_t'");
                return MsgValueError;

            }
            auto& HTTPSSVCReceivedStage = *maybe__HTTPSSVCReceivedStage;
            // Sentinel = 'HTTPSSVCReceivedStage'
            if ((!(((&(reader__)))->ReadSentinel(1328154523)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'uint32_t'");
                return MsgValueError;
            }
            auto maybe__supportsHttp3 = IPC::ReadParam<bool>((&(reader__)));
            if (!maybe__supportsHttp3) {
                FatalError("Error deserializing 'bool'");
                return MsgValueError;

            }
            auto& supportsHttp3 = *maybe__supportsHttp3;
            // Sentinel = 'supportsHttp3'
            if ((!(((&(reader__)))->ReadSentinel(663487844)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'bool'");
                return MsgValueError;
            }
            auto maybe__trrMode = IPC::ReadParam<TRRMode>((&(reader__)));
            if (!maybe__trrMode) {
                FatalError("Error deserializing 'TRRMode'");
                return MsgValueError;

            }
            auto& trrMode = *maybe__trrMode;
            // Sentinel = 'trrMode'
            if ((!(((&(reader__)))->ReadSentinel(197591774)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'TRRMode'");
                return MsgValueError;
            }
            auto maybe__trrSkipReason = IPC::ReadParam<TRRSkippedReason>((&(reader__)));
            if (!maybe__trrSkipReason) {
                FatalError("Error deserializing 'TRRSkippedReason'");
                return MsgValueError;

            }
            auto& trrSkipReason = *maybe__trrSkipReason;
            // Sentinel = 'trrSkipReason'
            if ((!(((&(reader__)))->ReadSentinel(630588760)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'TRRSkippedReason'");
                return MsgValueError;
            }
            auto maybe__caps = IPC::ReadParam<uint32_t>((&(reader__)));
            if (!maybe__caps) {
                FatalError("Error deserializing 'uint32_t'");
                return MsgValueError;

            }
            auto& caps = *maybe__caps;
            // Sentinel = 'caps'
            if ((!(((&(reader__)))->ReadSentinel(67502504)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'uint32_t'");
                return MsgValueError;
            }
            auto maybe__onStartRequestStart = IPC::ReadParam<TimeStamp>((&(reader__)));
            if (!maybe__onStartRequestStart) {
                FatalError("Error deserializing 'TimeStamp'");
                return MsgValueError;

            }
            auto& onStartRequestStart = *maybe__onStartRequestStart;
            // Sentinel = 'onStartRequestStart'
            if ((!(((&(reader__)))->ReadSentinel(1313015779)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'TimeStamp'");
                return MsgValueError;
            }
            auto maybe__connInfoArgs = IPC::ReadParam<HttpConnectionInfoCloneArgs>((&(reader__)));
            if (!maybe__connInfoArgs) {
                FatalError("Error deserializing 'HttpConnectionInfoCloneArgs'");
                return MsgValueError;

            }
            auto& connInfoArgs = *maybe__connInfoArgs;
            // Sentinel = 'connInfoArgs'
            if ((!(((&(reader__)))->ReadSentinel(521340104)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'HttpConnectionInfoCloneArgs'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::IPCResult __ok = (static_cast<HttpTransactionParent*>(this))->RecvOnStartRequest(std::move(status), std::move(responseHead), securityInfo, std::move(proxyConnectFailed), std::move(timings), std::move(proxyConnectResponseCode), std::move(dataForSniffer), std::move(altSvcUsed), std::move(dataToChildProcess), std::move(restarted), std::move(HTTPSSVCReceivedStage), std::move(supportsHttp3), std::move(trrMode), std::move(trrSkipReason), std::move(caps), std::move(onStartRequestStart), std::move(connInfoArgs));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PHttpTransaction::Msg_OnTransportStatus__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PHttpTransaction", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PHttpTransactionParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PHttpTransaction::Msg_OnTransportStatus", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__status = IPC::ReadParam<nsresult>((&(reader__)));
            if (!maybe__status) {
                FatalError("Error deserializing 'nsresult'");
                return MsgValueError;

            }
            auto& status = *maybe__status;
            // Sentinel = 'status'
            if ((!(((&(reader__)))->ReadSentinel(154731173)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'nsresult'");
                return MsgValueError;
            }
            auto maybe__progress = IPC::ReadParam<int64_t>((&(reader__)));
            if (!maybe__progress) {
                FatalError("Error deserializing 'int64_t'");
                return MsgValueError;

            }
            auto& progress = *maybe__progress;
            // Sentinel = 'progress'
            if ((!(((&(reader__)))->ReadSentinel(261292918)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'int64_t'");
                return MsgValueError;
            }
            auto maybe__progressMax = IPC::ReadParam<int64_t>((&(reader__)));
            if (!maybe__progressMax) {
                FatalError("Error deserializing 'int64_t'");
                return MsgValueError;

            }
            auto& progressMax = *maybe__progressMax;
            // Sentinel = 'progressMax'
            if ((!(((&(reader__)))->ReadSentinel(471205020)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'int64_t'");
                return MsgValueError;
            }
            auto maybe__networkAddressArg = IPC::ReadParam<mozilla::Maybe<NetworkAddressArg>>((&(reader__)));
            if (!maybe__networkAddressArg) {
                FatalError("Error deserializing 'NetworkAddressArg?'");
                return MsgValueError;

            }
            auto& networkAddressArg = *maybe__networkAddressArg;
            // Sentinel = 'networkAddressArg'
            if ((!(((&(reader__)))->ReadSentinel(1062471403)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'NetworkAddressArg?'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::IPCResult __ok = (static_cast<HttpTransactionParent*>(this))->RecvOnTransportStatus(std::move(status), std::move(progress), std::move(progressMax), std::move(networkAddressArg));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PHttpTransaction::Msg_OnDataAvailable__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PHttpTransaction", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PHttpTransactionParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PHttpTransaction::Msg_OnDataAvailable", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__data = IPC::ReadParam<nsCString>((&(reader__)));
            if (!maybe__data) {
                FatalError("Error deserializing 'nsCString'");
                return MsgValueError;

            }
            auto& data = *maybe__data;
            // Sentinel = 'data'
            if ((!(((&(reader__)))->ReadSentinel(67109275)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'nsCString'");
                return MsgValueError;
            }
            auto maybe__offset = IPC::ReadParam<uint64_t>((&(reader__)));
            if (!maybe__offset) {
                FatalError("Error deserializing 'uint64_t'");
                return MsgValueError;

            }
            auto& offset = *maybe__offset;
            // Sentinel = 'offset'
            if ((!(((&(reader__)))->ReadSentinel(147653256)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'uint64_t'");
                return MsgValueError;
            }
            auto maybe__count = IPC::ReadParam<uint32_t>((&(reader__)));
            if (!maybe__count) {
                FatalError("Error deserializing 'uint32_t'");
                return MsgValueError;

            }
            auto& count = *maybe__count;
            // Sentinel = 'count'
            if ((!(((&(reader__)))->ReadSentinel(106889770)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'uint32_t'");
                return MsgValueError;
            }
            auto maybe__onDataAvailableStart = IPC::ReadParam<TimeStamp>((&(reader__)));
            if (!maybe__onDataAvailableStart) {
                FatalError("Error deserializing 'TimeStamp'");
                return MsgValueError;

            }
            auto& onDataAvailableStart = *maybe__onDataAvailableStart;
            // Sentinel = 'onDataAvailableStart'
            if ((!(((&(reader__)))->ReadSentinel(1369049063)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'TimeStamp'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::IPCResult __ok = (static_cast<HttpTransactionParent*>(this))->RecvOnDataAvailable(std::move(data), std::move(offset), std::move(count), std::move(onDataAvailableStart));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PHttpTransaction::Msg_OnStopRequest__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PHttpTransaction", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PHttpTransactionParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PHttpTransaction::Msg_OnStopRequest", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__status = IPC::ReadParam<nsresult>((&(reader__)));
            if (!maybe__status) {
                FatalError("Error deserializing 'nsresult'");
                return MsgValueError;

            }
            auto& status = *maybe__status;
            // Sentinel = 'status'
            if ((!(((&(reader__)))->ReadSentinel(154731173)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'nsresult'");
                return MsgValueError;
            }
            auto maybe__responseIsComplete = IPC::ReadParam<bool>((&(reader__)));
            if (!maybe__responseIsComplete) {
                FatalError("Error deserializing 'bool'");
                return MsgValueError;

            }
            auto& responseIsComplete = *maybe__responseIsComplete;
            // Sentinel = 'responseIsComplete'
            if ((!(((&(reader__)))->ReadSentinel(1188956005)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'bool'");
                return MsgValueError;
            }
            auto maybe__transferSize = IPC::ReadParam<int64_t>((&(reader__)));
            if (!maybe__transferSize) {
                FatalError("Error deserializing 'int64_t'");
                return MsgValueError;

            }
            auto& transferSize = *maybe__transferSize;
            // Sentinel = 'transferSize'
            if ((!(((&(reader__)))->ReadSentinel(551814401)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'int64_t'");
                return MsgValueError;
            }
            auto maybe__timings = IPC::ReadParam<TimingStructArgs>((&(reader__)));
            if (!maybe__timings) {
                FatalError("Error deserializing 'TimingStructArgs'");
                return MsgValueError;

            }
            auto& timings = *maybe__timings;
            // Sentinel = 'timings'
            if ((!(((&(reader__)))->ReadSentinel(200868604)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'TimingStructArgs'");
                return MsgValueError;
            }
            auto maybe__responseTrailers = IPC::ReadParam<mozilla::Maybe<nsHttpHeaderArray>>((&(reader__)));
            if (!maybe__responseTrailers) {
                FatalError("Error deserializing 'nsHttpHeaderArray?'");
                return MsgValueError;

            }
            auto& responseTrailers = *maybe__responseTrailers;
            // Sentinel = 'responseTrailers'
            if ((!(((&(reader__)))->ReadSentinel(961873590)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'nsHttpHeaderArray?'");
                return MsgValueError;
            }
            auto maybe__transactionObserverResult = IPC::ReadParam<mozilla::Maybe<TransactionObserverResult>>((&(reader__)));
            if (!maybe__transactionObserverResult) {
                FatalError("Error deserializing 'TransactionObserverResult?'");
                return MsgValueError;

            }
            auto& transactionObserverResult = *maybe__transactionObserverResult;
            // Sentinel = 'transactionObserverResult'
            if ((!(((&(reader__)))->ReadSentinel(2271873646)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'TransactionObserverResult?'");
                return MsgValueError;
            }
            auto maybe__lastActiveTabOptimization = IPC::ReadParam<TimeStamp>((&(reader__)));
            if (!maybe__lastActiveTabOptimization) {
                FatalError("Error deserializing 'TimeStamp'");
                return MsgValueError;

            }
            auto& lastActiveTabOptimization = *maybe__lastActiveTabOptimization;
            // Sentinel = 'lastActiveTabOptimization'
            if ((!(((&(reader__)))->ReadSentinel(2190412335)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'TimeStamp'");
                return MsgValueError;
            }
            auto maybe__onStopRequestStart = IPC::ReadParam<TimeStamp>((&(reader__)));
            if (!maybe__onStopRequestStart) {
                FatalError("Error deserializing 'TimeStamp'");
                return MsgValueError;

            }
            auto& onStopRequestStart = *maybe__onStopRequestStart;
            // Sentinel = 'onStopRequestStart'
            if ((!(((&(reader__)))->ReadSentinel(1183909755)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'TimeStamp'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::IPCResult __ok = (static_cast<HttpTransactionParent*>(this))->RecvOnStopRequest(std::move(status), std::move(responseIsComplete), std::move(transferSize), std::move(timings), std::move(responseTrailers), std::move(transactionObserverResult), std::move(lastActiveTabOptimization), std::move(onStopRequestStart));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PHttpTransaction::Msg_OnInitFailed__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PHttpTransaction", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PHttpTransactionParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PHttpTransaction::Msg_OnInitFailed", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__status = IPC::ReadParam<nsresult>((&(reader__)));
            if (!maybe__status) {
                FatalError("Error deserializing 'nsresult'");
                return MsgValueError;

            }
            auto& status = *maybe__status;
            // Sentinel = 'status'
            if ((!(((&(reader__)))->ReadSentinel(154731173)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'nsresult'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::IPCResult __ok = (static_cast<HttpTransactionParent*>(this))->RecvOnInitFailed(std::move(status));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PHttpTransaction::Msg_OnH2PushStream__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PHttpTransaction", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PHttpTransactionParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PHttpTransaction::Msg_OnH2PushStream", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__pushedStreamId = IPC::ReadParam<uint32_t>((&(reader__)));
            if (!maybe__pushedStreamId) {
                FatalError("Error deserializing 'uint32_t'");
                return MsgValueError;

            }
            auto& pushedStreamId = *maybe__pushedStreamId;
            // Sentinel = 'pushedStreamId'
            if ((!(((&(reader__)))->ReadSentinel(731579811)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'uint32_t'");
                return MsgValueError;
            }
            auto maybe__resourceUrl = IPC::ReadParam<nsCString>((&(reader__)));
            if (!maybe__resourceUrl) {
                FatalError("Error deserializing 'nsCString'");
                return MsgValueError;

            }
            auto& resourceUrl = *maybe__resourceUrl;
            // Sentinel = 'resourceUrl'
            if ((!(((&(reader__)))->ReadSentinel(471270556)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'nsCString'");
                return MsgValueError;
            }
            auto maybe__requestString = IPC::ReadParam<nsCString>((&(reader__)));
            if (!maybe__requestString) {
                FatalError("Error deserializing 'nsCString'");
                return MsgValueError;

            }
            auto& requestString = *maybe__requestString;
            // Sentinel = 'requestString'
            if ((!(((&(reader__)))->ReadSentinel(650970497)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'nsCString'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::IPCResult __ok = (static_cast<HttpTransactionParent*>(this))->RecvOnH2PushStream(std::move(pushedStreamId), std::move(resourceUrl), std::move(requestString));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PHttpTransaction::Msg_EarlyHint__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PHttpTransaction", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PHttpTransactionParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PHttpTransaction::Msg_EarlyHint", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__linkHeader = IPC::ReadParam<nsCString>((&(reader__)));
            if (!maybe__linkHeader) {
                FatalError("Error deserializing 'nsCString'");
                return MsgValueError;

            }
            auto& linkHeader = *maybe__linkHeader;
            // Sentinel = 'linkHeader'
            if ((!(((&(reader__)))->ReadSentinel(367330296)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'nsCString'");
                return MsgValueError;
            }
            auto maybe__referrerPolicy = IPC::ReadParam<nsCString>((&(reader__)));
            if (!maybe__referrerPolicy) {
                FatalError("Error deserializing 'nsCString'");
                return MsgValueError;

            }
            auto& referrerPolicy = *maybe__referrerPolicy;
            // Sentinel = 'referrerPolicy'
            if ((!(((&(reader__)))->ReadSentinel(729482702)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'nsCString'");
                return MsgValueError;
            }
            auto maybe__cspHeader = IPC::ReadParam<nsCString>((&(reader__)));
            if (!maybe__cspHeader) {
                FatalError("Error deserializing 'nsCString'");
                return MsgValueError;

            }
            auto& cspHeader = *maybe__cspHeader;
            // Sentinel = 'cspHeader'
            if ((!(((&(reader__)))->ReadSentinel(297862032)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'nsCString'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::IPCResult __ok = (static_cast<HttpTransactionParent*>(this))->RecvEarlyHint(std::move(linkHeader), std::move(referrerPolicy), std::move(cspHeader));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PHttpTransaction::Reply___delete____ID:
        {
            return MsgProcessed;
        }
    default:
        return MsgNotKnown;
    }
}

auto PHttpTransactionParent::OnMessageReceived(
        const Message& msg__,
        UniquePtr<Message>& reply__) -> PHttpTransactionParent::Result
{
    return MsgNotKnown;
}



} // namespace net
} // namespace mozilla
namespace IPC {
auto ParamTraits<::mozilla::net::PHttpTransactionParent*>::Write(
        IPC::MessageWriter* aWriter,
        const paramType& aVar) -> void
{
    MOZ_RELEASE_ASSERT(
        aWriter->GetActor(),
        "Cannot serialize managed actors without an actor");

    int32_t id;
    if (!aVar) {
        id = 0;  // kNullActorId
    } else {
        id = aVar->Id();
        if (id == 1) {  // kFreedActorId
            aVar->FatalError("Actor has been |delete|d");
        }
        MOZ_RELEASE_ASSERT(
            aWriter->GetActor()->GetIPCChannel() == aVar->GetIPCChannel(),
            "Actor must be from the same channel as the"
            " actor it's being sent over");
        MOZ_RELEASE_ASSERT(
            aVar->CanSend(),
            "Actor must still be open when sending");
    }

    IPC::WriteParam(aWriter, id);
}

auto ParamTraits<::mozilla::net::PHttpTransactionParent*>::Read(IPC::MessageReader* aReader) -> IPC::ReadResult<paramType>
{
    MOZ_RELEASE_ASSERT(
        aReader->GetActor(),
        "Cannot deserialize managed actors without an actor");
    mozilla::Maybe<mozilla::ipc::IProtocol*> actor = aReader->GetActor()
        ->ReadActor(aReader, true, "PHttpTransaction", PHttpTransactionMsgStart);
    if (actor.isSome()) {
        return static_cast<::mozilla::net::PHttpTransactionParent*>(actor.ref());
    }
    return {};
}

} // namespace IPC
