//
// Automatically generated by ipdlc.
// Edit at your own risk
//


#include "mozilla/dom/PHandlerServiceParent.h"
#include "mozilla/ProfilerLabels.h"

#include "mozilla/dom/PContentParent.h"

#include "ipc/IPCMessageUtils.h"
#include "ipc/IPCMessageUtilsSpecializations.h"
#include "nsIFile.h"
#include "mozilla/ipc/Endpoint.h"
#include "mozilla/ipc/ProtocolMessageUtils.h"
#include "mozilla/ipc/ProtocolUtils.h"
#include "mozilla/ipc/ShmemMessageUtils.h"
#include "mozilla/ipc/TaintingIPCUtils.h"

namespace mozilla {
namespace dom {


auto PHandlerServiceParent::Recv__delete__() -> mozilla::ipc::IPCResult
{
    return IPC_OK();
}

MOZ_IMPLICIT PHandlerServiceParent::PHandlerServiceParent() :
    mozilla::ipc::IRefCountedProtocol(kProtocolId, mozilla::ipc::ParentSide)
{
    MOZ_COUNT_CTOR(PHandlerServiceParent);
}

PHandlerServiceParent::~PHandlerServiceParent()
{
    MOZ_COUNT_DTOR(PHandlerServiceParent);
}

auto PHandlerServiceParent::ActorAlloc() -> void
{
    AddRef();
}

auto PHandlerServiceParent::ActorDealloc() -> void
{
    Release();
}

auto PHandlerServiceParent::OtherPid() const -> ::base::ProcessId
{
    ::base::ProcessId pid =
        ::mozilla::ipc::IProtocol::ToplevelProtocol()->OtherPidMaybeInvalid();
    MOZ_RELEASE_ASSERT(pid != ::base::kInvalidProcessId);
    return pid;
}

auto PHandlerServiceParent::OtherChildID() const -> ::GeckoChildID
{
    ::GeckoChildID childID =
        ::mozilla::ipc::IProtocol::ToplevelProtocol()->OtherChildIDMaybeInvalid();
    MOZ_RELEASE_ASSERT(childID != -1);
    return childID;
}

auto PHandlerServiceParent::OtherEndpointProcInfo() const -> ::mozilla::ipc::EndpointProcInfo
{
    return ::mozilla::ipc::EndpointProcInfo{OtherPid(), OtherChildID()};
}

auto PHandlerServiceParent::Manager() const -> PContentParent*
{
    return static_cast<PContentParent*>(IProtocol::Manager());
}

auto PHandlerServiceParent::ManagedProtocolIds() const -> mozilla::Span<mozilla::ipc::ProtocolId const>
{
    return {};
}

auto PHandlerServiceParent::GetManagedActors(mozilla::ipc::ProtocolId aProtocol) -> UntypedManagedContainer*
{
    switch (aProtocol) {
    default:
        return nullptr;
    }
}

auto PHandlerServiceParent::DeallocManagee(
        int32_t aProtocolId,
        IProtocol* aListener) -> void
{
    FatalError("unreached");
    return;
}

auto PHandlerServiceParent::OnMessageReceived(const Message& msg__) -> PHandlerServiceParent::Result
{
    switch (msg__.type()) {
    case MANAGED_ENDPOINT_BOUND_MESSAGE_TYPE:
        {
            if (!mAwaitingManagedEndpointBind) {
                NS_WARNING("Unexpected managed endpoint lifecycle message after actor bound!");
                return MsgNotAllowed;
            }
            mAwaitingManagedEndpointBind = false;
            return MsgProcessed;
        }
    case MANAGED_ENDPOINT_DROPPED_MESSAGE_TYPE:
        {
            if (!mAwaitingManagedEndpointBind) {
                NS_WARNING("Unexpected managed endpoint lifecycle message after actor bound!");
                return MsgNotAllowed;
            }
            mAwaitingManagedEndpointBind = false;
            this->ActorDisconnected(ManagedEndpointDropped);
            return MsgProcessed;
        }
    case PHandlerService::Msg___delete____ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PHandlerService", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PHandlerServiceParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PHandlerService::Msg___delete__", OTHER);

            mozilla::ipc::IPCResult __ok = (this)->Recv__delete__();
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }


            this->ActorDisconnected(Deletion);

            return MsgProcessed;
        }
    default:
        return MsgNotKnown;
    }
}

auto PHandlerServiceParent::OnMessageReceived(
        const Message& msg__,
        UniquePtr<Message>& reply__) -> PHandlerServiceParent::Result
{
    switch (msg__.type()) {
    case PHandlerService::Msg_FillHandlerInfo__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PHandlerService", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PHandlerServiceParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PHandlerService::Msg_FillHandlerInfo", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__aHandlerInfoData = IPC::ReadParam<HandlerInfo>((&(reader__)));
            if (!maybe__aHandlerInfoData) {
                FatalError("Error deserializing 'HandlerInfo'");
                return MsgValueError;

            }
            auto& aHandlerInfoData = *maybe__aHandlerInfoData;
            // Sentinel = 'aHandlerInfoData'
            if ((!(((&(reader__)))->ReadSentinel(869860902)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'HandlerInfo'");
                return MsgValueError;
            }
            auto maybe__aOverrideType = IPC::ReadParam<nsCString>((&(reader__)));
            if (!maybe__aOverrideType) {
                FatalError("Error deserializing 'nsCString'");
                return MsgValueError;

            }
            auto& aOverrideType = *maybe__aOverrideType;
            // Sentinel = 'aOverrideType'
            if ((!(((&(reader__)))->ReadSentinel(611583300)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'nsCString'");
                return MsgValueError;
            }
            reader__.EndRead();
            int32_t id__ = Id();
            HandlerInfo handlerInfoData{};
            mozilla::ipc::IPCResult __ok = (this)->RecvFillHandlerInfo(std::move(aHandlerInfoData), std::move(aOverrideType), (&(handlerInfoData)));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            reply__ = PHandlerService::Reply_FillHandlerInfo(id__);
            IPC::MessageWriter writer__{
                    (*(reply__)),
                    this};

            IPC::WriteParam((&(writer__)), handlerInfoData);
            // Sentinel = 'handlerInfoData'
            ((&(writer__)))->WriteSentinel(799540709);

            if (mozilla::ipc::LoggingEnabledFor("PHandlerService", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PHandlerServiceParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Sending reply ",
                    reply__->type(),
                    mozilla::ipc::MessageDirection::eSending);
            }
            return MsgProcessed;
        }
    case PHandlerService::Msg_ExistsForProtocolOS__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PHandlerService", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PHandlerServiceParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PHandlerService::Msg_ExistsForProtocolOS", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__aProtocolScheme = IPC::ReadParam<nsCString>((&(reader__)));
            if (!maybe__aProtocolScheme) {
                FatalError("Error deserializing 'nsCString'");
                return MsgValueError;

            }
            auto& aProtocolScheme = *maybe__aProtocolScheme;
            // Sentinel = 'aProtocolScheme'
            if ((!(((&(reader__)))->ReadSentinel(809764361)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'nsCString'");
                return MsgValueError;
            }
            reader__.EndRead();
            int32_t id__ = Id();
            bool exists{};
            mozilla::ipc::IPCResult __ok = (this)->RecvExistsForProtocolOS(std::move(aProtocolScheme), (&(exists)));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            reply__ = PHandlerService::Reply_ExistsForProtocolOS(id__);
            IPC::MessageWriter writer__{
                    (*(reply__)),
                    this};

            IPC::WriteParam((&(writer__)), exists);
            // Sentinel = 'exists'
            ((&(writer__)))->WriteSentinel(152306337);

            if (mozilla::ipc::LoggingEnabledFor("PHandlerService", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PHandlerServiceParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Sending reply ",
                    reply__->type(),
                    mozilla::ipc::MessageDirection::eSending);
            }
            return MsgProcessed;
        }
    case PHandlerService::Msg_ExistsForProtocol__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PHandlerService", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PHandlerServiceParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PHandlerService::Msg_ExistsForProtocol", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__aProtocolScheme = IPC::ReadParam<nsCString>((&(reader__)));
            if (!maybe__aProtocolScheme) {
                FatalError("Error deserializing 'nsCString'");
                return MsgValueError;

            }
            auto& aProtocolScheme = *maybe__aProtocolScheme;
            // Sentinel = 'aProtocolScheme'
            if ((!(((&(reader__)))->ReadSentinel(809764361)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'nsCString'");
                return MsgValueError;
            }
            reader__.EndRead();
            int32_t id__ = Id();
            bool exists{};
            mozilla::ipc::IPCResult __ok = (this)->RecvExistsForProtocol(std::move(aProtocolScheme), (&(exists)));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            reply__ = PHandlerService::Reply_ExistsForProtocol(id__);
            IPC::MessageWriter writer__{
                    (*(reply__)),
                    this};

            IPC::WriteParam((&(writer__)), exists);
            // Sentinel = 'exists'
            ((&(writer__)))->WriteSentinel(152306337);

            if (mozilla::ipc::LoggingEnabledFor("PHandlerService", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PHandlerServiceParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Sending reply ",
                    reply__->type(),
                    mozilla::ipc::MessageDirection::eSending);
            }
            return MsgProcessed;
        }
    case PHandlerService::Msg_Exists__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PHandlerService", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PHandlerServiceParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PHandlerService::Msg_Exists", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__aHandlerInfo = IPC::ReadParam<HandlerInfo>((&(reader__)));
            if (!maybe__aHandlerInfo) {
                FatalError("Error deserializing 'HandlerInfo'");
                return MsgValueError;

            }
            auto& aHandlerInfo = *maybe__aHandlerInfo;
            // Sentinel = 'aHandlerInfo'
            if ((!(((&(reader__)))->ReadSentinel(497878188)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'HandlerInfo'");
                return MsgValueError;
            }
            reader__.EndRead();
            int32_t id__ = Id();
            bool exists{};
            mozilla::ipc::IPCResult __ok = (this)->RecvExists(std::move(aHandlerInfo), (&(exists)));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            reply__ = PHandlerService::Reply_Exists(id__);
            IPC::MessageWriter writer__{
                    (*(reply__)),
                    this};

            IPC::WriteParam((&(writer__)), exists);
            // Sentinel = 'exists'
            ((&(writer__)))->WriteSentinel(152306337);

            if (mozilla::ipc::LoggingEnabledFor("PHandlerService", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PHandlerServiceParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Sending reply ",
                    reply__->type(),
                    mozilla::ipc::MessageDirection::eSending);
            }
            return MsgProcessed;
        }
    case PHandlerService::Msg_GetTypeFromExtension__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PHandlerService", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PHandlerServiceParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PHandlerService::Msg_GetTypeFromExtension", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__aFileExtension = IPC::ReadParam<nsCString>((&(reader__)));
            if (!maybe__aFileExtension) {
                FatalError("Error deserializing 'nsCString'");
                return MsgValueError;

            }
            auto& aFileExtension = *maybe__aFileExtension;
            // Sentinel = 'aFileExtension'
            if ((!(((&(reader__)))->ReadSentinel(681313695)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'nsCString'");
                return MsgValueError;
            }
            reader__.EndRead();
            int32_t id__ = Id();
            nsCString type{};
            mozilla::ipc::IPCResult __ok = (this)->RecvGetTypeFromExtension(std::move(aFileExtension), (&(type)));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            reply__ = PHandlerService::Reply_GetTypeFromExtension(id__);
            IPC::MessageWriter writer__{
                    (*(reply__)),
                    this};

            IPC::WriteParam((&(writer__)), type);
            // Sentinel = 'type'
            ((&(writer__)))->WriteSentinel(75760067);

            if (mozilla::ipc::LoggingEnabledFor("PHandlerService", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PHandlerServiceParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Sending reply ",
                    reply__->type(),
                    mozilla::ipc::MessageDirection::eSending);
            }
            return MsgProcessed;
        }
    case PHandlerService::Msg_GetMIMEInfoFromOS__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PHandlerService", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PHandlerServiceParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PHandlerService::Msg_GetMIMEInfoFromOS", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__aMIMEType = IPC::ReadParam<nsCString>((&(reader__)));
            if (!maybe__aMIMEType) {
                FatalError("Error deserializing 'nsCString'");
                return MsgValueError;

            }
            auto& aMIMEType = *maybe__aMIMEType;
            // Sentinel = 'aMIMEType'
            if ((!(((&(reader__)))->ReadSentinel(251659052)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'nsCString'");
                return MsgValueError;
            }
            auto maybe__aExtension = IPC::ReadParam<nsCString>((&(reader__)));
            if (!maybe__aExtension) {
                FatalError("Error deserializing 'nsCString'");
                return MsgValueError;

            }
            auto& aExtension = *maybe__aExtension;
            // Sentinel = 'aExtension'
            if ((!(((&(reader__)))->ReadSentinel(369361951)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'nsCString'");
                return MsgValueError;
            }
            reader__.EndRead();
            int32_t id__ = Id();
            nsresult rv{};
            HandlerInfo handlerInfoData{};
            bool found{};
            mozilla::ipc::IPCResult __ok = (this)->RecvGetMIMEInfoFromOS(std::move(aMIMEType), std::move(aExtension), (&(rv)), (&(handlerInfoData)), (&(found)));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            reply__ = PHandlerService::Reply_GetMIMEInfoFromOS(id__);
            IPC::MessageWriter writer__{
                    (*(reply__)),
                    this};

            IPC::WriteParam((&(writer__)), rv);
            // Sentinel = 'rv'
            ((&(writer__)))->WriteSentinel(22806761);
            IPC::WriteParam((&(writer__)), handlerInfoData);
            // Sentinel = 'handlerInfoData'
            ((&(writer__)))->WriteSentinel(799540709);
            IPC::WriteParam((&(writer__)), found);
            // Sentinel = 'found'
            ((&(writer__)))->WriteSentinel(106824221);

            if (mozilla::ipc::LoggingEnabledFor("PHandlerService", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PHandlerServiceParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Sending reply ",
                    reply__->type(),
                    mozilla::ipc::MessageDirection::eSending);
            }
            return MsgProcessed;
        }
    case PHandlerService::Msg_GetApplicationDescription__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PHandlerService", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PHandlerServiceParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PHandlerService::Msg_GetApplicationDescription", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__aScheme = IPC::ReadParam<nsCString>((&(reader__)));
            if (!maybe__aScheme) {
                FatalError("Error deserializing 'nsCString'");
                return MsgValueError;

            }
            auto& aScheme = *maybe__aScheme;
            // Sentinel = 'aScheme'
            if ((!(((&(reader__)))->ReadSentinel(178062007)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'nsCString'");
                return MsgValueError;
            }
            reader__.EndRead();
            int32_t id__ = Id();
            nsresult rv{};
            nsString description{};
            mozilla::ipc::IPCResult __ok = (this)->RecvGetApplicationDescription(std::move(aScheme), (&(rv)), (&(description)));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            reply__ = PHandlerService::Reply_GetApplicationDescription(id__);
            IPC::MessageWriter writer__{
                    (*(reply__)),
                    this};

            IPC::WriteParam((&(writer__)), rv);
            // Sentinel = 'rv'
            ((&(writer__)))->WriteSentinel(22806761);
            IPC::WriteParam((&(writer__)), description);
            // Sentinel = 'description'
            ((&(writer__)))->WriteSentinel(461833381);

            if (mozilla::ipc::LoggingEnabledFor("PHandlerService", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PHandlerServiceParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Sending reply ",
                    reply__->type(),
                    mozilla::ipc::MessageDirection::eSending);
            }
            return MsgProcessed;
        }
    default:
        return MsgNotKnown;
    }
}



} // namespace dom
} // namespace mozilla
namespace IPC {
auto ParamTraits<::mozilla::dom::PHandlerServiceParent*>::Write(
        IPC::MessageWriter* aWriter,
        const paramType& aVar) -> void
{
    MOZ_RELEASE_ASSERT(
        aWriter->GetActor(),
        "Cannot serialize managed actors without an actor");

    int32_t id;
    if (!aVar) {
        id = 0;  // kNullActorId
    } else {
        id = aVar->Id();
        if (id == 1) {  // kFreedActorId
            aVar->FatalError("Actor has been |delete|d");
        }
        MOZ_RELEASE_ASSERT(
            aWriter->GetActor()->GetIPCChannel() == aVar->GetIPCChannel(),
            "Actor must be from the same channel as the"
            " actor it's being sent over");
        MOZ_RELEASE_ASSERT(
            aVar->CanSend(),
            "Actor must still be open when sending");
    }

    IPC::WriteParam(aWriter, id);
}

auto ParamTraits<::mozilla::dom::PHandlerServiceParent*>::Read(IPC::MessageReader* aReader) -> IPC::ReadResult<paramType>
{
    MOZ_RELEASE_ASSERT(
        aReader->GetActor(),
        "Cannot deserialize managed actors without an actor");
    mozilla::Maybe<mozilla::ipc::IProtocol*> actor = aReader->GetActor()
        ->ReadActor(aReader, true, "PHandlerService", PHandlerServiceMsgStart);
    if (actor.isSome()) {
        return static_cast<::mozilla::dom::PHandlerServiceParent*>(actor.ref());
    }
    return {};
}

} // namespace IPC
