//
// Automatically generated by ipdlc.
// Edit at your own risk
//


#include "mozilla/dom/PGamepadTestChannelParent.h"
#include "mozilla/ProfilerLabels.h"
#include "mozilla/dom/GamepadMessageUtils.h"
#include "mozilla/dom/GamepadTestChannelParent.h"

#include "mozilla/ipc/PBackgroundParent.h"

#include "ipc/IPCMessageUtils.h"
#include "ipc/IPCMessageUtilsSpecializations.h"
#include "nsIFile.h"
#include "mozilla/ipc/Endpoint.h"
#include "mozilla/ipc/ProtocolMessageUtils.h"
#include "mozilla/ipc/ProtocolUtils.h"
#include "mozilla/ipc/ShmemMessageUtils.h"
#include "mozilla/ipc/TaintingIPCUtils.h"

namespace mozilla {
namespace dom {


auto PGamepadTestChannelParent::Recv__delete__() -> mozilla::ipc::IPCResult
{
    return IPC_OK();
}

MOZ_IMPLICIT PGamepadTestChannelParent::PGamepadTestChannelParent() :
    mozilla::ipc::IRefCountedProtocol(kProtocolId, mozilla::ipc::ParentSide)
{
    MOZ_COUNT_CTOR(PGamepadTestChannelParent);
}

PGamepadTestChannelParent::~PGamepadTestChannelParent()
{
    MOZ_COUNT_DTOR(PGamepadTestChannelParent);
}

auto PGamepadTestChannelParent::ActorAlloc() -> void
{
    AddRef();
}

auto PGamepadTestChannelParent::ActorDealloc() -> void
{
    Release();
}

auto PGamepadTestChannelParent::OtherPid() const -> ::base::ProcessId
{
    ::base::ProcessId pid =
        ::mozilla::ipc::IProtocol::ToplevelProtocol()->OtherPidMaybeInvalid();
    MOZ_RELEASE_ASSERT(pid != ::base::kInvalidProcessId);
    return pid;
}

auto PGamepadTestChannelParent::OtherChildID() const -> ::GeckoChildID
{
    ::GeckoChildID childID =
        ::mozilla::ipc::IProtocol::ToplevelProtocol()->OtherChildIDMaybeInvalid();
    MOZ_RELEASE_ASSERT(childID != -1);
    return childID;
}

auto PGamepadTestChannelParent::OtherEndpointProcInfo() const -> ::mozilla::ipc::EndpointProcInfo
{
    return ::mozilla::ipc::EndpointProcInfo{OtherPid(), OtherChildID()};
}

auto PGamepadTestChannelParent::Manager() const -> PBackgroundParent*
{
    return static_cast<PBackgroundParent*>(IProtocol::Manager());
}

auto PGamepadTestChannelParent::ManagedProtocolIds() const -> mozilla::Span<mozilla::ipc::ProtocolId const>
{
    return {};
}

auto PGamepadTestChannelParent::GetManagedActors(mozilla::ipc::ProtocolId aProtocol) -> UntypedManagedContainer*
{
    switch (aProtocol) {
    default:
        return nullptr;
    }
}

auto PGamepadTestChannelParent::SendReplyGamepadHandle(
        const uint32_t& aID,
        const GamepadHandle& aHandle) -> bool
{
    UniquePtr<IPC::Message> msg__ = PGamepadTestChannel::Msg_ReplyGamepadHandle(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), aID);
    // Sentinel = 'aID'
    ((&(writer__)))->WriteSentinel(33292527);
    IPC::WriteParam((&(writer__)), aHandle);
    // Sentinel = 'aHandle'
    ((&(writer__)))->WriteSentinel(174326446);




    if (mozilla::ipc::LoggingEnabledFor("PGamepadTestChannel", mozilla::ipc::ParentSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PGamepadTestChannelParent",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PGamepadTestChannel::Msg_ReplyGamepadHandle", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PGamepadTestChannelParent::DeallocManagee(
        int32_t aProtocolId,
        IProtocol* aListener) -> void
{
    FatalError("unreached");
    return;
}

auto PGamepadTestChannelParent::OnMessageReceived(const Message& msg__) -> PGamepadTestChannelParent::Result
{
    switch (msg__.type()) {
    case MANAGED_ENDPOINT_BOUND_MESSAGE_TYPE:
        {
            if (!mAwaitingManagedEndpointBind) {
                NS_WARNING("Unexpected managed endpoint lifecycle message after actor bound!");
                return MsgNotAllowed;
            }
            mAwaitingManagedEndpointBind = false;
            return MsgProcessed;
        }
    case MANAGED_ENDPOINT_DROPPED_MESSAGE_TYPE:
        {
            if (!mAwaitingManagedEndpointBind) {
                NS_WARNING("Unexpected managed endpoint lifecycle message after actor bound!");
                return MsgNotAllowed;
            }
            mAwaitingManagedEndpointBind = false;
            this->ActorDisconnected(ManagedEndpointDropped);
            return MsgProcessed;
        }
    case PGamepadTestChannel::Msg_GamepadTestEvent__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PGamepadTestChannel", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PGamepadTestChannelParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PGamepadTestChannel::Msg_GamepadTestEvent", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__aID = IPC::ReadParam<uint32_t>((&(reader__)));
            if (!maybe__aID) {
                FatalError("Error deserializing 'uint32_t'");
                return MsgValueError;

            }
            auto& aID = *maybe__aID;
            // Sentinel = 'aID'
            if ((!(((&(reader__)))->ReadSentinel(33292527)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'uint32_t'");
                return MsgValueError;
            }
            auto maybe__aGamepadEvent = IPC::ReadParam<GamepadChangeEvent>((&(reader__)));
            if (!maybe__aGamepadEvent) {
                FatalError("Error deserializing 'GamepadChangeEvent'");
                return MsgValueError;

            }
            auto& aGamepadEvent = *maybe__aGamepadEvent;
            // Sentinel = 'aGamepadEvent'
            if ((!(((&(reader__)))->ReadSentinel(578225427)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'GamepadChangeEvent'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::IPCResult __ok = (static_cast<GamepadTestChannelParent*>(this))->RecvGamepadTestEvent(std::move(aID), std::move(aGamepadEvent));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PGamepadTestChannel::Msg___delete____ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PGamepadTestChannel", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PGamepadTestChannelParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PGamepadTestChannel::Msg___delete__", OTHER);

            mozilla::ipc::IPCResult __ok = (static_cast<GamepadTestChannelParent*>(this))->Recv__delete__();
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }


            this->ActorDisconnected(Deletion);

            return MsgProcessed;
        }
    default:
        return MsgNotKnown;
    }
}

auto PGamepadTestChannelParent::OnMessageReceived(
        const Message& msg__,
        UniquePtr<Message>& reply__) -> PGamepadTestChannelParent::Result
{
    return MsgNotKnown;
}



} // namespace dom
} // namespace mozilla
namespace IPC {
auto ParamTraits<::mozilla::dom::PGamepadTestChannelParent*>::Write(
        IPC::MessageWriter* aWriter,
        const paramType& aVar) -> void
{
    MOZ_RELEASE_ASSERT(
        aWriter->GetActor(),
        "Cannot serialize managed actors without an actor");

    int32_t id;
    if (!aVar) {
        id = 0;  // kNullActorId
    } else {
        id = aVar->Id();
        if (id == 1) {  // kFreedActorId
            aVar->FatalError("Actor has been |delete|d");
        }
        MOZ_RELEASE_ASSERT(
            aWriter->GetActor()->GetIPCChannel() == aVar->GetIPCChannel(),
            "Actor must be from the same channel as the"
            " actor it's being sent over");
        MOZ_RELEASE_ASSERT(
            aVar->CanSend(),
            "Actor must still be open when sending");
    }

    IPC::WriteParam(aWriter, id);
}

auto ParamTraits<::mozilla::dom::PGamepadTestChannelParent*>::Read(IPC::MessageReader* aReader) -> IPC::ReadResult<paramType>
{
    MOZ_RELEASE_ASSERT(
        aReader->GetActor(),
        "Cannot deserialize managed actors without an actor");
    mozilla::Maybe<mozilla::ipc::IProtocol*> actor = aReader->GetActor()
        ->ReadActor(aReader, true, "PGamepadTestChannel", PGamepadTestChannelMsgStart);
    if (actor.isSome()) {
        return static_cast<::mozilla::dom::PGamepadTestChannelParent*>(actor.ref());
    }
    return {};
}

} // namespace IPC
