//
// Automatically generated by ipdlc.
// Edit at your own risk
//


#include "mozilla/dom/PGamepadEventChannelParent.h"
#include "mozilla/ProfilerLabels.h"
#include "mozilla/dom/GamepadEventChannelParent.h"
#include "mozilla/dom/GamepadMessageUtils.h"

#include "mozilla/ipc/PBackgroundParent.h"

#include "ipc/IPCMessageUtils.h"
#include "ipc/IPCMessageUtilsSpecializations.h"
#include "nsIFile.h"
#include "mozilla/ipc/Endpoint.h"
#include "mozilla/ipc/ProtocolMessageUtils.h"
#include "mozilla/ipc/ProtocolUtils.h"
#include "mozilla/ipc/ShmemMessageUtils.h"
#include "mozilla/ipc/TaintingIPCUtils.h"

namespace mozilla {
namespace dom {


auto PGamepadEventChannelParent::Recv__delete__() -> mozilla::ipc::IPCResult
{
    return IPC_OK();
}

MOZ_IMPLICIT PGamepadEventChannelParent::PGamepadEventChannelParent() :
    mozilla::ipc::IRefCountedProtocol(kProtocolId, mozilla::ipc::ParentSide)
{
    MOZ_COUNT_CTOR(PGamepadEventChannelParent);
}

PGamepadEventChannelParent::~PGamepadEventChannelParent()
{
    MOZ_COUNT_DTOR(PGamepadEventChannelParent);
}

auto PGamepadEventChannelParent::ActorAlloc() -> void
{
    AddRef();
}

auto PGamepadEventChannelParent::ActorDealloc() -> void
{
    Release();
}

auto PGamepadEventChannelParent::OtherPid() const -> ::base::ProcessId
{
    ::base::ProcessId pid =
        ::mozilla::ipc::IProtocol::ToplevelProtocol()->OtherPidMaybeInvalid();
    MOZ_RELEASE_ASSERT(pid != ::base::kInvalidProcessId);
    return pid;
}

auto PGamepadEventChannelParent::OtherChildID() const -> ::GeckoChildID
{
    ::GeckoChildID childID =
        ::mozilla::ipc::IProtocol::ToplevelProtocol()->OtherChildIDMaybeInvalid();
    MOZ_RELEASE_ASSERT(childID != -1);
    return childID;
}

auto PGamepadEventChannelParent::OtherEndpointProcInfo() const -> ::mozilla::ipc::EndpointProcInfo
{
    return ::mozilla::ipc::EndpointProcInfo{OtherPid(), OtherChildID()};
}

auto PGamepadEventChannelParent::Manager() const -> PBackgroundParent*
{
    return static_cast<PBackgroundParent*>(IProtocol::Manager());
}

auto PGamepadEventChannelParent::ManagedProtocolIds() const -> mozilla::Span<mozilla::ipc::ProtocolId const>
{
    return {};
}

auto PGamepadEventChannelParent::GetManagedActors(mozilla::ipc::ProtocolId aProtocol) -> UntypedManagedContainer*
{
    switch (aProtocol) {
    default:
        return nullptr;
    }
}

auto PGamepadEventChannelParent::RejectPendingResponses(ResponseRejectReason aReason) -> void
{
    mAsyncCallbacks.RejectPendingResponses(aReason);
}

auto PGamepadEventChannelParent::SendGamepadUpdate(const GamepadChangeEvent& aGamepadEvent) -> bool
{
    UniquePtr<IPC::Message> msg__ = PGamepadEventChannel::Msg_GamepadUpdate(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), aGamepadEvent);
    // Sentinel = 'aGamepadEvent'
    ((&(writer__)))->WriteSentinel(578225427);




    if (mozilla::ipc::LoggingEnabledFor("PGamepadEventChannel", mozilla::ipc::ParentSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PGamepadEventChannelParent",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PGamepadEventChannel::Msg_GamepadUpdate", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PGamepadEventChannelParent::SendReplyGamepadPromise(const uint32_t& aPromiseID) -> bool
{
    UniquePtr<IPC::Message> msg__ = PGamepadEventChannel::Msg_ReplyGamepadPromise(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), aPromiseID);
    // Sentinel = 'aPromiseID'
    ((&(writer__)))->WriteSentinel(363398094);




    if (mozilla::ipc::LoggingEnabledFor("PGamepadEventChannel", mozilla::ipc::ParentSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PGamepadEventChannelParent",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PGamepadEventChannel::Msg_ReplyGamepadPromise", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PGamepadEventChannelParent::DeallocManagee(
        int32_t aProtocolId,
        IProtocol* aListener) -> void
{
    FatalError("unreached");
    return;
}

auto PGamepadEventChannelParent::OnMessageReceived(const Message& msg__) -> PGamepadEventChannelParent::Result
{
    switch (msg__.type()) {
    case MANAGED_ENDPOINT_BOUND_MESSAGE_TYPE:
        {
            if (!mAwaitingManagedEndpointBind) {
                NS_WARNING("Unexpected managed endpoint lifecycle message after actor bound!");
                return MsgNotAllowed;
            }
            mAwaitingManagedEndpointBind = false;
            return MsgProcessed;
        }
    case MANAGED_ENDPOINT_DROPPED_MESSAGE_TYPE:
        {
            if (!mAwaitingManagedEndpointBind) {
                NS_WARNING("Unexpected managed endpoint lifecycle message after actor bound!");
                return MsgNotAllowed;
            }
            mAwaitingManagedEndpointBind = false;
            this->ActorDisconnected(ManagedEndpointDropped);
            return MsgProcessed;
        }
    case PGamepadEventChannel::Msg___delete____ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PGamepadEventChannel", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PGamepadEventChannelParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PGamepadEventChannel::Msg___delete__", OTHER);

            mozilla::ipc::IPCResult __ok = (static_cast<GamepadEventChannelParent*>(this))->Recv__delete__();
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }


            this->ActorDisconnected(Deletion);

            return MsgProcessed;
        }
    case PGamepadEventChannel::Msg_VibrateHaptic__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PGamepadEventChannel", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PGamepadEventChannelParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PGamepadEventChannel::Msg_VibrateHaptic", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__aHandle = IPC::ReadParam<Tainted<GamepadHandle>>((&(reader__)));
            if (!maybe__aHandle) {
                FatalError("Error deserializing 'GamepadHandle'");
                return MsgValueError;

            }
            auto& aHandle = *maybe__aHandle;
            // Sentinel = 'aHandle'
            if ((!(((&(reader__)))->ReadSentinel(174326446)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'GamepadHandle'");
                return MsgValueError;
            }
            auto maybe__aHapticIndex = IPC::ReadParam<Tainted<uint32_t>>((&(reader__)));
            if (!maybe__aHapticIndex) {
                FatalError("Error deserializing 'uint32_t'");
                return MsgValueError;

            }
            auto& aHapticIndex = *maybe__aHapticIndex;
            // Sentinel = 'aHapticIndex'
            if ((!(((&(reader__)))->ReadSentinel(500040883)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'uint32_t'");
                return MsgValueError;
            }
            auto maybe__aIntensity = IPC::ReadParam<Tainted<double>>((&(reader__)));
            if (!maybe__aIntensity) {
                FatalError("Error deserializing 'double'");
                return MsgValueError;

            }
            auto& aIntensity = *maybe__aIntensity;
            // Sentinel = 'aIntensity'
            if ((!(((&(reader__)))->ReadSentinel(367854633)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'double'");
                return MsgValueError;
            }
            auto maybe__aDuration = IPC::ReadParam<Tainted<double>>((&(reader__)));
            if (!maybe__aDuration) {
                FatalError("Error deserializing 'double'");
                return MsgValueError;

            }
            auto& aDuration = *maybe__aDuration;
            // Sentinel = 'aDuration'
            if ((!(((&(reader__)))->ReadSentinel(296551336)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'double'");
                return MsgValueError;
            }
            auto maybe__aPromiseID = IPC::ReadParam<uint32_t>((&(reader__)));
            if (!maybe__aPromiseID) {
                FatalError("Error deserializing 'uint32_t'");
                return MsgValueError;

            }
            auto& aPromiseID = *maybe__aPromiseID;
            // Sentinel = 'aPromiseID'
            if ((!(((&(reader__)))->ReadSentinel(363398094)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'uint32_t'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::IPCResult __ok = (static_cast<GamepadEventChannelParent*>(this))->RecvVibrateHaptic(std::move(aHandle), std::move(aHapticIndex), std::move(aIntensity), std::move(aDuration), std::move(aPromiseID));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PGamepadEventChannel::Msg_StopVibrateHaptic__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PGamepadEventChannel", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PGamepadEventChannelParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PGamepadEventChannel::Msg_StopVibrateHaptic", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__aHandle = IPC::ReadParam<Tainted<GamepadHandle>>((&(reader__)));
            if (!maybe__aHandle) {
                FatalError("Error deserializing 'GamepadHandle'");
                return MsgValueError;

            }
            auto& aHandle = *maybe__aHandle;
            // Sentinel = 'aHandle'
            if ((!(((&(reader__)))->ReadSentinel(174326446)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'GamepadHandle'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::IPCResult __ok = (static_cast<GamepadEventChannelParent*>(this))->RecvStopVibrateHaptic(std::move(aHandle));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PGamepadEventChannel::Msg_LightIndicatorColor__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PGamepadEventChannel", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PGamepadEventChannelParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PGamepadEventChannel::Msg_LightIndicatorColor", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__aHandle = IPC::ReadParam<Tainted<GamepadHandle>>((&(reader__)));
            if (!maybe__aHandle) {
                FatalError("Error deserializing 'GamepadHandle'");
                return MsgValueError;

            }
            auto& aHandle = *maybe__aHandle;
            // Sentinel = 'aHandle'
            if ((!(((&(reader__)))->ReadSentinel(174326446)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'GamepadHandle'");
                return MsgValueError;
            }
            auto maybe__aLightColorIndex = IPC::ReadParam<Tainted<uint32_t>>((&(reader__)));
            if (!maybe__aLightColorIndex) {
                FatalError("Error deserializing 'uint32_t'");
                return MsgValueError;

            }
            auto& aLightColorIndex = *maybe__aLightColorIndex;
            // Sentinel = 'aLightColorIndex'
            if ((!(((&(reader__)))->ReadSentinel(882247249)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'uint32_t'");
                return MsgValueError;
            }
            auto maybe__aRed = IPC::ReadParam<uint8_t>((&(reader__)));
            if (!maybe__aRed) {
                FatalError("Error deserializing 'uint8_t'");
                return MsgValueError;

            }
            auto& aRed = *maybe__aRed;
            // Sentinel = 'aRed'
            if ((!(((&(reader__)))->ReadSentinel(61604221)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'uint8_t'");
                return MsgValueError;
            }
            auto maybe__aGreen = IPC::ReadParam<uint8_t>((&(reader__)));
            if (!maybe__aGreen) {
                FatalError("Error deserializing 'uint8_t'");
                return MsgValueError;

            }
            auto& aGreen = *maybe__aGreen;
            // Sentinel = 'aGreen'
            if ((!(((&(reader__)))->ReadSentinel(131990099)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'uint8_t'");
                return MsgValueError;
            }
            auto maybe__aBlue = IPC::ReadParam<uint8_t>((&(reader__)));
            if (!maybe__aBlue) {
                FatalError("Error deserializing 'uint8_t'");
                return MsgValueError;

            }
            auto& aBlue = *maybe__aBlue;
            // Sentinel = 'aBlue'
            if ((!(((&(reader__)))->ReadSentinel(92602858)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'uint8_t'");
                return MsgValueError;
            }
            auto maybe__aPromiseID = IPC::ReadParam<uint32_t>((&(reader__)));
            if (!maybe__aPromiseID) {
                FatalError("Error deserializing 'uint32_t'");
                return MsgValueError;

            }
            auto& aPromiseID = *maybe__aPromiseID;
            // Sentinel = 'aPromiseID'
            if ((!(((&(reader__)))->ReadSentinel(363398094)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'uint32_t'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::IPCResult __ok = (static_cast<GamepadEventChannelParent*>(this))->RecvLightIndicatorColor(std::move(aHandle), std::move(aLightColorIndex), std::move(aRed), std::move(aGreen), std::move(aBlue), std::move(aPromiseID));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PGamepadEventChannel::Msg_RequestAllGamepads__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PGamepadEventChannel", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PGamepadEventChannelParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PGamepadEventChannel::Msg_RequestAllGamepads", OTHER);

            int32_t id__ = Id();
            UniquePtr<IPC::Message> reply__(PGamepadEventChannel::Reply_RequestAllGamepads(id__));
            reply__->set_seqno(msg__.seqno());

            RefPtr<mozilla::ipc::IPDLResolverInner> resolver__ =
                new mozilla::ipc::IPDLResolverInner(std::move(reply__), this);

            RequestAllGamepadsResolver resolver = [resolver__ = std::move(resolver__)](mozilla::Span<GamepadAdded const> aParam) {
                resolver__->Resolve([&] (IPC::Message* reply__, IProtocol* self__) {
                    IPC::MessageWriter writer__(*reply__, self__);
                    IPC::WriteParam((&(writer__)), aParam);
                    // Sentinel = 'gamepads'
                    ((&(writer__)))->WriteSentinel(244056899);

                    if (mozilla::ipc::LoggingEnabledFor("PGamepadEventChannel", mozilla::ipc::ParentSide)) {
                        mozilla::ipc::LogMessageForProtocol(
                            "PGamepadEventChannelParent",
                            self__->ToplevelProtocol()->OtherPidMaybeInvalid(),
                            "Sending reply ",
                            reply__->type(),
                            mozilla::ipc::MessageDirection::eSending);
                    }

                });
            };
            mozilla::ipc::IPCResult __ok = (static_cast<GamepadEventChannelParent*>(this))->RecvRequestAllGamepads(std::move(resolver));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    default:
        return MsgNotKnown;
    }
}

auto PGamepadEventChannelParent::OnMessageReceived(
        const Message& msg__,
        UniquePtr<Message>& reply__) -> PGamepadEventChannelParent::Result
{
    return MsgNotKnown;
}



} // namespace dom
} // namespace mozilla
namespace IPC {
auto ParamTraits<::mozilla::dom::PGamepadEventChannelParent*>::Write(
        IPC::MessageWriter* aWriter,
        const paramType& aVar) -> void
{
    MOZ_RELEASE_ASSERT(
        aWriter->GetActor(),
        "Cannot serialize managed actors without an actor");

    int32_t id;
    if (!aVar) {
        id = 0;  // kNullActorId
    } else {
        id = aVar->Id();
        if (id == 1) {  // kFreedActorId
            aVar->FatalError("Actor has been |delete|d");
        }
        MOZ_RELEASE_ASSERT(
            aWriter->GetActor()->GetIPCChannel() == aVar->GetIPCChannel(),
            "Actor must be from the same channel as the"
            " actor it's being sent over");
        MOZ_RELEASE_ASSERT(
            aVar->CanSend(),
            "Actor must still be open when sending");
    }

    IPC::WriteParam(aWriter, id);
}

auto ParamTraits<::mozilla::dom::PGamepadEventChannelParent*>::Read(IPC::MessageReader* aReader) -> IPC::ReadResult<paramType>
{
    MOZ_RELEASE_ASSERT(
        aReader->GetActor(),
        "Cannot deserialize managed actors without an actor");
    mozilla::Maybe<mozilla::ipc::IProtocol*> actor = aReader->GetActor()
        ->ReadActor(aReader, true, "PGamepadEventChannel", PGamepadEventChannelMsgStart);
    if (actor.isSome()) {
        return static_cast<::mozilla::dom::PGamepadEventChannelParent*>(actor.ref());
    }
    return {};
}

} // namespace IPC
