//
// Automatically generated by ipdlc.
// Edit at your own risk
//


#include "mozilla/dom/PGamepadEventChannelChild.h"
#include "mozilla/ProfilerLabels.h"
#include "mozilla/dom/GamepadEventChannelChild.h"
#include "mozilla/dom/GamepadMessageUtils.h"

#include "mozilla/ipc/PBackgroundChild.h"

#include "ipc/IPCMessageUtils.h"
#include "ipc/IPCMessageUtilsSpecializations.h"
#include "nsIFile.h"
#include "mozilla/ipc/Endpoint.h"
#include "mozilla/ipc/ProtocolMessageUtils.h"
#include "mozilla/ipc/ProtocolUtils.h"
#include "mozilla/ipc/ShmemMessageUtils.h"
#include "mozilla/ipc/TaintingIPCUtils.h"

namespace mozilla {
namespace dom {


MOZ_IMPLICIT PGamepadEventChannelChild::PGamepadEventChannelChild() :
    mozilla::ipc::IRefCountedProtocol(kProtocolId, mozilla::ipc::ChildSide)
{
    MOZ_COUNT_CTOR(PGamepadEventChannelChild);
}

PGamepadEventChannelChild::~PGamepadEventChannelChild()
{
    MOZ_COUNT_DTOR(PGamepadEventChannelChild);
}

auto PGamepadEventChannelChild::ActorAlloc() -> void
{
    AddRef();
}

auto PGamepadEventChannelChild::ActorDealloc() -> void
{
    Release();
}

auto PGamepadEventChannelChild::OtherPid() const -> ::base::ProcessId
{
    ::base::ProcessId pid =
        ::mozilla::ipc::IProtocol::ToplevelProtocol()->OtherPidMaybeInvalid();
    MOZ_RELEASE_ASSERT(pid != ::base::kInvalidProcessId);
    return pid;
}

auto PGamepadEventChannelChild::OtherChildID() const -> ::GeckoChildID
{
    ::GeckoChildID childID =
        ::mozilla::ipc::IProtocol::ToplevelProtocol()->OtherChildIDMaybeInvalid();
    MOZ_RELEASE_ASSERT(childID != -1);
    return childID;
}

auto PGamepadEventChannelChild::OtherEndpointProcInfo() const -> ::mozilla::ipc::EndpointProcInfo
{
    return ::mozilla::ipc::EndpointProcInfo{OtherPid(), OtherChildID()};
}

auto PGamepadEventChannelChild::Manager() const -> PBackgroundChild*
{
    return static_cast<PBackgroundChild*>(IProtocol::Manager());
}

auto PGamepadEventChannelChild::ManagedProtocolIds() const -> mozilla::Span<mozilla::ipc::ProtocolId const>
{
    return {};
}

auto PGamepadEventChannelChild::GetManagedActors(mozilla::ipc::ProtocolId aProtocol) -> UntypedManagedContainer*
{
    switch (aProtocol) {
    default:
        return nullptr;
    }
}

auto PGamepadEventChannelChild::RejectPendingResponses(ResponseRejectReason aReason) -> void
{
    mAsyncCallbacks.RejectPendingResponses(aReason);
}

auto PGamepadEventChannelChild::Send__delete__(PGamepadEventChannelChild* actor) -> bool
{
    if (!actor || !actor->CanSend()) {
        NS_WARNING("Attempt to __delete__ missing or closed actor");
        return false;
    }
    UniquePtr<IPC::Message> msg__ = PGamepadEventChannel::Msg___delete__((actor)->Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            actor};




    if (mozilla::ipc::LoggingEnabledFor("PGamepadEventChannel", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PGamepadEventChannelChild",
            actor->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PGamepadEventChannel::Msg___delete__", OTHER);

    bool sendok__ = (actor)->ChannelSend(std::move(msg__));

    actor->ActorDisconnected(Deletion);
    return sendok__;
}

auto PGamepadEventChannelChild::SendVibrateHaptic(
        const GamepadHandle& aHandle,
        const uint32_t& aHapticIndex,
        const double& aIntensity,
        const double& aDuration,
        const uint32_t& aPromiseID) -> bool
{
    UniquePtr<IPC::Message> msg__ = PGamepadEventChannel::Msg_VibrateHaptic(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), aHandle);
    // Sentinel = 'aHandle'
    ((&(writer__)))->WriteSentinel(174326446);
    IPC::WriteParam((&(writer__)), aHapticIndex);
    // Sentinel = 'aHapticIndex'
    ((&(writer__)))->WriteSentinel(500040883);
    IPC::WriteParam((&(writer__)), aIntensity);
    // Sentinel = 'aIntensity'
    ((&(writer__)))->WriteSentinel(367854633);
    IPC::WriteParam((&(writer__)), aDuration);
    // Sentinel = 'aDuration'
    ((&(writer__)))->WriteSentinel(296551336);
    IPC::WriteParam((&(writer__)), aPromiseID);
    // Sentinel = 'aPromiseID'
    ((&(writer__)))->WriteSentinel(363398094);




    if (mozilla::ipc::LoggingEnabledFor("PGamepadEventChannel", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PGamepadEventChannelChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PGamepadEventChannel::Msg_VibrateHaptic", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PGamepadEventChannelChild::SendStopVibrateHaptic(const GamepadHandle& aHandle) -> bool
{
    UniquePtr<IPC::Message> msg__ = PGamepadEventChannel::Msg_StopVibrateHaptic(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), aHandle);
    // Sentinel = 'aHandle'
    ((&(writer__)))->WriteSentinel(174326446);




    if (mozilla::ipc::LoggingEnabledFor("PGamepadEventChannel", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PGamepadEventChannelChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PGamepadEventChannel::Msg_StopVibrateHaptic", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PGamepadEventChannelChild::SendLightIndicatorColor(
        const GamepadHandle& aHandle,
        const uint32_t& aLightColorIndex,
        const uint8_t& aRed,
        const uint8_t& aGreen,
        const uint8_t& aBlue,
        const uint32_t& aPromiseID) -> bool
{
    UniquePtr<IPC::Message> msg__ = PGamepadEventChannel::Msg_LightIndicatorColor(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), aHandle);
    // Sentinel = 'aHandle'
    ((&(writer__)))->WriteSentinel(174326446);
    IPC::WriteParam((&(writer__)), aLightColorIndex);
    // Sentinel = 'aLightColorIndex'
    ((&(writer__)))->WriteSentinel(882247249);
    IPC::WriteParam((&(writer__)), aRed);
    // Sentinel = 'aRed'
    ((&(writer__)))->WriteSentinel(61604221);
    IPC::WriteParam((&(writer__)), aGreen);
    // Sentinel = 'aGreen'
    ((&(writer__)))->WriteSentinel(131990099);
    IPC::WriteParam((&(writer__)), aBlue);
    // Sentinel = 'aBlue'
    ((&(writer__)))->WriteSentinel(92602858);
    IPC::WriteParam((&(writer__)), aPromiseID);
    // Sentinel = 'aPromiseID'
    ((&(writer__)))->WriteSentinel(363398094);




    if (mozilla::ipc::LoggingEnabledFor("PGamepadEventChannel", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PGamepadEventChannelChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PGamepadEventChannel::Msg_LightIndicatorColor", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PGamepadEventChannelChild::SendRequestAllGamepads(
        mozilla::ipc::ResolveCallback<nsTArray<GamepadAdded>>&& aResolve,
        mozilla::ipc::RejectCallback&& aReject) -> void
{
    UniquePtr<IPC::Message> msg__ = PGamepadEventChannel::Msg_RequestAllGamepads(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};





    if (mozilla::ipc::LoggingEnabledFor("PGamepadEventChannel", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PGamepadEventChannelChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PGamepadEventChannel::Msg_RequestAllGamepads", OTHER);

    int32_t seqno__ = 0;
    if (ChannelSend(std::move(msg__), (&(seqno__)))) {
        mAsyncCallbacks.AddCallback(seqno__, PGamepadEventChannel::Reply_RequestAllGamepads__ID, [resolve=std::move(aResolve)](IPC::MessageReader* aReader) mutable {
            auto maybe__gamepads = IPC::ReadParam<nsTArray<GamepadAdded>>(aReader);
            if (!maybe__gamepads) {
                (aReader)->FatalError("Error deserializing 'GamepadAdded[]'");
                return MsgValueError;

            }
            auto& gamepads = *maybe__gamepads;
            // Sentinel = 'gamepads'
            if ((!((aReader)->ReadSentinel(244056899)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'GamepadAdded[]'");
                return MsgValueError;
            }


            aReader->EndRead();

            resolve(std::move(gamepads));
            return MsgProcessed;
        }, std::move(aReject));
    }
    else {
        aReject(::mozilla::ipc::ResponseRejectReason::SendError);
    }
    return;
}

auto PGamepadEventChannelChild::SendRequestAllGamepads() -> RefPtr<RequestAllGamepadsPromise>
{
    RefPtr<MozPromise<nsTArray<GamepadAdded>, ResponseRejectReason, true>::Private> promise__ = new MozPromise<nsTArray<GamepadAdded>, ResponseRejectReason, true>::Private(__func__);
    promise__->UseDirectTaskDispatch(__func__);
    SendRequestAllGamepads([promise__](nsTArray<GamepadAdded>&& aValue) {
        promise__->Resolve(std::move(aValue), __func__);
    }, [promise__](ResponseRejectReason&& aReason) {
        promise__->Reject(std::move(aReason), __func__);
    });
    return promise__;
}

auto PGamepadEventChannelChild::DeallocManagee(
        int32_t aProtocolId,
        IProtocol* aListener) -> void
{
    FatalError("unreached");
    return;
}

auto PGamepadEventChannelChild::OnMessageReceived(const Message& msg__) -> PGamepadEventChannelChild::Result
{
    switch (msg__.type()) {
    case MANAGED_ENDPOINT_BOUND_MESSAGE_TYPE:
        {
            if (!mAwaitingManagedEndpointBind) {
                NS_WARNING("Unexpected managed endpoint lifecycle message after actor bound!");
                return MsgNotAllowed;
            }
            mAwaitingManagedEndpointBind = false;
            return MsgProcessed;
        }
    case MANAGED_ENDPOINT_DROPPED_MESSAGE_TYPE:
        {
            if (!mAwaitingManagedEndpointBind) {
                NS_WARNING("Unexpected managed endpoint lifecycle message after actor bound!");
                return MsgNotAllowed;
            }
            mAwaitingManagedEndpointBind = false;
            this->ActorDisconnected(ManagedEndpointDropped);
            return MsgProcessed;
        }
    case PGamepadEventChannel::Reply___delete____ID:
        {
            return MsgProcessed;
        }
    case PGamepadEventChannel::Reply_RequestAllGamepads__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PGamepadEventChannel", mozilla::ipc::ChildSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PGamepadEventChannelChild",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }

            AUTO_PROFILER_LABEL("PGamepadEventChannel::Msg_RequestAllGamepads", OTHER);


            return mAsyncCallbacks.GotReply(this, msg__);
        }
    case PGamepadEventChannel::Msg_GamepadUpdate__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PGamepadEventChannel", mozilla::ipc::ChildSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PGamepadEventChannelChild",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PGamepadEventChannel::Msg_GamepadUpdate", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__aGamepadEvent = IPC::ReadParam<GamepadChangeEvent>((&(reader__)));
            if (!maybe__aGamepadEvent) {
                FatalError("Error deserializing 'GamepadChangeEvent'");
                return MsgValueError;

            }
            auto& aGamepadEvent = *maybe__aGamepadEvent;
            // Sentinel = 'aGamepadEvent'
            if ((!(((&(reader__)))->ReadSentinel(578225427)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'GamepadChangeEvent'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::IPCResult __ok = (static_cast<GamepadEventChannelChild*>(this))->RecvGamepadUpdate(std::move(aGamepadEvent));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PGamepadEventChannel::Msg_ReplyGamepadPromise__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PGamepadEventChannel", mozilla::ipc::ChildSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PGamepadEventChannelChild",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PGamepadEventChannel::Msg_ReplyGamepadPromise", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__aPromiseID = IPC::ReadParam<uint32_t>((&(reader__)));
            if (!maybe__aPromiseID) {
                FatalError("Error deserializing 'uint32_t'");
                return MsgValueError;

            }
            auto& aPromiseID = *maybe__aPromiseID;
            // Sentinel = 'aPromiseID'
            if ((!(((&(reader__)))->ReadSentinel(363398094)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'uint32_t'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::IPCResult __ok = (static_cast<GamepadEventChannelChild*>(this))->RecvReplyGamepadPromise(std::move(aPromiseID));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    default:
        return MsgNotKnown;
    }
}

auto PGamepadEventChannelChild::OnMessageReceived(
        const Message& msg__,
        UniquePtr<Message>& reply__) -> PGamepadEventChannelChild::Result
{
    return MsgNotKnown;
}



} // namespace dom
} // namespace mozilla
namespace IPC {
auto ParamTraits<::mozilla::dom::PGamepadEventChannelChild*>::Write(
        IPC::MessageWriter* aWriter,
        const paramType& aVar) -> void
{
    MOZ_RELEASE_ASSERT(
        aWriter->GetActor(),
        "Cannot serialize managed actors without an actor");

    int32_t id;
    if (!aVar) {
        id = 0;  // kNullActorId
    } else {
        id = aVar->Id();
        if (id == 1) {  // kFreedActorId
            aVar->FatalError("Actor has been |delete|d");
        }
        MOZ_RELEASE_ASSERT(
            aWriter->GetActor()->GetIPCChannel() == aVar->GetIPCChannel(),
            "Actor must be from the same channel as the"
            " actor it's being sent over");
        MOZ_RELEASE_ASSERT(
            aVar->CanSend(),
            "Actor must still be open when sending");
    }

    IPC::WriteParam(aWriter, id);
}

auto ParamTraits<::mozilla::dom::PGamepadEventChannelChild*>::Read(IPC::MessageReader* aReader) -> IPC::ReadResult<paramType>
{
    MOZ_RELEASE_ASSERT(
        aReader->GetActor(),
        "Cannot deserialize managed actors without an actor");
    mozilla::Maybe<mozilla::ipc::IProtocol*> actor = aReader->GetActor()
        ->ReadActor(aReader, true, "PGamepadEventChannel", PGamepadEventChannelMsgStart);
    if (actor.isSome()) {
        return static_cast<::mozilla::dom::PGamepadEventChannelChild*>(actor.ref());
    }
    return {};
}

} // namespace IPC
