//
// Automatically generated by ipdlc.
// Edit at your own risk
//


#include "mozilla/gmp/PGMPParent.h"
#include "GMPChild.h"
#include "GMPParent.h"
#include "mozilla/ProfilerLabels.h"
#include "mozilla/ProfilerMarkers.h"
#include "mozilla/ipc/ByteBufUtils.h"
#include "mozilla/ipc/IPCCore.h"

#include "mozilla/gmp/PGMPContentParent.h"
#include "mozilla/gmp/PGMPTimerParent.h"
#include "mozilla/gmp/PGMPStorageParent.h"
#include "mozilla/PProfilerParent.h"

#include "ipc/IPCMessageUtils.h"
#include "ipc/IPCMessageUtilsSpecializations.h"
#include "nsIFile.h"
#include "mozilla/ipc/Endpoint.h"
#include "mozilla/ipc/ProtocolMessageUtils.h"
#include "mozilla/ipc/ProtocolUtils.h"
#include "mozilla/ipc/ShmemMessageUtils.h"
#include "mozilla/ipc/TaintingIPCUtils.h"

namespace mozilla {
namespace gmp {


auto PGMPParent::RecvPGMPTimerConstructor(PGMPTimerParent* actor) -> mozilla::ipc::IPCResult
{
    return IPC_OK();
}

auto PGMPParent::RecvPGMPStorageConstructor(PGMPStorageParent* actor) -> mozilla::ipc::IPCResult
{
    return IPC_OK();
}

auto PGMPParent::ProcessingError(
        Result aCode,
        const char* aReason) -> void
{
}

auto PGMPParent::ShouldContinueFromReplyTimeout() -> bool
{
    return true;
}

MOZ_IMPLICIT PGMPParent::PGMPParent() :
    mozilla::ipc::IToplevelProtocol("PGMPParent", kProtocolId, mozilla::ipc::ParentSide)
{
    MOZ_COUNT_CTOR(PGMPParent);
}

PGMPParent::~PGMPParent()
{
    MOZ_COUNT_DTOR(PGMPParent);
}

auto PGMPParent::ActorAlloc() -> void
{
    MOZ_RELEASE_ASSERT(XRE_IsParentProcess(), "Invalid process for `PGMPParent'");
    AddRef();
}

auto PGMPParent::ActorDealloc() -> void
{
    Release();
}

auto PGMPParent::OtherPid() const -> ::base::ProcessId
{
    ::base::ProcessId pid =
        ::mozilla::ipc::IProtocol::ToplevelProtocol()->OtherPidMaybeInvalid();
    MOZ_RELEASE_ASSERT(pid != ::base::kInvalidProcessId);
    return pid;
}

auto PGMPParent::OtherChildID() const -> ::GeckoChildID
{
    ::GeckoChildID childID =
        ::mozilla::ipc::IProtocol::ToplevelProtocol()->OtherChildIDMaybeInvalid();
    MOZ_RELEASE_ASSERT(childID != -1);
    return childID;
}

auto PGMPParent::OtherEndpointProcInfo() const -> ::mozilla::ipc::EndpointProcInfo
{
    return ::mozilla::ipc::EndpointProcInfo{OtherPid(), OtherChildID()};
}

auto PGMPParent::ManagedPGMPTimerParent(nsTArray<PGMPTimerParent*>& aArr) const -> void
{
    mManagedPGMPTimerParent.ToArray(aArr);
}

auto PGMPParent::ManagedPGMPTimerParent() const -> const ManagedContainer<PGMPTimerParent>&
{
    return mManagedPGMPTimerParent;
}

auto PGMPParent::ManagedPGMPStorageParent(nsTArray<PGMPStorageParent*>& aArr) const -> void
{
    mManagedPGMPStorageParent.ToArray(aArr);
}

auto PGMPParent::ManagedPGMPStorageParent() const -> const ManagedContainer<PGMPStorageParent>&
{
    return mManagedPGMPStorageParent;
}

auto PGMPParent::ManagedProtocolIds() const -> mozilla::Span<mozilla::ipc::ProtocolId const>
{
    static constexpr ::mozilla::ipc::ProtocolId sIds[] = {
        PGMPTimerMsgStart,
        PGMPStorageMsgStart
    };
    return sIds;
}

auto PGMPParent::GetManagedActors(mozilla::ipc::ProtocolId aProtocol) -> UntypedManagedContainer*
{
    switch (aProtocol) {
    case PGMPTimerMsgStart:
        return (&(mManagedPGMPTimerParent));
    case PGMPStorageMsgStart:
        return (&(mManagedPGMPStorageParent));
    default:
        return nullptr;
    }
}

auto PGMPParent::RejectPendingResponses(ResponseRejectReason aReason) -> void
{
    mAsyncCallbacks.RejectPendingResponses(aReason);
}

auto PGMPParent::OpenPGMPTimerEndpoint(PGMPTimerParent* aActor) -> ManagedEndpoint<PGMPTimerChild>
{
    if (!aActor) {
        NS_WARNING("Cannot bind null PGMPTimerParent actor");
        return ManagedEndpoint<PGMPTimerChild>();
    }

    if (!aActor->SetManagerAndRegister(this)) {
        NS_WARNING("Failed to bind PGMPTimerParent actor");
        return ManagedEndpoint<PGMPTimerChild>();
    }

    // Mark our actor as awaiting the other side to be bound. This will
    // be cleared when a `MANAGED_ENDPOINT_{DROPPED,BOUND}` message is
    // received.
    aActor->mAwaitingManagedEndpointBind = true;
    return ManagedEndpoint<PGMPTimerChild>(mozilla::ipc::PrivateIPDLInterface(), aActor);
}

auto PGMPParent::BindPGMPTimerEndpoint(
        ManagedEndpoint<PGMPTimerParent> aEndpoint,
        PGMPTimerParent* aActor) -> bool
{
    return aEndpoint.Bind(mozilla::ipc::PrivateIPDLInterface(), aActor, this);
}

auto PGMPParent::OpenPGMPStorageEndpoint(PGMPStorageParent* aActor) -> ManagedEndpoint<PGMPStorageChild>
{
    if (!aActor) {
        NS_WARNING("Cannot bind null PGMPStorageParent actor");
        return ManagedEndpoint<PGMPStorageChild>();
    }

    if (!aActor->SetManagerAndRegister(this)) {
        NS_WARNING("Failed to bind PGMPStorageParent actor");
        return ManagedEndpoint<PGMPStorageChild>();
    }

    // Mark our actor as awaiting the other side to be bound. This will
    // be cleared when a `MANAGED_ENDPOINT_{DROPPED,BOUND}` message is
    // received.
    aActor->mAwaitingManagedEndpointBind = true;
    return ManagedEndpoint<PGMPStorageChild>(mozilla::ipc::PrivateIPDLInterface(), aActor);
}

auto PGMPParent::BindPGMPStorageEndpoint(
        ManagedEndpoint<PGMPStorageParent> aEndpoint,
        PGMPStorageParent* aActor) -> bool
{
    return aEndpoint.Bind(mozilla::ipc::PrivateIPDLInterface(), aActor, this);
}

auto PGMPParent::SendCrashPluginNow() -> bool
{
    UniquePtr<IPC::Message> msg__ = PGMP::Msg_CrashPluginNow(MSG_ROUTING_CONTROL);
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};





    if (mozilla::ipc::LoggingEnabledFor("PGMP", mozilla::ipc::ParentSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PGMPParent",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PGMP::Msg_CrashPluginNow", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PGMPParent::SendStartPlugin(const nsAString& adapter) -> bool
{
    UniquePtr<IPC::Message> msg__ = PGMP::Msg_StartPlugin(MSG_ROUTING_CONTROL);
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), adapter);
    // Sentinel = 'adapter'
    ((&(writer__)))->WriteSentinel(188941026);



    UniquePtr<Message> reply__;

    if (mozilla::ipc::LoggingEnabledFor("PGMP", mozilla::ipc::ParentSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PGMPParent",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PGMP::Msg_StartPlugin", OTHER);

    bool sendok__ = false;
    {
        AUTO_PROFILER_TRACING_MARKER("Sync IPC", "PGMP::Msg_StartPlugin", IPC);
        sendok__ = ChannelSend(std::move(msg__), (&(reply__)));
    }
    if ((!(sendok__))) {
        return false;
    }

    if (mozilla::ipc::LoggingEnabledFor("PGMP", mozilla::ipc::ParentSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PGMPParent",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Received reply ",
            reply__->type(),
            mozilla::ipc::MessageDirection::eReceiving);
    }

    return true;
}

auto PGMPParent::SendProvideStorageId(const nsACString& storageId) -> bool
{
    UniquePtr<IPC::Message> msg__ = PGMP::Msg_ProvideStorageId(MSG_ROUTING_CONTROL);
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), storageId);
    // Sentinel = 'storageId'
    ((&(writer__)))->WriteSentinel(319751075);




    if (mozilla::ipc::LoggingEnabledFor("PGMP", mozilla::ipc::ParentSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PGMPParent",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PGMP::Msg_ProvideStorageId", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PGMPParent::SendPreloadLibs(const nsACString& libs) -> bool
{
    UniquePtr<IPC::Message> msg__ = PGMP::Msg_PreloadLibs(MSG_ROUTING_CONTROL);
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), libs);
    // Sentinel = 'libs'
    ((&(writer__)))->WriteSentinel(69599659);




    if (mozilla::ipc::LoggingEnabledFor("PGMP", mozilla::ipc::ParentSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PGMPParent",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PGMP::Msg_PreloadLibs", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PGMPParent::SendCloseActive() -> bool
{
    UniquePtr<IPC::Message> msg__ = PGMP::Msg_CloseActive(MSG_ROUTING_CONTROL);
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};





    if (mozilla::ipc::LoggingEnabledFor("PGMP", mozilla::ipc::ParentSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PGMPParent",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PGMP::Msg_CloseActive", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PGMPParent::SendInitGMPContentChild(Endpoint<::mozilla::gmp::PGMPContentChild>&& endpoint) -> bool
{
    UniquePtr<IPC::Message> msg__ = PGMP::Msg_InitGMPContentChild(MSG_ROUTING_CONTROL);
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), std::move(endpoint));
    // Sentinel = 'endpoint'
    ((&(writer__)))->WriteSentinel(251724642);




    if (mozilla::ipc::LoggingEnabledFor("PGMP", mozilla::ipc::ParentSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PGMPParent",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PGMP::Msg_InitGMPContentChild", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PGMPParent::SendInitProfiler(Endpoint<::mozilla::PProfilerChild>&& endpoint) -> bool
{
    UniquePtr<IPC::Message> msg__ = PGMP::Msg_InitProfiler(MSG_ROUTING_CONTROL);
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), std::move(endpoint));
    // Sentinel = 'endpoint'
    ((&(writer__)))->WriteSentinel(251724642);




    if (mozilla::ipc::LoggingEnabledFor("PGMP", mozilla::ipc::ParentSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PGMPParent",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PGMP::Msg_InitProfiler", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PGMPParent::SendPreferenceUpdate(const Pref& pref) -> bool
{
    UniquePtr<IPC::Message> msg__ = PGMP::Msg_PreferenceUpdate(MSG_ROUTING_CONTROL);
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), pref);
    // Sentinel = 'pref'
    ((&(writer__)))->WriteSentinel(71958958);




    if (mozilla::ipc::LoggingEnabledFor("PGMP", mozilla::ipc::ParentSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PGMPParent",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PGMP::Msg_PreferenceUpdate", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PGMPParent::SendFlushFOGData(
        mozilla::ipc::ResolveCallback<ByteBuf>&& aResolve,
        mozilla::ipc::RejectCallback&& aReject) -> void
{
    UniquePtr<IPC::Message> msg__ = PGMP::Msg_FlushFOGData(MSG_ROUTING_CONTROL);
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};





    if (mozilla::ipc::LoggingEnabledFor("PGMP", mozilla::ipc::ParentSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PGMPParent",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PGMP::Msg_FlushFOGData", OTHER);

    int32_t seqno__ = 0;
    if (ChannelSend(std::move(msg__), (&(seqno__)))) {
        mAsyncCallbacks.AddCallback(seqno__, PGMP::Reply_FlushFOGData__ID, [resolve=std::move(aResolve)](IPC::MessageReader* aReader) mutable {
            auto maybe__buf = IPC::ReadParam<ByteBuf>(aReader);
            if (!maybe__buf) {
                (aReader)->FatalError("Error deserializing 'ByteBuf'");
                return MsgValueError;

            }
            auto& buf = *maybe__buf;
            // Sentinel = 'buf'
            if ((!((aReader)->ReadSentinel(41484606)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'ByteBuf'");
                return MsgValueError;
            }


            aReader->EndRead();

            resolve(std::move(buf));
            return MsgProcessed;
        }, std::move(aReject));
    }
    else {
        aReject(::mozilla::ipc::ResponseRejectReason::SendError);
    }
    return;
}

auto PGMPParent::SendFlushFOGData() -> RefPtr<FlushFOGDataPromise>
{
    RefPtr<MozPromise<ByteBuf, ResponseRejectReason, true>::Private> promise__ = new MozPromise<ByteBuf, ResponseRejectReason, true>::Private(__func__);
    promise__->UseDirectTaskDispatch(__func__);
    SendFlushFOGData([promise__](ByteBuf&& aValue) {
        promise__->Resolve(std::move(aValue), __func__);
    }, [promise__](ResponseRejectReason&& aReason) {
        promise__->Reject(std::move(aReason), __func__);
    });
    return promise__;
}

auto PGMPParent::SendTestTriggerMetrics(
        mozilla::ipc::ResolveCallback<bool>&& aResolve,
        mozilla::ipc::RejectCallback&& aReject) -> void
{
    UniquePtr<IPC::Message> msg__ = PGMP::Msg_TestTriggerMetrics(MSG_ROUTING_CONTROL);
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};





    if (mozilla::ipc::LoggingEnabledFor("PGMP", mozilla::ipc::ParentSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PGMPParent",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PGMP::Msg_TestTriggerMetrics", OTHER);

    int32_t seqno__ = 0;
    if (ChannelSend(std::move(msg__), (&(seqno__)))) {
        mAsyncCallbacks.AddCallback(seqno__, PGMP::Reply_TestTriggerMetrics__ID, [resolve=std::move(aResolve)](IPC::MessageReader* aReader) mutable {
            auto maybe__unused = IPC::ReadParam<bool>(aReader);
            if (!maybe__unused) {
                (aReader)->FatalError("Error deserializing 'bool'");
                return MsgValueError;

            }
            auto& unused = *maybe__unused;
            // Sentinel = 'unused'
            if ((!((aReader)->ReadSentinel(155517589)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'bool'");
                return MsgValueError;
            }


            aReader->EndRead();

            resolve(std::move(unused));
            return MsgProcessed;
        }, std::move(aReject));
    }
    else {
        aReject(::mozilla::ipc::ResponseRejectReason::SendError);
    }
    return;
}

auto PGMPParent::SendTestTriggerMetrics() -> RefPtr<TestTriggerMetricsPromise>
{
    RefPtr<MozPromise<bool, ResponseRejectReason, true>::Private> promise__ = new MozPromise<bool, ResponseRejectReason, true>::Private(__func__);
    promise__->UseDirectTaskDispatch(__func__);
    SendTestTriggerMetrics([promise__](bool&& aValue) {
        promise__->Resolve(std::move(aValue), __func__);
    }, [promise__](ResponseRejectReason&& aReason) {
        promise__->Reject(std::move(aReason), __func__);
    });
    return promise__;
}

auto PGMPParent::SendShutdown(
        mozilla::ipc::ResolveCallback<nsCString>&& aResolve,
        mozilla::ipc::RejectCallback&& aReject) -> void
{
    UniquePtr<IPC::Message> msg__ = PGMP::Msg_Shutdown(MSG_ROUTING_CONTROL);
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};





    if (mozilla::ipc::LoggingEnabledFor("PGMP", mozilla::ipc::ParentSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PGMPParent",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PGMP::Msg_Shutdown", OTHER);

    int32_t seqno__ = 0;
    if (ChannelSend(std::move(msg__), (&(seqno__)))) {
        mAsyncCallbacks.AddCallback(seqno__, PGMP::Reply_Shutdown__ID, [resolve=std::move(aResolve)](IPC::MessageReader* aReader) mutable {
            auto maybe__profile = IPC::ReadParam<nsCString>(aReader);
            if (!maybe__profile) {
                (aReader)->FatalError("Error deserializing 'nsCString'");
                return MsgValueError;

            }
            auto& profile = *maybe__profile;
            // Sentinel = 'profile'
            if ((!((aReader)->ReadSentinel(201196274)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'nsCString'");
                return MsgValueError;
            }


            aReader->EndRead();

            resolve(std::move(profile));
            return MsgProcessed;
        }, std::move(aReject));
    }
    else {
        aReject(::mozilla::ipc::ResponseRejectReason::SendError);
    }
    return;
}

auto PGMPParent::SendShutdown() -> RefPtr<ShutdownPromise>
{
    RefPtr<MozPromise<nsCString, ResponseRejectReason, true>::Private> promise__ = new MozPromise<nsCString, ResponseRejectReason, true>::Private(__func__);
    promise__->UseDirectTaskDispatch(__func__);
    SendShutdown([promise__](nsCString&& aValue) {
        promise__->Resolve(std::move(aValue), __func__);
    }, [promise__](ResponseRejectReason&& aReason) {
        promise__->Reject(std::move(aReason), __func__);
    });
    return promise__;
}

auto PGMPParent::DeallocManagee(
        int32_t aProtocolId,
        IProtocol* aListener) -> void
{
    switch (aProtocolId) {
    case PGMPTimerMsgStart:
        static_cast<GMPParent*>(this)->DeallocPGMPTimerParent(static_cast<PGMPTimerParent*>(aListener));
        return;
    case PGMPStorageMsgStart:
        static_cast<GMPParent*>(this)->DeallocPGMPStorageParent(static_cast<PGMPStorageParent*>(aListener));
        return;
    default:
        FatalError("unreached");
        return;
    }
}

auto PGMPParent::OnMessageReceived(const Message& msg__) -> PGMPParent::Result
{
    int32_t route__ = msg__.routing_id();
    if (MSG_ROUTING_CONTROL != route__) {
        IProtocol* routed__ = Lookup(route__);
        if (!routed__ || !routed__->GetLifecycleProxy()) {
            if (mozilla::ipc::LoggingEnabledFor("PGMP", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PGMPParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Ignored message for dead actor",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eSending);
            }
            return MsgProcessed;

        }

        RefPtr<mozilla::ipc::ActorLifecycleProxy> proxy__ =
            routed__->GetLifecycleProxy();
        return proxy__->Get()->OnMessageReceived(msg__);
    }

    switch (msg__.type()) {
    case PGMP::Msg_InitCrashReporter__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PGMP", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PGMPParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PGMP::Msg_InitCrashReporter", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__threadId = IPC::ReadParam<NativeThreadId>((&(reader__)));
            if (!maybe__threadId) {
                FatalError("Error deserializing 'NativeThreadId'");
                return MsgValueError;

            }
            auto& threadId = *maybe__threadId;
            // Sentinel = 'threadId'
            if ((!(((&(reader__)))->ReadSentinel(248185638)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'NativeThreadId'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::IPCResult __ok = (static_cast<GMPParent*>(this))->RecvInitCrashReporter(std::move(threadId));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PGMP::Msg_PGMPTimerConstructor__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PGMP", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PGMPParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PGMP::Msg_PGMPTimerConstructor", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__handle__ = IPC::ReadParam<ActorHandle>((&(reader__)));
            if (!maybe__handle__) {
                FatalError("Error deserializing 'ActorHandle'");
                return MsgValueError;

            }
            auto& handle__ = *maybe__handle__;
            // Sentinel = 'actor'
            if ((!(((&(reader__)))->ReadSentinel(102892058)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'ActorHandle'");
                return MsgValueError;
            }
            reader__.EndRead();
            PGMPTimerParent* actor = (static_cast<GMPParent*>(this))->AllocPGMPTimerParent();
            if (!actor) {
                NS_WARNING("Cannot bind null PGMPTimerParent actor");
                return MsgValueError;
            }

            if (!actor->SetManagerAndRegister(this, (handle__).mId)) {
                NS_WARNING("Failed to bind PGMPTimerParent actor");
                return MsgValueError;
            }

            mozilla::ipc::IPCResult __ok = (static_cast<GMPParent*>(this))->RecvPGMPTimerConstructor(std::move(actor));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PGMP::Msg_PGMPStorageConstructor__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PGMP", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PGMPParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PGMP::Msg_PGMPStorageConstructor", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__handle__ = IPC::ReadParam<ActorHandle>((&(reader__)));
            if (!maybe__handle__) {
                FatalError("Error deserializing 'ActorHandle'");
                return MsgValueError;

            }
            auto& handle__ = *maybe__handle__;
            // Sentinel = 'actor'
            if ((!(((&(reader__)))->ReadSentinel(102892058)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'ActorHandle'");
                return MsgValueError;
            }
            reader__.EndRead();
            PGMPStorageParent* actor = (static_cast<GMPParent*>(this))->AllocPGMPStorageParent();
            if (!actor) {
                NS_WARNING("Cannot bind null PGMPStorageParent actor");
                return MsgValueError;
            }

            if (!actor->SetManagerAndRegister(this, (handle__).mId)) {
                NS_WARNING("Failed to bind PGMPStorageParent actor");
                return MsgValueError;
            }

            mozilla::ipc::IPCResult __ok = (static_cast<GMPParent*>(this))->RecvPGMPStorageConstructor(std::move(actor));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PGMP::Msg_PGMPContentChildDestroyed__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PGMP", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PGMPParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PGMP::Msg_PGMPContentChildDestroyed", OTHER);

            mozilla::ipc::IPCResult __ok = (static_cast<GMPParent*>(this))->RecvPGMPContentChildDestroyed();
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PGMP::Msg_FOGData__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PGMP", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PGMPParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PGMP::Msg_FOGData", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__buf = IPC::ReadParam<ByteBuf>((&(reader__)));
            if (!maybe__buf) {
                FatalError("Error deserializing 'ByteBuf'");
                return MsgValueError;

            }
            auto& buf = *maybe__buf;
            // Sentinel = 'buf'
            if ((!(((&(reader__)))->ReadSentinel(41484606)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'ByteBuf'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::IPCResult __ok = (static_cast<GMPParent*>(this))->RecvFOGData(std::move(buf));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PGMP::Reply_FlushFOGData__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PGMP", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PGMPParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }

            AUTO_PROFILER_LABEL("PGMP::Msg_FlushFOGData", OTHER);


            return mAsyncCallbacks.GotReply(this, msg__);
        }
    case PGMP::Reply_TestTriggerMetrics__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PGMP", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PGMPParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }

            AUTO_PROFILER_LABEL("PGMP::Msg_TestTriggerMetrics", OTHER);


            return mAsyncCallbacks.GotReply(this, msg__);
        }
    case PGMP::Reply_Shutdown__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PGMP", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PGMPParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }

            AUTO_PROFILER_LABEL("PGMP::Msg_Shutdown", OTHER);


            return mAsyncCallbacks.GotReply(this, msg__);
        }
    default:
        return MsgNotKnown;
    case SHMEM_CREATED_MESSAGE_TYPE:
        {
            if (!ShmemCreated(msg__)) {
                return MsgPayloadError;
            }
            return MsgProcessed;
        }
    case SHMEM_DESTROYED_MESSAGE_TYPE:
        {
            if (!ShmemDestroyed(msg__)) {
                return MsgPayloadError;
            }
            return MsgProcessed;
        }
    }
}

auto PGMPParent::OnMessageReceived(
        const Message& msg__,
        UniquePtr<Message>& reply__) -> PGMPParent::Result
{
    int32_t route__ = msg__.routing_id();
    if (MSG_ROUTING_CONTROL != route__) {
        IProtocol* routed__ = Lookup(route__);
        if (!routed__ || !routed__->GetLifecycleProxy()) {
            return MsgDropped;

        }

        RefPtr<mozilla::ipc::ActorLifecycleProxy> proxy__ =
            routed__->GetLifecycleProxy();
        return proxy__->Get()->OnMessageReceived(msg__, reply__);
    }

    return MsgNotKnown;
}



} // namespace gmp
} // namespace mozilla
namespace IPC {
auto ParamTraits<::mozilla::gmp::PGMPParent*>::Write(
        IPC::MessageWriter* aWriter,
        const paramType& aVar) -> void
{
    MOZ_RELEASE_ASSERT(
        aWriter->GetActor(),
        "Cannot serialize managed actors without an actor");

    int32_t id;
    if (!aVar) {
        id = 0;  // kNullActorId
    } else {
        id = aVar->Id();
        if (id == 1) {  // kFreedActorId
            aVar->FatalError("Actor has been |delete|d");
        }
        MOZ_RELEASE_ASSERT(
            aWriter->GetActor()->GetIPCChannel() == aVar->GetIPCChannel(),
            "Actor must be from the same channel as the"
            " actor it's being sent over");
        MOZ_RELEASE_ASSERT(
            aVar->CanSend(),
            "Actor must still be open when sending");
    }

    IPC::WriteParam(aWriter, id);
}

auto ParamTraits<::mozilla::gmp::PGMPParent*>::Read(IPC::MessageReader* aReader) -> IPC::ReadResult<paramType>
{
    MOZ_RELEASE_ASSERT(
        aReader->GetActor(),
        "Cannot deserialize managed actors without an actor");
    mozilla::Maybe<mozilla::ipc::IProtocol*> actor = aReader->GetActor()
        ->ReadActor(aReader, true, "PGMP", PGMPMsgStart);
    if (actor.isSome()) {
        return static_cast<::mozilla::gmp::PGMPParent*>(actor.ref());
    }
    return {};
}

} // namespace IPC
