//
// Automatically generated by ipdlc.
// Edit at your own risk
//


#include "mozilla/gmp/PGMPChild.h"
#include "GMPChild.h"
#include "GMPParent.h"
#include "mozilla/ProfilerLabels.h"
#include "mozilla/ipc/ByteBufUtils.h"
#include "mozilla/ipc/IPCCore.h"

#include "mozilla/gmp/PGMPContentChild.h"
#include "mozilla/gmp/PGMPTimerChild.h"
#include "mozilla/gmp/PGMPStorageChild.h"
#include "mozilla/PProfilerChild.h"

#include "ipc/IPCMessageUtils.h"
#include "ipc/IPCMessageUtilsSpecializations.h"
#include "nsIFile.h"
#include "mozilla/ipc/Endpoint.h"
#include "mozilla/ipc/ProtocolMessageUtils.h"
#include "mozilla/ipc/ProtocolUtils.h"
#include "mozilla/ipc/ShmemMessageUtils.h"
#include "mozilla/ipc/TaintingIPCUtils.h"

namespace mozilla {
namespace gmp {


auto PGMPChild::ProcessingError(
        Result aCode,
        const char* aReason) -> void
{
}

auto PGMPChild::ShouldContinueFromReplyTimeout() -> bool
{
    return true;
}

MOZ_IMPLICIT PGMPChild::PGMPChild() :
    mozilla::ipc::IToplevelProtocol("PGMPChild", kProtocolId, mozilla::ipc::ChildSide)
{
    MOZ_COUNT_CTOR(PGMPChild);
}

PGMPChild::~PGMPChild()
{
    MOZ_COUNT_DTOR(PGMPChild);
}

auto PGMPChild::ActorAlloc() -> void
{
    MOZ_RELEASE_ASSERT(XRE_IsGMPluginProcess(), "Invalid process for `PGMPChild'");
    AddRef();
}

auto PGMPChild::ActorDealloc() -> void
{
    Release();
}

auto PGMPChild::OtherPid() const -> ::base::ProcessId
{
    ::base::ProcessId pid =
        ::mozilla::ipc::IProtocol::ToplevelProtocol()->OtherPidMaybeInvalid();
    MOZ_RELEASE_ASSERT(pid != ::base::kInvalidProcessId);
    return pid;
}

auto PGMPChild::OtherChildID() const -> ::GeckoChildID
{
    ::GeckoChildID childID =
        ::mozilla::ipc::IProtocol::ToplevelProtocol()->OtherChildIDMaybeInvalid();
    MOZ_RELEASE_ASSERT(childID != -1);
    return childID;
}

auto PGMPChild::OtherEndpointProcInfo() const -> ::mozilla::ipc::EndpointProcInfo
{
    return ::mozilla::ipc::EndpointProcInfo{OtherPid(), OtherChildID()};
}

auto PGMPChild::ManagedPGMPTimerChild(nsTArray<PGMPTimerChild*>& aArr) const -> void
{
    mManagedPGMPTimerChild.ToArray(aArr);
}

auto PGMPChild::ManagedPGMPTimerChild() const -> const ManagedContainer<PGMPTimerChild>&
{
    return mManagedPGMPTimerChild;
}

auto PGMPChild::ManagedPGMPStorageChild(nsTArray<PGMPStorageChild*>& aArr) const -> void
{
    mManagedPGMPStorageChild.ToArray(aArr);
}

auto PGMPChild::ManagedPGMPStorageChild() const -> const ManagedContainer<PGMPStorageChild>&
{
    return mManagedPGMPStorageChild;
}

auto PGMPChild::ManagedProtocolIds() const -> mozilla::Span<mozilla::ipc::ProtocolId const>
{
    static constexpr ::mozilla::ipc::ProtocolId sIds[] = {
        PGMPTimerMsgStart,
        PGMPStorageMsgStart
    };
    return sIds;
}

auto PGMPChild::GetManagedActors(mozilla::ipc::ProtocolId aProtocol) -> UntypedManagedContainer*
{
    switch (aProtocol) {
    case PGMPTimerMsgStart:
        return (&(mManagedPGMPTimerChild));
    case PGMPStorageMsgStart:
        return (&(mManagedPGMPStorageChild));
    default:
        return nullptr;
    }
}

auto PGMPChild::RejectPendingResponses(ResponseRejectReason aReason) -> void
{
    mAsyncCallbacks.RejectPendingResponses(aReason);
}

auto PGMPChild::OpenPGMPTimerEndpoint(PGMPTimerChild* aActor) -> ManagedEndpoint<PGMPTimerParent>
{
    if (!aActor) {
        NS_WARNING("Cannot bind null PGMPTimerChild actor");
        return ManagedEndpoint<PGMPTimerParent>();
    }

    if (!aActor->SetManagerAndRegister(this)) {
        NS_WARNING("Failed to bind PGMPTimerChild actor");
        return ManagedEndpoint<PGMPTimerParent>();
    }

    // Mark our actor as awaiting the other side to be bound. This will
    // be cleared when a `MANAGED_ENDPOINT_{DROPPED,BOUND}` message is
    // received.
    aActor->mAwaitingManagedEndpointBind = true;
    return ManagedEndpoint<PGMPTimerParent>(mozilla::ipc::PrivateIPDLInterface(), aActor);
}

auto PGMPChild::BindPGMPTimerEndpoint(
        ManagedEndpoint<PGMPTimerChild> aEndpoint,
        PGMPTimerChild* aActor) -> bool
{
    return aEndpoint.Bind(mozilla::ipc::PrivateIPDLInterface(), aActor, this);
}

auto PGMPChild::OpenPGMPStorageEndpoint(PGMPStorageChild* aActor) -> ManagedEndpoint<PGMPStorageParent>
{
    if (!aActor) {
        NS_WARNING("Cannot bind null PGMPStorageChild actor");
        return ManagedEndpoint<PGMPStorageParent>();
    }

    if (!aActor->SetManagerAndRegister(this)) {
        NS_WARNING("Failed to bind PGMPStorageChild actor");
        return ManagedEndpoint<PGMPStorageParent>();
    }

    // Mark our actor as awaiting the other side to be bound. This will
    // be cleared when a `MANAGED_ENDPOINT_{DROPPED,BOUND}` message is
    // received.
    aActor->mAwaitingManagedEndpointBind = true;
    return ManagedEndpoint<PGMPStorageParent>(mozilla::ipc::PrivateIPDLInterface(), aActor);
}

auto PGMPChild::BindPGMPStorageEndpoint(
        ManagedEndpoint<PGMPStorageChild> aEndpoint,
        PGMPStorageChild* aActor) -> bool
{
    return aEndpoint.Bind(mozilla::ipc::PrivateIPDLInterface(), aActor, this);
}

auto PGMPChild::SendInitCrashReporter(const NativeThreadId& threadId) -> bool
{
    UniquePtr<IPC::Message> msg__ = PGMP::Msg_InitCrashReporter(MSG_ROUTING_CONTROL);
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), threadId);
    // Sentinel = 'threadId'
    ((&(writer__)))->WriteSentinel(248185638);




    if (mozilla::ipc::LoggingEnabledFor("PGMP", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PGMPChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PGMP::Msg_InitCrashReporter", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PGMPChild::SendPGMPTimerConstructor() -> PGMPTimerChild*
{
    PGMPTimerChild* actor = (static_cast<GMPChild*>(this))->AllocPGMPTimerChild();
    return SendPGMPTimerConstructor(std::move(actor));
}

auto PGMPChild::SendPGMPTimerConstructor(PGMPTimerChild* actor) -> PGMPTimerChild*
{
    if (!actor) {
        NS_WARNING("Cannot bind null PGMPTimerChild actor");
        return nullptr;
    }

    if (!actor->SetManagerAndRegister(this)) {
        NS_WARNING("Failed to bind PGMPTimerChild actor");
        return nullptr;
    }


    // Build our constructor message.
    UniquePtr<IPC::Message> msg__ = PGMP::Msg_PGMPTimerConstructor(MSG_ROUTING_CONTROL);
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), actor);
    // Sentinel = 'actor'
    ((&(writer__)))->WriteSentinel(102892058);




    // Notify the other side about the newly created actor. This can
    // fail if our manager has already been destroyed.
    //
    // NOTE: If the send call fails due to toplevel channel teardown,
    // the `IProtocol::ChannelSend` wrapper absorbs the error for us,
    // so we don't tear down actors unexpectedly.

    if (mozilla::ipc::LoggingEnabledFor("PGMP", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PGMPChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PGMP::Msg_PGMPTimerConstructor", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));


    // Warn, destroy the actor, and return null if the message failed to
    // send. Otherwise, return the successfully created actor reference.
    if (!sendok__) {
        NS_WARNING("Error sending PGMPTimerChild constructor");
        actor->ActorDisconnected(FailedConstructor);

        return nullptr;
    }
    return actor;
}

auto PGMPChild::SendPGMPStorageConstructor() -> PGMPStorageChild*
{
    PGMPStorageChild* actor = (static_cast<GMPChild*>(this))->AllocPGMPStorageChild();
    return SendPGMPStorageConstructor(std::move(actor));
}

auto PGMPChild::SendPGMPStorageConstructor(PGMPStorageChild* actor) -> PGMPStorageChild*
{
    if (!actor) {
        NS_WARNING("Cannot bind null PGMPStorageChild actor");
        return nullptr;
    }

    if (!actor->SetManagerAndRegister(this)) {
        NS_WARNING("Failed to bind PGMPStorageChild actor");
        return nullptr;
    }


    // Build our constructor message.
    UniquePtr<IPC::Message> msg__ = PGMP::Msg_PGMPStorageConstructor(MSG_ROUTING_CONTROL);
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), actor);
    // Sentinel = 'actor'
    ((&(writer__)))->WriteSentinel(102892058);




    // Notify the other side about the newly created actor. This can
    // fail if our manager has already been destroyed.
    //
    // NOTE: If the send call fails due to toplevel channel teardown,
    // the `IProtocol::ChannelSend` wrapper absorbs the error for us,
    // so we don't tear down actors unexpectedly.

    if (mozilla::ipc::LoggingEnabledFor("PGMP", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PGMPChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PGMP::Msg_PGMPStorageConstructor", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));


    // Warn, destroy the actor, and return null if the message failed to
    // send. Otherwise, return the successfully created actor reference.
    if (!sendok__) {
        NS_WARNING("Error sending PGMPStorageChild constructor");
        actor->ActorDisconnected(FailedConstructor);

        return nullptr;
    }
    return actor;
}

auto PGMPChild::SendPGMPContentChildDestroyed() -> bool
{
    UniquePtr<IPC::Message> msg__ = PGMP::Msg_PGMPContentChildDestroyed(MSG_ROUTING_CONTROL);
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};





    if (mozilla::ipc::LoggingEnabledFor("PGMP", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PGMPChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PGMP::Msg_PGMPContentChildDestroyed", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PGMPChild::SendFOGData(ByteBuf&& buf) -> bool
{
    UniquePtr<IPC::Message> msg__ = PGMP::Msg_FOGData(MSG_ROUTING_CONTROL);
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), std::move(buf));
    // Sentinel = 'buf'
    ((&(writer__)))->WriteSentinel(41484606);




    if (mozilla::ipc::LoggingEnabledFor("PGMP", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PGMPChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PGMP::Msg_FOGData", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PGMPChild::DeallocManagee(
        int32_t aProtocolId,
        IProtocol* aListener) -> void
{
    switch (aProtocolId) {
    case PGMPTimerMsgStart:
        static_cast<GMPChild*>(this)->DeallocPGMPTimerChild(static_cast<PGMPTimerChild*>(aListener));
        return;
    case PGMPStorageMsgStart:
        static_cast<GMPChild*>(this)->DeallocPGMPStorageChild(static_cast<PGMPStorageChild*>(aListener));
        return;
    default:
        FatalError("unreached");
        return;
    }
}

auto PGMPChild::OnMessageReceived(const Message& msg__) -> PGMPChild::Result
{
    int32_t route__ = msg__.routing_id();
    if (MSG_ROUTING_CONTROL != route__) {
        IProtocol* routed__ = Lookup(route__);
        if (!routed__ || !routed__->GetLifecycleProxy()) {
            if (mozilla::ipc::LoggingEnabledFor("PGMP", mozilla::ipc::ChildSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PGMPChild",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Ignored message for dead actor",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eSending);
            }
            return MsgProcessed;

        }

        RefPtr<mozilla::ipc::ActorLifecycleProxy> proxy__ =
            routed__->GetLifecycleProxy();
        return proxy__->Get()->OnMessageReceived(msg__);
    }

    switch (msg__.type()) {
    case PGMP::Reply_PGMPTimerConstructor__ID:
        {
            return MsgProcessed;
        }
    case PGMP::Reply_PGMPStorageConstructor__ID:
        {
            return MsgProcessed;
        }
    case PGMP::Msg_CrashPluginNow__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PGMP", mozilla::ipc::ChildSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PGMPChild",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PGMP::Msg_CrashPluginNow", OTHER);

            mozilla::ipc::IPCResult __ok = (static_cast<GMPChild*>(this))->RecvCrashPluginNow();
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PGMP::Msg_ProvideStorageId__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PGMP", mozilla::ipc::ChildSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PGMPChild",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PGMP::Msg_ProvideStorageId", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__storageId = IPC::ReadParam<nsCString>((&(reader__)));
            if (!maybe__storageId) {
                FatalError("Error deserializing 'nsCString'");
                return MsgValueError;

            }
            auto& storageId = *maybe__storageId;
            // Sentinel = 'storageId'
            if ((!(((&(reader__)))->ReadSentinel(319751075)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'nsCString'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::IPCResult __ok = (static_cast<GMPChild*>(this))->RecvProvideStorageId(std::move(storageId));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PGMP::Msg_PreloadLibs__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PGMP", mozilla::ipc::ChildSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PGMPChild",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PGMP::Msg_PreloadLibs", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__libs = IPC::ReadParam<nsCString>((&(reader__)));
            if (!maybe__libs) {
                FatalError("Error deserializing 'nsCString'");
                return MsgValueError;

            }
            auto& libs = *maybe__libs;
            // Sentinel = 'libs'
            if ((!(((&(reader__)))->ReadSentinel(69599659)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'nsCString'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::IPCResult __ok = (static_cast<GMPChild*>(this))->RecvPreloadLibs(std::move(libs));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PGMP::Msg_CloseActive__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PGMP", mozilla::ipc::ChildSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PGMPChild",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PGMP::Msg_CloseActive", OTHER);

            mozilla::ipc::IPCResult __ok = (static_cast<GMPChild*>(this))->RecvCloseActive();
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PGMP::Msg_InitGMPContentChild__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PGMP", mozilla::ipc::ChildSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PGMPChild",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PGMP::Msg_InitGMPContentChild", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__endpoint = IPC::ReadParam<Endpoint<::mozilla::gmp::PGMPContentChild>>((&(reader__)));
            if (!maybe__endpoint) {
                FatalError("Error deserializing 'Endpoint<::mozilla::gmp::PGMPContentChild>'");
                return MsgValueError;

            }
            auto& endpoint = *maybe__endpoint;
            // Sentinel = 'endpoint'
            if ((!(((&(reader__)))->ReadSentinel(251724642)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'Endpoint<::mozilla::gmp::PGMPContentChild>'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::IPCResult __ok = (static_cast<GMPChild*>(this))->RecvInitGMPContentChild(std::move(endpoint));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PGMP::Msg_InitProfiler__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PGMP", mozilla::ipc::ChildSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PGMPChild",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PGMP::Msg_InitProfiler", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__endpoint = IPC::ReadParam<Endpoint<::mozilla::PProfilerChild>>((&(reader__)));
            if (!maybe__endpoint) {
                FatalError("Error deserializing 'Endpoint<::mozilla::PProfilerChild>'");
                return MsgValueError;

            }
            auto& endpoint = *maybe__endpoint;
            // Sentinel = 'endpoint'
            if ((!(((&(reader__)))->ReadSentinel(251724642)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'Endpoint<::mozilla::PProfilerChild>'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::IPCResult __ok = (static_cast<GMPChild*>(this))->RecvInitProfiler(std::move(endpoint));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PGMP::Msg_PreferenceUpdate__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PGMP", mozilla::ipc::ChildSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PGMPChild",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PGMP::Msg_PreferenceUpdate", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__pref = IPC::ReadParam<Pref>((&(reader__)));
            if (!maybe__pref) {
                FatalError("Error deserializing 'Pref'");
                return MsgValueError;

            }
            auto& pref = *maybe__pref;
            // Sentinel = 'pref'
            if ((!(((&(reader__)))->ReadSentinel(71958958)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'Pref'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::IPCResult __ok = (static_cast<GMPChild*>(this))->RecvPreferenceUpdate(std::move(pref));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PGMP::Msg_FlushFOGData__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PGMP", mozilla::ipc::ChildSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PGMPChild",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PGMP::Msg_FlushFOGData", OTHER);

            int32_t id__ = MSG_ROUTING_CONTROL;
            UniquePtr<IPC::Message> reply__(PGMP::Reply_FlushFOGData(id__));
            reply__->set_seqno(msg__.seqno());

            RefPtr<mozilla::ipc::IPDLResolverInner> resolver__ =
                new mozilla::ipc::IPDLResolverInner(std::move(reply__), this);

            FlushFOGDataResolver resolver = [resolver__ = std::move(resolver__)](ByteBuf&& aParam) {
                resolver__->Resolve([&] (IPC::Message* reply__, IProtocol* self__) {
                    IPC::MessageWriter writer__(*reply__, self__);
                    IPC::WriteParam((&(writer__)), std::move(aParam));
                    // Sentinel = 'buf'
                    ((&(writer__)))->WriteSentinel(41484606);

                    if (mozilla::ipc::LoggingEnabledFor("PGMP", mozilla::ipc::ChildSide)) {
                        mozilla::ipc::LogMessageForProtocol(
                            "PGMPChild",
                            self__->ToplevelProtocol()->OtherPidMaybeInvalid(),
                            "Sending reply ",
                            reply__->type(),
                            mozilla::ipc::MessageDirection::eSending);
                    }

                });
            };
            mozilla::ipc::IPCResult __ok = (static_cast<GMPChild*>(this))->RecvFlushFOGData(std::move(resolver));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PGMP::Msg_TestTriggerMetrics__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PGMP", mozilla::ipc::ChildSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PGMPChild",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PGMP::Msg_TestTriggerMetrics", OTHER);

            int32_t id__ = MSG_ROUTING_CONTROL;
            UniquePtr<IPC::Message> reply__(PGMP::Reply_TestTriggerMetrics(id__));
            reply__->set_seqno(msg__.seqno());

            RefPtr<mozilla::ipc::IPDLResolverInner> resolver__ =
                new mozilla::ipc::IPDLResolverInner(std::move(reply__), this);

            TestTriggerMetricsResolver resolver = [resolver__ = std::move(resolver__)](const bool& aParam) {
                resolver__->Resolve([&] (IPC::Message* reply__, IProtocol* self__) {
                    IPC::MessageWriter writer__(*reply__, self__);
                    IPC::WriteParam((&(writer__)), aParam);
                    // Sentinel = 'unused'
                    ((&(writer__)))->WriteSentinel(155517589);

                    if (mozilla::ipc::LoggingEnabledFor("PGMP", mozilla::ipc::ChildSide)) {
                        mozilla::ipc::LogMessageForProtocol(
                            "PGMPChild",
                            self__->ToplevelProtocol()->OtherPidMaybeInvalid(),
                            "Sending reply ",
                            reply__->type(),
                            mozilla::ipc::MessageDirection::eSending);
                    }

                });
            };
            mozilla::ipc::IPCResult __ok = (static_cast<GMPChild*>(this))->RecvTestTriggerMetrics(std::move(resolver));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PGMP::Msg_Shutdown__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PGMP", mozilla::ipc::ChildSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PGMPChild",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PGMP::Msg_Shutdown", OTHER);

            int32_t id__ = MSG_ROUTING_CONTROL;
            UniquePtr<IPC::Message> reply__(PGMP::Reply_Shutdown(id__));
            reply__->set_seqno(msg__.seqno());

            RefPtr<mozilla::ipc::IPDLResolverInner> resolver__ =
                new mozilla::ipc::IPDLResolverInner(std::move(reply__), this);

            ShutdownResolver resolver = [resolver__ = std::move(resolver__)](const nsACString& aParam) {
                resolver__->Resolve([&] (IPC::Message* reply__, IProtocol* self__) {
                    IPC::MessageWriter writer__(*reply__, self__);
                    IPC::WriteParam((&(writer__)), aParam);
                    // Sentinel = 'profile'
                    ((&(writer__)))->WriteSentinel(201196274);

                    if (mozilla::ipc::LoggingEnabledFor("PGMP", mozilla::ipc::ChildSide)) {
                        mozilla::ipc::LogMessageForProtocol(
                            "PGMPChild",
                            self__->ToplevelProtocol()->OtherPidMaybeInvalid(),
                            "Sending reply ",
                            reply__->type(),
                            mozilla::ipc::MessageDirection::eSending);
                    }

                });
            };
            mozilla::ipc::IPCResult __ok = (static_cast<GMPChild*>(this))->RecvShutdown(std::move(resolver));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    default:
        return MsgNotKnown;
    case SHMEM_CREATED_MESSAGE_TYPE:
        {
            if (!ShmemCreated(msg__)) {
                return MsgPayloadError;
            }
            return MsgProcessed;
        }
    case SHMEM_DESTROYED_MESSAGE_TYPE:
        {
            if (!ShmemDestroyed(msg__)) {
                return MsgPayloadError;
            }
            return MsgProcessed;
        }
    }
}

auto PGMPChild::OnMessageReceived(
        const Message& msg__,
        UniquePtr<Message>& reply__) -> PGMPChild::Result
{
    int32_t route__ = msg__.routing_id();
    if (MSG_ROUTING_CONTROL != route__) {
        IProtocol* routed__ = Lookup(route__);
        if (!routed__ || !routed__->GetLifecycleProxy()) {
            return MsgDropped;

        }

        RefPtr<mozilla::ipc::ActorLifecycleProxy> proxy__ =
            routed__->GetLifecycleProxy();
        return proxy__->Get()->OnMessageReceived(msg__, reply__);
    }

    switch (msg__.type()) {
    case PGMP::Msg_StartPlugin__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PGMP", mozilla::ipc::ChildSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PGMPChild",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PGMP::Msg_StartPlugin", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__adapter = IPC::ReadParam<nsString>((&(reader__)));
            if (!maybe__adapter) {
                FatalError("Error deserializing 'nsString'");
                return MsgValueError;

            }
            auto& adapter = *maybe__adapter;
            // Sentinel = 'adapter'
            if ((!(((&(reader__)))->ReadSentinel(188941026)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'nsString'");
                return MsgValueError;
            }
            reader__.EndRead();
            int32_t id__ = MSG_ROUTING_CONTROL;
            mozilla::ipc::IPCResult __ok = (static_cast<GMPChild*>(this))->RecvStartPlugin(std::move(adapter));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            reply__ = PGMP::Reply_StartPlugin(id__);
            IPC::MessageWriter writer__{
                    (*(reply__)),
                    this};


            if (mozilla::ipc::LoggingEnabledFor("PGMP", mozilla::ipc::ChildSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PGMPChild",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Sending reply ",
                    reply__->type(),
                    mozilla::ipc::MessageDirection::eSending);
            }
            return MsgProcessed;
        }
    default:
        return MsgNotKnown;
    }
}



} // namespace gmp
} // namespace mozilla
namespace IPC {
auto ParamTraits<::mozilla::gmp::PGMPChild*>::Write(
        IPC::MessageWriter* aWriter,
        const paramType& aVar) -> void
{
    MOZ_RELEASE_ASSERT(
        aWriter->GetActor(),
        "Cannot serialize managed actors without an actor");

    int32_t id;
    if (!aVar) {
        id = 0;  // kNullActorId
    } else {
        id = aVar->Id();
        if (id == 1) {  // kFreedActorId
            aVar->FatalError("Actor has been |delete|d");
        }
        MOZ_RELEASE_ASSERT(
            aWriter->GetActor()->GetIPCChannel() == aVar->GetIPCChannel(),
            "Actor must be from the same channel as the"
            " actor it's being sent over");
        MOZ_RELEASE_ASSERT(
            aVar->CanSend(),
            "Actor must still be open when sending");
    }

    IPC::WriteParam(aWriter, id);
}

auto ParamTraits<::mozilla::gmp::PGMPChild*>::Read(IPC::MessageReader* aReader) -> IPC::ReadResult<paramType>
{
    MOZ_RELEASE_ASSERT(
        aReader->GetActor(),
        "Cannot deserialize managed actors without an actor");
    mozilla::Maybe<mozilla::ipc::IProtocol*> actor = aReader->GetActor()
        ->ReadActor(aReader, true, "PGMP", PGMPMsgStart);
    if (actor.isSome()) {
        return static_cast<::mozilla::gmp::PGMPChild*>(actor.ref());
    }
    return {};
}

} // namespace IPC
