//
// Automatically generated by ipdlc.
// Edit at your own risk
//


#include "mozilla/net/PGIOChannelChild.h"
#include "mozilla/AntiTrackingIPCUtils.h"
#include "mozilla/ProfilerLabels.h"
#include "mozilla/TimeStamp.h"
#include "mozilla/dom/DomSecurityIPCUtils.h"
#include "mozilla/dom/FeaturePolicyUtils.h"
#include "mozilla/dom/FetchIPCTypes.h"
#include "mozilla/dom/NavigationAPIIPCUtils.h"
#include "mozilla/dom/PropertyBagUtils.h"
#include "mozilla/dom/ReferrerInfoUtils.h"
#include "mozilla/dom/SessionHistoryEntry.h"
#include "mozilla/ipc/IPCCore.h"
#include "mozilla/ipc/URIUtils.h"
#include "mozilla/net/CacheInfoIPCTypes.h"
#include "mozilla/net/ClassOfService.h"
#include "nsDOMNavigationTiming.h"
#include "nsDocShellLoadState.h"
#include "nsHttp.h"
#include "nsHttpResponseHead.h"
#include "nsIPropertyBag2.h"

#include "mozilla/net/PNeckoChild.h"

#include "ipc/IPCMessageUtils.h"
#include "ipc/IPCMessageUtilsSpecializations.h"
#include "nsIFile.h"
#include "mozilla/ipc/Endpoint.h"
#include "mozilla/ipc/ProtocolMessageUtils.h"
#include "mozilla/ipc/ProtocolUtils.h"
#include "mozilla/ipc/ShmemMessageUtils.h"
#include "mozilla/ipc/TaintingIPCUtils.h"

namespace mozilla {
namespace net {


MOZ_IMPLICIT PGIOChannelChild::PGIOChannelChild() :
    mozilla::ipc::IProtocol(kProtocolId, mozilla::ipc::ChildSide)
{
    MOZ_COUNT_CTOR(PGIOChannelChild);
}

PGIOChannelChild::~PGIOChannelChild()
{
    MOZ_COUNT_DTOR(PGIOChannelChild);
}

auto PGIOChannelChild::ActorAlloc() -> void
{
}

auto PGIOChannelChild::ActorDealloc() -> void
{
    if (Manager()) {
        Manager()->DeallocManagee(kProtocolId, this);
    }
}

auto PGIOChannelChild::OtherPid() const -> ::base::ProcessId
{
    ::base::ProcessId pid =
        ::mozilla::ipc::IProtocol::ToplevelProtocol()->OtherPidMaybeInvalid();
    MOZ_RELEASE_ASSERT(pid != ::base::kInvalidProcessId);
    return pid;
}

auto PGIOChannelChild::OtherChildID() const -> ::GeckoChildID
{
    ::GeckoChildID childID =
        ::mozilla::ipc::IProtocol::ToplevelProtocol()->OtherChildIDMaybeInvalid();
    MOZ_RELEASE_ASSERT(childID != -1);
    return childID;
}

auto PGIOChannelChild::OtherEndpointProcInfo() const -> ::mozilla::ipc::EndpointProcInfo
{
    return ::mozilla::ipc::EndpointProcInfo{OtherPid(), OtherChildID()};
}

auto PGIOChannelChild::Manager() const -> PNeckoChild*
{
    return static_cast<PNeckoChild*>(IProtocol::Manager());
}

auto PGIOChannelChild::ManagedProtocolIds() const -> mozilla::Span<mozilla::ipc::ProtocolId const>
{
    return {};
}

auto PGIOChannelChild::GetManagedActors(mozilla::ipc::ProtocolId aProtocol) -> UntypedManagedContainer*
{
    switch (aProtocol) {
    default:
        return nullptr;
    }
}

auto PGIOChannelChild::Send__delete__(PGIOChannelChild* actor) -> bool
{
    if (!actor || !actor->CanSend()) {
        NS_WARNING("Attempt to __delete__ missing or closed actor");
        return false;
    }
    UniquePtr<IPC::Message> msg__ = PGIOChannel::Msg___delete__((actor)->Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            actor};




    if (mozilla::ipc::LoggingEnabledFor("PGIOChannel", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PGIOChannelChild",
            actor->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PGIOChannel::Msg___delete__", OTHER);

    bool sendok__ = (actor)->ChannelSend(std::move(msg__));

    actor->ActorDisconnected(Deletion);
    return sendok__;
}

auto PGIOChannelChild::SendCancel(const nsresult& status) -> bool
{
    UniquePtr<IPC::Message> msg__ = PGIOChannel::Msg_Cancel(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), status);
    // Sentinel = 'status'
    ((&(writer__)))->WriteSentinel(154731173);




    if (mozilla::ipc::LoggingEnabledFor("PGIOChannel", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PGIOChannelChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PGIOChannel::Msg_Cancel", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PGIOChannelChild::SendSuspend() -> bool
{
    UniquePtr<IPC::Message> msg__ = PGIOChannel::Msg_Suspend(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};





    if (mozilla::ipc::LoggingEnabledFor("PGIOChannel", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PGIOChannelChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PGIOChannel::Msg_Suspend", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PGIOChannelChild::SendResume() -> bool
{
    UniquePtr<IPC::Message> msg__ = PGIOChannel::Msg_Resume(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};





    if (mozilla::ipc::LoggingEnabledFor("PGIOChannel", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PGIOChannelChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PGIOChannel::Msg_Resume", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PGIOChannelChild::DeallocManagee(
        int32_t aProtocolId,
        IProtocol* aListener) -> void
{
    FatalError("unreached");
    return;
}

auto PGIOChannelChild::OnMessageReceived(const Message& msg__) -> PGIOChannelChild::Result
{
    switch (msg__.type()) {
    case MANAGED_ENDPOINT_BOUND_MESSAGE_TYPE:
        {
            if (!mAwaitingManagedEndpointBind) {
                NS_WARNING("Unexpected managed endpoint lifecycle message after actor bound!");
                return MsgNotAllowed;
            }
            mAwaitingManagedEndpointBind = false;
            return MsgProcessed;
        }
    case MANAGED_ENDPOINT_DROPPED_MESSAGE_TYPE:
        {
            if (!mAwaitingManagedEndpointBind) {
                NS_WARNING("Unexpected managed endpoint lifecycle message after actor bound!");
                return MsgNotAllowed;
            }
            mAwaitingManagedEndpointBind = false;
            this->ActorDisconnected(ManagedEndpointDropped);
            return MsgProcessed;
        }
    case PGIOChannel::Reply___delete____ID:
        {
            return MsgProcessed;
        }
    case PGIOChannel::Msg_OnStartRequest__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PGIOChannel", mozilla::ipc::ChildSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PGIOChannelChild",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PGIOChannel::Msg_OnStartRequest", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__aChannelStatus = IPC::ReadParam<nsresult>((&(reader__)));
            if (!maybe__aChannelStatus) {
                FatalError("Error deserializing 'nsresult'");
                return MsgValueError;

            }
            auto& aChannelStatus = *maybe__aChannelStatus;
            // Sentinel = 'aChannelStatus'
            if ((!(((&(reader__)))->ReadSentinel(679937439)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'nsresult'");
                return MsgValueError;
            }
            auto maybe__aContentLength = IPC::ReadParam<int64_t>((&(reader__)));
            if (!maybe__aContentLength) {
                FatalError("Error deserializing 'int64_t'");
                return MsgValueError;

            }
            auto& aContentLength = *maybe__aContentLength;
            // Sentinel = 'aContentLength'
            if ((!(((&(reader__)))->ReadSentinel(694158751)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'int64_t'");
                return MsgValueError;
            }
            auto maybe__aContentType = IPC::ReadParam<nsCString>((&(reader__)));
            if (!maybe__aContentType) {
                FatalError("Error deserializing 'nsCString'");
                return MsgValueError;

            }
            auto& aContentType = *maybe__aContentType;
            // Sentinel = 'aContentType'
            if ((!(((&(reader__)))->ReadSentinel(518522079)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'nsCString'");
                return MsgValueError;
            }
            auto maybe__aEntityID = IPC::ReadParam<nsCString>((&(reader__)));
            if (!maybe__aEntityID) {
                FatalError("Error deserializing 'nsCString'");
                return MsgValueError;

            }
            auto& aEntityID = *maybe__aEntityID;
            // Sentinel = 'aEntityID'
            if ((!(((&(reader__)))->ReadSentinel(292684652)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'nsCString'");
                return MsgValueError;
            }
            auto maybe__aURI = IPC::ReadParam<URIParams>((&(reader__)));
            if (!maybe__aURI) {
                FatalError("Error deserializing 'URIParams'");
                return MsgValueError;

            }
            auto& aURI = *maybe__aURI;
            // Sentinel = 'aURI'
            if ((!(((&(reader__)))->ReadSentinel(57934162)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'URIParams'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::IPCResult __ok = (this)->RecvOnStartRequest(std::move(aChannelStatus), std::move(aContentLength), std::move(aContentType), std::move(aEntityID), std::move(aURI));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PGIOChannel::Msg_OnDataAvailable__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PGIOChannel", mozilla::ipc::ChildSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PGIOChannelChild",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PGIOChannel::Msg_OnDataAvailable", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__channelStatus = IPC::ReadParam<nsresult>((&(reader__)));
            if (!maybe__channelStatus) {
                FatalError("Error deserializing 'nsresult'");
                return MsgValueError;

            }
            auto& channelStatus = *maybe__channelStatus;
            // Sentinel = 'channelStatus'
            if ((!(((&(reader__)))->ReadSentinel(618136926)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'nsresult'");
                return MsgValueError;
            }
            auto maybe__data = IPC::ReadParam<nsCString>((&(reader__)));
            if (!maybe__data) {
                FatalError("Error deserializing 'nsCString'");
                return MsgValueError;

            }
            auto& data = *maybe__data;
            // Sentinel = 'data'
            if ((!(((&(reader__)))->ReadSentinel(67109275)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'nsCString'");
                return MsgValueError;
            }
            auto maybe__offset = IPC::ReadParam<uint64_t>((&(reader__)));
            if (!maybe__offset) {
                FatalError("Error deserializing 'uint64_t'");
                return MsgValueError;

            }
            auto& offset = *maybe__offset;
            // Sentinel = 'offset'
            if ((!(((&(reader__)))->ReadSentinel(147653256)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'uint64_t'");
                return MsgValueError;
            }
            auto maybe__count = IPC::ReadParam<uint32_t>((&(reader__)));
            if (!maybe__count) {
                FatalError("Error deserializing 'uint32_t'");
                return MsgValueError;

            }
            auto& count = *maybe__count;
            // Sentinel = 'count'
            if ((!(((&(reader__)))->ReadSentinel(106889770)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'uint32_t'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::IPCResult __ok = (this)->RecvOnDataAvailable(std::move(channelStatus), std::move(data), std::move(offset), std::move(count));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PGIOChannel::Msg_OnStopRequest__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PGIOChannel", mozilla::ipc::ChildSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PGIOChannelChild",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PGIOChannel::Msg_OnStopRequest", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__channelStatus = IPC::ReadParam<nsresult>((&(reader__)));
            if (!maybe__channelStatus) {
                FatalError("Error deserializing 'nsresult'");
                return MsgValueError;

            }
            auto& channelStatus = *maybe__channelStatus;
            // Sentinel = 'channelStatus'
            if ((!(((&(reader__)))->ReadSentinel(618136926)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'nsresult'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::IPCResult __ok = (this)->RecvOnStopRequest(std::move(channelStatus));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PGIOChannel::Msg_FailedAsyncOpen__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PGIOChannel", mozilla::ipc::ChildSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PGIOChannelChild",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PGIOChannel::Msg_FailedAsyncOpen", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__statusCode = IPC::ReadParam<nsresult>((&(reader__)));
            if (!maybe__statusCode) {
                FatalError("Error deserializing 'nsresult'");
                return MsgValueError;

            }
            auto& statusCode = *maybe__statusCode;
            // Sentinel = 'statusCode'
            if ((!(((&(reader__)))->ReadSentinel(391316512)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'nsresult'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::IPCResult __ok = (this)->RecvFailedAsyncOpen(std::move(statusCode));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PGIOChannel::Msg_DeleteSelf__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PGIOChannel", mozilla::ipc::ChildSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PGIOChannelChild",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PGIOChannel::Msg_DeleteSelf", OTHER);

            mozilla::ipc::IPCResult __ok = (this)->RecvDeleteSelf();
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    default:
        return MsgNotKnown;
    }
}

auto PGIOChannelChild::OnMessageReceived(
        const Message& msg__,
        UniquePtr<Message>& reply__) -> PGIOChannelChild::Result
{
    return MsgNotKnown;
}



} // namespace net
} // namespace mozilla
namespace IPC {
auto ParamTraits<::mozilla::net::PGIOChannelChild*>::Write(
        IPC::MessageWriter* aWriter,
        const paramType& aVar) -> void
{
    MOZ_RELEASE_ASSERT(
        aWriter->GetActor(),
        "Cannot serialize managed actors without an actor");

    int32_t id;
    if (!aVar) {
        id = 0;  // kNullActorId
    } else {
        id = aVar->Id();
        if (id == 1) {  // kFreedActorId
            aVar->FatalError("Actor has been |delete|d");
        }
        MOZ_RELEASE_ASSERT(
            aWriter->GetActor()->GetIPCChannel() == aVar->GetIPCChannel(),
            "Actor must be from the same channel as the"
            " actor it's being sent over");
        MOZ_RELEASE_ASSERT(
            aVar->CanSend(),
            "Actor must still be open when sending");
    }

    IPC::WriteParam(aWriter, id);
}

auto ParamTraits<::mozilla::net::PGIOChannelChild*>::Read(IPC::MessageReader* aReader) -> IPC::ReadResult<paramType>
{
    MOZ_RELEASE_ASSERT(
        aReader->GetActor(),
        "Cannot deserialize managed actors without an actor");
    mozilla::Maybe<mozilla::ipc::IProtocol*> actor = aReader->GetActor()
        ->ReadActor(aReader, true, "PGIOChannel", PGIOChannelMsgStart);
    if (actor.isSome()) {
        return static_cast<::mozilla::net::PGIOChannelChild*>(actor.ref());
    }
    return {};
}

} // namespace IPC
