//
// Automatically generated by ipdlc.
// Edit at your own risk
//


#include "mozilla/dom/PFileSystemManagerParent.h"
#include "mozilla/ProfilerLabels.h"
#include "mozilla/RemoteLazyInputStream.h"
#include "mozilla/dom/FileSystemManagerParent.h"
#include "mozilla/ipc/IPCCore.h"

#include "mozilla/dom/PFileSystemAccessHandleParent.h"
#include "mozilla/dom/PFileSystemAccessHandleControlParent.h"
#include "mozilla/dom/PFileSystemWritableFileStreamParent.h"

#include "ipc/IPCMessageUtils.h"
#include "ipc/IPCMessageUtilsSpecializations.h"
#include "nsIFile.h"
#include "mozilla/ipc/Endpoint.h"
#include "mozilla/ipc/ProtocolMessageUtils.h"
#include "mozilla/ipc/ProtocolUtils.h"
#include "mozilla/ipc/ShmemMessageUtils.h"
#include "mozilla/ipc/TaintingIPCUtils.h"

namespace mozilla {
namespace dom {


auto PFileSystemManagerParent::ProcessingError(
        Result aCode,
        const char* aReason) -> void
{
}

auto PFileSystemManagerParent::ShouldContinueFromReplyTimeout() -> bool
{
    return true;
}

MOZ_IMPLICIT PFileSystemManagerParent::PFileSystemManagerParent() :
    mozilla::ipc::IToplevelProtocol("PFileSystemManagerParent", kProtocolId, mozilla::ipc::ParentSide)
{
    MOZ_COUNT_CTOR(PFileSystemManagerParent);
}

PFileSystemManagerParent::~PFileSystemManagerParent()
{
    MOZ_COUNT_DTOR(PFileSystemManagerParent);
}

auto PFileSystemManagerParent::ActorAlloc() -> void
{
    MOZ_RELEASE_ASSERT(XRE_IsParentProcess(), "Invalid process for `PFileSystemManagerParent'");
    AddRef();
}

auto PFileSystemManagerParent::ActorDealloc() -> void
{
    Release();
}

auto PFileSystemManagerParent::ManagedPFileSystemAccessHandleParent(nsTArray<PFileSystemAccessHandleParent*>& aArr) const -> void
{
    mManagedPFileSystemAccessHandleParent.ToArray(aArr);
}

auto PFileSystemManagerParent::ManagedPFileSystemAccessHandleParent() const -> const ManagedContainer<PFileSystemAccessHandleParent>&
{
    return mManagedPFileSystemAccessHandleParent;
}

auto PFileSystemManagerParent::ManagedPFileSystemWritableFileStreamParent(nsTArray<PFileSystemWritableFileStreamParent*>& aArr) const -> void
{
    mManagedPFileSystemWritableFileStreamParent.ToArray(aArr);
}

auto PFileSystemManagerParent::ManagedPFileSystemWritableFileStreamParent() const -> const ManagedContainer<PFileSystemWritableFileStreamParent>&
{
    return mManagedPFileSystemWritableFileStreamParent;
}

auto PFileSystemManagerParent::ManagedProtocolIds() const -> mozilla::Span<mozilla::ipc::ProtocolId const>
{
    static constexpr ::mozilla::ipc::ProtocolId sIds[] = {
        PFileSystemAccessHandleMsgStart,
        PFileSystemWritableFileStreamMsgStart
    };
    return sIds;
}

auto PFileSystemManagerParent::GetManagedActors(mozilla::ipc::ProtocolId aProtocol) -> UntypedManagedContainer*
{
    switch (aProtocol) {
    case PFileSystemAccessHandleMsgStart:
        return (&(mManagedPFileSystemAccessHandleParent));
    case PFileSystemWritableFileStreamMsgStart:
        return (&(mManagedPFileSystemWritableFileStreamParent));
    default:
        return nullptr;
    }
}

auto PFileSystemManagerParent::RejectPendingResponses(ResponseRejectReason aReason) -> void
{
    mAsyncCallbacks.RejectPendingResponses(aReason);
}

auto PFileSystemManagerParent::OpenPFileSystemAccessHandleEndpoint(PFileSystemAccessHandleParent* aActor) -> ManagedEndpoint<PFileSystemAccessHandleChild>
{
    if (!aActor) {
        NS_WARNING("Cannot bind null PFileSystemAccessHandleParent actor");
        return ManagedEndpoint<PFileSystemAccessHandleChild>();
    }

    if (!aActor->SetManagerAndRegister(this)) {
        NS_WARNING("Failed to bind PFileSystemAccessHandleParent actor");
        return ManagedEndpoint<PFileSystemAccessHandleChild>();
    }

    // Mark our actor as awaiting the other side to be bound. This will
    // be cleared when a `MANAGED_ENDPOINT_{DROPPED,BOUND}` message is
    // received.
    aActor->mAwaitingManagedEndpointBind = true;
    return ManagedEndpoint<PFileSystemAccessHandleChild>(mozilla::ipc::PrivateIPDLInterface(), aActor);
}

auto PFileSystemManagerParent::BindPFileSystemAccessHandleEndpoint(
        ManagedEndpoint<PFileSystemAccessHandleParent> aEndpoint,
        PFileSystemAccessHandleParent* aActor) -> bool
{
    return aEndpoint.Bind(mozilla::ipc::PrivateIPDLInterface(), aActor, this);
}

auto PFileSystemManagerParent::OpenPFileSystemWritableFileStreamEndpoint(PFileSystemWritableFileStreamParent* aActor) -> ManagedEndpoint<PFileSystemWritableFileStreamChild>
{
    if (!aActor) {
        NS_WARNING("Cannot bind null PFileSystemWritableFileStreamParent actor");
        return ManagedEndpoint<PFileSystemWritableFileStreamChild>();
    }

    if (!aActor->SetManagerAndRegister(this)) {
        NS_WARNING("Failed to bind PFileSystemWritableFileStreamParent actor");
        return ManagedEndpoint<PFileSystemWritableFileStreamChild>();
    }

    // Mark our actor as awaiting the other side to be bound. This will
    // be cleared when a `MANAGED_ENDPOINT_{DROPPED,BOUND}` message is
    // received.
    aActor->mAwaitingManagedEndpointBind = true;
    return ManagedEndpoint<PFileSystemWritableFileStreamChild>(mozilla::ipc::PrivateIPDLInterface(), aActor);
}

auto PFileSystemManagerParent::BindPFileSystemWritableFileStreamEndpoint(
        ManagedEndpoint<PFileSystemWritableFileStreamParent> aEndpoint,
        PFileSystemWritableFileStreamParent* aActor) -> bool
{
    return aEndpoint.Bind(mozilla::ipc::PrivateIPDLInterface(), aActor, this);
}

auto PFileSystemManagerParent::SendPFileSystemWritableFileStreamConstructor(PFileSystemWritableFileStreamParent* actor) -> PFileSystemWritableFileStreamParent*
{
    if (!actor) {
        NS_WARNING("Cannot bind null PFileSystemWritableFileStreamParent actor");
        return nullptr;
    }

    if (!actor->SetManagerAndRegister(this)) {
        NS_WARNING("Failed to bind PFileSystemWritableFileStreamParent actor");
        return nullptr;
    }


    // Build our constructor message.
    UniquePtr<IPC::Message> msg__ = PFileSystemManager::Msg_PFileSystemWritableFileStreamConstructor(MSG_ROUTING_CONTROL);
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), actor);
    // Sentinel = 'actor'
    ((&(writer__)))->WriteSentinel(102892058);




    // Notify the other side about the newly created actor. This can
    // fail if our manager has already been destroyed.
    //
    // NOTE: If the send call fails due to toplevel channel teardown,
    // the `IProtocol::ChannelSend` wrapper absorbs the error for us,
    // so we don't tear down actors unexpectedly.

    if (mozilla::ipc::LoggingEnabledFor("PFileSystemManager", mozilla::ipc::ParentSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PFileSystemManagerParent",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PFileSystemManager::Msg_PFileSystemWritableFileStreamConstructor", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));


    // Warn, destroy the actor, and return null if the message failed to
    // send. Otherwise, return the successfully created actor reference.
    if (!sendok__) {
        NS_WARNING("Error sending PFileSystemWritableFileStreamParent constructor");
        actor->ActorDisconnected(FailedConstructor);

        return nullptr;
    }
    return actor;
}

auto PFileSystemManagerParent::SendCloseAll(
        mozilla::ipc::ResolveCallback<nsresult>&& aResolve,
        mozilla::ipc::RejectCallback&& aReject) -> void
{
    UniquePtr<IPC::Message> msg__ = PFileSystemManager::Msg_CloseAll(MSG_ROUTING_CONTROL);
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};





    if (mozilla::ipc::LoggingEnabledFor("PFileSystemManager", mozilla::ipc::ParentSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PFileSystemManagerParent",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PFileSystemManager::Msg_CloseAll", OTHER);

    int32_t seqno__ = 0;
    if (ChannelSend(std::move(msg__), (&(seqno__)))) {
        mAsyncCallbacks.AddCallback(seqno__, PFileSystemManager::Reply_CloseAll__ID, [resolve=std::move(aResolve)](IPC::MessageReader* aReader) mutable {
            auto maybe__rv = IPC::ReadParam<nsresult>(aReader);
            if (!maybe__rv) {
                (aReader)->FatalError("Error deserializing 'nsresult'");
                return MsgValueError;

            }
            auto& rv = *maybe__rv;
            // Sentinel = 'rv'
            if ((!((aReader)->ReadSentinel(22806761)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'nsresult'");
                return MsgValueError;
            }


            aReader->EndRead();

            resolve(std::move(rv));
            return MsgProcessed;
        }, std::move(aReject));
    }
    else {
        aReject(::mozilla::ipc::ResponseRejectReason::SendError);
    }
    return;
}

auto PFileSystemManagerParent::SendCloseAll() -> RefPtr<CloseAllPromise>
{
    RefPtr<MozPromise<nsresult, ResponseRejectReason, true>::Private> promise__ = new MozPromise<nsresult, ResponseRejectReason, true>::Private(__func__);
    promise__->UseDirectTaskDispatch(__func__);
    SendCloseAll([promise__](nsresult&& aValue) {
        promise__->Resolve(std::move(aValue), __func__);
    }, [promise__](ResponseRejectReason&& aReason) {
        promise__->Reject(std::move(aReason), __func__);
    });
    return promise__;
}

auto PFileSystemManagerParent::DeallocManagee(
        int32_t aProtocolId,
        IProtocol* aListener) -> void
{
    switch (aProtocolId) {
    default:
        FatalError("unreached");
        return;
    }
}

auto PFileSystemManagerParent::OnMessageReceived(const Message& msg__) -> PFileSystemManagerParent::Result
{
    int32_t route__ = msg__.routing_id();
    if (MSG_ROUTING_CONTROL != route__) {
        IProtocol* routed__ = Lookup(route__);
        if (!routed__ || !routed__->GetLifecycleProxy()) {
            if (mozilla::ipc::LoggingEnabledFor("PFileSystemManager", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PFileSystemManagerParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Ignored message for dead actor",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eSending);
            }
            return MsgProcessed;

        }

        RefPtr<mozilla::ipc::ActorLifecycleProxy> proxy__ =
            routed__->GetLifecycleProxy();
        return proxy__->Get()->OnMessageReceived(msg__);
    }

    switch (msg__.type()) {
    case PFileSystemManager::Msg_GetRootHandle__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PFileSystemManager", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PFileSystemManagerParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PFileSystemManager::Msg_GetRootHandle", OTHER);

            int32_t id__ = MSG_ROUTING_CONTROL;
            UniquePtr<IPC::Message> reply__(PFileSystemManager::Reply_GetRootHandle(id__));
            reply__->set_seqno(msg__.seqno());

            RefPtr<mozilla::ipc::IPDLResolverInner> resolver__ =
                new mozilla::ipc::IPDLResolverInner(std::move(reply__), this);

            GetRootHandleResolver resolver = [resolver__ = std::move(resolver__)](const FileSystemGetHandleResponse& aParam) {
                resolver__->Resolve([&] (IPC::Message* reply__, IProtocol* self__) {
                    IPC::MessageWriter writer__(*reply__, self__);
                    IPC::WriteParam((&(writer__)), aParam);
                    // Sentinel = 'response'
                    ((&(writer__)))->WriteSentinel(260965232);

                    if (mozilla::ipc::LoggingEnabledFor("PFileSystemManager", mozilla::ipc::ParentSide)) {
                        mozilla::ipc::LogMessageForProtocol(
                            "PFileSystemManagerParent",
                            self__->ToplevelProtocol()->OtherPidMaybeInvalid(),
                            "Sending reply ",
                            reply__->type(),
                            mozilla::ipc::MessageDirection::eSending);
                    }

                });
            };
            mozilla::ipc::IPCResult __ok = (static_cast<FileSystemManagerParent*>(this))->RecvGetRootHandle(std::move(resolver));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PFileSystemManager::Msg_GetDirectoryHandle__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PFileSystemManager", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PFileSystemManagerParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PFileSystemManager::Msg_GetDirectoryHandle", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__request = IPC::ReadParam<FileSystemGetHandleRequest>((&(reader__)));
            if (!maybe__request) {
                FatalError("Error deserializing 'FileSystemGetHandleRequest'");
                return MsgValueError;

            }
            auto& request = *maybe__request;
            // Sentinel = 'request'
            if ((!(((&(reader__)))->ReadSentinel(202703626)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'FileSystemGetHandleRequest'");
                return MsgValueError;
            }
            reader__.EndRead();
            int32_t id__ = MSG_ROUTING_CONTROL;
            UniquePtr<IPC::Message> reply__(PFileSystemManager::Reply_GetDirectoryHandle(id__));
            reply__->set_seqno(msg__.seqno());

            RefPtr<mozilla::ipc::IPDLResolverInner> resolver__ =
                new mozilla::ipc::IPDLResolverInner(std::move(reply__), this);

            GetDirectoryHandleResolver resolver = [resolver__ = std::move(resolver__)](const FileSystemGetHandleResponse& aParam) {
                resolver__->Resolve([&] (IPC::Message* reply__, IProtocol* self__) {
                    IPC::MessageWriter writer__(*reply__, self__);
                    IPC::WriteParam((&(writer__)), aParam);
                    // Sentinel = 'handle'
                    ((&(writer__)))->WriteSentinel(142344813);

                    if (mozilla::ipc::LoggingEnabledFor("PFileSystemManager", mozilla::ipc::ParentSide)) {
                        mozilla::ipc::LogMessageForProtocol(
                            "PFileSystemManagerParent",
                            self__->ToplevelProtocol()->OtherPidMaybeInvalid(),
                            "Sending reply ",
                            reply__->type(),
                            mozilla::ipc::MessageDirection::eSending);
                    }

                });
            };
            mozilla::ipc::IPCResult __ok = (static_cast<FileSystemManagerParent*>(this))->RecvGetDirectoryHandle(std::move(request), std::move(resolver));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PFileSystemManager::Msg_GetFileHandle__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PFileSystemManager", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PFileSystemManagerParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PFileSystemManager::Msg_GetFileHandle", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__request = IPC::ReadParam<FileSystemGetHandleRequest>((&(reader__)));
            if (!maybe__request) {
                FatalError("Error deserializing 'FileSystemGetHandleRequest'");
                return MsgValueError;

            }
            auto& request = *maybe__request;
            // Sentinel = 'request'
            if ((!(((&(reader__)))->ReadSentinel(202703626)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'FileSystemGetHandleRequest'");
                return MsgValueError;
            }
            reader__.EndRead();
            int32_t id__ = MSG_ROUTING_CONTROL;
            UniquePtr<IPC::Message> reply__(PFileSystemManager::Reply_GetFileHandle(id__));
            reply__->set_seqno(msg__.seqno());

            RefPtr<mozilla::ipc::IPDLResolverInner> resolver__ =
                new mozilla::ipc::IPDLResolverInner(std::move(reply__), this);

            GetFileHandleResolver resolver = [resolver__ = std::move(resolver__)](const FileSystemGetHandleResponse& aParam) {
                resolver__->Resolve([&] (IPC::Message* reply__, IProtocol* self__) {
                    IPC::MessageWriter writer__(*reply__, self__);
                    IPC::WriteParam((&(writer__)), aParam);
                    // Sentinel = 'handle'
                    ((&(writer__)))->WriteSentinel(142344813);

                    if (mozilla::ipc::LoggingEnabledFor("PFileSystemManager", mozilla::ipc::ParentSide)) {
                        mozilla::ipc::LogMessageForProtocol(
                            "PFileSystemManagerParent",
                            self__->ToplevelProtocol()->OtherPidMaybeInvalid(),
                            "Sending reply ",
                            reply__->type(),
                            mozilla::ipc::MessageDirection::eSending);
                    }

                });
            };
            mozilla::ipc::IPCResult __ok = (static_cast<FileSystemManagerParent*>(this))->RecvGetFileHandle(std::move(request), std::move(resolver));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PFileSystemManager::Msg_GetFile__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PFileSystemManager", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PFileSystemManagerParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PFileSystemManager::Msg_GetFile", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__request = IPC::ReadParam<FileSystemGetFileRequest>((&(reader__)));
            if (!maybe__request) {
                FatalError("Error deserializing 'FileSystemGetFileRequest'");
                return MsgValueError;

            }
            auto& request = *maybe__request;
            // Sentinel = 'request'
            if ((!(((&(reader__)))->ReadSentinel(202703626)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'FileSystemGetFileRequest'");
                return MsgValueError;
            }
            reader__.EndRead();
            int32_t id__ = MSG_ROUTING_CONTROL;
            UniquePtr<IPC::Message> reply__(PFileSystemManager::Reply_GetFile(id__));
            reply__->set_seqno(msg__.seqno());

            RefPtr<mozilla::ipc::IPDLResolverInner> resolver__ =
                new mozilla::ipc::IPDLResolverInner(std::move(reply__), this);

            GetFileResolver resolver = [resolver__ = std::move(resolver__)](const FileSystemGetFileResponse& aParam) {
                resolver__->Resolve([&] (IPC::Message* reply__, IProtocol* self__) {
                    IPC::MessageWriter writer__(*reply__, self__);
                    IPC::WriteParam((&(writer__)), aParam);
                    // Sentinel = 'response'
                    ((&(writer__)))->WriteSentinel(260965232);

                    if (mozilla::ipc::LoggingEnabledFor("PFileSystemManager", mozilla::ipc::ParentSide)) {
                        mozilla::ipc::LogMessageForProtocol(
                            "PFileSystemManagerParent",
                            self__->ToplevelProtocol()->OtherPidMaybeInvalid(),
                            "Sending reply ",
                            reply__->type(),
                            mozilla::ipc::MessageDirection::eSending);
                    }

                });
            };
            mozilla::ipc::IPCResult __ok = (static_cast<FileSystemManagerParent*>(this))->RecvGetFile(std::move(request), std::move(resolver));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PFileSystemManager::Msg_GetAccessHandle__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PFileSystemManager", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PFileSystemManagerParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PFileSystemManager::Msg_GetAccessHandle", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__request = IPC::ReadParam<FileSystemGetAccessHandleRequest>((&(reader__)));
            if (!maybe__request) {
                FatalError("Error deserializing 'FileSystemGetAccessHandleRequest'");
                return MsgValueError;

            }
            auto& request = *maybe__request;
            // Sentinel = 'request'
            if ((!(((&(reader__)))->ReadSentinel(202703626)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'FileSystemGetAccessHandleRequest'");
                return MsgValueError;
            }
            reader__.EndRead();
            int32_t id__ = MSG_ROUTING_CONTROL;
            UniquePtr<IPC::Message> reply__(PFileSystemManager::Reply_GetAccessHandle(id__));
            reply__->set_seqno(msg__.seqno());

            RefPtr<mozilla::ipc::IPDLResolverInner> resolver__ =
                new mozilla::ipc::IPDLResolverInner(std::move(reply__), this);

            GetAccessHandleResolver resolver = [resolver__ = std::move(resolver__)](FileSystemGetAccessHandleResponse&& aParam) {
                resolver__->Resolve([&] (IPC::Message* reply__, IProtocol* self__) {
                    IPC::MessageWriter writer__(*reply__, self__);
                    IPC::WriteParam((&(writer__)), std::move(aParam));
                    // Sentinel = 'response'
                    ((&(writer__)))->WriteSentinel(260965232);

                    if (mozilla::ipc::LoggingEnabledFor("PFileSystemManager", mozilla::ipc::ParentSide)) {
                        mozilla::ipc::LogMessageForProtocol(
                            "PFileSystemManagerParent",
                            self__->ToplevelProtocol()->OtherPidMaybeInvalid(),
                            "Sending reply ",
                            reply__->type(),
                            mozilla::ipc::MessageDirection::eSending);
                    }

                });
            };
            mozilla::ipc::IPCResult __ok = (static_cast<FileSystemManagerParent*>(this))->RecvGetAccessHandle(std::move(request), std::move(resolver));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PFileSystemManager::Msg_GetWritable__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PFileSystemManager", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PFileSystemManagerParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PFileSystemManager::Msg_GetWritable", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__request = IPC::ReadParam<FileSystemGetWritableRequest>((&(reader__)));
            if (!maybe__request) {
                FatalError("Error deserializing 'FileSystemGetWritableRequest'");
                return MsgValueError;

            }
            auto& request = *maybe__request;
            // Sentinel = 'request'
            if ((!(((&(reader__)))->ReadSentinel(202703626)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'FileSystemGetWritableRequest'");
                return MsgValueError;
            }
            reader__.EndRead();
            int32_t id__ = MSG_ROUTING_CONTROL;
            UniquePtr<IPC::Message> reply__(PFileSystemManager::Reply_GetWritable(id__));
            reply__->set_seqno(msg__.seqno());

            RefPtr<mozilla::ipc::IPDLResolverInner> resolver__ =
                new mozilla::ipc::IPDLResolverInner(std::move(reply__), this);

            GetWritableResolver resolver = [resolver__ = std::move(resolver__)](FileSystemGetWritableFileStreamResponse&& aParam) {
                resolver__->Resolve([&] (IPC::Message* reply__, IProtocol* self__) {
                    IPC::MessageWriter writer__(*reply__, self__);
                    IPC::WriteParam((&(writer__)), std::move(aParam));
                    // Sentinel = 'fileData'
                    ((&(writer__)))->WriteSentinel(236192539);

                    if (mozilla::ipc::LoggingEnabledFor("PFileSystemManager", mozilla::ipc::ParentSide)) {
                        mozilla::ipc::LogMessageForProtocol(
                            "PFileSystemManagerParent",
                            self__->ToplevelProtocol()->OtherPidMaybeInvalid(),
                            "Sending reply ",
                            reply__->type(),
                            mozilla::ipc::MessageDirection::eSending);
                    }

                });
            };
            mozilla::ipc::IPCResult __ok = (static_cast<FileSystemManagerParent*>(this))->RecvGetWritable(std::move(request), std::move(resolver));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PFileSystemManager::Msg_Resolve__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PFileSystemManager", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PFileSystemManagerParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PFileSystemManager::Msg_Resolve", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__request = IPC::ReadParam<FileSystemResolveRequest>((&(reader__)));
            if (!maybe__request) {
                FatalError("Error deserializing 'FileSystemResolveRequest'");
                return MsgValueError;

            }
            auto& request = *maybe__request;
            // Sentinel = 'request'
            if ((!(((&(reader__)))->ReadSentinel(202703626)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'FileSystemResolveRequest'");
                return MsgValueError;
            }
            reader__.EndRead();
            int32_t id__ = MSG_ROUTING_CONTROL;
            UniquePtr<IPC::Message> reply__(PFileSystemManager::Reply_Resolve(id__));
            reply__->set_seqno(msg__.seqno());

            RefPtr<mozilla::ipc::IPDLResolverInner> resolver__ =
                new mozilla::ipc::IPDLResolverInner(std::move(reply__), this);

            ResolveResolver resolver = [resolver__ = std::move(resolver__)](const FileSystemResolveResponse& aParam) {
                resolver__->Resolve([&] (IPC::Message* reply__, IProtocol* self__) {
                    IPC::MessageWriter writer__(*reply__, self__);
                    IPC::WriteParam((&(writer__)), aParam);
                    // Sentinel = 'response'
                    ((&(writer__)))->WriteSentinel(260965232);

                    if (mozilla::ipc::LoggingEnabledFor("PFileSystemManager", mozilla::ipc::ParentSide)) {
                        mozilla::ipc::LogMessageForProtocol(
                            "PFileSystemManagerParent",
                            self__->ToplevelProtocol()->OtherPidMaybeInvalid(),
                            "Sending reply ",
                            reply__->type(),
                            mozilla::ipc::MessageDirection::eSending);
                    }

                });
            };
            mozilla::ipc::IPCResult __ok = (static_cast<FileSystemManagerParent*>(this))->RecvResolve(std::move(request), std::move(resolver));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PFileSystemManager::Msg_GetEntries__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PFileSystemManager", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PFileSystemManagerParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PFileSystemManager::Msg_GetEntries", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__request = IPC::ReadParam<FileSystemGetEntriesRequest>((&(reader__)));
            if (!maybe__request) {
                FatalError("Error deserializing 'FileSystemGetEntriesRequest'");
                return MsgValueError;

            }
            auto& request = *maybe__request;
            // Sentinel = 'request'
            if ((!(((&(reader__)))->ReadSentinel(202703626)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'FileSystemGetEntriesRequest'");
                return MsgValueError;
            }
            reader__.EndRead();
            int32_t id__ = MSG_ROUTING_CONTROL;
            UniquePtr<IPC::Message> reply__(PFileSystemManager::Reply_GetEntries(id__));
            reply__->set_seqno(msg__.seqno());

            RefPtr<mozilla::ipc::IPDLResolverInner> resolver__ =
                new mozilla::ipc::IPDLResolverInner(std::move(reply__), this);

            GetEntriesResolver resolver = [resolver__ = std::move(resolver__)](const FileSystemGetEntriesResponse& aParam) {
                resolver__->Resolve([&] (IPC::Message* reply__, IProtocol* self__) {
                    IPC::MessageWriter writer__(*reply__, self__);
                    IPC::WriteParam((&(writer__)), aParam);
                    // Sentinel = 'entries'
                    ((&(writer__)))->WriteSentinel(199361275);

                    if (mozilla::ipc::LoggingEnabledFor("PFileSystemManager", mozilla::ipc::ParentSide)) {
                        mozilla::ipc::LogMessageForProtocol(
                            "PFileSystemManagerParent",
                            self__->ToplevelProtocol()->OtherPidMaybeInvalid(),
                            "Sending reply ",
                            reply__->type(),
                            mozilla::ipc::MessageDirection::eSending);
                    }

                });
            };
            mozilla::ipc::IPCResult __ok = (static_cast<FileSystemManagerParent*>(this))->RecvGetEntries(std::move(request), std::move(resolver));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PFileSystemManager::Msg_RemoveEntry__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PFileSystemManager", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PFileSystemManagerParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PFileSystemManager::Msg_RemoveEntry", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__request = IPC::ReadParam<FileSystemRemoveEntryRequest>((&(reader__)));
            if (!maybe__request) {
                FatalError("Error deserializing 'FileSystemRemoveEntryRequest'");
                return MsgValueError;

            }
            auto& request = *maybe__request;
            // Sentinel = 'request'
            if ((!(((&(reader__)))->ReadSentinel(202703626)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'FileSystemRemoveEntryRequest'");
                return MsgValueError;
            }
            reader__.EndRead();
            int32_t id__ = MSG_ROUTING_CONTROL;
            UniquePtr<IPC::Message> reply__(PFileSystemManager::Reply_RemoveEntry(id__));
            reply__->set_seqno(msg__.seqno());

            RefPtr<mozilla::ipc::IPDLResolverInner> resolver__ =
                new mozilla::ipc::IPDLResolverInner(std::move(reply__), this);

            RemoveEntryResolver resolver = [resolver__ = std::move(resolver__)](const FileSystemRemoveEntryResponse& aParam) {
                resolver__->Resolve([&] (IPC::Message* reply__, IProtocol* self__) {
                    IPC::MessageWriter writer__(*reply__, self__);
                    IPC::WriteParam((&(writer__)), aParam);
                    // Sentinel = 'response'
                    ((&(writer__)))->WriteSentinel(260965232);

                    if (mozilla::ipc::LoggingEnabledFor("PFileSystemManager", mozilla::ipc::ParentSide)) {
                        mozilla::ipc::LogMessageForProtocol(
                            "PFileSystemManagerParent",
                            self__->ToplevelProtocol()->OtherPidMaybeInvalid(),
                            "Sending reply ",
                            reply__->type(),
                            mozilla::ipc::MessageDirection::eSending);
                    }

                });
            };
            mozilla::ipc::IPCResult __ok = (static_cast<FileSystemManagerParent*>(this))->RecvRemoveEntry(std::move(request), std::move(resolver));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PFileSystemManager::Msg_MoveEntry__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PFileSystemManager", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PFileSystemManagerParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PFileSystemManager::Msg_MoveEntry", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__request = IPC::ReadParam<FileSystemMoveEntryRequest>((&(reader__)));
            if (!maybe__request) {
                FatalError("Error deserializing 'FileSystemMoveEntryRequest'");
                return MsgValueError;

            }
            auto& request = *maybe__request;
            // Sentinel = 'request'
            if ((!(((&(reader__)))->ReadSentinel(202703626)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'FileSystemMoveEntryRequest'");
                return MsgValueError;
            }
            reader__.EndRead();
            int32_t id__ = MSG_ROUTING_CONTROL;
            UniquePtr<IPC::Message> reply__(PFileSystemManager::Reply_MoveEntry(id__));
            reply__->set_seqno(msg__.seqno());

            RefPtr<mozilla::ipc::IPDLResolverInner> resolver__ =
                new mozilla::ipc::IPDLResolverInner(std::move(reply__), this);

            MoveEntryResolver resolver = [resolver__ = std::move(resolver__)](const FileSystemMoveEntryResponse& aParam) {
                resolver__->Resolve([&] (IPC::Message* reply__, IProtocol* self__) {
                    IPC::MessageWriter writer__(*reply__, self__);
                    IPC::WriteParam((&(writer__)), aParam);
                    // Sentinel = 'response'
                    ((&(writer__)))->WriteSentinel(260965232);

                    if (mozilla::ipc::LoggingEnabledFor("PFileSystemManager", mozilla::ipc::ParentSide)) {
                        mozilla::ipc::LogMessageForProtocol(
                            "PFileSystemManagerParent",
                            self__->ToplevelProtocol()->OtherPidMaybeInvalid(),
                            "Sending reply ",
                            reply__->type(),
                            mozilla::ipc::MessageDirection::eSending);
                    }

                });
            };
            mozilla::ipc::IPCResult __ok = (static_cast<FileSystemManagerParent*>(this))->RecvMoveEntry(std::move(request), std::move(resolver));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PFileSystemManager::Msg_RenameEntry__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PFileSystemManager", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PFileSystemManagerParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PFileSystemManager::Msg_RenameEntry", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__request = IPC::ReadParam<FileSystemRenameEntryRequest>((&(reader__)));
            if (!maybe__request) {
                FatalError("Error deserializing 'FileSystemRenameEntryRequest'");
                return MsgValueError;

            }
            auto& request = *maybe__request;
            // Sentinel = 'request'
            if ((!(((&(reader__)))->ReadSentinel(202703626)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'FileSystemRenameEntryRequest'");
                return MsgValueError;
            }
            reader__.EndRead();
            int32_t id__ = MSG_ROUTING_CONTROL;
            UniquePtr<IPC::Message> reply__(PFileSystemManager::Reply_RenameEntry(id__));
            reply__->set_seqno(msg__.seqno());

            RefPtr<mozilla::ipc::IPDLResolverInner> resolver__ =
                new mozilla::ipc::IPDLResolverInner(std::move(reply__), this);

            RenameEntryResolver resolver = [resolver__ = std::move(resolver__)](const FileSystemMoveEntryResponse& aParam) {
                resolver__->Resolve([&] (IPC::Message* reply__, IProtocol* self__) {
                    IPC::MessageWriter writer__(*reply__, self__);
                    IPC::WriteParam((&(writer__)), aParam);
                    // Sentinel = 'response'
                    ((&(writer__)))->WriteSentinel(260965232);

                    if (mozilla::ipc::LoggingEnabledFor("PFileSystemManager", mozilla::ipc::ParentSide)) {
                        mozilla::ipc::LogMessageForProtocol(
                            "PFileSystemManagerParent",
                            self__->ToplevelProtocol()->OtherPidMaybeInvalid(),
                            "Sending reply ",
                            reply__->type(),
                            mozilla::ipc::MessageDirection::eSending);
                    }

                });
            };
            mozilla::ipc::IPCResult __ok = (static_cast<FileSystemManagerParent*>(this))->RecvRenameEntry(std::move(request), std::move(resolver));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PFileSystemManager::Reply_PFileSystemWritableFileStreamConstructor__ID:
        {
            return MsgProcessed;
        }
    case PFileSystemManager::Reply_CloseAll__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PFileSystemManager", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PFileSystemManagerParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }

            AUTO_PROFILER_LABEL("PFileSystemManager::Msg_CloseAll", OTHER);


            return mAsyncCallbacks.GotReply(this, msg__);
        }
    default:
        return MsgNotKnown;
    case SHMEM_CREATED_MESSAGE_TYPE:
        {
            if (!ShmemCreated(msg__)) {
                return MsgPayloadError;
            }
            return MsgProcessed;
        }
    case SHMEM_DESTROYED_MESSAGE_TYPE:
        {
            if (!ShmemDestroyed(msg__)) {
                return MsgPayloadError;
            }
            return MsgProcessed;
        }
    }
}

auto PFileSystemManagerParent::OnMessageReceived(
        const Message& msg__,
        UniquePtr<Message>& reply__) -> PFileSystemManagerParent::Result
{
    MOZ_ASSERT_UNREACHABLE("message protocol not supported");
    return MsgNotKnown;
}



} // namespace dom
} // namespace mozilla
namespace IPC {
auto ParamTraits<::mozilla::dom::PFileSystemManagerParent*>::Write(
        IPC::MessageWriter* aWriter,
        const paramType& aVar) -> void
{
    MOZ_RELEASE_ASSERT(
        aWriter->GetActor(),
        "Cannot serialize managed actors without an actor");

    int32_t id;
    if (!aVar) {
        id = 0;  // kNullActorId
    } else {
        id = aVar->Id();
        if (id == 1) {  // kFreedActorId
            aVar->FatalError("Actor has been |delete|d");
        }
        MOZ_RELEASE_ASSERT(
            aWriter->GetActor()->GetIPCChannel() == aVar->GetIPCChannel(),
            "Actor must be from the same channel as the"
            " actor it's being sent over");
        MOZ_RELEASE_ASSERT(
            aVar->CanSend(),
            "Actor must still be open when sending");
    }

    IPC::WriteParam(aWriter, id);
}

auto ParamTraits<::mozilla::dom::PFileSystemManagerParent*>::Read(IPC::MessageReader* aReader) -> IPC::ReadResult<paramType>
{
    MOZ_RELEASE_ASSERT(
        aReader->GetActor(),
        "Cannot deserialize managed actors without an actor");
    mozilla::Maybe<mozilla::ipc::IProtocol*> actor = aReader->GetActor()
        ->ReadActor(aReader, true, "PFileSystemManager", PFileSystemManagerMsgStart);
    if (actor.isSome()) {
        return static_cast<::mozilla::dom::PFileSystemManagerParent*>(actor.ref());
    }
    return {};
}

} // namespace IPC
