//
// Automatically generated by ipdlc.
// Edit at your own risk
//


#include "mozilla/a11y/PDocAccessibleParent.h"
#include "mozilla/GfxMessageUtils.h"
#include "mozilla/ProfilerLabels.h"

#include "mozilla/dom/PBrowserParent.h"

#include "ipc/IPCMessageUtils.h"
#include "ipc/IPCMessageUtilsSpecializations.h"
#include "nsIFile.h"
#include "mozilla/ipc/Endpoint.h"
#include "mozilla/ipc/ProtocolMessageUtils.h"
#include "mozilla/ipc/ProtocolUtils.h"
#include "mozilla/ipc/ShmemMessageUtils.h"
#include "mozilla/ipc/TaintingIPCUtils.h"

namespace mozilla {
namespace a11y {


MOZ_IMPLICIT PDocAccessibleParent::PDocAccessibleParent() :
    mozilla::ipc::IProtocol(kProtocolId, mozilla::ipc::ParentSide)
{
    MOZ_COUNT_CTOR(PDocAccessibleParent);
}

PDocAccessibleParent::~PDocAccessibleParent()
{
    MOZ_COUNT_DTOR(PDocAccessibleParent);
}

auto PDocAccessibleParent::ActorAlloc() -> void
{
}

auto PDocAccessibleParent::ActorDealloc() -> void
{
    if (Manager()) {
        Manager()->DeallocManagee(kProtocolId, this);
    }
}

auto PDocAccessibleParent::OtherPid() const -> ::base::ProcessId
{
    ::base::ProcessId pid =
        ::mozilla::ipc::IProtocol::ToplevelProtocol()->OtherPidMaybeInvalid();
    MOZ_RELEASE_ASSERT(pid != ::base::kInvalidProcessId);
    return pid;
}

auto PDocAccessibleParent::OtherChildID() const -> ::GeckoChildID
{
    ::GeckoChildID childID =
        ::mozilla::ipc::IProtocol::ToplevelProtocol()->OtherChildIDMaybeInvalid();
    MOZ_RELEASE_ASSERT(childID != -1);
    return childID;
}

auto PDocAccessibleParent::OtherEndpointProcInfo() const -> ::mozilla::ipc::EndpointProcInfo
{
    return ::mozilla::ipc::EndpointProcInfo{OtherPid(), OtherChildID()};
}

auto PDocAccessibleParent::Manager() const -> PBrowserParent*
{
    return static_cast<PBrowserParent*>(IProtocol::Manager());
}

auto PDocAccessibleParent::ManagedProtocolIds() const -> mozilla::Span<mozilla::ipc::ProtocolId const>
{
    return {};
}

auto PDocAccessibleParent::GetManagedActors(mozilla::ipc::ProtocolId aProtocol) -> UntypedManagedContainer*
{
    switch (aProtocol) {
    default:
        return nullptr;
    }
}

auto PDocAccessibleParent::Send__delete__(PDocAccessibleParent* actor) -> bool
{
    if (!actor || !actor->CanSend()) {
        NS_WARNING("Attempt to __delete__ missing or closed actor");
        return false;
    }
    UniquePtr<IPC::Message> msg__ = PDocAccessible::Msg___delete__((actor)->Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            actor};




    if (mozilla::ipc::LoggingEnabledFor("PDocAccessible", mozilla::ipc::ParentSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PDocAccessibleParent",
            actor->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PDocAccessible::Msg___delete__", OTHER);

    bool sendok__ = (actor)->ChannelSend(std::move(msg__));

    actor->ActorDisconnected(Deletion);
    return sendok__;
}

auto PDocAccessibleParent::SendRestoreFocus() -> bool
{
    UniquePtr<IPC::Message> msg__ = PDocAccessible::Msg_RestoreFocus(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};





    if (mozilla::ipc::LoggingEnabledFor("PDocAccessible", mozilla::ipc::ParentSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PDocAccessibleParent",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PDocAccessible::Msg_RestoreFocus", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PDocAccessibleParent::SendScrollTo(
        const uint64_t& aID,
        const uint32_t& aScrollType) -> bool
{
    UniquePtr<IPC::Message> msg__ = PDocAccessible::Msg_ScrollTo(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), aID);
    // Sentinel = 'aID'
    ((&(writer__)))->WriteSentinel(33292527);
    IPC::WriteParam((&(writer__)), aScrollType);
    // Sentinel = 'aScrollType'
    ((&(writer__)))->WriteSentinel(439092339);




    if (mozilla::ipc::LoggingEnabledFor("PDocAccessible", mozilla::ipc::ParentSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PDocAccessibleParent",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PDocAccessible::Msg_ScrollTo", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PDocAccessibleParent::SendScrollToPoint(
        const uint64_t& aID,
        const uint32_t& aScrollType,
        const int32_t& aX,
        const int32_t& aY) -> bool
{
    UniquePtr<IPC::Message> msg__ = PDocAccessible::Msg_ScrollToPoint(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), aID);
    // Sentinel = 'aID'
    ((&(writer__)))->WriteSentinel(33292527);
    IPC::WriteParam((&(writer__)), aScrollType);
    // Sentinel = 'aScrollType'
    ((&(writer__)))->WriteSentinel(439092339);
    IPC::WriteParam((&(writer__)), aX);
    // Sentinel = 'aX'
    ((&(writer__)))->WriteSentinel(18612410);
    IPC::WriteParam((&(writer__)), aY);
    // Sentinel = 'aY'
    ((&(writer__)))->WriteSentinel(18677947);




    if (mozilla::ipc::LoggingEnabledFor("PDocAccessible", mozilla::ipc::ParentSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PDocAccessibleParent",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PDocAccessible::Msg_ScrollToPoint", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PDocAccessibleParent::SendAnnounce(
        const uint64_t& aID,
        const nsAString& aAnnouncement,
        const uint16_t& aPriority) -> bool
{
    UniquePtr<IPC::Message> msg__ = PDocAccessible::Msg_Announce(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), aID);
    // Sentinel = 'aID'
    ((&(writer__)))->WriteSentinel(33292527);
    IPC::WriteParam((&(writer__)), aAnnouncement);
    // Sentinel = 'aAnnouncement'
    ((&(writer__)))->WriteSentinel(605750605);
    IPC::WriteParam((&(writer__)), aPriority);
    // Sentinel = 'aPriority'
    ((&(writer__)))->WriteSentinel(303367108);




    if (mozilla::ipc::LoggingEnabledFor("PDocAccessible", mozilla::ipc::ParentSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PDocAccessibleParent",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PDocAccessible::Msg_Announce", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PDocAccessibleParent::SendSetTextSelection(
        const uint64_t& aStartID,
        const int32_t& aStartOffset,
        const uint64_t& aEndID,
        const int32_t& aEndOffset,
        const int32_t& aSelectionNum) -> bool
{
    UniquePtr<IPC::Message> msg__ = PDocAccessible::Msg_SetTextSelection(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), aStartID);
    // Sentinel = 'aStartID'
    ((&(writer__)))->WriteSentinel(233571069);
    IPC::WriteParam((&(writer__)), aStartOffset);
    // Sentinel = 'aStartOffset'
    ((&(writer__)))->WriteSentinel(517801175);
    IPC::WriteParam((&(writer__)), aEndID);
    // Sentinel = 'aEndID'
    ((&(writer__)))->WriteSentinel(123666950);
    IPC::WriteParam((&(writer__)), aEndOffset);
    // Sentinel = 'aEndOffset'
    ((&(writer__)))->WriteSentinel(343147488);
    IPC::WriteParam((&(writer__)), aSelectionNum);
    // Sentinel = 'aSelectionNum'
    ((&(writer__)))->WriteSentinel(601359672);




    if (mozilla::ipc::LoggingEnabledFor("PDocAccessible", mozilla::ipc::ParentSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PDocAccessibleParent",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PDocAccessible::Msg_SetTextSelection", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PDocAccessibleParent::SendRemoveTextSelection(
        const uint64_t& aID,
        const int32_t& aSelectionNum) -> bool
{
    UniquePtr<IPC::Message> msg__ = PDocAccessible::Msg_RemoveTextSelection(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), aID);
    // Sentinel = 'aID'
    ((&(writer__)))->WriteSentinel(33292527);
    IPC::WriteParam((&(writer__)), aSelectionNum);
    // Sentinel = 'aSelectionNum'
    ((&(writer__)))->WriteSentinel(601359672);




    if (mozilla::ipc::LoggingEnabledFor("PDocAccessible", mozilla::ipc::ParentSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PDocAccessibleParent",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PDocAccessible::Msg_RemoveTextSelection", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PDocAccessibleParent::SendScrollTextLeafRangeIntoView(
        const uint64_t& aStartID,
        const int32_t& aStartOffset,
        const uint64_t& aEndID,
        const int32_t& aEndOffset,
        const uint32_t& aScrollType) -> bool
{
    UniquePtr<IPC::Message> msg__ = PDocAccessible::Msg_ScrollTextLeafRangeIntoView(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), aStartID);
    // Sentinel = 'aStartID'
    ((&(writer__)))->WriteSentinel(233571069);
    IPC::WriteParam((&(writer__)), aStartOffset);
    // Sentinel = 'aStartOffset'
    ((&(writer__)))->WriteSentinel(517801175);
    IPC::WriteParam((&(writer__)), aEndID);
    // Sentinel = 'aEndID'
    ((&(writer__)))->WriteSentinel(123666950);
    IPC::WriteParam((&(writer__)), aEndOffset);
    // Sentinel = 'aEndOffset'
    ((&(writer__)))->WriteSentinel(343147488);
    IPC::WriteParam((&(writer__)), aScrollType);
    // Sentinel = 'aScrollType'
    ((&(writer__)))->WriteSentinel(439092339);




    if (mozilla::ipc::LoggingEnabledFor("PDocAccessible", mozilla::ipc::ParentSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PDocAccessibleParent",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PDocAccessible::Msg_ScrollTextLeafRangeIntoView", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PDocAccessibleParent::SendScrollSubstringToPoint(
        const uint64_t& aID,
        const int32_t& aStartOffset,
        const int32_t& aEndOffset,
        const uint32_t& aCoordinateType,
        const int32_t& aX,
        const int32_t& aY) -> bool
{
    UniquePtr<IPC::Message> msg__ = PDocAccessible::Msg_ScrollSubstringToPoint(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), aID);
    // Sentinel = 'aID'
    ((&(writer__)))->WriteSentinel(33292527);
    IPC::WriteParam((&(writer__)), aStartOffset);
    // Sentinel = 'aStartOffset'
    ((&(writer__)))->WriteSentinel(517801175);
    IPC::WriteParam((&(writer__)), aEndOffset);
    // Sentinel = 'aEndOffset'
    ((&(writer__)))->WriteSentinel(343147488);
    IPC::WriteParam((&(writer__)), aCoordinateType);
    // Sentinel = 'aCoordinateType'
    ((&(writer__)))->WriteSentinel(797312524);
    IPC::WriteParam((&(writer__)), aX);
    // Sentinel = 'aX'
    ((&(writer__)))->WriteSentinel(18612410);
    IPC::WriteParam((&(writer__)), aY);
    // Sentinel = 'aY'
    ((&(writer__)))->WriteSentinel(18677947);




    if (mozilla::ipc::LoggingEnabledFor("PDocAccessible", mozilla::ipc::ParentSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PDocAccessibleParent",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PDocAccessible::Msg_ScrollSubstringToPoint", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PDocAccessibleParent::SendReplaceText(
        const uint64_t& aID,
        const nsAString& aText) -> bool
{
    UniquePtr<IPC::Message> msg__ = PDocAccessible::Msg_ReplaceText(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), aID);
    // Sentinel = 'aID'
    ((&(writer__)))->WriteSentinel(33292527);
    IPC::WriteParam((&(writer__)), aText);
    // Sentinel = 'aText'
    ((&(writer__)))->WriteSentinel(97321479);




    if (mozilla::ipc::LoggingEnabledFor("PDocAccessible", mozilla::ipc::ParentSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PDocAccessibleParent",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PDocAccessible::Msg_ReplaceText", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PDocAccessibleParent::SendInsertText(
        const uint64_t& aID,
        const nsAString& aText,
        const int32_t& aPosition) -> bool
{
    UniquePtr<IPC::Message> msg__ = PDocAccessible::Msg_InsertText(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), aID);
    // Sentinel = 'aID'
    ((&(writer__)))->WriteSentinel(33292527);
    IPC::WriteParam((&(writer__)), aText);
    // Sentinel = 'aText'
    ((&(writer__)))->WriteSentinel(97321479);
    IPC::WriteParam((&(writer__)), aPosition);
    // Sentinel = 'aPosition'
    ((&(writer__)))->WriteSentinel(303104951);




    if (mozilla::ipc::LoggingEnabledFor("PDocAccessible", mozilla::ipc::ParentSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PDocAccessibleParent",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PDocAccessible::Msg_InsertText", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PDocAccessibleParent::SendCopyText(
        const uint64_t& aID,
        const int32_t& aStartPos,
        const int32_t& aEndPos) -> bool
{
    UniquePtr<IPC::Message> msg__ = PDocAccessible::Msg_CopyText(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), aID);
    // Sentinel = 'aID'
    ((&(writer__)))->WriteSentinel(33292527);
    IPC::WriteParam((&(writer__)), aStartPos);
    // Sentinel = 'aStartPos'
    ((&(writer__)))->WriteSentinel(298255266);
    IPC::WriteParam((&(writer__)), aEndPos);
    // Sentinel = 'aEndPos'
    ((&(writer__)))->WriteSentinel(172163755);




    if (mozilla::ipc::LoggingEnabledFor("PDocAccessible", mozilla::ipc::ParentSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PDocAccessibleParent",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PDocAccessible::Msg_CopyText", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PDocAccessibleParent::SendCutText(
        const uint64_t& aID,
        const int32_t& aStartPos,
        const int32_t& aEndPos) -> bool
{
    UniquePtr<IPC::Message> msg__ = PDocAccessible::Msg_CutText(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), aID);
    // Sentinel = 'aID'
    ((&(writer__)))->WriteSentinel(33292527);
    IPC::WriteParam((&(writer__)), aStartPos);
    // Sentinel = 'aStartPos'
    ((&(writer__)))->WriteSentinel(298255266);
    IPC::WriteParam((&(writer__)), aEndPos);
    // Sentinel = 'aEndPos'
    ((&(writer__)))->WriteSentinel(172163755);




    if (mozilla::ipc::LoggingEnabledFor("PDocAccessible", mozilla::ipc::ParentSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PDocAccessibleParent",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PDocAccessible::Msg_CutText", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PDocAccessibleParent::SendDeleteText(
        const uint64_t& aID,
        const int32_t& aStartPos,
        const int32_t& aEndPos) -> bool
{
    UniquePtr<IPC::Message> msg__ = PDocAccessible::Msg_DeleteText(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), aID);
    // Sentinel = 'aID'
    ((&(writer__)))->WriteSentinel(33292527);
    IPC::WriteParam((&(writer__)), aStartPos);
    // Sentinel = 'aStartPos'
    ((&(writer__)))->WriteSentinel(298255266);
    IPC::WriteParam((&(writer__)), aEndPos);
    // Sentinel = 'aEndPos'
    ((&(writer__)))->WriteSentinel(172163755);




    if (mozilla::ipc::LoggingEnabledFor("PDocAccessible", mozilla::ipc::ParentSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PDocAccessibleParent",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PDocAccessible::Msg_DeleteText", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PDocAccessibleParent::SendPasteText(
        const uint64_t& aID,
        const int32_t& aPosition) -> bool
{
    UniquePtr<IPC::Message> msg__ = PDocAccessible::Msg_PasteText(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), aID);
    // Sentinel = 'aID'
    ((&(writer__)))->WriteSentinel(33292527);
    IPC::WriteParam((&(writer__)), aPosition);
    // Sentinel = 'aPosition'
    ((&(writer__)))->WriteSentinel(303104951);




    if (mozilla::ipc::LoggingEnabledFor("PDocAccessible", mozilla::ipc::ParentSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PDocAccessibleParent",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PDocAccessible::Msg_PasteText", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PDocAccessibleParent::SendTakeSelection(const uint64_t& aID) -> bool
{
    UniquePtr<IPC::Message> msg__ = PDocAccessible::Msg_TakeSelection(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), aID);
    // Sentinel = 'aID'
    ((&(writer__)))->WriteSentinel(33292527);




    if (mozilla::ipc::LoggingEnabledFor("PDocAccessible", mozilla::ipc::ParentSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PDocAccessibleParent",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PDocAccessible::Msg_TakeSelection", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PDocAccessibleParent::SendSetSelected(
        const uint64_t& aID,
        const bool& aSelected) -> bool
{
    UniquePtr<IPC::Message> msg__ = PDocAccessible::Msg_SetSelected(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), aID);
    // Sentinel = 'aID'
    ((&(writer__)))->WriteSentinel(33292527);
    IPC::WriteParam((&(writer__)), aSelected);
    // Sentinel = 'aSelected'
    ((&(writer__)))->WriteSentinel(291767179);




    if (mozilla::ipc::LoggingEnabledFor("PDocAccessible", mozilla::ipc::ParentSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PDocAccessibleParent",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PDocAccessible::Msg_SetSelected", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PDocAccessibleParent::SendDoActionAsync(
        const uint64_t& aID,
        const uint8_t& aIndex) -> bool
{
    UniquePtr<IPC::Message> msg__ = PDocAccessible::Msg_DoActionAsync(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), aID);
    // Sentinel = 'aID'
    ((&(writer__)))->WriteSentinel(33292527);
    IPC::WriteParam((&(writer__)), aIndex);
    // Sentinel = 'aIndex'
    ((&(writer__)))->WriteSentinel(132055642);




    if (mozilla::ipc::LoggingEnabledFor("PDocAccessible", mozilla::ipc::ParentSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PDocAccessibleParent",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PDocAccessible::Msg_DoActionAsync", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PDocAccessibleParent::SendSetCurValue(
        const uint64_t& aID,
        const double& aValue) -> bool
{
    UniquePtr<IPC::Message> msg__ = PDocAccessible::Msg_SetCurValue(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), aID);
    // Sentinel = 'aID'
    ((&(writer__)))->WriteSentinel(33292527);
    IPC::WriteParam((&(writer__)), aValue);
    // Sentinel = 'aValue'
    ((&(writer__)))->WriteSentinel(135332447);




    if (mozilla::ipc::LoggingEnabledFor("PDocAccessible", mozilla::ipc::ParentSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PDocAccessibleParent",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PDocAccessible::Msg_SetCurValue", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PDocAccessibleParent::SendTakeFocus(const uint64_t& aID) -> bool
{
    UniquePtr<IPC::Message> msg__ = PDocAccessible::Msg_TakeFocus(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), aID);
    // Sentinel = 'aID'
    ((&(writer__)))->WriteSentinel(33292527);




    if (mozilla::ipc::LoggingEnabledFor("PDocAccessible", mozilla::ipc::ParentSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PDocAccessibleParent",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PDocAccessible::Msg_TakeFocus", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PDocAccessibleParent::SendVerifyCache(
        const uint64_t& aID,
        const uint64_t& aCacheDomain,
        AccAttributes* aFields) -> bool
{
    UniquePtr<IPC::Message> msg__ = PDocAccessible::Msg_VerifyCache(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), aID);
    // Sentinel = 'aID'
    ((&(writer__)))->WriteSentinel(33292527);
    IPC::WriteParam((&(writer__)), aCacheDomain);
    // Sentinel = 'aCacheDomain'
    ((&(writer__)))->WriteSentinel(479921294);
    IPC::WriteParam((&(writer__)), aFields);
    // Sentinel = 'aFields'
    ((&(writer__)))->WriteSentinel(175243961);




    if (mozilla::ipc::LoggingEnabledFor("PDocAccessible", mozilla::ipc::ParentSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PDocAccessibleParent",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PDocAccessible::Msg_VerifyCache", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PDocAccessibleParent::SendAckMutationEvents() -> bool
{
    UniquePtr<IPC::Message> msg__ = PDocAccessible::Msg_AckMutationEvents(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};





    if (mozilla::ipc::LoggingEnabledFor("PDocAccessible", mozilla::ipc::ParentSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PDocAccessibleParent",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PDocAccessible::Msg_AckMutationEvents", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PDocAccessibleParent::DeallocManagee(
        int32_t aProtocolId,
        IProtocol* aListener) -> void
{
    FatalError("unreached");
    return;
}

auto PDocAccessibleParent::OnMessageReceived(const Message& msg__) -> PDocAccessibleParent::Result
{
    switch (msg__.type()) {
    case MANAGED_ENDPOINT_BOUND_MESSAGE_TYPE:
        {
            if (!mAwaitingManagedEndpointBind) {
                NS_WARNING("Unexpected managed endpoint lifecycle message after actor bound!");
                return MsgNotAllowed;
            }
            mAwaitingManagedEndpointBind = false;
            return MsgProcessed;
        }
    case MANAGED_ENDPOINT_DROPPED_MESSAGE_TYPE:
        {
            if (!mAwaitingManagedEndpointBind) {
                NS_WARNING("Unexpected managed endpoint lifecycle message after actor bound!");
                return MsgNotAllowed;
            }
            mAwaitingManagedEndpointBind = false;
            this->ActorDisconnected(ManagedEndpointDropped);
            return MsgProcessed;
        }
    case PDocAccessible::Msg_Shutdown__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PDocAccessible", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PDocAccessibleParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PDocAccessible::Msg_Shutdown", OTHER);

            mozilla::ipc::IPCResult __ok = (this)->RecvShutdown();
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PDocAccessible::Msg_Event__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PDocAccessible", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PDocAccessibleParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PDocAccessible::Msg_Event", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__aID = IPC::ReadParam<uint64_t>((&(reader__)));
            if (!maybe__aID) {
                FatalError("Error deserializing 'uint64_t'");
                return MsgValueError;

            }
            auto& aID = *maybe__aID;
            // Sentinel = 'aID'
            if ((!(((&(reader__)))->ReadSentinel(33292527)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'uint64_t'");
                return MsgValueError;
            }
            auto maybe__type = IPC::ReadParam<uint32_t>((&(reader__)));
            if (!maybe__type) {
                FatalError("Error deserializing 'uint32_t'");
                return MsgValueError;

            }
            auto& type = *maybe__type;
            // Sentinel = 'type'
            if ((!(((&(reader__)))->ReadSentinel(75760067)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'uint32_t'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::IPCResult __ok = (this)->RecvEvent(std::move(aID), std::move(type));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PDocAccessible::Msg_StateChangeEvent__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PDocAccessible", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PDocAccessibleParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PDocAccessible::Msg_StateChangeEvent", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__aID = IPC::ReadParam<uint64_t>((&(reader__)));
            if (!maybe__aID) {
                FatalError("Error deserializing 'uint64_t'");
                return MsgValueError;

            }
            auto& aID = *maybe__aID;
            // Sentinel = 'aID'
            if ((!(((&(reader__)))->ReadSentinel(33292527)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'uint64_t'");
                return MsgValueError;
            }
            auto maybe__aState = IPC::ReadParam<uint64_t>((&(reader__)));
            if (!maybe__aState) {
                FatalError("Error deserializing 'uint64_t'");
                return MsgValueError;

            }
            auto& aState = *maybe__aState;
            // Sentinel = 'aState'
            if ((!(((&(reader__)))->ReadSentinel(137036387)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'uint64_t'");
                return MsgValueError;
            }
            auto maybe__aEnabled = IPC::ReadParam<bool>((&(reader__)));
            if (!maybe__aEnabled) {
                FatalError("Error deserializing 'bool'");
                return MsgValueError;

            }
            auto& aEnabled = *maybe__aEnabled;
            // Sentinel = 'aEnabled'
            if ((!(((&(reader__)))->ReadSentinel(224789261)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'bool'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::IPCResult __ok = (this)->RecvStateChangeEvent(std::move(aID), std::move(aState), std::move(aEnabled));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PDocAccessible::Msg_CaretMoveEvent__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PDocAccessible", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PDocAccessibleParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PDocAccessible::Msg_CaretMoveEvent", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__aID = IPC::ReadParam<uint64_t>((&(reader__)));
            if (!maybe__aID) {
                FatalError("Error deserializing 'uint64_t'");
                return MsgValueError;

            }
            auto& aID = *maybe__aID;
            // Sentinel = 'aID'
            if ((!(((&(reader__)))->ReadSentinel(33292527)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'uint64_t'");
                return MsgValueError;
            }
            auto maybe__aCaretRect = IPC::ReadParam<LayoutDeviceIntRect>((&(reader__)));
            if (!maybe__aCaretRect) {
                FatalError("Error deserializing 'LayoutDeviceIntRect'");
                return MsgValueError;

            }
            auto& aCaretRect = *maybe__aCaretRect;
            // Sentinel = 'aCaretRect'
            if ((!(((&(reader__)))->ReadSentinel(346555359)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'LayoutDeviceIntRect'");
                return MsgValueError;
            }
            auto maybe__aOffset = IPC::ReadParam<int32_t>((&(reader__)));
            if (!maybe__aOffset) {
                FatalError("Error deserializing 'int32_t'");
                return MsgValueError;

            }
            auto& aOffset = *maybe__aOffset;
            // Sentinel = 'aOffset'
            if ((!(((&(reader__)))->ReadSentinel(179634889)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'int32_t'");
                return MsgValueError;
            }
            auto maybe__aIsSelectionCollapsed = IPC::ReadParam<bool>((&(reader__)));
            if (!maybe__aIsSelectionCollapsed) {
                FatalError("Error deserializing 'bool'");
                return MsgValueError;

            }
            auto& aIsSelectionCollapsed = *maybe__aIsSelectionCollapsed;
            // Sentinel = 'aIsSelectionCollapsed'
            if ((!(((&(reader__)))->ReadSentinel(1514342491)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'bool'");
                return MsgValueError;
            }
            auto maybe__aIsAtEndOfLine = IPC::ReadParam<bool>((&(reader__)));
            if (!maybe__aIsAtEndOfLine) {
                FatalError("Error deserializing 'bool'");
                return MsgValueError;

            }
            auto& aIsAtEndOfLine = *maybe__aIsAtEndOfLine;
            // Sentinel = 'aIsAtEndOfLine'
            if ((!(((&(reader__)))->ReadSentinel(635766055)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'bool'");
                return MsgValueError;
            }
            auto maybe__aGranularity = IPC::ReadParam<int32_t>((&(reader__)));
            if (!maybe__aGranularity) {
                FatalError("Error deserializing 'int32_t'");
                return MsgValueError;

            }
            auto& aGranularity = *maybe__aGranularity;
            // Sentinel = 'aGranularity'
            if ((!(((&(reader__)))->ReadSentinel(519439604)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'int32_t'");
                return MsgValueError;
            }
            auto maybe__aFromUser = IPC::ReadParam<bool>((&(reader__)));
            if (!maybe__aFromUser) {
                FatalError("Error deserializing 'bool'");
                return MsgValueError;

            }
            auto& aFromUser = *maybe__aFromUser;
            // Sentinel = 'aFromUser'
            if ((!(((&(reader__)))->ReadSentinel(291767189)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'bool'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::IPCResult __ok = (this)->RecvCaretMoveEvent(std::move(aID), std::move(aCaretRect), std::move(aOffset), std::move(aIsSelectionCollapsed), std::move(aIsAtEndOfLine), std::move(aGranularity), std::move(aFromUser));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PDocAccessible::Msg_MutationEvents__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PDocAccessible", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PDocAccessibleParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PDocAccessible::Msg_MutationEvents", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__aData = IPC::ReadParam<nsTArray<MutationEventData>>((&(reader__)));
            if (!maybe__aData) {
                FatalError("Error deserializing 'MutationEventData[]'");
                return MsgValueError;

            }
            auto& aData = *maybe__aData;
            // Sentinel = 'aData'
            if ((!(((&(reader__)))->ReadSentinel(90571228)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'MutationEventData[]'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::IPCResult __ok = (this)->RecvMutationEvents(std::move(aData));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PDocAccessible::Msg_RequestAckMutationEvents__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PDocAccessible", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PDocAccessibleParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PDocAccessible::Msg_RequestAckMutationEvents", OTHER);

            mozilla::ipc::IPCResult __ok = (this)->RecvRequestAckMutationEvents();
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PDocAccessible::Msg_SelectionEvent__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PDocAccessible", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PDocAccessibleParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PDocAccessible::Msg_SelectionEvent", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__aID = IPC::ReadParam<uint64_t>((&(reader__)));
            if (!maybe__aID) {
                FatalError("Error deserializing 'uint64_t'");
                return MsgValueError;

            }
            auto& aID = *maybe__aID;
            // Sentinel = 'aID'
            if ((!(((&(reader__)))->ReadSentinel(33292527)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'uint64_t'");
                return MsgValueError;
            }
            auto maybe__aWidgetID = IPC::ReadParam<uint64_t>((&(reader__)));
            if (!maybe__aWidgetID) {
                FatalError("Error deserializing 'uint64_t'");
                return MsgValueError;

            }
            auto& aWidgetID = *maybe__aWidgetID;
            // Sentinel = 'aWidgetID'
            if ((!(((&(reader__)))->ReadSentinel(287966035)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'uint64_t'");
                return MsgValueError;
            }
            auto maybe__aType = IPC::ReadParam<uint32_t>((&(reader__)));
            if (!maybe__aType) {
                FatalError("Error deserializing 'uint32_t'");
                return MsgValueError;

            }
            auto& aType = *maybe__aType;
            // Sentinel = 'aType'
            if ((!(((&(reader__)))->ReadSentinel(99222020)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'uint32_t'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::IPCResult __ok = (this)->RecvSelectionEvent(std::move(aID), std::move(aWidgetID), std::move(aType));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PDocAccessible::Msg_RoleChangedEvent__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PDocAccessible", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PDocAccessibleParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PDocAccessible::Msg_RoleChangedEvent", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__aRole = IPC::ReadParam<role>((&(reader__)));
            if (!maybe__aRole) {
                FatalError("Error deserializing 'role'");
                return MsgValueError;

            }
            auto& aRole = *maybe__aRole;
            // Sentinel = 'aRole'
            if ((!(((&(reader__)))->ReadSentinel(96207348)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'role'");
                return MsgValueError;
            }
            auto maybe__aRoleMapEntryIndex = IPC::ReadParam<uint8_t>((&(reader__)));
            if (!maybe__aRoleMapEntryIndex) {
                FatalError("Error deserializing 'uint8_t'");
                return MsgValueError;

            }
            auto& aRoleMapEntryIndex = *maybe__aRoleMapEntryIndex;
            // Sentinel = 'aRoleMapEntryIndex'
            if ((!(((&(reader__)))->ReadSentinel(1109133084)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'uint8_t'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::IPCResult __ok = (this)->RecvRoleChangedEvent(std::move(aRole), std::move(aRoleMapEntryIndex));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PDocAccessible::Msg_FocusEvent__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PDocAccessible", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PDocAccessibleParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PDocAccessible::Msg_FocusEvent", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__aID = IPC::ReadParam<uint64_t>((&(reader__)));
            if (!maybe__aID) {
                FatalError("Error deserializing 'uint64_t'");
                return MsgValueError;

            }
            auto& aID = *maybe__aID;
            // Sentinel = 'aID'
            if ((!(((&(reader__)))->ReadSentinel(33292527)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'uint64_t'");
                return MsgValueError;
            }
            auto maybe__aCaretRect = IPC::ReadParam<LayoutDeviceIntRect>((&(reader__)));
            if (!maybe__aCaretRect) {
                FatalError("Error deserializing 'LayoutDeviceIntRect'");
                return MsgValueError;

            }
            auto& aCaretRect = *maybe__aCaretRect;
            // Sentinel = 'aCaretRect'
            if ((!(((&(reader__)))->ReadSentinel(346555359)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'LayoutDeviceIntRect'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::IPCResult __ok = (this)->RecvFocusEvent(std::move(aID), std::move(aCaretRect));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PDocAccessible::Msg_ScrollingEvent__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PDocAccessible", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PDocAccessibleParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PDocAccessible::Msg_ScrollingEvent", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__aID = IPC::ReadParam<uint64_t>((&(reader__)));
            if (!maybe__aID) {
                FatalError("Error deserializing 'uint64_t'");
                return MsgValueError;

            }
            auto& aID = *maybe__aID;
            // Sentinel = 'aID'
            if ((!(((&(reader__)))->ReadSentinel(33292527)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'uint64_t'");
                return MsgValueError;
            }
            auto maybe__aType = IPC::ReadParam<uint64_t>((&(reader__)));
            if (!maybe__aType) {
                FatalError("Error deserializing 'uint64_t'");
                return MsgValueError;

            }
            auto& aType = *maybe__aType;
            // Sentinel = 'aType'
            if ((!(((&(reader__)))->ReadSentinel(99222020)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'uint64_t'");
                return MsgValueError;
            }
            auto maybe__aScrollX = IPC::ReadParam<uint32_t>((&(reader__)));
            if (!maybe__aScrollX) {
                FatalError("Error deserializing 'uint32_t'");
                return MsgValueError;

            }
            auto& aScrollX = *maybe__aScrollX;
            // Sentinel = 'aScrollX'
            if ((!(((&(reader__)))->ReadSentinel(235995945)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'uint32_t'");
                return MsgValueError;
            }
            auto maybe__aScrollY = IPC::ReadParam<uint32_t>((&(reader__)));
            if (!maybe__aScrollY) {
                FatalError("Error deserializing 'uint32_t'");
                return MsgValueError;

            }
            auto& aScrollY = *maybe__aScrollY;
            // Sentinel = 'aScrollY'
            if ((!(((&(reader__)))->ReadSentinel(236061482)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'uint32_t'");
                return MsgValueError;
            }
            auto maybe__aMaxScrollX = IPC::ReadParam<uint32_t>((&(reader__)));
            if (!maybe__aMaxScrollX) {
                FatalError("Error deserializing 'uint32_t'");
                return MsgValueError;

            }
            auto& aMaxScrollX = *maybe__aMaxScrollX;
            // Sentinel = 'aMaxScrollX'
            if ((!(((&(reader__)))->ReadSentinel(425854031)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'uint32_t'");
                return MsgValueError;
            }
            auto maybe__aMaxScrollY = IPC::ReadParam<uint32_t>((&(reader__)));
            if (!maybe__aMaxScrollY) {
                FatalError("Error deserializing 'uint32_t'");
                return MsgValueError;

            }
            auto& aMaxScrollY = *maybe__aMaxScrollY;
            // Sentinel = 'aMaxScrollY'
            if ((!(((&(reader__)))->ReadSentinel(425919568)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'uint32_t'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::IPCResult __ok = (this)->RecvScrollingEvent(std::move(aID), std::move(aType), std::move(aScrollX), std::move(aScrollY), std::move(aMaxScrollX), std::move(aMaxScrollY));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PDocAccessible::Msg_AnnouncementEvent__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PDocAccessible", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PDocAccessibleParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PDocAccessible::Msg_AnnouncementEvent", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__aID = IPC::ReadParam<uint64_t>((&(reader__)));
            if (!maybe__aID) {
                FatalError("Error deserializing 'uint64_t'");
                return MsgValueError;

            }
            auto& aID = *maybe__aID;
            // Sentinel = 'aID'
            if ((!(((&(reader__)))->ReadSentinel(33292527)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'uint64_t'");
                return MsgValueError;
            }
            auto maybe__aAnnouncement = IPC::ReadParam<nsString>((&(reader__)));
            if (!maybe__aAnnouncement) {
                FatalError("Error deserializing 'nsString'");
                return MsgValueError;

            }
            auto& aAnnouncement = *maybe__aAnnouncement;
            // Sentinel = 'aAnnouncement'
            if ((!(((&(reader__)))->ReadSentinel(605750605)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'nsString'");
                return MsgValueError;
            }
            auto maybe__aPriority = IPC::ReadParam<uint16_t>((&(reader__)));
            if (!maybe__aPriority) {
                FatalError("Error deserializing 'uint16_t'");
                return MsgValueError;

            }
            auto& aPriority = *maybe__aPriority;
            // Sentinel = 'aPriority'
            if ((!(((&(reader__)))->ReadSentinel(303367108)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'uint16_t'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::IPCResult __ok = (this)->RecvAnnouncementEvent(std::move(aID), std::move(aAnnouncement), std::move(aPriority));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PDocAccessible::Msg_TextSelectionChangeEvent__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PDocAccessible", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PDocAccessibleParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PDocAccessible::Msg_TextSelectionChangeEvent", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__aID = IPC::ReadParam<uint64_t>((&(reader__)));
            if (!maybe__aID) {
                FatalError("Error deserializing 'uint64_t'");
                return MsgValueError;

            }
            auto& aID = *maybe__aID;
            // Sentinel = 'aID'
            if ((!(((&(reader__)))->ReadSentinel(33292527)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'uint64_t'");
                return MsgValueError;
            }
            auto maybe__aSelection = IPC::ReadParam<nsTArray<TextRangeData>>((&(reader__)));
            if (!maybe__aSelection) {
                FatalError("Error deserializing 'TextRangeData[]'");
                return MsgValueError;

            }
            auto& aSelection = *maybe__aSelection;
            // Sentinel = 'aSelection'
            if ((!(((&(reader__)))->ReadSentinel(360645640)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'TextRangeData[]'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::IPCResult __ok = (this)->RecvTextSelectionChangeEvent(std::move(aID), std::move(aSelection));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PDocAccessible::Msg_BindChildDoc__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PDocAccessible", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PDocAccessibleParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PDocAccessible::Msg_BindChildDoc", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__aChildDoc = IPC::ReadParam<mozilla::NotNull<PDocAccessibleParent*>>((&(reader__)));
            if (!maybe__aChildDoc) {
                FatalError("Error deserializing 'NotNull<PDocAccessible>'");
                return MsgValueError;

            }
            auto& aChildDoc = *maybe__aChildDoc;
            // Sentinel = 'aChildDoc'
            if ((!(((&(reader__)))->ReadSentinel(277939036)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'NotNull<PDocAccessible>'");
                return MsgValueError;
            }
            auto maybe__aID = IPC::ReadParam<uint64_t>((&(reader__)));
            if (!maybe__aID) {
                FatalError("Error deserializing 'uint64_t'");
                return MsgValueError;

            }
            auto& aID = *maybe__aID;
            // Sentinel = 'aID'
            if ((!(((&(reader__)))->ReadSentinel(33292527)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'uint64_t'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::IPCResult __ok = (this)->RecvBindChildDoc(aChildDoc, std::move(aID));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PDocAccessible::Msg_Cache__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PDocAccessible", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PDocAccessibleParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PDocAccessible::Msg_Cache", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__aUpdateType = IPC::ReadParam<CacheUpdateType>((&(reader__)));
            if (!maybe__aUpdateType) {
                FatalError("Error deserializing 'CacheUpdateType'");
                return MsgValueError;

            }
            auto& aUpdateType = *maybe__aUpdateType;
            // Sentinel = 'aUpdateType'
            if ((!(((&(reader__)))->ReadSentinel(435160167)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'CacheUpdateType'");
                return MsgValueError;
            }
            auto maybe__aData = IPC::ReadParam<nsTArray<CacheData>>((&(reader__)));
            if (!maybe__aData) {
                FatalError("Error deserializing 'CacheData[]'");
                return MsgValueError;

            }
            auto& aData = *maybe__aData;
            // Sentinel = 'aData'
            if ((!(((&(reader__)))->ReadSentinel(90571228)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'CacheData[]'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::IPCResult __ok = (this)->RecvCache(std::move(aUpdateType), std::move(aData));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PDocAccessible::Msg_SelectedAccessiblesChanged__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PDocAccessible", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PDocAccessibleParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PDocAccessible::Msg_SelectedAccessiblesChanged", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__aSelectedIDs = IPC::ReadParam<nsTArray<uint64_t>>((&(reader__)));
            if (!maybe__aSelectedIDs) {
                FatalError("Error deserializing 'uint64_t[]'");
                return MsgValueError;

            }
            auto& aSelectedIDs = *maybe__aSelectedIDs;
            // Sentinel = 'aSelectedIDs'
            if ((!(((&(reader__)))->ReadSentinel(500892811)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'uint64_t[]'");
                return MsgValueError;
            }
            auto maybe__aUnselectedIDs = IPC::ReadParam<nsTArray<uint64_t>>((&(reader__)));
            if (!maybe__aUnselectedIDs) {
                FatalError("Error deserializing 'uint64_t[]'");
                return MsgValueError;

            }
            auto& aUnselectedIDs = *maybe__aUnselectedIDs;
            // Sentinel = 'aUnselectedIDs'
            if ((!(((&(reader__)))->ReadSentinel(695731566)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'uint64_t[]'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::IPCResult __ok = (this)->RecvSelectedAccessiblesChanged(std::move(aSelectedIDs), std::move(aUnselectedIDs));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PDocAccessible::Msg_AccessiblesWillMove__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PDocAccessible", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PDocAccessibleParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PDocAccessible::Msg_AccessiblesWillMove", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__aIDs = IPC::ReadParam<nsTArray<uint64_t>>((&(reader__)));
            if (!maybe__aIDs) {
                FatalError("Error deserializing 'uint64_t[]'");
                return MsgValueError;

            }
            auto& aIDs = *maybe__aIDs;
            // Sentinel = 'aIDs'
            if ((!(((&(reader__)))->ReadSentinel(56492386)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'uint64_t[]'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::IPCResult __ok = (this)->RecvAccessiblesWillMove(std::move(aIDs));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PDocAccessible::Reply___delete____ID:
        {
            return MsgProcessed;
        }
    default:
        return MsgNotKnown;
    }
}

auto PDocAccessibleParent::OnMessageReceived(
        const Message& msg__,
        UniquePtr<Message>& reply__) -> PDocAccessibleParent::Result
{
    return MsgNotKnown;
}



} // namespace a11y
} // namespace mozilla
namespace IPC {
auto ParamTraits<::mozilla::a11y::PDocAccessibleParent*>::Write(
        IPC::MessageWriter* aWriter,
        const paramType& aVar) -> void
{
    MOZ_RELEASE_ASSERT(
        aWriter->GetActor(),
        "Cannot serialize managed actors without an actor");

    int32_t id;
    if (!aVar) {
        id = 0;  // kNullActorId
    } else {
        id = aVar->Id();
        if (id == 1) {  // kFreedActorId
            aVar->FatalError("Actor has been |delete|d");
        }
        MOZ_RELEASE_ASSERT(
            aWriter->GetActor()->GetIPCChannel() == aVar->GetIPCChannel(),
            "Actor must be from the same channel as the"
            " actor it's being sent over");
        MOZ_RELEASE_ASSERT(
            aVar->CanSend(),
            "Actor must still be open when sending");
    }

    IPC::WriteParam(aWriter, id);
}

auto ParamTraits<::mozilla::a11y::PDocAccessibleParent*>::Read(IPC::MessageReader* aReader) -> IPC::ReadResult<paramType>
{
    MOZ_RELEASE_ASSERT(
        aReader->GetActor(),
        "Cannot deserialize managed actors without an actor");
    mozilla::Maybe<mozilla::ipc::IProtocol*> actor = aReader->GetActor()
        ->ReadActor(aReader, true, "PDocAccessible", PDocAccessibleMsgStart);
    if (actor.isSome()) {
        return static_cast<::mozilla::a11y::PDocAccessibleParent*>(actor.ref());
    }
    return {};
}

} // namespace IPC
