//
// Automatically generated by ipdlc.
// Edit at your own risk
//


#include "mozilla/net/PDataChannelParent.h"
#include "mozilla/AntiTrackingIPCUtils.h"
#include "mozilla/ProfilerLabels.h"
#include "mozilla/TimeStamp.h"
#include "mozilla/dom/DomSecurityIPCUtils.h"
#include "mozilla/dom/FeaturePolicyUtils.h"
#include "mozilla/dom/FetchIPCTypes.h"
#include "mozilla/dom/NavigationAPIIPCUtils.h"
#include "mozilla/dom/PropertyBagUtils.h"
#include "mozilla/dom/ReferrerInfoUtils.h"
#include "mozilla/dom/SessionHistoryEntry.h"
#include "mozilla/ipc/URIUtils.h"
#include "mozilla/net/CacheInfoIPCTypes.h"
#include "mozilla/net/ClassOfService.h"
#include "mozilla/net/DataChannelParent.h"
#include "nsDOMNavigationTiming.h"
#include "nsDocShellLoadState.h"
#include "nsHttp.h"
#include "nsHttpResponseHead.h"
#include "nsIPropertyBag2.h"

#include "mozilla/net/PNeckoParent.h"

#include "ipc/IPCMessageUtils.h"
#include "ipc/IPCMessageUtilsSpecializations.h"
#include "nsIFile.h"
#include "mozilla/ipc/Endpoint.h"
#include "mozilla/ipc/ProtocolMessageUtils.h"
#include "mozilla/ipc/ProtocolUtils.h"
#include "mozilla/ipc/ShmemMessageUtils.h"
#include "mozilla/ipc/TaintingIPCUtils.h"

namespace mozilla {
namespace net {


auto PDataChannelParent::Recv__delete__() -> mozilla::ipc::IPCResult
{
    return IPC_OK();
}

MOZ_IMPLICIT PDataChannelParent::PDataChannelParent() :
    mozilla::ipc::IRefCountedProtocol(kProtocolId, mozilla::ipc::ParentSide)
{
    MOZ_COUNT_CTOR(PDataChannelParent);
}

PDataChannelParent::~PDataChannelParent()
{
    MOZ_COUNT_DTOR(PDataChannelParent);
}

auto PDataChannelParent::ActorAlloc() -> void
{
    AddRef();
}

auto PDataChannelParent::ActorDealloc() -> void
{
    Release();
}

auto PDataChannelParent::OtherPid() const -> ::base::ProcessId
{
    ::base::ProcessId pid =
        ::mozilla::ipc::IProtocol::ToplevelProtocol()->OtherPidMaybeInvalid();
    MOZ_RELEASE_ASSERT(pid != ::base::kInvalidProcessId);
    return pid;
}

auto PDataChannelParent::OtherChildID() const -> ::GeckoChildID
{
    ::GeckoChildID childID =
        ::mozilla::ipc::IProtocol::ToplevelProtocol()->OtherChildIDMaybeInvalid();
    MOZ_RELEASE_ASSERT(childID != -1);
    return childID;
}

auto PDataChannelParent::OtherEndpointProcInfo() const -> ::mozilla::ipc::EndpointProcInfo
{
    return ::mozilla::ipc::EndpointProcInfo{OtherPid(), OtherChildID()};
}

auto PDataChannelParent::Manager() const -> PNeckoParent*
{
    return static_cast<PNeckoParent*>(IProtocol::Manager());
}

auto PDataChannelParent::ManagedProtocolIds() const -> mozilla::Span<mozilla::ipc::ProtocolId const>
{
    return {};
}

auto PDataChannelParent::GetManagedActors(mozilla::ipc::ProtocolId aProtocol) -> UntypedManagedContainer*
{
    switch (aProtocol) {
    default:
        return nullptr;
    }
}

auto PDataChannelParent::DeallocManagee(
        int32_t aProtocolId,
        IProtocol* aListener) -> void
{
    FatalError("unreached");
    return;
}

auto PDataChannelParent::OnMessageReceived(const Message& msg__) -> PDataChannelParent::Result
{
    switch (msg__.type()) {
    case MANAGED_ENDPOINT_BOUND_MESSAGE_TYPE:
        {
            if (!mAwaitingManagedEndpointBind) {
                NS_WARNING("Unexpected managed endpoint lifecycle message after actor bound!");
                return MsgNotAllowed;
            }
            mAwaitingManagedEndpointBind = false;
            return MsgProcessed;
        }
    case MANAGED_ENDPOINT_DROPPED_MESSAGE_TYPE:
        {
            if (!mAwaitingManagedEndpointBind) {
                NS_WARNING("Unexpected managed endpoint lifecycle message after actor bound!");
                return MsgNotAllowed;
            }
            mAwaitingManagedEndpointBind = false;
            this->ActorDisconnected(ManagedEndpointDropped);
            return MsgProcessed;
        }
    case PDataChannel::Msg___delete____ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PDataChannel", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PDataChannelParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PDataChannel::Msg___delete__", OTHER);

            mozilla::ipc::IPCResult __ok = (static_cast<DataChannelParent*>(this))->Recv__delete__();
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }


            this->ActorDisconnected(Deletion);

            return MsgProcessed;
        }
    case PDataChannel::Msg_NotifyListeners__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PDataChannel", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PDataChannelParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PDataChannel::Msg_NotifyListeners", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__aDataChannelInfo = IPC::ReadParam<DataChannelInfo>((&(reader__)));
            if (!maybe__aDataChannelInfo) {
                FatalError("Error deserializing 'DataChannelInfo'");
                return MsgValueError;

            }
            auto& aDataChannelInfo = *maybe__aDataChannelInfo;
            // Sentinel = 'aDataChannelInfo'
            if ((!(((&(reader__)))->ReadSentinel(852035105)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'DataChannelInfo'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::IPCResult __ok = (static_cast<DataChannelParent*>(this))->RecvNotifyListeners(std::move(aDataChannelInfo));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PDataChannel::Msg_SetChannelIdForRedirect__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PDataChannel", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PDataChannelParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PDataChannel::Msg_SetChannelIdForRedirect", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__aChannelId = IPC::ReadParam<uint64_t>((&(reader__)));
            if (!maybe__aChannelId) {
                FatalError("Error deserializing 'uint64_t'");
                return MsgValueError;

            }
            auto& aChannelId = *maybe__aChannelId;
            // Sentinel = 'aChannelId'
            if ((!(((&(reader__)))->ReadSentinel(345899976)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'uint64_t'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::IPCResult __ok = (static_cast<DataChannelParent*>(this))->RecvSetChannelIdForRedirect(std::move(aChannelId));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    default:
        return MsgNotKnown;
    }
}

auto PDataChannelParent::OnMessageReceived(
        const Message& msg__,
        UniquePtr<Message>& reply__) -> PDataChannelParent::Result
{
    return MsgNotKnown;
}



} // namespace net
} // namespace mozilla
namespace IPC {
auto ParamTraits<::mozilla::net::PDataChannelParent*>::Write(
        IPC::MessageWriter* aWriter,
        const paramType& aVar) -> void
{
    MOZ_RELEASE_ASSERT(
        aWriter->GetActor(),
        "Cannot serialize managed actors without an actor");

    int32_t id;
    if (!aVar) {
        id = 0;  // kNullActorId
    } else {
        id = aVar->Id();
        if (id == 1) {  // kFreedActorId
            aVar->FatalError("Actor has been |delete|d");
        }
        MOZ_RELEASE_ASSERT(
            aWriter->GetActor()->GetIPCChannel() == aVar->GetIPCChannel(),
            "Actor must be from the same channel as the"
            " actor it's being sent over");
        MOZ_RELEASE_ASSERT(
            aVar->CanSend(),
            "Actor must still be open when sending");
    }

    IPC::WriteParam(aWriter, id);
}

auto ParamTraits<::mozilla::net::PDataChannelParent*>::Read(IPC::MessageReader* aReader) -> IPC::ReadResult<paramType>
{
    MOZ_RELEASE_ASSERT(
        aReader->GetActor(),
        "Cannot deserialize managed actors without an actor");
    mozilla::Maybe<mozilla::ipc::IProtocol*> actor = aReader->GetActor()
        ->ReadActor(aReader, true, "PDataChannel", PDataChannelMsgStart);
    if (actor.isSome()) {
        return static_cast<::mozilla::net::PDataChannelParent*>(actor.ref());
    }
    return {};
}

} // namespace IPC
