//
// Automatically generated by ipdlc.
// Edit at your own risk
//


#include "mozilla/net/PCookieServiceChild.h"
#include "ipc/IPCMessageUtils.h"
#include "mozilla/AntiTrackingIPCUtils.h"
#include "mozilla/ProfilerLabels.h"
#include "mozilla/TimeStamp.h"
#include "mozilla/dom/DomSecurityIPCUtils.h"
#include "mozilla/dom/FeaturePolicyUtils.h"
#include "mozilla/dom/FetchIPCTypes.h"
#include "mozilla/dom/NavigationAPIIPCUtils.h"
#include "mozilla/dom/PropertyBagUtils.h"
#include "mozilla/dom/ReferrerInfoUtils.h"
#include "mozilla/dom/SessionHistoryEntry.h"
#include "mozilla/ipc/URIUtils.h"
#include "mozilla/net/CacheInfoIPCTypes.h"
#include "mozilla/net/ClassOfService.h"
#include "mozilla/net/CookieServiceChild.h"
#include "nsDOMNavigationTiming.h"
#include "nsDocShellLoadState.h"
#include "nsHttp.h"
#include "nsHttpResponseHead.h"
#include "nsID.h"
#include "nsIPropertyBag2.h"

#include "mozilla/net/PNeckoChild.h"

#include "ipc/IPCMessageUtils.h"
#include "ipc/IPCMessageUtilsSpecializations.h"
#include "nsIFile.h"
#include "mozilla/ipc/Endpoint.h"
#include "mozilla/ipc/ProtocolMessageUtils.h"
#include "mozilla/ipc/ProtocolUtils.h"
#include "mozilla/ipc/ShmemMessageUtils.h"
#include "mozilla/ipc/TaintingIPCUtils.h"

namespace mozilla {
namespace net {


MOZ_IMPLICIT PCookieServiceChild::PCookieServiceChild() :
    mozilla::ipc::IProtocol(kProtocolId, mozilla::ipc::ChildSide)
{
    MOZ_COUNT_CTOR(PCookieServiceChild);
}

PCookieServiceChild::~PCookieServiceChild()
{
    MOZ_COUNT_DTOR(PCookieServiceChild);
}

auto PCookieServiceChild::ActorAlloc() -> void
{
}

auto PCookieServiceChild::ActorDealloc() -> void
{
    if (Manager()) {
        Manager()->DeallocManagee(kProtocolId, this);
    }
}

auto PCookieServiceChild::OtherPid() const -> ::base::ProcessId
{
    ::base::ProcessId pid =
        ::mozilla::ipc::IProtocol::ToplevelProtocol()->OtherPidMaybeInvalid();
    MOZ_RELEASE_ASSERT(pid != ::base::kInvalidProcessId);
    return pid;
}

auto PCookieServiceChild::OtherChildID() const -> ::GeckoChildID
{
    ::GeckoChildID childID =
        ::mozilla::ipc::IProtocol::ToplevelProtocol()->OtherChildIDMaybeInvalid();
    MOZ_RELEASE_ASSERT(childID != -1);
    return childID;
}

auto PCookieServiceChild::OtherEndpointProcInfo() const -> ::mozilla::ipc::EndpointProcInfo
{
    return ::mozilla::ipc::EndpointProcInfo{OtherPid(), OtherChildID()};
}

auto PCookieServiceChild::Manager() const -> PNeckoChild*
{
    return static_cast<PNeckoChild*>(IProtocol::Manager());
}

auto PCookieServiceChild::ManagedProtocolIds() const -> mozilla::Span<mozilla::ipc::ProtocolId const>
{
    return {};
}

auto PCookieServiceChild::GetManagedActors(mozilla::ipc::ProtocolId aProtocol) -> UntypedManagedContainer*
{
    switch (aProtocol) {
    default:
        return nullptr;
    }
}

auto PCookieServiceChild::RejectPendingResponses(ResponseRejectReason aReason) -> void
{
    mAsyncCallbacks.RejectPendingResponses(aReason);
}

auto PCookieServiceChild::SendSetCookies(
        const nsACString& baseDomain,
        const OriginAttributes& attrs,
        nsIURI* host,
        const bool& fromHttp,
        const bool& isThirdParty,
        mozilla::Span<CookieStruct const> cookies) -> bool
{
    UniquePtr<IPC::Message> msg__ = PCookieService::Msg_SetCookies(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), baseDomain);
    // Sentinel = 'baseDomain'
    ((&(writer__)))->WriteSentinel(360449012);
    IPC::WriteParam((&(writer__)), attrs);
    // Sentinel = 'attrs'
    ((&(writer__)))->WriteSentinel(107807279);
    IPC::WriteParam((&(writer__)), host);
    // Sentinel = 'host'
    ((&(writer__)))->WriteSentinel(72024511);
    IPC::WriteParam((&(writer__)), fromHttp);
    // Sentinel = 'fromHttp'
    ((&(writer__)))->WriteSentinel(249889621);
    IPC::WriteParam((&(writer__)), isThirdParty);
    // Sentinel = 'isThirdParty'
    ((&(writer__)))->WriteSentinel(526517480);
    IPC::WriteParam((&(writer__)), cookies);
    // Sentinel = 'cookies'
    ((&(writer__)))->WriteSentinel(195363566);




    if (mozilla::ipc::LoggingEnabledFor("PCookieService", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PCookieServiceChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PCookieService::Msg_SetCookies", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PCookieServiceChild::SendGetCookieList(
        nsIURI* host,
        const bool& isForeign,
        const bool& isThirdPartyTrackingResource,
        const bool& isThirdPartySocialTrackingResource,
        const bool& firstPartyStorageAccessPermissionGranted,
        const uint32_t& rejectedReason,
        const bool& isSafeTopLevelNav,
        const bool& isSameSiteForeign,
        const bool& hadCrossSiteRedirects,
        mozilla::Span<OriginAttributes const> attrsList,
        mozilla::ipc::ResolveCallback<nsTArray<CookieStructTable>>&& aResolve,
        mozilla::ipc::RejectCallback&& aReject) -> void
{
    UniquePtr<IPC::Message> msg__ = PCookieService::Msg_GetCookieList(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), host);
    // Sentinel = 'host'
    ((&(writer__)))->WriteSentinel(72024511);
    IPC::WriteParam((&(writer__)), isForeign);
    // Sentinel = 'isForeign'
    ((&(writer__)))->WriteSentinel(303760295);
    IPC::WriteParam((&(writer__)), isThirdPartyTrackingResource);
    // Sentinel = 'isThirdPartyTrackingResource'
    ((&(writer__)))->WriteSentinel(2753301347);
    IPC::WriteParam((&(writer__)), isThirdPartySocialTrackingResource);
    // Sentinel = 'isThirdPartySocialTrackingResource'
    ((&(writer__)))->WriteSentinel(4014869950);
    IPC::WriteParam((&(writer__)), firstPartyStorageAccessPermissionGranted);
    // Sentinel = 'firstPartyStorageAccessPermissionGranted'
    ((&(writer__)))->WriteSentinel(1328746574);
    IPC::WriteParam((&(writer__)), rejectedReason);
    // Sentinel = 'rejectedReason'
    ((&(writer__)))->WriteSentinel(714999215);
    IPC::WriteParam((&(writer__)), isSafeTopLevelNav);
    // Sentinel = 'isSafeTopLevelNav'
    ((&(writer__)))->WriteSentinel(1004734124);
    IPC::WriteParam((&(writer__)), isSameSiteForeign);
    // Sentinel = 'isSameSiteForeign'
    ((&(writer__)))->WriteSentinel(1012532930);
    IPC::WriteParam((&(writer__)), hadCrossSiteRedirects);
    // Sentinel = 'hadCrossSiteRedirects'
    ((&(writer__)))->WriteSentinel(1534789746);
    IPC::WriteParam((&(writer__)), attrsList);
    // Sentinel = 'attrsList'
    ((&(writer__)))->WriteSentinel(317588427);




    if (mozilla::ipc::LoggingEnabledFor("PCookieService", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PCookieServiceChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PCookieService::Msg_GetCookieList", OTHER);

    int32_t seqno__ = 0;
    if (ChannelSend(std::move(msg__), (&(seqno__)))) {
        mAsyncCallbacks.AddCallback(seqno__, PCookieService::Reply_GetCookieList__ID, [resolve=std::move(aResolve)](IPC::MessageReader* aReader) mutable {
            auto maybe__cookies = IPC::ReadParam<nsTArray<CookieStructTable>>(aReader);
            if (!maybe__cookies) {
                (aReader)->FatalError("Error deserializing 'CookieStructTable[]'");
                return MsgValueError;

            }
            auto& cookies = *maybe__cookies;
            // Sentinel = 'cookies'
            if ((!((aReader)->ReadSentinel(195363566)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'CookieStructTable[]'");
                return MsgValueError;
            }


            aReader->EndRead();

            resolve(std::move(cookies));
            return MsgProcessed;
        }, std::move(aReject));
    }
    else {
        aReject(::mozilla::ipc::ResponseRejectReason::SendError);
    }
    return;
}

auto PCookieServiceChild::SendGetCookieList(
        nsIURI* host,
        const bool& isForeign,
        const bool& isThirdPartyTrackingResource,
        const bool& isThirdPartySocialTrackingResource,
        const bool& firstPartyStorageAccessPermissionGranted,
        const uint32_t& rejectedReason,
        const bool& isSafeTopLevelNav,
        const bool& isSameSiteForeign,
        const bool& hadCrossSiteRedirects,
        mozilla::Span<OriginAttributes const> attrsList) -> RefPtr<GetCookieListPromise>
{
    RefPtr<MozPromise<nsTArray<CookieStructTable>, ResponseRejectReason, true>::Private> promise__ = new MozPromise<nsTArray<CookieStructTable>, ResponseRejectReason, true>::Private(__func__);
    promise__->UseDirectTaskDispatch(__func__);
    SendGetCookieList(std::move(host), std::move(isForeign), std::move(isThirdPartyTrackingResource), std::move(isThirdPartySocialTrackingResource), std::move(firstPartyStorageAccessPermissionGranted), std::move(rejectedReason), std::move(isSafeTopLevelNav), std::move(isSameSiteForeign), std::move(hadCrossSiteRedirects), std::move(attrsList), [promise__](nsTArray<CookieStructTable>&& aValue) {
        promise__->Resolve(std::move(aValue), __func__);
    }, [promise__](ResponseRejectReason&& aReason) {
        promise__->Reject(std::move(aReason), __func__);
    });
    return promise__;
}

auto PCookieServiceChild::Send__delete__(PCookieServiceChild* actor) -> bool
{
    if (!actor || !actor->CanSend()) {
        NS_WARNING("Attempt to __delete__ missing or closed actor");
        return false;
    }
    UniquePtr<IPC::Message> msg__ = PCookieService::Msg___delete__((actor)->Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            actor};




    if (mozilla::ipc::LoggingEnabledFor("PCookieService", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PCookieServiceChild",
            actor->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PCookieService::Msg___delete__", OTHER);

    bool sendok__ = (actor)->ChannelSend(std::move(msg__));

    actor->ActorDisconnected(Deletion);
    return sendok__;
}

auto PCookieServiceChild::DeallocManagee(
        int32_t aProtocolId,
        IProtocol* aListener) -> void
{
    FatalError("unreached");
    return;
}

auto PCookieServiceChild::OnMessageReceived(const Message& msg__) -> PCookieServiceChild::Result
{
    switch (msg__.type()) {
    case MANAGED_ENDPOINT_BOUND_MESSAGE_TYPE:
        {
            if (!mAwaitingManagedEndpointBind) {
                NS_WARNING("Unexpected managed endpoint lifecycle message after actor bound!");
                return MsgNotAllowed;
            }
            mAwaitingManagedEndpointBind = false;
            return MsgProcessed;
        }
    case MANAGED_ENDPOINT_DROPPED_MESSAGE_TYPE:
        {
            if (!mAwaitingManagedEndpointBind) {
                NS_WARNING("Unexpected managed endpoint lifecycle message after actor bound!");
                return MsgNotAllowed;
            }
            mAwaitingManagedEndpointBind = false;
            this->ActorDisconnected(ManagedEndpointDropped);
            return MsgProcessed;
        }
    case PCookieService::Reply_GetCookieList__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PCookieService", mozilla::ipc::ChildSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PCookieServiceChild",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }

            AUTO_PROFILER_LABEL("PCookieService::Msg_GetCookieList", OTHER);


            return mAsyncCallbacks.GotReply(this, msg__);
        }
    case PCookieService::Reply___delete____ID:
        {
            return MsgProcessed;
        }
    case PCookieService::Msg_TrackCookiesLoad__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PCookieService", mozilla::ipc::ChildSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PCookieServiceChild",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PCookieService::Msg_TrackCookiesLoad", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__cookiesListTable = IPC::ReadParam<nsTArray<CookieStructTable>>((&(reader__)));
            if (!maybe__cookiesListTable) {
                FatalError("Error deserializing 'CookieStructTable[]'");
                return MsgValueError;

            }
            auto& cookiesListTable = *maybe__cookiesListTable;
            // Sentinel = 'cookiesListTable'
            if ((!(((&(reader__)))->ReadSentinel(928974450)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'CookieStructTable[]'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::IPCResult __ok = (static_cast<CookieServiceChild*>(this))->RecvTrackCookiesLoad(std::move(cookiesListTable));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PCookieService::Msg_RemoveCookie__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PCookieService", mozilla::ipc::ChildSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PCookieServiceChild",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PCookieService::Msg_RemoveCookie", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__cookie = IPC::ReadParam<CookieStruct>((&(reader__)));
            if (!maybe__cookie) {
                FatalError("Error deserializing 'CookieStruct'");
                return MsgValueError;

            }
            auto& cookie = *maybe__cookie;
            // Sentinel = 'cookie'
            if ((!(((&(reader__)))->ReadSentinel(146211451)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'CookieStruct'");
                return MsgValueError;
            }
            auto maybe__attrs = IPC::ReadParam<OriginAttributes>((&(reader__)));
            if (!maybe__attrs) {
                FatalError("Error deserializing 'OriginAttributes'");
                return MsgValueError;

            }
            auto& attrs = *maybe__attrs;
            // Sentinel = 'attrs'
            if ((!(((&(reader__)))->ReadSentinel(107807279)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'OriginAttributes'");
                return MsgValueError;
            }
            auto maybe__operationId = IPC::ReadParam<mozilla::Maybe<nsID>>((&(reader__)));
            if (!maybe__operationId) {
                FatalError("Error deserializing 'nsID?'");
                return MsgValueError;

            }
            auto& operationId = *maybe__operationId;
            // Sentinel = 'operationId'
            if ((!(((&(reader__)))->ReadSentinel(464847999)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'nsID?'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::IPCResult __ok = (static_cast<CookieServiceChild*>(this))->RecvRemoveCookie(std::move(cookie), std::move(attrs), std::move(operationId));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PCookieService::Msg_RemoveBatchDeletedCookies__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PCookieService", mozilla::ipc::ChildSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PCookieServiceChild",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PCookieService::Msg_RemoveBatchDeletedCookies", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__cookiesList = IPC::ReadParam<nsTArray<CookieStruct>>((&(reader__)));
            if (!maybe__cookiesList) {
                FatalError("Error deserializing 'CookieStruct[]'");
                return MsgValueError;

            }
            auto& cookiesList = *maybe__cookiesList;
            // Sentinel = 'cookiesList'
            if ((!(((&(reader__)))->ReadSentinel(455214218)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'CookieStruct[]'");
                return MsgValueError;
            }
            auto maybe__attrsList = IPC::ReadParam<nsTArray<OriginAttributes>>((&(reader__)));
            if (!maybe__attrsList) {
                FatalError("Error deserializing 'OriginAttributes[]'");
                return MsgValueError;

            }
            auto& attrsList = *maybe__attrsList;
            // Sentinel = 'attrsList'
            if ((!(((&(reader__)))->ReadSentinel(317588427)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'OriginAttributes[]'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::IPCResult __ok = (static_cast<CookieServiceChild*>(this))->RecvRemoveBatchDeletedCookies(std::move(cookiesList), std::move(attrsList));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PCookieService::Msg_RemoveAll__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PCookieService", mozilla::ipc::ChildSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PCookieServiceChild",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PCookieService::Msg_RemoveAll", OTHER);

            mozilla::ipc::IPCResult __ok = (static_cast<CookieServiceChild*>(this))->RecvRemoveAll();
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PCookieService::Msg_AddCookie__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PCookieService", mozilla::ipc::ChildSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PCookieServiceChild",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PCookieService::Msg_AddCookie", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__cookie = IPC::ReadParam<CookieStruct>((&(reader__)));
            if (!maybe__cookie) {
                FatalError("Error deserializing 'CookieStruct'");
                return MsgValueError;

            }
            auto& cookie = *maybe__cookie;
            // Sentinel = 'cookie'
            if ((!(((&(reader__)))->ReadSentinel(146211451)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'CookieStruct'");
                return MsgValueError;
            }
            auto maybe__attrs = IPC::ReadParam<OriginAttributes>((&(reader__)));
            if (!maybe__attrs) {
                FatalError("Error deserializing 'OriginAttributes'");
                return MsgValueError;

            }
            auto& attrs = *maybe__attrs;
            // Sentinel = 'attrs'
            if ((!(((&(reader__)))->ReadSentinel(107807279)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'OriginAttributes'");
                return MsgValueError;
            }
            auto maybe__operationId = IPC::ReadParam<mozilla::Maybe<nsID>>((&(reader__)));
            if (!maybe__operationId) {
                FatalError("Error deserializing 'nsID?'");
                return MsgValueError;

            }
            auto& operationId = *maybe__operationId;
            // Sentinel = 'operationId'
            if ((!(((&(reader__)))->ReadSentinel(464847999)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'nsID?'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::IPCResult __ok = (static_cast<CookieServiceChild*>(this))->RecvAddCookie(std::move(cookie), std::move(attrs), std::move(operationId));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    default:
        return MsgNotKnown;
    }
}

auto PCookieServiceChild::OnMessageReceived(
        const Message& msg__,
        UniquePtr<Message>& reply__) -> PCookieServiceChild::Result
{
    return MsgNotKnown;
}



} // namespace net
} // namespace mozilla
namespace IPC {
auto ParamTraits<::mozilla::net::PCookieServiceChild*>::Write(
        IPC::MessageWriter* aWriter,
        const paramType& aVar) -> void
{
    MOZ_RELEASE_ASSERT(
        aWriter->GetActor(),
        "Cannot serialize managed actors without an actor");

    int32_t id;
    if (!aVar) {
        id = 0;  // kNullActorId
    } else {
        id = aVar->Id();
        if (id == 1) {  // kFreedActorId
            aVar->FatalError("Actor has been |delete|d");
        }
        MOZ_RELEASE_ASSERT(
            aWriter->GetActor()->GetIPCChannel() == aVar->GetIPCChannel(),
            "Actor must be from the same channel as the"
            " actor it's being sent over");
        MOZ_RELEASE_ASSERT(
            aVar->CanSend(),
            "Actor must still be open when sending");
    }

    IPC::WriteParam(aWriter, id);
}

auto ParamTraits<::mozilla::net::PCookieServiceChild*>::Read(IPC::MessageReader* aReader) -> IPC::ReadResult<paramType>
{
    MOZ_RELEASE_ASSERT(
        aReader->GetActor(),
        "Cannot deserialize managed actors without an actor");
    mozilla::Maybe<mozilla::ipc::IProtocol*> actor = aReader->GetActor()
        ->ReadActor(aReader, true, "PCookieService", PCookieServiceMsgStart);
    if (actor.isSome()) {
        return static_cast<::mozilla::net::PCookieServiceChild*>(actor.ref());
    }
    return {};
}

} // namespace IPC
