//
// Automatically generated by ipdlc.
// Edit at your own risk
//


#include "mozilla/layers/PCompositorManagerParent.h"
#include "gfxipc/ShadowLayerUtils.h"
#include "mozilla/GfxMessageUtils.h"
#include "mozilla/ProfilerLabels.h"
#include "mozilla/ipc/IPCCore.h"
#include "mozilla/layers/CompositorManagerParent.h"
#include "mozilla/layers/LayersMessageUtils.h"
#include "mozilla/layers/WebRenderMessageUtils.h"

#include "mozilla/gfx/PCanvasManagerParent.h"
#include "mozilla/layers/PCompositorBridgeParent.h"

#include "ipc/IPCMessageUtils.h"
#include "ipc/IPCMessageUtilsSpecializations.h"
#include "nsIFile.h"
#include "mozilla/ipc/Endpoint.h"
#include "mozilla/ipc/ProtocolMessageUtils.h"
#include "mozilla/ipc/ProtocolUtils.h"
#include "mozilla/ipc/ShmemMessageUtils.h"
#include "mozilla/ipc/TaintingIPCUtils.h"

namespace mozilla {
namespace layers {


auto PCompositorManagerParent::RecvPCompositorBridgeConstructor(
        PCompositorBridgeParent* actor,
        const CompositorBridgeOptions& options) -> mozilla::ipc::IPCResult
{
    return IPC_OK();
}

auto PCompositorManagerParent::ProcessingError(
        Result aCode,
        const char* aReason) -> void
{
}

auto PCompositorManagerParent::ShouldContinueFromReplyTimeout() -> bool
{
    return true;
}

MOZ_IMPLICIT PCompositorManagerParent::PCompositorManagerParent() :
    mozilla::ipc::IToplevelProtocol("PCompositorManagerParent", kProtocolId, mozilla::ipc::ParentSide)
{
    MOZ_COUNT_CTOR(PCompositorManagerParent);
}

PCompositorManagerParent::~PCompositorManagerParent()
{
    MOZ_COUNT_DTOR(PCompositorManagerParent);
}

auto PCompositorManagerParent::ActorAlloc() -> void
{
    MOZ_RELEASE_ASSERT(XRE_IsParentProcess() || XRE_IsGPUProcess(), "Invalid process for `PCompositorManagerParent'");
    AddRef();
}

auto PCompositorManagerParent::ActorDealloc() -> void
{
    Release();
}

auto PCompositorManagerParent::OtherPid() const -> ::base::ProcessId
{
    ::base::ProcessId pid =
        ::mozilla::ipc::IProtocol::ToplevelProtocol()->OtherPidMaybeInvalid();
    MOZ_RELEASE_ASSERT(pid != ::base::kInvalidProcessId);
    return pid;
}

auto PCompositorManagerParent::OtherChildID() const -> ::GeckoChildID
{
    ::GeckoChildID childID =
        ::mozilla::ipc::IProtocol::ToplevelProtocol()->OtherChildIDMaybeInvalid();
    MOZ_RELEASE_ASSERT(childID != -1);
    return childID;
}

auto PCompositorManagerParent::OtherEndpointProcInfo() const -> ::mozilla::ipc::EndpointProcInfo
{
    return ::mozilla::ipc::EndpointProcInfo{OtherPid(), OtherChildID()};
}

auto PCompositorManagerParent::ManagedPCompositorBridgeParent(nsTArray<PCompositorBridgeParent*>& aArr) const -> void
{
    mManagedPCompositorBridgeParent.ToArray(aArr);
}

auto PCompositorManagerParent::ManagedPCompositorBridgeParent() const -> const ManagedContainer<PCompositorBridgeParent>&
{
    return mManagedPCompositorBridgeParent;
}

auto PCompositorManagerParent::ManagedProtocolIds() const -> mozilla::Span<mozilla::ipc::ProtocolId const>
{
    static constexpr ::mozilla::ipc::ProtocolId sIds[] = {
        PCompositorBridgeMsgStart
    };
    return sIds;
}

auto PCompositorManagerParent::GetManagedActors(mozilla::ipc::ProtocolId aProtocol) -> UntypedManagedContainer*
{
    switch (aProtocol) {
    case PCompositorBridgeMsgStart:
        return (&(mManagedPCompositorBridgeParent));
    default:
        return nullptr;
    }
}

auto PCompositorManagerParent::RejectPendingResponses(ResponseRejectReason aReason) -> void
{
    mAsyncCallbacks.RejectPendingResponses(aReason);
}

auto PCompositorManagerParent::OpenPCompositorBridgeEndpoint(PCompositorBridgeParent* aActor) -> ManagedEndpoint<PCompositorBridgeChild>
{
    if (!aActor) {
        NS_WARNING("Cannot bind null PCompositorBridgeParent actor");
        return ManagedEndpoint<PCompositorBridgeChild>();
    }

    if (!aActor->SetManagerAndRegister(this)) {
        NS_WARNING("Failed to bind PCompositorBridgeParent actor");
        return ManagedEndpoint<PCompositorBridgeChild>();
    }

    // Mark our actor as awaiting the other side to be bound. This will
    // be cleared when a `MANAGED_ENDPOINT_{DROPPED,BOUND}` message is
    // received.
    aActor->mAwaitingManagedEndpointBind = true;
    return ManagedEndpoint<PCompositorBridgeChild>(mozilla::ipc::PrivateIPDLInterface(), aActor);
}

auto PCompositorManagerParent::BindPCompositorBridgeEndpoint(
        ManagedEndpoint<PCompositorBridgeParent> aEndpoint,
        PCompositorBridgeParent* aActor) -> bool
{
    return aEndpoint.Bind(mozilla::ipc::PrivateIPDLInterface(), aActor, this);
}

auto PCompositorManagerParent::SendNotifyWebRenderError(const WebRenderError& error) -> bool
{
    UniquePtr<IPC::Message> msg__ = PCompositorManager::Msg_NotifyWebRenderError(MSG_ROUTING_CONTROL);
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), error);
    // Sentinel = 'error'
    ((&(writer__)))->WriteSentinel(107741739);




    if (mozilla::ipc::LoggingEnabledFor("PCompositorManager", mozilla::ipc::ParentSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PCompositorManagerParent",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PCompositorManager::Msg_NotifyWebRenderError", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PCompositorManagerParent::DeallocManagee(
        int32_t aProtocolId,
        IProtocol* aListener) -> void
{
    switch (aProtocolId) {
    default:
        FatalError("unreached");
        return;
    }
}

auto PCompositorManagerParent::OnMessageReceived(const Message& msg__) -> PCompositorManagerParent::Result
{
    int32_t route__ = msg__.routing_id();
    if (MSG_ROUTING_CONTROL != route__) {
        IProtocol* routed__ = Lookup(route__);
        if (!routed__ || !routed__->GetLifecycleProxy()) {
            if (mozilla::ipc::LoggingEnabledFor("PCompositorManager", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PCompositorManagerParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Ignored message for dead actor",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eSending);
            }
            return MsgProcessed;

        }

        RefPtr<mozilla::ipc::ActorLifecycleProxy> proxy__ =
            routed__->GetLifecycleProxy();
        return proxy__->Get()->OnMessageReceived(msg__);
    }

    switch (msg__.type()) {
    case PCompositorManager::Msg_PCompositorBridgeConstructor__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PCompositorManager", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PCompositorManagerParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PCompositorManager::Msg_PCompositorBridgeConstructor", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__handle__ = IPC::ReadParam<ActorHandle>((&(reader__)));
            if (!maybe__handle__) {
                FatalError("Error deserializing 'ActorHandle'");
                return MsgValueError;

            }
            auto& handle__ = *maybe__handle__;
            // Sentinel = 'actor'
            if ((!(((&(reader__)))->ReadSentinel(102892058)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'ActorHandle'");
                return MsgValueError;
            }
            auto maybe__options = IPC::ReadParam<CompositorBridgeOptions>((&(reader__)));
            if (!maybe__options) {
                FatalError("Error deserializing 'CompositorBridgeOptions'");
                return MsgValueError;

            }
            auto& options = *maybe__options;
            // Sentinel = 'options'
            if ((!(((&(reader__)))->ReadSentinel(204735245)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'CompositorBridgeOptions'");
                return MsgValueError;
            }
            reader__.EndRead();
            RefPtr<PCompositorBridgeParent> actor = (static_cast<CompositorManagerParent*>(this))->AllocPCompositorBridgeParent(options);
            if (!actor) {
                NS_WARNING("Cannot bind null PCompositorBridgeParent actor");
                return MsgValueError;
            }

            if (!actor->SetManagerAndRegister(this, (handle__).mId)) {
                NS_WARNING("Failed to bind PCompositorBridgeParent actor");
                return MsgValueError;
            }

            mozilla::ipc::IPCResult __ok = (static_cast<CompositorManagerParent*>(this))->RecvPCompositorBridgeConstructor(actor, std::move(options));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PCompositorManager::Msg_AddSharedSurface__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PCompositorManager", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PCompositorManagerParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PCompositorManager::Msg_AddSharedSurface", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__aId = IPC::ReadParam<ExternalImageId>((&(reader__)));
            if (!maybe__aId) {
                FatalError("Error deserializing 'ExternalImageId'");
                return MsgValueError;

            }
            auto& aId = *maybe__aId;
            // Sentinel = 'aId'
            if ((!(((&(reader__)))->ReadSentinel(35389711)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'ExternalImageId'");
                return MsgValueError;
            }
            auto maybe__aDesc = IPC::ReadParam<SurfaceDescriptorShared>((&(reader__)));
            if (!maybe__aDesc) {
                FatalError("Error deserializing 'SurfaceDescriptorShared'");
                return MsgValueError;

            }
            auto& aDesc = *maybe__aDesc;
            // Sentinel = 'aDesc'
            if ((!(((&(reader__)))->ReadSentinel(91357665)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'SurfaceDescriptorShared'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::IPCResult __ok = (static_cast<CompositorManagerParent*>(this))->RecvAddSharedSurface(std::move(aId), std::move(aDesc));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PCompositorManager::Msg_RemoveSharedSurface__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PCompositorManager", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PCompositorManagerParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PCompositorManager::Msg_RemoveSharedSurface", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__aId = IPC::ReadParam<ExternalImageId>((&(reader__)));
            if (!maybe__aId) {
                FatalError("Error deserializing 'ExternalImageId'");
                return MsgValueError;

            }
            auto& aId = *maybe__aId;
            // Sentinel = 'aId'
            if ((!(((&(reader__)))->ReadSentinel(35389711)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'ExternalImageId'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::IPCResult __ok = (static_cast<CompositorManagerParent*>(this))->RecvRemoveSharedSurface(std::move(aId));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PCompositorManager::Msg_ReportSharedSurfacesMemory__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PCompositorManager", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PCompositorManagerParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PCompositorManager::Msg_ReportSharedSurfacesMemory", OTHER);

            int32_t id__ = MSG_ROUTING_CONTROL;
            UniquePtr<IPC::Message> reply__(PCompositorManager::Reply_ReportSharedSurfacesMemory(id__));
            reply__->set_seqno(msg__.seqno());

            RefPtr<mozilla::ipc::IPDLResolverInner> resolver__ =
                new mozilla::ipc::IPDLResolverInner(std::move(reply__), this);

            ReportSharedSurfacesMemoryResolver resolver = [resolver__ = std::move(resolver__)](const SharedSurfacesMemoryReport& aParam) {
                resolver__->Resolve([&] (IPC::Message* reply__, IProtocol* self__) {
                    IPC::MessageWriter writer__(*reply__, self__);
                    IPC::WriteParam((&(writer__)), aParam);
                    // Sentinel = 'aReport'
                    ((&(writer__)))->WriteSentinel(184025822);

                    if (mozilla::ipc::LoggingEnabledFor("PCompositorManager", mozilla::ipc::ParentSide)) {
                        mozilla::ipc::LogMessageForProtocol(
                            "PCompositorManagerParent",
                            self__->ToplevelProtocol()->OtherPidMaybeInvalid(),
                            "Sending reply ",
                            reply__->type(),
                            mozilla::ipc::MessageDirection::eSending);
                    }

                });
            };
            mozilla::ipc::IPCResult __ok = (static_cast<CompositorManagerParent*>(this))->RecvReportSharedSurfacesMemory(std::move(resolver));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PCompositorManager::Msg_NotifyMemoryPressure__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PCompositorManager", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PCompositorManagerParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PCompositorManager::Msg_NotifyMemoryPressure", OTHER);

            mozilla::ipc::IPCResult __ok = (static_cast<CompositorManagerParent*>(this))->RecvNotifyMemoryPressure();
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PCompositorManager::Msg_ReportMemory__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PCompositorManager", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PCompositorManagerParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PCompositorManager::Msg_ReportMemory", OTHER);

            int32_t id__ = MSG_ROUTING_CONTROL;
            UniquePtr<IPC::Message> reply__(PCompositorManager::Reply_ReportMemory(id__));
            reply__->set_seqno(msg__.seqno());

            RefPtr<mozilla::ipc::IPDLResolverInner> resolver__ =
                new mozilla::ipc::IPDLResolverInner(std::move(reply__), this);

            ReportMemoryResolver resolver = [resolver__ = std::move(resolver__)](const MemoryReport& aParam) {
                resolver__->Resolve([&] (IPC::Message* reply__, IProtocol* self__) {
                    IPC::MessageWriter writer__(*reply__, self__);
                    IPC::WriteParam((&(writer__)), aParam);
                    // Sentinel = 'aReport'
                    ((&(writer__)))->WriteSentinel(184025822);

                    if (mozilla::ipc::LoggingEnabledFor("PCompositorManager", mozilla::ipc::ParentSide)) {
                        mozilla::ipc::LogMessageForProtocol(
                            "PCompositorManagerParent",
                            self__->ToplevelProtocol()->OtherPidMaybeInvalid(),
                            "Sending reply ",
                            reply__->type(),
                            mozilla::ipc::MessageDirection::eSending);
                    }

                });
            };
            mozilla::ipc::IPCResult __ok = (static_cast<CompositorManagerParent*>(this))->RecvReportMemory(std::move(resolver));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PCompositorManager::Msg_InitCanvasManager__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PCompositorManager", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PCompositorManagerParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PCompositorManager::Msg_InitCanvasManager", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__endpoint = IPC::ReadParam<Endpoint<::mozilla::gfx::PCanvasManagerParent>>((&(reader__)));
            if (!maybe__endpoint) {
                FatalError("Error deserializing 'Endpoint<::mozilla::gfx::PCanvasManagerParent>'");
                return MsgValueError;

            }
            auto& endpoint = *maybe__endpoint;
            // Sentinel = 'endpoint'
            if ((!(((&(reader__)))->ReadSentinel(251724642)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'Endpoint<::mozilla::gfx::PCanvasManagerParent>'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::IPCResult __ok = (static_cast<CompositorManagerParent*>(this))->RecvInitCanvasManager(std::move(endpoint));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    default:
        return MsgNotKnown;
    case SHMEM_CREATED_MESSAGE_TYPE:
        {
            if (!ShmemCreated(msg__)) {
                return MsgPayloadError;
            }
            return MsgProcessed;
        }
    case SHMEM_DESTROYED_MESSAGE_TYPE:
        {
            if (!ShmemDestroyed(msg__)) {
                return MsgPayloadError;
            }
            return MsgProcessed;
        }
    }
}

auto PCompositorManagerParent::OnMessageReceived(
        const Message& msg__,
        UniquePtr<Message>& reply__) -> PCompositorManagerParent::Result
{
    int32_t route__ = msg__.routing_id();
    if (MSG_ROUTING_CONTROL != route__) {
        IProtocol* routed__ = Lookup(route__);
        if (!routed__ || !routed__->GetLifecycleProxy()) {
            return MsgDropped;

        }

        RefPtr<mozilla::ipc::ActorLifecycleProxy> proxy__ =
            routed__->GetLifecycleProxy();
        return proxy__->Get()->OnMessageReceived(msg__, reply__);
    }

    return MsgNotKnown;
}



} // namespace layers
} // namespace mozilla
namespace IPC {
auto ParamTraits<::mozilla::layers::PCompositorManagerParent*>::Write(
        IPC::MessageWriter* aWriter,
        const paramType& aVar) -> void
{
    MOZ_RELEASE_ASSERT(
        aWriter->GetActor(),
        "Cannot serialize managed actors without an actor");

    int32_t id;
    if (!aVar) {
        id = 0;  // kNullActorId
    } else {
        id = aVar->Id();
        if (id == 1) {  // kFreedActorId
            aVar->FatalError("Actor has been |delete|d");
        }
        MOZ_RELEASE_ASSERT(
            aWriter->GetActor()->GetIPCChannel() == aVar->GetIPCChannel(),
            "Actor must be from the same channel as the"
            " actor it's being sent over");
        MOZ_RELEASE_ASSERT(
            aVar->CanSend(),
            "Actor must still be open when sending");
    }

    IPC::WriteParam(aWriter, id);
}

auto ParamTraits<::mozilla::layers::PCompositorManagerParent*>::Read(IPC::MessageReader* aReader) -> IPC::ReadResult<paramType>
{
    MOZ_RELEASE_ASSERT(
        aReader->GetActor(),
        "Cannot deserialize managed actors without an actor");
    mozilla::Maybe<mozilla::ipc::IProtocol*> actor = aReader->GetActor()
        ->ReadActor(aReader, true, "PCompositorManager", PCompositorManagerMsgStart);
    if (actor.isSome()) {
        return static_cast<::mozilla::layers::PCompositorManagerParent*>(actor.ref());
    }
    return {};
}

} // namespace IPC
