//
// Automatically generated by ipdlc.
// Edit at your own risk
//


#include "mozilla/dom/PClientManagerParent.h"
#include "ipc/ErrorIPCUtils.h"
#include "mozilla/ProfilerLabels.h"
#include "mozilla/dom/BindingIPCUtils.h"
#include "mozilla/dom/ClientIPCUtils.h"

#include "mozilla/ipc/PBackgroundParent.h"
#include "mozilla/dom/PClientHandleParent.h"
#include "mozilla/dom/PClientManagerOpParent.h"
#include "mozilla/dom/PClientNavigateOpParent.h"
#include "mozilla/dom/PClientSourceParent.h"

#include "ipc/IPCMessageUtils.h"
#include "ipc/IPCMessageUtilsSpecializations.h"
#include "nsIFile.h"
#include "mozilla/ipc/Endpoint.h"
#include "mozilla/ipc/ProtocolMessageUtils.h"
#include "mozilla/ipc/ProtocolUtils.h"
#include "mozilla/ipc/ShmemMessageUtils.h"
#include "mozilla/ipc/TaintingIPCUtils.h"

namespace mozilla {
namespace dom {


auto PClientManagerParent::RecvPClientHandleConstructor(
        PClientHandleParent* actor,
        const IPCClientInfo& aClientInfo) -> mozilla::ipc::IPCResult
{
    return IPC_OK();
}

auto PClientManagerParent::RecvPClientManagerOpConstructor(
        PClientManagerOpParent* actor,
        const ClientOpConstructorArgs& aArgs) -> mozilla::ipc::IPCResult
{
    return IPC_OK();
}

auto PClientManagerParent::RecvPClientSourceConstructor(
        PClientSourceParent* actor,
        const ClientSourceConstructorArgs& aArgs) -> mozilla::ipc::IPCResult
{
    return IPC_OK();
}

MOZ_IMPLICIT PClientManagerParent::PClientManagerParent() :
    mozilla::ipc::IRefCountedProtocol(kProtocolId, mozilla::ipc::ParentSide)
{
    MOZ_COUNT_CTOR(PClientManagerParent);
}

PClientManagerParent::~PClientManagerParent()
{
    MOZ_COUNT_DTOR(PClientManagerParent);
}

auto PClientManagerParent::ActorAlloc() -> void
{
    AddRef();
}

auto PClientManagerParent::ActorDealloc() -> void
{
    Release();
}

auto PClientManagerParent::OtherPid() const -> ::base::ProcessId
{
    ::base::ProcessId pid =
        ::mozilla::ipc::IProtocol::ToplevelProtocol()->OtherPidMaybeInvalid();
    MOZ_RELEASE_ASSERT(pid != ::base::kInvalidProcessId);
    return pid;
}

auto PClientManagerParent::OtherChildID() const -> ::GeckoChildID
{
    ::GeckoChildID childID =
        ::mozilla::ipc::IProtocol::ToplevelProtocol()->OtherChildIDMaybeInvalid();
    MOZ_RELEASE_ASSERT(childID != -1);
    return childID;
}

auto PClientManagerParent::OtherEndpointProcInfo() const -> ::mozilla::ipc::EndpointProcInfo
{
    return ::mozilla::ipc::EndpointProcInfo{OtherPid(), OtherChildID()};
}

auto PClientManagerParent::Manager() const -> PBackgroundParent*
{
    return static_cast<PBackgroundParent*>(IProtocol::Manager());
}

auto PClientManagerParent::ManagedPClientHandleParent(nsTArray<PClientHandleParent*>& aArr) const -> void
{
    mManagedPClientHandleParent.ToArray(aArr);
}

auto PClientManagerParent::ManagedPClientHandleParent() const -> const ManagedContainer<PClientHandleParent>&
{
    return mManagedPClientHandleParent;
}

auto PClientManagerParent::ManagedPClientManagerOpParent(nsTArray<PClientManagerOpParent*>& aArr) const -> void
{
    mManagedPClientManagerOpParent.ToArray(aArr);
}

auto PClientManagerParent::ManagedPClientManagerOpParent() const -> const ManagedContainer<PClientManagerOpParent>&
{
    return mManagedPClientManagerOpParent;
}

auto PClientManagerParent::ManagedPClientNavigateOpParent(nsTArray<PClientNavigateOpParent*>& aArr) const -> void
{
    mManagedPClientNavigateOpParent.ToArray(aArr);
}

auto PClientManagerParent::ManagedPClientNavigateOpParent() const -> const ManagedContainer<PClientNavigateOpParent>&
{
    return mManagedPClientNavigateOpParent;
}

auto PClientManagerParent::ManagedPClientSourceParent(nsTArray<PClientSourceParent*>& aArr) const -> void
{
    mManagedPClientSourceParent.ToArray(aArr);
}

auto PClientManagerParent::ManagedPClientSourceParent() const -> const ManagedContainer<PClientSourceParent>&
{
    return mManagedPClientSourceParent;
}

auto PClientManagerParent::ManagedProtocolIds() const -> mozilla::Span<mozilla::ipc::ProtocolId const>
{
    static constexpr ::mozilla::ipc::ProtocolId sIds[] = {
        PClientHandleMsgStart,
        PClientManagerOpMsgStart,
        PClientNavigateOpMsgStart,
        PClientSourceMsgStart
    };
    return sIds;
}

auto PClientManagerParent::GetManagedActors(mozilla::ipc::ProtocolId aProtocol) -> UntypedManagedContainer*
{
    switch (aProtocol) {
    case PClientHandleMsgStart:
        return (&(mManagedPClientHandleParent));
    case PClientManagerOpMsgStart:
        return (&(mManagedPClientManagerOpParent));
    case PClientNavigateOpMsgStart:
        return (&(mManagedPClientNavigateOpParent));
    case PClientSourceMsgStart:
        return (&(mManagedPClientSourceParent));
    default:
        return nullptr;
    }
}

auto PClientManagerParent::OpenPClientHandleEndpoint(PClientHandleParent* aActor) -> ManagedEndpoint<PClientHandleChild>
{
    if (!aActor) {
        NS_WARNING("Cannot bind null PClientHandleParent actor");
        return ManagedEndpoint<PClientHandleChild>();
    }

    if (!aActor->SetManagerAndRegister(this)) {
        NS_WARNING("Failed to bind PClientHandleParent actor");
        return ManagedEndpoint<PClientHandleChild>();
    }

    // Mark our actor as awaiting the other side to be bound. This will
    // be cleared when a `MANAGED_ENDPOINT_{DROPPED,BOUND}` message is
    // received.
    aActor->mAwaitingManagedEndpointBind = true;
    return ManagedEndpoint<PClientHandleChild>(mozilla::ipc::PrivateIPDLInterface(), aActor);
}

auto PClientManagerParent::BindPClientHandleEndpoint(
        ManagedEndpoint<PClientHandleParent> aEndpoint,
        PClientHandleParent* aActor) -> bool
{
    return aEndpoint.Bind(mozilla::ipc::PrivateIPDLInterface(), aActor, this);
}

auto PClientManagerParent::OpenPClientManagerOpEndpoint(PClientManagerOpParent* aActor) -> ManagedEndpoint<PClientManagerOpChild>
{
    if (!aActor) {
        NS_WARNING("Cannot bind null PClientManagerOpParent actor");
        return ManagedEndpoint<PClientManagerOpChild>();
    }

    if (!aActor->SetManagerAndRegister(this)) {
        NS_WARNING("Failed to bind PClientManagerOpParent actor");
        return ManagedEndpoint<PClientManagerOpChild>();
    }

    // Mark our actor as awaiting the other side to be bound. This will
    // be cleared when a `MANAGED_ENDPOINT_{DROPPED,BOUND}` message is
    // received.
    aActor->mAwaitingManagedEndpointBind = true;
    return ManagedEndpoint<PClientManagerOpChild>(mozilla::ipc::PrivateIPDLInterface(), aActor);
}

auto PClientManagerParent::BindPClientManagerOpEndpoint(
        ManagedEndpoint<PClientManagerOpParent> aEndpoint,
        PClientManagerOpParent* aActor) -> bool
{
    return aEndpoint.Bind(mozilla::ipc::PrivateIPDLInterface(), aActor, this);
}

auto PClientManagerParent::OpenPClientNavigateOpEndpoint(PClientNavigateOpParent* aActor) -> ManagedEndpoint<PClientNavigateOpChild>
{
    if (!aActor) {
        NS_WARNING("Cannot bind null PClientNavigateOpParent actor");
        return ManagedEndpoint<PClientNavigateOpChild>();
    }

    if (!aActor->SetManagerAndRegister(this)) {
        NS_WARNING("Failed to bind PClientNavigateOpParent actor");
        return ManagedEndpoint<PClientNavigateOpChild>();
    }

    // Mark our actor as awaiting the other side to be bound. This will
    // be cleared when a `MANAGED_ENDPOINT_{DROPPED,BOUND}` message is
    // received.
    aActor->mAwaitingManagedEndpointBind = true;
    return ManagedEndpoint<PClientNavigateOpChild>(mozilla::ipc::PrivateIPDLInterface(), aActor);
}

auto PClientManagerParent::BindPClientNavigateOpEndpoint(
        ManagedEndpoint<PClientNavigateOpParent> aEndpoint,
        PClientNavigateOpParent* aActor) -> bool
{
    return aEndpoint.Bind(mozilla::ipc::PrivateIPDLInterface(), aActor, this);
}

auto PClientManagerParent::OpenPClientSourceEndpoint(PClientSourceParent* aActor) -> ManagedEndpoint<PClientSourceChild>
{
    if (!aActor) {
        NS_WARNING("Cannot bind null PClientSourceParent actor");
        return ManagedEndpoint<PClientSourceChild>();
    }

    if (!aActor->SetManagerAndRegister(this)) {
        NS_WARNING("Failed to bind PClientSourceParent actor");
        return ManagedEndpoint<PClientSourceChild>();
    }

    // Mark our actor as awaiting the other side to be bound. This will
    // be cleared when a `MANAGED_ENDPOINT_{DROPPED,BOUND}` message is
    // received.
    aActor->mAwaitingManagedEndpointBind = true;
    return ManagedEndpoint<PClientSourceChild>(mozilla::ipc::PrivateIPDLInterface(), aActor);
}

auto PClientManagerParent::BindPClientSourceEndpoint(
        ManagedEndpoint<PClientSourceParent> aEndpoint,
        PClientSourceParent* aActor) -> bool
{
    return aEndpoint.Bind(mozilla::ipc::PrivateIPDLInterface(), aActor, this);
}

auto PClientManagerParent::SendPClientNavigateOpConstructor(const ClientNavigateOpConstructorArgs& aArgs) -> PClientNavigateOpParent*
{
    PClientNavigateOpParent* actor = (this)->AllocPClientNavigateOpParent(aArgs);
    return SendPClientNavigateOpConstructor(std::move(actor), std::move(aArgs));
}

auto PClientManagerParent::SendPClientNavigateOpConstructor(
        PClientNavigateOpParent* actor,
        const ClientNavigateOpConstructorArgs& aArgs) -> PClientNavigateOpParent*
{
    if (!actor) {
        NS_WARNING("Cannot bind null PClientNavigateOpParent actor");
        return nullptr;
    }

    if (!actor->SetManagerAndRegister(this)) {
        NS_WARNING("Failed to bind PClientNavigateOpParent actor");
        return nullptr;
    }


    // Build our constructor message.
    UniquePtr<IPC::Message> msg__ = PClientManager::Msg_PClientNavigateOpConstructor(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), actor);
    // Sentinel = 'actor'
    ((&(writer__)))->WriteSentinel(102892058);
    IPC::WriteParam((&(writer__)), aArgs);
    // Sentinel = 'aArgs'
    ((&(writer__)))->WriteSentinel(92602863);




    // Notify the other side about the newly created actor. This can
    // fail if our manager has already been destroyed.
    //
    // NOTE: If the send call fails due to toplevel channel teardown,
    // the `IProtocol::ChannelSend` wrapper absorbs the error for us,
    // so we don't tear down actors unexpectedly.

    if (mozilla::ipc::LoggingEnabledFor("PClientManager", mozilla::ipc::ParentSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PClientManagerParent",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PClientManager::Msg_PClientNavigateOpConstructor", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));


    // Warn, destroy the actor, and return null if the message failed to
    // send. Otherwise, return the successfully created actor reference.
    if (!sendok__) {
        NS_WARNING("Error sending PClientNavigateOpParent constructor");
        actor->ActorDisconnected(FailedConstructor);

        return nullptr;
    }
    return actor;
}

auto PClientManagerParent::Send__delete__(PClientManagerParent* actor) -> bool
{
    if (!actor || !actor->CanSend()) {
        NS_WARNING("Attempt to __delete__ missing or closed actor");
        return false;
    }
    UniquePtr<IPC::Message> msg__ = PClientManager::Msg___delete__((actor)->Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            actor};




    if (mozilla::ipc::LoggingEnabledFor("PClientManager", mozilla::ipc::ParentSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PClientManagerParent",
            actor->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PClientManager::Msg___delete__", OTHER);

    bool sendok__ = (actor)->ChannelSend(std::move(msg__));

    actor->ActorDisconnected(Deletion);
    return sendok__;
}

auto PClientManagerParent::DeallocManagee(
        int32_t aProtocolId,
        IProtocol* aListener) -> void
{
    switch (aProtocolId) {
    case PClientManagerOpMsgStart:
        this->DeallocPClientManagerOpParent(static_cast<PClientManagerOpParent*>(aListener));
        return;
    case PClientNavigateOpMsgStart:
        this->DeallocPClientNavigateOpParent(static_cast<PClientNavigateOpParent*>(aListener));
        return;
    default:
        FatalError("unreached");
        return;
    }
}

auto PClientManagerParent::OnMessageReceived(const Message& msg__) -> PClientManagerParent::Result
{
    switch (msg__.type()) {
    case MANAGED_ENDPOINT_BOUND_MESSAGE_TYPE:
        {
            if (!mAwaitingManagedEndpointBind) {
                NS_WARNING("Unexpected managed endpoint lifecycle message after actor bound!");
                return MsgNotAllowed;
            }
            mAwaitingManagedEndpointBind = false;
            return MsgProcessed;
        }
    case MANAGED_ENDPOINT_DROPPED_MESSAGE_TYPE:
        {
            if (!mAwaitingManagedEndpointBind) {
                NS_WARNING("Unexpected managed endpoint lifecycle message after actor bound!");
                return MsgNotAllowed;
            }
            mAwaitingManagedEndpointBind = false;
            this->ActorDisconnected(ManagedEndpointDropped);
            return MsgProcessed;
        }
    case PClientManager::Msg_Teardown__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PClientManager", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PClientManagerParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PClientManager::Msg_Teardown", OTHER);

            mozilla::ipc::IPCResult __ok = (this)->RecvTeardown();
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PClientManager::Msg_PClientHandleConstructor__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PClientManager", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PClientManagerParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PClientManager::Msg_PClientHandleConstructor", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__handle__ = IPC::ReadParam<ActorHandle>((&(reader__)));
            if (!maybe__handle__) {
                FatalError("Error deserializing 'ActorHandle'");
                return MsgValueError;

            }
            auto& handle__ = *maybe__handle__;
            // Sentinel = 'actor'
            if ((!(((&(reader__)))->ReadSentinel(102892058)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'ActorHandle'");
                return MsgValueError;
            }
            auto maybe__aClientInfo = IPC::ReadParam<IPCClientInfo>((&(reader__)));
            if (!maybe__aClientInfo) {
                FatalError("Error deserializing 'IPCClientInfo'");
                return MsgValueError;

            }
            auto& aClientInfo = *maybe__aClientInfo;
            // Sentinel = 'aClientInfo'
            if ((!(((&(reader__)))->ReadSentinel(422315085)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'IPCClientInfo'");
                return MsgValueError;
            }
            reader__.EndRead();
            RefPtr<PClientHandleParent> actor = (this)->AllocPClientHandleParent(aClientInfo);
            if (!actor) {
                NS_WARNING("Cannot bind null PClientHandleParent actor");
                return MsgValueError;
            }

            if (!actor->SetManagerAndRegister(this, (handle__).mId)) {
                NS_WARNING("Failed to bind PClientHandleParent actor");
                return MsgValueError;
            }

            mozilla::ipc::IPCResult __ok = (this)->RecvPClientHandleConstructor(actor, std::move(aClientInfo));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PClientManager::Msg_PClientManagerOpConstructor__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PClientManager", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PClientManagerParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PClientManager::Msg_PClientManagerOpConstructor", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__handle__ = IPC::ReadParam<ActorHandle>((&(reader__)));
            if (!maybe__handle__) {
                FatalError("Error deserializing 'ActorHandle'");
                return MsgValueError;

            }
            auto& handle__ = *maybe__handle__;
            // Sentinel = 'actor'
            if ((!(((&(reader__)))->ReadSentinel(102892058)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'ActorHandle'");
                return MsgValueError;
            }
            auto maybe__aArgs = IPC::ReadParam<ClientOpConstructorArgs>((&(reader__)));
            if (!maybe__aArgs) {
                FatalError("Error deserializing 'ClientOpConstructorArgs'");
                return MsgValueError;

            }
            auto& aArgs = *maybe__aArgs;
            // Sentinel = 'aArgs'
            if ((!(((&(reader__)))->ReadSentinel(92602863)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'ClientOpConstructorArgs'");
                return MsgValueError;
            }
            reader__.EndRead();
            PClientManagerOpParent* actor = (this)->AllocPClientManagerOpParent(aArgs);
            if (!actor) {
                NS_WARNING("Cannot bind null PClientManagerOpParent actor");
                return MsgValueError;
            }

            if (!actor->SetManagerAndRegister(this, (handle__).mId)) {
                NS_WARNING("Failed to bind PClientManagerOpParent actor");
                return MsgValueError;
            }

            mozilla::ipc::IPCResult __ok = (this)->RecvPClientManagerOpConstructor(std::move(actor), std::move(aArgs));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PClientManager::Msg_PClientSourceConstructor__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PClientManager", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PClientManagerParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PClientManager::Msg_PClientSourceConstructor", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__handle__ = IPC::ReadParam<ActorHandle>((&(reader__)));
            if (!maybe__handle__) {
                FatalError("Error deserializing 'ActorHandle'");
                return MsgValueError;

            }
            auto& handle__ = *maybe__handle__;
            // Sentinel = 'actor'
            if ((!(((&(reader__)))->ReadSentinel(102892058)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'ActorHandle'");
                return MsgValueError;
            }
            auto maybe__aArgs = IPC::ReadParam<ClientSourceConstructorArgs>((&(reader__)));
            if (!maybe__aArgs) {
                FatalError("Error deserializing 'ClientSourceConstructorArgs'");
                return MsgValueError;

            }
            auto& aArgs = *maybe__aArgs;
            // Sentinel = 'aArgs'
            if ((!(((&(reader__)))->ReadSentinel(92602863)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'ClientSourceConstructorArgs'");
                return MsgValueError;
            }
            reader__.EndRead();
            RefPtr<PClientSourceParent> actor = (this)->AllocPClientSourceParent(aArgs);
            if (!actor) {
                NS_WARNING("Cannot bind null PClientSourceParent actor");
                return MsgValueError;
            }

            if (!actor->SetManagerAndRegister(this, (handle__).mId)) {
                NS_WARNING("Failed to bind PClientSourceParent actor");
                return MsgValueError;
            }

            mozilla::ipc::IPCResult __ok = (this)->RecvPClientSourceConstructor(actor, std::move(aArgs));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PClientManager::Msg_ExpectFutureClientSource__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PClientManager", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PClientManagerParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PClientManager::Msg_ExpectFutureClientSource", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__aClientInfo = IPC::ReadParam<IPCClientInfo>((&(reader__)));
            if (!maybe__aClientInfo) {
                FatalError("Error deserializing 'IPCClientInfo'");
                return MsgValueError;

            }
            auto& aClientInfo = *maybe__aClientInfo;
            // Sentinel = 'aClientInfo'
            if ((!(((&(reader__)))->ReadSentinel(422315085)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'IPCClientInfo'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::IPCResult __ok = (this)->RecvExpectFutureClientSource(std::move(aClientInfo));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PClientManager::Msg_ForgetFutureClientSource__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PClientManager", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PClientManagerParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PClientManager::Msg_ForgetFutureClientSource", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__aClientInfo = IPC::ReadParam<IPCClientInfo>((&(reader__)));
            if (!maybe__aClientInfo) {
                FatalError("Error deserializing 'IPCClientInfo'");
                return MsgValueError;

            }
            auto& aClientInfo = *maybe__aClientInfo;
            // Sentinel = 'aClientInfo'
            if ((!(((&(reader__)))->ReadSentinel(422315085)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'IPCClientInfo'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::IPCResult __ok = (this)->RecvForgetFutureClientSource(std::move(aClientInfo));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PClientManager::Reply_PClientNavigateOpConstructor__ID:
        {
            return MsgProcessed;
        }
    case PClientManager::Reply___delete____ID:
        {
            return MsgProcessed;
        }
    default:
        return MsgNotKnown;
    }
}

auto PClientManagerParent::OnMessageReceived(
        const Message& msg__,
        UniquePtr<Message>& reply__) -> PClientManagerParent::Result
{
    return MsgNotKnown;
}



} // namespace dom
} // namespace mozilla
namespace IPC {
auto ParamTraits<::mozilla::dom::PClientManagerParent*>::Write(
        IPC::MessageWriter* aWriter,
        const paramType& aVar) -> void
{
    MOZ_RELEASE_ASSERT(
        aWriter->GetActor(),
        "Cannot serialize managed actors without an actor");

    int32_t id;
    if (!aVar) {
        id = 0;  // kNullActorId
    } else {
        id = aVar->Id();
        if (id == 1) {  // kFreedActorId
            aVar->FatalError("Actor has been |delete|d");
        }
        MOZ_RELEASE_ASSERT(
            aWriter->GetActor()->GetIPCChannel() == aVar->GetIPCChannel(),
            "Actor must be from the same channel as the"
            " actor it's being sent over");
        MOZ_RELEASE_ASSERT(
            aVar->CanSend(),
            "Actor must still be open when sending");
    }

    IPC::WriteParam(aWriter, id);
}

auto ParamTraits<::mozilla::dom::PClientManagerParent*>::Read(IPC::MessageReader* aReader) -> IPC::ReadResult<paramType>
{
    MOZ_RELEASE_ASSERT(
        aReader->GetActor(),
        "Cannot deserialize managed actors without an actor");
    mozilla::Maybe<mozilla::ipc::IProtocol*> actor = aReader->GetActor()
        ->ReadActor(aReader, true, "PClientManager", PClientManagerMsgStart);
    if (actor.isSome()) {
        return static_cast<::mozilla::dom::PClientManagerParent*>(actor.ref());
    }
    return {};
}

} // namespace IPC
