//
// Automatically generated by ipdlc.
// Edit at your own risk
//


#include "mozilla/gmp/PChromiumCDMParent.h"
#include "ChromiumCDMParent.h"
#include "GMPMessageUtils.h"
#include "mozilla/ProfilerLabels.h"

#include "mozilla/gmp/PGMPContentParent.h"

#include "ipc/IPCMessageUtils.h"
#include "ipc/IPCMessageUtilsSpecializations.h"
#include "nsIFile.h"
#include "mozilla/ipc/Endpoint.h"
#include "mozilla/ipc/ProtocolMessageUtils.h"
#include "mozilla/ipc/ProtocolUtils.h"
#include "mozilla/ipc/ShmemMessageUtils.h"
#include "mozilla/ipc/TaintingIPCUtils.h"

namespace mozilla {
namespace gmp {


auto PChromiumCDMParent::Recv__delete__() -> mozilla::ipc::IPCResult
{
    return IPC_OK();
}

MOZ_IMPLICIT PChromiumCDMParent::PChromiumCDMParent() :
    mozilla::ipc::IRefCountedProtocol(kProtocolId, mozilla::ipc::ParentSide)
{
    MOZ_COUNT_CTOR(PChromiumCDMParent);
}

PChromiumCDMParent::~PChromiumCDMParent()
{
    MOZ_COUNT_DTOR(PChromiumCDMParent);
}

auto PChromiumCDMParent::ActorAlloc() -> void
{
    AddRef();
}

auto PChromiumCDMParent::ActorDealloc() -> void
{
    Release();
}

auto PChromiumCDMParent::OtherPid() const -> ::base::ProcessId
{
    ::base::ProcessId pid =
        ::mozilla::ipc::IProtocol::ToplevelProtocol()->OtherPidMaybeInvalid();
    MOZ_RELEASE_ASSERT(pid != ::base::kInvalidProcessId);
    return pid;
}

auto PChromiumCDMParent::OtherChildID() const -> ::GeckoChildID
{
    ::GeckoChildID childID =
        ::mozilla::ipc::IProtocol::ToplevelProtocol()->OtherChildIDMaybeInvalid();
    MOZ_RELEASE_ASSERT(childID != -1);
    return childID;
}

auto PChromiumCDMParent::OtherEndpointProcInfo() const -> ::mozilla::ipc::EndpointProcInfo
{
    return ::mozilla::ipc::EndpointProcInfo{OtherPid(), OtherChildID()};
}

auto PChromiumCDMParent::Manager() const -> PGMPContentParent*
{
    return static_cast<PGMPContentParent*>(IProtocol::Manager());
}

auto PChromiumCDMParent::ManagedProtocolIds() const -> mozilla::Span<mozilla::ipc::ProtocolId const>
{
    return {};
}

auto PChromiumCDMParent::GetManagedActors(mozilla::ipc::ProtocolId aProtocol) -> UntypedManagedContainer*
{
    switch (aProtocol) {
    default:
        return nullptr;
    }
}

auto PChromiumCDMParent::RejectPendingResponses(ResponseRejectReason aReason) -> void
{
    mAsyncCallbacks.RejectPendingResponses(aReason);
}

auto PChromiumCDMParent::SendInit(
        const bool& aAllowDistinctiveIdentifier,
        const bool& aAllowPersistentState,
        mozilla::ipc::ResolveCallback<bool>&& aResolve,
        mozilla::ipc::RejectCallback&& aReject) -> void
{
    UniquePtr<IPC::Message> msg__ = PChromiumCDM::Msg_Init(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), aAllowDistinctiveIdentifier);
    // Sentinel = 'aAllowDistinctiveIdentifier'
    ((&(writer__)))->WriteSentinel(2530609898);
    IPC::WriteParam((&(writer__)), aAllowPersistentState);
    // Sentinel = 'aAllowPersistentState'
    ((&(writer__)))->WriteSentinel(1556285587);




    if (mozilla::ipc::LoggingEnabledFor("PChromiumCDM", mozilla::ipc::ParentSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PChromiumCDMParent",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PChromiumCDM::Msg_Init", OTHER);

    int32_t seqno__ = 0;
    if (ChannelSend(std::move(msg__), (&(seqno__)))) {
        mAsyncCallbacks.AddCallback(seqno__, PChromiumCDM::Reply_Init__ID, [resolve=std::move(aResolve)](IPC::MessageReader* aReader) mutable {
            auto maybe__aSuccess = IPC::ReadParam<bool>(aReader);
            if (!maybe__aSuccess) {
                (aReader)->FatalError("Error deserializing 'bool'");
                return MsgValueError;

            }
            auto& aSuccess = *maybe__aSuccess;
            // Sentinel = 'aSuccess'
            if ((!((aReader)->ReadSentinel(236323643)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'bool'");
                return MsgValueError;
            }


            aReader->EndRead();

            resolve(std::move(aSuccess));
            return MsgProcessed;
        }, std::move(aReject));
    }
    else {
        aReject(::mozilla::ipc::ResponseRejectReason::SendError);
    }
    return;
}

auto PChromiumCDMParent::SendInit(
        const bool& aAllowDistinctiveIdentifier,
        const bool& aAllowPersistentState) -> RefPtr<InitPromise>
{
    RefPtr<MozPromise<bool, ResponseRejectReason, true>::Private> promise__ = new MozPromise<bool, ResponseRejectReason, true>::Private(__func__);
    promise__->UseDirectTaskDispatch(__func__);
    SendInit(std::move(aAllowDistinctiveIdentifier), std::move(aAllowPersistentState), [promise__](bool&& aValue) {
        promise__->Resolve(std::move(aValue), __func__);
    }, [promise__](ResponseRejectReason&& aReason) {
        promise__->Reject(std::move(aReason), __func__);
    });
    return promise__;
}

auto PChromiumCDMParent::SendGetStatusForPolicy(
        const uint32_t& aPromiseId,
        const HdcpVersion& aMinHdcpVersion) -> bool
{
    UniquePtr<IPC::Message> msg__ = PChromiumCDM::Msg_GetStatusForPolicy(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), aPromiseId);
    // Sentinel = 'aPromiseId'
    ((&(writer__)))->WriteSentinel(365495278);
    IPC::WriteParam((&(writer__)), aMinHdcpVersion);
    // Sentinel = 'aMinHdcpVersion'
    ((&(writer__)))->WriteSentinel(766576107);




    if (mozilla::ipc::LoggingEnabledFor("PChromiumCDM", mozilla::ipc::ParentSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PChromiumCDMParent",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PChromiumCDM::Msg_GetStatusForPolicy", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PChromiumCDMParent::SendSetServerCertificate(
        const uint32_t& aPromiseId,
        mozilla::Span<uint8_t const> aServerCert) -> bool
{
    UniquePtr<IPC::Message> msg__ = PChromiumCDM::Msg_SetServerCertificate(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), aPromiseId);
    // Sentinel = 'aPromiseId'
    ((&(writer__)))->WriteSentinel(365495278);
    IPC::WriteParam((&(writer__)), aServerCert);
    // Sentinel = 'aServerCert'
    ((&(writer__)))->WriteSentinel(435553383);




    if (mozilla::ipc::LoggingEnabledFor("PChromiumCDM", mozilla::ipc::ParentSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PChromiumCDMParent",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PChromiumCDM::Msg_SetServerCertificate", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PChromiumCDMParent::SendCreateSessionAndGenerateRequest(
        const uint32_t& aPromiseId,
        const uint32_t& aSessionType,
        const uint32_t& aInitDataType,
        mozilla::Span<uint8_t const> aInitData) -> bool
{
    UniquePtr<IPC::Message> msg__ = PChromiumCDM::Msg_CreateSessionAndGenerateRequest(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), aPromiseId);
    // Sentinel = 'aPromiseId'
    ((&(writer__)))->WriteSentinel(365495278);
    IPC::WriteParam((&(writer__)), aSessionType);
    // Sentinel = 'aSessionType'
    ((&(writer__)))->WriteSentinel(526189800);
    IPC::WriteParam((&(writer__)), aInitDataType);
    // Sentinel = 'aInitDataType'
    ((&(writer__)))->WriteSentinel(582092050);
    IPC::WriteParam((&(writer__)), aInitData);
    // Sentinel = 'aInitData'
    ((&(writer__)))->WriteSentinel(284296048);




    if (mozilla::ipc::LoggingEnabledFor("PChromiumCDM", mozilla::ipc::ParentSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PChromiumCDMParent",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PChromiumCDM::Msg_CreateSessionAndGenerateRequest", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PChromiumCDMParent::SendLoadSession(
        const uint32_t& aPromiseId,
        const uint32_t& aSessionType,
        const nsACString& aSessionId) -> bool
{
    UniquePtr<IPC::Message> msg__ = PChromiumCDM::Msg_LoadSession(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), aPromiseId);
    // Sentinel = 'aPromiseId'
    ((&(writer__)))->WriteSentinel(365495278);
    IPC::WriteParam((&(writer__)), aSessionType);
    // Sentinel = 'aSessionType'
    ((&(writer__)))->WriteSentinel(526189800);
    IPC::WriteParam((&(writer__)), aSessionId);
    // Sentinel = 'aSessionId'
    ((&(writer__)))->WriteSentinel(365364211);




    if (mozilla::ipc::LoggingEnabledFor("PChromiumCDM", mozilla::ipc::ParentSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PChromiumCDMParent",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PChromiumCDM::Msg_LoadSession", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PChromiumCDMParent::SendUpdateSession(
        const uint32_t& aPromiseId,
        const nsACString& aSessionId,
        mozilla::Span<uint8_t const> aResponse) -> bool
{
    UniquePtr<IPC::Message> msg__ = PChromiumCDM::Msg_UpdateSession(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), aPromiseId);
    // Sentinel = 'aPromiseId'
    ((&(writer__)))->WriteSentinel(365495278);
    IPC::WriteParam((&(writer__)), aSessionId);
    // Sentinel = 'aSessionId'
    ((&(writer__)))->WriteSentinel(365364211);
    IPC::WriteParam((&(writer__)), aResponse);
    // Sentinel = 'aResponse'
    ((&(writer__)))->WriteSentinel(301466545);




    if (mozilla::ipc::LoggingEnabledFor("PChromiumCDM", mozilla::ipc::ParentSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PChromiumCDMParent",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PChromiumCDM::Msg_UpdateSession", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PChromiumCDMParent::SendCloseSession(
        const uint32_t& aPromiseId,
        const nsACString& aSessionId) -> bool
{
    UniquePtr<IPC::Message> msg__ = PChromiumCDM::Msg_CloseSession(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), aPromiseId);
    // Sentinel = 'aPromiseId'
    ((&(writer__)))->WriteSentinel(365495278);
    IPC::WriteParam((&(writer__)), aSessionId);
    // Sentinel = 'aSessionId'
    ((&(writer__)))->WriteSentinel(365364211);




    if (mozilla::ipc::LoggingEnabledFor("PChromiumCDM", mozilla::ipc::ParentSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PChromiumCDMParent",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PChromiumCDM::Msg_CloseSession", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PChromiumCDMParent::SendRemoveSession(
        const uint32_t& aPromiseId,
        const nsACString& aSessionId) -> bool
{
    UniquePtr<IPC::Message> msg__ = PChromiumCDM::Msg_RemoveSession(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), aPromiseId);
    // Sentinel = 'aPromiseId'
    ((&(writer__)))->WriteSentinel(365495278);
    IPC::WriteParam((&(writer__)), aSessionId);
    // Sentinel = 'aSessionId'
    ((&(writer__)))->WriteSentinel(365364211);




    if (mozilla::ipc::LoggingEnabledFor("PChromiumCDM", mozilla::ipc::ParentSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PChromiumCDMParent",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PChromiumCDM::Msg_RemoveSession", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PChromiumCDMParent::SendCompleteQueryOutputProtectionStatus(
        const bool& aSuccess,
        const uint32_t& aLinkMask,
        const uint32_t& aProtectionMask) -> bool
{
    UniquePtr<IPC::Message> msg__ = PChromiumCDM::Msg_CompleteQueryOutputProtectionStatus(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), aSuccess);
    // Sentinel = 'aSuccess'
    ((&(writer__)))->WriteSentinel(236323643);
    IPC::WriteParam((&(writer__)), aLinkMask);
    // Sentinel = 'aLinkMask'
    ((&(writer__)))->WriteSentinel(285475708);
    IPC::WriteParam((&(writer__)), aProtectionMask);
    // Sentinel = 'aProtectionMask'
    ((&(writer__)))->WriteSentinel(812385813);




    if (mozilla::ipc::LoggingEnabledFor("PChromiumCDM", mozilla::ipc::ParentSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PChromiumCDMParent",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PChromiumCDM::Msg_CompleteQueryOutputProtectionStatus", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PChromiumCDMParent::SendDecrypt(
        const uint32_t& aId,
        const CDMInputBuffer& aBuffer) -> bool
{
    UniquePtr<IPC::Message> msg__ = PChromiumCDM::Msg_Decrypt(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), aId);
    // Sentinel = 'aId'
    ((&(writer__)))->WriteSentinel(35389711);
    IPC::WriteParam((&(writer__)), aBuffer);
    // Sentinel = 'aBuffer'
    ((&(writer__)))->WriteSentinel(176751292);




    if (mozilla::ipc::LoggingEnabledFor("PChromiumCDM", mozilla::ipc::ParentSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PChromiumCDMParent",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PChromiumCDM::Msg_Decrypt", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PChromiumCDMParent::SendInitializeVideoDecoder(const CDMVideoDecoderConfig& aConfig) -> bool
{
    UniquePtr<IPC::Message> msg__ = PChromiumCDM::Msg_InitializeVideoDecoder(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), aConfig);
    // Sentinel = 'aConfig'
    ((&(writer__)))->WriteSentinel(177078968);




    if (mozilla::ipc::LoggingEnabledFor("PChromiumCDM", mozilla::ipc::ParentSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PChromiumCDMParent",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PChromiumCDM::Msg_InitializeVideoDecoder", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PChromiumCDMParent::SendDeinitializeVideoDecoder() -> bool
{
    UniquePtr<IPC::Message> msg__ = PChromiumCDM::Msg_DeinitializeVideoDecoder(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};





    if (mozilla::ipc::LoggingEnabledFor("PChromiumCDM", mozilla::ipc::ParentSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PChromiumCDMParent",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PChromiumCDM::Msg_DeinitializeVideoDecoder", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PChromiumCDMParent::SendResetVideoDecoder() -> bool
{
    UniquePtr<IPC::Message> msg__ = PChromiumCDM::Msg_ResetVideoDecoder(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};





    if (mozilla::ipc::LoggingEnabledFor("PChromiumCDM", mozilla::ipc::ParentSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PChromiumCDMParent",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PChromiumCDM::Msg_ResetVideoDecoder", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PChromiumCDMParent::SendDecryptAndDecodeFrame(const CDMInputBuffer& aBuffer) -> bool
{
    UniquePtr<IPC::Message> msg__ = PChromiumCDM::Msg_DecryptAndDecodeFrame(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), aBuffer);
    // Sentinel = 'aBuffer'
    ((&(writer__)))->WriteSentinel(176751292);




    if (mozilla::ipc::LoggingEnabledFor("PChromiumCDM", mozilla::ipc::ParentSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PChromiumCDMParent",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PChromiumCDM::Msg_DecryptAndDecodeFrame", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PChromiumCDMParent::SendDrain() -> bool
{
    UniquePtr<IPC::Message> msg__ = PChromiumCDM::Msg_Drain(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};





    if (mozilla::ipc::LoggingEnabledFor("PChromiumCDM", mozilla::ipc::ParentSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PChromiumCDMParent",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PChromiumCDM::Msg_Drain", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PChromiumCDMParent::SendDestroy() -> bool
{
    UniquePtr<IPC::Message> msg__ = PChromiumCDM::Msg_Destroy(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};





    if (mozilla::ipc::LoggingEnabledFor("PChromiumCDM", mozilla::ipc::ParentSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PChromiumCDMParent",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PChromiumCDM::Msg_Destroy", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PChromiumCDMParent::SendGiveBuffer(Shmem&& aShmem) -> bool
{
    UniquePtr<IPC::Message> msg__ = PChromiumCDM::Msg_GiveBuffer(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), std::move(aShmem));
    // Sentinel = 'aShmem'
    ((&(writer__)))->WriteSentinel(134808156);




    if (mozilla::ipc::LoggingEnabledFor("PChromiumCDM", mozilla::ipc::ParentSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PChromiumCDMParent",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PChromiumCDM::Msg_GiveBuffer", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PChromiumCDMParent::SendPurgeShmems() -> bool
{
    UniquePtr<IPC::Message> msg__ = PChromiumCDM::Msg_PurgeShmems(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};





    if (mozilla::ipc::LoggingEnabledFor("PChromiumCDM", mozilla::ipc::ParentSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PChromiumCDMParent",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PChromiumCDM::Msg_PurgeShmems", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PChromiumCDMParent::DeallocManagee(
        int32_t aProtocolId,
        IProtocol* aListener) -> void
{
    FatalError("unreached");
    return;
}

auto PChromiumCDMParent::OnMessageReceived(const Message& msg__) -> PChromiumCDMParent::Result
{
    switch (msg__.type()) {
    case MANAGED_ENDPOINT_BOUND_MESSAGE_TYPE:
        {
            if (!mAwaitingManagedEndpointBind) {
                NS_WARNING("Unexpected managed endpoint lifecycle message after actor bound!");
                return MsgNotAllowed;
            }
            mAwaitingManagedEndpointBind = false;
            return MsgProcessed;
        }
    case MANAGED_ENDPOINT_DROPPED_MESSAGE_TYPE:
        {
            if (!mAwaitingManagedEndpointBind) {
                NS_WARNING("Unexpected managed endpoint lifecycle message after actor bound!");
                return MsgNotAllowed;
            }
            mAwaitingManagedEndpointBind = false;
            this->ActorDisconnected(ManagedEndpointDropped);
            return MsgProcessed;
        }
    case PChromiumCDM::Reply_Init__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PChromiumCDM", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PChromiumCDMParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }

            AUTO_PROFILER_LABEL("PChromiumCDM::Msg_Init", OTHER);


            return mAsyncCallbacks.GotReply(this, msg__);
        }
    case PChromiumCDM::Msg___delete____ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PChromiumCDM", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PChromiumCDMParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PChromiumCDM::Msg___delete__", OTHER);

            mozilla::ipc::IPCResult __ok = (static_cast<ChromiumCDMParent*>(this))->Recv__delete__();
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }


            this->ActorDisconnected(Deletion);

            return MsgProcessed;
        }
    case PChromiumCDM::Msg_OnResolvePromiseWithKeyStatus__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PChromiumCDM", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PChromiumCDMParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PChromiumCDM::Msg_OnResolvePromiseWithKeyStatus", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__aPromiseId = IPC::ReadParam<uint32_t>((&(reader__)));
            if (!maybe__aPromiseId) {
                FatalError("Error deserializing 'uint32_t'");
                return MsgValueError;

            }
            auto& aPromiseId = *maybe__aPromiseId;
            // Sentinel = 'aPromiseId'
            if ((!(((&(reader__)))->ReadSentinel(365495278)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'uint32_t'");
                return MsgValueError;
            }
            auto maybe__aKeyStatus = IPC::ReadParam<uint32_t>((&(reader__)));
            if (!maybe__aKeyStatus) {
                FatalError("Error deserializing 'uint32_t'");
                return MsgValueError;

            }
            auto& aKeyStatus = *maybe__aKeyStatus;
            // Sentinel = 'aKeyStatus'
            if ((!(((&(reader__)))->ReadSentinel(358679567)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'uint32_t'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::IPCResult __ok = (static_cast<ChromiumCDMParent*>(this))->RecvOnResolvePromiseWithKeyStatus(std::move(aPromiseId), std::move(aKeyStatus));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PChromiumCDM::Msg_OnResolveNewSessionPromise__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PChromiumCDM", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PChromiumCDMParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PChromiumCDM::Msg_OnResolveNewSessionPromise", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__aPromiseId = IPC::ReadParam<uint32_t>((&(reader__)));
            if (!maybe__aPromiseId) {
                FatalError("Error deserializing 'uint32_t'");
                return MsgValueError;

            }
            auto& aPromiseId = *maybe__aPromiseId;
            // Sentinel = 'aPromiseId'
            if ((!(((&(reader__)))->ReadSentinel(365495278)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'uint32_t'");
                return MsgValueError;
            }
            auto maybe__aSessionId = IPC::ReadParam<nsCString>((&(reader__)));
            if (!maybe__aSessionId) {
                FatalError("Error deserializing 'nsCString'");
                return MsgValueError;

            }
            auto& aSessionId = *maybe__aSessionId;
            // Sentinel = 'aSessionId'
            if ((!(((&(reader__)))->ReadSentinel(365364211)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'nsCString'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::IPCResult __ok = (static_cast<ChromiumCDMParent*>(this))->RecvOnResolveNewSessionPromise(std::move(aPromiseId), std::move(aSessionId));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PChromiumCDM::Msg_OnResolvePromise__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PChromiumCDM", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PChromiumCDMParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PChromiumCDM::Msg_OnResolvePromise", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__aPromiseId = IPC::ReadParam<uint32_t>((&(reader__)));
            if (!maybe__aPromiseId) {
                FatalError("Error deserializing 'uint32_t'");
                return MsgValueError;

            }
            auto& aPromiseId = *maybe__aPromiseId;
            // Sentinel = 'aPromiseId'
            if ((!(((&(reader__)))->ReadSentinel(365495278)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'uint32_t'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::IPCResult __ok = (static_cast<ChromiumCDMParent*>(this))->RecvOnResolvePromise(std::move(aPromiseId));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PChromiumCDM::Msg_OnRejectPromise__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PChromiumCDM", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PChromiumCDMParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PChromiumCDM::Msg_OnRejectPromise", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__aPromiseId = IPC::ReadParam<uint32_t>((&(reader__)));
            if (!maybe__aPromiseId) {
                FatalError("Error deserializing 'uint32_t'");
                return MsgValueError;

            }
            auto& aPromiseId = *maybe__aPromiseId;
            // Sentinel = 'aPromiseId'
            if ((!(((&(reader__)))->ReadSentinel(365495278)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'uint32_t'");
                return MsgValueError;
            }
            auto maybe__aException = IPC::ReadParam<uint32_t>((&(reader__)));
            if (!maybe__aException) {
                FatalError("Error deserializing 'uint32_t'");
                return MsgValueError;

            }
            auto& aException = *maybe__aException;
            // Sentinel = 'aException'
            if ((!(((&(reader__)))->ReadSentinel(362480657)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'uint32_t'");
                return MsgValueError;
            }
            auto maybe__aSystemCode = IPC::ReadParam<uint32_t>((&(reader__)));
            if (!maybe__aSystemCode) {
                FatalError("Error deserializing 'uint32_t'");
                return MsgValueError;

            }
            auto& aSystemCode = *maybe__aSystemCode;
            // Sentinel = 'aSystemCode'
            if ((!(((&(reader__)))->ReadSentinel(444466274)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'uint32_t'");
                return MsgValueError;
            }
            auto maybe__aErrorMessage = IPC::ReadParam<nsCString>((&(reader__)));
            if (!maybe__aErrorMessage) {
                FatalError("Error deserializing 'nsCString'");
                return MsgValueError;

            }
            auto& aErrorMessage = *maybe__aErrorMessage;
            // Sentinel = 'aErrorMessage'
            if ((!(((&(reader__)))->ReadSentinel(601949489)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'nsCString'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::IPCResult __ok = (static_cast<ChromiumCDMParent*>(this))->RecvOnRejectPromise(std::move(aPromiseId), std::move(aException), std::move(aSystemCode), std::move(aErrorMessage));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PChromiumCDM::Msg_OnSessionMessage__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PChromiumCDM", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PChromiumCDMParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PChromiumCDM::Msg_OnSessionMessage", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__aSessionId = IPC::ReadParam<nsCString>((&(reader__)));
            if (!maybe__aSessionId) {
                FatalError("Error deserializing 'nsCString'");
                return MsgValueError;

            }
            auto& aSessionId = *maybe__aSessionId;
            // Sentinel = 'aSessionId'
            if ((!(((&(reader__)))->ReadSentinel(365364211)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'nsCString'");
                return MsgValueError;
            }
            auto maybe__aMessageType = IPC::ReadParam<uint32_t>((&(reader__)));
            if (!maybe__aMessageType) {
                FatalError("Error deserializing 'uint32_t'");
                return MsgValueError;

            }
            auto& aMessageType = *maybe__aMessageType;
            // Sentinel = 'aMessageType'
            if ((!(((&(reader__)))->ReadSentinel(512099529)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'uint32_t'");
                return MsgValueError;
            }
            auto maybe__aMessage = IPC::ReadParam<nsTArray<uint8_t>>((&(reader__)));
            if (!maybe__aMessage) {
                FatalError("Error deserializing 'uint8_t[]'");
                return MsgValueError;

            }
            auto& aMessage = *maybe__aMessage;
            // Sentinel = 'aMessage'
            if ((!(((&(reader__)))->ReadSentinel(233440039)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'uint8_t[]'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::IPCResult __ok = (static_cast<ChromiumCDMParent*>(this))->RecvOnSessionMessage(std::move(aSessionId), std::move(aMessageType), std::move(aMessage));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PChromiumCDM::Msg_OnSessionKeysChange__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PChromiumCDM", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PChromiumCDMParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PChromiumCDM::Msg_OnSessionKeysChange", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__aSessionId = IPC::ReadParam<nsCString>((&(reader__)));
            if (!maybe__aSessionId) {
                FatalError("Error deserializing 'nsCString'");
                return MsgValueError;

            }
            auto& aSessionId = *maybe__aSessionId;
            // Sentinel = 'aSessionId'
            if ((!(((&(reader__)))->ReadSentinel(365364211)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'nsCString'");
                return MsgValueError;
            }
            auto maybe__aKeysInfo = IPC::ReadParam<nsTArray<CDMKeyInformation>>((&(reader__)));
            if (!maybe__aKeysInfo) {
                FatalError("Error deserializing 'CDMKeyInformation[]'");
                return MsgValueError;

            }
            auto& aKeysInfo = *maybe__aKeysInfo;
            // Sentinel = 'aKeysInfo'
            if ((!(((&(reader__)))->ReadSentinel(290128778)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'CDMKeyInformation[]'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::IPCResult __ok = (static_cast<ChromiumCDMParent*>(this))->RecvOnSessionKeysChange(std::move(aSessionId), std::move(aKeysInfo));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PChromiumCDM::Msg_OnExpirationChange__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PChromiumCDM", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PChromiumCDMParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PChromiumCDM::Msg_OnExpirationChange", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__aSessionId = IPC::ReadParam<nsCString>((&(reader__)));
            if (!maybe__aSessionId) {
                FatalError("Error deserializing 'nsCString'");
                return MsgValueError;

            }
            auto& aSessionId = *maybe__aSessionId;
            // Sentinel = 'aSessionId'
            if ((!(((&(reader__)))->ReadSentinel(365364211)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'nsCString'");
                return MsgValueError;
            }
            auto maybe__aSecondsSinceEpoch = IPC::ReadParam<double>((&(reader__)));
            if (!maybe__aSecondsSinceEpoch) {
                FatalError("Error deserializing 'double'");
                return MsgValueError;

            }
            auto& aSecondsSinceEpoch = *maybe__aSecondsSinceEpoch;
            // Sentinel = 'aSecondsSinceEpoch'
            if ((!(((&(reader__)))->ReadSentinel(1121126162)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'double'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::IPCResult __ok = (static_cast<ChromiumCDMParent*>(this))->RecvOnExpirationChange(std::move(aSessionId), std::move(aSecondsSinceEpoch));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PChromiumCDM::Msg_OnSessionClosed__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PChromiumCDM", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PChromiumCDMParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PChromiumCDM::Msg_OnSessionClosed", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__aSessionId = IPC::ReadParam<nsCString>((&(reader__)));
            if (!maybe__aSessionId) {
                FatalError("Error deserializing 'nsCString'");
                return MsgValueError;

            }
            auto& aSessionId = *maybe__aSessionId;
            // Sentinel = 'aSessionId'
            if ((!(((&(reader__)))->ReadSentinel(365364211)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'nsCString'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::IPCResult __ok = (static_cast<ChromiumCDMParent*>(this))->RecvOnSessionClosed(std::move(aSessionId));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PChromiumCDM::Msg_OnQueryOutputProtectionStatus__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PChromiumCDM", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PChromiumCDMParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PChromiumCDM::Msg_OnQueryOutputProtectionStatus", OTHER);

            mozilla::ipc::IPCResult __ok = (static_cast<ChromiumCDMParent*>(this))->RecvOnQueryOutputProtectionStatus();
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PChromiumCDM::Msg_ResolveLoadSessionPromise__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PChromiumCDM", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PChromiumCDMParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PChromiumCDM::Msg_ResolveLoadSessionPromise", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__aPromiseId = IPC::ReadParam<uint32_t>((&(reader__)));
            if (!maybe__aPromiseId) {
                FatalError("Error deserializing 'uint32_t'");
                return MsgValueError;

            }
            auto& aPromiseId = *maybe__aPromiseId;
            // Sentinel = 'aPromiseId'
            if ((!(((&(reader__)))->ReadSentinel(365495278)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'uint32_t'");
                return MsgValueError;
            }
            auto maybe__aSuccessful = IPC::ReadParam<bool>((&(reader__)));
            if (!maybe__aSuccessful) {
                FatalError("Error deserializing 'bool'");
                return MsgValueError;

            }
            auto& aSuccessful = *maybe__aSuccessful;
            // Sentinel = 'aSuccessful'
            if ((!(((&(reader__)))->ReadSentinel(441386114)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'bool'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::IPCResult __ok = (static_cast<ChromiumCDMParent*>(this))->RecvResolveLoadSessionPromise(std::move(aPromiseId), std::move(aSuccessful));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PChromiumCDM::Msg_Decrypted__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PChromiumCDM", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PChromiumCDMParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PChromiumCDM::Msg_Decrypted", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__aId = IPC::ReadParam<uint32_t>((&(reader__)));
            if (!maybe__aId) {
                FatalError("Error deserializing 'uint32_t'");
                return MsgValueError;

            }
            auto& aId = *maybe__aId;
            // Sentinel = 'aId'
            if ((!(((&(reader__)))->ReadSentinel(35389711)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'uint32_t'");
                return MsgValueError;
            }
            auto maybe__aStatus = IPC::ReadParam<uint32_t>((&(reader__)));
            if (!maybe__aStatus) {
                FatalError("Error deserializing 'uint32_t'");
                return MsgValueError;

            }
            auto& aStatus = *maybe__aStatus;
            // Sentinel = 'aStatus'
            if ((!(((&(reader__)))->ReadSentinel(186712806)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'uint32_t'");
                return MsgValueError;
            }
            auto maybe__aDecryptedData = IPC::ReadParam<Shmem>((&(reader__)));
            if (!maybe__aDecryptedData) {
                FatalError("Error deserializing 'Shmem'");
                return MsgValueError;

            }
            auto& aDecryptedData = *maybe__aDecryptedData;
            // Sentinel = 'aDecryptedData'
            if ((!(((&(reader__)))->ReadSentinel(687605120)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'Shmem'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::IPCResult __ok = (static_cast<ChromiumCDMParent*>(this))->RecvDecrypted(std::move(aId), std::move(aStatus), std::move(aDecryptedData));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PChromiumCDM::Msg_DecryptFailed__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PChromiumCDM", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PChromiumCDMParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PChromiumCDM::Msg_DecryptFailed", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__aId = IPC::ReadParam<uint32_t>((&(reader__)));
            if (!maybe__aId) {
                FatalError("Error deserializing 'uint32_t'");
                return MsgValueError;

            }
            auto& aId = *maybe__aId;
            // Sentinel = 'aId'
            if ((!(((&(reader__)))->ReadSentinel(35389711)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'uint32_t'");
                return MsgValueError;
            }
            auto maybe__aStatus = IPC::ReadParam<uint32_t>((&(reader__)));
            if (!maybe__aStatus) {
                FatalError("Error deserializing 'uint32_t'");
                return MsgValueError;

            }
            auto& aStatus = *maybe__aStatus;
            // Sentinel = 'aStatus'
            if ((!(((&(reader__)))->ReadSentinel(186712806)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'uint32_t'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::IPCResult __ok = (static_cast<ChromiumCDMParent*>(this))->RecvDecryptFailed(std::move(aId), std::move(aStatus));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PChromiumCDM::Msg_OnDecoderInitDone__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PChromiumCDM", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PChromiumCDMParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PChromiumCDM::Msg_OnDecoderInitDone", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__aStatus = IPC::ReadParam<uint32_t>((&(reader__)));
            if (!maybe__aStatus) {
                FatalError("Error deserializing 'uint32_t'");
                return MsgValueError;

            }
            auto& aStatus = *maybe__aStatus;
            // Sentinel = 'aStatus'
            if ((!(((&(reader__)))->ReadSentinel(186712806)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'uint32_t'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::IPCResult __ok = (static_cast<ChromiumCDMParent*>(this))->RecvOnDecoderInitDone(std::move(aStatus));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PChromiumCDM::Msg_DecodedShmem__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PChromiumCDM", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PChromiumCDMParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PChromiumCDM::Msg_DecodedShmem", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__aFrame = IPC::ReadParam<CDMVideoFrame>((&(reader__)));
            if (!maybe__aFrame) {
                FatalError("Error deserializing 'CDMVideoFrame'");
                return MsgValueError;

            }
            auto& aFrame = *maybe__aFrame;
            // Sentinel = 'aFrame'
            if ((!(((&(reader__)))->ReadSentinel(131334733)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'CDMVideoFrame'");
                return MsgValueError;
            }
            auto maybe__aData = IPC::ReadParam<Shmem>((&(reader__)));
            if (!maybe__aData) {
                FatalError("Error deserializing 'Shmem'");
                return MsgValueError;

            }
            auto& aData = *maybe__aData;
            // Sentinel = 'aData'
            if ((!(((&(reader__)))->ReadSentinel(90571228)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'Shmem'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::IPCResult __ok = (static_cast<ChromiumCDMParent*>(this))->RecvDecodedShmem(std::move(aFrame), std::move(aData));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PChromiumCDM::Msg_DecodedData__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PChromiumCDM", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PChromiumCDMParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PChromiumCDM::Msg_DecodedData", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__aFrame = IPC::ReadParam<CDMVideoFrame>((&(reader__)));
            if (!maybe__aFrame) {
                FatalError("Error deserializing 'CDMVideoFrame'");
                return MsgValueError;

            }
            auto& aFrame = *maybe__aFrame;
            // Sentinel = 'aFrame'
            if ((!(((&(reader__)))->ReadSentinel(131334733)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'CDMVideoFrame'");
                return MsgValueError;
            }
            auto maybe__aData = IPC::ReadParam<nsTArray<uint8_t>>((&(reader__)));
            if (!maybe__aData) {
                FatalError("Error deserializing 'uint8_t[]'");
                return MsgValueError;

            }
            auto& aData = *maybe__aData;
            // Sentinel = 'aData'
            if ((!(((&(reader__)))->ReadSentinel(90571228)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'uint8_t[]'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::IPCResult __ok = (static_cast<ChromiumCDMParent*>(this))->RecvDecodedData(std::move(aFrame), std::move(aData));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PChromiumCDM::Msg_DecodeFailed__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PChromiumCDM", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PChromiumCDMParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PChromiumCDM::Msg_DecodeFailed", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__aStatus = IPC::ReadParam<uint32_t>((&(reader__)));
            if (!maybe__aStatus) {
                FatalError("Error deserializing 'uint32_t'");
                return MsgValueError;

            }
            auto& aStatus = *maybe__aStatus;
            // Sentinel = 'aStatus'
            if ((!(((&(reader__)))->ReadSentinel(186712806)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'uint32_t'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::IPCResult __ok = (static_cast<ChromiumCDMParent*>(this))->RecvDecodeFailed(std::move(aStatus));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PChromiumCDM::Msg_ResetVideoDecoderComplete__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PChromiumCDM", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PChromiumCDMParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PChromiumCDM::Msg_ResetVideoDecoderComplete", OTHER);

            mozilla::ipc::IPCResult __ok = (static_cast<ChromiumCDMParent*>(this))->RecvResetVideoDecoderComplete();
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PChromiumCDM::Msg_DrainComplete__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PChromiumCDM", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PChromiumCDMParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PChromiumCDM::Msg_DrainComplete", OTHER);

            mozilla::ipc::IPCResult __ok = (static_cast<ChromiumCDMParent*>(this))->RecvDrainComplete();
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PChromiumCDM::Msg_Shutdown__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PChromiumCDM", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PChromiumCDMParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PChromiumCDM::Msg_Shutdown", OTHER);

            mozilla::ipc::IPCResult __ok = (static_cast<ChromiumCDMParent*>(this))->RecvShutdown();
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PChromiumCDM::Msg_IncreaseShmemPoolSize__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PChromiumCDM", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PChromiumCDMParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PChromiumCDM::Msg_IncreaseShmemPoolSize", OTHER);

            mozilla::ipc::IPCResult __ok = (static_cast<ChromiumCDMParent*>(this))->RecvIncreaseShmemPoolSize();
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    default:
        return MsgNotKnown;
    }
}

auto PChromiumCDMParent::OnMessageReceived(
        const Message& msg__,
        UniquePtr<Message>& reply__) -> PChromiumCDMParent::Result
{
    return MsgNotKnown;
}



} // namespace gmp
} // namespace mozilla
namespace IPC {
auto ParamTraits<::mozilla::gmp::PChromiumCDMParent*>::Write(
        IPC::MessageWriter* aWriter,
        const paramType& aVar) -> void
{
    MOZ_RELEASE_ASSERT(
        aWriter->GetActor(),
        "Cannot serialize managed actors without an actor");

    int32_t id;
    if (!aVar) {
        id = 0;  // kNullActorId
    } else {
        id = aVar->Id();
        if (id == 1) {  // kFreedActorId
            aVar->FatalError("Actor has been |delete|d");
        }
        MOZ_RELEASE_ASSERT(
            aWriter->GetActor()->GetIPCChannel() == aVar->GetIPCChannel(),
            "Actor must be from the same channel as the"
            " actor it's being sent over");
        MOZ_RELEASE_ASSERT(
            aVar->CanSend(),
            "Actor must still be open when sending");
    }

    IPC::WriteParam(aWriter, id);
}

auto ParamTraits<::mozilla::gmp::PChromiumCDMParent*>::Read(IPC::MessageReader* aReader) -> IPC::ReadResult<paramType>
{
    MOZ_RELEASE_ASSERT(
        aReader->GetActor(),
        "Cannot deserialize managed actors without an actor");
    mozilla::Maybe<mozilla::ipc::IProtocol*> actor = aReader->GetActor()
        ->ReadActor(aReader, true, "PChromiumCDM", PChromiumCDMMsgStart);
    if (actor.isSome()) {
        return static_cast<::mozilla::gmp::PChromiumCDMParent*>(actor.ref());
    }
    return {};
}

} // namespace IPC
