//
// Automatically generated by ipdlc.
// Edit at your own risk
//


#include "mozilla/layers/PCanvasChild.h"
#include "mozilla/ProfilerLabels.h"
#include "mozilla/layers/CanvasChild.h"
#include "mozilla/layers/CanvasTranslator.h"
#include "mozilla/layers/LayersMessageUtils.h"

#include "mozilla/gfx/PCanvasManagerChild.h"

#include "ipc/IPCMessageUtils.h"
#include "ipc/IPCMessageUtilsSpecializations.h"
#include "nsIFile.h"
#include "mozilla/ipc/Endpoint.h"
#include "mozilla/ipc/ProtocolMessageUtils.h"
#include "mozilla/ipc/ProtocolUtils.h"
#include "mozilla/ipc/ShmemMessageUtils.h"
#include "mozilla/ipc/TaintingIPCUtils.h"

namespace mozilla {
namespace layers {


MOZ_IMPLICIT PCanvasChild::PCanvasChild() :
    mozilla::ipc::IRefCountedProtocol(kProtocolId, mozilla::ipc::ChildSide)
{
    MOZ_COUNT_CTOR(PCanvasChild);
}

PCanvasChild::~PCanvasChild()
{
    MOZ_COUNT_DTOR(PCanvasChild);
}

auto PCanvasChild::ActorAlloc() -> void
{
    AddRef();
}

auto PCanvasChild::ActorDealloc() -> void
{
    Release();
}

auto PCanvasChild::OtherPid() const -> ::base::ProcessId
{
    ::base::ProcessId pid =
        ::mozilla::ipc::IProtocol::ToplevelProtocol()->OtherPidMaybeInvalid();
    MOZ_RELEASE_ASSERT(pid != ::base::kInvalidProcessId);
    return pid;
}

auto PCanvasChild::OtherChildID() const -> ::GeckoChildID
{
    ::GeckoChildID childID =
        ::mozilla::ipc::IProtocol::ToplevelProtocol()->OtherChildIDMaybeInvalid();
    MOZ_RELEASE_ASSERT(childID != -1);
    return childID;
}

auto PCanvasChild::OtherEndpointProcInfo() const -> ::mozilla::ipc::EndpointProcInfo
{
    return ::mozilla::ipc::EndpointProcInfo{OtherPid(), OtherChildID()};
}

auto PCanvasChild::Manager() const -> PCanvasManagerChild*
{
    return static_cast<PCanvasManagerChild*>(IProtocol::Manager());
}

auto PCanvasChild::ManagedProtocolIds() const -> mozilla::Span<mozilla::ipc::ProtocolId const>
{
    return {};
}

auto PCanvasChild::GetManagedActors(mozilla::ipc::ProtocolId aProtocol) -> UntypedManagedContainer*
{
    switch (aProtocol) {
    default:
        return nullptr;
    }
}

auto PCanvasChild::RejectPendingResponses(ResponseRejectReason aReason) -> void
{
    mAsyncCallbacks.RejectPendingResponses(aReason);
}

auto PCanvasChild::SendInitTranslator(
        const TextureType& aTextureType,
        const TextureType& aWebglTextureType,
        const BackendType& aBackendType,
        MutableSharedMemoryHandle&& aHeaderHandle,
        nsTArray<ReadOnlySharedMemoryHandle>&& aBufferHandles,
        CrossProcessSemaphoreHandle&& aReaderSem,
        CrossProcessSemaphoreHandle&& aWriterSem) -> bool
{
    UniquePtr<IPC::Message> msg__ = PCanvas::Msg_InitTranslator(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), aTextureType);
    // Sentinel = 'aTextureType'
    ((&(writer__)))->WriteSentinel(534119669);
    IPC::WriteParam((&(writer__)), aWebglTextureType);
    // Sentinel = 'aWebglTextureType'
    ((&(writer__)))->WriteSentinel(1019348710);
    IPC::WriteParam((&(writer__)), aBackendType);
    // Sentinel = 'aBackendType'
    ((&(writer__)))->WriteSentinel(492176556);
    IPC::WriteParam((&(writer__)), std::move(aHeaderHandle));
    // Sentinel = 'aHeaderHandle'
    ((&(writer__)))->WriteSentinel(570098935);
    IPC::WriteParam((&(writer__)), std::move(aBufferHandles));
    // Sentinel = 'aBufferHandles'
    ((&(writer__)))->WriteSentinel(673318267);
    IPC::WriteParam((&(writer__)), std::move(aReaderSem));
    // Sentinel = 'aReaderSem'
    ((&(writer__)))->WriteSentinel(349045722);
    IPC::WriteParam((&(writer__)), std::move(aWriterSem));
    // Sentinel = 'aWriterSem'
    ((&(writer__)))->WriteSentinel(368772100);




    if (mozilla::ipc::LoggingEnabledFor("PCanvas", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PCanvasChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PCanvas::Msg_InitTranslator", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PCanvasChild::SendRestartTranslation() -> bool
{
    UniquePtr<IPC::Message> msg__ = PCanvas::Msg_RestartTranslation(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};





    if (mozilla::ipc::LoggingEnabledFor("PCanvas", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PCanvasChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PCanvas::Msg_RestartTranslation", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PCanvasChild::SendAddBuffer(ReadOnlySharedMemoryHandle&& aBufferHandle) -> bool
{
    UniquePtr<IPC::Message> msg__ = PCanvas::Msg_AddBuffer(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), std::move(aBufferHandle));
    // Sentinel = 'aBufferHandle'
    ((&(writer__)))->WriteSentinel(581371144);




    if (mozilla::ipc::LoggingEnabledFor("PCanvas", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PCanvasChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PCanvas::Msg_AddBuffer", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PCanvasChild::SendSetDataSurfaceBuffer(MutableSharedMemoryHandle&& aBufferHandle) -> bool
{
    UniquePtr<IPC::Message> msg__ = PCanvas::Msg_SetDataSurfaceBuffer(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), std::move(aBufferHandle));
    // Sentinel = 'aBufferHandle'
    ((&(writer__)))->WriteSentinel(581371144);




    if (mozilla::ipc::LoggingEnabledFor("PCanvas", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PCanvasChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PCanvas::Msg_SetDataSurfaceBuffer", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PCanvasChild::SendClearCachedResources() -> bool
{
    UniquePtr<IPC::Message> msg__ = PCanvas::Msg_ClearCachedResources(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};





    if (mozilla::ipc::LoggingEnabledFor("PCanvas", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PCanvasChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PCanvas::Msg_ClearCachedResources", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PCanvasChild::SendDropFreeBuffersWhenDormant() -> bool
{
    UniquePtr<IPC::Message> msg__ = PCanvas::Msg_DropFreeBuffersWhenDormant(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};





    if (mozilla::ipc::LoggingEnabledFor("PCanvas", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PCanvasChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PCanvas::Msg_DropFreeBuffersWhenDormant", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PCanvasChild::Send__delete__(PCanvasChild* actor) -> bool
{
    if (!actor || !actor->CanSend()) {
        NS_WARNING("Attempt to __delete__ missing or closed actor");
        return false;
    }
    UniquePtr<IPC::Message> msg__ = PCanvas::Msg___delete__((actor)->Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            actor};




    if (mozilla::ipc::LoggingEnabledFor("PCanvas", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PCanvasChild",
            actor->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PCanvas::Msg___delete__", OTHER);

    bool sendok__ = (actor)->ChannelSend(std::move(msg__));

    actor->ActorDisconnected(Deletion);
    return sendok__;
}

auto PCanvasChild::DeallocManagee(
        int32_t aProtocolId,
        IProtocol* aListener) -> void
{
    FatalError("unreached");
    return;
}

auto PCanvasChild::OnMessageReceived(const Message& msg__) -> PCanvasChild::Result
{
    switch (msg__.type()) {
    case MANAGED_ENDPOINT_BOUND_MESSAGE_TYPE:
        {
            if (!mAwaitingManagedEndpointBind) {
                NS_WARNING("Unexpected managed endpoint lifecycle message after actor bound!");
                return MsgNotAllowed;
            }
            mAwaitingManagedEndpointBind = false;
            return MsgProcessed;
        }
    case MANAGED_ENDPOINT_DROPPED_MESSAGE_TYPE:
        {
            if (!mAwaitingManagedEndpointBind) {
                NS_WARNING("Unexpected managed endpoint lifecycle message after actor bound!");
                return MsgNotAllowed;
            }
            mAwaitingManagedEndpointBind = false;
            this->ActorDisconnected(ManagedEndpointDropped);
            return MsgProcessed;
        }
    case PCanvas::Reply___delete____ID:
        {
            return MsgProcessed;
        }
    case PCanvas::Msg_NotifyDeviceChanged__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PCanvas", mozilla::ipc::ChildSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PCanvasChild",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PCanvas::Msg_NotifyDeviceChanged", OTHER);

            mozilla::ipc::IPCResult __ok = (static_cast<CanvasChild*>(this))->RecvNotifyDeviceChanged();
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PCanvas::Msg_NotifyDeviceReset__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PCanvas", mozilla::ipc::ChildSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PCanvasChild",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PCanvas::Msg_NotifyDeviceReset", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__aOwners = IPC::ReadParam<nsTArray<RemoteTextureOwnerId>>((&(reader__)));
            if (!maybe__aOwners) {
                FatalError("Error deserializing 'RemoteTextureOwnerId[]'");
                return MsgValueError;

            }
            auto& aOwners = *maybe__aOwners;
            // Sentinel = 'aOwners'
            if ((!(((&(reader__)))->ReadSentinel(186188512)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'RemoteTextureOwnerId[]'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::IPCResult __ok = (static_cast<CanvasChild*>(this))->RecvNotifyDeviceReset(std::move(aOwners));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PCanvas::Msg_Deactivate__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PCanvas", mozilla::ipc::ChildSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PCanvasChild",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PCanvas::Msg_Deactivate", OTHER);

            mozilla::ipc::IPCResult __ok = (static_cast<CanvasChild*>(this))->RecvDeactivate();
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PCanvas::Msg_BlockCanvas__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PCanvas", mozilla::ipc::ChildSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PCanvasChild",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PCanvas::Msg_BlockCanvas", OTHER);

            mozilla::ipc::IPCResult __ok = (static_cast<CanvasChild*>(this))->RecvBlockCanvas();
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PCanvas::Msg_NotifyRequiresRefresh__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PCanvas", mozilla::ipc::ChildSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PCanvasChild",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PCanvas::Msg_NotifyRequiresRefresh", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__aTextureOwnerId = IPC::ReadParam<RemoteTextureOwnerId>((&(reader__)));
            if (!maybe__aTextureOwnerId) {
                FatalError("Error deserializing 'RemoteTextureOwnerId'");
                return MsgValueError;

            }
            auto& aTextureOwnerId = *maybe__aTextureOwnerId;
            // Sentinel = 'aTextureOwnerId'
            if ((!(((&(reader__)))->ReadSentinel(818415115)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'RemoteTextureOwnerId'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::IPCResult __ok = (static_cast<CanvasChild*>(this))->RecvNotifyRequiresRefresh(std::move(aTextureOwnerId));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PCanvas::Msg_SnapshotShmem__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PCanvas", mozilla::ipc::ChildSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PCanvasChild",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PCanvas::Msg_SnapshotShmem", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__aTextureOwnerId = IPC::ReadParam<RemoteTextureOwnerId>((&(reader__)));
            if (!maybe__aTextureOwnerId) {
                FatalError("Error deserializing 'RemoteTextureOwnerId'");
                return MsgValueError;

            }
            auto& aTextureOwnerId = *maybe__aTextureOwnerId;
            // Sentinel = 'aTextureOwnerId'
            if ((!(((&(reader__)))->ReadSentinel(818415115)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'RemoteTextureOwnerId'");
                return MsgValueError;
            }
            auto maybe__aShmemHandle = IPC::ReadParam<ReadOnlySharedMemoryHandle>((&(reader__)));
            if (!maybe__aShmemHandle) {
                FatalError("Error deserializing 'ReadOnlySharedMemoryHandle'");
                return MsgValueError;

            }
            auto& aShmemHandle = *maybe__aShmemHandle;
            // Sentinel = 'aShmemHandle'
            if ((!(((&(reader__)))->ReadSentinel(501679272)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'ReadOnlySharedMemoryHandle'");
                return MsgValueError;
            }
            reader__.EndRead();
            int32_t id__ = Id();
            UniquePtr<IPC::Message> reply__(PCanvas::Reply_SnapshotShmem(id__));
            reply__->set_seqno(msg__.seqno());

            RefPtr<mozilla::ipc::IPDLResolverInner> resolver__ =
                new mozilla::ipc::IPDLResolverInner(std::move(reply__), this);

            SnapshotShmemResolver resolver = [resolver__ = std::move(resolver__)](const bool& aParam) {
                resolver__->Resolve([&] (IPC::Message* reply__, IProtocol* self__) {
                    IPC::MessageWriter writer__(*reply__, self__);
                    IPC::WriteParam((&(writer__)), aParam);
                    // Sentinel = 'aSuccess'
                    ((&(writer__)))->WriteSentinel(236323643);

                    if (mozilla::ipc::LoggingEnabledFor("PCanvas", mozilla::ipc::ChildSide)) {
                        mozilla::ipc::LogMessageForProtocol(
                            "PCanvasChild",
                            self__->ToplevelProtocol()->OtherPidMaybeInvalid(),
                            "Sending reply ",
                            reply__->type(),
                            mozilla::ipc::MessageDirection::eSending);
                    }

                });
            };
            mozilla::ipc::IPCResult __ok = (static_cast<CanvasChild*>(this))->RecvSnapshotShmem(std::move(aTextureOwnerId), std::move(aShmemHandle), std::move(resolver));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PCanvas::Msg_NotifyTextureDestruction__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PCanvas", mozilla::ipc::ChildSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PCanvasChild",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PCanvas::Msg_NotifyTextureDestruction", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__aTextureOwnerId = IPC::ReadParam<RemoteTextureOwnerId>((&(reader__)));
            if (!maybe__aTextureOwnerId) {
                FatalError("Error deserializing 'RemoteTextureOwnerId'");
                return MsgValueError;

            }
            auto& aTextureOwnerId = *maybe__aTextureOwnerId;
            // Sentinel = 'aTextureOwnerId'
            if ((!(((&(reader__)))->ReadSentinel(818415115)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'RemoteTextureOwnerId'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::IPCResult __ok = (static_cast<CanvasChild*>(this))->RecvNotifyTextureDestruction(std::move(aTextureOwnerId));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    default:
        return MsgNotKnown;
    }
}

auto PCanvasChild::OnMessageReceived(
        const Message& msg__,
        UniquePtr<Message>& reply__) -> PCanvasChild::Result
{
    return MsgNotKnown;
}



} // namespace layers
} // namespace mozilla
namespace IPC {
auto ParamTraits<::mozilla::layers::PCanvasChild*>::Write(
        IPC::MessageWriter* aWriter,
        const paramType& aVar) -> void
{
    MOZ_RELEASE_ASSERT(
        aWriter->GetActor(),
        "Cannot serialize managed actors without an actor");

    int32_t id;
    if (!aVar) {
        id = 0;  // kNullActorId
    } else {
        id = aVar->Id();
        if (id == 1) {  // kFreedActorId
            aVar->FatalError("Actor has been |delete|d");
        }
        MOZ_RELEASE_ASSERT(
            aWriter->GetActor()->GetIPCChannel() == aVar->GetIPCChannel(),
            "Actor must be from the same channel as the"
            " actor it's being sent over");
        MOZ_RELEASE_ASSERT(
            aVar->CanSend(),
            "Actor must still be open when sending");
    }

    IPC::WriteParam(aWriter, id);
}

auto ParamTraits<::mozilla::layers::PCanvasChild*>::Read(IPC::MessageReader* aReader) -> IPC::ReadResult<paramType>
{
    MOZ_RELEASE_ASSERT(
        aReader->GetActor(),
        "Cannot deserialize managed actors without an actor");
    mozilla::Maybe<mozilla::ipc::IProtocol*> actor = aReader->GetActor()
        ->ReadActor(aReader, true, "PCanvas", PCanvasMsgStart);
    if (actor.isSome()) {
        return static_cast<::mozilla::layers::PCanvasChild*>(actor.ref());
    }
    return {};
}

} // namespace IPC
