//
// Automatically generated by ipdlc.
// Edit at your own risk
//


#include "mozilla/camera/PCamerasChild.h"
#include "mozilla/ProfilerLabels.h"
#include "mozilla/dom/DomSecurityIPCUtils.h"
#include "mozilla/dom/MediaIPCUtils.h"
#include "mozilla/ipc/IPCCore.h"

#include "mozilla/dom/PContentChild.h"
#include "mozilla/ipc/PBackgroundChild.h"

#include "ipc/IPCMessageUtils.h"
#include "ipc/IPCMessageUtilsSpecializations.h"
#include "nsIFile.h"
#include "mozilla/ipc/Endpoint.h"
#include "mozilla/ipc/ProtocolMessageUtils.h"
#include "mozilla/ipc/ProtocolUtils.h"
#include "mozilla/ipc/ShmemMessageUtils.h"
#include "mozilla/ipc/TaintingIPCUtils.h"

namespace mozilla {
namespace camera {


auto PCamerasChild::Recv__delete__() -> mozilla::ipc::IPCResult
{
    return IPC_OK();
}

MOZ_IMPLICIT PCamerasChild::PCamerasChild() :
    mozilla::ipc::IProtocol(kProtocolId, mozilla::ipc::ChildSide)
{
    MOZ_COUNT_CTOR(PCamerasChild);
}

PCamerasChild::~PCamerasChild()
{
    MOZ_COUNT_DTOR(PCamerasChild);
}

auto PCamerasChild::ActorAlloc() -> void
{
}

auto PCamerasChild::ActorDealloc() -> void
{
    if (Manager()) {
        Manager()->DeallocManagee(kProtocolId, this);
    }
}

auto PCamerasChild::OtherPid() const -> ::base::ProcessId
{
    ::base::ProcessId pid =
        ::mozilla::ipc::IProtocol::ToplevelProtocol()->OtherPidMaybeInvalid();
    MOZ_RELEASE_ASSERT(pid != ::base::kInvalidProcessId);
    return pid;
}

auto PCamerasChild::OtherChildID() const -> ::GeckoChildID
{
    ::GeckoChildID childID =
        ::mozilla::ipc::IProtocol::ToplevelProtocol()->OtherChildIDMaybeInvalid();
    MOZ_RELEASE_ASSERT(childID != -1);
    return childID;
}

auto PCamerasChild::OtherEndpointProcInfo() const -> ::mozilla::ipc::EndpointProcInfo
{
    return ::mozilla::ipc::EndpointProcInfo{OtherPid(), OtherChildID()};
}

auto PCamerasChild::Manager() const -> PBackgroundChild*
{
    return static_cast<PBackgroundChild*>(IProtocol::Manager());
}

auto PCamerasChild::ManagedProtocolIds() const -> mozilla::Span<mozilla::ipc::ProtocolId const>
{
    return {};
}

auto PCamerasChild::GetManagedActors(mozilla::ipc::ProtocolId aProtocol) -> UntypedManagedContainer*
{
    switch (aProtocol) {
    default:
        return nullptr;
    }
}

auto PCamerasChild::SendNumberOfCaptureDevices(const CaptureEngine& engine) -> bool
{
    UniquePtr<IPC::Message> msg__ = PCameras::Msg_NumberOfCaptureDevices(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), engine);
    // Sentinel = 'engine'
    ((&(writer__)))->WriteSentinel(144835191);




    if (mozilla::ipc::LoggingEnabledFor("PCameras", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PCamerasChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PCameras::Msg_NumberOfCaptureDevices", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PCamerasChild::SendNumberOfCapabilities(
        const CaptureEngine& engine,
        const nsACString& deviceUniqueIdUTF8) -> bool
{
    UniquePtr<IPC::Message> msg__ = PCameras::Msg_NumberOfCapabilities(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), engine);
    // Sentinel = 'engine'
    ((&(writer__)))->WriteSentinel(144835191);
    IPC::WriteParam((&(writer__)), deviceUniqueIdUTF8);
    // Sentinel = 'deviceUniqueIdUTF8'
    ((&(writer__)))->WriteSentinel(1137903292);




    if (mozilla::ipc::LoggingEnabledFor("PCameras", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PCamerasChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PCameras::Msg_NumberOfCapabilities", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PCamerasChild::SendGetCaptureCapability(
        const CaptureEngine& engine,
        const nsACString& unique_idUTF8,
        const int& capability_number) -> bool
{
    UniquePtr<IPC::Message> msg__ = PCameras::Msg_GetCaptureCapability(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), engine);
    // Sentinel = 'engine'
    ((&(writer__)))->WriteSentinel(144835191);
    IPC::WriteParam((&(writer__)), unique_idUTF8);
    // Sentinel = 'unique_idUTF8'
    ((&(writer__)))->WriteSentinel(628032747);
    IPC::WriteParam((&(writer__)), capability_number);
    // Sentinel = 'capability_number'
    ((&(writer__)))->WriteSentinel(1050543883);




    if (mozilla::ipc::LoggingEnabledFor("PCameras", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PCamerasChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PCameras::Msg_GetCaptureCapability", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PCamerasChild::SendGetCaptureDevice(
        const CaptureEngine& engine,
        const int& deviceIndex) -> bool
{
    UniquePtr<IPC::Message> msg__ = PCameras::Msg_GetCaptureDevice(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), engine);
    // Sentinel = 'engine'
    ((&(writer__)))->WriteSentinel(144835191);
    IPC::WriteParam((&(writer__)), deviceIndex);
    // Sentinel = 'deviceIndex'
    ((&(writer__)))->WriteSentinel(442303593);




    if (mozilla::ipc::LoggingEnabledFor("PCameras", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PCamerasChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PCameras::Msg_GetCaptureDevice", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PCamerasChild::SendAllocateCapture(
        const CaptureEngine& engine,
        const nsACString& unique_idUTF8,
        const uint64_t& windowID) -> bool
{
    UniquePtr<IPC::Message> msg__ = PCameras::Msg_AllocateCapture(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), engine);
    // Sentinel = 'engine'
    ((&(writer__)))->WriteSentinel(144835191);
    IPC::WriteParam((&(writer__)), unique_idUTF8);
    // Sentinel = 'unique_idUTF8'
    ((&(writer__)))->WriteSentinel(628032747);
    IPC::WriteParam((&(writer__)), windowID);
    // Sentinel = 'windowID'
    ((&(writer__)))->WriteSentinel(253625126);




    if (mozilla::ipc::LoggingEnabledFor("PCameras", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PCamerasChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PCameras::Msg_AllocateCapture", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PCamerasChild::SendReleaseCapture(
        const CaptureEngine& engine,
        const int& captureId) -> bool
{
    UniquePtr<IPC::Message> msg__ = PCameras::Msg_ReleaseCapture(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), engine);
    // Sentinel = 'engine'
    ((&(writer__)))->WriteSentinel(144835191);
    IPC::WriteParam((&(writer__)), captureId);
    // Sentinel = 'captureId'
    ((&(writer__)))->WriteSentinel(311034786);




    if (mozilla::ipc::LoggingEnabledFor("PCameras", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PCamerasChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PCameras::Msg_ReleaseCapture", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PCamerasChild::SendStartCapture(
        const CaptureEngine& engine,
        const int& captureId,
        const VideoCaptureCapability& capability) -> bool
{
    UniquePtr<IPC::Message> msg__ = PCameras::Msg_StartCapture(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), engine);
    // Sentinel = 'engine'
    ((&(writer__)))->WriteSentinel(144835191);
    IPC::WriteParam((&(writer__)), captureId);
    // Sentinel = 'captureId'
    ((&(writer__)))->WriteSentinel(311034786);
    IPC::WriteParam((&(writer__)), capability);
    // Sentinel = 'capability'
    ((&(writer__)))->WriteSentinel(371000355);




    if (mozilla::ipc::LoggingEnabledFor("PCameras", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PCamerasChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PCameras::Msg_StartCapture", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PCamerasChild::SendFocusOnSelectedSource(
        const CaptureEngine& engine,
        const int& captureId) -> bool
{
    UniquePtr<IPC::Message> msg__ = PCameras::Msg_FocusOnSelectedSource(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), engine);
    // Sentinel = 'engine'
    ((&(writer__)))->WriteSentinel(144835191);
    IPC::WriteParam((&(writer__)), captureId);
    // Sentinel = 'captureId'
    ((&(writer__)))->WriteSentinel(311034786);




    if (mozilla::ipc::LoggingEnabledFor("PCameras", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PCamerasChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PCameras::Msg_FocusOnSelectedSource", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PCamerasChild::SendStopCapture(
        const CaptureEngine& engine,
        const int& captureId) -> bool
{
    UniquePtr<IPC::Message> msg__ = PCameras::Msg_StopCapture(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), engine);
    // Sentinel = 'engine'
    ((&(writer__)))->WriteSentinel(144835191);
    IPC::WriteParam((&(writer__)), captureId);
    // Sentinel = 'captureId'
    ((&(writer__)))->WriteSentinel(311034786);




    if (mozilla::ipc::LoggingEnabledFor("PCameras", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PCamerasChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PCameras::Msg_StopCapture", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PCamerasChild::SendReleaseFrame(Shmem&& s) -> bool
{
    UniquePtr<IPC::Message> msg__ = PCameras::Msg_ReleaseFrame(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), std::move(s));
    // Sentinel = 's'
    ((&(writer__)))->WriteSentinel(7602292);




    if (mozilla::ipc::LoggingEnabledFor("PCameras", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PCamerasChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PCameras::Msg_ReleaseFrame", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PCamerasChild::SendEnsureInitialized(const CaptureEngine& engine) -> bool
{
    UniquePtr<IPC::Message> msg__ = PCameras::Msg_EnsureInitialized(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), engine);
    // Sentinel = 'engine'
    ((&(writer__)))->WriteSentinel(144835191);




    if (mozilla::ipc::LoggingEnabledFor("PCameras", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PCamerasChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PCameras::Msg_EnsureInitialized", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PCamerasChild::DeallocManagee(
        int32_t aProtocolId,
        IProtocol* aListener) -> void
{
    FatalError("unreached");
    return;
}

auto PCamerasChild::OnMessageReceived(const Message& msg__) -> PCamerasChild::Result
{
    switch (msg__.type()) {
    case MANAGED_ENDPOINT_BOUND_MESSAGE_TYPE:
        {
            if (!mAwaitingManagedEndpointBind) {
                NS_WARNING("Unexpected managed endpoint lifecycle message after actor bound!");
                return MsgNotAllowed;
            }
            mAwaitingManagedEndpointBind = false;
            return MsgProcessed;
        }
    case MANAGED_ENDPOINT_DROPPED_MESSAGE_TYPE:
        {
            if (!mAwaitingManagedEndpointBind) {
                NS_WARNING("Unexpected managed endpoint lifecycle message after actor bound!");
                return MsgNotAllowed;
            }
            mAwaitingManagedEndpointBind = false;
            this->ActorDisconnected(ManagedEndpointDropped);
            return MsgProcessed;
        }
    case PCameras::Msg_CaptureEnded__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PCameras", mozilla::ipc::ChildSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PCamerasChild",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PCameras::Msg_CaptureEnded", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__streamId = IPC::ReadParam<int>((&(reader__)));
            if (!maybe__streamId) {
                FatalError("Error deserializing 'int'");
                return MsgValueError;

            }
            auto& streamId = *maybe__streamId;
            // Sentinel = 'streamId'
            if ((!(((&(reader__)))->ReadSentinel(254935866)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'int'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::IPCResult __ok = (this)->RecvCaptureEnded(std::move(streamId));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PCameras::Msg_DeliverFrame__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PCameras", mozilla::ipc::ChildSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PCamerasChild",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PCameras::Msg_DeliverFrame", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__streamId = IPC::ReadParam<int>((&(reader__)));
            if (!maybe__streamId) {
                FatalError("Error deserializing 'int'");
                return MsgValueError;

            }
            auto& streamId = *maybe__streamId;
            // Sentinel = 'streamId'
            if ((!(((&(reader__)))->ReadSentinel(254935866)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'int'");
                return MsgValueError;
            }
            auto maybe__buffer = IPC::ReadParam<Shmem>((&(reader__)));
            if (!maybe__buffer) {
                FatalError("Error deserializing 'Shmem'");
                return MsgValueError;

            }
            auto& buffer = *maybe__buffer;
            // Sentinel = 'buffer'
            if ((!(((&(reader__)))->ReadSentinel(144769659)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'Shmem'");
                return MsgValueError;
            }
            auto maybe__props = IPC::ReadParam<VideoFrameProperties>((&(reader__)));
            if (!maybe__props) {
                FatalError("Error deserializing 'VideoFrameProperties'");
                return MsgValueError;

            }
            auto& props = *maybe__props;
            // Sentinel = 'props'
            if ((!(((&(reader__)))->ReadSentinel(110953013)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'VideoFrameProperties'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::IPCResult __ok = (this)->RecvDeliverFrame(std::move(streamId), std::move(buffer), std::move(props));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PCameras::Msg_DeviceChange__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PCameras", mozilla::ipc::ChildSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PCamerasChild",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PCameras::Msg_DeviceChange", OTHER);

            mozilla::ipc::IPCResult __ok = (this)->RecvDeviceChange();
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PCameras::Msg_ReplyNumberOfCaptureDevices__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PCameras", mozilla::ipc::ChildSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PCamerasChild",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PCameras::Msg_ReplyNumberOfCaptureDevices", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__deviceCount = IPC::ReadParam<int>((&(reader__)));
            if (!maybe__deviceCount) {
                FatalError("Error deserializing 'int'");
                return MsgValueError;

            }
            auto& deviceCount = *maybe__deviceCount;
            // Sentinel = 'deviceCount'
            if ((!(((&(reader__)))->ReadSentinel(444859514)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'int'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::IPCResult __ok = (this)->RecvReplyNumberOfCaptureDevices(std::move(deviceCount));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PCameras::Msg_ReplyNumberOfCapabilities__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PCameras", mozilla::ipc::ChildSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PCamerasChild",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PCameras::Msg_ReplyNumberOfCapabilities", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__capabilityCount = IPC::ReadParam<int>((&(reader__)));
            if (!maybe__capabilityCount) {
                FatalError("Error deserializing 'int'");
                return MsgValueError;

            }
            auto& capabilityCount = *maybe__capabilityCount;
            // Sentinel = 'capabilityCount'
            if ((!(((&(reader__)))->ReadSentinel(814089772)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'int'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::IPCResult __ok = (this)->RecvReplyNumberOfCapabilities(std::move(capabilityCount));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PCameras::Msg_ReplyAllocateCapture__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PCameras", mozilla::ipc::ChildSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PCamerasChild",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PCameras::Msg_ReplyAllocateCapture", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__captureId = IPC::ReadParam<int>((&(reader__)));
            if (!maybe__captureId) {
                FatalError("Error deserializing 'int'");
                return MsgValueError;

            }
            auto& captureId = *maybe__captureId;
            // Sentinel = 'captureId'
            if ((!(((&(reader__)))->ReadSentinel(311034786)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'int'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::IPCResult __ok = (this)->RecvReplyAllocateCapture(std::move(captureId));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PCameras::Msg_ReplyGetCaptureCapability__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PCameras", mozilla::ipc::ChildSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PCamerasChild",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PCameras::Msg_ReplyGetCaptureCapability", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__cap = IPC::ReadParam<VideoCaptureCapability>((&(reader__)));
            if (!maybe__cap) {
                FatalError("Error deserializing 'VideoCaptureCapability'");
                return MsgValueError;

            }
            auto& cap = *maybe__cap;
            // Sentinel = 'cap'
            if ((!(((&(reader__)))->ReadSentinel(39715125)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'VideoCaptureCapability'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::IPCResult __ok = (this)->RecvReplyGetCaptureCapability(std::move(cap));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PCameras::Msg_ReplyGetCaptureDevice__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PCameras", mozilla::ipc::ChildSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PCamerasChild",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PCameras::Msg_ReplyGetCaptureDevice", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__device_name = IPC::ReadParam<nsCString>((&(reader__)));
            if (!maybe__device_name) {
                FatalError("Error deserializing 'nsCString'");
                return MsgValueError;

            }
            auto& device_name = *maybe__device_name;
            // Sentinel = 'device_name'
            if ((!(((&(reader__)))->ReadSentinel(448726129)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'nsCString'");
                return MsgValueError;
            }
            auto maybe__device_id = IPC::ReadParam<nsCString>((&(reader__)));
            if (!maybe__device_id) {
                FatalError("Error deserializing 'nsCString'");
                return MsgValueError;

            }
            auto& device_id = *maybe__device_id;
            // Sentinel = 'device_id'
            if ((!(((&(reader__)))->ReadSentinel(305857437)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'nsCString'");
                return MsgValueError;
            }
            auto maybe__scary = IPC::ReadParam<bool>((&(reader__)));
            if (!maybe__scary) {
                FatalError("Error deserializing 'bool'");
                return MsgValueError;

            }
            auto& scary = *maybe__scary;
            // Sentinel = 'scary'
            if ((!(((&(reader__)))->ReadSentinel(105906723)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'bool'");
                return MsgValueError;
            }
            auto maybe__placeholder = IPC::ReadParam<bool>((&(reader__)));
            if (!maybe__placeholder) {
                FatalError("Error deserializing 'bool'");
                return MsgValueError;

            }
            auto& placeholder = *maybe__placeholder;
            // Sentinel = 'placeholder'
            if ((!(((&(reader__)))->ReadSentinel(453641348)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'bool'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::IPCResult __ok = (this)->RecvReplyGetCaptureDevice(std::move(device_name), std::move(device_id), std::move(scary), std::move(placeholder));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PCameras::Msg_ReplyFailure__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PCameras", mozilla::ipc::ChildSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PCamerasChild",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PCameras::Msg_ReplyFailure", OTHER);

            mozilla::ipc::IPCResult __ok = (this)->RecvReplyFailure();
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PCameras::Msg_ReplySuccess__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PCameras", mozilla::ipc::ChildSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PCamerasChild",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PCameras::Msg_ReplySuccess", OTHER);

            mozilla::ipc::IPCResult __ok = (this)->RecvReplySuccess();
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PCameras::Msg___delete____ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PCameras", mozilla::ipc::ChildSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PCamerasChild",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PCameras::Msg___delete__", OTHER);

            mozilla::ipc::IPCResult __ok = (this)->Recv__delete__();
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }


            this->ActorDisconnected(Deletion);

            return MsgProcessed;
        }
    default:
        return MsgNotKnown;
    }
}

auto PCamerasChild::OnMessageReceived(
        const Message& msg__,
        UniquePtr<Message>& reply__) -> PCamerasChild::Result
{
    return MsgNotKnown;
}



} // namespace camera
} // namespace mozilla
namespace IPC {
auto ParamTraits<::mozilla::camera::PCamerasChild*>::Write(
        IPC::MessageWriter* aWriter,
        const paramType& aVar) -> void
{
    MOZ_RELEASE_ASSERT(
        aWriter->GetActor(),
        "Cannot serialize managed actors without an actor");

    int32_t id;
    if (!aVar) {
        id = 0;  // kNullActorId
    } else {
        id = aVar->Id();
        if (id == 1) {  // kFreedActorId
            aVar->FatalError("Actor has been |delete|d");
        }
        MOZ_RELEASE_ASSERT(
            aWriter->GetActor()->GetIPCChannel() == aVar->GetIPCChannel(),
            "Actor must be from the same channel as the"
            " actor it's being sent over");
        MOZ_RELEASE_ASSERT(
            aVar->CanSend(),
            "Actor must still be open when sending");
    }

    IPC::WriteParam(aWriter, id);
}

auto ParamTraits<::mozilla::camera::PCamerasChild*>::Read(IPC::MessageReader* aReader) -> IPC::ReadResult<paramType>
{
    MOZ_RELEASE_ASSERT(
        aReader->GetActor(),
        "Cannot deserialize managed actors without an actor");
    mozilla::Maybe<mozilla::ipc::IProtocol*> actor = aReader->GetActor()
        ->ReadActor(aReader, true, "PCameras", PCamerasMsgStart);
    if (actor.isSome()) {
        return static_cast<::mozilla::camera::PCamerasChild*>(actor.ref());
    }
    return {};
}

} // namespace IPC
