//
// Automatically generated by ipdlc.
// Edit at your own risk
//


#include "mozilla/dom/cache/PCacheStreamControlChild.h"
#include "mozilla/ProfilerLabels.h"
#include "mozilla/dom/cache/CacheStreamControlChild.h"
#include "nsID.h"

#include "mozilla/ipc/PBackgroundChild.h"

#include "ipc/IPCMessageUtils.h"
#include "ipc/IPCMessageUtilsSpecializations.h"
#include "nsIFile.h"
#include "mozilla/ipc/Endpoint.h"
#include "mozilla/ipc/ProtocolMessageUtils.h"
#include "mozilla/ipc/ProtocolUtils.h"
#include "mozilla/ipc/ShmemMessageUtils.h"
#include "mozilla/ipc/TaintingIPCUtils.h"

namespace mozilla {
namespace dom {
namespace cache {


auto PCacheStreamControlChild::Recv__delete__() -> mozilla::ipc::IPCResult
{
    return IPC_OK();
}

MOZ_IMPLICIT PCacheStreamControlChild::PCacheStreamControlChild() :
    mozilla::ipc::IRefCountedProtocol(kProtocolId, mozilla::ipc::ChildSide)
{
    MOZ_COUNT_CTOR(PCacheStreamControlChild);
}

PCacheStreamControlChild::~PCacheStreamControlChild()
{
    MOZ_COUNT_DTOR(PCacheStreamControlChild);
}

auto PCacheStreamControlChild::ActorAlloc() -> void
{
    AddRef();
}

auto PCacheStreamControlChild::ActorDealloc() -> void
{
    Release();
}

auto PCacheStreamControlChild::OtherPid() const -> ::base::ProcessId
{
    ::base::ProcessId pid =
        ::mozilla::ipc::IProtocol::ToplevelProtocol()->OtherPidMaybeInvalid();
    MOZ_RELEASE_ASSERT(pid != ::base::kInvalidProcessId);
    return pid;
}

auto PCacheStreamControlChild::OtherChildID() const -> ::GeckoChildID
{
    ::GeckoChildID childID =
        ::mozilla::ipc::IProtocol::ToplevelProtocol()->OtherChildIDMaybeInvalid();
    MOZ_RELEASE_ASSERT(childID != -1);
    return childID;
}

auto PCacheStreamControlChild::OtherEndpointProcInfo() const -> ::mozilla::ipc::EndpointProcInfo
{
    return ::mozilla::ipc::EndpointProcInfo{OtherPid(), OtherChildID()};
}

auto PCacheStreamControlChild::Manager() const -> PBackgroundChild*
{
    return static_cast<PBackgroundChild*>(IProtocol::Manager());
}

auto PCacheStreamControlChild::ManagedProtocolIds() const -> mozilla::Span<mozilla::ipc::ProtocolId const>
{
    return {};
}

auto PCacheStreamControlChild::GetManagedActors(mozilla::ipc::ProtocolId aProtocol) -> UntypedManagedContainer*
{
    switch (aProtocol) {
    default:
        return nullptr;
    }
}

auto PCacheStreamControlChild::RejectPendingResponses(ResponseRejectReason aReason) -> void
{
    mAsyncCallbacks.RejectPendingResponses(aReason);
}

auto PCacheStreamControlChild::SendOpenStream(
        const nsID& aStreamId,
        mozilla::ipc::ResolveCallback<mozilla::Maybe<IPCStream>>&& aResolve,
        mozilla::ipc::RejectCallback&& aReject) -> void
{
    UniquePtr<IPC::Message> msg__ = PCacheStreamControl::Msg_OpenStream(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), aStreamId);
    // Sentinel = 'aStreamId'
    ((&(writer__)))->WriteSentinel(295437179);




    if (mozilla::ipc::LoggingEnabledFor("PCacheStreamControl", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PCacheStreamControlChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PCacheStreamControl::Msg_OpenStream", OTHER);

    int32_t seqno__ = 0;
    if (ChannelSend(std::move(msg__), (&(seqno__)))) {
        mAsyncCallbacks.AddCallback(seqno__, PCacheStreamControl::Reply_OpenStream__ID, [resolve=std::move(aResolve)](IPC::MessageReader* aReader) mutable {
            auto maybe__aStream = IPC::ReadParam<mozilla::Maybe<IPCStream>>(aReader);
            if (!maybe__aStream) {
                (aReader)->FatalError("Error deserializing 'IPCStream?'");
                return MsgValueError;

            }
            auto& aStream = *maybe__aStream;
            // Sentinel = 'aStream'
            if ((!((aReader)->ReadSentinel(185205454)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'IPCStream?'");
                return MsgValueError;
            }


            aReader->EndRead();

            resolve(std::move(aStream));
            return MsgProcessed;
        }, std::move(aReject));
    }
    else {
        aReject(::mozilla::ipc::ResponseRejectReason::SendError);
    }
    return;
}

auto PCacheStreamControlChild::SendOpenStream(const nsID& aStreamId) -> RefPtr<OpenStreamPromise>
{
    RefPtr<MozPromise<mozilla::Maybe<IPCStream>, ResponseRejectReason, true>::Private> promise__ = new MozPromise<mozilla::Maybe<IPCStream>, ResponseRejectReason, true>::Private(__func__);
    promise__->UseDirectTaskDispatch(__func__);
    SendOpenStream(std::move(aStreamId), [promise__](mozilla::Maybe<IPCStream>&& aValue) {
        promise__->Resolve(std::move(aValue), __func__);
    }, [promise__](ResponseRejectReason&& aReason) {
        promise__->Reject(std::move(aReason), __func__);
    });
    return promise__;
}

auto PCacheStreamControlChild::SendNoteClosed(const nsID& aStreamId) -> bool
{
    UniquePtr<IPC::Message> msg__ = PCacheStreamControl::Msg_NoteClosed(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), aStreamId);
    // Sentinel = 'aStreamId'
    ((&(writer__)))->WriteSentinel(295437179);




    if (mozilla::ipc::LoggingEnabledFor("PCacheStreamControl", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PCacheStreamControlChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PCacheStreamControl::Msg_NoteClosed", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PCacheStreamControlChild::DeallocManagee(
        int32_t aProtocolId,
        IProtocol* aListener) -> void
{
    FatalError("unreached");
    return;
}

auto PCacheStreamControlChild::OnMessageReceived(const Message& msg__) -> PCacheStreamControlChild::Result
{
    switch (msg__.type()) {
    case MANAGED_ENDPOINT_BOUND_MESSAGE_TYPE:
        {
            if (!mAwaitingManagedEndpointBind) {
                NS_WARNING("Unexpected managed endpoint lifecycle message after actor bound!");
                return MsgNotAllowed;
            }
            mAwaitingManagedEndpointBind = false;
            return MsgProcessed;
        }
    case MANAGED_ENDPOINT_DROPPED_MESSAGE_TYPE:
        {
            if (!mAwaitingManagedEndpointBind) {
                NS_WARNING("Unexpected managed endpoint lifecycle message after actor bound!");
                return MsgNotAllowed;
            }
            mAwaitingManagedEndpointBind = false;
            this->ActorDisconnected(ManagedEndpointDropped);
            return MsgProcessed;
        }
    case PCacheStreamControl::Reply_OpenStream__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PCacheStreamControl", mozilla::ipc::ChildSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PCacheStreamControlChild",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }

            AUTO_PROFILER_LABEL("PCacheStreamControl::Msg_OpenStream", OTHER);


            return mAsyncCallbacks.GotReply(this, msg__);
        }
    case PCacheStreamControl::Msg_CloseAll__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PCacheStreamControl", mozilla::ipc::ChildSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PCacheStreamControlChild",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PCacheStreamControl::Msg_CloseAll", OTHER);

            mozilla::ipc::IPCResult __ok = (static_cast<CacheStreamControlChild*>(this))->RecvCloseAll();
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PCacheStreamControl::Msg___delete____ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PCacheStreamControl", mozilla::ipc::ChildSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PCacheStreamControlChild",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PCacheStreamControl::Msg___delete__", OTHER);

            mozilla::ipc::IPCResult __ok = (static_cast<CacheStreamControlChild*>(this))->Recv__delete__();
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }


            this->ActorDisconnected(Deletion);

            return MsgProcessed;
        }
    default:
        return MsgNotKnown;
    }
}

auto PCacheStreamControlChild::OnMessageReceived(
        const Message& msg__,
        UniquePtr<Message>& reply__) -> PCacheStreamControlChild::Result
{
    return MsgNotKnown;
}



} // namespace cache
} // namespace dom
} // namespace mozilla
namespace IPC {
auto ParamTraits<::mozilla::dom::cache::PCacheStreamControlChild*>::Write(
        IPC::MessageWriter* aWriter,
        const paramType& aVar) -> void
{
    MOZ_RELEASE_ASSERT(
        aWriter->GetActor(),
        "Cannot serialize managed actors without an actor");

    int32_t id;
    if (!aVar) {
        id = 0;  // kNullActorId
    } else {
        id = aVar->Id();
        if (id == 1) {  // kFreedActorId
            aVar->FatalError("Actor has been |delete|d");
        }
        MOZ_RELEASE_ASSERT(
            aWriter->GetActor()->GetIPCChannel() == aVar->GetIPCChannel(),
            "Actor must be from the same channel as the"
            " actor it's being sent over");
        MOZ_RELEASE_ASSERT(
            aVar->CanSend(),
            "Actor must still be open when sending");
    }

    IPC::WriteParam(aWriter, id);
}

auto ParamTraits<::mozilla::dom::cache::PCacheStreamControlChild*>::Read(IPC::MessageReader* aReader) -> IPC::ReadResult<paramType>
{
    MOZ_RELEASE_ASSERT(
        aReader->GetActor(),
        "Cannot deserialize managed actors without an actor");
    mozilla::Maybe<mozilla::ipc::IProtocol*> actor = aReader->GetActor()
        ->ReadActor(aReader, true, "PCacheStreamControl", PCacheStreamControlMsgStart);
    if (actor.isSome()) {
        return static_cast<::mozilla::dom::cache::PCacheStreamControlChild*>(actor.ref());
    }
    return {};
}

} // namespace IPC
