//
// Automatically generated by ipdlc.
// Edit at your own risk
//


#include "mozilla/dom/cache/PCacheParent.h"
#include "mozilla/ProfilerLabels.h"
#include "mozilla/dom/FetchIPCTypes.h"
#include "mozilla/dom/cache/CacheParent.h"
#include "mozilla/dom/cache/IPCUtils.h"
#include "mozilla/ipc/TransportSecurityInfoUtils.h"
#include "nsID.h"
#include "nsITransportSecurityInfo.h"

#include "mozilla/ipc/PBackgroundParent.h"
#include "mozilla/dom/cache/PCacheOpParent.h"
#include "mozilla/dom/cache/PCacheStreamControlParent.h"

#include "ipc/IPCMessageUtils.h"
#include "ipc/IPCMessageUtilsSpecializations.h"
#include "nsIFile.h"
#include "mozilla/ipc/Endpoint.h"
#include "mozilla/ipc/ProtocolMessageUtils.h"
#include "mozilla/ipc/ProtocolUtils.h"
#include "mozilla/ipc/ShmemMessageUtils.h"
#include "mozilla/ipc/TaintingIPCUtils.h"

namespace mozilla {
namespace dom {
namespace cache {


auto PCacheParent::RecvPCacheOpConstructor(
        PCacheOpParent* actor,
        const CacheOpArgs& aOpArgs) -> mozilla::ipc::IPCResult
{
    return IPC_OK();
}

MOZ_IMPLICIT PCacheParent::PCacheParent() :
    mozilla::ipc::IRefCountedProtocol(kProtocolId, mozilla::ipc::ParentSide)
{
    MOZ_COUNT_CTOR(PCacheParent);
}

PCacheParent::~PCacheParent()
{
    MOZ_COUNT_DTOR(PCacheParent);
}

auto PCacheParent::ActorAlloc() -> void
{
    AddRef();
}

auto PCacheParent::ActorDealloc() -> void
{
    Release();
}

auto PCacheParent::OtherPid() const -> ::base::ProcessId
{
    ::base::ProcessId pid =
        ::mozilla::ipc::IProtocol::ToplevelProtocol()->OtherPidMaybeInvalid();
    MOZ_RELEASE_ASSERT(pid != ::base::kInvalidProcessId);
    return pid;
}

auto PCacheParent::OtherChildID() const -> ::GeckoChildID
{
    ::GeckoChildID childID =
        ::mozilla::ipc::IProtocol::ToplevelProtocol()->OtherChildIDMaybeInvalid();
    MOZ_RELEASE_ASSERT(childID != -1);
    return childID;
}

auto PCacheParent::OtherEndpointProcInfo() const -> ::mozilla::ipc::EndpointProcInfo
{
    return ::mozilla::ipc::EndpointProcInfo{OtherPid(), OtherChildID()};
}

auto PCacheParent::Manager() const -> PBackgroundParent*
{
    return static_cast<PBackgroundParent*>(IProtocol::Manager());
}

auto PCacheParent::ManagedPCacheOpParent(nsTArray<PCacheOpParent*>& aArr) const -> void
{
    mManagedPCacheOpParent.ToArray(aArr);
}

auto PCacheParent::ManagedPCacheOpParent() const -> const ManagedContainer<PCacheOpParent>&
{
    return mManagedPCacheOpParent;
}

auto PCacheParent::ManagedProtocolIds() const -> mozilla::Span<mozilla::ipc::ProtocolId const>
{
    static constexpr ::mozilla::ipc::ProtocolId sIds[] = {
        PCacheOpMsgStart
    };
    return sIds;
}

auto PCacheParent::GetManagedActors(mozilla::ipc::ProtocolId aProtocol) -> UntypedManagedContainer*
{
    switch (aProtocol) {
    case PCacheOpMsgStart:
        return (&(mManagedPCacheOpParent));
    default:
        return nullptr;
    }
}

auto PCacheParent::OpenPCacheOpEndpoint(PCacheOpParent* aActor) -> ManagedEndpoint<PCacheOpChild>
{
    if (!aActor) {
        NS_WARNING("Cannot bind null PCacheOpParent actor");
        return ManagedEndpoint<PCacheOpChild>();
    }

    if (!aActor->SetManagerAndRegister(this)) {
        NS_WARNING("Failed to bind PCacheOpParent actor");
        return ManagedEndpoint<PCacheOpChild>();
    }

    // Mark our actor as awaiting the other side to be bound. This will
    // be cleared when a `MANAGED_ENDPOINT_{DROPPED,BOUND}` message is
    // received.
    aActor->mAwaitingManagedEndpointBind = true;
    return ManagedEndpoint<PCacheOpChild>(mozilla::ipc::PrivateIPDLInterface(), aActor);
}

auto PCacheParent::BindPCacheOpEndpoint(
        ManagedEndpoint<PCacheOpParent> aEndpoint,
        PCacheOpParent* aActor) -> bool
{
    return aEndpoint.Bind(mozilla::ipc::PrivateIPDLInterface(), aActor, this);
}

auto PCacheParent::Send__delete__(PCacheParent* actor) -> bool
{
    if (!actor || !actor->CanSend()) {
        NS_WARNING("Attempt to __delete__ missing or closed actor");
        return false;
    }
    UniquePtr<IPC::Message> msg__ = PCache::Msg___delete__((actor)->Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            actor};




    if (mozilla::ipc::LoggingEnabledFor("PCache", mozilla::ipc::ParentSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PCacheParent",
            actor->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PCache::Msg___delete__", OTHER);

    bool sendok__ = (actor)->ChannelSend(std::move(msg__));

    actor->ActorDisconnected(Deletion);
    return sendok__;
}

auto PCacheParent::DeallocManagee(
        int32_t aProtocolId,
        IProtocol* aListener) -> void
{
    switch (aProtocolId) {
    default:
        FatalError("unreached");
        return;
    }
}

auto PCacheParent::OnMessageReceived(const Message& msg__) -> PCacheParent::Result
{
    switch (msg__.type()) {
    case MANAGED_ENDPOINT_BOUND_MESSAGE_TYPE:
        {
            if (!mAwaitingManagedEndpointBind) {
                NS_WARNING("Unexpected managed endpoint lifecycle message after actor bound!");
                return MsgNotAllowed;
            }
            mAwaitingManagedEndpointBind = false;
            return MsgProcessed;
        }
    case MANAGED_ENDPOINT_DROPPED_MESSAGE_TYPE:
        {
            if (!mAwaitingManagedEndpointBind) {
                NS_WARNING("Unexpected managed endpoint lifecycle message after actor bound!");
                return MsgNotAllowed;
            }
            mAwaitingManagedEndpointBind = false;
            this->ActorDisconnected(ManagedEndpointDropped);
            return MsgProcessed;
        }
    case PCache::Msg_PCacheOpConstructor__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PCache", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PCacheParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PCache::Msg_PCacheOpConstructor", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__handle__ = IPC::ReadParam<ActorHandle>((&(reader__)));
            if (!maybe__handle__) {
                FatalError("Error deserializing 'ActorHandle'");
                return MsgValueError;

            }
            auto& handle__ = *maybe__handle__;
            // Sentinel = 'actor'
            if ((!(((&(reader__)))->ReadSentinel(102892058)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'ActorHandle'");
                return MsgValueError;
            }
            auto maybe__aOpArgs = IPC::ReadParam<CacheOpArgs>((&(reader__)));
            if (!maybe__aOpArgs) {
                FatalError("Error deserializing 'CacheOpArgs'");
                return MsgValueError;

            }
            auto& aOpArgs = *maybe__aOpArgs;
            // Sentinel = 'aOpArgs'
            if ((!(((&(reader__)))->ReadSentinel(173212334)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'CacheOpArgs'");
                return MsgValueError;
            }
            reader__.EndRead();
            RefPtr<PCacheOpParent> actor = (static_cast<CacheParent*>(this))->AllocPCacheOpParent(aOpArgs);
            if (!actor) {
                NS_WARNING("Cannot bind null PCacheOpParent actor");
                return MsgValueError;
            }

            if (!actor->SetManagerAndRegister(this, (handle__).mId)) {
                NS_WARNING("Failed to bind PCacheOpParent actor");
                return MsgValueError;
            }

            mozilla::ipc::IPCResult __ok = (static_cast<CacheParent*>(this))->RecvPCacheOpConstructor(actor, std::move(aOpArgs));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PCache::Msg_Teardown__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PCache", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PCacheParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PCache::Msg_Teardown", OTHER);

            mozilla::ipc::IPCResult __ok = (static_cast<CacheParent*>(this))->RecvTeardown();
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PCache::Reply___delete____ID:
        {
            return MsgProcessed;
        }
    default:
        return MsgNotKnown;
    }
}

auto PCacheParent::OnMessageReceived(
        const Message& msg__,
        UniquePtr<Message>& reply__) -> PCacheParent::Result
{
    return MsgNotKnown;
}



} // namespace cache
} // namespace dom
} // namespace mozilla
namespace IPC {
auto ParamTraits<::mozilla::dom::cache::PCacheParent*>::Write(
        IPC::MessageWriter* aWriter,
        const paramType& aVar) -> void
{
    MOZ_RELEASE_ASSERT(
        aWriter->GetActor(),
        "Cannot serialize managed actors without an actor");

    int32_t id;
    if (!aVar) {
        id = 0;  // kNullActorId
    } else {
        id = aVar->Id();
        if (id == 1) {  // kFreedActorId
            aVar->FatalError("Actor has been |delete|d");
        }
        MOZ_RELEASE_ASSERT(
            aWriter->GetActor()->GetIPCChannel() == aVar->GetIPCChannel(),
            "Actor must be from the same channel as the"
            " actor it's being sent over");
        MOZ_RELEASE_ASSERT(
            aVar->CanSend(),
            "Actor must still be open when sending");
    }

    IPC::WriteParam(aWriter, id);
}

auto ParamTraits<::mozilla::dom::cache::PCacheParent*>::Read(IPC::MessageReader* aReader) -> IPC::ReadResult<paramType>
{
    MOZ_RELEASE_ASSERT(
        aReader->GetActor(),
        "Cannot deserialize managed actors without an actor");
    mozilla::Maybe<mozilla::ipc::IProtocol*> actor = aReader->GetActor()
        ->ReadActor(aReader, true, "PCache", PCacheMsgStart);
    if (actor.isSome()) {
        return static_cast<::mozilla::dom::cache::PCacheParent*>(actor.ref());
    }
    return {};
}

} // namespace IPC
