//
// Automatically generated by ipdlc.
// Edit at your own risk
//


#include "mozilla/dom/cache/PCacheOpParent.h"
#include "ipc/ErrorIPCUtils.h"
#include "mozilla/ProfilerLabels.h"
#include "mozilla/dom/FetchIPCTypes.h"
#include "mozilla/dom/cache/CacheOpParent.h"
#include "mozilla/dom/cache/IPCUtils.h"
#include "mozilla/ipc/TransportSecurityInfoUtils.h"
#include "nsID.h"
#include "nsITransportSecurityInfo.h"

#include "mozilla/dom/cache/PCacheParent.h"
#include "mozilla/dom/cache/PCacheStorageParent.h"
#include "mozilla/dom/cache/PCacheStreamControlParent.h"

#include "ipc/IPCMessageUtils.h"
#include "ipc/IPCMessageUtilsSpecializations.h"
#include "nsIFile.h"
#include "mozilla/ipc/Endpoint.h"
#include "mozilla/ipc/ProtocolMessageUtils.h"
#include "mozilla/ipc/ProtocolUtils.h"
#include "mozilla/ipc/ShmemMessageUtils.h"
#include "mozilla/ipc/TaintingIPCUtils.h"

namespace mozilla {
namespace dom {
namespace cache {


MOZ_IMPLICIT PCacheOpParent::PCacheOpParent() :
    mozilla::ipc::IRefCountedProtocol(kProtocolId, mozilla::ipc::ParentSide)
{
    MOZ_COUNT_CTOR(PCacheOpParent);
}

PCacheOpParent::~PCacheOpParent()
{
    MOZ_COUNT_DTOR(PCacheOpParent);
}

auto PCacheOpParent::ActorAlloc() -> void
{
    AddRef();
}

auto PCacheOpParent::ActorDealloc() -> void
{
    Release();
}

auto PCacheOpParent::OtherPid() const -> ::base::ProcessId
{
    ::base::ProcessId pid =
        ::mozilla::ipc::IProtocol::ToplevelProtocol()->OtherPidMaybeInvalid();
    MOZ_RELEASE_ASSERT(pid != ::base::kInvalidProcessId);
    return pid;
}

auto PCacheOpParent::OtherChildID() const -> ::GeckoChildID
{
    ::GeckoChildID childID =
        ::mozilla::ipc::IProtocol::ToplevelProtocol()->OtherChildIDMaybeInvalid();
    MOZ_RELEASE_ASSERT(childID != -1);
    return childID;
}

auto PCacheOpParent::OtherEndpointProcInfo() const -> ::mozilla::ipc::EndpointProcInfo
{
    return ::mozilla::ipc::EndpointProcInfo{OtherPid(), OtherChildID()};
}

auto PCacheOpParent::ManagedProtocolIds() const -> mozilla::Span<mozilla::ipc::ProtocolId const>
{
    return {};
}

auto PCacheOpParent::GetManagedActors(mozilla::ipc::ProtocolId aProtocol) -> UntypedManagedContainer*
{
    switch (aProtocol) {
    default:
        return nullptr;
    }
}

auto PCacheOpParent::Send__delete__(
        PCacheOpParent* actor,
        const CopyableErrorResult& aRv,
        const CacheOpResult& aResult) -> bool
{
    if (!actor || !actor->CanSend()) {
        NS_WARNING("Attempt to __delete__ missing or closed actor");
        return false;
    }
    UniquePtr<IPC::Message> msg__ = PCacheOp::Msg___delete__((actor)->Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            actor};

    IPC::WriteParam((&(writer__)), aRv);
    // Sentinel = 'aRv'
    ((&(writer__)))->WriteSentinel(37749034);
    IPC::WriteParam((&(writer__)), aResult);
    // Sentinel = 'aResult'
    ((&(writer__)))->WriteSentinel(185205473);



    if (mozilla::ipc::LoggingEnabledFor("PCacheOp", mozilla::ipc::ParentSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PCacheOpParent",
            actor->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PCacheOp::Msg___delete__", OTHER);

    bool sendok__ = (actor)->ChannelSend(std::move(msg__));

    actor->ActorDisconnected(Deletion);
    return sendok__;
}

auto PCacheOpParent::DeallocManagee(
        int32_t aProtocolId,
        IProtocol* aListener) -> void
{
    FatalError("unreached");
    return;
}

auto PCacheOpParent::OnMessageReceived(const Message& msg__) -> PCacheOpParent::Result
{
    switch (msg__.type()) {
    case MANAGED_ENDPOINT_BOUND_MESSAGE_TYPE:
        {
            if (!mAwaitingManagedEndpointBind) {
                NS_WARNING("Unexpected managed endpoint lifecycle message after actor bound!");
                return MsgNotAllowed;
            }
            mAwaitingManagedEndpointBind = false;
            return MsgProcessed;
        }
    case MANAGED_ENDPOINT_DROPPED_MESSAGE_TYPE:
        {
            if (!mAwaitingManagedEndpointBind) {
                NS_WARNING("Unexpected managed endpoint lifecycle message after actor bound!");
                return MsgNotAllowed;
            }
            mAwaitingManagedEndpointBind = false;
            this->ActorDisconnected(ManagedEndpointDropped);
            return MsgProcessed;
        }
    case PCacheOp::Reply___delete____ID:
        {
            return MsgProcessed;
        }
    default:
        return MsgNotKnown;
    }
}

auto PCacheOpParent::OnMessageReceived(
        const Message& msg__,
        UniquePtr<Message>& reply__) -> PCacheOpParent::Result
{
    return MsgNotKnown;
}



} // namespace cache
} // namespace dom
} // namespace mozilla
namespace IPC {
auto ParamTraits<::mozilla::dom::cache::PCacheOpParent*>::Write(
        IPC::MessageWriter* aWriter,
        const paramType& aVar) -> void
{
    MOZ_RELEASE_ASSERT(
        aWriter->GetActor(),
        "Cannot serialize managed actors without an actor");

    int32_t id;
    if (!aVar) {
        id = 0;  // kNullActorId
    } else {
        id = aVar->Id();
        if (id == 1) {  // kFreedActorId
            aVar->FatalError("Actor has been |delete|d");
        }
        MOZ_RELEASE_ASSERT(
            aWriter->GetActor()->GetIPCChannel() == aVar->GetIPCChannel(),
            "Actor must be from the same channel as the"
            " actor it's being sent over");
        MOZ_RELEASE_ASSERT(
            aVar->CanSend(),
            "Actor must still be open when sending");
    }

    IPC::WriteParam(aWriter, id);
}

auto ParamTraits<::mozilla::dom::cache::PCacheOpParent*>::Read(IPC::MessageReader* aReader) -> IPC::ReadResult<paramType>
{
    MOZ_RELEASE_ASSERT(
        aReader->GetActor(),
        "Cannot deserialize managed actors without an actor");
    mozilla::Maybe<mozilla::ipc::IProtocol*> actor = aReader->GetActor()
        ->ReadActor(aReader, true, "PCacheOp", PCacheOpMsgStart);
    if (actor.isSome()) {
        return static_cast<::mozilla::dom::cache::PCacheOpParent*>(actor.ref());
    }
    return {};
}

} // namespace IPC
