//
// Automatically generated by ipdlc.
// Edit at your own risk
//


#include "mozilla/dom/cache/PCacheOpChild.h"
#include "ipc/ErrorIPCUtils.h"
#include "mozilla/ProfilerLabels.h"
#include "mozilla/dom/FetchIPCTypes.h"
#include "mozilla/dom/cache/CacheOpChild.h"
#include "mozilla/dom/cache/IPCUtils.h"
#include "mozilla/ipc/TransportSecurityInfoUtils.h"
#include "nsID.h"
#include "nsITransportSecurityInfo.h"

#include "mozilla/dom/cache/PCacheChild.h"
#include "mozilla/dom/cache/PCacheStorageChild.h"
#include "mozilla/dom/cache/PCacheStreamControlChild.h"

#include "ipc/IPCMessageUtils.h"
#include "ipc/IPCMessageUtilsSpecializations.h"
#include "nsIFile.h"
#include "mozilla/ipc/Endpoint.h"
#include "mozilla/ipc/ProtocolMessageUtils.h"
#include "mozilla/ipc/ProtocolUtils.h"
#include "mozilla/ipc/ShmemMessageUtils.h"
#include "mozilla/ipc/TaintingIPCUtils.h"

namespace mozilla {
namespace dom {
namespace cache {


MOZ_IMPLICIT PCacheOpChild::PCacheOpChild() :
    mozilla::ipc::IRefCountedProtocol(kProtocolId, mozilla::ipc::ChildSide)
{
    MOZ_COUNT_CTOR(PCacheOpChild);
}

PCacheOpChild::~PCacheOpChild()
{
    MOZ_COUNT_DTOR(PCacheOpChild);
}

auto PCacheOpChild::ActorAlloc() -> void
{
    AddRef();
}

auto PCacheOpChild::ActorDealloc() -> void
{
    Release();
}

auto PCacheOpChild::OtherPid() const -> ::base::ProcessId
{
    ::base::ProcessId pid =
        ::mozilla::ipc::IProtocol::ToplevelProtocol()->OtherPidMaybeInvalid();
    MOZ_RELEASE_ASSERT(pid != ::base::kInvalidProcessId);
    return pid;
}

auto PCacheOpChild::OtherChildID() const -> ::GeckoChildID
{
    ::GeckoChildID childID =
        ::mozilla::ipc::IProtocol::ToplevelProtocol()->OtherChildIDMaybeInvalid();
    MOZ_RELEASE_ASSERT(childID != -1);
    return childID;
}

auto PCacheOpChild::OtherEndpointProcInfo() const -> ::mozilla::ipc::EndpointProcInfo
{
    return ::mozilla::ipc::EndpointProcInfo{OtherPid(), OtherChildID()};
}

auto PCacheOpChild::ManagedProtocolIds() const -> mozilla::Span<mozilla::ipc::ProtocolId const>
{
    return {};
}

auto PCacheOpChild::GetManagedActors(mozilla::ipc::ProtocolId aProtocol) -> UntypedManagedContainer*
{
    switch (aProtocol) {
    default:
        return nullptr;
    }
}

auto PCacheOpChild::DeallocManagee(
        int32_t aProtocolId,
        IProtocol* aListener) -> void
{
    FatalError("unreached");
    return;
}

auto PCacheOpChild::OnMessageReceived(const Message& msg__) -> PCacheOpChild::Result
{
    switch (msg__.type()) {
    case MANAGED_ENDPOINT_BOUND_MESSAGE_TYPE:
        {
            if (!mAwaitingManagedEndpointBind) {
                NS_WARNING("Unexpected managed endpoint lifecycle message after actor bound!");
                return MsgNotAllowed;
            }
            mAwaitingManagedEndpointBind = false;
            return MsgProcessed;
        }
    case MANAGED_ENDPOINT_DROPPED_MESSAGE_TYPE:
        {
            if (!mAwaitingManagedEndpointBind) {
                NS_WARNING("Unexpected managed endpoint lifecycle message after actor bound!");
                return MsgNotAllowed;
            }
            mAwaitingManagedEndpointBind = false;
            this->ActorDisconnected(ManagedEndpointDropped);
            return MsgProcessed;
        }
    case PCacheOp::Msg___delete____ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PCacheOp", mozilla::ipc::ChildSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PCacheOpChild",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PCacheOp::Msg___delete__", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__aRv = IPC::ReadParam<CopyableErrorResult>((&(reader__)));
            if (!maybe__aRv) {
                FatalError("Error deserializing 'CopyableErrorResult'");
                return MsgValueError;

            }
            auto& aRv = *maybe__aRv;
            // Sentinel = 'aRv'
            if ((!(((&(reader__)))->ReadSentinel(37749034)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'CopyableErrorResult'");
                return MsgValueError;
            }
            auto maybe__aResult = IPC::ReadParam<CacheOpResult>((&(reader__)));
            if (!maybe__aResult) {
                FatalError("Error deserializing 'CacheOpResult'");
                return MsgValueError;

            }
            auto& aResult = *maybe__aResult;
            // Sentinel = 'aResult'
            if ((!(((&(reader__)))->ReadSentinel(185205473)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'CacheOpResult'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::IPCResult __ok = (static_cast<CacheOpChild*>(this))->Recv__delete__(std::move(aRv), std::move(aResult));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }


            this->ActorDisconnected(Deletion);

            return MsgProcessed;
        }
    default:
        return MsgNotKnown;
    }
}

auto PCacheOpChild::OnMessageReceived(
        const Message& msg__,
        UniquePtr<Message>& reply__) -> PCacheOpChild::Result
{
    return MsgNotKnown;
}



} // namespace cache
} // namespace dom
} // namespace mozilla
namespace IPC {
auto ParamTraits<::mozilla::dom::cache::PCacheOpChild*>::Write(
        IPC::MessageWriter* aWriter,
        const paramType& aVar) -> void
{
    MOZ_RELEASE_ASSERT(
        aWriter->GetActor(),
        "Cannot serialize managed actors without an actor");

    int32_t id;
    if (!aVar) {
        id = 0;  // kNullActorId
    } else {
        id = aVar->Id();
        if (id == 1) {  // kFreedActorId
            aVar->FatalError("Actor has been |delete|d");
        }
        MOZ_RELEASE_ASSERT(
            aWriter->GetActor()->GetIPCChannel() == aVar->GetIPCChannel(),
            "Actor must be from the same channel as the"
            " actor it's being sent over");
        MOZ_RELEASE_ASSERT(
            aVar->CanSend(),
            "Actor must still be open when sending");
    }

    IPC::WriteParam(aWriter, id);
}

auto ParamTraits<::mozilla::dom::cache::PCacheOpChild*>::Read(IPC::MessageReader* aReader) -> IPC::ReadResult<paramType>
{
    MOZ_RELEASE_ASSERT(
        aReader->GetActor(),
        "Cannot deserialize managed actors without an actor");
    mozilla::Maybe<mozilla::ipc::IProtocol*> actor = aReader->GetActor()
        ->ReadActor(aReader, true, "PCacheOp", PCacheOpMsgStart);
    if (actor.isSome()) {
        return static_cast<::mozilla::dom::cache::PCacheOpChild*>(actor.ref());
    }
    return {};
}

} // namespace IPC
