//
// Automatically generated by ipdlc.
// Edit at your own risk
//


#include "mozilla/dom/cache/PCacheChild.h"
#include "mozilla/ProfilerLabels.h"
#include "mozilla/dom/FetchIPCTypes.h"
#include "mozilla/dom/cache/CacheChild.h"
#include "mozilla/dom/cache/IPCUtils.h"
#include "mozilla/ipc/TransportSecurityInfoUtils.h"
#include "nsID.h"
#include "nsITransportSecurityInfo.h"

#include "mozilla/ipc/PBackgroundChild.h"
#include "mozilla/dom/cache/PCacheOpChild.h"
#include "mozilla/dom/cache/PCacheStreamControlChild.h"

#include "ipc/IPCMessageUtils.h"
#include "ipc/IPCMessageUtilsSpecializations.h"
#include "nsIFile.h"
#include "mozilla/ipc/Endpoint.h"
#include "mozilla/ipc/ProtocolMessageUtils.h"
#include "mozilla/ipc/ProtocolUtils.h"
#include "mozilla/ipc/ShmemMessageUtils.h"
#include "mozilla/ipc/TaintingIPCUtils.h"

namespace mozilla {
namespace dom {
namespace cache {


auto PCacheChild::Recv__delete__() -> mozilla::ipc::IPCResult
{
    return IPC_OK();
}

MOZ_IMPLICIT PCacheChild::PCacheChild() :
    mozilla::ipc::IRefCountedProtocol(kProtocolId, mozilla::ipc::ChildSide)
{
    MOZ_COUNT_CTOR(PCacheChild);
}

PCacheChild::~PCacheChild()
{
    MOZ_COUNT_DTOR(PCacheChild);
}

auto PCacheChild::ActorAlloc() -> void
{
    AddRef();
}

auto PCacheChild::ActorDealloc() -> void
{
    Release();
}

auto PCacheChild::OtherPid() const -> ::base::ProcessId
{
    ::base::ProcessId pid =
        ::mozilla::ipc::IProtocol::ToplevelProtocol()->OtherPidMaybeInvalid();
    MOZ_RELEASE_ASSERT(pid != ::base::kInvalidProcessId);
    return pid;
}

auto PCacheChild::OtherChildID() const -> ::GeckoChildID
{
    ::GeckoChildID childID =
        ::mozilla::ipc::IProtocol::ToplevelProtocol()->OtherChildIDMaybeInvalid();
    MOZ_RELEASE_ASSERT(childID != -1);
    return childID;
}

auto PCacheChild::OtherEndpointProcInfo() const -> ::mozilla::ipc::EndpointProcInfo
{
    return ::mozilla::ipc::EndpointProcInfo{OtherPid(), OtherChildID()};
}

auto PCacheChild::Manager() const -> PBackgroundChild*
{
    return static_cast<PBackgroundChild*>(IProtocol::Manager());
}

auto PCacheChild::ManagedPCacheOpChild(nsTArray<PCacheOpChild*>& aArr) const -> void
{
    mManagedPCacheOpChild.ToArray(aArr);
}

auto PCacheChild::ManagedPCacheOpChild() const -> const ManagedContainer<PCacheOpChild>&
{
    return mManagedPCacheOpChild;
}

auto PCacheChild::ManagedProtocolIds() const -> mozilla::Span<mozilla::ipc::ProtocolId const>
{
    static constexpr ::mozilla::ipc::ProtocolId sIds[] = {
        PCacheOpMsgStart
    };
    return sIds;
}

auto PCacheChild::GetManagedActors(mozilla::ipc::ProtocolId aProtocol) -> UntypedManagedContainer*
{
    switch (aProtocol) {
    case PCacheOpMsgStart:
        return (&(mManagedPCacheOpChild));
    default:
        return nullptr;
    }
}

auto PCacheChild::OpenPCacheOpEndpoint(PCacheOpChild* aActor) -> ManagedEndpoint<PCacheOpParent>
{
    if (!aActor) {
        NS_WARNING("Cannot bind null PCacheOpChild actor");
        return ManagedEndpoint<PCacheOpParent>();
    }

    if (!aActor->SetManagerAndRegister(this)) {
        NS_WARNING("Failed to bind PCacheOpChild actor");
        return ManagedEndpoint<PCacheOpParent>();
    }

    // Mark our actor as awaiting the other side to be bound. This will
    // be cleared when a `MANAGED_ENDPOINT_{DROPPED,BOUND}` message is
    // received.
    aActor->mAwaitingManagedEndpointBind = true;
    return ManagedEndpoint<PCacheOpParent>(mozilla::ipc::PrivateIPDLInterface(), aActor);
}

auto PCacheChild::BindPCacheOpEndpoint(
        ManagedEndpoint<PCacheOpChild> aEndpoint,
        PCacheOpChild* aActor) -> bool
{
    return aEndpoint.Bind(mozilla::ipc::PrivateIPDLInterface(), aActor, this);
}

auto PCacheChild::SendPCacheOpConstructor(
        PCacheOpChild* actor,
        const CacheOpArgs& aOpArgs) -> PCacheOpChild*
{
    if (!actor) {
        NS_WARNING("Cannot bind null PCacheOpChild actor");
        return nullptr;
    }

    if (!actor->SetManagerAndRegister(this)) {
        NS_WARNING("Failed to bind PCacheOpChild actor");
        return nullptr;
    }


    // Build our constructor message.
    UniquePtr<IPC::Message> msg__ = PCache::Msg_PCacheOpConstructor(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), actor);
    // Sentinel = 'actor'
    ((&(writer__)))->WriteSentinel(102892058);
    IPC::WriteParam((&(writer__)), aOpArgs);
    // Sentinel = 'aOpArgs'
    ((&(writer__)))->WriteSentinel(173212334);




    // Notify the other side about the newly created actor. This can
    // fail if our manager has already been destroyed.
    //
    // NOTE: If the send call fails due to toplevel channel teardown,
    // the `IProtocol::ChannelSend` wrapper absorbs the error for us,
    // so we don't tear down actors unexpectedly.

    if (mozilla::ipc::LoggingEnabledFor("PCache", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PCacheChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PCache::Msg_PCacheOpConstructor", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));


    // Warn, destroy the actor, and return null if the message failed to
    // send. Otherwise, return the successfully created actor reference.
    if (!sendok__) {
        NS_WARNING("Error sending PCacheOpChild constructor");
        actor->ActorDisconnected(FailedConstructor);

        return nullptr;
    }
    return actor;
}

auto PCacheChild::SendTeardown() -> bool
{
    UniquePtr<IPC::Message> msg__ = PCache::Msg_Teardown(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};





    if (mozilla::ipc::LoggingEnabledFor("PCache", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PCacheChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PCache::Msg_Teardown", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PCacheChild::DeallocManagee(
        int32_t aProtocolId,
        IProtocol* aListener) -> void
{
    switch (aProtocolId) {
    default:
        FatalError("unreached");
        return;
    }
}

auto PCacheChild::OnMessageReceived(const Message& msg__) -> PCacheChild::Result
{
    switch (msg__.type()) {
    case MANAGED_ENDPOINT_BOUND_MESSAGE_TYPE:
        {
            if (!mAwaitingManagedEndpointBind) {
                NS_WARNING("Unexpected managed endpoint lifecycle message after actor bound!");
                return MsgNotAllowed;
            }
            mAwaitingManagedEndpointBind = false;
            return MsgProcessed;
        }
    case MANAGED_ENDPOINT_DROPPED_MESSAGE_TYPE:
        {
            if (!mAwaitingManagedEndpointBind) {
                NS_WARNING("Unexpected managed endpoint lifecycle message after actor bound!");
                return MsgNotAllowed;
            }
            mAwaitingManagedEndpointBind = false;
            this->ActorDisconnected(ManagedEndpointDropped);
            return MsgProcessed;
        }
    case PCache::Reply_PCacheOpConstructor__ID:
        {
            return MsgProcessed;
        }
    case PCache::Msg___delete____ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PCache", mozilla::ipc::ChildSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PCacheChild",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PCache::Msg___delete__", OTHER);

            mozilla::ipc::IPCResult __ok = (static_cast<CacheChild*>(this))->Recv__delete__();
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }


            this->ActorDisconnected(Deletion);

            return MsgProcessed;
        }
    default:
        return MsgNotKnown;
    }
}

auto PCacheChild::OnMessageReceived(
        const Message& msg__,
        UniquePtr<Message>& reply__) -> PCacheChild::Result
{
    return MsgNotKnown;
}



} // namespace cache
} // namespace dom
} // namespace mozilla
namespace IPC {
auto ParamTraits<::mozilla::dom::cache::PCacheChild*>::Write(
        IPC::MessageWriter* aWriter,
        const paramType& aVar) -> void
{
    MOZ_RELEASE_ASSERT(
        aWriter->GetActor(),
        "Cannot serialize managed actors without an actor");

    int32_t id;
    if (!aVar) {
        id = 0;  // kNullActorId
    } else {
        id = aVar->Id();
        if (id == 1) {  // kFreedActorId
            aVar->FatalError("Actor has been |delete|d");
        }
        MOZ_RELEASE_ASSERT(
            aWriter->GetActor()->GetIPCChannel() == aVar->GetIPCChannel(),
            "Actor must be from the same channel as the"
            " actor it's being sent over");
        MOZ_RELEASE_ASSERT(
            aVar->CanSend(),
            "Actor must still be open when sending");
    }

    IPC::WriteParam(aWriter, id);
}

auto ParamTraits<::mozilla::dom::cache::PCacheChild*>::Read(IPC::MessageReader* aReader) -> IPC::ReadResult<paramType>
{
    MOZ_RELEASE_ASSERT(
        aReader->GetActor(),
        "Cannot deserialize managed actors without an actor");
    mozilla::Maybe<mozilla::ipc::IProtocol*> actor = aReader->GetActor()
        ->ReadActor(aReader, true, "PCache", PCacheMsgStart);
    if (actor.isSome()) {
        return static_cast<::mozilla::dom::cache::PCacheChild*>(actor.ref());
    }
    return {};
}

} // namespace IPC
