//
// Automatically generated by ipdlc.
// Edit at your own risk
//


#include "mozilla/dom/PBroadcastChannelParent.h"
#include "mozilla/GfxMessageUtils.h"
#include "mozilla/ProfilerLabels.h"
#include "mozilla/RemoteLazyInputStream.h"
#include "mozilla/dom/CSPMessageUtils.h"
#include "mozilla/dom/DocShellMessageUtils.h"
#include "mozilla/dom/DomSecurityIPCUtils.h"
#include "mozilla/dom/NavigationAPIIPCUtils.h"
#include "mozilla/dom/PermissionMessageUtils.h"
#include "mozilla/dom/PropertyBagUtils.h"
#include "mozilla/dom/ReferrerInfoUtils.h"
#include "mozilla/dom/SessionHistoryEntry.h"
#include "mozilla/dom/TabMessageUtils.h"
#include "mozilla/dom/notification/IPCUtils.h"
#include "mozilla/ipc/BigBuffer.h"
#include "mozilla/ipc/IPCCore.h"
#include "mozilla/ipc/IPCStreamUtils.h"
#include "mozilla/ipc/SerializedStructuredCloneBuffer.h"
#include "mozilla/ipc/URIUtils.h"
#include "mozilla/layers/LayersMessageUtils.h"
#include "mozilla/net/NeckoMessageUtils.h"
#include "nsIContentSecurityPolicy.h"
#include "nsID.h"
#include "nsIPrincipal.h"
#include "nsIReferrerInfo.h"
#include "nsIURI.h"
#include "nsIVariant.h"

#include "mozilla/ipc/PBackgroundParent.h"

#include "ipc/IPCMessageUtils.h"
#include "ipc/IPCMessageUtilsSpecializations.h"
#include "nsIFile.h"
#include "mozilla/ipc/Endpoint.h"
#include "mozilla/ipc/ProtocolMessageUtils.h"
#include "mozilla/ipc/ProtocolUtils.h"
#include "mozilla/ipc/ShmemMessageUtils.h"
#include "mozilla/ipc/TaintingIPCUtils.h"

namespace mozilla {
namespace dom {


MOZ_IMPLICIT PBroadcastChannelParent::PBroadcastChannelParent() :
    mozilla::ipc::IProtocol(kProtocolId, mozilla::ipc::ParentSide)
{
    MOZ_COUNT_CTOR(PBroadcastChannelParent);
}

PBroadcastChannelParent::~PBroadcastChannelParent()
{
    MOZ_COUNT_DTOR(PBroadcastChannelParent);
}

auto PBroadcastChannelParent::ActorAlloc() -> void
{
}

auto PBroadcastChannelParent::ActorDealloc() -> void
{
    if (Manager()) {
        Manager()->DeallocManagee(kProtocolId, this);
    }
}

auto PBroadcastChannelParent::OtherPid() const -> ::base::ProcessId
{
    ::base::ProcessId pid =
        ::mozilla::ipc::IProtocol::ToplevelProtocol()->OtherPidMaybeInvalid();
    MOZ_RELEASE_ASSERT(pid != ::base::kInvalidProcessId);
    return pid;
}

auto PBroadcastChannelParent::OtherChildID() const -> ::GeckoChildID
{
    ::GeckoChildID childID =
        ::mozilla::ipc::IProtocol::ToplevelProtocol()->OtherChildIDMaybeInvalid();
    MOZ_RELEASE_ASSERT(childID != -1);
    return childID;
}

auto PBroadcastChannelParent::OtherEndpointProcInfo() const -> ::mozilla::ipc::EndpointProcInfo
{
    return ::mozilla::ipc::EndpointProcInfo{OtherPid(), OtherChildID()};
}

auto PBroadcastChannelParent::Manager() const -> PBackgroundParent*
{
    return static_cast<PBackgroundParent*>(IProtocol::Manager());
}

auto PBroadcastChannelParent::ManagedProtocolIds() const -> mozilla::Span<mozilla::ipc::ProtocolId const>
{
    return {};
}

auto PBroadcastChannelParent::GetManagedActors(mozilla::ipc::ProtocolId aProtocol) -> UntypedManagedContainer*
{
    switch (aProtocol) {
    default:
        return nullptr;
    }
}

auto PBroadcastChannelParent::SendNotify(const MessageData& message) -> bool
{
    UniquePtr<IPC::Message> msg__ = PBroadcastChannel::Msg_Notify(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), message);
    // Sentinel = 'message'
    ((&(writer__)))->WriteSentinel(197198566);




    if (mozilla::ipc::LoggingEnabledFor("PBroadcastChannel", mozilla::ipc::ParentSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PBroadcastChannelParent",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PBroadcastChannel::Msg_Notify", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PBroadcastChannelParent::SendRefMessageDelivered(
        const nsID& messageID,
        const uint32_t& actorsOnSamePid) -> bool
{
    UniquePtr<IPC::Message> msg__ = PBroadcastChannel::Msg_RefMessageDelivered(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), messageID);
    // Sentinel = 'messageID'
    ((&(writer__)))->WriteSentinel(308478835);
    IPC::WriteParam((&(writer__)), actorsOnSamePid);
    // Sentinel = 'actorsOnSamePid'
    ((&(writer__)))->WriteSentinel(809567725);




    if (mozilla::ipc::LoggingEnabledFor("PBroadcastChannel", mozilla::ipc::ParentSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PBroadcastChannelParent",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PBroadcastChannel::Msg_RefMessageDelivered", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PBroadcastChannelParent::Send__delete__(PBroadcastChannelParent* actor) -> bool
{
    if (!actor || !actor->CanSend()) {
        NS_WARNING("Attempt to __delete__ missing or closed actor");
        return false;
    }
    UniquePtr<IPC::Message> msg__ = PBroadcastChannel::Msg___delete__((actor)->Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            actor};




    if (mozilla::ipc::LoggingEnabledFor("PBroadcastChannel", mozilla::ipc::ParentSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PBroadcastChannelParent",
            actor->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PBroadcastChannel::Msg___delete__", OTHER);

    bool sendok__ = (actor)->ChannelSend(std::move(msg__));

    actor->ActorDisconnected(Deletion);
    return sendok__;
}

auto PBroadcastChannelParent::DeallocManagee(
        int32_t aProtocolId,
        IProtocol* aListener) -> void
{
    FatalError("unreached");
    return;
}

auto PBroadcastChannelParent::OnMessageReceived(const Message& msg__) -> PBroadcastChannelParent::Result
{
    switch (msg__.type()) {
    case MANAGED_ENDPOINT_BOUND_MESSAGE_TYPE:
        {
            if (!mAwaitingManagedEndpointBind) {
                NS_WARNING("Unexpected managed endpoint lifecycle message after actor bound!");
                return MsgNotAllowed;
            }
            mAwaitingManagedEndpointBind = false;
            return MsgProcessed;
        }
    case MANAGED_ENDPOINT_DROPPED_MESSAGE_TYPE:
        {
            if (!mAwaitingManagedEndpointBind) {
                NS_WARNING("Unexpected managed endpoint lifecycle message after actor bound!");
                return MsgNotAllowed;
            }
            mAwaitingManagedEndpointBind = false;
            this->ActorDisconnected(ManagedEndpointDropped);
            return MsgProcessed;
        }
    case PBroadcastChannel::Msg_PostMessage__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PBroadcastChannel", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PBroadcastChannelParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PBroadcastChannel::Msg_PostMessage", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__message = IPC::ReadParam<MessageData>((&(reader__)));
            if (!maybe__message) {
                FatalError("Error deserializing 'MessageData'");
                return MsgValueError;

            }
            auto& message = *maybe__message;
            // Sentinel = 'message'
            if ((!(((&(reader__)))->ReadSentinel(197198566)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'MessageData'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::IPCResult __ok = (this)->RecvPostMessage(std::move(message));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PBroadcastChannel::Msg_Close__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PBroadcastChannel", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PBroadcastChannelParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PBroadcastChannel::Msg_Close", OTHER);

            mozilla::ipc::IPCResult __ok = (this)->RecvClose();
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PBroadcastChannel::Reply___delete____ID:
        {
            return MsgProcessed;
        }
    default:
        return MsgNotKnown;
    }
}

auto PBroadcastChannelParent::OnMessageReceived(
        const Message& msg__,
        UniquePtr<Message>& reply__) -> PBroadcastChannelParent::Result
{
    return MsgNotKnown;
}



} // namespace dom
} // namespace mozilla
namespace IPC {
auto ParamTraits<::mozilla::dom::PBroadcastChannelParent*>::Write(
        IPC::MessageWriter* aWriter,
        const paramType& aVar) -> void
{
    MOZ_RELEASE_ASSERT(
        aWriter->GetActor(),
        "Cannot serialize managed actors without an actor");

    int32_t id;
    if (!aVar) {
        id = 0;  // kNullActorId
    } else {
        id = aVar->Id();
        if (id == 1) {  // kFreedActorId
            aVar->FatalError("Actor has been |delete|d");
        }
        MOZ_RELEASE_ASSERT(
            aWriter->GetActor()->GetIPCChannel() == aVar->GetIPCChannel(),
            "Actor must be from the same channel as the"
            " actor it's being sent over");
        MOZ_RELEASE_ASSERT(
            aVar->CanSend(),
            "Actor must still be open when sending");
    }

    IPC::WriteParam(aWriter, id);
}

auto ParamTraits<::mozilla::dom::PBroadcastChannelParent*>::Read(IPC::MessageReader* aReader) -> IPC::ReadResult<paramType>
{
    MOZ_RELEASE_ASSERT(
        aReader->GetActor(),
        "Cannot deserialize managed actors without an actor");
    mozilla::Maybe<mozilla::ipc::IProtocol*> actor = aReader->GetActor()
        ->ReadActor(aReader, true, "PBroadcastChannel", PBroadcastChannelMsgStart);
    if (actor.isSome()) {
        return static_cast<::mozilla::dom::PBroadcastChannelParent*>(actor.ref());
    }
    return {};
}

} // namespace IPC
