//
// Automatically generated by ipdlc.
// Edit at your own risk
//


#include "mozilla/dom/PBroadcastChannelChild.h"
#include "mozilla/GfxMessageUtils.h"
#include "mozilla/ProfilerLabels.h"
#include "mozilla/RemoteLazyInputStream.h"
#include "mozilla/dom/CSPMessageUtils.h"
#include "mozilla/dom/DocShellMessageUtils.h"
#include "mozilla/dom/DomSecurityIPCUtils.h"
#include "mozilla/dom/NavigationAPIIPCUtils.h"
#include "mozilla/dom/PermissionMessageUtils.h"
#include "mozilla/dom/PropertyBagUtils.h"
#include "mozilla/dom/ReferrerInfoUtils.h"
#include "mozilla/dom/SessionHistoryEntry.h"
#include "mozilla/dom/TabMessageUtils.h"
#include "mozilla/dom/notification/IPCUtils.h"
#include "mozilla/ipc/BigBuffer.h"
#include "mozilla/ipc/IPCCore.h"
#include "mozilla/ipc/IPCStreamUtils.h"
#include "mozilla/ipc/SerializedStructuredCloneBuffer.h"
#include "mozilla/ipc/URIUtils.h"
#include "mozilla/layers/LayersMessageUtils.h"
#include "mozilla/net/NeckoMessageUtils.h"
#include "nsIContentSecurityPolicy.h"
#include "nsID.h"
#include "nsIPrincipal.h"
#include "nsIReferrerInfo.h"
#include "nsIURI.h"
#include "nsIVariant.h"

#include "mozilla/ipc/PBackgroundChild.h"

#include "ipc/IPCMessageUtils.h"
#include "ipc/IPCMessageUtilsSpecializations.h"
#include "nsIFile.h"
#include "mozilla/ipc/Endpoint.h"
#include "mozilla/ipc/ProtocolMessageUtils.h"
#include "mozilla/ipc/ProtocolUtils.h"
#include "mozilla/ipc/ShmemMessageUtils.h"
#include "mozilla/ipc/TaintingIPCUtils.h"

namespace mozilla {
namespace dom {


auto PBroadcastChannelChild::Recv__delete__() -> mozilla::ipc::IPCResult
{
    return IPC_OK();
}

MOZ_IMPLICIT PBroadcastChannelChild::PBroadcastChannelChild() :
    mozilla::ipc::IProtocol(kProtocolId, mozilla::ipc::ChildSide)
{
    MOZ_COUNT_CTOR(PBroadcastChannelChild);
}

PBroadcastChannelChild::~PBroadcastChannelChild()
{
    MOZ_COUNT_DTOR(PBroadcastChannelChild);
}

auto PBroadcastChannelChild::ActorAlloc() -> void
{
}

auto PBroadcastChannelChild::ActorDealloc() -> void
{
    if (Manager()) {
        Manager()->DeallocManagee(kProtocolId, this);
    }
}

auto PBroadcastChannelChild::OtherPid() const -> ::base::ProcessId
{
    ::base::ProcessId pid =
        ::mozilla::ipc::IProtocol::ToplevelProtocol()->OtherPidMaybeInvalid();
    MOZ_RELEASE_ASSERT(pid != ::base::kInvalidProcessId);
    return pid;
}

auto PBroadcastChannelChild::OtherChildID() const -> ::GeckoChildID
{
    ::GeckoChildID childID =
        ::mozilla::ipc::IProtocol::ToplevelProtocol()->OtherChildIDMaybeInvalid();
    MOZ_RELEASE_ASSERT(childID != -1);
    return childID;
}

auto PBroadcastChannelChild::OtherEndpointProcInfo() const -> ::mozilla::ipc::EndpointProcInfo
{
    return ::mozilla::ipc::EndpointProcInfo{OtherPid(), OtherChildID()};
}

auto PBroadcastChannelChild::Manager() const -> PBackgroundChild*
{
    return static_cast<PBackgroundChild*>(IProtocol::Manager());
}

auto PBroadcastChannelChild::ManagedProtocolIds() const -> mozilla::Span<mozilla::ipc::ProtocolId const>
{
    return {};
}

auto PBroadcastChannelChild::GetManagedActors(mozilla::ipc::ProtocolId aProtocol) -> UntypedManagedContainer*
{
    switch (aProtocol) {
    default:
        return nullptr;
    }
}

auto PBroadcastChannelChild::SendPostMessage(const MessageData& message) -> bool
{
    UniquePtr<IPC::Message> msg__ = PBroadcastChannel::Msg_PostMessage(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), message);
    // Sentinel = 'message'
    ((&(writer__)))->WriteSentinel(197198566);




    if (mozilla::ipc::LoggingEnabledFor("PBroadcastChannel", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PBroadcastChannelChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PBroadcastChannel::Msg_PostMessage", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PBroadcastChannelChild::SendClose() -> bool
{
    UniquePtr<IPC::Message> msg__ = PBroadcastChannel::Msg_Close(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};





    if (mozilla::ipc::LoggingEnabledFor("PBroadcastChannel", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PBroadcastChannelChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PBroadcastChannel::Msg_Close", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PBroadcastChannelChild::DeallocManagee(
        int32_t aProtocolId,
        IProtocol* aListener) -> void
{
    FatalError("unreached");
    return;
}

auto PBroadcastChannelChild::OnMessageReceived(const Message& msg__) -> PBroadcastChannelChild::Result
{
    switch (msg__.type()) {
    case MANAGED_ENDPOINT_BOUND_MESSAGE_TYPE:
        {
            if (!mAwaitingManagedEndpointBind) {
                NS_WARNING("Unexpected managed endpoint lifecycle message after actor bound!");
                return MsgNotAllowed;
            }
            mAwaitingManagedEndpointBind = false;
            return MsgProcessed;
        }
    case MANAGED_ENDPOINT_DROPPED_MESSAGE_TYPE:
        {
            if (!mAwaitingManagedEndpointBind) {
                NS_WARNING("Unexpected managed endpoint lifecycle message after actor bound!");
                return MsgNotAllowed;
            }
            mAwaitingManagedEndpointBind = false;
            this->ActorDisconnected(ManagedEndpointDropped);
            return MsgProcessed;
        }
    case PBroadcastChannel::Msg_Notify__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PBroadcastChannel", mozilla::ipc::ChildSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PBroadcastChannelChild",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PBroadcastChannel::Msg_Notify", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__message = IPC::ReadParam<MessageData>((&(reader__)));
            if (!maybe__message) {
                FatalError("Error deserializing 'MessageData'");
                return MsgValueError;

            }
            auto& message = *maybe__message;
            // Sentinel = 'message'
            if ((!(((&(reader__)))->ReadSentinel(197198566)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'MessageData'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::IPCResult __ok = (this)->RecvNotify(std::move(message));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PBroadcastChannel::Msg_RefMessageDelivered__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PBroadcastChannel", mozilla::ipc::ChildSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PBroadcastChannelChild",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PBroadcastChannel::Msg_RefMessageDelivered", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__messageID = IPC::ReadParam<nsID>((&(reader__)));
            if (!maybe__messageID) {
                FatalError("Error deserializing 'nsID'");
                return MsgValueError;

            }
            auto& messageID = *maybe__messageID;
            // Sentinel = 'messageID'
            if ((!(((&(reader__)))->ReadSentinel(308478835)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'nsID'");
                return MsgValueError;
            }
            auto maybe__actorsOnSamePid = IPC::ReadParam<uint32_t>((&(reader__)));
            if (!maybe__actorsOnSamePid) {
                FatalError("Error deserializing 'uint32_t'");
                return MsgValueError;

            }
            auto& actorsOnSamePid = *maybe__actorsOnSamePid;
            // Sentinel = 'actorsOnSamePid'
            if ((!(((&(reader__)))->ReadSentinel(809567725)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'uint32_t'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::IPCResult __ok = (this)->RecvRefMessageDelivered(std::move(messageID), std::move(actorsOnSamePid));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PBroadcastChannel::Msg___delete____ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PBroadcastChannel", mozilla::ipc::ChildSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PBroadcastChannelChild",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PBroadcastChannel::Msg___delete__", OTHER);

            mozilla::ipc::IPCResult __ok = (this)->Recv__delete__();
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }


            this->ActorDisconnected(Deletion);

            return MsgProcessed;
        }
    default:
        return MsgNotKnown;
    }
}

auto PBroadcastChannelChild::OnMessageReceived(
        const Message& msg__,
        UniquePtr<Message>& reply__) -> PBroadcastChannelChild::Result
{
    return MsgNotKnown;
}



} // namespace dom
} // namespace mozilla
namespace IPC {
auto ParamTraits<::mozilla::dom::PBroadcastChannelChild*>::Write(
        IPC::MessageWriter* aWriter,
        const paramType& aVar) -> void
{
    MOZ_RELEASE_ASSERT(
        aWriter->GetActor(),
        "Cannot serialize managed actors without an actor");

    int32_t id;
    if (!aVar) {
        id = 0;  // kNullActorId
    } else {
        id = aVar->Id();
        if (id == 1) {  // kFreedActorId
            aVar->FatalError("Actor has been |delete|d");
        }
        MOZ_RELEASE_ASSERT(
            aWriter->GetActor()->GetIPCChannel() == aVar->GetIPCChannel(),
            "Actor must be from the same channel as the"
            " actor it's being sent over");
        MOZ_RELEASE_ASSERT(
            aVar->CanSend(),
            "Actor must still be open when sending");
    }

    IPC::WriteParam(aWriter, id);
}

auto ParamTraits<::mozilla::dom::PBroadcastChannelChild*>::Read(IPC::MessageReader* aReader) -> IPC::ReadResult<paramType>
{
    MOZ_RELEASE_ASSERT(
        aReader->GetActor(),
        "Cannot deserialize managed actors without an actor");
    mozilla::Maybe<mozilla::ipc::IProtocol*> actor = aReader->GetActor()
        ->ReadActor(aReader, true, "PBroadcastChannel", PBroadcastChannelMsgStart);
    if (actor.isSome()) {
        return static_cast<::mozilla::dom::PBroadcastChannelChild*>(actor.ref());
    }
    return {};
}

} // namespace IPC
