//
// Automatically generated by ipdlc.
// Edit at your own risk
//


#include "mozilla/PBenchmarkStorageChild.h"
#include "mozilla/BenchmarkStorageChild.h"
#include "mozilla/ProfilerLabels.h"

#include "mozilla/dom/PContentChild.h"

#include "ipc/IPCMessageUtils.h"
#include "ipc/IPCMessageUtilsSpecializations.h"
#include "nsIFile.h"
#include "mozilla/ipc/Endpoint.h"
#include "mozilla/ipc/ProtocolMessageUtils.h"
#include "mozilla/ipc/ProtocolUtils.h"
#include "mozilla/ipc/ShmemMessageUtils.h"
#include "mozilla/ipc/TaintingIPCUtils.h"

namespace mozilla {


MOZ_IMPLICIT PBenchmarkStorageChild::PBenchmarkStorageChild() :
    mozilla::ipc::IProtocol(kProtocolId, mozilla::ipc::ChildSide)
{
    MOZ_COUNT_CTOR(PBenchmarkStorageChild);
}

PBenchmarkStorageChild::~PBenchmarkStorageChild()
{
    MOZ_COUNT_DTOR(PBenchmarkStorageChild);
}

auto PBenchmarkStorageChild::ActorAlloc() -> void
{
}

auto PBenchmarkStorageChild::ActorDealloc() -> void
{
    if (Manager()) {
        Manager()->DeallocManagee(kProtocolId, this);
    }
}

auto PBenchmarkStorageChild::OtherPid() const -> ::base::ProcessId
{
    ::base::ProcessId pid =
        ::mozilla::ipc::IProtocol::ToplevelProtocol()->OtherPidMaybeInvalid();
    MOZ_RELEASE_ASSERT(pid != ::base::kInvalidProcessId);
    return pid;
}

auto PBenchmarkStorageChild::OtherChildID() const -> ::GeckoChildID
{
    ::GeckoChildID childID =
        ::mozilla::ipc::IProtocol::ToplevelProtocol()->OtherChildIDMaybeInvalid();
    MOZ_RELEASE_ASSERT(childID != -1);
    return childID;
}

auto PBenchmarkStorageChild::OtherEndpointProcInfo() const -> ::mozilla::ipc::EndpointProcInfo
{
    return ::mozilla::ipc::EndpointProcInfo{OtherPid(), OtherChildID()};
}

auto PBenchmarkStorageChild::Manager() const -> PContentChild*
{
    return static_cast<PContentChild*>(IProtocol::Manager());
}

auto PBenchmarkStorageChild::ManagedProtocolIds() const -> mozilla::Span<mozilla::ipc::ProtocolId const>
{
    return {};
}

auto PBenchmarkStorageChild::GetManagedActors(mozilla::ipc::ProtocolId aProtocol) -> UntypedManagedContainer*
{
    switch (aProtocol) {
    default:
        return nullptr;
    }
}

auto PBenchmarkStorageChild::RejectPendingResponses(ResponseRejectReason aReason) -> void
{
    mAsyncCallbacks.RejectPendingResponses(aReason);
}

auto PBenchmarkStorageChild::SendPut(
        const nsACString& aDbName,
        const nsACString& aKey,
        const int32_t& aValue) -> bool
{
    UniquePtr<IPC::Message> msg__ = PBenchmarkStorage::Msg_Put(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), aDbName);
    // Sentinel = 'aDbName'
    ((&(writer__)))->WriteSentinel(164233865);
    IPC::WriteParam((&(writer__)), aKey);
    // Sentinel = 'aKey'
    ((&(writer__)))->WriteSentinel(61604235);
    IPC::WriteParam((&(writer__)), aValue);
    // Sentinel = 'aValue'
    ((&(writer__)))->WriteSentinel(135332447);




    if (mozilla::ipc::LoggingEnabledFor("PBenchmarkStorage", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PBenchmarkStorageChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PBenchmarkStorage::Msg_Put", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PBenchmarkStorageChild::SendGet(
        const nsACString& aDbName,
        const nsACString& aKey,
        mozilla::ipc::ResolveCallback<int32_t>&& aResolve,
        mozilla::ipc::RejectCallback&& aReject) -> void
{
    UniquePtr<IPC::Message> msg__ = PBenchmarkStorage::Msg_Get(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), aDbName);
    // Sentinel = 'aDbName'
    ((&(writer__)))->WriteSentinel(164233865);
    IPC::WriteParam((&(writer__)), aKey);
    // Sentinel = 'aKey'
    ((&(writer__)))->WriteSentinel(61604235);




    if (mozilla::ipc::LoggingEnabledFor("PBenchmarkStorage", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PBenchmarkStorageChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PBenchmarkStorage::Msg_Get", OTHER);

    int32_t seqno__ = 0;
    if (ChannelSend(std::move(msg__), (&(seqno__)))) {
        mAsyncCallbacks.AddCallback(seqno__, PBenchmarkStorage::Reply_Get__ID, [resolve=std::move(aResolve)](IPC::MessageReader* aReader) mutable {
            auto maybe__aValue = IPC::ReadParam<int32_t>(aReader);
            if (!maybe__aValue) {
                (aReader)->FatalError("Error deserializing 'int32_t'");
                return MsgValueError;

            }
            auto& aValue = *maybe__aValue;
            // Sentinel = 'aValue'
            if ((!((aReader)->ReadSentinel(135332447)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'int32_t'");
                return MsgValueError;
            }


            aReader->EndRead();

            resolve(std::move(aValue));
            return MsgProcessed;
        }, std::move(aReject));
    }
    else {
        aReject(::mozilla::ipc::ResponseRejectReason::SendError);
    }
    return;
}

auto PBenchmarkStorageChild::SendGet(
        const nsACString& aDbName,
        const nsACString& aKey) -> RefPtr<GetPromise>
{
    RefPtr<MozPromise<int32_t, ResponseRejectReason, true>::Private> promise__ = new MozPromise<int32_t, ResponseRejectReason, true>::Private(__func__);
    promise__->UseDirectTaskDispatch(__func__);
    SendGet(std::move(aDbName), std::move(aKey), [promise__](int32_t&& aValue) {
        promise__->Resolve(std::move(aValue), __func__);
    }, [promise__](ResponseRejectReason&& aReason) {
        promise__->Reject(std::move(aReason), __func__);
    });
    return promise__;
}

auto PBenchmarkStorageChild::SendCheckVersion(
        const nsACString& aDbName,
        const int32_t& aVersion) -> bool
{
    UniquePtr<IPC::Message> msg__ = PBenchmarkStorage::Msg_CheckVersion(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), aDbName);
    // Sentinel = 'aDbName'
    ((&(writer__)))->WriteSentinel(164233865);
    IPC::WriteParam((&(writer__)), aVersion);
    // Sentinel = 'aVersion'
    ((&(writer__)))->WriteSentinel(240452424);




    if (mozilla::ipc::LoggingEnabledFor("PBenchmarkStorage", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PBenchmarkStorageChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PBenchmarkStorage::Msg_CheckVersion", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PBenchmarkStorageChild::Send__delete__(PBenchmarkStorageChild* actor) -> bool
{
    if (!actor || !actor->CanSend()) {
        NS_WARNING("Attempt to __delete__ missing or closed actor");
        return false;
    }
    UniquePtr<IPC::Message> msg__ = PBenchmarkStorage::Msg___delete__((actor)->Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            actor};




    if (mozilla::ipc::LoggingEnabledFor("PBenchmarkStorage", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PBenchmarkStorageChild",
            actor->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PBenchmarkStorage::Msg___delete__", OTHER);

    bool sendok__ = (actor)->ChannelSend(std::move(msg__));

    actor->ActorDisconnected(Deletion);
    return sendok__;
}

auto PBenchmarkStorageChild::DeallocManagee(
        int32_t aProtocolId,
        IProtocol* aListener) -> void
{
    FatalError("unreached");
    return;
}

auto PBenchmarkStorageChild::OnMessageReceived(const Message& msg__) -> PBenchmarkStorageChild::Result
{
    switch (msg__.type()) {
    case MANAGED_ENDPOINT_BOUND_MESSAGE_TYPE:
        {
            if (!mAwaitingManagedEndpointBind) {
                NS_WARNING("Unexpected managed endpoint lifecycle message after actor bound!");
                return MsgNotAllowed;
            }
            mAwaitingManagedEndpointBind = false;
            return MsgProcessed;
        }
    case MANAGED_ENDPOINT_DROPPED_MESSAGE_TYPE:
        {
            if (!mAwaitingManagedEndpointBind) {
                NS_WARNING("Unexpected managed endpoint lifecycle message after actor bound!");
                return MsgNotAllowed;
            }
            mAwaitingManagedEndpointBind = false;
            this->ActorDisconnected(ManagedEndpointDropped);
            return MsgProcessed;
        }
    case PBenchmarkStorage::Reply_Get__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PBenchmarkStorage", mozilla::ipc::ChildSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PBenchmarkStorageChild",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }

            AUTO_PROFILER_LABEL("PBenchmarkStorage::Msg_Get", OTHER);


            return mAsyncCallbacks.GotReply(this, msg__);
        }
    case PBenchmarkStorage::Reply___delete____ID:
        {
            return MsgProcessed;
        }
    default:
        return MsgNotKnown;
    }
}

auto PBenchmarkStorageChild::OnMessageReceived(
        const Message& msg__,
        UniquePtr<Message>& reply__) -> PBenchmarkStorageChild::Result
{
    return MsgNotKnown;
}



} // namespace mozilla
namespace IPC {
auto ParamTraits<::mozilla::PBenchmarkStorageChild*>::Write(
        IPC::MessageWriter* aWriter,
        const paramType& aVar) -> void
{
    MOZ_RELEASE_ASSERT(
        aWriter->GetActor(),
        "Cannot serialize managed actors without an actor");

    int32_t id;
    if (!aVar) {
        id = 0;  // kNullActorId
    } else {
        id = aVar->Id();
        if (id == 1) {  // kFreedActorId
            aVar->FatalError("Actor has been |delete|d");
        }
        MOZ_RELEASE_ASSERT(
            aWriter->GetActor()->GetIPCChannel() == aVar->GetIPCChannel(),
            "Actor must be from the same channel as the"
            " actor it's being sent over");
        MOZ_RELEASE_ASSERT(
            aVar->CanSend(),
            "Actor must still be open when sending");
    }

    IPC::WriteParam(aWriter, id);
}

auto ParamTraits<::mozilla::PBenchmarkStorageChild*>::Read(IPC::MessageReader* aReader) -> IPC::ReadResult<paramType>
{
    MOZ_RELEASE_ASSERT(
        aReader->GetActor(),
        "Cannot deserialize managed actors without an actor");
    mozilla::Maybe<mozilla::ipc::IProtocol*> actor = aReader->GetActor()
        ->ReadActor(aReader, true, "PBenchmarkStorage", PBenchmarkStorageMsgStart);
    if (actor.isSome()) {
        return static_cast<::mozilla::PBenchmarkStorageChild*>(actor.ref());
    }
    return {};
}

} // namespace IPC
