//
// Automatically generated by ipdlc.
// Edit at your own risk
//


#include "mozilla/ipc/PBackgroundTestChild.h"
#include "mozilla/ProfilerLabels.h"

#include "mozilla/ipc/PBackgroundChild.h"

#include "ipc/IPCMessageUtils.h"
#include "ipc/IPCMessageUtilsSpecializations.h"
#include "nsIFile.h"
#include "mozilla/ipc/Endpoint.h"
#include "mozilla/ipc/ProtocolMessageUtils.h"
#include "mozilla/ipc/ProtocolUtils.h"
#include "mozilla/ipc/ShmemMessageUtils.h"
#include "mozilla/ipc/TaintingIPCUtils.h"

namespace mozilla {
namespace ipc {


MOZ_IMPLICIT PBackgroundTestChild::PBackgroundTestChild() :
    mozilla::ipc::IProtocol(kProtocolId, mozilla::ipc::ChildSide)
{
    MOZ_COUNT_CTOR(PBackgroundTestChild);
}

PBackgroundTestChild::~PBackgroundTestChild()
{
    MOZ_COUNT_DTOR(PBackgroundTestChild);
}

auto PBackgroundTestChild::ActorAlloc() -> void
{
}

auto PBackgroundTestChild::ActorDealloc() -> void
{
    if (Manager()) {
        Manager()->DeallocManagee(kProtocolId, this);
    }
}

auto PBackgroundTestChild::OtherPid() const -> ::base::ProcessId
{
    ::base::ProcessId pid =
        ::mozilla::ipc::IProtocol::ToplevelProtocol()->OtherPidMaybeInvalid();
    MOZ_RELEASE_ASSERT(pid != ::base::kInvalidProcessId);
    return pid;
}

auto PBackgroundTestChild::OtherChildID() const -> ::GeckoChildID
{
    ::GeckoChildID childID =
        ::mozilla::ipc::IProtocol::ToplevelProtocol()->OtherChildIDMaybeInvalid();
    MOZ_RELEASE_ASSERT(childID != -1);
    return childID;
}

auto PBackgroundTestChild::OtherEndpointProcInfo() const -> ::mozilla::ipc::EndpointProcInfo
{
    return ::mozilla::ipc::EndpointProcInfo{OtherPid(), OtherChildID()};
}

auto PBackgroundTestChild::Manager() const -> PBackgroundChild*
{
    return static_cast<PBackgroundChild*>(IProtocol::Manager());
}

auto PBackgroundTestChild::ManagedProtocolIds() const -> mozilla::Span<mozilla::ipc::ProtocolId const>
{
    return {};
}

auto PBackgroundTestChild::GetManagedActors(mozilla::ipc::ProtocolId aProtocol) -> UntypedManagedContainer*
{
    switch (aProtocol) {
    default:
        return nullptr;
    }
}

auto PBackgroundTestChild::DeallocManagee(
        int32_t aProtocolId,
        IProtocol* aListener) -> void
{
    FatalError("unreached");
    return;
}

auto PBackgroundTestChild::OnMessageReceived(const Message& msg__) -> PBackgroundTestChild::Result
{
    switch (msg__.type()) {
    case MANAGED_ENDPOINT_BOUND_MESSAGE_TYPE:
        {
            if (!mAwaitingManagedEndpointBind) {
                NS_WARNING("Unexpected managed endpoint lifecycle message after actor bound!");
                return MsgNotAllowed;
            }
            mAwaitingManagedEndpointBind = false;
            return MsgProcessed;
        }
    case MANAGED_ENDPOINT_DROPPED_MESSAGE_TYPE:
        {
            if (!mAwaitingManagedEndpointBind) {
                NS_WARNING("Unexpected managed endpoint lifecycle message after actor bound!");
                return MsgNotAllowed;
            }
            mAwaitingManagedEndpointBind = false;
            this->ActorDisconnected(ManagedEndpointDropped);
            return MsgProcessed;
        }
    case PBackgroundTest::Msg___delete____ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PBackgroundTest", mozilla::ipc::ChildSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PBackgroundTestChild",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PBackgroundTest::Msg___delete__", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__testArg = IPC::ReadParam<nsCString>((&(reader__)));
            if (!maybe__testArg) {
                FatalError("Error deserializing 'nsCString'");
                return MsgValueError;

            }
            auto& testArg = *maybe__testArg;
            // Sentinel = 'testArg'
            if ((!(((&(reader__)))->ReadSentinel(195953371)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'nsCString'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::IPCResult __ok = (this)->Recv__delete__(std::move(testArg));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }


            this->ActorDisconnected(Deletion);

            return MsgProcessed;
        }
    default:
        return MsgNotKnown;
    }
}

auto PBackgroundTestChild::OnMessageReceived(
        const Message& msg__,
        UniquePtr<Message>& reply__) -> PBackgroundTestChild::Result
{
    return MsgNotKnown;
}



} // namespace ipc
} // namespace mozilla
namespace IPC {
auto ParamTraits<::mozilla::ipc::PBackgroundTestChild*>::Write(
        IPC::MessageWriter* aWriter,
        const paramType& aVar) -> void
{
    MOZ_RELEASE_ASSERT(
        aWriter->GetActor(),
        "Cannot serialize managed actors without an actor");

    int32_t id;
    if (!aVar) {
        id = 0;  // kNullActorId
    } else {
        id = aVar->Id();
        if (id == 1) {  // kFreedActorId
            aVar->FatalError("Actor has been |delete|d");
        }
        MOZ_RELEASE_ASSERT(
            aWriter->GetActor()->GetIPCChannel() == aVar->GetIPCChannel(),
            "Actor must be from the same channel as the"
            " actor it's being sent over");
        MOZ_RELEASE_ASSERT(
            aVar->CanSend(),
            "Actor must still be open when sending");
    }

    IPC::WriteParam(aWriter, id);
}

auto ParamTraits<::mozilla::ipc::PBackgroundTestChild*>::Read(IPC::MessageReader* aReader) -> IPC::ReadResult<paramType>
{
    MOZ_RELEASE_ASSERT(
        aReader->GetActor(),
        "Cannot deserialize managed actors without an actor");
    mozilla::Maybe<mozilla::ipc::IProtocol*> actor = aReader->GetActor()
        ->ReadActor(aReader, true, "PBackgroundTest", PBackgroundTestMsgStart);
    if (actor.isSome()) {
        return static_cast<::mozilla::ipc::PBackgroundTestChild*>(actor.ref());
    }
    return {};
}

} // namespace IPC
