//
// Automatically generated by ipdlc.
// Edit at your own risk
//


#include "mozilla/dom/PBackgroundStorageParent.h"
#include "mozilla/ProfilerLabels.h"
#include "mozilla/dom/quota/SerializationHelpers.h"

#include "mozilla/ipc/PBackgroundParent.h"

#include "ipc/IPCMessageUtils.h"
#include "ipc/IPCMessageUtilsSpecializations.h"
#include "nsIFile.h"
#include "mozilla/ipc/Endpoint.h"
#include "mozilla/ipc/ProtocolMessageUtils.h"
#include "mozilla/ipc/ProtocolUtils.h"
#include "mozilla/ipc/ShmemMessageUtils.h"
#include "mozilla/ipc/TaintingIPCUtils.h"

namespace mozilla {
namespace dom {


MOZ_IMPLICIT PBackgroundStorageParent::PBackgroundStorageParent() :
    mozilla::ipc::IProtocol(kProtocolId, mozilla::ipc::ParentSide)
{
    MOZ_COUNT_CTOR(PBackgroundStorageParent);
}

PBackgroundStorageParent::~PBackgroundStorageParent()
{
    MOZ_COUNT_DTOR(PBackgroundStorageParent);
}

auto PBackgroundStorageParent::ActorAlloc() -> void
{
}

auto PBackgroundStorageParent::ActorDealloc() -> void
{
    if (Manager()) {
        Manager()->DeallocManagee(kProtocolId, this);
    }
}

auto PBackgroundStorageParent::OtherPid() const -> ::base::ProcessId
{
    ::base::ProcessId pid =
        ::mozilla::ipc::IProtocol::ToplevelProtocol()->OtherPidMaybeInvalid();
    MOZ_RELEASE_ASSERT(pid != ::base::kInvalidProcessId);
    return pid;
}

auto PBackgroundStorageParent::OtherChildID() const -> ::GeckoChildID
{
    ::GeckoChildID childID =
        ::mozilla::ipc::IProtocol::ToplevelProtocol()->OtherChildIDMaybeInvalid();
    MOZ_RELEASE_ASSERT(childID != -1);
    return childID;
}

auto PBackgroundStorageParent::OtherEndpointProcInfo() const -> ::mozilla::ipc::EndpointProcInfo
{
    return ::mozilla::ipc::EndpointProcInfo{OtherPid(), OtherChildID()};
}

auto PBackgroundStorageParent::Manager() const -> PBackgroundParent*
{
    return static_cast<PBackgroundParent*>(IProtocol::Manager());
}

auto PBackgroundStorageParent::ManagedProtocolIds() const -> mozilla::Span<mozilla::ipc::ProtocolId const>
{
    return {};
}

auto PBackgroundStorageParent::GetManagedActors(mozilla::ipc::ProtocolId aProtocol) -> UntypedManagedContainer*
{
    switch (aProtocol) {
    default:
        return nullptr;
    }
}

auto PBackgroundStorageParent::Send__delete__(PBackgroundStorageParent* actor) -> bool
{
    if (!actor || !actor->CanSend()) {
        NS_WARNING("Attempt to __delete__ missing or closed actor");
        return false;
    }
    UniquePtr<IPC::Message> msg__ = PBackgroundStorage::Msg___delete__((actor)->Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            actor};




    if (mozilla::ipc::LoggingEnabledFor("PBackgroundStorage", mozilla::ipc::ParentSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PBackgroundStorageParent",
            actor->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PBackgroundStorage::Msg___delete__", OTHER);

    bool sendok__ = (actor)->ChannelSend(std::move(msg__));

    actor->ActorDisconnected(Deletion);
    return sendok__;
}

auto PBackgroundStorageParent::SendObserve(
        const nsACString& topic,
        const nsAString& originAttributesPattern,
        const nsACString& originScope) -> bool
{
    UniquePtr<IPC::Message> msg__ = PBackgroundStorage::Msg_Observe(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), topic);
    // Sentinel = 'topic'
    ((&(writer__)))->WriteSentinel(109707808);
    IPC::WriteParam((&(writer__)), originAttributesPattern);
    // Sentinel = 'originAttributesPattern'
    ((&(writer__)))->WriteSentinel(1917913486);
    IPC::WriteParam((&(writer__)), originScope);
    // Sentinel = 'originScope'
    ((&(writer__)))->WriteSentinel(459080835);




    if (mozilla::ipc::LoggingEnabledFor("PBackgroundStorage", mozilla::ipc::ParentSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PBackgroundStorageParent",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PBackgroundStorage::Msg_Observe", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PBackgroundStorageParent::SendOriginsHavingData(mozilla::Span<nsCString const> origins) -> bool
{
    UniquePtr<IPC::Message> msg__ = PBackgroundStorage::Msg_OriginsHavingData(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), origins);
    // Sentinel = 'origins'
    ((&(writer__)))->WriteSentinel(200213244);




    if (mozilla::ipc::LoggingEnabledFor("PBackgroundStorage", mozilla::ipc::ParentSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PBackgroundStorageParent",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PBackgroundStorage::Msg_OriginsHavingData", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PBackgroundStorageParent::SendLoadItem(
        const nsACString& originSuffix,
        const nsACString& originNoSuffix,
        const nsAString& key,
        const nsAString& value) -> bool
{
    UniquePtr<IPC::Message> msg__ = PBackgroundStorage::Msg_LoadItem(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), originSuffix);
    // Sentinel = 'originSuffix'
    ((&(writer__)))->WriteSentinel(544736510);
    IPC::WriteParam((&(writer__)), originNoSuffix);
    // Sentinel = 'originNoSuffix'
    ((&(writer__)))->WriteSentinel(721618363);
    IPC::WriteParam((&(writer__)), key);
    // Sentinel = 'key'
    ((&(writer__)))->WriteSentinel(42402122);
    IPC::WriteParam((&(writer__)), value);
    // Sentinel = 'value'
    ((&(writer__)))->WriteSentinel(107610654);




    if (mozilla::ipc::LoggingEnabledFor("PBackgroundStorage", mozilla::ipc::ParentSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PBackgroundStorageParent",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PBackgroundStorage::Msg_LoadItem", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PBackgroundStorageParent::SendLoadDone(
        const nsACString& originSuffix,
        const nsACString& originNoSuffix,
        const nsresult& rv) -> bool
{
    UniquePtr<IPC::Message> msg__ = PBackgroundStorage::Msg_LoadDone(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), originSuffix);
    // Sentinel = 'originSuffix'
    ((&(writer__)))->WriteSentinel(544736510);
    IPC::WriteParam((&(writer__)), originNoSuffix);
    // Sentinel = 'originNoSuffix'
    ((&(writer__)))->WriteSentinel(721618363);
    IPC::WriteParam((&(writer__)), rv);
    // Sentinel = 'rv'
    ((&(writer__)))->WriteSentinel(22806761);




    if (mozilla::ipc::LoggingEnabledFor("PBackgroundStorage", mozilla::ipc::ParentSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PBackgroundStorageParent",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PBackgroundStorage::Msg_LoadDone", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PBackgroundStorageParent::SendLoadUsage(
        const nsACString& scope,
        const int64_t& usage) -> bool
{
    UniquePtr<IPC::Message> msg__ = PBackgroundStorage::Msg_LoadUsage(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), scope);
    // Sentinel = 'scope'
    ((&(writer__)))->WriteSentinel(107086363);
    IPC::WriteParam((&(writer__)), usage);
    // Sentinel = 'usage'
    ((&(writer__)))->WriteSentinel(108003862);




    if (mozilla::ipc::LoggingEnabledFor("PBackgroundStorage", mozilla::ipc::ParentSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PBackgroundStorageParent",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PBackgroundStorage::Msg_LoadUsage", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PBackgroundStorageParent::SendError(const nsresult& rv) -> bool
{
    UniquePtr<IPC::Message> msg__ = PBackgroundStorage::Msg_Error(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), rv);
    // Sentinel = 'rv'
    ((&(writer__)))->WriteSentinel(22806761);




    if (mozilla::ipc::LoggingEnabledFor("PBackgroundStorage", mozilla::ipc::ParentSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PBackgroundStorageParent",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PBackgroundStorage::Msg_Error", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PBackgroundStorageParent::DeallocManagee(
        int32_t aProtocolId,
        IProtocol* aListener) -> void
{
    FatalError("unreached");
    return;
}

auto PBackgroundStorageParent::OnMessageReceived(const Message& msg__) -> PBackgroundStorageParent::Result
{
    switch (msg__.type()) {
    case MANAGED_ENDPOINT_BOUND_MESSAGE_TYPE:
        {
            if (!mAwaitingManagedEndpointBind) {
                NS_WARNING("Unexpected managed endpoint lifecycle message after actor bound!");
                return MsgNotAllowed;
            }
            mAwaitingManagedEndpointBind = false;
            return MsgProcessed;
        }
    case MANAGED_ENDPOINT_DROPPED_MESSAGE_TYPE:
        {
            if (!mAwaitingManagedEndpointBind) {
                NS_WARNING("Unexpected managed endpoint lifecycle message after actor bound!");
                return MsgNotAllowed;
            }
            mAwaitingManagedEndpointBind = false;
            this->ActorDisconnected(ManagedEndpointDropped);
            return MsgProcessed;
        }
    case PBackgroundStorage::Msg_DeleteMe__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PBackgroundStorage", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PBackgroundStorageParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PBackgroundStorage::Msg_DeleteMe", OTHER);

            mozilla::ipc::IPCResult __ok = (this)->RecvDeleteMe();
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PBackgroundStorage::Msg_AsyncPreload__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PBackgroundStorage", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PBackgroundStorageParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PBackgroundStorage::Msg_AsyncPreload", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__originSuffix = IPC::ReadParam<nsCString>((&(reader__)));
            if (!maybe__originSuffix) {
                FatalError("Error deserializing 'nsCString'");
                return MsgValueError;

            }
            auto& originSuffix = *maybe__originSuffix;
            // Sentinel = 'originSuffix'
            if ((!(((&(reader__)))->ReadSentinel(544736510)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'nsCString'");
                return MsgValueError;
            }
            auto maybe__originNoSuffix = IPC::ReadParam<nsCString>((&(reader__)));
            if (!maybe__originNoSuffix) {
                FatalError("Error deserializing 'nsCString'");
                return MsgValueError;

            }
            auto& originNoSuffix = *maybe__originNoSuffix;
            // Sentinel = 'originNoSuffix'
            if ((!(((&(reader__)))->ReadSentinel(721618363)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'nsCString'");
                return MsgValueError;
            }
            auto maybe__priority = IPC::ReadParam<bool>((&(reader__)));
            if (!maybe__priority) {
                FatalError("Error deserializing 'bool'");
                return MsgValueError;

            }
            auto& priority = *maybe__priority;
            // Sentinel = 'priority'
            if ((!(((&(reader__)))->ReadSentinel(262865795)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'bool'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::IPCResult __ok = (this)->RecvAsyncPreload(std::move(originSuffix), std::move(originNoSuffix), std::move(priority));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PBackgroundStorage::Msg_AsyncGetUsage__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PBackgroundStorage", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PBackgroundStorageParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PBackgroundStorage::Msg_AsyncGetUsage", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__scope = IPC::ReadParam<nsCString>((&(reader__)));
            if (!maybe__scope) {
                FatalError("Error deserializing 'nsCString'");
                return MsgValueError;

            }
            auto& scope = *maybe__scope;
            // Sentinel = 'scope'
            if ((!(((&(reader__)))->ReadSentinel(107086363)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'nsCString'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::IPCResult __ok = (this)->RecvAsyncGetUsage(std::move(scope));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PBackgroundStorage::Msg_AsyncAddItem__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PBackgroundStorage", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PBackgroundStorageParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PBackgroundStorage::Msg_AsyncAddItem", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__originSuffix = IPC::ReadParam<nsCString>((&(reader__)));
            if (!maybe__originSuffix) {
                FatalError("Error deserializing 'nsCString'");
                return MsgValueError;

            }
            auto& originSuffix = *maybe__originSuffix;
            // Sentinel = 'originSuffix'
            if ((!(((&(reader__)))->ReadSentinel(544736510)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'nsCString'");
                return MsgValueError;
            }
            auto maybe__originNoSuffix = IPC::ReadParam<nsCString>((&(reader__)));
            if (!maybe__originNoSuffix) {
                FatalError("Error deserializing 'nsCString'");
                return MsgValueError;

            }
            auto& originNoSuffix = *maybe__originNoSuffix;
            // Sentinel = 'originNoSuffix'
            if ((!(((&(reader__)))->ReadSentinel(721618363)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'nsCString'");
                return MsgValueError;
            }
            auto maybe__key = IPC::ReadParam<nsString>((&(reader__)));
            if (!maybe__key) {
                FatalError("Error deserializing 'nsString'");
                return MsgValueError;

            }
            auto& key = *maybe__key;
            // Sentinel = 'key'
            if ((!(((&(reader__)))->ReadSentinel(42402122)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'nsString'");
                return MsgValueError;
            }
            auto maybe__value = IPC::ReadParam<nsString>((&(reader__)));
            if (!maybe__value) {
                FatalError("Error deserializing 'nsString'");
                return MsgValueError;

            }
            auto& value = *maybe__value;
            // Sentinel = 'value'
            if ((!(((&(reader__)))->ReadSentinel(107610654)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'nsString'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::IPCResult __ok = (this)->RecvAsyncAddItem(std::move(originSuffix), std::move(originNoSuffix), std::move(key), std::move(value));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PBackgroundStorage::Msg_AsyncUpdateItem__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PBackgroundStorage", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PBackgroundStorageParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PBackgroundStorage::Msg_AsyncUpdateItem", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__originSuffix = IPC::ReadParam<nsCString>((&(reader__)));
            if (!maybe__originSuffix) {
                FatalError("Error deserializing 'nsCString'");
                return MsgValueError;

            }
            auto& originSuffix = *maybe__originSuffix;
            // Sentinel = 'originSuffix'
            if ((!(((&(reader__)))->ReadSentinel(544736510)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'nsCString'");
                return MsgValueError;
            }
            auto maybe__originNoSuffix = IPC::ReadParam<nsCString>((&(reader__)));
            if (!maybe__originNoSuffix) {
                FatalError("Error deserializing 'nsCString'");
                return MsgValueError;

            }
            auto& originNoSuffix = *maybe__originNoSuffix;
            // Sentinel = 'originNoSuffix'
            if ((!(((&(reader__)))->ReadSentinel(721618363)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'nsCString'");
                return MsgValueError;
            }
            auto maybe__key = IPC::ReadParam<nsString>((&(reader__)));
            if (!maybe__key) {
                FatalError("Error deserializing 'nsString'");
                return MsgValueError;

            }
            auto& key = *maybe__key;
            // Sentinel = 'key'
            if ((!(((&(reader__)))->ReadSentinel(42402122)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'nsString'");
                return MsgValueError;
            }
            auto maybe__value = IPC::ReadParam<nsString>((&(reader__)));
            if (!maybe__value) {
                FatalError("Error deserializing 'nsString'");
                return MsgValueError;

            }
            auto& value = *maybe__value;
            // Sentinel = 'value'
            if ((!(((&(reader__)))->ReadSentinel(107610654)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'nsString'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::IPCResult __ok = (this)->RecvAsyncUpdateItem(std::move(originSuffix), std::move(originNoSuffix), std::move(key), std::move(value));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PBackgroundStorage::Msg_AsyncRemoveItem__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PBackgroundStorage", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PBackgroundStorageParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PBackgroundStorage::Msg_AsyncRemoveItem", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__originSuffix = IPC::ReadParam<nsCString>((&(reader__)));
            if (!maybe__originSuffix) {
                FatalError("Error deserializing 'nsCString'");
                return MsgValueError;

            }
            auto& originSuffix = *maybe__originSuffix;
            // Sentinel = 'originSuffix'
            if ((!(((&(reader__)))->ReadSentinel(544736510)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'nsCString'");
                return MsgValueError;
            }
            auto maybe__originNoSuffix = IPC::ReadParam<nsCString>((&(reader__)));
            if (!maybe__originNoSuffix) {
                FatalError("Error deserializing 'nsCString'");
                return MsgValueError;

            }
            auto& originNoSuffix = *maybe__originNoSuffix;
            // Sentinel = 'originNoSuffix'
            if ((!(((&(reader__)))->ReadSentinel(721618363)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'nsCString'");
                return MsgValueError;
            }
            auto maybe__key = IPC::ReadParam<nsString>((&(reader__)));
            if (!maybe__key) {
                FatalError("Error deserializing 'nsString'");
                return MsgValueError;

            }
            auto& key = *maybe__key;
            // Sentinel = 'key'
            if ((!(((&(reader__)))->ReadSentinel(42402122)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'nsString'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::IPCResult __ok = (this)->RecvAsyncRemoveItem(std::move(originSuffix), std::move(originNoSuffix), std::move(key));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PBackgroundStorage::Msg_AsyncClear__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PBackgroundStorage", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PBackgroundStorageParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PBackgroundStorage::Msg_AsyncClear", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__originSuffix = IPC::ReadParam<nsCString>((&(reader__)));
            if (!maybe__originSuffix) {
                FatalError("Error deserializing 'nsCString'");
                return MsgValueError;

            }
            auto& originSuffix = *maybe__originSuffix;
            // Sentinel = 'originSuffix'
            if ((!(((&(reader__)))->ReadSentinel(544736510)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'nsCString'");
                return MsgValueError;
            }
            auto maybe__originNoSuffix = IPC::ReadParam<nsCString>((&(reader__)));
            if (!maybe__originNoSuffix) {
                FatalError("Error deserializing 'nsCString'");
                return MsgValueError;

            }
            auto& originNoSuffix = *maybe__originNoSuffix;
            // Sentinel = 'originNoSuffix'
            if ((!(((&(reader__)))->ReadSentinel(721618363)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'nsCString'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::IPCResult __ok = (this)->RecvAsyncClear(std::move(originSuffix), std::move(originNoSuffix));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PBackgroundStorage::Msg_AsyncFlush__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PBackgroundStorage", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PBackgroundStorageParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PBackgroundStorage::Msg_AsyncFlush", OTHER);

            mozilla::ipc::IPCResult __ok = (this)->RecvAsyncFlush();
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PBackgroundStorage::Msg_Startup__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PBackgroundStorage", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PBackgroundStorageParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PBackgroundStorage::Msg_Startup", OTHER);

            mozilla::ipc::IPCResult __ok = (this)->RecvStartup();
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PBackgroundStorage::Msg_ClearAll__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PBackgroundStorage", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PBackgroundStorageParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PBackgroundStorage::Msg_ClearAll", OTHER);

            mozilla::ipc::IPCResult __ok = (this)->RecvClearAll();
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PBackgroundStorage::Msg_ClearMatchingOrigin__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PBackgroundStorage", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PBackgroundStorageParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PBackgroundStorage::Msg_ClearMatchingOrigin", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__originNoSuffix = IPC::ReadParam<nsCString>((&(reader__)));
            if (!maybe__originNoSuffix) {
                FatalError("Error deserializing 'nsCString'");
                return MsgValueError;

            }
            auto& originNoSuffix = *maybe__originNoSuffix;
            // Sentinel = 'originNoSuffix'
            if ((!(((&(reader__)))->ReadSentinel(721618363)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'nsCString'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::IPCResult __ok = (this)->RecvClearMatchingOrigin(std::move(originNoSuffix));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PBackgroundStorage::Msg_ClearMatchingOriginAttributes__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PBackgroundStorage", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PBackgroundStorageParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PBackgroundStorage::Msg_ClearMatchingOriginAttributes", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__pattern = IPC::ReadParam<OriginAttributesPattern>((&(reader__)));
            if (!maybe__pattern) {
                FatalError("Error deserializing 'OriginAttributesPattern'");
                return MsgValueError;

            }
            auto& pattern = *maybe__pattern;
            // Sentinel = 'pattern'
            if ((!(((&(reader__)))->ReadSentinel(200409855)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'OriginAttributesPattern'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::IPCResult __ok = (this)->RecvClearMatchingOriginAttributes(std::move(pattern));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PBackgroundStorage::Reply___delete____ID:
        {
            return MsgProcessed;
        }
    default:
        return MsgNotKnown;
    }
}

auto PBackgroundStorageParent::OnMessageReceived(
        const Message& msg__,
        UniquePtr<Message>& reply__) -> PBackgroundStorageParent::Result
{
    switch (msg__.type()) {
    case PBackgroundStorage::Msg_Preload__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PBackgroundStorage", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PBackgroundStorageParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PBackgroundStorage::Msg_Preload", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__originSuffix = IPC::ReadParam<nsCString>((&(reader__)));
            if (!maybe__originSuffix) {
                FatalError("Error deserializing 'nsCString'");
                return MsgValueError;

            }
            auto& originSuffix = *maybe__originSuffix;
            // Sentinel = 'originSuffix'
            if ((!(((&(reader__)))->ReadSentinel(544736510)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'nsCString'");
                return MsgValueError;
            }
            auto maybe__originNoSuffix = IPC::ReadParam<nsCString>((&(reader__)));
            if (!maybe__originNoSuffix) {
                FatalError("Error deserializing 'nsCString'");
                return MsgValueError;

            }
            auto& originNoSuffix = *maybe__originNoSuffix;
            // Sentinel = 'originNoSuffix'
            if ((!(((&(reader__)))->ReadSentinel(721618363)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'nsCString'");
                return MsgValueError;
            }
            auto maybe__alreadyLoadedCount = IPC::ReadParam<uint32_t>((&(reader__)));
            if (!maybe__alreadyLoadedCount) {
                FatalError("Error deserializing 'uint32_t'");
                return MsgValueError;

            }
            auto& alreadyLoadedCount = *maybe__alreadyLoadedCount;
            // Sentinel = 'alreadyLoadedCount'
            if ((!(((&(reader__)))->ReadSentinel(1143015221)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'uint32_t'");
                return MsgValueError;
            }
            reader__.EndRead();
            int32_t id__ = Id();
            nsTArray<nsString> keys{};
            nsTArray<nsString> values{};
            nsresult rv{};
            mozilla::ipc::IPCResult __ok = (this)->RecvPreload(std::move(originSuffix), std::move(originNoSuffix), std::move(alreadyLoadedCount), (&(keys)), (&(values)), (&(rv)));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            reply__ = PBackgroundStorage::Reply_Preload(id__);
            IPC::MessageWriter writer__{
                    (*(reply__)),
                    this};

            IPC::WriteParam((&(writer__)), keys);
            // Sentinel = 'keys'
            ((&(writer__)))->WriteSentinel(71565757);
            IPC::WriteParam((&(writer__)), values);
            // Sentinel = 'values'
            ((&(writer__)))->WriteSentinel(150667921);
            IPC::WriteParam((&(writer__)), rv);
            // Sentinel = 'rv'
            ((&(writer__)))->WriteSentinel(22806761);

            if (mozilla::ipc::LoggingEnabledFor("PBackgroundStorage", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PBackgroundStorageParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Sending reply ",
                    reply__->type(),
                    mozilla::ipc::MessageDirection::eSending);
            }
            return MsgProcessed;
        }
    default:
        return MsgNotKnown;
    }
}



} // namespace dom
} // namespace mozilla
namespace IPC {
auto ParamTraits<::mozilla::dom::PBackgroundStorageParent*>::Write(
        IPC::MessageWriter* aWriter,
        const paramType& aVar) -> void
{
    MOZ_RELEASE_ASSERT(
        aWriter->GetActor(),
        "Cannot serialize managed actors without an actor");

    int32_t id;
    if (!aVar) {
        id = 0;  // kNullActorId
    } else {
        id = aVar->Id();
        if (id == 1) {  // kFreedActorId
            aVar->FatalError("Actor has been |delete|d");
        }
        MOZ_RELEASE_ASSERT(
            aWriter->GetActor()->GetIPCChannel() == aVar->GetIPCChannel(),
            "Actor must be from the same channel as the"
            " actor it's being sent over");
        MOZ_RELEASE_ASSERT(
            aVar->CanSend(),
            "Actor must still be open when sending");
    }

    IPC::WriteParam(aWriter, id);
}

auto ParamTraits<::mozilla::dom::PBackgroundStorageParent*>::Read(IPC::MessageReader* aReader) -> IPC::ReadResult<paramType>
{
    MOZ_RELEASE_ASSERT(
        aReader->GetActor(),
        "Cannot deserialize managed actors without an actor");
    mozilla::Maybe<mozilla::ipc::IProtocol*> actor = aReader->GetActor()
        ->ReadActor(aReader, true, "PBackgroundStorage", PBackgroundStorageMsgStart);
    if (actor.isSome()) {
        return static_cast<::mozilla::dom::PBackgroundStorageParent*>(actor.ref());
    }
    return {};
}

} // namespace IPC
