//
// Automatically generated by ipdlc.
// Edit at your own risk
//


#include "mozilla/dom/PBackgroundStorageChild.h"
#include "mozilla/ProfilerLabels.h"
#include "mozilla/ProfilerMarkers.h"
#include "mozilla/dom/quota/SerializationHelpers.h"

#include "mozilla/ipc/PBackgroundChild.h"

#include "ipc/IPCMessageUtils.h"
#include "ipc/IPCMessageUtilsSpecializations.h"
#include "nsIFile.h"
#include "mozilla/ipc/Endpoint.h"
#include "mozilla/ipc/ProtocolMessageUtils.h"
#include "mozilla/ipc/ProtocolUtils.h"
#include "mozilla/ipc/ShmemMessageUtils.h"
#include "mozilla/ipc/TaintingIPCUtils.h"

namespace mozilla {
namespace dom {


auto PBackgroundStorageChild::Recv__delete__() -> mozilla::ipc::IPCResult
{
    return IPC_OK();
}

MOZ_IMPLICIT PBackgroundStorageChild::PBackgroundStorageChild() :
    mozilla::ipc::IProtocol(kProtocolId, mozilla::ipc::ChildSide)
{
    MOZ_COUNT_CTOR(PBackgroundStorageChild);
}

PBackgroundStorageChild::~PBackgroundStorageChild()
{
    MOZ_COUNT_DTOR(PBackgroundStorageChild);
}

auto PBackgroundStorageChild::ActorAlloc() -> void
{
}

auto PBackgroundStorageChild::ActorDealloc() -> void
{
    if (Manager()) {
        Manager()->DeallocManagee(kProtocolId, this);
    }
}

auto PBackgroundStorageChild::OtherPid() const -> ::base::ProcessId
{
    ::base::ProcessId pid =
        ::mozilla::ipc::IProtocol::ToplevelProtocol()->OtherPidMaybeInvalid();
    MOZ_RELEASE_ASSERT(pid != ::base::kInvalidProcessId);
    return pid;
}

auto PBackgroundStorageChild::OtherChildID() const -> ::GeckoChildID
{
    ::GeckoChildID childID =
        ::mozilla::ipc::IProtocol::ToplevelProtocol()->OtherChildIDMaybeInvalid();
    MOZ_RELEASE_ASSERT(childID != -1);
    return childID;
}

auto PBackgroundStorageChild::OtherEndpointProcInfo() const -> ::mozilla::ipc::EndpointProcInfo
{
    return ::mozilla::ipc::EndpointProcInfo{OtherPid(), OtherChildID()};
}

auto PBackgroundStorageChild::Manager() const -> PBackgroundChild*
{
    return static_cast<PBackgroundChild*>(IProtocol::Manager());
}

auto PBackgroundStorageChild::ManagedProtocolIds() const -> mozilla::Span<mozilla::ipc::ProtocolId const>
{
    return {};
}

auto PBackgroundStorageChild::GetManagedActors(mozilla::ipc::ProtocolId aProtocol) -> UntypedManagedContainer*
{
    switch (aProtocol) {
    default:
        return nullptr;
    }
}

auto PBackgroundStorageChild::SendDeleteMe() -> bool
{
    UniquePtr<IPC::Message> msg__ = PBackgroundStorage::Msg_DeleteMe(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};





    if (mozilla::ipc::LoggingEnabledFor("PBackgroundStorage", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PBackgroundStorageChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PBackgroundStorage::Msg_DeleteMe", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PBackgroundStorageChild::SendPreload(
        const nsACString& originSuffix,
        const nsACString& originNoSuffix,
        const uint32_t& alreadyLoadedCount,
        nsTArray<nsString>* keys,
        nsTArray<nsString>* values,
        nsresult* rv) -> bool
{
    UniquePtr<IPC::Message> msg__ = PBackgroundStorage::Msg_Preload(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), originSuffix);
    // Sentinel = 'originSuffix'
    ((&(writer__)))->WriteSentinel(544736510);
    IPC::WriteParam((&(writer__)), originNoSuffix);
    // Sentinel = 'originNoSuffix'
    ((&(writer__)))->WriteSentinel(721618363);
    IPC::WriteParam((&(writer__)), alreadyLoadedCount);
    // Sentinel = 'alreadyLoadedCount'
    ((&(writer__)))->WriteSentinel(1143015221);



    UniquePtr<Message> reply__;

    if (mozilla::ipc::LoggingEnabledFor("PBackgroundStorage", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PBackgroundStorageChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PBackgroundStorage::Msg_Preload", OTHER);

    bool sendok__ = false;
    {
        AUTO_PROFILER_TRACING_MARKER("Sync IPC", "PBackgroundStorage::Msg_Preload", IPC);
        sendok__ = ChannelSend(std::move(msg__), (&(reply__)));
    }
    if ((!(sendok__))) {
        return false;
    }

    if (mozilla::ipc::LoggingEnabledFor("PBackgroundStorage", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PBackgroundStorageChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Received reply ",
            reply__->type(),
            mozilla::ipc::MessageDirection::eReceiving);
    }

    IPC::MessageReader reader__{
            (*(reply__)),
            this};

    auto maybe__keys__reply = IPC::ReadParam<nsTArray<nsString>>((&(reader__)));
    if (!maybe__keys__reply) {
        FatalError("Error deserializing 'nsString[]'");
        return false;

    }
    auto& keys__reply = *maybe__keys__reply;
    // Sentinel = 'keys'
    if ((!(((&(reader__)))->ReadSentinel(71565757)))) {
        mozilla::ipc::SentinelReadError("Error deserializing 'nsString[]'");
        return false;
    }
    auto maybe__values__reply = IPC::ReadParam<nsTArray<nsString>>((&(reader__)));
    if (!maybe__values__reply) {
        FatalError("Error deserializing 'nsString[]'");
        return false;

    }
    auto& values__reply = *maybe__values__reply;
    // Sentinel = 'values'
    if ((!(((&(reader__)))->ReadSentinel(150667921)))) {
        mozilla::ipc::SentinelReadError("Error deserializing 'nsString[]'");
        return false;
    }
    auto maybe__rv__reply = IPC::ReadParam<nsresult>((&(reader__)));
    if (!maybe__rv__reply) {
        FatalError("Error deserializing 'nsresult'");
        return false;

    }
    auto& rv__reply = *maybe__rv__reply;
    // Sentinel = 'rv'
    if ((!(((&(reader__)))->ReadSentinel(22806761)))) {
        mozilla::ipc::SentinelReadError("Error deserializing 'nsresult'");
        return false;
    }
    (*(keys)) = std::move(keys__reply);
    (*(values)) = std::move(values__reply);
    (*(rv)) = std::move(rv__reply);
    reader__.EndRead();

    return true;
}

auto PBackgroundStorageChild::SendAsyncPreload(
        const nsACString& originSuffix,
        const nsACString& originNoSuffix,
        const bool& priority) -> bool
{
    UniquePtr<IPC::Message> msg__ = PBackgroundStorage::Msg_AsyncPreload(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), originSuffix);
    // Sentinel = 'originSuffix'
    ((&(writer__)))->WriteSentinel(544736510);
    IPC::WriteParam((&(writer__)), originNoSuffix);
    // Sentinel = 'originNoSuffix'
    ((&(writer__)))->WriteSentinel(721618363);
    IPC::WriteParam((&(writer__)), priority);
    // Sentinel = 'priority'
    ((&(writer__)))->WriteSentinel(262865795);




    if (mozilla::ipc::LoggingEnabledFor("PBackgroundStorage", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PBackgroundStorageChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PBackgroundStorage::Msg_AsyncPreload", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PBackgroundStorageChild::SendAsyncGetUsage(const nsACString& scope) -> bool
{
    UniquePtr<IPC::Message> msg__ = PBackgroundStorage::Msg_AsyncGetUsage(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), scope);
    // Sentinel = 'scope'
    ((&(writer__)))->WriteSentinel(107086363);




    if (mozilla::ipc::LoggingEnabledFor("PBackgroundStorage", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PBackgroundStorageChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PBackgroundStorage::Msg_AsyncGetUsage", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PBackgroundStorageChild::SendAsyncAddItem(
        const nsACString& originSuffix,
        const nsACString& originNoSuffix,
        const nsAString& key,
        const nsAString& value) -> bool
{
    UniquePtr<IPC::Message> msg__ = PBackgroundStorage::Msg_AsyncAddItem(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), originSuffix);
    // Sentinel = 'originSuffix'
    ((&(writer__)))->WriteSentinel(544736510);
    IPC::WriteParam((&(writer__)), originNoSuffix);
    // Sentinel = 'originNoSuffix'
    ((&(writer__)))->WriteSentinel(721618363);
    IPC::WriteParam((&(writer__)), key);
    // Sentinel = 'key'
    ((&(writer__)))->WriteSentinel(42402122);
    IPC::WriteParam((&(writer__)), value);
    // Sentinel = 'value'
    ((&(writer__)))->WriteSentinel(107610654);




    if (mozilla::ipc::LoggingEnabledFor("PBackgroundStorage", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PBackgroundStorageChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PBackgroundStorage::Msg_AsyncAddItem", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PBackgroundStorageChild::SendAsyncUpdateItem(
        const nsACString& originSuffix,
        const nsACString& originNoSuffix,
        const nsAString& key,
        const nsAString& value) -> bool
{
    UniquePtr<IPC::Message> msg__ = PBackgroundStorage::Msg_AsyncUpdateItem(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), originSuffix);
    // Sentinel = 'originSuffix'
    ((&(writer__)))->WriteSentinel(544736510);
    IPC::WriteParam((&(writer__)), originNoSuffix);
    // Sentinel = 'originNoSuffix'
    ((&(writer__)))->WriteSentinel(721618363);
    IPC::WriteParam((&(writer__)), key);
    // Sentinel = 'key'
    ((&(writer__)))->WriteSentinel(42402122);
    IPC::WriteParam((&(writer__)), value);
    // Sentinel = 'value'
    ((&(writer__)))->WriteSentinel(107610654);




    if (mozilla::ipc::LoggingEnabledFor("PBackgroundStorage", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PBackgroundStorageChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PBackgroundStorage::Msg_AsyncUpdateItem", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PBackgroundStorageChild::SendAsyncRemoveItem(
        const nsACString& originSuffix,
        const nsACString& originNoSuffix,
        const nsAString& key) -> bool
{
    UniquePtr<IPC::Message> msg__ = PBackgroundStorage::Msg_AsyncRemoveItem(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), originSuffix);
    // Sentinel = 'originSuffix'
    ((&(writer__)))->WriteSentinel(544736510);
    IPC::WriteParam((&(writer__)), originNoSuffix);
    // Sentinel = 'originNoSuffix'
    ((&(writer__)))->WriteSentinel(721618363);
    IPC::WriteParam((&(writer__)), key);
    // Sentinel = 'key'
    ((&(writer__)))->WriteSentinel(42402122);




    if (mozilla::ipc::LoggingEnabledFor("PBackgroundStorage", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PBackgroundStorageChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PBackgroundStorage::Msg_AsyncRemoveItem", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PBackgroundStorageChild::SendAsyncClear(
        const nsACString& originSuffix,
        const nsACString& originNoSuffix) -> bool
{
    UniquePtr<IPC::Message> msg__ = PBackgroundStorage::Msg_AsyncClear(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), originSuffix);
    // Sentinel = 'originSuffix'
    ((&(writer__)))->WriteSentinel(544736510);
    IPC::WriteParam((&(writer__)), originNoSuffix);
    // Sentinel = 'originNoSuffix'
    ((&(writer__)))->WriteSentinel(721618363);




    if (mozilla::ipc::LoggingEnabledFor("PBackgroundStorage", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PBackgroundStorageChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PBackgroundStorage::Msg_AsyncClear", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PBackgroundStorageChild::SendAsyncFlush() -> bool
{
    UniquePtr<IPC::Message> msg__ = PBackgroundStorage::Msg_AsyncFlush(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};





    if (mozilla::ipc::LoggingEnabledFor("PBackgroundStorage", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PBackgroundStorageChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PBackgroundStorage::Msg_AsyncFlush", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PBackgroundStorageChild::SendStartup() -> bool
{
    UniquePtr<IPC::Message> msg__ = PBackgroundStorage::Msg_Startup(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};





    if (mozilla::ipc::LoggingEnabledFor("PBackgroundStorage", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PBackgroundStorageChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PBackgroundStorage::Msg_Startup", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PBackgroundStorageChild::SendClearAll() -> bool
{
    UniquePtr<IPC::Message> msg__ = PBackgroundStorage::Msg_ClearAll(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};





    if (mozilla::ipc::LoggingEnabledFor("PBackgroundStorage", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PBackgroundStorageChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PBackgroundStorage::Msg_ClearAll", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PBackgroundStorageChild::SendClearMatchingOrigin(const nsACString& originNoSuffix) -> bool
{
    UniquePtr<IPC::Message> msg__ = PBackgroundStorage::Msg_ClearMatchingOrigin(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), originNoSuffix);
    // Sentinel = 'originNoSuffix'
    ((&(writer__)))->WriteSentinel(721618363);




    if (mozilla::ipc::LoggingEnabledFor("PBackgroundStorage", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PBackgroundStorageChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PBackgroundStorage::Msg_ClearMatchingOrigin", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PBackgroundStorageChild::SendClearMatchingOriginAttributes(const OriginAttributesPattern& pattern) -> bool
{
    UniquePtr<IPC::Message> msg__ = PBackgroundStorage::Msg_ClearMatchingOriginAttributes(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), pattern);
    // Sentinel = 'pattern'
    ((&(writer__)))->WriteSentinel(200409855);




    if (mozilla::ipc::LoggingEnabledFor("PBackgroundStorage", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PBackgroundStorageChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PBackgroundStorage::Msg_ClearMatchingOriginAttributes", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PBackgroundStorageChild::DeallocManagee(
        int32_t aProtocolId,
        IProtocol* aListener) -> void
{
    FatalError("unreached");
    return;
}

auto PBackgroundStorageChild::OnMessageReceived(const Message& msg__) -> PBackgroundStorageChild::Result
{
    switch (msg__.type()) {
    case MANAGED_ENDPOINT_BOUND_MESSAGE_TYPE:
        {
            if (!mAwaitingManagedEndpointBind) {
                NS_WARNING("Unexpected managed endpoint lifecycle message after actor bound!");
                return MsgNotAllowed;
            }
            mAwaitingManagedEndpointBind = false;
            return MsgProcessed;
        }
    case MANAGED_ENDPOINT_DROPPED_MESSAGE_TYPE:
        {
            if (!mAwaitingManagedEndpointBind) {
                NS_WARNING("Unexpected managed endpoint lifecycle message after actor bound!");
                return MsgNotAllowed;
            }
            mAwaitingManagedEndpointBind = false;
            this->ActorDisconnected(ManagedEndpointDropped);
            return MsgProcessed;
        }
    case PBackgroundStorage::Msg___delete____ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PBackgroundStorage", mozilla::ipc::ChildSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PBackgroundStorageChild",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PBackgroundStorage::Msg___delete__", OTHER);

            mozilla::ipc::IPCResult __ok = (this)->Recv__delete__();
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }


            this->ActorDisconnected(Deletion);

            return MsgProcessed;
        }
    case PBackgroundStorage::Msg_Observe__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PBackgroundStorage", mozilla::ipc::ChildSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PBackgroundStorageChild",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PBackgroundStorage::Msg_Observe", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__topic = IPC::ReadParam<nsCString>((&(reader__)));
            if (!maybe__topic) {
                FatalError("Error deserializing 'nsCString'");
                return MsgValueError;

            }
            auto& topic = *maybe__topic;
            // Sentinel = 'topic'
            if ((!(((&(reader__)))->ReadSentinel(109707808)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'nsCString'");
                return MsgValueError;
            }
            auto maybe__originAttributesPattern = IPC::ReadParam<nsString>((&(reader__)));
            if (!maybe__originAttributesPattern) {
                FatalError("Error deserializing 'nsString'");
                return MsgValueError;

            }
            auto& originAttributesPattern = *maybe__originAttributesPattern;
            // Sentinel = 'originAttributesPattern'
            if ((!(((&(reader__)))->ReadSentinel(1917913486)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'nsString'");
                return MsgValueError;
            }
            auto maybe__originScope = IPC::ReadParam<nsCString>((&(reader__)));
            if (!maybe__originScope) {
                FatalError("Error deserializing 'nsCString'");
                return MsgValueError;

            }
            auto& originScope = *maybe__originScope;
            // Sentinel = 'originScope'
            if ((!(((&(reader__)))->ReadSentinel(459080835)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'nsCString'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::IPCResult __ok = (this)->RecvObserve(std::move(topic), std::move(originAttributesPattern), std::move(originScope));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PBackgroundStorage::Msg_OriginsHavingData__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PBackgroundStorage", mozilla::ipc::ChildSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PBackgroundStorageChild",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PBackgroundStorage::Msg_OriginsHavingData", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__origins = IPC::ReadParam<nsTArray<nsCString>>((&(reader__)));
            if (!maybe__origins) {
                FatalError("Error deserializing 'nsCString[]'");
                return MsgValueError;

            }
            auto& origins = *maybe__origins;
            // Sentinel = 'origins'
            if ((!(((&(reader__)))->ReadSentinel(200213244)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'nsCString[]'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::IPCResult __ok = (this)->RecvOriginsHavingData(std::move(origins));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PBackgroundStorage::Msg_LoadItem__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PBackgroundStorage", mozilla::ipc::ChildSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PBackgroundStorageChild",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PBackgroundStorage::Msg_LoadItem", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__originSuffix = IPC::ReadParam<nsCString>((&(reader__)));
            if (!maybe__originSuffix) {
                FatalError("Error deserializing 'nsCString'");
                return MsgValueError;

            }
            auto& originSuffix = *maybe__originSuffix;
            // Sentinel = 'originSuffix'
            if ((!(((&(reader__)))->ReadSentinel(544736510)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'nsCString'");
                return MsgValueError;
            }
            auto maybe__originNoSuffix = IPC::ReadParam<nsCString>((&(reader__)));
            if (!maybe__originNoSuffix) {
                FatalError("Error deserializing 'nsCString'");
                return MsgValueError;

            }
            auto& originNoSuffix = *maybe__originNoSuffix;
            // Sentinel = 'originNoSuffix'
            if ((!(((&(reader__)))->ReadSentinel(721618363)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'nsCString'");
                return MsgValueError;
            }
            auto maybe__key = IPC::ReadParam<nsString>((&(reader__)));
            if (!maybe__key) {
                FatalError("Error deserializing 'nsString'");
                return MsgValueError;

            }
            auto& key = *maybe__key;
            // Sentinel = 'key'
            if ((!(((&(reader__)))->ReadSentinel(42402122)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'nsString'");
                return MsgValueError;
            }
            auto maybe__value = IPC::ReadParam<nsString>((&(reader__)));
            if (!maybe__value) {
                FatalError("Error deserializing 'nsString'");
                return MsgValueError;

            }
            auto& value = *maybe__value;
            // Sentinel = 'value'
            if ((!(((&(reader__)))->ReadSentinel(107610654)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'nsString'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::IPCResult __ok = (this)->RecvLoadItem(std::move(originSuffix), std::move(originNoSuffix), std::move(key), std::move(value));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PBackgroundStorage::Msg_LoadDone__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PBackgroundStorage", mozilla::ipc::ChildSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PBackgroundStorageChild",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PBackgroundStorage::Msg_LoadDone", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__originSuffix = IPC::ReadParam<nsCString>((&(reader__)));
            if (!maybe__originSuffix) {
                FatalError("Error deserializing 'nsCString'");
                return MsgValueError;

            }
            auto& originSuffix = *maybe__originSuffix;
            // Sentinel = 'originSuffix'
            if ((!(((&(reader__)))->ReadSentinel(544736510)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'nsCString'");
                return MsgValueError;
            }
            auto maybe__originNoSuffix = IPC::ReadParam<nsCString>((&(reader__)));
            if (!maybe__originNoSuffix) {
                FatalError("Error deserializing 'nsCString'");
                return MsgValueError;

            }
            auto& originNoSuffix = *maybe__originNoSuffix;
            // Sentinel = 'originNoSuffix'
            if ((!(((&(reader__)))->ReadSentinel(721618363)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'nsCString'");
                return MsgValueError;
            }
            auto maybe__rv = IPC::ReadParam<nsresult>((&(reader__)));
            if (!maybe__rv) {
                FatalError("Error deserializing 'nsresult'");
                return MsgValueError;

            }
            auto& rv = *maybe__rv;
            // Sentinel = 'rv'
            if ((!(((&(reader__)))->ReadSentinel(22806761)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'nsresult'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::IPCResult __ok = (this)->RecvLoadDone(std::move(originSuffix), std::move(originNoSuffix), std::move(rv));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PBackgroundStorage::Msg_LoadUsage__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PBackgroundStorage", mozilla::ipc::ChildSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PBackgroundStorageChild",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PBackgroundStorage::Msg_LoadUsage", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__scope = IPC::ReadParam<nsCString>((&(reader__)));
            if (!maybe__scope) {
                FatalError("Error deserializing 'nsCString'");
                return MsgValueError;

            }
            auto& scope = *maybe__scope;
            // Sentinel = 'scope'
            if ((!(((&(reader__)))->ReadSentinel(107086363)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'nsCString'");
                return MsgValueError;
            }
            auto maybe__usage = IPC::ReadParam<int64_t>((&(reader__)));
            if (!maybe__usage) {
                FatalError("Error deserializing 'int64_t'");
                return MsgValueError;

            }
            auto& usage = *maybe__usage;
            // Sentinel = 'usage'
            if ((!(((&(reader__)))->ReadSentinel(108003862)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'int64_t'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::IPCResult __ok = (this)->RecvLoadUsage(std::move(scope), std::move(usage));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PBackgroundStorage::Msg_Error__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PBackgroundStorage", mozilla::ipc::ChildSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PBackgroundStorageChild",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PBackgroundStorage::Msg_Error", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__rv = IPC::ReadParam<nsresult>((&(reader__)));
            if (!maybe__rv) {
                FatalError("Error deserializing 'nsresult'");
                return MsgValueError;

            }
            auto& rv = *maybe__rv;
            // Sentinel = 'rv'
            if ((!(((&(reader__)))->ReadSentinel(22806761)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'nsresult'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::IPCResult __ok = (this)->RecvError(std::move(rv));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    default:
        return MsgNotKnown;
    }
}

auto PBackgroundStorageChild::OnMessageReceived(
        const Message& msg__,
        UniquePtr<Message>& reply__) -> PBackgroundStorageChild::Result
{
    return MsgNotKnown;
}



} // namespace dom
} // namespace mozilla
namespace IPC {
auto ParamTraits<::mozilla::dom::PBackgroundStorageChild*>::Write(
        IPC::MessageWriter* aWriter,
        const paramType& aVar) -> void
{
    MOZ_RELEASE_ASSERT(
        aWriter->GetActor(),
        "Cannot serialize managed actors without an actor");

    int32_t id;
    if (!aVar) {
        id = 0;  // kNullActorId
    } else {
        id = aVar->Id();
        if (id == 1) {  // kFreedActorId
            aVar->FatalError("Actor has been |delete|d");
        }
        MOZ_RELEASE_ASSERT(
            aWriter->GetActor()->GetIPCChannel() == aVar->GetIPCChannel(),
            "Actor must be from the same channel as the"
            " actor it's being sent over");
        MOZ_RELEASE_ASSERT(
            aVar->CanSend(),
            "Actor must still be open when sending");
    }

    IPC::WriteParam(aWriter, id);
}

auto ParamTraits<::mozilla::dom::PBackgroundStorageChild*>::Read(IPC::MessageReader* aReader) -> IPC::ReadResult<paramType>
{
    MOZ_RELEASE_ASSERT(
        aReader->GetActor(),
        "Cannot deserialize managed actors without an actor");
    mozilla::Maybe<mozilla::ipc::IProtocol*> actor = aReader->GetActor()
        ->ReadActor(aReader, true, "PBackgroundStorage", PBackgroundStorageMsgStart);
    if (actor.isSome()) {
        return static_cast<::mozilla::dom::PBackgroundStorageChild*>(actor.ref());
    }
    return {};
}

} // namespace IPC
