//
// Automatically generated by ipdlc.
// Edit at your own risk
//


#include "mozilla/dom/PBackgroundSessionStorageCacheParent.h"
#include "mozilla/ProfilerLabels.h"
#include "mozilla/dom/DomSecurityIPCUtils.h"
#include "mozilla/ipc/IPCCore.h"

#include "mozilla/ipc/PBackgroundParent.h"
#include "mozilla/dom/PBackgroundSessionStorageManagerParent.h"

#include "ipc/IPCMessageUtils.h"
#include "ipc/IPCMessageUtilsSpecializations.h"
#include "nsIFile.h"
#include "mozilla/ipc/Endpoint.h"
#include "mozilla/ipc/ProtocolMessageUtils.h"
#include "mozilla/ipc/ProtocolUtils.h"
#include "mozilla/ipc/ShmemMessageUtils.h"
#include "mozilla/ipc/TaintingIPCUtils.h"

namespace mozilla {
namespace dom {


MOZ_IMPLICIT PBackgroundSessionStorageCacheParent::PBackgroundSessionStorageCacheParent() :
    mozilla::ipc::IRefCountedProtocol(kProtocolId, mozilla::ipc::ParentSide)
{
    MOZ_COUNT_CTOR(PBackgroundSessionStorageCacheParent);
}

PBackgroundSessionStorageCacheParent::~PBackgroundSessionStorageCacheParent()
{
    MOZ_COUNT_DTOR(PBackgroundSessionStorageCacheParent);
}

auto PBackgroundSessionStorageCacheParent::ActorAlloc() -> void
{
    AddRef();
}

auto PBackgroundSessionStorageCacheParent::ActorDealloc() -> void
{
    Release();
}

auto PBackgroundSessionStorageCacheParent::OtherPid() const -> ::base::ProcessId
{
    ::base::ProcessId pid =
        ::mozilla::ipc::IProtocol::ToplevelProtocol()->OtherPidMaybeInvalid();
    MOZ_RELEASE_ASSERT(pid != ::base::kInvalidProcessId);
    return pid;
}

auto PBackgroundSessionStorageCacheParent::OtherChildID() const -> ::GeckoChildID
{
    ::GeckoChildID childID =
        ::mozilla::ipc::IProtocol::ToplevelProtocol()->OtherChildIDMaybeInvalid();
    MOZ_RELEASE_ASSERT(childID != -1);
    return childID;
}

auto PBackgroundSessionStorageCacheParent::OtherEndpointProcInfo() const -> ::mozilla::ipc::EndpointProcInfo
{
    return ::mozilla::ipc::EndpointProcInfo{OtherPid(), OtherChildID()};
}

auto PBackgroundSessionStorageCacheParent::Manager() const -> PBackgroundSessionStorageManagerParent*
{
    return static_cast<PBackgroundSessionStorageManagerParent*>(IProtocol::Manager());
}

auto PBackgroundSessionStorageCacheParent::ManagedProtocolIds() const -> mozilla::Span<mozilla::ipc::ProtocolId const>
{
    return {};
}

auto PBackgroundSessionStorageCacheParent::GetManagedActors(mozilla::ipc::ProtocolId aProtocol) -> UntypedManagedContainer*
{
    switch (aProtocol) {
    default:
        return nullptr;
    }
}

auto PBackgroundSessionStorageCacheParent::Send__delete__(PBackgroundSessionStorageCacheParent* actor) -> bool
{
    if (!actor || !actor->CanSend()) {
        NS_WARNING("Attempt to __delete__ missing or closed actor");
        return false;
    }
    UniquePtr<IPC::Message> msg__ = PBackgroundSessionStorageCache::Msg___delete__((actor)->Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            actor};




    if (mozilla::ipc::LoggingEnabledFor("PBackgroundSessionStorageCache", mozilla::ipc::ParentSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PBackgroundSessionStorageCacheParent",
            actor->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PBackgroundSessionStorageCache::Msg___delete__", OTHER);

    bool sendok__ = (actor)->ChannelSend(std::move(msg__));

    actor->ActorDisconnected(Deletion);
    return sendok__;
}

auto PBackgroundSessionStorageCacheParent::DeallocManagee(
        int32_t aProtocolId,
        IProtocol* aListener) -> void
{
    FatalError("unreached");
    return;
}

auto PBackgroundSessionStorageCacheParent::OnMessageReceived(const Message& msg__) -> PBackgroundSessionStorageCacheParent::Result
{
    switch (msg__.type()) {
    case MANAGED_ENDPOINT_BOUND_MESSAGE_TYPE:
        {
            if (!mAwaitingManagedEndpointBind) {
                NS_WARNING("Unexpected managed endpoint lifecycle message after actor bound!");
                return MsgNotAllowed;
            }
            mAwaitingManagedEndpointBind = false;
            return MsgProcessed;
        }
    case MANAGED_ENDPOINT_DROPPED_MESSAGE_TYPE:
        {
            if (!mAwaitingManagedEndpointBind) {
                NS_WARNING("Unexpected managed endpoint lifecycle message after actor bound!");
                return MsgNotAllowed;
            }
            mAwaitingManagedEndpointBind = false;
            this->ActorDisconnected(ManagedEndpointDropped);
            return MsgProcessed;
        }
    case PBackgroundSessionStorageCache::Msg_DeleteMe__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PBackgroundSessionStorageCache", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PBackgroundSessionStorageCacheParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PBackgroundSessionStorageCache::Msg_DeleteMe", OTHER);

            mozilla::ipc::IPCResult __ok = (this)->RecvDeleteMe();
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PBackgroundSessionStorageCache::Msg_Checkpoint__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PBackgroundSessionStorageCache", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PBackgroundSessionStorageCacheParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PBackgroundSessionStorageCache::Msg_Checkpoint", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__aWriteInfos = IPC::ReadParam<nsTArray<SSWriteInfo>>((&(reader__)));
            if (!maybe__aWriteInfos) {
                FatalError("Error deserializing 'SSWriteInfo[]'");
                return MsgValueError;

            }
            auto& aWriteInfos = *maybe__aWriteInfos;
            // Sentinel = 'aWriteInfos'
            if ((!(((&(reader__)))->ReadSentinel(437781612)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'SSWriteInfo[]'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::IPCResult __ok = (this)->RecvCheckpoint(std::move(aWriteInfos));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PBackgroundSessionStorageCache::Reply___delete____ID:
        {
            return MsgProcessed;
        }
    default:
        return MsgNotKnown;
    }
}

auto PBackgroundSessionStorageCacheParent::OnMessageReceived(
        const Message& msg__,
        UniquePtr<Message>& reply__) -> PBackgroundSessionStorageCacheParent::Result
{
    switch (msg__.type()) {
    case PBackgroundSessionStorageCache::Msg_Load__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PBackgroundSessionStorageCache", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PBackgroundSessionStorageCacheParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PBackgroundSessionStorageCache::Msg_Load", OTHER);

            int32_t id__ = Id();
            nsTArray<SSSetItemInfo> aData{};
            mozilla::ipc::IPCResult __ok = (this)->RecvLoad((&(aData)));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            reply__ = PBackgroundSessionStorageCache::Reply_Load(id__);
            IPC::MessageWriter writer__{
                    (*(reply__)),
                    this};

            IPC::WriteParam((&(writer__)), aData);
            // Sentinel = 'aData'
            ((&(writer__)))->WriteSentinel(90571228);

            if (mozilla::ipc::LoggingEnabledFor("PBackgroundSessionStorageCache", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PBackgroundSessionStorageCacheParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Sending reply ",
                    reply__->type(),
                    mozilla::ipc::MessageDirection::eSending);
            }
            return MsgProcessed;
        }
    default:
        return MsgNotKnown;
    }
}



} // namespace dom
} // namespace mozilla
namespace IPC {
auto ParamTraits<::mozilla::dom::PBackgroundSessionStorageCacheParent*>::Write(
        IPC::MessageWriter* aWriter,
        const paramType& aVar) -> void
{
    MOZ_RELEASE_ASSERT(
        aWriter->GetActor(),
        "Cannot serialize managed actors without an actor");

    int32_t id;
    if (!aVar) {
        id = 0;  // kNullActorId
    } else {
        id = aVar->Id();
        if (id == 1) {  // kFreedActorId
            aVar->FatalError("Actor has been |delete|d");
        }
        MOZ_RELEASE_ASSERT(
            aWriter->GetActor()->GetIPCChannel() == aVar->GetIPCChannel(),
            "Actor must be from the same channel as the"
            " actor it's being sent over");
        MOZ_RELEASE_ASSERT(
            aVar->CanSend(),
            "Actor must still be open when sending");
    }

    IPC::WriteParam(aWriter, id);
}

auto ParamTraits<::mozilla::dom::PBackgroundSessionStorageCacheParent*>::Read(IPC::MessageReader* aReader) -> IPC::ReadResult<paramType>
{
    MOZ_RELEASE_ASSERT(
        aReader->GetActor(),
        "Cannot deserialize managed actors without an actor");
    mozilla::Maybe<mozilla::ipc::IProtocol*> actor = aReader->GetActor()
        ->ReadActor(aReader, true, "PBackgroundSessionStorageCache", PBackgroundSessionStorageCacheMsgStart);
    if (actor.isSome()) {
        return static_cast<::mozilla::dom::PBackgroundSessionStorageCacheParent*>(actor.ref());
    }
    return {};
}

} // namespace IPC
