//
// Automatically generated by ipdlc.
// Edit at your own risk
//


#include "mozilla/dom/PBackgroundSDBConnectionParent.h"
#include "mozilla/ProfilerLabels.h"

#include "mozilla/ipc/PBackgroundParent.h"
#include "mozilla/dom/PBackgroundSDBRequestParent.h"

#include "ipc/IPCMessageUtils.h"
#include "ipc/IPCMessageUtilsSpecializations.h"
#include "nsIFile.h"
#include "mozilla/ipc/Endpoint.h"
#include "mozilla/ipc/ProtocolMessageUtils.h"
#include "mozilla/ipc/ProtocolUtils.h"
#include "mozilla/ipc/ShmemMessageUtils.h"
#include "mozilla/ipc/TaintingIPCUtils.h"

namespace mozilla {
namespace dom {


auto PBackgroundSDBConnectionParent::RecvPBackgroundSDBRequestConstructor(
        PBackgroundSDBRequestParent* actor,
        const SDBRequestParams& params) -> mozilla::ipc::IPCResult
{
    return IPC_OK();
}

MOZ_IMPLICIT PBackgroundSDBConnectionParent::PBackgroundSDBConnectionParent() :
    mozilla::ipc::IRefCountedProtocol(kProtocolId, mozilla::ipc::ParentSide)
{
    MOZ_COUNT_CTOR(PBackgroundSDBConnectionParent);
}

PBackgroundSDBConnectionParent::~PBackgroundSDBConnectionParent()
{
    MOZ_COUNT_DTOR(PBackgroundSDBConnectionParent);
}

auto PBackgroundSDBConnectionParent::ActorAlloc() -> void
{
    AddRef();
}

auto PBackgroundSDBConnectionParent::ActorDealloc() -> void
{
    Release();
}

auto PBackgroundSDBConnectionParent::OtherPid() const -> ::base::ProcessId
{
    ::base::ProcessId pid =
        ::mozilla::ipc::IProtocol::ToplevelProtocol()->OtherPidMaybeInvalid();
    MOZ_RELEASE_ASSERT(pid != ::base::kInvalidProcessId);
    return pid;
}

auto PBackgroundSDBConnectionParent::OtherChildID() const -> ::GeckoChildID
{
    ::GeckoChildID childID =
        ::mozilla::ipc::IProtocol::ToplevelProtocol()->OtherChildIDMaybeInvalid();
    MOZ_RELEASE_ASSERT(childID != -1);
    return childID;
}

auto PBackgroundSDBConnectionParent::OtherEndpointProcInfo() const -> ::mozilla::ipc::EndpointProcInfo
{
    return ::mozilla::ipc::EndpointProcInfo{OtherPid(), OtherChildID()};
}

auto PBackgroundSDBConnectionParent::Manager() const -> PBackgroundParent*
{
    return static_cast<PBackgroundParent*>(IProtocol::Manager());
}

auto PBackgroundSDBConnectionParent::ManagedPBackgroundSDBRequestParent(nsTArray<PBackgroundSDBRequestParent*>& aArr) const -> void
{
    mManagedPBackgroundSDBRequestParent.ToArray(aArr);
}

auto PBackgroundSDBConnectionParent::ManagedPBackgroundSDBRequestParent() const -> const ManagedContainer<PBackgroundSDBRequestParent>&
{
    return mManagedPBackgroundSDBRequestParent;
}

auto PBackgroundSDBConnectionParent::ManagedProtocolIds() const -> mozilla::Span<mozilla::ipc::ProtocolId const>
{
    static constexpr ::mozilla::ipc::ProtocolId sIds[] = {
        PBackgroundSDBRequestMsgStart
    };
    return sIds;
}

auto PBackgroundSDBConnectionParent::GetManagedActors(mozilla::ipc::ProtocolId aProtocol) -> UntypedManagedContainer*
{
    switch (aProtocol) {
    case PBackgroundSDBRequestMsgStart:
        return (&(mManagedPBackgroundSDBRequestParent));
    default:
        return nullptr;
    }
}

auto PBackgroundSDBConnectionParent::OpenPBackgroundSDBRequestEndpoint(PBackgroundSDBRequestParent* aActor) -> ManagedEndpoint<PBackgroundSDBRequestChild>
{
    if (!aActor) {
        NS_WARNING("Cannot bind null PBackgroundSDBRequestParent actor");
        return ManagedEndpoint<PBackgroundSDBRequestChild>();
    }

    if (!aActor->SetManagerAndRegister(this)) {
        NS_WARNING("Failed to bind PBackgroundSDBRequestParent actor");
        return ManagedEndpoint<PBackgroundSDBRequestChild>();
    }

    // Mark our actor as awaiting the other side to be bound. This will
    // be cleared when a `MANAGED_ENDPOINT_{DROPPED,BOUND}` message is
    // received.
    aActor->mAwaitingManagedEndpointBind = true;
    return ManagedEndpoint<PBackgroundSDBRequestChild>(mozilla::ipc::PrivateIPDLInterface(), aActor);
}

auto PBackgroundSDBConnectionParent::BindPBackgroundSDBRequestEndpoint(
        ManagedEndpoint<PBackgroundSDBRequestParent> aEndpoint,
        PBackgroundSDBRequestParent* aActor) -> bool
{
    return aEndpoint.Bind(mozilla::ipc::PrivateIPDLInterface(), aActor, this);
}

auto PBackgroundSDBConnectionParent::Send__delete__(PBackgroundSDBConnectionParent* actor) -> bool
{
    if (!actor || !actor->CanSend()) {
        NS_WARNING("Attempt to __delete__ missing or closed actor");
        return false;
    }
    UniquePtr<IPC::Message> msg__ = PBackgroundSDBConnection::Msg___delete__((actor)->Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            actor};




    if (mozilla::ipc::LoggingEnabledFor("PBackgroundSDBConnection", mozilla::ipc::ParentSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PBackgroundSDBConnectionParent",
            actor->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PBackgroundSDBConnection::Msg___delete__", OTHER);

    bool sendok__ = (actor)->ChannelSend(std::move(msg__));

    actor->ActorDisconnected(Deletion);
    return sendok__;
}

auto PBackgroundSDBConnectionParent::SendAllowToClose() -> bool
{
    UniquePtr<IPC::Message> msg__ = PBackgroundSDBConnection::Msg_AllowToClose(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};





    if (mozilla::ipc::LoggingEnabledFor("PBackgroundSDBConnection", mozilla::ipc::ParentSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PBackgroundSDBConnectionParent",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PBackgroundSDBConnection::Msg_AllowToClose", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PBackgroundSDBConnectionParent::SendClosed() -> bool
{
    UniquePtr<IPC::Message> msg__ = PBackgroundSDBConnection::Msg_Closed(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};





    if (mozilla::ipc::LoggingEnabledFor("PBackgroundSDBConnection", mozilla::ipc::ParentSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PBackgroundSDBConnectionParent",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PBackgroundSDBConnection::Msg_Closed", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PBackgroundSDBConnectionParent::DeallocManagee(
        int32_t aProtocolId,
        IProtocol* aListener) -> void
{
    switch (aProtocolId) {
    case PBackgroundSDBRequestMsgStart:
        this->DeallocPBackgroundSDBRequestParent(static_cast<PBackgroundSDBRequestParent*>(aListener));
        return;
    default:
        FatalError("unreached");
        return;
    }
}

auto PBackgroundSDBConnectionParent::OnMessageReceived(const Message& msg__) -> PBackgroundSDBConnectionParent::Result
{
    switch (msg__.type()) {
    case MANAGED_ENDPOINT_BOUND_MESSAGE_TYPE:
        {
            if (!mAwaitingManagedEndpointBind) {
                NS_WARNING("Unexpected managed endpoint lifecycle message after actor bound!");
                return MsgNotAllowed;
            }
            mAwaitingManagedEndpointBind = false;
            return MsgProcessed;
        }
    case MANAGED_ENDPOINT_DROPPED_MESSAGE_TYPE:
        {
            if (!mAwaitingManagedEndpointBind) {
                NS_WARNING("Unexpected managed endpoint lifecycle message after actor bound!");
                return MsgNotAllowed;
            }
            mAwaitingManagedEndpointBind = false;
            this->ActorDisconnected(ManagedEndpointDropped);
            return MsgProcessed;
        }
    case PBackgroundSDBConnection::Msg_DeleteMe__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PBackgroundSDBConnection", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PBackgroundSDBConnectionParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PBackgroundSDBConnection::Msg_DeleteMe", OTHER);

            mozilla::ipc::IPCResult __ok = (this)->RecvDeleteMe();
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PBackgroundSDBConnection::Msg_PBackgroundSDBRequestConstructor__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PBackgroundSDBConnection", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PBackgroundSDBConnectionParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PBackgroundSDBConnection::Msg_PBackgroundSDBRequestConstructor", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__handle__ = IPC::ReadParam<ActorHandle>((&(reader__)));
            if (!maybe__handle__) {
                FatalError("Error deserializing 'ActorHandle'");
                return MsgValueError;

            }
            auto& handle__ = *maybe__handle__;
            // Sentinel = 'actor'
            if ((!(((&(reader__)))->ReadSentinel(102892058)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'ActorHandle'");
                return MsgValueError;
            }
            auto maybe__params = IPC::ReadParam<SDBRequestParams>((&(reader__)));
            if (!maybe__params) {
                FatalError("Error deserializing 'SDBRequestParams'");
                return MsgValueError;

            }
            auto& params = *maybe__params;
            // Sentinel = 'params'
            if ((!(((&(reader__)))->ReadSentinel(146997893)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'SDBRequestParams'");
                return MsgValueError;
            }
            reader__.EndRead();
            PBackgroundSDBRequestParent* actor = (this)->AllocPBackgroundSDBRequestParent(params);
            if (!actor) {
                NS_WARNING("Cannot bind null PBackgroundSDBRequestParent actor");
                return MsgValueError;
            }

            if (!actor->SetManagerAndRegister(this, (handle__).mId)) {
                NS_WARNING("Failed to bind PBackgroundSDBRequestParent actor");
                return MsgValueError;
            }

            mozilla::ipc::IPCResult __ok = (this)->RecvPBackgroundSDBRequestConstructor(std::move(actor), std::move(params));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PBackgroundSDBConnection::Reply___delete____ID:
        {
            return MsgProcessed;
        }
    default:
        return MsgNotKnown;
    }
}

auto PBackgroundSDBConnectionParent::OnMessageReceived(
        const Message& msg__,
        UniquePtr<Message>& reply__) -> PBackgroundSDBConnectionParent::Result
{
    return MsgNotKnown;
}



} // namespace dom
} // namespace mozilla
namespace IPC {
auto ParamTraits<::mozilla::dom::PBackgroundSDBConnectionParent*>::Write(
        IPC::MessageWriter* aWriter,
        const paramType& aVar) -> void
{
    MOZ_RELEASE_ASSERT(
        aWriter->GetActor(),
        "Cannot serialize managed actors without an actor");

    int32_t id;
    if (!aVar) {
        id = 0;  // kNullActorId
    } else {
        id = aVar->Id();
        if (id == 1) {  // kFreedActorId
            aVar->FatalError("Actor has been |delete|d");
        }
        MOZ_RELEASE_ASSERT(
            aWriter->GetActor()->GetIPCChannel() == aVar->GetIPCChannel(),
            "Actor must be from the same channel as the"
            " actor it's being sent over");
        MOZ_RELEASE_ASSERT(
            aVar->CanSend(),
            "Actor must still be open when sending");
    }

    IPC::WriteParam(aWriter, id);
}

auto ParamTraits<::mozilla::dom::PBackgroundSDBConnectionParent*>::Read(IPC::MessageReader* aReader) -> IPC::ReadResult<paramType>
{
    MOZ_RELEASE_ASSERT(
        aReader->GetActor(),
        "Cannot deserialize managed actors without an actor");
    mozilla::Maybe<mozilla::ipc::IProtocol*> actor = aReader->GetActor()
        ->ReadActor(aReader, true, "PBackgroundSDBConnection", PBackgroundSDBConnectionMsgStart);
    if (actor.isSome()) {
        return static_cast<::mozilla::dom::PBackgroundSDBConnectionParent*>(actor.ref());
    }
    return {};
}

} // namespace IPC
