//
// Automatically generated by ipdlc.
// Edit at your own risk
//


#include "mozilla/dom/PBackgroundSDBConnectionChild.h"
#include "mozilla/ProfilerLabels.h"

#include "mozilla/ipc/PBackgroundChild.h"
#include "mozilla/dom/PBackgroundSDBRequestChild.h"

#include "ipc/IPCMessageUtils.h"
#include "ipc/IPCMessageUtilsSpecializations.h"
#include "nsIFile.h"
#include "mozilla/ipc/Endpoint.h"
#include "mozilla/ipc/ProtocolMessageUtils.h"
#include "mozilla/ipc/ProtocolUtils.h"
#include "mozilla/ipc/ShmemMessageUtils.h"
#include "mozilla/ipc/TaintingIPCUtils.h"

namespace mozilla {
namespace dom {


auto PBackgroundSDBConnectionChild::Recv__delete__() -> mozilla::ipc::IPCResult
{
    return IPC_OK();
}

MOZ_IMPLICIT PBackgroundSDBConnectionChild::PBackgroundSDBConnectionChild() :
    mozilla::ipc::IRefCountedProtocol(kProtocolId, mozilla::ipc::ChildSide)
{
    MOZ_COUNT_CTOR(PBackgroundSDBConnectionChild);
}

PBackgroundSDBConnectionChild::~PBackgroundSDBConnectionChild()
{
    MOZ_COUNT_DTOR(PBackgroundSDBConnectionChild);
}

auto PBackgroundSDBConnectionChild::ActorAlloc() -> void
{
    AddRef();
}

auto PBackgroundSDBConnectionChild::ActorDealloc() -> void
{
    Release();
}

auto PBackgroundSDBConnectionChild::OtherPid() const -> ::base::ProcessId
{
    ::base::ProcessId pid =
        ::mozilla::ipc::IProtocol::ToplevelProtocol()->OtherPidMaybeInvalid();
    MOZ_RELEASE_ASSERT(pid != ::base::kInvalidProcessId);
    return pid;
}

auto PBackgroundSDBConnectionChild::OtherChildID() const -> ::GeckoChildID
{
    ::GeckoChildID childID =
        ::mozilla::ipc::IProtocol::ToplevelProtocol()->OtherChildIDMaybeInvalid();
    MOZ_RELEASE_ASSERT(childID != -1);
    return childID;
}

auto PBackgroundSDBConnectionChild::OtherEndpointProcInfo() const -> ::mozilla::ipc::EndpointProcInfo
{
    return ::mozilla::ipc::EndpointProcInfo{OtherPid(), OtherChildID()};
}

auto PBackgroundSDBConnectionChild::Manager() const -> PBackgroundChild*
{
    return static_cast<PBackgroundChild*>(IProtocol::Manager());
}

auto PBackgroundSDBConnectionChild::ManagedPBackgroundSDBRequestChild(nsTArray<PBackgroundSDBRequestChild*>& aArr) const -> void
{
    mManagedPBackgroundSDBRequestChild.ToArray(aArr);
}

auto PBackgroundSDBConnectionChild::ManagedPBackgroundSDBRequestChild() const -> const ManagedContainer<PBackgroundSDBRequestChild>&
{
    return mManagedPBackgroundSDBRequestChild;
}

auto PBackgroundSDBConnectionChild::ManagedProtocolIds() const -> mozilla::Span<mozilla::ipc::ProtocolId const>
{
    static constexpr ::mozilla::ipc::ProtocolId sIds[] = {
        PBackgroundSDBRequestMsgStart
    };
    return sIds;
}

auto PBackgroundSDBConnectionChild::GetManagedActors(mozilla::ipc::ProtocolId aProtocol) -> UntypedManagedContainer*
{
    switch (aProtocol) {
    case PBackgroundSDBRequestMsgStart:
        return (&(mManagedPBackgroundSDBRequestChild));
    default:
        return nullptr;
    }
}

auto PBackgroundSDBConnectionChild::OpenPBackgroundSDBRequestEndpoint(PBackgroundSDBRequestChild* aActor) -> ManagedEndpoint<PBackgroundSDBRequestParent>
{
    if (!aActor) {
        NS_WARNING("Cannot bind null PBackgroundSDBRequestChild actor");
        return ManagedEndpoint<PBackgroundSDBRequestParent>();
    }

    if (!aActor->SetManagerAndRegister(this)) {
        NS_WARNING("Failed to bind PBackgroundSDBRequestChild actor");
        return ManagedEndpoint<PBackgroundSDBRequestParent>();
    }

    // Mark our actor as awaiting the other side to be bound. This will
    // be cleared when a `MANAGED_ENDPOINT_{DROPPED,BOUND}` message is
    // received.
    aActor->mAwaitingManagedEndpointBind = true;
    return ManagedEndpoint<PBackgroundSDBRequestParent>(mozilla::ipc::PrivateIPDLInterface(), aActor);
}

auto PBackgroundSDBConnectionChild::BindPBackgroundSDBRequestEndpoint(
        ManagedEndpoint<PBackgroundSDBRequestChild> aEndpoint,
        PBackgroundSDBRequestChild* aActor) -> bool
{
    return aEndpoint.Bind(mozilla::ipc::PrivateIPDLInterface(), aActor, this);
}

auto PBackgroundSDBConnectionChild::SendDeleteMe() -> bool
{
    UniquePtr<IPC::Message> msg__ = PBackgroundSDBConnection::Msg_DeleteMe(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};





    if (mozilla::ipc::LoggingEnabledFor("PBackgroundSDBConnection", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PBackgroundSDBConnectionChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PBackgroundSDBConnection::Msg_DeleteMe", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PBackgroundSDBConnectionChild::SendPBackgroundSDBRequestConstructor(const SDBRequestParams& params) -> PBackgroundSDBRequestChild*
{
    PBackgroundSDBRequestChild* actor = (this)->AllocPBackgroundSDBRequestChild(params);
    return SendPBackgroundSDBRequestConstructor(std::move(actor), std::move(params));
}

auto PBackgroundSDBConnectionChild::SendPBackgroundSDBRequestConstructor(
        PBackgroundSDBRequestChild* actor,
        const SDBRequestParams& params) -> PBackgroundSDBRequestChild*
{
    if (!actor) {
        NS_WARNING("Cannot bind null PBackgroundSDBRequestChild actor");
        return nullptr;
    }

    if (!actor->SetManagerAndRegister(this)) {
        NS_WARNING("Failed to bind PBackgroundSDBRequestChild actor");
        return nullptr;
    }


    // Build our constructor message.
    UniquePtr<IPC::Message> msg__ = PBackgroundSDBConnection::Msg_PBackgroundSDBRequestConstructor(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), actor);
    // Sentinel = 'actor'
    ((&(writer__)))->WriteSentinel(102892058);
    IPC::WriteParam((&(writer__)), params);
    // Sentinel = 'params'
    ((&(writer__)))->WriteSentinel(146997893);




    // Notify the other side about the newly created actor. This can
    // fail if our manager has already been destroyed.
    //
    // NOTE: If the send call fails due to toplevel channel teardown,
    // the `IProtocol::ChannelSend` wrapper absorbs the error for us,
    // so we don't tear down actors unexpectedly.

    if (mozilla::ipc::LoggingEnabledFor("PBackgroundSDBConnection", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PBackgroundSDBConnectionChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PBackgroundSDBConnection::Msg_PBackgroundSDBRequestConstructor", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));


    // Warn, destroy the actor, and return null if the message failed to
    // send. Otherwise, return the successfully created actor reference.
    if (!sendok__) {
        NS_WARNING("Error sending PBackgroundSDBRequestChild constructor");
        actor->ActorDisconnected(FailedConstructor);

        return nullptr;
    }
    return actor;
}

auto PBackgroundSDBConnectionChild::DeallocManagee(
        int32_t aProtocolId,
        IProtocol* aListener) -> void
{
    switch (aProtocolId) {
    case PBackgroundSDBRequestMsgStart:
        this->DeallocPBackgroundSDBRequestChild(static_cast<PBackgroundSDBRequestChild*>(aListener));
        return;
    default:
        FatalError("unreached");
        return;
    }
}

auto PBackgroundSDBConnectionChild::OnMessageReceived(const Message& msg__) -> PBackgroundSDBConnectionChild::Result
{
    switch (msg__.type()) {
    case MANAGED_ENDPOINT_BOUND_MESSAGE_TYPE:
        {
            if (!mAwaitingManagedEndpointBind) {
                NS_WARNING("Unexpected managed endpoint lifecycle message after actor bound!");
                return MsgNotAllowed;
            }
            mAwaitingManagedEndpointBind = false;
            return MsgProcessed;
        }
    case MANAGED_ENDPOINT_DROPPED_MESSAGE_TYPE:
        {
            if (!mAwaitingManagedEndpointBind) {
                NS_WARNING("Unexpected managed endpoint lifecycle message after actor bound!");
                return MsgNotAllowed;
            }
            mAwaitingManagedEndpointBind = false;
            this->ActorDisconnected(ManagedEndpointDropped);
            return MsgProcessed;
        }
    case PBackgroundSDBConnection::Reply_PBackgroundSDBRequestConstructor__ID:
        {
            return MsgProcessed;
        }
    case PBackgroundSDBConnection::Msg___delete____ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PBackgroundSDBConnection", mozilla::ipc::ChildSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PBackgroundSDBConnectionChild",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PBackgroundSDBConnection::Msg___delete__", OTHER);

            mozilla::ipc::IPCResult __ok = (this)->Recv__delete__();
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }


            this->ActorDisconnected(Deletion);

            return MsgProcessed;
        }
    case PBackgroundSDBConnection::Msg_AllowToClose__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PBackgroundSDBConnection", mozilla::ipc::ChildSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PBackgroundSDBConnectionChild",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PBackgroundSDBConnection::Msg_AllowToClose", OTHER);

            mozilla::ipc::IPCResult __ok = (this)->RecvAllowToClose();
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PBackgroundSDBConnection::Msg_Closed__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PBackgroundSDBConnection", mozilla::ipc::ChildSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PBackgroundSDBConnectionChild",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PBackgroundSDBConnection::Msg_Closed", OTHER);

            mozilla::ipc::IPCResult __ok = (this)->RecvClosed();
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    default:
        return MsgNotKnown;
    }
}

auto PBackgroundSDBConnectionChild::OnMessageReceived(
        const Message& msg__,
        UniquePtr<Message>& reply__) -> PBackgroundSDBConnectionChild::Result
{
    return MsgNotKnown;
}



} // namespace dom
} // namespace mozilla
namespace IPC {
auto ParamTraits<::mozilla::dom::PBackgroundSDBConnectionChild*>::Write(
        IPC::MessageWriter* aWriter,
        const paramType& aVar) -> void
{
    MOZ_RELEASE_ASSERT(
        aWriter->GetActor(),
        "Cannot serialize managed actors without an actor");

    int32_t id;
    if (!aVar) {
        id = 0;  // kNullActorId
    } else {
        id = aVar->Id();
        if (id == 1) {  // kFreedActorId
            aVar->FatalError("Actor has been |delete|d");
        }
        MOZ_RELEASE_ASSERT(
            aWriter->GetActor()->GetIPCChannel() == aVar->GetIPCChannel(),
            "Actor must be from the same channel as the"
            " actor it's being sent over");
        MOZ_RELEASE_ASSERT(
            aVar->CanSend(),
            "Actor must still be open when sending");
    }

    IPC::WriteParam(aWriter, id);
}

auto ParamTraits<::mozilla::dom::PBackgroundSDBConnectionChild*>::Read(IPC::MessageReader* aReader) -> IPC::ReadResult<paramType>
{
    MOZ_RELEASE_ASSERT(
        aReader->GetActor(),
        "Cannot deserialize managed actors without an actor");
    mozilla::Maybe<mozilla::ipc::IProtocol*> actor = aReader->GetActor()
        ->ReadActor(aReader, true, "PBackgroundSDBConnection", PBackgroundSDBConnectionMsgStart);
    if (actor.isSome()) {
        return static_cast<::mozilla::dom::PBackgroundSDBConnectionChild*>(actor.ref());
    }
    return {};
}

} // namespace IPC
