//
// Automatically generated by ipdlc.
// Edit at your own risk
//


#include "mozilla/dom/PBackgroundLocalStorageCacheParent.h"
#include "mozilla/ProfilerLabels.h"
#include "mozilla/dom/DomSecurityIPCUtils.h"
#include "mozilla/ipc/IPCCore.h"

#include "mozilla/ipc/PBackgroundParent.h"

#include "ipc/IPCMessageUtils.h"
#include "ipc/IPCMessageUtilsSpecializations.h"
#include "nsIFile.h"
#include "mozilla/ipc/Endpoint.h"
#include "mozilla/ipc/ProtocolMessageUtils.h"
#include "mozilla/ipc/ProtocolUtils.h"
#include "mozilla/ipc/ShmemMessageUtils.h"
#include "mozilla/ipc/TaintingIPCUtils.h"

namespace mozilla {
namespace dom {


MOZ_IMPLICIT PBackgroundLocalStorageCacheParent::PBackgroundLocalStorageCacheParent() :
    mozilla::ipc::IProtocol(kProtocolId, mozilla::ipc::ParentSide)
{
    MOZ_COUNT_CTOR(PBackgroundLocalStorageCacheParent);
}

PBackgroundLocalStorageCacheParent::~PBackgroundLocalStorageCacheParent()
{
    MOZ_COUNT_DTOR(PBackgroundLocalStorageCacheParent);
}

auto PBackgroundLocalStorageCacheParent::ActorAlloc() -> void
{
}

auto PBackgroundLocalStorageCacheParent::ActorDealloc() -> void
{
    if (Manager()) {
        Manager()->DeallocManagee(kProtocolId, this);
    }
}

auto PBackgroundLocalStorageCacheParent::OtherPid() const -> ::base::ProcessId
{
    ::base::ProcessId pid =
        ::mozilla::ipc::IProtocol::ToplevelProtocol()->OtherPidMaybeInvalid();
    MOZ_RELEASE_ASSERT(pid != ::base::kInvalidProcessId);
    return pid;
}

auto PBackgroundLocalStorageCacheParent::OtherChildID() const -> ::GeckoChildID
{
    ::GeckoChildID childID =
        ::mozilla::ipc::IProtocol::ToplevelProtocol()->OtherChildIDMaybeInvalid();
    MOZ_RELEASE_ASSERT(childID != -1);
    return childID;
}

auto PBackgroundLocalStorageCacheParent::OtherEndpointProcInfo() const -> ::mozilla::ipc::EndpointProcInfo
{
    return ::mozilla::ipc::EndpointProcInfo{OtherPid(), OtherChildID()};
}

auto PBackgroundLocalStorageCacheParent::Manager() const -> PBackgroundParent*
{
    return static_cast<PBackgroundParent*>(IProtocol::Manager());
}

auto PBackgroundLocalStorageCacheParent::ManagedProtocolIds() const -> mozilla::Span<mozilla::ipc::ProtocolId const>
{
    return {};
}

auto PBackgroundLocalStorageCacheParent::GetManagedActors(mozilla::ipc::ProtocolId aProtocol) -> UntypedManagedContainer*
{
    switch (aProtocol) {
    default:
        return nullptr;
    }
}

auto PBackgroundLocalStorageCacheParent::SendObserve(
        const PrincipalInfo& principalInfo,
        const PrincipalInfo& cachePrincipalInfo,
        const uint32_t& privateBrowsingId,
        const nsAString& documentURI,
        const nsAString& key,
        const nsAString& oldValue,
        const nsAString& newValue) -> bool
{
    UniquePtr<IPC::Message> msg__ = PBackgroundLocalStorageCache::Msg_Observe(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), principalInfo);
    // Sentinel = 'principalInfo'
    ((&(writer__)))->WriteSentinel(633472335);
    IPC::WriteParam((&(writer__)), cachePrincipalInfo);
    // Sentinel = 'cachePrincipalInfo'
    ((&(writer__)))->WriteSentinel(1130104611);
    IPC::WriteParam((&(writer__)), privateBrowsingId);
    // Sentinel = 'privateBrowsingId'
    ((&(writer__)))->WriteSentinel(1071711988);
    IPC::WriteParam((&(writer__)), documentURI);
    // Sentinel = 'documentURI'
    ((&(writer__)))->WriteSentinel(453706832);
    IPC::WriteParam((&(writer__)), key);
    // Sentinel = 'key'
    ((&(writer__)))->WriteSentinel(42402122);
    IPC::WriteParam((&(writer__)), oldValue);
    // Sentinel = 'oldValue'
    ((&(writer__)))->WriteSentinel(244384573);
    IPC::WriteParam((&(writer__)), newValue);
    // Sentinel = 'newValue'
    ((&(writer__)))->WriteSentinel(248120136);




    if (mozilla::ipc::LoggingEnabledFor("PBackgroundLocalStorageCache", mozilla::ipc::ParentSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PBackgroundLocalStorageCacheParent",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PBackgroundLocalStorageCache::Msg_Observe", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PBackgroundLocalStorageCacheParent::Send__delete__(PBackgroundLocalStorageCacheParent* actor) -> bool
{
    if (!actor || !actor->CanSend()) {
        NS_WARNING("Attempt to __delete__ missing or closed actor");
        return false;
    }
    UniquePtr<IPC::Message> msg__ = PBackgroundLocalStorageCache::Msg___delete__((actor)->Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            actor};




    if (mozilla::ipc::LoggingEnabledFor("PBackgroundLocalStorageCache", mozilla::ipc::ParentSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PBackgroundLocalStorageCacheParent",
            actor->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PBackgroundLocalStorageCache::Msg___delete__", OTHER);

    bool sendok__ = (actor)->ChannelSend(std::move(msg__));

    actor->ActorDisconnected(Deletion);
    return sendok__;
}

auto PBackgroundLocalStorageCacheParent::DeallocManagee(
        int32_t aProtocolId,
        IProtocol* aListener) -> void
{
    FatalError("unreached");
    return;
}

auto PBackgroundLocalStorageCacheParent::OnMessageReceived(const Message& msg__) -> PBackgroundLocalStorageCacheParent::Result
{
    switch (msg__.type()) {
    case MANAGED_ENDPOINT_BOUND_MESSAGE_TYPE:
        {
            if (!mAwaitingManagedEndpointBind) {
                NS_WARNING("Unexpected managed endpoint lifecycle message after actor bound!");
                return MsgNotAllowed;
            }
            mAwaitingManagedEndpointBind = false;
            return MsgProcessed;
        }
    case MANAGED_ENDPOINT_DROPPED_MESSAGE_TYPE:
        {
            if (!mAwaitingManagedEndpointBind) {
                NS_WARNING("Unexpected managed endpoint lifecycle message after actor bound!");
                return MsgNotAllowed;
            }
            mAwaitingManagedEndpointBind = false;
            this->ActorDisconnected(ManagedEndpointDropped);
            return MsgProcessed;
        }
    case PBackgroundLocalStorageCache::Msg_DeleteMe__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PBackgroundLocalStorageCache", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PBackgroundLocalStorageCacheParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PBackgroundLocalStorageCache::Msg_DeleteMe", OTHER);

            mozilla::ipc::IPCResult __ok = (this)->RecvDeleteMe();
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PBackgroundLocalStorageCache::Msg_Notify__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PBackgroundLocalStorageCache", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PBackgroundLocalStorageCacheParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PBackgroundLocalStorageCache::Msg_Notify", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__documentURI = IPC::ReadParam<nsString>((&(reader__)));
            if (!maybe__documentURI) {
                FatalError("Error deserializing 'nsString'");
                return MsgValueError;

            }
            auto& documentURI = *maybe__documentURI;
            // Sentinel = 'documentURI'
            if ((!(((&(reader__)))->ReadSentinel(453706832)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'nsString'");
                return MsgValueError;
            }
            auto maybe__key = IPC::ReadParam<nsString>((&(reader__)));
            if (!maybe__key) {
                FatalError("Error deserializing 'nsString'");
                return MsgValueError;

            }
            auto& key = *maybe__key;
            // Sentinel = 'key'
            if ((!(((&(reader__)))->ReadSentinel(42402122)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'nsString'");
                return MsgValueError;
            }
            auto maybe__oldValue = IPC::ReadParam<nsString>((&(reader__)));
            if (!maybe__oldValue) {
                FatalError("Error deserializing 'nsString'");
                return MsgValueError;

            }
            auto& oldValue = *maybe__oldValue;
            // Sentinel = 'oldValue'
            if ((!(((&(reader__)))->ReadSentinel(244384573)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'nsString'");
                return MsgValueError;
            }
            auto maybe__newValue = IPC::ReadParam<nsString>((&(reader__)));
            if (!maybe__newValue) {
                FatalError("Error deserializing 'nsString'");
                return MsgValueError;

            }
            auto& newValue = *maybe__newValue;
            // Sentinel = 'newValue'
            if ((!(((&(reader__)))->ReadSentinel(248120136)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'nsString'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::IPCResult __ok = (this)->RecvNotify(std::move(documentURI), std::move(key), std::move(oldValue), std::move(newValue));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PBackgroundLocalStorageCache::Reply___delete____ID:
        {
            return MsgProcessed;
        }
    default:
        return MsgNotKnown;
    }
}

auto PBackgroundLocalStorageCacheParent::OnMessageReceived(
        const Message& msg__,
        UniquePtr<Message>& reply__) -> PBackgroundLocalStorageCacheParent::Result
{
    return MsgNotKnown;
}



} // namespace dom
} // namespace mozilla
namespace IPC {
auto ParamTraits<::mozilla::dom::PBackgroundLocalStorageCacheParent*>::Write(
        IPC::MessageWriter* aWriter,
        const paramType& aVar) -> void
{
    MOZ_RELEASE_ASSERT(
        aWriter->GetActor(),
        "Cannot serialize managed actors without an actor");

    int32_t id;
    if (!aVar) {
        id = 0;  // kNullActorId
    } else {
        id = aVar->Id();
        if (id == 1) {  // kFreedActorId
            aVar->FatalError("Actor has been |delete|d");
        }
        MOZ_RELEASE_ASSERT(
            aWriter->GetActor()->GetIPCChannel() == aVar->GetIPCChannel(),
            "Actor must be from the same channel as the"
            " actor it's being sent over");
        MOZ_RELEASE_ASSERT(
            aVar->CanSend(),
            "Actor must still be open when sending");
    }

    IPC::WriteParam(aWriter, id);
}

auto ParamTraits<::mozilla::dom::PBackgroundLocalStorageCacheParent*>::Read(IPC::MessageReader* aReader) -> IPC::ReadResult<paramType>
{
    MOZ_RELEASE_ASSERT(
        aReader->GetActor(),
        "Cannot deserialize managed actors without an actor");
    mozilla::Maybe<mozilla::ipc::IProtocol*> actor = aReader->GetActor()
        ->ReadActor(aReader, true, "PBackgroundLocalStorageCache", PBackgroundLocalStorageCacheMsgStart);
    if (actor.isSome()) {
        return static_cast<::mozilla::dom::PBackgroundLocalStorageCacheParent*>(actor.ref());
    }
    return {};
}

} // namespace IPC
