//
// Automatically generated by ipdlc.
// Edit at your own risk
//


#include "mozilla/dom/PBackgroundLocalStorageCacheChild.h"
#include "mozilla/ProfilerLabels.h"
#include "mozilla/dom/DomSecurityIPCUtils.h"
#include "mozilla/ipc/IPCCore.h"

#include "mozilla/ipc/PBackgroundChild.h"

#include "ipc/IPCMessageUtils.h"
#include "ipc/IPCMessageUtilsSpecializations.h"
#include "nsIFile.h"
#include "mozilla/ipc/Endpoint.h"
#include "mozilla/ipc/ProtocolMessageUtils.h"
#include "mozilla/ipc/ProtocolUtils.h"
#include "mozilla/ipc/ShmemMessageUtils.h"
#include "mozilla/ipc/TaintingIPCUtils.h"

namespace mozilla {
namespace dom {


auto PBackgroundLocalStorageCacheChild::Recv__delete__() -> mozilla::ipc::IPCResult
{
    return IPC_OK();
}

MOZ_IMPLICIT PBackgroundLocalStorageCacheChild::PBackgroundLocalStorageCacheChild() :
    mozilla::ipc::IProtocol(kProtocolId, mozilla::ipc::ChildSide)
{
    MOZ_COUNT_CTOR(PBackgroundLocalStorageCacheChild);
}

PBackgroundLocalStorageCacheChild::~PBackgroundLocalStorageCacheChild()
{
    MOZ_COUNT_DTOR(PBackgroundLocalStorageCacheChild);
}

auto PBackgroundLocalStorageCacheChild::ActorAlloc() -> void
{
}

auto PBackgroundLocalStorageCacheChild::ActorDealloc() -> void
{
    if (Manager()) {
        Manager()->DeallocManagee(kProtocolId, this);
    }
}

auto PBackgroundLocalStorageCacheChild::OtherPid() const -> ::base::ProcessId
{
    ::base::ProcessId pid =
        ::mozilla::ipc::IProtocol::ToplevelProtocol()->OtherPidMaybeInvalid();
    MOZ_RELEASE_ASSERT(pid != ::base::kInvalidProcessId);
    return pid;
}

auto PBackgroundLocalStorageCacheChild::OtherChildID() const -> ::GeckoChildID
{
    ::GeckoChildID childID =
        ::mozilla::ipc::IProtocol::ToplevelProtocol()->OtherChildIDMaybeInvalid();
    MOZ_RELEASE_ASSERT(childID != -1);
    return childID;
}

auto PBackgroundLocalStorageCacheChild::OtherEndpointProcInfo() const -> ::mozilla::ipc::EndpointProcInfo
{
    return ::mozilla::ipc::EndpointProcInfo{OtherPid(), OtherChildID()};
}

auto PBackgroundLocalStorageCacheChild::Manager() const -> PBackgroundChild*
{
    return static_cast<PBackgroundChild*>(IProtocol::Manager());
}

auto PBackgroundLocalStorageCacheChild::ManagedProtocolIds() const -> mozilla::Span<mozilla::ipc::ProtocolId const>
{
    return {};
}

auto PBackgroundLocalStorageCacheChild::GetManagedActors(mozilla::ipc::ProtocolId aProtocol) -> UntypedManagedContainer*
{
    switch (aProtocol) {
    default:
        return nullptr;
    }
}

auto PBackgroundLocalStorageCacheChild::SendDeleteMe() -> bool
{
    UniquePtr<IPC::Message> msg__ = PBackgroundLocalStorageCache::Msg_DeleteMe(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};





    if (mozilla::ipc::LoggingEnabledFor("PBackgroundLocalStorageCache", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PBackgroundLocalStorageCacheChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PBackgroundLocalStorageCache::Msg_DeleteMe", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PBackgroundLocalStorageCacheChild::SendNotify(
        const nsAString& documentURI,
        const nsAString& key,
        const nsAString& oldValue,
        const nsAString& newValue) -> bool
{
    UniquePtr<IPC::Message> msg__ = PBackgroundLocalStorageCache::Msg_Notify(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), documentURI);
    // Sentinel = 'documentURI'
    ((&(writer__)))->WriteSentinel(453706832);
    IPC::WriteParam((&(writer__)), key);
    // Sentinel = 'key'
    ((&(writer__)))->WriteSentinel(42402122);
    IPC::WriteParam((&(writer__)), oldValue);
    // Sentinel = 'oldValue'
    ((&(writer__)))->WriteSentinel(244384573);
    IPC::WriteParam((&(writer__)), newValue);
    // Sentinel = 'newValue'
    ((&(writer__)))->WriteSentinel(248120136);




    if (mozilla::ipc::LoggingEnabledFor("PBackgroundLocalStorageCache", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PBackgroundLocalStorageCacheChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PBackgroundLocalStorageCache::Msg_Notify", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PBackgroundLocalStorageCacheChild::DeallocManagee(
        int32_t aProtocolId,
        IProtocol* aListener) -> void
{
    FatalError("unreached");
    return;
}

auto PBackgroundLocalStorageCacheChild::OnMessageReceived(const Message& msg__) -> PBackgroundLocalStorageCacheChild::Result
{
    switch (msg__.type()) {
    case MANAGED_ENDPOINT_BOUND_MESSAGE_TYPE:
        {
            if (!mAwaitingManagedEndpointBind) {
                NS_WARNING("Unexpected managed endpoint lifecycle message after actor bound!");
                return MsgNotAllowed;
            }
            mAwaitingManagedEndpointBind = false;
            return MsgProcessed;
        }
    case MANAGED_ENDPOINT_DROPPED_MESSAGE_TYPE:
        {
            if (!mAwaitingManagedEndpointBind) {
                NS_WARNING("Unexpected managed endpoint lifecycle message after actor bound!");
                return MsgNotAllowed;
            }
            mAwaitingManagedEndpointBind = false;
            this->ActorDisconnected(ManagedEndpointDropped);
            return MsgProcessed;
        }
    case PBackgroundLocalStorageCache::Msg_Observe__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PBackgroundLocalStorageCache", mozilla::ipc::ChildSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PBackgroundLocalStorageCacheChild",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PBackgroundLocalStorageCache::Msg_Observe", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__principalInfo = IPC::ReadParam<PrincipalInfo>((&(reader__)));
            if (!maybe__principalInfo) {
                FatalError("Error deserializing 'PrincipalInfo'");
                return MsgValueError;

            }
            auto& principalInfo = *maybe__principalInfo;
            // Sentinel = 'principalInfo'
            if ((!(((&(reader__)))->ReadSentinel(633472335)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'PrincipalInfo'");
                return MsgValueError;
            }
            auto maybe__cachePrincipalInfo = IPC::ReadParam<PrincipalInfo>((&(reader__)));
            if (!maybe__cachePrincipalInfo) {
                FatalError("Error deserializing 'PrincipalInfo'");
                return MsgValueError;

            }
            auto& cachePrincipalInfo = *maybe__cachePrincipalInfo;
            // Sentinel = 'cachePrincipalInfo'
            if ((!(((&(reader__)))->ReadSentinel(1130104611)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'PrincipalInfo'");
                return MsgValueError;
            }
            auto maybe__privateBrowsingId = IPC::ReadParam<uint32_t>((&(reader__)));
            if (!maybe__privateBrowsingId) {
                FatalError("Error deserializing 'uint32_t'");
                return MsgValueError;

            }
            auto& privateBrowsingId = *maybe__privateBrowsingId;
            // Sentinel = 'privateBrowsingId'
            if ((!(((&(reader__)))->ReadSentinel(1071711988)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'uint32_t'");
                return MsgValueError;
            }
            auto maybe__documentURI = IPC::ReadParam<nsString>((&(reader__)));
            if (!maybe__documentURI) {
                FatalError("Error deserializing 'nsString'");
                return MsgValueError;

            }
            auto& documentURI = *maybe__documentURI;
            // Sentinel = 'documentURI'
            if ((!(((&(reader__)))->ReadSentinel(453706832)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'nsString'");
                return MsgValueError;
            }
            auto maybe__key = IPC::ReadParam<nsString>((&(reader__)));
            if (!maybe__key) {
                FatalError("Error deserializing 'nsString'");
                return MsgValueError;

            }
            auto& key = *maybe__key;
            // Sentinel = 'key'
            if ((!(((&(reader__)))->ReadSentinel(42402122)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'nsString'");
                return MsgValueError;
            }
            auto maybe__oldValue = IPC::ReadParam<nsString>((&(reader__)));
            if (!maybe__oldValue) {
                FatalError("Error deserializing 'nsString'");
                return MsgValueError;

            }
            auto& oldValue = *maybe__oldValue;
            // Sentinel = 'oldValue'
            if ((!(((&(reader__)))->ReadSentinel(244384573)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'nsString'");
                return MsgValueError;
            }
            auto maybe__newValue = IPC::ReadParam<nsString>((&(reader__)));
            if (!maybe__newValue) {
                FatalError("Error deserializing 'nsString'");
                return MsgValueError;

            }
            auto& newValue = *maybe__newValue;
            // Sentinel = 'newValue'
            if ((!(((&(reader__)))->ReadSentinel(248120136)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'nsString'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::IPCResult __ok = (this)->RecvObserve(std::move(principalInfo), std::move(cachePrincipalInfo), std::move(privateBrowsingId), std::move(documentURI), std::move(key), std::move(oldValue), std::move(newValue));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PBackgroundLocalStorageCache::Msg___delete____ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PBackgroundLocalStorageCache", mozilla::ipc::ChildSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PBackgroundLocalStorageCacheChild",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PBackgroundLocalStorageCache::Msg___delete__", OTHER);

            mozilla::ipc::IPCResult __ok = (this)->Recv__delete__();
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }


            this->ActorDisconnected(Deletion);

            return MsgProcessed;
        }
    default:
        return MsgNotKnown;
    }
}

auto PBackgroundLocalStorageCacheChild::OnMessageReceived(
        const Message& msg__,
        UniquePtr<Message>& reply__) -> PBackgroundLocalStorageCacheChild::Result
{
    return MsgNotKnown;
}



} // namespace dom
} // namespace mozilla
namespace IPC {
auto ParamTraits<::mozilla::dom::PBackgroundLocalStorageCacheChild*>::Write(
        IPC::MessageWriter* aWriter,
        const paramType& aVar) -> void
{
    MOZ_RELEASE_ASSERT(
        aWriter->GetActor(),
        "Cannot serialize managed actors without an actor");

    int32_t id;
    if (!aVar) {
        id = 0;  // kNullActorId
    } else {
        id = aVar->Id();
        if (id == 1) {  // kFreedActorId
            aVar->FatalError("Actor has been |delete|d");
        }
        MOZ_RELEASE_ASSERT(
            aWriter->GetActor()->GetIPCChannel() == aVar->GetIPCChannel(),
            "Actor must be from the same channel as the"
            " actor it's being sent over");
        MOZ_RELEASE_ASSERT(
            aVar->CanSend(),
            "Actor must still be open when sending");
    }

    IPC::WriteParam(aWriter, id);
}

auto ParamTraits<::mozilla::dom::PBackgroundLocalStorageCacheChild*>::Read(IPC::MessageReader* aReader) -> IPC::ReadResult<paramType>
{
    MOZ_RELEASE_ASSERT(
        aReader->GetActor(),
        "Cannot deserialize managed actors without an actor");
    mozilla::Maybe<mozilla::ipc::IProtocol*> actor = aReader->GetActor()
        ->ReadActor(aReader, true, "PBackgroundLocalStorageCache", PBackgroundLocalStorageCacheMsgStart);
    if (actor.isSome()) {
        return static_cast<::mozilla::dom::PBackgroundLocalStorageCacheChild*>(actor.ref());
    }
    return {};
}

} // namespace IPC
