//
// Automatically generated by ipdlc.
// Edit at your own risk
//


#include "mozilla/dom/PBackgroundLSDatabaseParent.h"
#include "mozilla/ProfilerLabels.h"
#include "mozilla/dom/localstorage/SerializationHelpers.h"

#include "mozilla/dom/PBackgroundLSSnapshotParent.h"

#include "ipc/IPCMessageUtils.h"
#include "ipc/IPCMessageUtilsSpecializations.h"
#include "nsIFile.h"
#include "mozilla/ipc/Endpoint.h"
#include "mozilla/ipc/ProtocolMessageUtils.h"
#include "mozilla/ipc/ProtocolUtils.h"
#include "mozilla/ipc/ShmemMessageUtils.h"
#include "mozilla/ipc/TaintingIPCUtils.h"

namespace mozilla {
namespace dom {


auto PBackgroundLSDatabaseParent::RecvPBackgroundLSSnapshotConstructor(
        PBackgroundLSSnapshotParent* actor,
        const nsAString& documentURI,
        const nsAString& key,
        const bool& increasePeakUsage,
        const int64_t& minSize,
        LSSnapshotInitInfo* initInfo) -> mozilla::ipc::IPCResult
{
    return IPC_OK();
}

auto PBackgroundLSDatabaseParent::ProcessingError(
        Result aCode,
        const char* aReason) -> void
{
}

auto PBackgroundLSDatabaseParent::ShouldContinueFromReplyTimeout() -> bool
{
    return true;
}

MOZ_IMPLICIT PBackgroundLSDatabaseParent::PBackgroundLSDatabaseParent() :
    mozilla::ipc::IToplevelProtocol("PBackgroundLSDatabaseParent", kProtocolId, mozilla::ipc::ParentSide)
{
    MOZ_COUNT_CTOR(PBackgroundLSDatabaseParent);
}

PBackgroundLSDatabaseParent::~PBackgroundLSDatabaseParent()
{
    MOZ_COUNT_DTOR(PBackgroundLSDatabaseParent);
}

auto PBackgroundLSDatabaseParent::ActorAlloc() -> void
{
    MOZ_RELEASE_ASSERT(XRE_IsParentProcess(), "Invalid process for `PBackgroundLSDatabaseParent'");
    AddRef();
}

auto PBackgroundLSDatabaseParent::ActorDealloc() -> void
{
    Release();
}

auto PBackgroundLSDatabaseParent::ManagedPBackgroundLSSnapshotParent(nsTArray<PBackgroundLSSnapshotParent*>& aArr) const -> void
{
    mManagedPBackgroundLSSnapshotParent.ToArray(aArr);
}

auto PBackgroundLSDatabaseParent::ManagedPBackgroundLSSnapshotParent() const -> const ManagedContainer<PBackgroundLSSnapshotParent>&
{
    return mManagedPBackgroundLSSnapshotParent;
}

auto PBackgroundLSDatabaseParent::ManagedProtocolIds() const -> mozilla::Span<mozilla::ipc::ProtocolId const>
{
    static constexpr ::mozilla::ipc::ProtocolId sIds[] = {
        PBackgroundLSSnapshotMsgStart
    };
    return sIds;
}

auto PBackgroundLSDatabaseParent::GetManagedActors(mozilla::ipc::ProtocolId aProtocol) -> UntypedManagedContainer*
{
    switch (aProtocol) {
    case PBackgroundLSSnapshotMsgStart:
        return (&(mManagedPBackgroundLSSnapshotParent));
    default:
        return nullptr;
    }
}

auto PBackgroundLSDatabaseParent::OpenPBackgroundLSSnapshotEndpoint(PBackgroundLSSnapshotParent* aActor) -> ManagedEndpoint<PBackgroundLSSnapshotChild>
{
    if (!aActor) {
        NS_WARNING("Cannot bind null PBackgroundLSSnapshotParent actor");
        return ManagedEndpoint<PBackgroundLSSnapshotChild>();
    }

    if (!aActor->SetManagerAndRegister(this)) {
        NS_WARNING("Failed to bind PBackgroundLSSnapshotParent actor");
        return ManagedEndpoint<PBackgroundLSSnapshotChild>();
    }

    // Mark our actor as awaiting the other side to be bound. This will
    // be cleared when a `MANAGED_ENDPOINT_{DROPPED,BOUND}` message is
    // received.
    aActor->mAwaitingManagedEndpointBind = true;
    return ManagedEndpoint<PBackgroundLSSnapshotChild>(mozilla::ipc::PrivateIPDLInterface(), aActor);
}

auto PBackgroundLSDatabaseParent::BindPBackgroundLSSnapshotEndpoint(
        ManagedEndpoint<PBackgroundLSSnapshotParent> aEndpoint,
        PBackgroundLSSnapshotParent* aActor) -> bool
{
    return aEndpoint.Bind(mozilla::ipc::PrivateIPDLInterface(), aActor, this);
}

auto PBackgroundLSDatabaseParent::SendRequestAllowToClose() -> bool
{
    UniquePtr<IPC::Message> msg__ = PBackgroundLSDatabase::Msg_RequestAllowToClose(MSG_ROUTING_CONTROL);
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};





    if (mozilla::ipc::LoggingEnabledFor("PBackgroundLSDatabase", mozilla::ipc::ParentSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PBackgroundLSDatabaseParent",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PBackgroundLSDatabase::Msg_RequestAllowToClose", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PBackgroundLSDatabaseParent::DeallocManagee(
        int32_t aProtocolId,
        IProtocol* aListener) -> void
{
    switch (aProtocolId) {
    case PBackgroundLSSnapshotMsgStart:
        this->DeallocPBackgroundLSSnapshotParent(static_cast<PBackgroundLSSnapshotParent*>(aListener));
        return;
    default:
        FatalError("unreached");
        return;
    }
}

auto PBackgroundLSDatabaseParent::OnMessageReceived(const Message& msg__) -> PBackgroundLSDatabaseParent::Result
{
    int32_t route__ = msg__.routing_id();
    if (MSG_ROUTING_CONTROL != route__) {
        IProtocol* routed__ = Lookup(route__);
        if (!routed__ || !routed__->GetLifecycleProxy()) {
            if (mozilla::ipc::LoggingEnabledFor("PBackgroundLSDatabase", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PBackgroundLSDatabaseParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Ignored message for dead actor",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eSending);
            }
            return MsgProcessed;

        }

        RefPtr<mozilla::ipc::ActorLifecycleProxy> proxy__ =
            routed__->GetLifecycleProxy();
        return proxy__->Get()->OnMessageReceived(msg__);
    }

    switch (msg__.type()) {
    case PBackgroundLSDatabase::Msg_AllowToClose__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PBackgroundLSDatabase", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PBackgroundLSDatabaseParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PBackgroundLSDatabase::Msg_AllowToClose", OTHER);

            mozilla::ipc::IPCResult __ok = (this)->RecvAllowToClose();
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    default:
        return MsgNotKnown;
    case SHMEM_CREATED_MESSAGE_TYPE:
        {
            if (!ShmemCreated(msg__)) {
                return MsgPayloadError;
            }
            return MsgProcessed;
        }
    case SHMEM_DESTROYED_MESSAGE_TYPE:
        {
            if (!ShmemDestroyed(msg__)) {
                return MsgPayloadError;
            }
            return MsgProcessed;
        }
    }
}

auto PBackgroundLSDatabaseParent::OnMessageReceived(
        const Message& msg__,
        UniquePtr<Message>& reply__) -> PBackgroundLSDatabaseParent::Result
{
    int32_t route__ = msg__.routing_id();
    if (MSG_ROUTING_CONTROL != route__) {
        IProtocol* routed__ = Lookup(route__);
        if (!routed__ || !routed__->GetLifecycleProxy()) {
            return MsgDropped;

        }

        RefPtr<mozilla::ipc::ActorLifecycleProxy> proxy__ =
            routed__->GetLifecycleProxy();
        return proxy__->Get()->OnMessageReceived(msg__, reply__);
    }

    switch (msg__.type()) {
    case PBackgroundLSDatabase::Msg_PBackgroundLSSnapshotConstructor__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PBackgroundLSDatabase", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PBackgroundLSDatabaseParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PBackgroundLSDatabase::Msg_PBackgroundLSSnapshotConstructor", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__handle__ = IPC::ReadParam<ActorHandle>((&(reader__)));
            if (!maybe__handle__) {
                FatalError("Error deserializing 'ActorHandle'");
                return MsgValueError;

            }
            auto& handle__ = *maybe__handle__;
            // Sentinel = 'actor'
            if ((!(((&(reader__)))->ReadSentinel(102892058)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'ActorHandle'");
                return MsgValueError;
            }
            auto maybe__documentURI = IPC::ReadParam<nsString>((&(reader__)));
            if (!maybe__documentURI) {
                FatalError("Error deserializing 'nsString'");
                return MsgValueError;

            }
            auto& documentURI = *maybe__documentURI;
            // Sentinel = 'documentURI'
            if ((!(((&(reader__)))->ReadSentinel(453706832)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'nsString'");
                return MsgValueError;
            }
            auto maybe__key = IPC::ReadParam<nsString>((&(reader__)));
            if (!maybe__key) {
                FatalError("Error deserializing 'nsString'");
                return MsgValueError;

            }
            auto& key = *maybe__key;
            // Sentinel = 'key'
            if ((!(((&(reader__)))->ReadSentinel(42402122)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'nsString'");
                return MsgValueError;
            }
            auto maybe__increasePeakUsage = IPC::ReadParam<bool>((&(reader__)));
            if (!maybe__increasePeakUsage) {
                FatalError("Error deserializing 'bool'");
                return MsgValueError;

            }
            auto& increasePeakUsage = *maybe__increasePeakUsage;
            // Sentinel = 'increasePeakUsage'
            if ((!(((&(reader__)))->ReadSentinel(1030686401)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'bool'");
                return MsgValueError;
            }
            auto maybe__minSize = IPC::ReadParam<int64_t>((&(reader__)));
            if (!maybe__minSize) {
                FatalError("Error deserializing 'int64_t'");
                return MsgValueError;

            }
            auto& minSize = *maybe__minSize;
            // Sentinel = 'minSize'
            if ((!(((&(reader__)))->ReadSentinel(192807648)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'int64_t'");
                return MsgValueError;
            }
            reader__.EndRead();
            LSSnapshotInitInfo initInfo{};
            PBackgroundLSSnapshotParent* actor = (this)->AllocPBackgroundLSSnapshotParent(documentURI, key, increasePeakUsage, minSize, (&(initInfo)));
            if (!actor) {
                NS_WARNING("Cannot bind null PBackgroundLSSnapshotParent actor");
                return MsgValueError;
            }

            if (!actor->SetManagerAndRegister(this, (handle__).mId)) {
                NS_WARNING("Failed to bind PBackgroundLSSnapshotParent actor");
                return MsgValueError;
            }

            int32_t id__ = MSG_ROUTING_CONTROL;
            mozilla::ipc::IPCResult __ok = (this)->RecvPBackgroundLSSnapshotConstructor(std::move(actor), std::move(documentURI), std::move(key), std::move(increasePeakUsage), std::move(minSize), (&(initInfo)));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }
            reply__ = PBackgroundLSDatabase::Reply_PBackgroundLSSnapshotConstructor(id__);
            IPC::MessageWriter writer__{
                    (*(reply__)),
                    this};

            IPC::WriteParam((&(writer__)), initInfo);
            // Sentinel = 'initInfo'
            ((&(writer__)))->WriteSentinel(246743873);

            if (mozilla::ipc::LoggingEnabledFor("PBackgroundLSDatabase", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PBackgroundLSDatabaseParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Sending reply ",
                    reply__->type(),
                    mozilla::ipc::MessageDirection::eSending);
            }

            return MsgProcessed;
        }
    default:
        return MsgNotKnown;
    }
}



} // namespace dom
} // namespace mozilla
namespace IPC {
auto ParamTraits<::mozilla::dom::PBackgroundLSDatabaseParent*>::Write(
        IPC::MessageWriter* aWriter,
        const paramType& aVar) -> void
{
    MOZ_RELEASE_ASSERT(
        aWriter->GetActor(),
        "Cannot serialize managed actors without an actor");

    int32_t id;
    if (!aVar) {
        id = 0;  // kNullActorId
    } else {
        id = aVar->Id();
        if (id == 1) {  // kFreedActorId
            aVar->FatalError("Actor has been |delete|d");
        }
        MOZ_RELEASE_ASSERT(
            aWriter->GetActor()->GetIPCChannel() == aVar->GetIPCChannel(),
            "Actor must be from the same channel as the"
            " actor it's being sent over");
        MOZ_RELEASE_ASSERT(
            aVar->CanSend(),
            "Actor must still be open when sending");
    }

    IPC::WriteParam(aWriter, id);
}

auto ParamTraits<::mozilla::dom::PBackgroundLSDatabaseParent*>::Read(IPC::MessageReader* aReader) -> IPC::ReadResult<paramType>
{
    MOZ_RELEASE_ASSERT(
        aReader->GetActor(),
        "Cannot deserialize managed actors without an actor");
    mozilla::Maybe<mozilla::ipc::IProtocol*> actor = aReader->GetActor()
        ->ReadActor(aReader, true, "PBackgroundLSDatabase", PBackgroundLSDatabaseMsgStart);
    if (actor.isSome()) {
        return static_cast<::mozilla::dom::PBackgroundLSDatabaseParent*>(actor.ref());
    }
    return {};
}

} // namespace IPC
