//
// Automatically generated by ipdlc.
// Edit at your own risk
//


#include "mozilla/dom/PBackgroundLSDatabaseChild.h"
#include "mozilla/ProfilerLabels.h"
#include "mozilla/ProfilerMarkers.h"
#include "mozilla/dom/localstorage/SerializationHelpers.h"

#include "mozilla/dom/PBackgroundLSSnapshotChild.h"

#include "ipc/IPCMessageUtils.h"
#include "ipc/IPCMessageUtilsSpecializations.h"
#include "nsIFile.h"
#include "mozilla/ipc/Endpoint.h"
#include "mozilla/ipc/ProtocolMessageUtils.h"
#include "mozilla/ipc/ProtocolUtils.h"
#include "mozilla/ipc/ShmemMessageUtils.h"
#include "mozilla/ipc/TaintingIPCUtils.h"

namespace mozilla {
namespace dom {


auto PBackgroundLSDatabaseChild::ProcessingError(
        Result aCode,
        const char* aReason) -> void
{
}

auto PBackgroundLSDatabaseChild::ShouldContinueFromReplyTimeout() -> bool
{
    return true;
}

MOZ_IMPLICIT PBackgroundLSDatabaseChild::PBackgroundLSDatabaseChild() :
    mozilla::ipc::IToplevelProtocol("PBackgroundLSDatabaseChild", kProtocolId, mozilla::ipc::ChildSide)
{
    MOZ_COUNT_CTOR(PBackgroundLSDatabaseChild);
}

PBackgroundLSDatabaseChild::~PBackgroundLSDatabaseChild()
{
    MOZ_COUNT_DTOR(PBackgroundLSDatabaseChild);
}

auto PBackgroundLSDatabaseChild::ActorAlloc() -> void
{
    MOZ_RELEASE_ASSERT(XRE_IsParentProcess() || XRE_IsContentProcess(), "Invalid process for `PBackgroundLSDatabaseChild'");
    AddRef();
}

auto PBackgroundLSDatabaseChild::ActorDealloc() -> void
{
    Release();
}

auto PBackgroundLSDatabaseChild::ManagedPBackgroundLSSnapshotChild(nsTArray<PBackgroundLSSnapshotChild*>& aArr) const -> void
{
    mManagedPBackgroundLSSnapshotChild.ToArray(aArr);
}

auto PBackgroundLSDatabaseChild::ManagedPBackgroundLSSnapshotChild() const -> const ManagedContainer<PBackgroundLSSnapshotChild>&
{
    return mManagedPBackgroundLSSnapshotChild;
}

auto PBackgroundLSDatabaseChild::ManagedProtocolIds() const -> mozilla::Span<mozilla::ipc::ProtocolId const>
{
    static constexpr ::mozilla::ipc::ProtocolId sIds[] = {
        PBackgroundLSSnapshotMsgStart
    };
    return sIds;
}

auto PBackgroundLSDatabaseChild::GetManagedActors(mozilla::ipc::ProtocolId aProtocol) -> UntypedManagedContainer*
{
    switch (aProtocol) {
    case PBackgroundLSSnapshotMsgStart:
        return (&(mManagedPBackgroundLSSnapshotChild));
    default:
        return nullptr;
    }
}

auto PBackgroundLSDatabaseChild::OpenPBackgroundLSSnapshotEndpoint(PBackgroundLSSnapshotChild* aActor) -> ManagedEndpoint<PBackgroundLSSnapshotParent>
{
    if (!aActor) {
        NS_WARNING("Cannot bind null PBackgroundLSSnapshotChild actor");
        return ManagedEndpoint<PBackgroundLSSnapshotParent>();
    }

    if (!aActor->SetManagerAndRegister(this)) {
        NS_WARNING("Failed to bind PBackgroundLSSnapshotChild actor");
        return ManagedEndpoint<PBackgroundLSSnapshotParent>();
    }

    // Mark our actor as awaiting the other side to be bound. This will
    // be cleared when a `MANAGED_ENDPOINT_{DROPPED,BOUND}` message is
    // received.
    aActor->mAwaitingManagedEndpointBind = true;
    return ManagedEndpoint<PBackgroundLSSnapshotParent>(mozilla::ipc::PrivateIPDLInterface(), aActor);
}

auto PBackgroundLSDatabaseChild::BindPBackgroundLSSnapshotEndpoint(
        ManagedEndpoint<PBackgroundLSSnapshotChild> aEndpoint,
        PBackgroundLSSnapshotChild* aActor) -> bool
{
    return aEndpoint.Bind(mozilla::ipc::PrivateIPDLInterface(), aActor, this);
}

auto PBackgroundLSDatabaseChild::SendAllowToClose() -> bool
{
    UniquePtr<IPC::Message> msg__ = PBackgroundLSDatabase::Msg_AllowToClose(MSG_ROUTING_CONTROL);
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};





    if (mozilla::ipc::LoggingEnabledFor("PBackgroundLSDatabase", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PBackgroundLSDatabaseChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PBackgroundLSDatabase::Msg_AllowToClose", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PBackgroundLSDatabaseChild::SendPBackgroundLSSnapshotConstructor(
        const nsAString& documentURI,
        const nsAString& key,
        const bool& increasePeakUsage,
        const int64_t& minSize,
        LSSnapshotInitInfo* initInfo) -> PBackgroundLSSnapshotChild*
{
    PBackgroundLSSnapshotChild* actor = (this)->AllocPBackgroundLSSnapshotChild(documentURI, key, increasePeakUsage, minSize, initInfo);
    return SendPBackgroundLSSnapshotConstructor(std::move(actor), std::move(documentURI), std::move(key), std::move(increasePeakUsage), std::move(minSize), initInfo);
}

auto PBackgroundLSDatabaseChild::SendPBackgroundLSSnapshotConstructor(
        PBackgroundLSSnapshotChild* actor,
        const nsAString& documentURI,
        const nsAString& key,
        const bool& increasePeakUsage,
        const int64_t& minSize,
        LSSnapshotInitInfo* initInfo) -> PBackgroundLSSnapshotChild*
{
    if (!actor) {
        NS_WARNING("Cannot bind null PBackgroundLSSnapshotChild actor");
        return nullptr;
    }

    if (!actor->SetManagerAndRegister(this)) {
        NS_WARNING("Failed to bind PBackgroundLSSnapshotChild actor");
        return nullptr;
    }


    // Build our constructor message.
    UniquePtr<IPC::Message> msg__ = PBackgroundLSDatabase::Msg_PBackgroundLSSnapshotConstructor(MSG_ROUTING_CONTROL);
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), actor);
    // Sentinel = 'actor'
    ((&(writer__)))->WriteSentinel(102892058);
    IPC::WriteParam((&(writer__)), documentURI);
    // Sentinel = 'documentURI'
    ((&(writer__)))->WriteSentinel(453706832);
    IPC::WriteParam((&(writer__)), key);
    // Sentinel = 'key'
    ((&(writer__)))->WriteSentinel(42402122);
    IPC::WriteParam((&(writer__)), increasePeakUsage);
    // Sentinel = 'increasePeakUsage'
    ((&(writer__)))->WriteSentinel(1030686401);
    IPC::WriteParam((&(writer__)), minSize);
    // Sentinel = 'minSize'
    ((&(writer__)))->WriteSentinel(192807648);




    // Synchronously send the constructor message to the other side. If
    // the send fails, e.g. due to the remote side shutting down, the
    // actor will be destroyed and potentially freed.
    UniquePtr<Message> reply__;

    if (mozilla::ipc::LoggingEnabledFor("PBackgroundLSDatabase", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PBackgroundLSDatabaseChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PBackgroundLSDatabase::Msg_PBackgroundLSSnapshotConstructor", OTHER);

    bool sendok__ = false;
    {
        AUTO_PROFILER_TRACING_MARKER("Sync IPC", "PBackgroundLSDatabase::Msg_PBackgroundLSSnapshotConstructor", IPC);
        sendok__ = ChannelSend(std::move(msg__), (&(reply__)));
    }


    if (!(sendok__)) {
        // Warn, destroy the actor and return null if the message
        // failed to send.
        NS_WARNING("Error sending constructor");
        actor->ActorDisconnected(FailedConstructor);

        return nullptr;
    }


    if (mozilla::ipc::LoggingEnabledFor("PBackgroundLSDatabase", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PBackgroundLSDatabaseChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Received reply ",
            reply__->type(),
            mozilla::ipc::MessageDirection::eReceiving);
    }

    IPC::MessageReader reader__{
            (*(reply__)),
            this};

    auto maybe__initInfo__reply = IPC::ReadParam<LSSnapshotInitInfo>((&(reader__)));
    if (!maybe__initInfo__reply) {
        FatalError("Error deserializing 'LSSnapshotInitInfo'");
        return nullptr;

    }
    auto& initInfo__reply = *maybe__initInfo__reply;
    // Sentinel = 'initInfo'
    if ((!(((&(reader__)))->ReadSentinel(246743873)))) {
        mozilla::ipc::SentinelReadError("Error deserializing 'LSSnapshotInitInfo'");
        return nullptr;
    }
    (*(initInfo)) = std::move(initInfo__reply);
    reader__.EndRead();

    return actor;
}

auto PBackgroundLSDatabaseChild::DeallocManagee(
        int32_t aProtocolId,
        IProtocol* aListener) -> void
{
    switch (aProtocolId) {
    case PBackgroundLSSnapshotMsgStart:
        this->DeallocPBackgroundLSSnapshotChild(static_cast<PBackgroundLSSnapshotChild*>(aListener));
        return;
    default:
        FatalError("unreached");
        return;
    }
}

auto PBackgroundLSDatabaseChild::OnMessageReceived(const Message& msg__) -> PBackgroundLSDatabaseChild::Result
{
    int32_t route__ = msg__.routing_id();
    if (MSG_ROUTING_CONTROL != route__) {
        IProtocol* routed__ = Lookup(route__);
        if (!routed__ || !routed__->GetLifecycleProxy()) {
            if (mozilla::ipc::LoggingEnabledFor("PBackgroundLSDatabase", mozilla::ipc::ChildSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PBackgroundLSDatabaseChild",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Ignored message for dead actor",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eSending);
            }
            return MsgProcessed;

        }

        RefPtr<mozilla::ipc::ActorLifecycleProxy> proxy__ =
            routed__->GetLifecycleProxy();
        return proxy__->Get()->OnMessageReceived(msg__);
    }

    switch (msg__.type()) {
    case PBackgroundLSDatabase::Msg_RequestAllowToClose__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PBackgroundLSDatabase", mozilla::ipc::ChildSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PBackgroundLSDatabaseChild",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PBackgroundLSDatabase::Msg_RequestAllowToClose", OTHER);

            mozilla::ipc::IPCResult __ok = (this)->RecvRequestAllowToClose();
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    default:
        return MsgNotKnown;
    case SHMEM_CREATED_MESSAGE_TYPE:
        {
            if (!ShmemCreated(msg__)) {
                return MsgPayloadError;
            }
            return MsgProcessed;
        }
    case SHMEM_DESTROYED_MESSAGE_TYPE:
        {
            if (!ShmemDestroyed(msg__)) {
                return MsgPayloadError;
            }
            return MsgProcessed;
        }
    }
}

auto PBackgroundLSDatabaseChild::OnMessageReceived(
        const Message& msg__,
        UniquePtr<Message>& reply__) -> PBackgroundLSDatabaseChild::Result
{
    int32_t route__ = msg__.routing_id();
    if (MSG_ROUTING_CONTROL != route__) {
        IProtocol* routed__ = Lookup(route__);
        if (!routed__ || !routed__->GetLifecycleProxy()) {
            return MsgDropped;

        }

        RefPtr<mozilla::ipc::ActorLifecycleProxy> proxy__ =
            routed__->GetLifecycleProxy();
        return proxy__->Get()->OnMessageReceived(msg__, reply__);
    }

    return MsgNotKnown;
}



} // namespace dom
} // namespace mozilla
namespace IPC {
auto ParamTraits<::mozilla::dom::PBackgroundLSDatabaseChild*>::Write(
        IPC::MessageWriter* aWriter,
        const paramType& aVar) -> void
{
    MOZ_RELEASE_ASSERT(
        aWriter->GetActor(),
        "Cannot serialize managed actors without an actor");

    int32_t id;
    if (!aVar) {
        id = 0;  // kNullActorId
    } else {
        id = aVar->Id();
        if (id == 1) {  // kFreedActorId
            aVar->FatalError("Actor has been |delete|d");
        }
        MOZ_RELEASE_ASSERT(
            aWriter->GetActor()->GetIPCChannel() == aVar->GetIPCChannel(),
            "Actor must be from the same channel as the"
            " actor it's being sent over");
        MOZ_RELEASE_ASSERT(
            aVar->CanSend(),
            "Actor must still be open when sending");
    }

    IPC::WriteParam(aWriter, id);
}

auto ParamTraits<::mozilla::dom::PBackgroundLSDatabaseChild*>::Read(IPC::MessageReader* aReader) -> IPC::ReadResult<paramType>
{
    MOZ_RELEASE_ASSERT(
        aReader->GetActor(),
        "Cannot deserialize managed actors without an actor");
    mozilla::Maybe<mozilla::ipc::IProtocol*> actor = aReader->GetActor()
        ->ReadActor(aReader, true, "PBackgroundLSDatabase", PBackgroundLSDatabaseMsgStart);
    if (actor.isSome()) {
        return static_cast<::mozilla::dom::PBackgroundLSDatabaseChild*>(actor.ref());
    }
    return {};
}

} // namespace IPC
