//
// Automatically generated by ipdlc.
// Edit at your own risk
//


#include "mozilla/dom/indexedDB/PBackgroundIndexedDBUtilsParent.h"
#include "mozilla/ProfilerLabels.h"
#include "mozilla/dom/indexedDB/ActorsChild.h"
#include "mozilla/dom/quota/SerializationHelpers.h"

#include "mozilla/ipc/PBackgroundParent.h"

#include "ipc/IPCMessageUtils.h"
#include "ipc/IPCMessageUtilsSpecializations.h"
#include "nsIFile.h"
#include "mozilla/ipc/Endpoint.h"
#include "mozilla/ipc/ProtocolMessageUtils.h"
#include "mozilla/ipc/ProtocolUtils.h"
#include "mozilla/ipc/ShmemMessageUtils.h"
#include "mozilla/ipc/TaintingIPCUtils.h"

namespace mozilla {
namespace dom {
namespace indexedDB {


MOZ_IMPLICIT PBackgroundIndexedDBUtilsParent::PBackgroundIndexedDBUtilsParent() :
    mozilla::ipc::IProtocol(kProtocolId, mozilla::ipc::ParentSide)
{
    MOZ_COUNT_CTOR(PBackgroundIndexedDBUtilsParent);
}

PBackgroundIndexedDBUtilsParent::~PBackgroundIndexedDBUtilsParent()
{
    MOZ_COUNT_DTOR(PBackgroundIndexedDBUtilsParent);
}

auto PBackgroundIndexedDBUtilsParent::ActorAlloc() -> void
{
}

auto PBackgroundIndexedDBUtilsParent::ActorDealloc() -> void
{
    if (Manager()) {
        Manager()->DeallocManagee(kProtocolId, this);
    }
}

auto PBackgroundIndexedDBUtilsParent::OtherPid() const -> ::base::ProcessId
{
    ::base::ProcessId pid =
        ::mozilla::ipc::IProtocol::ToplevelProtocol()->OtherPidMaybeInvalid();
    MOZ_RELEASE_ASSERT(pid != ::base::kInvalidProcessId);
    return pid;
}

auto PBackgroundIndexedDBUtilsParent::OtherChildID() const -> ::GeckoChildID
{
    ::GeckoChildID childID =
        ::mozilla::ipc::IProtocol::ToplevelProtocol()->OtherChildIDMaybeInvalid();
    MOZ_RELEASE_ASSERT(childID != -1);
    return childID;
}

auto PBackgroundIndexedDBUtilsParent::OtherEndpointProcInfo() const -> ::mozilla::ipc::EndpointProcInfo
{
    return ::mozilla::ipc::EndpointProcInfo{OtherPid(), OtherChildID()};
}

auto PBackgroundIndexedDBUtilsParent::Manager() const -> PBackgroundParent*
{
    return static_cast<PBackgroundParent*>(IProtocol::Manager());
}

auto PBackgroundIndexedDBUtilsParent::ManagedProtocolIds() const -> mozilla::Span<mozilla::ipc::ProtocolId const>
{
    return {};
}

auto PBackgroundIndexedDBUtilsParent::GetManagedActors(mozilla::ipc::ProtocolId aProtocol) -> UntypedManagedContainer*
{
    switch (aProtocol) {
    default:
        return nullptr;
    }
}

auto PBackgroundIndexedDBUtilsParent::RejectPendingResponses(ResponseRejectReason aReason) -> void
{
    mAsyncCallbacks.RejectPendingResponses(aReason);
}

auto PBackgroundIndexedDBUtilsParent::Send__delete__(PBackgroundIndexedDBUtilsParent* actor) -> bool
{
    if (!actor || !actor->CanSend()) {
        NS_WARNING("Attempt to __delete__ missing or closed actor");
        return false;
    }
    UniquePtr<IPC::Message> msg__ = PBackgroundIndexedDBUtils::Msg___delete__((actor)->Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            actor};




    if (mozilla::ipc::LoggingEnabledFor("PBackgroundIndexedDBUtils", mozilla::ipc::ParentSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PBackgroundIndexedDBUtilsParent",
            actor->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PBackgroundIndexedDBUtils::Msg___delete__", OTHER);

    bool sendok__ = (actor)->ChannelSend(std::move(msg__));

    actor->ActorDisconnected(Deletion);
    return sendok__;
}

auto PBackgroundIndexedDBUtilsParent::DeallocManagee(
        int32_t aProtocolId,
        IProtocol* aListener) -> void
{
    FatalError("unreached");
    return;
}

auto PBackgroundIndexedDBUtilsParent::OnMessageReceived(const Message& msg__) -> PBackgroundIndexedDBUtilsParent::Result
{
    switch (msg__.type()) {
    case MANAGED_ENDPOINT_BOUND_MESSAGE_TYPE:
        {
            if (!mAwaitingManagedEndpointBind) {
                NS_WARNING("Unexpected managed endpoint lifecycle message after actor bound!");
                return MsgNotAllowed;
            }
            mAwaitingManagedEndpointBind = false;
            return MsgProcessed;
        }
    case MANAGED_ENDPOINT_DROPPED_MESSAGE_TYPE:
        {
            if (!mAwaitingManagedEndpointBind) {
                NS_WARNING("Unexpected managed endpoint lifecycle message after actor bound!");
                return MsgNotAllowed;
            }
            mAwaitingManagedEndpointBind = false;
            this->ActorDisconnected(ManagedEndpointDropped);
            return MsgProcessed;
        }
    case PBackgroundIndexedDBUtils::Msg_DeleteMe__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PBackgroundIndexedDBUtils", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PBackgroundIndexedDBUtilsParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PBackgroundIndexedDBUtils::Msg_DeleteMe", OTHER);

            mozilla::ipc::IPCResult __ok = (this)->RecvDeleteMe();
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PBackgroundIndexedDBUtils::Msg_DoMaintenance__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PBackgroundIndexedDBUtils", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PBackgroundIndexedDBUtilsParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PBackgroundIndexedDBUtils::Msg_DoMaintenance", OTHER);

            int32_t id__ = Id();
            UniquePtr<IPC::Message> reply__(PBackgroundIndexedDBUtils::Reply_DoMaintenance(id__));
            reply__->set_seqno(msg__.seqno());

            RefPtr<mozilla::ipc::IPDLResolverInner> resolver__ =
                new mozilla::ipc::IPDLResolverInner(std::move(reply__), this);

            DoMaintenanceResolver resolver = [resolver__ = std::move(resolver__)](const nsresult& aParam) {
                resolver__->Resolve([&] (IPC::Message* reply__, IProtocol* self__) {
                    IPC::MessageWriter writer__(*reply__, self__);
                    IPC::WriteParam((&(writer__)), aParam);
                    // Sentinel = 'rv'
                    ((&(writer__)))->WriteSentinel(22806761);

                    if (mozilla::ipc::LoggingEnabledFor("PBackgroundIndexedDBUtils", mozilla::ipc::ParentSide)) {
                        mozilla::ipc::LogMessageForProtocol(
                            "PBackgroundIndexedDBUtilsParent",
                            self__->ToplevelProtocol()->OtherPidMaybeInvalid(),
                            "Sending reply ",
                            reply__->type(),
                            mozilla::ipc::MessageDirection::eSending);
                    }

                });
            };
            mozilla::ipc::IPCResult __ok = (this)->RecvDoMaintenance(std::move(resolver));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PBackgroundIndexedDBUtils::Reply___delete____ID:
        {
            return MsgProcessed;
        }
    default:
        return MsgNotKnown;
    }
}

auto PBackgroundIndexedDBUtilsParent::OnMessageReceived(
        const Message& msg__,
        UniquePtr<Message>& reply__) -> PBackgroundIndexedDBUtilsParent::Result
{
    switch (msg__.type()) {
    case PBackgroundIndexedDBUtils::Msg_GetFileReferences__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PBackgroundIndexedDBUtils", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PBackgroundIndexedDBUtilsParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PBackgroundIndexedDBUtils::Msg_GetFileReferences", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__persistenceType = IPC::ReadParam<PersistenceType>((&(reader__)));
            if (!maybe__persistenceType) {
                FatalError("Error deserializing 'PersistenceType'");
                return MsgValueError;

            }
            auto& persistenceType = *maybe__persistenceType;
            // Sentinel = 'persistenceType'
            if ((!(((&(reader__)))->ReadSentinel(853345864)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'PersistenceType'");
                return MsgValueError;
            }
            auto maybe__origin = IPC::ReadParam<nsCString>((&(reader__)));
            if (!maybe__origin) {
                FatalError("Error deserializing 'nsCString'");
                return MsgValueError;

            }
            auto& origin = *maybe__origin;
            // Sentinel = 'origin'
            if ((!(((&(reader__)))->ReadSentinel(150143625)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'nsCString'");
                return MsgValueError;
            }
            auto maybe__databaseName = IPC::ReadParam<nsString>((&(reader__)));
            if (!maybe__databaseName) {
                FatalError("Error deserializing 'nsString'");
                return MsgValueError;

            }
            auto& databaseName = *maybe__databaseName;
            // Sentinel = 'databaseName'
            if ((!(((&(reader__)))->ReadSentinel(517211319)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'nsString'");
                return MsgValueError;
            }
            auto maybe__fileId = IPC::ReadParam<int64_t>((&(reader__)));
            if (!maybe__fileId) {
                FatalError("Error deserializing 'int64_t'");
                return MsgValueError;

            }
            auto& fileId = *maybe__fileId;
            // Sentinel = 'fileId'
            if ((!(((&(reader__)))->ReadSentinel(139199054)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'int64_t'");
                return MsgValueError;
            }
            reader__.EndRead();
            int32_t id__ = Id();
            int32_t refCnt{};
            int32_t dBRefCnt{};
            bool result{};
            mozilla::ipc::IPCResult __ok = (this)->RecvGetFileReferences(std::move(persistenceType), std::move(origin), std::move(databaseName), std::move(fileId), (&(refCnt)), (&(dBRefCnt)), (&(result)));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            reply__ = PBackgroundIndexedDBUtils::Reply_GetFileReferences(id__);
            IPC::MessageWriter writer__{
                    (*(reply__)),
                    this};

            IPC::WriteParam((&(writer__)), refCnt);
            // Sentinel = 'refCnt'
            ((&(writer__)))->WriteSentinel(140247651);
            IPC::WriteParam((&(writer__)), dBRefCnt);
            // Sentinel = 'dBRefCnt'
            ((&(writer__)))->WriteSentinel(210502377);
            IPC::WriteParam((&(writer__)), result);
            // Sentinel = 'result'
            ((&(writer__)))->WriteSentinel(153223840);

            if (mozilla::ipc::LoggingEnabledFor("PBackgroundIndexedDBUtils", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PBackgroundIndexedDBUtilsParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Sending reply ",
                    reply__->type(),
                    mozilla::ipc::MessageDirection::eSending);
            }
            return MsgProcessed;
        }
    default:
        return MsgNotKnown;
    }
}



} // namespace indexedDB
} // namespace dom
} // namespace mozilla
namespace IPC {
auto ParamTraits<::mozilla::dom::indexedDB::PBackgroundIndexedDBUtilsParent*>::Write(
        IPC::MessageWriter* aWriter,
        const paramType& aVar) -> void
{
    MOZ_RELEASE_ASSERT(
        aWriter->GetActor(),
        "Cannot serialize managed actors without an actor");

    int32_t id;
    if (!aVar) {
        id = 0;  // kNullActorId
    } else {
        id = aVar->Id();
        if (id == 1) {  // kFreedActorId
            aVar->FatalError("Actor has been |delete|d");
        }
        MOZ_RELEASE_ASSERT(
            aWriter->GetActor()->GetIPCChannel() == aVar->GetIPCChannel(),
            "Actor must be from the same channel as the"
            " actor it's being sent over");
        MOZ_RELEASE_ASSERT(
            aVar->CanSend(),
            "Actor must still be open when sending");
    }

    IPC::WriteParam(aWriter, id);
}

auto ParamTraits<::mozilla::dom::indexedDB::PBackgroundIndexedDBUtilsParent*>::Read(IPC::MessageReader* aReader) -> IPC::ReadResult<paramType>
{
    MOZ_RELEASE_ASSERT(
        aReader->GetActor(),
        "Cannot deserialize managed actors without an actor");
    mozilla::Maybe<mozilla::ipc::IProtocol*> actor = aReader->GetActor()
        ->ReadActor(aReader, true, "PBackgroundIndexedDBUtils", PBackgroundIndexedDBUtilsMsgStart);
    if (actor.isSome()) {
        return static_cast<::mozilla::dom::indexedDB::PBackgroundIndexedDBUtilsParent*>(actor.ref());
    }
    return {};
}

} // namespace IPC
